/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.sgt.dm.SimpleGrid;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.tsunami.cmi.GeoGrid2D;
import gov.noaa.tsunami.cmi.SiftShare;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class MOSTGrid
extends GeoGrid2D
implements Cloneable {
    private double[] time;
    private int skipX = 1;
    private int skipY = 1;
    private NetcdfFile nc;
    private int[] origin = new int[0];
    private int[] shape = new int[0];
    private boolean isDataValid;
    private double missing_value = -1.0E33;
    private String varName = "ha";

    public MOSTGrid(String fileName) {
        this(fileName, "ha");
    }

    public MOSTGrid(String fileName, String varName) {
        this.fileName = fileName;
        this.varName = varName;
    }

    public boolean setVarName(String vn) {
        if (!(vn.equals("ha") || vn.equals("ua") || vn.equals("va"))) {
            return false;
        }
        this.varName = vn;
        return true;
    }

    public boolean readData(int timeStep) {
        this.isDataValid = false;
        this.close();
        try {
            Variable v;
            this.nc = NetcdfFile.open(this.fileName);
            Variable ha = this.nc.findVariable(this.varName.toUpperCase(Locale.ENGLISH));
            if (ha == null) {
                ha = this.nc.findVariable(this.varName.toLowerCase(Locale.ENGLISH));
            }
            this.shape = ha.getShape();
            this.origin = new int[ha.getRank()];
            this.nLon = this.shape[2];
            this.nLat = this.shape[1];
            this.grid = new double[this.nLon * this.nLat];
            Attribute attMissing = ha.findAttribute("missing_value");
            if (attMissing != null) {
                this.missing_value = attMissing.getNumericValue().floatValue();
            }
            if ((v = this.nc.findVariable("LON")) == null) {
                v = this.nc.findVariable("lon");
            }
            this.lons = (double[])v.read().copyTo1DJavaArray();
            v = this.nc.findVariable("LAT");
            if (v == null) {
                v = this.nc.findVariable("lat");
            }
            this.lats = (double[])v.read().copyTo1DJavaArray();
            v = this.nc.findVariable("TIME");
            if (v == null) {
                v = this.nc.findVariable("time");
            }
            Array tarr = v.read();
            this.time = new double[(int)tarr.getSize()];
            for (int i = 0; i < this.time.length; ++i) {
                this.time[i] = tarr.getDouble(i);
            }
            if (Math.abs(this.lons[0]) > 1.0E30 || Math.abs(this.lats[0]) > 1.0E30) {
                throw new IOException();
            }
            this.xRange_ = GeoGrid2D.getRange(this.lons);
            this.yRange_ = GeoGrid2D.getRange(this.lats);
            this.zMetaData_ = new SGTMetaData("Wave Amplitude", "centimeters");
            this.zRange_ = new Range2D(-100.0, 100.0);
            this.flipLat();
            this.normalizeLons();
            this.loadTimeStep(timeStep);
            this.isDataValid = true;
        }
        catch (IOException ignore) {
            this.isDataValid = false;
            this.nLon = 2;
            this.nLat = 2;
            this.lons = new double[]{0.0, 1.0};
            this.lats = new double[]{0.0, 1.0};
            this.time = new double[]{0.0, 1.0};
            this.grid = new double[]{0.0, 0.0, 0.0, 0.0};
        }
        SiftShare.log.log(Level.INFO, "Loaded MOST file: {0}\nnLon: {1} nLat: {2}\nxrange: {3} yrange:{4}", new Object[]{this.fileName, this.nLon, this.nLat, this.xRange_, this.yRange_});
        return this.isDataValid;
    }

    public int getNumberOfTimeSteps() {
        return this.isDataValid ? this.time.length : 0;
    }

    public double getTime(int t) {
        double result = -1.0;
        if (this.time == null) {
            return result;
        }
        if (t >= 0 && t < this.time.length) {
            result = this.time[t];
        }
        return result;
    }

    @Override
    public void clearData() {
        for (int j = 0; j < this.nLon; ++j) {
            for (int i = 0; i < this.nLat; ++i) {
                this.grid[j * this.nLat + i] = Double.NaN;
            }
        }
    }

    public void updateTimeAxis() {
        if (this.nc == null && !this.readData(0)) {
            return;
        }
        try {
            this.nc.close();
            this.nc = NetcdfFile.open(this.fileName);
            this.time = (double[])this.findVariable("TIME").read().copyTo1DJavaArray();
        }
        catch (IOException ex) {
            this.time = new double[]{0.0, 1.0};
        }
    }

    private Variable findVariable(String varname) {
        Variable v = this.nc.findVariable(varname);
        if (v == null) {
            v = this.nc.findVariable(varname.toLowerCase());
        }
        return v;
    }

    public void loadTimeStep(int step) throws IOException {
        if (step < 0 || step >= this.time.length) {
            return;
        }
        if (this.origin.length == 0 || this.shape.length == 0) {
            this.readData(step);
            return;
        }
        this.shape[0] = 1;
        this.origin[0] = step;
        try {
            Variable v = this.nc.findVariable(this.varName.toUpperCase(Locale.ENGLISH));
            if (v == null) {
                v = this.nc.findVariable(this.varName.toLowerCase(Locale.ENGLISH));
            }
            ArrayFloat.D2 a = (ArrayFloat.D2)v.read(this.origin, this.shape).reduce();
            if (this.flipLat) {
                a = (ArrayFloat.D2)a.flip(0);
            }
            int count = 0;
            for (int j = 0; j < this.nLon; ++j) {
                for (int i = 0; i < this.nLat; ++i) {
                    if (j % this.skipX != 0 || i % this.skipY != 0) continue;
                    double holder = a.get(i, j);
                    this.grid[count] = holder > this.missing_value ? holder : Double.NaN;
                    ++count;
                }
            }
            this.changes_.firePropertyChange("dataModified", 0, this.grid.length);
        }
        catch (InvalidRangeException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void subsampleToMaxSize(int maxDimension) {
        this.skipX = 1;
        this.skipY = 1;
        while (this.nLon / this.skipX > maxDimension) {
            ++this.skipX;
        }
        while (this.nLat / this.skipY > maxDimension) {
            ++this.skipY;
        }
        if (this.skipX == 1 && this.skipY == 1) {
            return;
        }
        int numX = (this.nLon - 1) / this.skipX + 1;
        int numY = (this.nLat - 1) / this.skipY + 1;
        double[] newdeps = new double[numX * numY];
        int count = 0;
        for (int i = 0; i < this.nLon; ++i) {
            for (int j = 0; j < this.nLat; ++j) {
                if (i % this.skipX != 0 || j % this.skipY != 0) continue;
                newdeps[count] = this.grid[this.nLat * i + j];
                ++count;
            }
        }
        double[] newlons = new double[numX];
        count = 0;
        for (int i = 0; i < this.nLon; i += this.skipX) {
            newlons[count] = this.lons[i];
            ++count;
        }
        double[] newlats = new double[numY];
        count = 0;
        for (int i = 0; i < this.nLat; i += this.skipY) {
            newlats[count] = this.lats[i];
            ++count;
        }
        this.grid = newdeps;
        this.lons = newlons;
        this.lats = newlats;
    }

    public void close() {
        try {
            if (this.nc != null) {
                this.nc.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.nc = null;
        }
    }

    @Override
    public SGTData copy() {
        SGTGrid newGrid;
        try {
            newGrid = (SGTGrid)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newGrid = new SimpleGrid();
        }
        return newGrid;
    }
}

