/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.SiteInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;

public class MOSTInputPanel
extends JPanel
implements PropertyChangeListener {
    private static Icon warningIcon = null;
    private static final NumberFormat dfxxxx = new DecimalFormat("0.0000");
    private static final NumberFormat dfx = new DecimalFormat("0.0");
    private static final NumberFormat dfxx = new DecimalFormat("0.00");
    private static final NumberFormat intformat = NumberFormat.getIntegerInstance();
    private SiteInfo site = null;
    private static final Color ERROR_COLOR = Color.RED;
    private JPopupMenu contextMenu;
    private JLabel dryLandDepthLabel;
    private JFormattedTextField dryLandDepthTF;
    private JLabel frictionLabel;
    private JFormattedTextField frictionTF;
    private JLabel maxEtaLabel;
    private JFormattedTextField maxEtaTF;
    private JLabel minimumAmplitudeLabel;
    private JFormattedTextField minimumAmplitudeTF;
    private JLabel minimumDepthLabel;
    private JFormattedTextField minimumDepthTF;
    private JLabel numberStrideLabel;
    private JFormattedTextField numberStrideTF;
    private JLabel numberTimeStepsAGridLabel;
    private JFormattedTextField numberTimeStepsAGridTF;
    private JLabel numberTimeStepsBGridLabel;
    private JFormattedTextField numberTimeStepsBGridTF;
    private JLabel numberTimeStepsSavingLabel;
    private JFormattedTextField numberTimeStepsSavingTF;
    private JLabel numberTimeStepsStartLabel;
    private JFormattedTextField numberTimeStepsStartTF;
    private JCheckBox runupCheckBox;
    private final JLabel timeStepLabel = new JLabel();
    private final JFormattedTextField timeStepTF = new JFormattedTextField(dfxxxx);
    private JLabel totalNumberTimeStepLabel;
    private JFormattedTextField totalNumberTimeStepTF;

    public MOSTInputPanel() {
        intformat.setGroupingUsed(false);
        this.initComponents();
    }

    public void setCurrentSite(SiteInfo site) {
        this.site = site;
        if (site != null) {
            this.setFieldsEnabled(true);
            this.dryLandDepthTF.setValue(site.getDryLandDepth());
            this.frictionTF.setValue(site.getFriction());
            this.maxEtaTF.setValue(site.getMaxEta());
            this.minimumAmplitudeTF.setValue(site.getMinimumAmplitude());
            this.minimumDepthTF.setValue(site.getMinimumDepth());
            this.numberStrideTF.setValue(site.getNumberStride());
            this.numberTimeStepsAGridTF.setValue(site.getNumberTimeStepsAGrid());
            this.numberTimeStepsBGridTF.setValue(site.getNumberTimeStepsBGrid());
            this.numberTimeStepsSavingTF.setValue(site.getNumberTimeStepsBetweenOutput());
            this.numberTimeStepsStartTF.setValue(site.getNumberTimeStepsStart());
            this.runupCheckBox.setSelected(site.isAllowRunup());
            this.timeStepTF.setValue(site.getTimeStep());
            this.totalNumberTimeStepTF.setValue(site.getTotalNumberTimeStep());
        } else {
            this.setFieldsEnabled(false);
        }
        this.validateAllFields();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("currentSite".equals(evt.getPropertyName())) {
            this.setCurrentSite((SiteInfo)evt.getNewValue());
        }
    }

    private void initComponents() {
        this.contextMenu = new JPopupMenu();
        JMenuItem resetDefaultsMenuItem = new JMenuItem();
        this.minimumAmplitudeTF = new JFormattedTextField(dfxxxx);
        this.minimumAmplitudeLabel = new JLabel();
        this.minimumDepthTF = new JFormattedTextField(dfx);
        this.minimumDepthLabel = new JLabel();
        this.dryLandDepthTF = new JFormattedTextField(dfx);
        this.dryLandDepthLabel = new JLabel();
        this.frictionTF = new JFormattedTextField(dfxxxx);
        this.frictionLabel = new JLabel();
        this.runupCheckBox = new JCheckBox();
        JLabel runupLabel = new JLabel();
        this.maxEtaTF = new JFormattedTextField(dfx);
        this.maxEtaLabel = new JLabel();
        this.totalNumberTimeStepTF = new JFormattedTextField(intformat);
        this.totalNumberTimeStepLabel = new JLabel();
        this.numberTimeStepsAGridTF = new JFormattedTextField(intformat);
        this.numberTimeStepsAGridLabel = new JLabel();
        this.numberTimeStepsBGridTF = new JFormattedTextField(intformat);
        this.numberTimeStepsBGridLabel = new JLabel();
        this.numberTimeStepsSavingTF = new JFormattedTextField(intformat);
        this.numberTimeStepsSavingLabel = new JLabel();
        this.numberTimeStepsStartTF = new JFormattedTextField(intformat);
        this.numberTimeStepsStartLabel = new JLabel();
        this.numberStrideTF = new JFormattedTextField(intformat);
        this.numberStrideLabel = new JLabel();
        resetDefaultsMenuItem.setText("Reset to defaults");
        resetDefaultsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MOSTInputPanel.this.resetDefaultsMenuItemActionPerformed(evt);
            }
        });
        this.contextMenu.add(resetDefaultsMenuItem);
        this.setBackground(Color.white);
        this.setMinimumSize(new Dimension(378, 439));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MOSTInputPanel.this.contextMenuHandler(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                MOSTInputPanel.this.contextMenuHandler(evt);
            }
        });
        this.minimumAmplitudeTF.setColumns(6);
        this.minimumAmplitudeTF.setText("0.005");
        this.minimumAmplitudeTF.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MOSTInputPanel.this.minimumAmplitudeTFPropertyChange(evt);
            }
        });
        this.minimumAmplitudeLabel.setText("Minimum amp. of input offshore wave (m)");
        this.minimumDepthTF.setColumns(6);
        this.minimumDepthTF.setText("5.0");
        this.minimumDepthTF.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MOSTInputPanel.this.minimumDepthTFPropertyChange(evt);
            }
        });
        this.minimumDepthLabel.setText("Minimum depth of offshore (m)");
        this.dryLandDepthTF.setColumns(6);
        this.dryLandDepthTF.setText("0.1");
        this.dryLandDepthTF.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MOSTInputPanel.this.dryLandDepthTFPropertyChange(evt);
            }
        });
        this.dryLandDepthLabel.setText("Dry land depth of inundation (m)");
        this.frictionTF.setColumns(6);
        this.frictionTF.setText("0.0009");
        this.frictionTF.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MOSTInputPanel.this.frictionTFPropertyChange(evt);
            }
        });
        this.frictionLabel.setText("<html>Friction coefficient (n<small><sup>2</sup></small>)</html>");
        this.runupCheckBox.setBackground(Color.white);
        this.runupCheckBox.setSelected(true);
        this.runupCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.runupCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MOSTInputPanel.this.runupCheckBoxActionPerformed(evt);
            }
        });
        runupLabel.setText("Let A-Grid and B-Grid run up");
        this.maxEtaTF.setColumns(6);
        this.maxEtaTF.setText("90.0");
        this.maxEtaTF.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MOSTInputPanel.this.maxEtaTFPropertyChange(evt);
            }
        });
        this.maxEtaLabel.setText("Max eta before blow-up (m)");
        this.timeStepTF.setColumns(6);
        this.timeStepTF.setText("3.0000");
        this.timeStepTF.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MOSTInputPanel.this.timeStepTFPropertyChange(evt);
            }
        });
        this.timeStepLabel.setText("Time step (sec)");
        this.timeStepLabel.setToolTipText("Time step on innermost grid");
        this.totalNumberTimeStepTF.setColumns(6);
        this.totalNumberTimeStepTF.setText("6000");
        this.totalNumberTimeStepTF.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MOSTInputPanel.this.totalNumberTimeStepTFPropertyChange(evt);
            }
        });
        this.totalNumberTimeStepLabel.setText("Total number of time steps in run");
        this.numberTimeStepsAGridTF.setColumns(6);
        this.numberTimeStepsAGridTF.setText("1");
        this.numberTimeStepsAGridTF.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MOSTInputPanel.this.numberTimeStepsAGridTFPropertyChange(evt);
            }
        });
        this.numberTimeStepsAGridLabel.setText("Time steps between A-Grid computations");
        this.numberTimeStepsBGridTF.setColumns(6);
        this.numberTimeStepsBGridTF.setText("1");
        this.numberTimeStepsBGridTF.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MOSTInputPanel.this.numberTimeStepsBGridTFPropertyChange(evt);
            }
        });
        this.numberTimeStepsBGridLabel.setText("Time steps between B-Grid computations");
        this.numberTimeStepsSavingTF.setColumns(6);
        this.numberTimeStepsSavingTF.setText("30");
        this.numberTimeStepsSavingTF.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MOSTInputPanel.this.numberTimeStepsSavingTFPropertyChange(evt);
            }
        });
        this.numberTimeStepsSavingLabel.setText("Time steps between output steps");
        this.numberTimeStepsStartTF.setColumns(6);
        this.numberTimeStepsStartTF.setText("0");
        this.numberTimeStepsStartTF.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MOSTInputPanel.this.numberTimeStepsStartTFPropertyChange(evt);
            }
        });
        this.numberTimeStepsStartLabel.setText("Time steps before saving first output step");
        this.numberStrideTF.setColumns(6);
        this.numberStrideTF.setText("1");
        this.numberStrideTF.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MOSTInputPanel.this.numberStrideTFPropertyChange(evt);
            }
        });
        this.numberStrideLabel.setText("Save output every n-th grid point");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(2, false).add(1, this.minimumDepthTF).add(1, this.frictionTF).add(this.runupCheckBox).add(1, this.dryLandDepthTF).add(1, this.minimumAmplitudeTF, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(2).add(1, runupLabel, -1, -1, Short.MAX_VALUE).add(1, this.minimumDepthLabel, -1, -1, Short.MAX_VALUE).add(1, this.dryLandDepthLabel, -1, -1, Short.MAX_VALUE).add(1, this.frictionLabel).add(this.minimumAmplitudeLabel, -1, -1, Short.MAX_VALUE))).add(layout.createSequentialGroup().add(layout.createParallelGroup(2).add(this.maxEtaTF, -2, -1, -2).add(this.timeStepTF, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(2).add(1, this.maxEtaLabel, -1, -1, Short.MAX_VALUE).add(1, this.timeStepLabel, -1, -1, Short.MAX_VALUE))).add(layout.createSequentialGroup().add(this.totalNumberTimeStepTF, -2, -1, -2).addPreferredGap(0).add(this.totalNumberTimeStepLabel, -1, -1, Short.MAX_VALUE)).add(layout.createSequentialGroup().add(layout.createParallelGroup(2).add(this.numberTimeStepsStartTF, -2, -1, -2).add(this.numberTimeStepsAGridTF, -2, -1, -2).add(this.numberTimeStepsSavingTF, -2, -1, -2).add(this.numberTimeStepsBGridTF, -2, -1, -2).add(this.numberStrideTF, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(2).add(1, this.numberTimeStepsSavingLabel, -1, -1, Short.MAX_VALUE).add(1, this.numberTimeStepsBGridLabel, -1, -1, Short.MAX_VALUE).add(1, this.numberTimeStepsAGridLabel, -1, -1, Short.MAX_VALUE).add(1, this.numberStrideLabel, -1, -1, Short.MAX_VALUE).add(1, this.numberTimeStepsStartLabel, -1, -1, Short.MAX_VALUE)))).addContainerGap(25, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.dryLandDepthLabel, this.frictionLabel, this.maxEtaLabel, this.minimumAmplitudeLabel, this.minimumDepthLabel, this.numberStrideLabel, this.numberTimeStepsAGridLabel, this.numberTimeStepsBGridLabel, this.numberTimeStepsSavingLabel, this.numberTimeStepsStartLabel, runupLabel, this.timeStepLabel, this.totalNumberTimeStepLabel}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(3).add(this.minimumAmplitudeTF, -2, -1, -2).add(this.minimumAmplitudeLabel, -2, 20, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.minimumDepthLabel, -2, 20, -2).add(this.minimumDepthTF, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.dryLandDepthTF, -2, -1, -2).add(this.dryLandDepthLabel, -2, 20, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.frictionTF, -2, -1, -2).add(this.frictionLabel, -2, 20, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.runupCheckBox, -2, 17, -2).add(runupLabel)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.maxEtaTF, -2, -1, -2).add(this.maxEtaLabel, -2, 19, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.timeStepTF, -2, -1, -2).add(this.timeStepLabel, -2, 19, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.totalNumberTimeStepTF, -2, -1, -2).add(this.totalNumberTimeStepLabel, -2, 19, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.numberTimeStepsAGridTF, -2, -1, -2).add(this.numberTimeStepsAGridLabel, -2, 19, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.numberTimeStepsBGridTF, -2, -1, -2).add(this.numberTimeStepsBGridLabel, -2, 19, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.numberTimeStepsSavingTF, -2, -1, -2).add(this.numberTimeStepsSavingLabel, -2, 19, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.numberTimeStepsStartTF, -2, -1, -2).add(this.numberTimeStepsStartLabel, -2, 19, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.numberStrideLabel, -2, 19, -2).add(this.numberStrideTF, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.dryLandDepthLabel, this.frictionLabel, this.maxEtaLabel, this.minimumAmplitudeLabel, this.minimumDepthLabel, this.numberStrideLabel, this.numberTimeStepsAGridLabel, this.numberTimeStepsBGridLabel, this.numberTimeStepsSavingLabel, this.numberTimeStepsStartLabel, runupLabel, this.timeStepLabel, this.totalNumberTimeStepLabel}, 2);
    }

    private boolean doParameterChange(PropertyChangeEvent evt) {
        return this.site != null && "value".equals(evt.getPropertyName()) && evt.getNewValue() != null;
    }

    private void runupCheckBoxActionPerformed(ActionEvent evt) {
        this.site.setAllowRunup(this.runupCheckBox.isSelected());
    }

    private void minimumAmplitudeTFPropertyChange(PropertyChangeEvent evt) {
        if (this.doParameterChange(evt)) {
            this.site.setMinimumAmplitude(((Number)this.minimumAmplitudeTF.getValue()).doubleValue());
        }
    }

    private void minimumDepthTFPropertyChange(PropertyChangeEvent evt) {
        if (this.doParameterChange(evt)) {
            this.site.setMinimumDepth(((Number)this.minimumDepthTF.getValue()).doubleValue());
        }
    }

    private void dryLandDepthTFPropertyChange(PropertyChangeEvent evt) {
        if (this.doParameterChange(evt)) {
            this.site.setDryLandDepth(((Number)this.dryLandDepthTF.getValue()).doubleValue());
        }
    }

    private void frictionTFPropertyChange(PropertyChangeEvent evt) {
        if (this.doParameterChange(evt)) {
            this.site.setFriction(((Number)this.frictionTF.getValue()).doubleValue());
        }
    }

    private void maxEtaTFPropertyChange(PropertyChangeEvent evt) {
        if (this.doParameterChange(evt)) {
            this.site.setMaxEta(((Number)this.maxEtaTF.getValue()).doubleValue());
        }
    }

    private void timeStepTFPropertyChange(PropertyChangeEvent evt) {
        if (this.doParameterChange(evt)) {
            this.site.setTimeStep(((Number)this.timeStepTF.getValue()).doubleValue());
            this.validateAllFields();
        }
    }

    private void numberTimeStepsAGridTFPropertyChange(PropertyChangeEvent evt) {
        if (this.doParameterChange(evt)) {
            this.site.setNumberTimeStepsAGrid(((Number)this.numberTimeStepsAGridTF.getValue()).intValue());
            this.validateAllFields();
        }
    }

    private void numberTimeStepsBGridTFPropertyChange(PropertyChangeEvent evt) {
        if (this.doParameterChange(evt)) {
            this.site.setNumberTimeStepsBGrid(((Number)this.numberTimeStepsBGridTF.getValue()).intValue());
            this.validateAllFields();
        }
    }

    private void numberTimeStepsSavingTFPropertyChange(PropertyChangeEvent evt) {
        if (this.doParameterChange(evt)) {
            this.site.setNumberTimeStepsBetweenOutput(((Number)this.numberTimeStepsSavingTF.getValue()).intValue());
            this.validateAllFields();
        }
    }

    private void numberTimeStepsStartTFPropertyChange(PropertyChangeEvent evt) {
        if (this.doParameterChange(evt)) {
            this.site.setNumberTimeStepsStart(((Number)this.numberTimeStepsStartTF.getValue()).intValue());
        }
    }

    private void numberStrideTFPropertyChange(PropertyChangeEvent evt) {
        if (this.doParameterChange(evt)) {
            this.site.setNumberStride(((Number)this.numberStrideTF.getValue()).intValue());
            this.validateAllFields();
        }
    }

    private void totalNumberTimeStepTFPropertyChange(PropertyChangeEvent evt) {
        if (this.doParameterChange(evt)) {
            this.site.setTotalNumberTimeStep(((Number)this.totalNumberTimeStepTF.getValue()).intValue());
            this.validateAllFields();
        }
    }

    private void contextMenuHandler(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.contextMenu.show(this, evt.getX(), evt.getY());
        }
    }

    private void resetDefaultsMenuItemActionPerformed(ActionEvent evt) {
        if (this.site != null) {
            this.site.setDefaultParameters();
            this.setCurrentSite(this.site);
        }
    }

    private void hideFieldError(JTextComponent textfield, JLabel label) {
        Color c = UIManager.getDefaults().getColor("Label.foreground");
        for (MouseListener ml : label.getMouseListeners()) {
            label.removeMouseListener(ml);
        }
        label.setCursor(Cursor.getPredefinedCursor(0));
        label.setIcon(null);
        if (textfield != null) {
            textfield.setForeground(c);
        }
        label.setForeground(c);
        String tt2 = label.getToolTipText();
        if (tt2 != null && tt2.charAt(0) == '<') {
            label.setToolTipText(tt2.replaceAll("<b>.+</b>(<p>)*", ""));
        }
    }

    private void addFieldError(JTextComponent textfield, final JLabel label, final String message) {
        try {
            if (label.getIcon() == null) {
                label.setCursor(Cursor.getPredefinedCursor(12));
                if (warningIcon == null) {
                    warningIcon = new ImageIcon(this.getClass().getResource("images/WarningSign16.png"));
                }
                label.setIcon(warningIcon);
                label.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        JOptionPane.showMessageDialog(label, message, "Invalid model parameter", 2);
                    }
                });
                String tt2 = label.getToolTipText();
                String m = String.format("<html><b>%s</b>%s</html>", message.replace(">", "&gt;").replace("<", "&lt;").replace("\n", "<br>"), tt2 != null ? "<p>" + tt2 : "");
                label.setToolTipText(m);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (textfield != null) {
            textfield.setForeground(ERROR_COLOR);
        }
        label.setForeground(ERROR_COLOR);
    }

    private void checkPositive(JFormattedTextField textfield, JLabel label) {
        if (((Number)textfield.getValue()).doubleValue() <= 0.0) {
            this.addFieldError(textfield, label, label.getText() + " must be greater than zero.");
        } else {
            this.hideFieldError(textfield, label);
        }
    }

    private void validateAllFields() {
        try {
            double maxdt = this.site.getMaxTimeStep();
            double dt = ((Number)this.timeStepTF.getValue()).doubleValue();
            int ka = ((Number)this.numberTimeStepsAGridTF.getValue()).intValue();
            int kb = ((Number)this.numberTimeStepsBGridTF.getValue()).intValue();
            int ksf = ((Number)this.numberTimeStepsSavingTF.getValue()).intValue();
            this.hideFieldError(this.timeStepTF, this.timeStepLabel);
            if (dt > maxdt - 1.0E-4) {
                this.addFieldError(this.timeStepTF, this.timeStepLabel, String.format("Model time step must be less than %.2f s (CFL condition).", maxdt));
            } else if (dt <= 0.0) {
                this.addFieldError(this.timeStepTF, this.timeStepLabel, "Model time step must be greater than zero.");
            } else {
                double dta = this.site.getBathyGrid(1).getMaxTimeStep();
                double dtb = this.site.getBathyGrid(2).getMaxTimeStep();
                String msg = "Model time step in the %c-grid must be less than %.2f s (CFL condition).\nAdjust this setting to skip no more than %d time steps in this grid.";
                if (dt > 0.0 && dt * (double)ka > dta - 0.001) {
                    this.addFieldError(this.numberTimeStepsAGridTF, this.numberTimeStepsAGridLabel, String.format("Model time step in the %c-grid must be less than %.2f s (CFL condition).\nAdjust this setting to skip no more than %d time steps in this grid.", Character.valueOf('A'), dta, (int)Math.floor(dta / dt)));
                } else {
                    this.hideFieldError(this.numberTimeStepsAGridTF, this.numberTimeStepsAGridLabel);
                }
                if (dt * (double)kb > dtb - 0.001) {
                    this.addFieldError(this.numberTimeStepsBGridTF, this.numberTimeStepsBGridLabel, String.format("Model time step in the %c-grid must be less than %.2f s (CFL condition).\nAdjust this setting to skip no more than %d time steps in this grid.", Character.valueOf('B'), dtb, (int)Math.floor(dtb / dt)));
                } else {
                    this.hideFieldError(this.numberTimeStepsBGridTF, this.numberTimeStepsBGridLabel);
                }
            }
            if (ka == 0 || kb == 0 || ksf / ka * ka != ksf || ksf / kb * kb != ksf) {
                this.addFieldError(this.numberTimeStepsSavingTF, this.numberTimeStepsSavingLabel, String.format("Output timestep skip must be a multiple of timestep values\nfor grids A and B (%d and %d).", ka, kb));
            } else {
                this.hideFieldError(this.numberTimeStepsSavingTF, this.numberTimeStepsSavingLabel);
            }
            if (((Number)this.totalNumberTimeStepTF.getValue()).intValue() <= 0) {
                this.addFieldError(this.totalNumberTimeStepTF, this.totalNumberTimeStepLabel, "Total number of timesteps must be greater than zero.");
            } else {
                this.hideFieldError(this.totalNumberTimeStepTF, this.totalNumberTimeStepLabel);
            }
            this.checkPositive(this.totalNumberTimeStepTF, this.totalNumberTimeStepLabel);
            this.checkPositive(this.numberStrideTF, this.numberStrideLabel);
        }
        catch (Exception e) {
            this.hideFieldError(this.timeStepTF, this.timeStepLabel);
            this.hideFieldError(this.numberTimeStepsSavingTF, this.numberTimeStepsSavingLabel);
            this.hideFieldError(this.totalNumberTimeStepTF, this.totalNumberTimeStepLabel);
            this.hideFieldError(this.totalNumberTimeStepTF, this.totalNumberTimeStepLabel);
            this.hideFieldError(this.numberStrideTF, this.numberStrideLabel);
        }
    }

    private void setFieldsEnabled(boolean enable) {
        if (!enable) {
            this.dryLandDepthTF.setValue(null);
            this.frictionTF.setValue(null);
            this.maxEtaTF.setValue(null);
            this.minimumAmplitudeTF.setValue(null);
            this.minimumDepthTF.setValue(null);
            this.numberStrideTF.setValue(null);
            this.numberTimeStepsAGridTF.setValue(null);
            this.numberTimeStepsBGridTF.setValue(null);
            this.numberTimeStepsSavingTF.setValue(null);
            this.numberTimeStepsStartTF.setValue(null);
            this.runupCheckBox.setSelected(false);
            this.timeStepTF.setValue(null);
            this.totalNumberTimeStepTF.setValue(null);
        }
        this.dryLandDepthTF.setEnabled(enable);
        this.frictionTF.setEnabled(enable);
        this.maxEtaTF.setEnabled(enable);
        this.minimumAmplitudeTF.setEnabled(enable);
        this.minimumDepthTF.setEnabled(enable);
        this.numberStrideTF.setEnabled(enable);
        this.numberTimeStepsAGridTF.setEnabled(enable);
        this.numberTimeStepsBGridTF.setEnabled(enable);
        this.numberTimeStepsSavingTF.setEnabled(enable);
        this.numberTimeStepsStartTF.setEnabled(enable);
        this.runupCheckBox.setEnabled(enable);
        this.timeStepTF.setEnabled(enable);
        this.totalNumberTimeStepTF.setEnabled(enable);
    }
}

