/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.dm.AbstractData;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.GeoDateArray;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.tsunami.cmi.SiftShare;
import java.io.File;
import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class MOSTLine
extends AbstractData
implements SGTLine {
    private final SGTMetaData xMeta_ = new SGTMetaData("Time since event", "hours");
    private final SGTMetaData yMeta_ = new SGTMetaData("Wave amplitude", "cm");
    private SoTRange.Double xRange_;
    private SoTRange.Double yRange_;
    double[] times;
    double[] heights;
    private final String title_;
    private final String id_;
    private File ncFile;
    private Point2D.Double tsLocation;
    private int[] tsIndices = null;
    private int timeOffset = 0;

    public MOSTLine() {
        this("ts", "Timeseries");
    }

    public MOSTLine(String id, String title) {
        this.title_ = title;
        this.id_ = id;
        this.xTime_ = false;
        this.yTime_ = false;
        this.dynamic_ = false;
        this.setEmptyData();
    }

    public void setTimeseriesLocation(Point2D.Double tspoint) {
        this.tsLocation = tspoint;
        this.tsIndices = null;
    }

    public void setDataFilename(File ncFile) {
        if (ncFile == null || !ncFile.equals(this.ncFile)) {
            this.ncFile = ncFile;
            this.tsIndices = null;
        }
    }

    public static LonLatIdx findTimeseriesIndices(NetcdfFile nc, Point2D.Double tspt) throws IOException {
        LonLatIdx lli = new LonLatIdx();
        if (nc != null && tspt != null) {
            Variable v = nc.findVariable("LON");
            if (v == null) {
                v = nc.findVariable("lon");
            }
            double[] lons = (double[])v.read().copyTo1DJavaArray();
            v = nc.findVariable("LAT");
            if (v == null) {
                v = nc.findVariable("lat");
            }
            double[] lats = (double[])v.read().copyTo1DJavaArray();
            lli.idx[2] = MOSTLine.getClosestIndex(lons, tspt.x);
            lli.idx[1] = MOSTLine.getClosestIndex(lats, tspt.y);
            lli.lon = lons[lli.idx[2]];
            lli.lat = lats[lli.idx[1]];
        }
        SiftShare.log.fine("getting timeseries location from file: " + nc.getLocation() + " lon: " + tspt.x + ", zero-referenced-i: " + lli.idx[1] + "\n lat: " + tspt.y + ", zero-referenced-j: " + lli.idx[2]);
        return lli;
    }

    public final void setEmptyData() {
        this.xRange_ = new SoTRange.Double(0.0, 1.0);
        this.yRange_ = new SoTRange.Double(-1.0, 1.0);
        this.times = new double[]{0.0};
        this.heights = new double[]{0.0};
        this.fireChange(1);
    }

    public void shiftLeft() {
        int i = 0;
        while (i < this.times.length) {
            int n = i++;
            this.times[n] = this.times[n] - 0.016666666666666666;
        }
        --this.timeOffset;
        this.fireChange(this.times.length);
    }

    public void shiftRight() {
        int i = 0;
        while (i < this.times.length) {
            int n = i++;
            this.times[n] = this.times[n] + 0.016666666666666666;
        }
        ++this.timeOffset;
        this.fireChange(this.times.length);
    }

    public void shiftCenter() {
        int i = 0;
        while (i < this.times.length) {
            int n = i++;
            this.times[n] = this.times[n] - (double)this.timeOffset * 0.016666666666666666;
        }
        this.timeOffset = 0;
        this.fireChange(this.times.length);
    }

    public boolean hasData() {
        return this.heights.length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateData() {
        if (this.ncFile == null || this.tsLocation == null) {
            this.setEmptyData();
            return;
        }
        NetcdfFile nc = null;
        try {
            Variable v;
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            nc = NetcdfFile.open(this.ncFile.getPath());
            if (this.tsIndices == null) {
                this.tsIndices = MOSTLine.findTimeseriesIndices((NetcdfFile)nc, (Point2D.Double)this.tsLocation).idx;
            }
            if ((v = nc.findVariable("TIME")) == null) {
                v = nc.findVariable("time");
            }
            Array tarr = v.read();
            this.times = new double[(int)tarr.getSize()];
            for (int i = 0; i < this.times.length; ++i) {
                this.times[i] = tarr.getDouble(i);
            }
            Variable ha = nc.findVariable("HA");
            if (ha == null) {
                ha = nc.findVariable("ha");
            }
            int[] ha_shape = ha.getShape();
            ha_shape[2] = 1;
            ha_shape[1] = 1;
            float[] htmp = (float[])ha.read(this.tsIndices, ha_shape).copyTo1DJavaArray();
            if (this.times.length == 0 && htmp.length == 0) {
                this.heights = new double[0];
                return;
            }
            int i = 0;
            while (i < this.times.length) {
                int n = i++;
                this.times[n] = this.times[n] / 3600.0;
            }
            this.xRange_ = new SoTRange.Double(this.times[0], this.times[this.times.length - 1]);
            this.heights = new double[htmp.length];
            for (i = 0; i < this.heights.length; ++i) {
                double d = this.heights[i] = htmp[i] < -1.0E30f ? Double.NaN : (double)htmp[i];
                if (this.heights[i] < min) {
                    min = this.heights[i];
                }
                if (!(this.heights[i] > max)) continue;
                max = this.heights[i];
            }
            this.yRange_ = new SoTRange.Double(min, max);
            this.fireChange(this.times.length);
        }
        catch (InvalidRangeException ex) {
            SiftShare.log.warning(ex.getMessage());
            this.setEmptyData();
        }
        catch (IOException ex) {
            SiftShare.log.warning("IO error reading timeseries: " + ex.getMessage());
            this.setEmptyData();
        }
        finally {
            try {
                if (nc != null) {
                    nc.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public int getIndexClosestInTime(double t) {
        return MOSTLine.getClosestIndex(this.times, t);
    }

    private static int getClosestIndex(double[] vec, double t) {
        double del = Double.MAX_VALUE;
        int idx = 0;
        for (int i = 0; i < vec.length; ++i) {
            if (!(Math.abs(vec[i] - t) < del)) continue;
            del = Math.abs(vec[i] - t);
            idx = i;
        }
        return idx;
    }

    private void fireChange(int length) {
        String property = this.isDynamic() ? "dynamicDataModified" : "dataModified";
        this.changes_.firePropertyChange(property, new Integer(0), new Integer(length));
    }

    @Override
    public double[] getXArray() {
        return this.times;
    }

    @Override
    public double[] getYArray() {
        return this.heights;
    }

    @Override
    public GeoDate[] getTimeArray() {
        return null;
    }

    @Override
    public GeoDateArray getGeoDateArray() {
        return null;
    }

    @Override
    public double[] getAssociatedData() {
        return null;
    }

    @Override
    public boolean hasAssociatedData() {
        return false;
    }

    @Override
    public String getTitle() {
        return this.title_;
    }

    @Override
    public SGLabel getKeyTitle() {
        return null;
    }

    @Override
    public String getId() {
        return this.id_;
    }

    @Override
    public SGTData copy() {
        return null;
    }

    @Override
    public boolean isXTime() {
        return false;
    }

    @Override
    public boolean isYTime() {
        return false;
    }

    @Override
    public SGTMetaData getXMetaData() {
        return this.xMeta_;
    }

    @Override
    public SGTMetaData getYMetaData() {
        return this.yMeta_;
    }

    @Override
    public SoTRange getXRange() {
        return this.xRange_.copy();
    }

    @Override
    public SoTRange getYRange() {
        return this.yRange_.copy();
    }

    public static class LonLatIdx {
        public int[] idx = new int[]{0, 0, 0};
        public double lon = 0.0;
        public double lat = 0.0;

        public String toString() {
            return "Lon: " + this.lon + " idx: " + this.idx[2] + " Lat: " + this.lat + " jdx: " + this.idx[1];
        }
    }
}

