/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.dm.SimpleGrid;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.tsunami.cmi.GeoGrid2D;
import gov.noaa.tsunami.cmi.SiftShare;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.logging.Level;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.geotiff.GeoTiffCWM;

public class MOSTMaxGrid
extends GeoGrid2D
implements Cloneable {
    private int skipX = 1;
    private int skipY = 1;
    private String varName;
    private int maxI;
    private int maxJ;
    private int minI;
    private int minJ;
    private static double missing_value = -1.0E34;
    private double inunArea = 0.0;
    private static int countnan = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readData(String fileName, String varName) {
        String latName;
        String lonName;
        this.id_ = fileName;
        this.fileName = fileName;
        this.varName = varName;
        boolean dataValid = false;
        double start = Double.POSITIVE_INFINITY;
        double end = Double.NEGATIVE_INFINITY;
        this.clearData();
        if (varName.endsWith("_a")) {
            lonName = "lona";
            latName = "lata";
        } else if (varName.endsWith("_b")) {
            lonName = "lonb";
            latName = "latb";
        } else if (varName.endsWith("_c")) {
            lonName = "lonc";
            latName = "latc";
        } else {
            lonName = "grid_lon";
            latName = "grid_lat";
        }
        NetcdfFile nc = null;
        try {
            Variable latVar;
            nc = NetcdfFile.open(fileName);
            Variable ha = nc.findVariable(varName);
            if (ha == null) {
                throw new IOException("no var: " + varName);
            }
            int[] shape = ha.getShape();
            int[] origin = new int[ha.getRank()];
            this.nLon = shape[1];
            this.nLat = shape[0];
            this.grid = new double[this.nLon * this.nLat];
            Variable lonVar = nc.findVariable(lonName);
            if (lonVar == null) {
                lonVar = nc.findVariable("lon");
            }
            if ((latVar = nc.findVariable(latName)) == null) {
                latVar = nc.findVariable("lat");
            }
            this.lons = (double[])lonVar.read().copyTo1DJavaArray();
            this.lats = (double[])latVar.read().copyTo1DJavaArray();
            this.normalizeLons();
            this.xRange_ = MOSTMaxGrid.getRange(this.lons);
            this.yRange_ = MOSTMaxGrid.getRange(this.lats);
            SiftShare.log.info("max amp filename: " + fileName + " range, X: " + this.xRange_ + " Y: " + this.yRange_);
            this.zRange_ = new Range2D(-100.0, 100.0);
            missing_value = nc.readAttributeDouble(ha, "missing_value", missing_value);
            ArrayFloat.D2 a = (ArrayFloat.D2)nc.findVariable(varName).read(origin, shape).reduce();
            this.minJ = -1;
            this.minI = -1;
            this.maxJ = -1;
            this.maxI = -1;
            for (int j = 0; j < this.nLon; ++j) {
                for (int i = 0; i < this.nLat; ++i) {
                    double holder = a.get(i, j);
                    if (Math.abs(holder - missing_value) < 0.01) {
                        this.grid[j * this.nLat + i] = Double.NaN;
                        continue;
                    }
                    this.grid[j * this.nLat + i] = holder;
                    if (this.grid[j * this.nLat + i] < start) {
                        start = this.grid[j * this.nLat + i];
                        this.minI = i;
                        this.minJ = j;
                    }
                    if (!(this.grid[j * this.nLat + i] > end)) continue;
                    end = this.grid[j * this.nLat + i];
                    this.maxI = i;
                    this.maxJ = j;
                }
            }
            Variable inun = nc.findVariable("inundation");
            if (inun != null) {
                this.inunArea = nc.readAttributeDouble(inun, "MaxInundationArea", this.inunArea);
            }
            if (start != Double.POSITIVE_INFINITY || end != Double.NEGATIVE_INFINITY) {
                this.zRange_.start = start;
                this.zRange_.end = end;
                SiftShare.log.log(Level.INFO, "Grid Z range: {0} to {1}, max index: i={2} j={3} at pos: lat={4} lon={5}, min index: i={6} j={7} at pos; lat={8} lon={9}", new Object[]{start, end, this.maxI, this.maxJ, this.lats[this.maxI], this.lons[this.maxJ], this.minI, this.minJ, this.lats[this.minI], this.lons[this.minJ]});
                dataValid = true;
                this.changes_.firePropertyChange("dataModified", 0, this.grid.length);
            } else {
                dataValid = false;
            }
        }
        catch (IOException | InvalidRangeException ex) {
            SiftShare.log.log(Level.WARNING, "Error reading MOST max file: " + fileName, ex);
            dataValid = false;
        }
        finally {
            if (nc != null) {
                try {
                    nc.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (!dataValid) {
            this.nLon = 2;
            this.nLat = 2;
            this.lons = new double[]{0.0, 1.0};
            this.lats = new double[]{0.0, 1.0};
            this.grid = new double[]{0.0, 0.0, 0.0, 0.0};
        }
        return dataValid;
    }

    public void setMinMaxIndices(int nI, int xI, int nJ, int xJ, double s, double e) {
        if (nI < 0 | xI < 0 | nJ < 0 | xJ < 0) {
            this.maxJ = 0;
            this.minJ = 0;
            this.maxI = 0;
            this.minI = 0;
            this.zRange_.start = 0.0;
            this.zRange_.end = 0.0;
        } else {
            this.minI = nI;
            this.maxI = xI;
            this.minJ = nJ;
            this.maxJ = xJ;
            this.zRange_.start = s;
            this.zRange_.end = e;
        }
        this.changes_.firePropertyChange("dataModified", 0, this.grid.length);
    }

    public void currentsToKnots() {
        for (int j = 0; j < this.nLon; ++j) {
            for (int i = 0; i < this.nLat; ++i) {
                if (Double.isNaN(this.grid[j * this.nLat + i])) continue;
                int n = j * this.nLat + i;
                this.grid[n] = this.grid[n] * 0.0194384;
            }
        }
        this.zRange_.start *= 0.0194384;
        this.zRange_.end *= 0.0194384;
    }

    public void saveFlowDepthAsNetCDF(File ncFile) throws IOException {
        int i;
        if (ncFile.exists()) {
            ncFile.delete();
        }
        NetcdfFileWriter ncfw = NetcdfFileWriter.createNew(NetcdfFileWriter.Version.netcdf3, ncFile.getPath(), null);
        Dimension lonDim = ncfw.addDimension(null, "lon", this.nLon);
        Dimension latDim = ncfw.addDimension(null, "lat", this.nLat);
        ArrayList<Dimension> dimList = new ArrayList<Dimension>();
        dimList.add(lonDim);
        Variable lonVar = ncfw.addVariable(null, "lon", DataType.DOUBLE, dimList);
        dimList.clear();
        dimList.add(latDim);
        Variable latVar = ncfw.addVariable(null, "lat", DataType.DOUBLE, dimList);
        dimList.clear();
        dimList.add(latDim);
        dimList.add(lonDim);
        Variable bathVar = ncfw.addVariable(null, "flow_depth", DataType.FLOAT, dimList);
        lonVar.addAttribute(new Attribute("long_name", "Longitude"));
        lonVar.addAttribute(new Attribute("units", "degrees_east"));
        latVar.addAttribute(new Attribute("long_name", "Latitude"));
        latVar.addAttribute(new Attribute("units", "degrees_north"));
        bathVar.addAttribute(new Attribute("long_name", "Flow Depth"));
        bathVar.addAttribute(new Attribute("units", "centimeters"));
        bathVar.addAttribute(new Attribute("_FillValue", Float.valueOf(-1.0E34f)));
        bathVar.addAttribute(new Attribute("missing_value", Float.valueOf(-1.0E34f)));
        bathVar.addAttribute(new Attribute("grid_mapping", "crs"));
        dimList.clear();
        Variable crsVar = ncfw.addVariable(null, "crs", DataType.INT, dimList);
        crsVar.addAttribute(new Attribute("grid_mapping_name", "latitude_longitude"));
        crsVar.addAttribute(new Attribute("longitude_of_prime_meridian", 0.0));
        crsVar.addAttribute(new Attribute("semi_major_axis", 6378137.0));
        crsVar.addAttribute(new Attribute("inverse_flattening", 298.257223563));
        crsVar.addAttribute(new Attribute("crs_wkt", "GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]"));
        crsVar.addAttribute(new Attribute("spatial_ref", "GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]"));
        ncfw.addGroupAttribute(null, new Attribute("Conventions", "COARDS"));
        ncfw.addGroupAttribute(null, new Attribute("title", "flow depth from MOST"));
        ncfw.create();
        boolean decLon = false;
        double[] nxloc = new double[this.lons.length];
        for (i = 0; i < this.lons.length; ++i) {
            nxloc[i] = this.lons[i];
            if (!(this.lons[i] > 180.0)) continue;
            decLon = true;
        }
        if (decLon) {
            for (i = 0; i < nxloc.length; ++i) {
                nxloc[i] = nxloc[i] - 360.0;
            }
        }
        try {
            ncfw.write(lonVar, Array.factory(nxloc));
            ncfw.write(latVar, Array.factory(this.lats));
            ArrayFloat.D2 depsarr = new ArrayFloat.D2(this.nLat, this.nLon);
            for (int j = 0; j < this.nLat; ++j) {
                for (int i2 = 0; i2 < this.nLon; ++i2) {
                    depsarr.set(j, i2, (float)this.grid[this.nLat * i2 + j]);
                }
            }
            ncfw.write(bathVar, depsarr);
        }
        catch (InvalidRangeException ex) {
            SiftShare.log.log(Level.SEVERE, "Error creating bathy netcdf file", ex);
            throw new IOException(ex);
        }
        ncfw.close();
    }

    public void copyNetCDFforGIS(File ncfile) throws IOException {
        File infile = new File(this.fileName);
        Files.copy(infile.toPath(), ncfile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        NetcdfFileWriter ncfw = NetcdfFileWriter.openExisting(ncfile.getPath());
        NetcdfFile nc = NetcdfFile.open(this.fileName);
        ArrayDouble.D1 lona = (ArrayDouble.D1)nc.findVariable("lona").read();
        boolean decLon = false;
        int i = 0;
        while ((long)i < lona.getSize()) {
            if (lona.get(i) > 180.0) {
                decLon = true;
                break;
            }
            ++i;
        }
        if (decLon) {
            i = 0;
            while ((long)i < lona.getSize()) {
                double val = lona.get(i);
                lona.set(i, val - 360.0);
                ++i;
            }
        }
        ArrayDouble.D1 lonb = (ArrayDouble.D1)nc.findVariable("lonb").read();
        decLon = false;
        int i2 = 0;
        while ((long)i2 < lonb.getSize()) {
            if (lonb.get(i2) > 180.0) {
                decLon = true;
            }
            ++i2;
        }
        if (decLon) {
            i2 = 0;
            while ((long)i2 < lonb.getSize()) {
                double val = lonb.get(i2);
                lonb.set(i2, val - 360.0);
                ++i2;
            }
        }
        ArrayDouble.D1 lonc = (ArrayDouble.D1)nc.findVariable("lonc").read();
        decLon = false;
        int i3 = 0;
        while ((long)i3 < lonc.getSize()) {
            if (lonc.get(i3) > 180.0) {
                decLon = true;
                break;
            }
            ++i3;
        }
        if (decLon) {
            i3 = 0;
            while ((long)i3 < lonc.getSize()) {
                double val = lonc.get(i3);
                lonc.set(i3, val - 360.0);
                ++i3;
            }
        }
        Variable vara = ncfw.findVariable("lona");
        Variable varb = ncfw.findVariable("lonb");
        Variable varc = ncfw.findVariable("lonc");
        try {
            ncfw.write(vara, lona);
            ncfw.write(varb, lonb);
            ncfw.write(varc, lonc);
        }
        catch (InvalidRangeException ex) {
            nc.close();
            ncfw.close();
            throw new IOException(ex);
        }
        nc.close();
        ncfw.close();
    }

    public String getVarName() {
        return this.varName;
    }

    public void saveAsGeoTIFF(File infile, String gridname, File outfile) throws IOException {
        GridDataset gridDs = GridDataset.open(infile.getPath());
        GeoGrid g = gridDs.findGridByName(gridname);
        GeoTiffCWM gtw = new GeoTiffCWM(outfile.getCanonicalPath());
        SiftShare.log.info("Saving GeoTIFF... grid: " + g.getInfo() + " to file: " + outfile.getCanonicalPath());
        try {
            gtw.writeGrid(gridDs, g, g.readYXData(0, 0), false);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException(iae);
        }
        gtw.close();
        gridDs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAsASCIIRaster2(File file) throws IOException {
        int i;
        int i2;
        int j;
        int i3;
        double[] X2 = new double[this.nLon];
        double[] Y = new double[this.nLat];
        double[] Z = new double[this.nLon * this.nLat];
        boolean decLong = false;
        for (i3 = 0; i3 < this.nLon; ++i3) {
            X2[i3] = this.lons[i3];
            if (!(X2[i3] > 180.0)) continue;
            decLong = true;
        }
        if (decLong) {
            SiftShare.log.info("putting longitude on -180<lon<180");
            for (i3 = 0; i3 < this.nLon; ++i3) {
                X2[i3] = X2[i3] - 360.0;
            }
        }
        if (this.lats[1] > this.lats[0]) {
            SiftShare.log.info("flipping  latitude");
            for (i3 = 0; i3 < this.nLat; ++i3) {
                Y[i3] = this.lats[this.nLat - i3 + 1];
            }
            for (j = 0; j < this.nLat; ++j) {
                for (i2 = 0; i2 < this.nLon; ++i2) {
                    Z[this.nLat * i2 + this.nLat - j + 1] = this.grid[this.nLat * i2 + j];
                }
            }
        } else {
            for (i3 = 0; i3 < this.nLat; ++i3) {
                Y[i3] = this.lats[i3];
            }
            for (j = 0; j < this.nLat; ++j) {
                for (i2 = 0; i2 < this.nLon; ++i2) {
                    Z[this.nLat * i2 + j] = this.grid[this.nLat * i2 + j];
                }
            }
        }
        double dxmax = this.lons[1] - this.lons[0];
        double dxmin = this.lons[1] - this.lons[0];
        double dymax = this.lats[0] - this.lats[1];
        double dymin = this.lats[0] - this.lats[1];
        for (i = 0; i < this.nLon - 1; ++i) {
            if (this.lons[i + 1] - this.lons[i] > dxmax) {
                dxmax = this.lons[i + 1] - this.lons[i];
            }
            if (!(this.lons[i + 1] - this.lons[i] < dxmin)) continue;
            dxmin = this.lons[i + 1] - this.lons[i];
        }
        for (i = 0; i < this.nLat - 1; ++i) {
            if (this.lats[i] - this.lats[i + 1] > dymax) {
                dymax = this.lats[i] - this.lats[i + 1];
            }
            if (!(this.lats[i] - this.lats[i + 1] < dymin)) continue;
            dymin = this.lats[i] - this.lats[i + 1];
        }
        SiftShare.log.info("dxmin: " + dxmin + " dxmax: " + dxmax + " dymin: " + dymin + " dymax: " + dymax);
        if (!(Math.abs(dxmin - dxmax) < 1.0E-7 && Math.abs(dymin - dymax) < 1.0E-7 && Math.abs(dxmin - dymax) < 1.0E-7)) {
            throw new IOException("regridding with missing values unsupported.");
        }
        SiftShare.log.info("Not regridding.");
        double[] Xn = X2;
        double[] Yn = Y;
        double[] Zn = Z;
        int nx = this.nLon;
        int ny = this.nLat;
        double dx = dxmin;
        try (PrintWriter pw = new PrintWriter(file);){
            pw.printf("ncols %6d\n", nx);
            pw.printf("nrows %6d\n", ny);
            pw.printf("xllcorner %3.10f\n", Xn[0] - 0.5 * dx);
            pw.printf("yllcorner %2.10f\n", Yn[ny - 1] - 0.5 * dx);
            pw.printf("cellsize %2.15f\n", dx);
            pw.printf("NODATA_value %5d\n", -9999);
            for (int j2 = 0; j2 < ny; ++j2) {
                for (int i4 = 0; i4 < nx; ++i4) {
                    if (Double.isNaN(Zn[ny * i4 + j2])) {
                        pw.printf(" -9999", new Object[0]);
                        continue;
                    }
                    pw.printf(" %2.2f", Zn[ny * i4 + j2]);
                }
                pw.printf("\n", new Object[0]);
            }
        }
    }

    private static int findIndex(double[] x, double sx) {
        int i;
        if (Double.isNaN(sx) || sx < x[0] || sx > x[x.length - 1]) {
            ++countnan;
            return Integer.MIN_VALUE;
        }
        for (i = 1; i < x.length && (Double.isNaN(x[i]) || x[i] < sx); ++i) {
        }
        return i;
    }

    public static void bilinearRegrid(double[] sx, double[] sy, double[] sz, double[] dx, double[] dy, double[] dz) {
        if (sx.length * sy.length != sz.length || dx.length * dy.length != dz.length) {
            throw new IllegalArgumentException();
        }
        int sylen = sy.length;
        for (int dj = 0; dj < dy.length; ++dj) {
            int sj = MOSTMaxGrid.findIndex(sy, dy[dj]);
            if (sj < 0 || sy[sj] == sy[sj - 1]) continue;
            double u = (dy[dj] - sy[sj - 1]) / (sy[sj] - sy[sj - 1]);
            for (int di = 0; di < dx.length; ++di) {
                int si = MOSTMaxGrid.findIndex(sx, dx[di]);
                if (si < 0 || sx[si] == sx[si - 1]) continue;
                double t = (dx[di] - sx[si - 1]) / (sx[si] - sx[si - 1]);
                dz[di * dy.length + dj] = t * u * sz[si * sylen + sj] + (1.0 - t) * u * sz[(si - 1) * sylen + sj] + (1.0 - t) * (1.0 - u) * sz[(si - 1) * sylen + (sj - 1)] + t * (1.0 - u) * sz[si * sylen + (sj - 1)];
            }
        }
    }

    public void subsampleToMaxSize(int maxDimension) {
        this.skipX = 1;
        this.skipY = 1;
        while (this.nLon / this.skipX > maxDimension) {
            ++this.skipX;
        }
        while (this.nLat / this.skipY > maxDimension) {
            ++this.skipY;
        }
        if (this.skipX == 1 && this.skipY == 1) {
            return;
        }
        int numX = (this.nLon - 1) / this.skipX + 1;
        int numY = (this.nLat - 1) / this.skipY + 1;
        SiftShare.log.log(Level.FINE, "Subsampling, maxDim: {0} nLon: {1} skipX: {2} numX: {3}", new Object[]{maxDimension, this.nLon, this.skipX, numX});
        double[] newdeps = new double[numX * numY];
        int count = 0;
        for (int i = 0; i < this.nLon; ++i) {
            for (int j = 0; j < this.nLat; ++j) {
                if (i % this.skipX != 0 || j % this.skipY != 0) continue;
                newdeps[count] = this.grid[this.nLat * i + j];
                ++count;
            }
        }
        double[] newlons = new double[numX];
        count = 0;
        for (int i = 0; i < this.nLon; i += this.skipX) {
            newlons[count] = this.lons[i];
            ++count;
        }
        double[] newlats = new double[numY];
        count = 0;
        for (int i = 0; i < this.nLat; i += this.skipY) {
            newlats[count] = this.lats[i];
            ++count;
        }
        this.grid = newdeps;
        this.lons = newlons;
        this.lats = newlats;
    }

    public double getInunArea() {
        return this.inunArea;
    }

    public double getXOfMaxWave() {
        return this.lons[this.maxJ];
    }

    public double getYOfMaxWave() {
        return this.lats[this.maxI];
    }

    public double getXOfMinWave() {
        return this.lons[this.minJ];
    }

    public double getYOfMinWave() {
        return this.lats[this.minI];
    }

    public boolean isImage() {
        return this.lats[0] > this.lats[1];
    }

    @Override
    public SGTData copy() {
        SGTGrid newGrid;
        try {
            newGrid = (SGTGrid)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newGrid = new SimpleGrid();
        }
        return newGrid;
    }

    public static void main(String[] args) {
        MOSTMaxGrid mg = new MOSTMaxGrid();
        mg.readData("/Users/cmoore/ComMIT/scratch/hilo2/linCo_source001h_max.nc", "max_height");
        Range2D zr = mg.getZRange();
        System.out.println("max amp in grid: " + zr.end + " min: " + zr.start);
        try {
            mg.saveAsASCIIRaster2(new File("/Users/cmoore/ComMIT/pacific/westport_run2d/westport_maxC.asc"));
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.SEVERE, null, ex);
        }
    }
}

