/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.websift.events.SeismicEvent;
import gov.noaa.tsunami.websift.propdb.SourceScenario;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class ManualEventDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private static int returnStatus = 0;
    private static SeismicEvent seismicEvent = new SeismicEvent();
    private JFormattedTextField depthFormattedTextField;
    private JFormattedTextField jFormattedTextField1;
    private JFormattedTextField jFormattedTextField2;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JSpinner jSpinner1;
    private JFormattedTextField mwFormattedTextField;
    private JTextField nameTextField;
    private JButton resetButton;
    private JButton submitButton;

    public ManualEventDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        JSpinner.DateEditor de = new JSpinner.DateEditor(this.jSpinner1, "yyyy-DD-MM hh:mm:ss");
        this.jSpinner1.setEditor(de);
        SpinnerDateModel sdm = new SpinnerDateModel();
        sdm.setCalendarField(13);
        this.jSpinner1.setModel(sdm);
        CMIUtil.installEscapeCloseOperation(this);
    }

    public static int showDialog(Dialog d, boolean b) {
        ManualEventDialog dialog = new ManualEventDialog(null, b);
        dialog.setLocationRelativeTo(d);
        dialog.setVisible(true);
        dialog.dispose();
        return returnStatus;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jFormattedTextField1 = new JFormattedTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jFormattedTextField2 = new JFormattedTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jLabel7 = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.mwFormattedTextField = new JFormattedTextField();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.depthFormattedTextField = new JFormattedTextField();
        this.submitButton = new JButton();
        this.resetButton = new JButton();
        this.setTitle("Manually Create New Event");
        this.jLabel1.setText("Enter event details");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Event details"));
        this.jLabel2.setText("Latitude:");
        this.jFormattedTextField1.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter()));
        this.jFormattedTextField1.setText("0.0000");
        this.jLabel3.setForeground(new Color(153, 153, 153));
        this.jLabel3.setText("North 0.0-90.0, South -0.1 to -90.0");
        this.jLabel4.setText("Longitude:");
        this.jFormattedTextField2.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter()));
        this.jFormattedTextField2.setText("0.0000");
        this.jLabel5.setForeground(new Color(153, 153, 153));
        this.jLabel5.setText("East 0.0-180.0, West -0.1 -180.0");
        this.jLabel6.setText("Event Date/Time (UTC):");
        this.jSpinner1.setModel(new SpinnerDateModel(new Date(), null, null, 13));
        this.jLabel7.setText("Event Name:");
        this.jLabel8.setForeground(new Color(153, 153, 153));
        this.jLabel8.setText("Brief identifier for this event");
        this.jLabel9.setText("Magnitude (Mw):");
        this.mwFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.00"))));
        this.jLabel10.setForeground(new Color(153, 153, 153));
        this.jLabel10.setText("Mw from 3-9.6 (or zero for non seismic)");
        this.jLabel11.setText("Depth (km):");
        this.depthFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.00"))));
        this.depthFormattedTextField.setText("10.0");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6).addGap(59, 59, 59).addComponent(this.jSpinner1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel7).addGap(122, 122, 122).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameTextField).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jLabel8, -1, -1, Short.MAX_VALUE)))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel4).addComponent(this.jLabel9).addComponent(this.jLabel11)).addGap(97, 97, 97).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mwFormattedTextField, GroupLayout.Alignment.TRAILING).addComponent(this.jFormattedTextField2, GroupLayout.Alignment.TRAILING).addComponent(this.jFormattedTextField1).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5, GroupLayout.Alignment.LEADING, -2, 245, -2).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -2, 262, -2).addComponent(this.jLabel10, GroupLayout.Alignment.LEADING, -2, 286, -2)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.depthFormattedTextField)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jFormattedTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jFormattedTextField2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addGap(15, 15, 15).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.mwFormattedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10).addGap(8, 8, 8).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.depthFormattedTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jSpinner1, -2, -1, -2)).addContainerGap(20, Short.MAX_VALUE)));
        this.submitButton.setText("Submit");
        this.submitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManualEventDialog.this.submitButtonActionPerformed(evt);
            }
        });
        this.resetButton.setText("Cancel");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManualEventDialog.this.resetButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resetButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.submitButton).addComponent(this.resetButton))));
        this.pack();
    }

    private void submitButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        Double lat = (Double)this.jFormattedTextField2.getValue();
        Double lon = (Double)this.jFormattedTextField1.getValue();
        seismicEvent = new SeismicEvent(7.5, lat, lon);
        Date date = (Date)this.jSpinner1.getValue();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        seismicEvent.setTime(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13));
        this.setVisible(false);
    }

    public static SeismicEvent getSeismicEvent() {
        return seismicEvent;
    }

    public static SourceScenario getSourceScenario() {
        SourceScenario ss = new SourceScenario("test", seismicEvent, "", SourceScenario.Type.UNKNOWN);
        return ss;
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ManualEventDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(ManualEventDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ManualEventDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ManualEventDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ManualEventDialog dialog = new ManualEventDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

