/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;

class ModelRunFileView
extends FileView {
    private static final Icon emptyRunIcon = ModelRunFileView.loadIcon("images/ModelNoResults16.png");
    private static final Icon resultsRunIcon = ModelRunFileView.loadIcon("images/ModelResults16.png");

    ModelRunFileView() {
    }

    @Override
    public Boolean isTraversable(File f) {
        return !ModelRunFileView.isModelRunDirectory(f);
    }

    @Override
    public Icon getIcon(File f) {
        if (ModelRunFileView.isModelRunDirectory(f)) {
            return this.hasModelResults(f) ? resultsRunIcon : emptyRunIcon;
        }
        return null;
    }

    @Override
    public String getName(File f) {
        if (f.getName().endsWith("_run2d") && ModelRunFileView.isModelRunDirectory(f)) {
            return f.getName().replaceFirst("_run2d$", "");
        }
        return null;
    }

    @Override
    public String getTypeDescription(File f) {
        return ModelRunFileView.isModelRunDirectory(f) ? "MOST model run" : null;
    }

    public static boolean isModelRunDirectory(File f) {
        return f != null && f.isDirectory() && new File(f, "most3_facts_nc.in").length() > 0L;
    }

    private boolean hasModelResults(File f) {
        return new File(f, this.getName(f) + "source01_runup_ha.nc").isFile();
    }

    public static FileFilter getModelRunFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f != null && f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Model run";
            }
        };
    }

    private static Icon loadIcon(String s) {
        return new ImageIcon(ModelRunFileView.class.getResource(s));
    }
}

