/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.LinCombModule;
import gov.noaa.tsunami.cmi.ModelEvent;
import gov.noaa.tsunami.cmi.ModelListener;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import gov.noaa.tsunami.cmi.StreamGobbler;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModelRunner
implements Runnable {
    private final SiteInfo runningSite;
    private final Iterable<ModelListener> listeners;
    private Process mostProc;
    private Thread mythread;
    private LinCombModule linearCombinator;
    private boolean modelCancelled = false;
    public static final int POLLING_RATE = 1000;
    public static final String TERM_FILENAME = "shootmenow";
    private StreamGobbler mostErrorGobbler;
    private StreamGobbler mostOutputGobbler;

    public ModelRunner(SiteInfo site, Iterable<ModelListener> listeners) {
        this.runningSite = site;
        this.listeners = listeners != null ? listeners : Collections.emptyList();
        SiftShare.log.info("Creating ModelRunner for site: " + site.getName() + " source: " + site.getActiveSourceName());
    }

    public Thread start() {
        this.mythread = new Thread((Runnable)this, this.getClass().getSimpleName() + ": " + this.runningSite.getName());
        this.mythread.start();
        return this.mythread;
    }

    protected void notifyModelUpdate(ModelEvent event) {
        for (ModelListener ml : this.listeners) {
            ml.modelUpdate(event);
        }
    }

    protected void notifyModelStart(ModelEvent event) {
        for (ModelListener ml : this.listeners) {
            ml.modelStarted(event);
        }
    }

    protected void notifyModelStop(ModelEvent event) {
        for (ModelListener ml : this.listeners) {
            ml.modelStopped(event);
        }
    }

    @Override
    public void run() {
        ModelEvent startEv = new ModelEvent(this.runningSite, 100);
        startEv.setLogText(String.format("Starting model %s\n", this.runningSite.getName()));
        this.notifyModelStart(startEv);
        if (!this.generateSources()) {
            return;
        }
        try {
            SiftShare.log.entering("ModelRunner", "run");
            if (!CMIUtil.deleteFile(new File(this.runningSite.getSiteDirectory(), TERM_FILENAME))) {
                throw new IOException("Can't delete terminate (shootmenow) file; is the model run directory read-only?");
            }
            System.gc();
            this.runningSite.loadSettings(true);
            ModelEvent ev = new ModelEvent(this.runningSite, 100);
            ev.setMessage("Launching MOST\n");
            ev.setLogText("Launching MOST\n");
            this.notifyModelUpdate(ev);
            Runtime rt = Runtime.getRuntime();
            String runString = String.format("%s %s linCo_%s ./ t", CMIUtil.MOST_EXEC, this.runningSite.getName() + "_" + this.runningSite.getActiveSourceName(), this.runningSite.getActiveSourceName());
            SiftShare.log.log(Level.INFO, "Starting MOST for model {0}: {1}", new Object[]{this.runningSite.getName(), runString});
            this.mostProc = rt.exec(runString, this.setupEnvironment(CMIUtil.MOST_EXEC), this.runningSite.getSiteDirectory());
        }
        catch (IOException ex) {
            String msg = "Error starting MOST: " + ex.getMessage();
            ModelEvent errev = new ModelEvent(this.runningSite, 201, this.runningSite.getTimestepsAvailable());
            SiftShare.log.log(Level.SEVERE, msg, ex);
            errev.setLogText(msg);
            errev.setMessage(msg);
            this.notifyModelStop(errev);
            return;
        }
        this.mostErrorGobbler = new StreamGobbler(this.mostProc.getErrorStream(), "MOSTERR");
        this.mostErrorGobbler.start();
        this.mostOutputGobbler = new StreamGobbler(this.mostProc.getInputStream(), "MOSTOUT");
        this.mostOutputGobbler.start();
        MostResultMonitor resultMonitor = new MostResultMonitor();
        Timer resultTimer = new Timer(resultMonitor.getClass().getSimpleName() + ": " + this.runningSite.getName(), true);
        resultTimer.schedule((TimerTask)resultMonitor, 0L, 1000L);
        try {
            this.mostProc.waitFor();
        }
        catch (InterruptedException ex) {
            this.modelCancelled = true;
        }
        int exitval = this.mostProc.exitValue();
        SiftShare.log.info("Model stopped, exit value: " + exitval);
        this.mostProc = null;
        resultMonitor.run();
        resultTimer.cancel();
        this.mostErrorGobbler.requestStop();
        this.mostOutputGobbler.requestStop();
        ModelEvent stopev = new ModelEvent(this.runningSite, 200, this.runningSite.getTimestepsAvailable());
        String logtxt = resultMonitor.checkOutputLog();
        String exittxt = "";
        switch (exitval) {
            case 0: {
                exittxt = "\nModel completed normally.\n";
                stopev.status = 200;
                break;
            }
            case 1: {
                exittxt = "\nModel run cancelled.\n";
                stopev.status = 200;
                break;
            }
            case 2: {
                exittxt = "\nModel caught TERM signal.\n";
                stopev.status = 200;
                break;
            }
            case 3: {
                exittxt = "\nNo model arguments, printing Usage.\n";
                stopev.status = 202;
                break;
            }
            case 4: {
                exittxt = "\nError: Can't find most3_facts_nc.in parameter file.\n";
                stopev.status = 201;
                break;
            }
            case 5: {
                exittxt = "\nError: Can't parse 'runup' parameter in most3_facts_nc.in file.\n";
                stopev.status = 201;
                break;
            }
            case 6: {
                exittxt = "\nError: A/B-grid steps not an integer multiple of output time step.\n";
                stopev.status = 201;
                break;
            }
            case 7: {
                exittxt = "\nError: Can't parse bathymetry file.\n";
                stopev.status = 201;
                break;
            }
            case 8: {
                exittxt = "\nError: bathymetry file too large.\n";
                stopev.status = 201;
                break;
            }
            case 9: {
                exittxt = "\nError: bathymetry files overlap.\n";
                stopev.status = 201;
                break;
            }
            case 10: {
                exittxt = "\nError: local deformation regridding error.\n";
                stopev.status = 201;
                break;
            }
            case 11: {
                exittxt = "\nError: zero-grid (propdb) regridding error.\n";
                stopev.status = 201;
                break;
            }
            case 12: {
                exittxt = "\nError: initial condition wave too small. No output produced\n";
                stopev.status = 201;
                break;
            }
            case 13: {
                exittxt = "\nError: C-grid blowup error (exceeded user-defined max wave).\n";
                stopev.status = 201;
                break;
            }
            case 14: {
                exittxt = "\nError: B-grid blowup error (exceeded user-defined max wave).\n";
                stopev.status = 201;
                break;
            }
            case 15: {
                exittxt = "\nError: A-grid blowup error (exceeded user-defined max wave).\n";
                stopev.status = 201;
                break;
            }
            case 16: {
                exittxt = "\nError: no _sift.nc file running from restart.\n";
                stopev.status = 201;
                break;
            }
            case 17: {
                exittxt = "\nWarning: reached end of forcing file...\n";
                stopev.status = 201;
                break;
            }
            case 18: {
                exittxt = "\nError: error initializing CUDA - no card or not enough memory.\n";
                stopev.status = 201;
                break;
            }
        }
        logtxt = (logtxt != null ? logtxt : exittxt) + String.format("Model %s ended.\n", this.runningSite.getName());
        stopev.setLogText(logtxt);
        stopev.setMessage(exittxt);
        if (resultMonitor.errorMessage != null) {
            stopev.status = 201;
            stopev.setMessage(resultMonitor.errorMessage);
        } else if (this.modelCancelled) {
            stopev.status = 202;
        }
        this.notifyModelStop(stopev);
        SiftShare.log.exiting("ModelRunner", "run");
    }

    public void stop() {
        this.modelCancelled = true;
        OutputStreamWriter fw = null;
        try {
            fw = new FileWriter(new File(this.runningSite.getSiteDirectory(), TERM_FILENAME));
            fw.write("now");
        }
        catch (Exception e) {
            SiftShare.log.log(Level.WARNING, "error writing shootmenow file", e);
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
                System.gc();
            }
            catch (IOException iOException) {}
        }
        if (this.linearCombinator != null) {
            this.linearCombinator.cancel();
        }
    }

    public boolean isRunning() {
        return this.mythread != null && this.mythread.isAlive();
    }

    public SiteInfo getModelSite() {
        return this.runningSite;
    }

    private boolean generateSources() {
        boolean rv = true;
        if (this.linearCombinator != null) {
            try {
                this.linearCombinator.createLinComb();
            }
            catch (LinCombModule.LinCombException ex) {
                ModelEvent mev = new ModelEvent(this.runningSite, ex.getModelEventStatus(), this.runningSite.getTimestepsAvailable());
                mev.setMessage(ex.getMessage());
                mev.setLogText(ex.getMessage());
                this.notifyModelStop(mev);
                rv = false;
            }
        } else {
            ModelEvent me = new ModelEvent(this.runningSite, 100);
            me.setLogText("Initial Condition is up to date.\n");
            this.notifyModelUpdate(me);
        }
        return rv;
    }

    private String[] setupEnvironment(String mostexec) {
        SiftShare.log.info("os.name: " + System.getProperty("os.name"));
        if (System.getProperty("os.name").startsWith("Mac OS")) {
            return new String[]{"DYLD_LIBRARY_PATH=" + new File(mostexec).getParent()};
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("linux")) {
            return new String[]{"LD_LIBRARY_PATH=/usr/local/netcdf/lib"};
        }
        return new String[0];
    }

    void setLinearCombinator(LinCombModule linco) {
        this.linearCombinator = linco;
    }

    private class MostResultMonitor
    extends TimerTask {
        private int lastTsCount = 0;
        private FileReader logReader = null;
        private final Pattern errp = Pattern.compile("^.*(error\\W.*)$", 10);
        public String errorMessage = null;

        @Override
        public void run() {
            if (((ModelRunner)ModelRunner.this).mostErrorGobbler.outputOccurred) {
                ModelEvent evt = new ModelEvent(ModelRunner.this.runningSite, 201, ModelRunner.this.runningSite.getTimestepsAvailable());
                evt.setMessage(String.format("MOST error: %s\n", ((ModelRunner)ModelRunner.this).mostErrorGobbler.errorString));
                evt.setLogText(String.format("MOST error: %s\n", ((ModelRunner)ModelRunner.this).mostErrorGobbler.errorString));
                SiftShare.log.log(Level.SEVERE, "MOST error: " + ((ModelRunner)ModelRunner.this).mostErrorGobbler.errorString);
                ModelRunner.this.notifyModelStop(evt);
            }
            String logtext = this.checkOutputLog();
            int tsCount = ModelRunner.this.runningSite.getTimestepsAvailable();
            if (tsCount != this.lastTsCount || logtext != null) {
                ModelEvent evt = new ModelEvent(ModelRunner.this.runningSite, 101, tsCount);
                if (evt.status == 101) {
                    evt.setMessage(String.format("%s running: output step %d of %d", evt.getSourceModel().getName(), evt.getTimesteps(), evt.getSourceModel().getNumberOutputTimesteps()));
                }
                if (logtext != null) {
                    evt.setLogText(logtext);
                }
                ModelRunner.this.notifyModelUpdate(evt);
                this.lastTsCount = tsCount;
            }
        }

        public String checkOutputLog() {
            String logText = null;
            try {
                if (this.logReader == null) {
                    File logf = new File(ModelRunner.this.runningSite.getSiteDirectory(), "output_" + ModelRunner.this.runningSite.getName() + "_" + ModelRunner.this.runningSite.getActiveSourceName() + ".lis");
                    if (logf.exists()) {
                        this.logReader = new FileReader(logf);
                    } else {
                        return null;
                    }
                }
                if (!this.logReader.ready()) {
                    return null;
                }
                StringBuilder readBuf = new StringBuilder(1024);
                char[] inBuf = new char[1024];
                while (this.logReader.ready()) {
                    int chread = this.logReader.read(inBuf);
                    readBuf.append(inBuf, 0, chread);
                }
                if (readBuf.length() <= 0) {
                    return null;
                }
                logText = readBuf.toString();
                Matcher errm = this.errp.matcher(logText);
                if (errm.find()) {
                    this.errorMessage = errm.group(1);
                }
            }
            catch (IOException ioe) {
                SiftShare.log.log(Level.WARNING, "error", ioe);
            }
            return logText;
        }
    }
}

