/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.ModelEvent;
import gov.noaa.tsunami.cmi.ModelListener;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MostBackgroundMonitor
extends TimerTask {
    public static final int POLLING_RATE = 1000;
    private final SiteInfo runningSite;
    public static final String TERM_FILENAME = "shootmenow";
    private final Iterable<ModelListener> listeners;
    Timer resultTimer = null;
    private int lastTsCount = 0;
    private int totalSteps = 0;
    private boolean isRunning = false;
    private boolean stopping = false;
    private FileReader logReader = null;
    private final Pattern errp = Pattern.compile("^.*(finished|cancelled.*)$", 10);
    public String errorMessage = null;

    public MostBackgroundMonitor(SiteInfo site, Iterable<ModelListener> listeners) {
        this.runningSite = site;
        this.listeners = listeners != null ? listeners : Collections.emptyList();
        this.lastTsCount = this.runningSite.getTimestepsAvailable();
        this.totalSteps = this.runningSite.getNumberOutputTimesteps();
        this.resultTimer = new Timer("background Most run monitor: " + this.runningSite.getName(), true);
        this.resultTimer.schedule((TimerTask)this, 500L, 1000L);
    }

    @Override
    public void run() {
        if (this.stopping) {
            this.checkOutputLog();
        } else {
            int tsCount = this.runningSite.getTimestepsAvailable();
            if (tsCount != this.lastTsCount) {
                if (!this.isRunning) {
                    SiftShare.log.info("\n\nFound MOST running in the background: " + this.runningSite.getName() + "\n");
                }
                this.isRunning = true;
                ModelEvent evt = new ModelEvent(this.runningSite, 101, tsCount);
                evt.setMessage(String.format("%s running: output step %d of %d", this.runningSite.getName(), tsCount, this.totalSteps));
                for (ModelListener ml : this.listeners) {
                    ml.modelUpdate(evt);
                }
                this.lastTsCount = tsCount;
            }
            if (tsCount == this.totalSteps) {
                this.stop();
            }
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void stop() {
        this.resultTimer.cancel();
    }

    public void stopModel() {
        OutputStreamWriter fw = null;
        try {
            fw = new FileWriter(new File(this.runningSite.getSiteDirectory(), TERM_FILENAME));
            fw.write("now");
        }
        catch (Exception e) {
            SiftShare.log.log(Level.WARNING, "error writing shootmenow file", e);
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
                System.gc();
            }
            catch (IOException iOException) {}
        }
        this.stopping = true;
    }

    public String checkOutputLog() {
        String logText = null;
        try {
            if (this.logReader == null) {
                File logf = new File(this.runningSite.getSiteDirectory(), "output_" + this.runningSite.getName() + ".lis");
                if (logf.exists()) {
                    this.logReader = new FileReader(logf);
                } else {
                    return null;
                }
            }
            if (!this.logReader.ready()) {
                return null;
            }
            StringBuilder readBuf = new StringBuilder(1024);
            char[] inBuf = new char[1024];
            while (this.logReader.ready()) {
                int chread = this.logReader.read(inBuf);
                readBuf.append(inBuf, 0, chread);
            }
            if (readBuf.length() <= 0) {
                return null;
            }
            logText = readBuf.toString();
            Matcher errm = this.errp.matcher(logText);
            if (errm.find()) {
                this.isRunning = false;
                this.stop();
                ModelEvent evt = new ModelEvent(this.runningSite, 202);
                evt.setMessage("Background model run stopped: " + this.runningSite.getName());
                for (ModelListener ml : this.listeners) {
                    ml.modelStopped(evt);
                }
            }
        }
        catch (IOException ioe) {
            SiftShare.log.log(Level.WARNING, "error", ioe);
        }
        return logText;
    }
}

