/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.PrefsDialog;
import gov.noaa.tsunami.cmi.SiftShare;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class MostExecDownloader {
    public static final String UPDATE_URL_ENV_VAR = "COMMIT_UPDATE_URL";
    public static final int MOST_INUN = 0;
    public static final int MOST_PROP = 1;
    private static int mosttype = 0;
    private Component parentComp;
    private PrefsDialog prefsDialog = null;
    private boolean checkCompleted = false;
    private Properties updateProperties = null;
    private URL updateURL = null;
    private String osname = null;
    private String osarch = null;
    private Runnable successCallback;

    public MostExecDownloader(Component comp) {
        this(comp, null);
    }

    public MostExecDownloader(Component comp, PrefsDialog pd) {
        if (pd != null) {
            this.prefsDialog = pd;
        }
        this.parentComp = comp;
    }

    public Properties getUpdateProperties() {
        if (this.updateProperties != null && this.updateURL != null) {
            return this.updateProperties;
        }
        ArrayList<URL> updateURLS = new ArrayList<URL>();
        try {
            if (System.getenv(UPDATE_URL_ENV_VAR) != null) {
                updateURLS.add(new URL(System.getenv(UPDATE_URL_ENV_VAR)));
            } else {
                updateURLS.add(new URL(CMIUtil.commitServerAddress + "/download/ComMIT.update.properties"));
                updateURLS.add(new URL(String.format(CMIUtil.commitServerAddress + "/download/ComMIT.update.%s.properties", "1.8.6".split(" ")[0])));
            }
        }
        catch (MalformedURLException ex) {
            SiftShare.log.log(Level.SEVERE, null, ex);
        }
        Properties props = new Properties();
        for (URL u : updateURLS) {
            try {
                URLConnection con = u.openConnection();
                con.setConnectTimeout(5000);
                props.load(con.getInputStream());
                this.updateURL = u;
            }
            catch (IOException iOException) {}
        }
        return props;
    }

    public void downloadMOST() {
        try {
            mosttype = 0;
            this.doDownloadMOST();
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.WARNING, "Download error", ex);
            JOptionPane.showMessageDialog(null, String.format("An error occurred while downloading the MOST executable:\n%s", ex.getMessage()));
        }
    }

    public void downloadMOSTProp() {
        try {
            mosttype = 1;
            this.doDownloadMOST();
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.WARNING, "Download error", ex);
            JOptionPane.showMessageDialog(null, String.format("An error occurred while downloading the MOST executable:\n%s", ex.getMessage()));
        }
    }

    private String findPlatformValue(Properties props, String baseName) {
        String[] keys;
        if (this.osarch == null) {
            this.osarch = System.getProperty("os.arch");
        }
        if (this.osname == null) {
            this.osname = System.getProperty("os.name");
            this.osname = this.osname.split(" ", 2)[0];
            if (this.osname.equals("Linux")) {
                this.osarch = this.getLinuxArch();
            }
        }
        for (String k : keys = new String[]{baseName + "." + this.osname + "." + this.osarch, baseName + "." + this.osname, baseName}) {
            String v = props.getProperty(k);
            if (v == null) continue;
            Pattern subp = Pattern.compile("\\{(.+)\\}");
            Matcher m = subp.matcher(v);
            while (m.find()) {
                v = m.replaceFirst(props.getProperty(m.group(1), ""));
                m = subp.matcher(v);
            }
            return v;
        }
        return null;
    }

    private void doDownloadMOST() throws IOException {
        Properties prop = this.getUpdateProperties();
        SiftShare.log.info("Updating for os.name: " + this.osname + "  os.arch: " + this.osarch);
        if (prop.isEmpty() || this.updateURL == null) {
            throw new IOException("Could not get ComMIT update information from the server. Check your Internet connection.");
        }
        String mostExec = "";
        if (mosttype == 0) {
            mostExec = this.findPlatformValue(prop, "MOST.exec");
        } else if (mosttype == 1) {
            mostExec = this.findPlatformValue(prop, "MOSTDB.exec");
        }
        String mostLibs = this.findPlatformValue(prop, "MOST.libs");
        boolean unixish = this.osname != null && (this.osname.startsWith("Linux") || this.osname.startsWith("Mac"));
        int revnum = this.getLatestMOSTRevision(prop, mosttype);
        if (mostExec == null) {
            String msg = String.format("No MOST executable is currently available for your\noperating system (%s) and architecture (%s).", this.osname, this.osarch);
            throw new IOException(msg);
        }
        URL mostExecURL = new URL(this.updateURL, mostExec);
        SiftShare.log.info("downloading MOST executable: " + mostExecURL.toString());
        Thread downloadThread = new Thread(new pmWorker(new URL(this.updateURL, mostExec), new File(mostExec).getName(), revnum, unixish));
        downloadThread.start();
        if (mostLibs != null) {
            for (String sl : mostLibs.split(";")) {
                File supportLib = new File(sl);
                Thread slThread = new Thread(new pmWorker(new URL(this.updateURL, sl), supportLib.getName(), -1, false));
                slThread.start();
            }
        }
        this.checkCompleted = true;
    }

    private String getLinuxArch() {
        String result = "i386";
        Runtime rt = Runtime.getRuntime();
        try {
            String inputLine;
            Process proc = rt.exec("uname -i");
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((inputLine = br.readLine()) != null) {
                if (inputLine.indexOf("i386") >= 0) {
                    result = "i386";
                    continue;
                }
                if (inputLine.indexOf("x86_64") < 0) continue;
                result = "x86_64";
            }
        }
        catch (IOException e) {
            SiftShare.log.log(Level.WARNING, "error", e);
        }
        return result;
    }

    public void recheckUpdateServer() {
        this.updateProperties = null;
        this.updateURL = null;
    }

    public boolean isCheckCompleted() {
        return this.checkCompleted;
    }

    public int getLatesteMOSTRevision() {
        return this.getLatestMOSTRevision(0);
    }

    public int getLatestMOSTRevision(int type) {
        return this.getLatestMOSTRevision(this.getUpdateProperties(), type);
    }

    public int getLatestMOSTRevision(Properties props, int type) {
        try {
            String v = "";
            v = type == 0 ? this.findPlatformValue(props, "MOST.revision") : this.findPlatformValue(props, "MOSTDB.revision");
            return Integer.parseInt(v != null ? v : "-1");
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public void initialCheckForMostUpdate(final Component dlgparent, final int type) {
        String m;
        int hasrev;
        if (CMIUtil.workOffline || this.isCheckCompleted()) {
            return;
        }
        final int mostrev = this.getLatestMOSTRevision(type);
        if (type == 0) {
            mosttype = 0;
            hasrev = CMIUtil.MOST_REV;
            m = "MOST";
        } else {
            mosttype = 1;
            hasrev = CMIUtil.MOSTProp_REV;
            m = "Propagation MOST";
        }
        SiftShare.log.info(String.format("Latest version of " + m + " is %d; current local version is %d", mostrev, hasrev));
        if (mostrev > hasrev) {
            Runnable uithread = new Runnable(){

                @Override
                public void run() {
                    String msg = String.format("A new version of " + m + " (revision %d) is available.\nYou are currently running revision %d.\n\nDownload update?", mostrev, hasrev);
                    int result = JOptionPane.showConfirmDialog(dlgparent, msg, "MOST Update Available", 0, 3);
                    if (result == 0) {
                        if (type == 0) {
                            MostExecDownloader.this.downloadMOST();
                        } else {
                            MostExecDownloader.this.downloadMOSTProp();
                        }
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                uithread.run();
            } else {
                SwingUtilities.invokeLater(uithread);
            }
        }
    }

    public void setCompletionCallback(Runnable runnable) {
        this.successCallback = runnable;
    }

    private class pmWorker
    implements Runnable {
        URL durl;
        String mostExec;
        boolean isLinux;
        int revnum;

        public pmWorker(URL d, String m, int r, boolean i) {
            this.durl = d;
            this.mostExec = m;
            this.isLinux = i;
            this.revnum = r;
        }

        @Override
        public void run() {
            SiftShare.log.info("in MostExecDownloader.writeMOST (pmWorker thread)");
            boolean can = false;
            try {
                int c;
                File f = new File(CMIUtil.baseDirName + File.separator + "bin" + File.separator + this.mostExec);
                File tmpFile = File.createTempFile("mostExec", null, new File(CMIUtil.baseDirName, "bin"));
                tmpFile.deleteOnExit();
                HttpURLConnection uc = (HttpURLConnection)this.durl.openConnection();
                uc.setConnectTimeout(7000);
                uc.connect();
                int downloadSize = uc.getContentLength();
                ProgressMonitor pm = new ProgressMonitor(MostExecDownloader.this.parentComp, "Downloading MOST Executable", "", 0, downloadSize);
                pm.setMillisToDecideToPopup(200);
                InputStream is = uc.getInputStream();
                FileOutputStream out = new FileOutputStream(tmpFile);
                int nread = 0;
                byte[] buffer = new byte[1024];
                while ((c = is.read(buffer)) != -1) {
                    if (c > 0) {
                        pm.setProgress(nread += c);
                    }
                    if (pm.isCanceled()) {
                        is.close();
                        out.close();
                        tmpFile.delete();
                        can = true;
                        break;
                    }
                    out.write(buffer, 0, c);
                }
                is.close();
                out.close();
                if (!can) {
                    f.delete();
                    tmpFile.renameTo(f);
                    if (this.isLinux) {
                        Runtime.getRuntime().exec("/bin/chmod +x " + f.getPath());
                    }
                    if (this.revnum >= 0) {
                        if (mosttype == 0) {
                            CMIUtil.MOST_EXEC = f.getPath();
                            CMIUtil.MOST_REV = this.revnum;
                        } else if (mosttype == 1) {
                            CMIUtil.MOSTProp_EXEC = f.getPath();
                            CMIUtil.MOSTProp_REV = this.revnum;
                        }
                    }
                    if (MostExecDownloader.this.prefsDialog != null) {
                        MostExecDownloader.this.prefsDialog.savePrefs();
                    }
                    pm.close();
                    System.gc();
                    SiftShare.log.info(this.durl.toString() + "\nDownloaded file: " + this.mostExec + ", number ints read in download: " + nread);
                } else {
                    SiftShare.log.info("download cancelled: " + this.mostExec);
                }
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(MostExecDownloader.this.parentComp, "Unable to download MOST\n\n" + e.getMessage(), "Error", 0);
                SiftShare.log.log(Level.WARNING, "Error downloading MOST executable", e);
                return;
            }
            if (this.revnum >= 0 && MostExecDownloader.this.successCallback != null) {
                SwingUtilities.invokeLater(MostExecDownloader.this.successCallback);
            }
        }
    }
}

