/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.GridSelectorPanel;
import gov.noaa.tsunami.cmi.SMaxImagePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MostExtremaPanel
extends JPanel {
    private final SMaxImagePanel sMaxImagePanel;
    protected DecimalFormat dfxxxx = new DecimalFormat("0.0000");
    protected DecimalFormat dfxx = new DecimalFormat("0.00");
    private JLabel depthLabel;
    private JTextField depthTextField;
    private GridSelectorPanel gridSelectorPanel1;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel6;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JSpinner jSpinner1;
    private JToolBar jToolBar1;
    private JTextField latTextField;
    private JTextField lonTextField;
    private JPanel maxPanel;
    private JTextField valueTextField;
    private JButton vectorsButton;

    public MostExtremaPanel() {
        this.initComponents();
        this.jSpinner1.getModel().setValue("10.0");
        this.sMaxImagePanel = new SMaxImagePanel();
        this.sMaxImagePanel.setGridSelectorControl(this.gridSelectorPanel1);
        this.maxPanel.add((Component)this.sMaxImagePanel, "Center");
        this.sMaxImagePanel.setMEP(this);
    }

    public SMaxImagePanel getSMaxImagePanel() {
        return this.sMaxImagePanel;
    }

    public void setLongitude(double lon) {
        this.lonTextField.setText(this.dfxxxx.format(lon));
    }

    public void setLatitude(double lat) {
        this.latTextField.setText(this.dfxxxx.format(lat));
    }

    public void setExtrema(double x) {
        this.valueTextField.setText(this.dfxx.format(x));
    }

    public void setDepth(double d) {
        this.depthTextField.setText(this.dfxx.format(d));
    }

    private void initComponents() {
        this.maxPanel = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.gridSelectorPanel1 = new GridSelectorPanel();
        this.jComboBox1 = new JComboBox();
        this.valueTextField = new JTextField();
        this.jSeparator4 = new JToolBar.Separator();
        this.depthLabel = new JLabel();
        this.depthTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.lonTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.latTextField = new JTextField();
        this.jSeparator1 = new JToolBar.Separator();
        this.vectorsButton = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jSpinner1 = new JSpinner();
        this.jLabel6 = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setLayout(new BorderLayout());
        this.maxPanel.setLayout(new BorderLayout());
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setMinimumSize(new Dimension(1092, 39));
        this.gridSelectorPanel1.setMinimumSize(new Dimension(180, 35));
        this.jToolBar1.add(this.gridSelectorPanel1);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Max Amp [cm]:", "Flow Depth [cm]:", "Min Amp [cm]:", "Max Speed [cm/s]:"}));
        this.jComboBox1.setMaximumSize(new Dimension(168, 32));
        this.jComboBox1.setMinimumSize(new Dimension(168, 27));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MostExtremaPanel.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jComboBox1);
        this.valueTextField.setEditable(false);
        this.valueTextField.setBackground(new Color(204, 204, 204));
        this.valueTextField.setColumns(8);
        this.valueTextField.setText("123.12");
        this.valueTextField.setMaximumSize(new Dimension(110, 28));
        this.valueTextField.setMinimumSize(new Dimension(110, 28));
        this.valueTextField.setPreferredSize(new Dimension(80, 28));
        this.jToolBar1.add(this.valueTextField);
        this.jToolBar1.add(this.jSeparator4);
        this.depthLabel.setText(", Depth [m]:");
        this.jToolBar1.add(this.depthLabel);
        this.depthTextField.setEditable(false);
        this.depthTextField.setBackground(new Color(204, 204, 204));
        this.depthTextField.setText("-5,000.00");
        this.depthTextField.setMaximumSize(new Dimension(110, 28));
        this.depthTextField.setMinimumSize(new Dimension(110, 28));
        this.jToolBar1.add(this.depthTextField);
        this.jLabel1.setText("Lon:");
        this.jToolBar1.add(this.jLabel1);
        this.lonTextField.setEditable(false);
        this.lonTextField.setBackground(new Color(204, 204, 204));
        this.lonTextField.setText("-12.34567");
        this.lonTextField.setMaximumSize(new Dimension(110, 28));
        this.lonTextField.setMinimumSize(new Dimension(110, 28));
        this.jToolBar1.add(this.lonTextField);
        this.jLabel2.setText("Lat:");
        this.jToolBar1.add(this.jLabel2);
        this.latTextField.setEditable(false);
        this.latTextField.setBackground(new Color(204, 204, 204));
        this.latTextField.setText("123.45678");
        this.latTextField.setMaximumSize(new Dimension(110, 28));
        this.latTextField.setMinimumSize(new Dimension(110, 28));
        this.jToolBar1.add(this.latTextField);
        this.jToolBar1.add(this.jSeparator1);
        this.vectorsButton.setText("Currents");
        this.vectorsButton.setFocusable(false);
        this.vectorsButton.setHorizontalTextPosition(0);
        this.vectorsButton.setVerticalTextPosition(3);
        this.vectorsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MostExtremaPanel.this.vectorsButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.vectorsButton);
        this.jToolBar1.add(this.jSeparator3);
        this.jSpinner1.setModel(new SpinnerListModel(new String[]{"0.1", "0.2", "0.5", "1.0", "2.0", "5.0", "10.0", "20.0", "50.0", "100.0", "200.0", "500.0", "1000.0"}));
        this.jSpinner1.setMaximumSize(new Dimension(90, 28));
        this.jSpinner1.setPreferredSize(new Dimension(90, 28));
        this.jSpinner1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MostExtremaPanel.this.jSpinner1StateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jSpinner1);
        this.jLabel6.setIcon(new ImageIcon(this.getClass().getResource("/gov/noaa/tsunami/cmi/images/arrow.png")));
        this.jLabel6.setText("[cm/s]");
        this.jToolBar1.add(this.jLabel6);
        this.maxPanel.add((Component)this.jToolBar1, "First");
        this.add((Component)this.maxPanel, "Center");
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        int i = this.jComboBox1.getSelectedIndex();
        this.sMaxImagePanel.setExtrema(i);
    }

    private void jSpinner1StateChanged(ChangeEvent evt) {
        String val = (String)this.jSpinner1.getValue();
        double dval = Double.parseDouble(val);
        if (this.sMaxImagePanel != null) {
            this.sMaxImagePanel.setVectorScale(0.085 / dval);
        }
    }

    private void vectorsButtonActionPerformed(ActionEvent evt) {
        if (this.vectorsButton.getText().equals("Currents")) {
            this.vectorsButton.setText("Hide");
            this.sMaxImagePanel.showVectors();
            String[] vals = new String[]{"0.1", "0.2", "0.5", "1.0", "2.0", "5.0", "10.0", "20.0", "50.0", "100.0", "200.0", "500.0", "1000.0"};
            double m = this.sMaxImagePanel.getMax();
            for (int i = 1; i < vals.length; ++i) {
                if (!(Double.parseDouble(vals[i]) > m)) continue;
                this.jSpinner1.setValue(vals[--i]);
                break;
            }
            this.sMaxImagePanel.readGrid();
        } else {
            this.vectorsButton.setText("Currents");
            this.sMaxImagePanel.hideVectors();
            this.sMaxImagePanel.readGrid();
        }
    }
}

