/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.pmel.util.Point2D;
import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.GridSelectorPanel;
import gov.noaa.tsunami.cmi.MOSTGrid;
import gov.noaa.tsunami.cmi.ModelEvent;
import gov.noaa.tsunami.cmi.ModelListener;
import gov.noaa.tsunami.cmi.SAnimPanel;
import gov.noaa.tsunami.cmi.STSPanel;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import gov.noaa.tsunami.cmi.TideGaugeClient;
import gov.noaa.tsunami.cmi.TideStationMetadata;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SpinnerListModel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public final class MostResultsPanel
extends JPanel
implements ActionListener,
ChangeListener,
PropertyChangeListener,
ModelListener {
    private final Timer animationTimer;
    private static final ImageIcon runIcon;
    private static final ImageIcon stopIcon;
    private static final int SPEED_SLIDER_MAX = 400;
    private static final int SPEED_SLIDER_MIN = 2;
    private int timeStep = 0;
    private boolean adjustingSliderMax = false;
    private final SAnimPanel sAnimPanel;
    private final STSPanel sTSPanel;
    private int gridShowing;
    private static final NumberFormat dfx;
    private static final NumberFormat dfxxxx;
    private boolean lastFrameRequested = false;
    private SiteInfo currentSite = null;
    private Point2D.Double timeseriesLocation;
    private boolean ignoreUpdates = false;
    private JFormattedTextField ampFormattedTextField;
    private JPanel animPanel;
    private JFormattedTextField depthFormattedTextField;
    private JButton fastForwardButton;
    private GridSelectorPanel gridSelectorPanel;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JToolBar.Separator jSeparator10;
    private JToolBar.Separator jSeparator11;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JToolBar.Separator jSeparator7;
    private JToolBar.Separator jSeparator8;
    private JToolBar.Separator jSeparator9;
    private JSpinner jSpinner1;
    private JSplitPane jSplitPane1;
    private JToolBar jToolBar1;
    private JFormattedTextField latFormattedTextField;
    private JFormattedTextField lonFormattedTextField;
    private JButton rewindButton;
    private JButton runStopButton;
    private JButton stepBackButton;
    private JButton stepForwardButton;
    private JPanel tsPanel;
    private JButton vectorsButton;

    public MostResultsPanel() {
        this.initComponents();
        this.jSpinner1.getModel().setValue("25.0");
        this.lonFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(dfxxxx)));
        this.latFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(dfxxxx)));
        this.depthFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(dfx)));
        this.sTSPanel = new STSPanel(this);
        this.tsPanel.add((Component)this.sTSPanel, "Center");
        this.addPropertyChangeListener(this.sTSPanel);
        this.gridSelectorPanel.addPropertyChangeListener("selectedGrid", this.sTSPanel);
        this.sTSPanel.setSelectedGrid(this.gridSelectorPanel.getSelectedGrid());
        this.addPropertyChangeListener("timeseriesLocation", this);
        this.sAnimPanel = new SAnimPanel();
        this.animPanel.add((Component)this.sAnimPanel, "Center");
        this.sAnimPanel.addActionListener(this);
        this.addPropertyChangeListener(this.sAnimPanel);
        this.sAnimPanel.setGridSelectorControl(this.gridSelectorPanel);
        this.gridSelectorPanel.addPropertyChangeListener(this);
        this.runStopButton.setIcon(runIcon);
        this.animationTimer = new Timer(1000, this);
        this.gridShowing = 1;
        this.getInputMap(1).put(KeyStroke.getKeyStroke("RIGHT"), "advance step");
        this.getActionMap().put("advance step", new RightStepAction());
        this.getInputMap(1).put(KeyStroke.getKeyStroke("LEFT"), "rewind step");
        this.getActionMap().put("rewind step", new LeftStepAction());
        this.sAnimPanel.getInputMap(1).put(KeyStroke.getKeyStroke("RIGHT"), "advance step");
        this.sAnimPanel.getActionMap().put("advance step", new RightStepAction());
        this.sAnimPanel.getInputMap(1).put(KeyStroke.getKeyStroke("LEFT"), "rewind step");
        this.sAnimPanel.getActionMap().put("rewind step", new LeftStepAction());
        this.setFocusable(true);
    }

    public int getSplitPanePosition() {
        return this.jSplitPane1.getDividerLocation();
    }

    public void setSplitPanePosition(int pos) {
        this.jSplitPane1.setDividerLocation(pos);
    }

    public MOSTGrid getMostGrid() {
        return this.sAnimPanel.getMostGrid();
    }

    private void updatePanel() {
        SiftShare.log.finest("updatePanel  tscount " + this.getTimeStepCount());
        if (this.getTimeStep() >= this.getTimeStepCount()) {
            this.setTimeStep(this.getTimeStepCount() - 1);
        }
    }

    private void initComponents() {
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.jSplitPane1 = new JSplitPane();
        this.animPanel = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.gridSelectorPanel = new GridSelectorPanel();
        this.rewindButton = new JButton();
        this.stepBackButton = new JButton();
        this.runStopButton = new JButton();
        this.stepForwardButton = new JButton();
        this.fastForwardButton = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jSeparator7 = new JToolBar.Separator();
        this.jSeparator8 = new JToolBar.Separator();
        JLabel jLabel1 = new JLabel();
        this.latFormattedTextField = new JFormattedTextField();
        this.jSeparator3 = new JToolBar.Separator();
        JLabel jLabel2 = new JLabel();
        this.lonFormattedTextField = new JFormattedTextField();
        this.jSeparator4 = new JToolBar.Separator();
        JLabel jLabel3 = new JLabel();
        this.depthFormattedTextField = new JFormattedTextField();
        this.jLabel4 = new JLabel();
        this.ampFormattedTextField = new JFormattedTextField();
        this.jLabel5 = new JLabel();
        this.jSeparator9 = new JToolBar.Separator();
        this.jSeparator10 = new JToolBar.Separator();
        this.vectorsButton = new JButton();
        this.jSeparator11 = new JToolBar.Separator();
        this.jSpinner1 = new JSpinner();
        this.jLabel6 = new JLabel();
        this.tsPanel = new JPanel();
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(600);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPane1.setContinuousLayout(true);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.animPanel.setMinimumSize(new Dimension(200, 150));
        this.animPanel.setPreferredSize(new Dimension(1000, 700));
        this.animPanel.setLayout(new BorderLayout());
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setMaximumSize(new Dimension(2752, 40));
        this.jToolBar1.setMinimumSize(new Dimension(903, 40));
        this.jToolBar1.setPreferredSize(new Dimension(668, 34));
        this.jToolBar1.add(this.gridSelectorPanel);
        this.rewindButton.setIcon(new ImageIcon(this.getClass().getResource("/gov/noaa/tsunami/cmi/images/Rewind16.gif")));
        this.rewindButton.setToolTipText("First frame");
        this.rewindButton.setPreferredSize(new Dimension(28, 20));
        this.rewindButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MostResultsPanel.this.rewindButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.rewindButton);
        this.stepBackButton.setIcon(new ImageIcon(this.getClass().getResource("/gov/noaa/tsunami/cmi/images/StepBack16.gif")));
        this.stepBackButton.setToolTipText("Previous frame");
        this.stepBackButton.setMinimumSize(new Dimension(28, 20));
        this.stepBackButton.setPreferredSize(new Dimension(28, 20));
        this.stepBackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MostResultsPanel.this.stepBackButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.stepBackButton);
        this.runStopButton.setToolTipText("Start/Stop animation");
        this.runStopButton.setMaximumSize(new Dimension(28, 20));
        this.runStopButton.setMinimumSize(new Dimension(28, 20));
        this.runStopButton.setPreferredSize(new Dimension(28, 20));
        this.runStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MostResultsPanel.this.runStopButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.runStopButton);
        this.stepForwardButton.setIcon(new ImageIcon(this.getClass().getResource("/gov/noaa/tsunami/cmi/images/StepForward16.gif")));
        this.stepForwardButton.setToolTipText("Next frame");
        this.stepForwardButton.setMinimumSize(new Dimension(28, 20));
        this.stepForwardButton.setPreferredSize(new Dimension(28, 20));
        this.stepForwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MostResultsPanel.this.stepForwardButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.stepForwardButton);
        this.fastForwardButton.setIcon(new ImageIcon(this.getClass().getResource("/gov/noaa/tsunami/cmi/images/FastForward16.gif")));
        this.fastForwardButton.setToolTipText("Last frame");
        this.fastForwardButton.setMinimumSize(new Dimension(28, 20));
        this.fastForwardButton.setPreferredSize(new Dimension(28, 20));
        this.fastForwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MostResultsPanel.this.fastForwardButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.fastForwardButton);
        this.jToolBar1.add(this.jSeparator2);
        this.jToolBar1.add(this.jSeparator7);
        this.jToolBar1.add(this.jSeparator8);
        jLabel1.setText("Lat: ");
        this.jToolBar1.add(jLabel1);
        this.latFormattedTextField.setHorizontalAlignment(0);
        this.latFormattedTextField.setText("0.0");
        this.latFormattedTextField.setMaximumSize(new Dimension(80, 24));
        this.latFormattedTextField.setMinimumSize(new Dimension(4, 24));
        this.latFormattedTextField.setPreferredSize(new Dimension(80, 24));
        this.latFormattedTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MostResultsPanel.this.latFormattedTextFieldPropertyChange(evt);
            }
        });
        this.jToolBar1.add(this.latFormattedTextField);
        this.jToolBar1.add(this.jSeparator3);
        jLabel2.setText(" Lon: ");
        this.jToolBar1.add(jLabel2);
        this.lonFormattedTextField.setHorizontalAlignment(0);
        this.lonFormattedTextField.setText("0.0");
        this.lonFormattedTextField.setMaximumSize(new Dimension(80, 24));
        this.lonFormattedTextField.setMinimumSize(new Dimension(4, 24));
        this.lonFormattedTextField.setPreferredSize(new Dimension(80, 24));
        this.lonFormattedTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MostResultsPanel.this.lonFormattedTextFieldPropertyChange(evt);
            }
        });
        this.jToolBar1.add(this.lonFormattedTextField);
        this.jToolBar1.add(this.jSeparator4);
        jLabel3.setText("Depth: ");
        this.jToolBar1.add(jLabel3);
        this.depthFormattedTextField.setEditable(false);
        this.depthFormattedTextField.setHorizontalAlignment(0);
        this.depthFormattedTextField.setText("0.0");
        this.depthFormattedTextField.setMaximumSize(new Dimension(80, 24));
        this.depthFormattedTextField.setMinimumSize(new Dimension(4, 24));
        this.depthFormattedTextField.setPreferredSize(new Dimension(80, 24));
        this.jToolBar1.add(this.depthFormattedTextField);
        this.jLabel4.setText("[m],  Amp:");
        this.jToolBar1.add(this.jLabel4);
        this.ampFormattedTextField.setEditable(false);
        this.ampFormattedTextField.setHorizontalAlignment(0);
        this.ampFormattedTextField.setText("0.0");
        this.ampFormattedTextField.setMaximumSize(new Dimension(80, 24));
        this.ampFormattedTextField.setMinimumSize(new Dimension(4, 24));
        this.jToolBar1.add(this.ampFormattedTextField);
        this.jLabel5.setText("[cm]");
        this.jToolBar1.add(this.jLabel5);
        this.jToolBar1.add(this.jSeparator9);
        this.jToolBar1.add(this.jSeparator10);
        this.vectorsButton.setText("Currents");
        this.vectorsButton.setFocusable(false);
        this.vectorsButton.setHorizontalTextPosition(0);
        this.vectorsButton.setVerticalTextPosition(3);
        this.vectorsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MostResultsPanel.this.vectorsButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.vectorsButton);
        this.jToolBar1.add(this.jSeparator11);
        this.jSpinner1.setModel(new SpinnerListModel(new String[]{"0.1", "0.25", "0.5", "1.0", "2.5", "5.0", "10.0", "25.0", "50.0", "100.0", "250.0", "500.0", "1000.0"}));
        this.jSpinner1.setMaximumSize(new Dimension(90, 28));
        this.jSpinner1.setPreferredSize(new Dimension(90, 28));
        this.jSpinner1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MostResultsPanel.this.jSpinner1StateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jSpinner1);
        this.jLabel6.setIcon(new ImageIcon(this.getClass().getResource("/gov/noaa/tsunami/cmi/images/arrow.png")));
        this.jLabel6.setText("[cm/s]");
        this.jToolBar1.add(this.jLabel6);
        this.animPanel.add((Component)this.jToolBar1, "First");
        this.jSplitPane1.setLeftComponent(this.animPanel);
        this.tsPanel.setBackground(new Color(255, 255, 255));
        this.tsPanel.setMinimumSize(new Dimension(100, 10));
        this.tsPanel.setPreferredSize(new Dimension(800, 60));
        this.tsPanel.setLayout(new BorderLayout());
        this.jSplitPane1.setRightComponent(this.tsPanel);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void lonFormattedTextFieldPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("value") && this.lonFormattedTextField.getValue() != null) {
            Point2D.Double tspt = new Point2D.Double(((Number)this.lonFormattedTextField.getValue()).doubleValue(), this.getTimeseriesLocation().y);
            this.setTimeseriesLocation(tspt);
        }
    }

    private void latFormattedTextFieldPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("value") && this.latFormattedTextField.getValue() != null) {
            Point2D.Double tspt = new Point2D.Double(this.getTimeseriesLocation().x, ((Number)this.latFormattedTextField.getValue()).doubleValue());
            this.setTimeseriesLocation(tspt);
        }
    }

    private void fastForwardButtonActionPerformed(ActionEvent evt) {
        if (this.animationTimer.isRunning()) {
            this.stopAnimation();
        }
        this.setTimeStep(this.getTimeStepCount() - 1);
        this.lastFrameRequested = true;
        this.requestFocusInWindow();
    }

    private void stepForwardButtonActionPerformed(ActionEvent evt) {
        this.setTimeStep(this.getTimeStep() + 1);
        this.lastFrameRequested = false;
        this.requestFocusInWindow();
    }

    private void runStopButtonActionPerformed(ActionEvent evt) {
        this.lastFrameRequested = false;
        if (this.animationTimer.isRunning()) {
            this.stopAnimation();
        } else {
            this.runStopButton.setIcon(stopIcon);
            this.animationTimer.setDelay(200);
            this.animationTimer.start();
        }
        this.requestFocusInWindow();
    }

    private void stepBackButtonActionPerformed(ActionEvent evt) {
        this.setTimeStep(this.getTimeStep() - 1);
        this.lastFrameRequested = false;
        this.requestFocusInWindow();
    }

    private void rewindButtonActionPerformed(ActionEvent evt) {
        this.setTimeStep(0);
        this.lastFrameRequested = false;
        this.requestFocusInWindow();
    }

    private void vectorsButtonActionPerformed(ActionEvent evt) {
        if (this.vectorsButton.getText().equals("Currents")) {
            this.vectorsButton.setText("Hide");
            this.sAnimPanel.showVectors();
            this.sAnimPanel.readGrid();
        } else {
            this.vectorsButton.setText("Currents");
            this.sAnimPanel.hideVectors();
            this.sAnimPanel.readGrid();
        }
        this.requestFocusInWindow();
    }

    private void jSpinner1StateChanged(ChangeEvent evt) {
        String val = (String)this.jSpinner1.getValue();
        double dval = Double.parseDouble(val);
        if (this.sAnimPanel != null) {
            this.sAnimPanel.setVectorScale(0.085 / dval);
        }
    }

    public void saveTimeseries() {
        this.sTSPanel.saveTimeseries();
    }

    public boolean contoursPlotted() {
        return this.sAnimPanel.contoursPlotted();
    }

    public SAnimPanel getSAnimPanel() {
        return this.sAnimPanel;
    }

    public int getGridShowing() {
        return this.gridShowing;
    }

    public void setGridShowing(int gridID) {
        this.gridSelectorPanel.setSelectedGrid(gridID);
    }

    public void stickToLastFrame(boolean b) {
        this.lastFrameRequested = b;
    }

    private void enableAnimButtons(boolean b) {
        this.rewindButton.setEnabled(b);
        this.stepBackButton.setEnabled(b);
        this.runStopButton.setEnabled(b);
        this.stepForwardButton.setEnabled(b);
        this.fastForwardButton.setEnabled(b);
        this.latFormattedTextField.setEnabled(b);
        this.lonFormattedTextField.setEnabled(b);
        this.gridSelectorPanel.setEnabled(b);
    }

    public void setIgnoreUpdates(boolean b) {
        this.ignoreUpdates = b;
    }

    public void saveAllImages() {
        this.stopAnimation();
        this.enableAnimButtons(false);
        try {
            for (int tp = 0; tp < this.getTimeStepCount(); ++tp) {
                this.setTimeStep(tp);
                this.repaint();
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException ignore) {
                    break;
                }
                this.saveImage(tp);
            }
        }
        catch (Exception e) {
            SiftShare.log.log(Level.WARNING, "error calling saveImage", e);
        }
        this.stopAnimation();
        this.enableAnimButtons(true);
    }

    public void saveImage(int t) {
        File f = new File(this.currentSite.getSiteDirectory(), "images");
        if (!f.exists()) {
            f.mkdir();
        }
        f = new File(f, String.format("grid%s%04d.png", BathyGrid.getGridLetter(this.gridShowing), t + 1));
        this.sAnimPanel.savePanelImage(f, false, true, true);
    }

    public int getTimeStep() {
        return this.timeStep;
    }

    public void setTimeStep(int t) {
        int tt2 = t;
        if (tt2 >= this.getTimeStepCount()) {
            tt2 = this.getTimeStepCount() - 1;
        }
        if (tt2 < 0) {
            tt2 = 0;
        }
        if (tt2 != this.timeStep) {
            int oldts = this.timeStep;
            this.timeStep = tt2;
            this.firePropertyChange("timeStep", oldts, this.timeStep);
            this.ampFormattedTextField.setText(dfx.format(this.sTSPanel.getModelAtStep(this.timeStep)));
        }
    }

    public int getTimeStepCount() {
        return this.sAnimPanel != null && this.sAnimPanel.getMostGrid() != null ? this.sAnimPanel.getMostGrid().getNumberOfTimeSteps() : 0;
    }

    public void setTimeseriesLocation(Point2D.Double pt) {
        boolean inside = false;
        if (pt == null || this.currentSite == null) {
            return;
        }
        SiftShare.log.fine("ts loc: " + pt.x + " " + pt.y + " site: " + this.currentSite.getName() + " source: " + this.currentSite.getActiveSourceName());
        Point2D.Double oldtl = this.timeseriesLocation;
        this.timeseriesLocation = pt;
        inside = this.currentSite.setTimeseriesLocation(this.gridShowing, pt.x, pt.y);
        if (inside) {
            this.firePropertyChange("timeseriesLocation", oldtl, this.timeseriesLocation);
        } else {
            oldtl = this.currentSite.getTimeseriesLocation(this.gridShowing);
            this.firePropertyChange("timeseriesLocation", this.timeseriesLocation, oldtl);
        }
        this.ampFormattedTextField.setText(dfx.format(this.sTSPanel.getModelAtStep(this.timeStep)));
    }

    public Point2D.Double getTimeseriesLocation() {
        if (this.timeseriesLocation == null) {
            this.timeseriesLocation = this.currentSite.getTimeseriesLocation(this.gridShowing);
        }
        return this.timeseriesLocation;
    }

    public double getTimeseriesDepth() {
        double depth = -9999.0;
        if (this.timeseriesLocation == null) {
            this.currentSite.getTimeseriesLocation(this.gridShowing);
        }
        try {
            depth = this.currentSite.getBathyGrid(this.getGridShowing()).getValueAt(this.timeseriesLocation.x, this.timeseriesLocation.y);
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.WARNING, "Can't find depth", ex);
        }
        return depth;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.animationTimer.isRunning()) {
            int newts = this.getTimeStep() + 1;
            if (newts >= this.getTimeStepCount()) {
                newts = 0;
            }
            this.setTimeStep(newts);
        }
    }

    public void closeFiles() {
        this.sAnimPanel.closeFile();
    }

    public void stopAnimation() {
        this.runStopButton.setIcon(runIcon);
        this.animationTimer.stop();
    }

    public void plotGaugeLocation() {
        if (this.currentSite != null) {
            ArrayList<TideStationMetadata> tsm;
            if (!TideGaugeClient.getGaugeLocsParsed()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    SiftShare.log.log(Level.SEVERE, null, ex);
                }
            }
            if ((tsm = this.currentSite.getTideStationMetadata()).size() > 0) {
                double[] lonLat = tsm.get(0).getLonLat();
                this.sAnimPanel.setGaugeLocation(lonLat[0], lonLat[1]);
                SiftShare.log.info("Found tide gauge for site: " + tsm);
            } else {
                SiftShare.log.info("No tide gauge for site: " + this.currentSite.getName());
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propname = evt.getPropertyName();
        if ("currentSite".equals(propname)) {
            SiteInfo site = (SiteInfo)evt.getNewValue();
            if (site == null) {
                this.currentSite = site;
                this.stopAnimation();
                this.enableAnimButtons(false);
            } else if (!site.equals(this.currentSite)) {
                this.currentSite = site;
                this.stopAnimation();
                this.updatePanel();
                this.enableAnimButtons(true);
                this.setTimeseriesLocation(site.getTimeseriesLocation(this.getGridShowing()));
            }
            this.plotGaugeLocation();
            this.sAnimPanel.propertyChange(evt);
            this.sTSPanel.propertyChange(evt);
            this.requestFocusInWindow();
        } else if ("timeseriesLocation".equals(propname) && this.currentSite != null) {
            Point2D.Double tspt = (Point2D.Double)evt.getNewValue();
            if (tspt != null) {
                this.lonFormattedTextField.setText(dfxxxx.format(tspt.x));
                this.latFormattedTextField.setText(dfxxxx.format(tspt.y));
                try {
                    BathyGrid bgt = this.currentSite.getBathyGrid(this.getGridShowing());
                    this.depthFormattedTextField.setText(dfx.format(bgt.getValueAt(tspt.x, tspt.y)));
                }
                catch (IOException ex) {
                    this.depthFormattedTextField.setText("ERR");
                }
            } else {
                this.latFormattedTextField.setText(null);
                this.lonFormattedTextField.setText(null);
                this.depthFormattedTextField.setText(null);
            }
            this.requestFocusInWindow();
        } else if ("selectedGrid".equals(propname)) {
            this.gridShowing = this.gridSelectorPanel.getSelectedGrid();
            this.sTSPanel.setSelectedGrid(this.gridShowing);
            this.setTimeseriesLocation(this.currentSite.getTimeseriesLocation(this.getGridShowing()));
            this.requestFocusInWindow();
        } else if ("sourceSwitched".equals(propname)) {
            this.stopAnimation();
            this.plotGaugeLocation();
            this.sAnimPanel.propertyChange(evt);
            this.sTSPanel.propertyChange(evt);
            this.setTimeStep(this.timeStep);
            this.requestFocusInWindow();
        } else if ("sourceScenario".equals(propname)) {
            this.sTSPanel.propertyChange(evt);
        }
    }

    @Override
    public void modelStarted(final ModelEvent me) {
        CMIUtil.runOnDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (me.getSourceModel().equals(MostResultsPanel.this.currentSite)) {
                    MostResultsPanel.this.stopAnimation();
                    MostResultsPanel.this.lastFrameRequested = true;
                    MostResultsPanel.this.ignoreUpdates = false;
                    MostResultsPanel.this.sAnimPanel.modelStarted(me);
                    MostResultsPanel.this.sTSPanel.modelStarted(me);
                    MostResultsPanel.this.updatePanel();
                }
            }
        });
    }

    @Override
    public void modelStopped(final ModelEvent me) {
        CMIUtil.runOnDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (me.getSourceModel().equals(MostResultsPanel.this.currentSite)) {
                    MostResultsPanel.this.sAnimPanel.modelStopped(me);
                    MostResultsPanel.this.sTSPanel.modelStopped(me);
                    MostResultsPanel.this.lastFrameRequested = false;
                }
            }
        });
    }

    @Override
    public void modelUpdate(final ModelEvent me) {
        CMIUtil.runOnDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (me.getStatus() == 101 && me.getTimesteps() > 0 && me.getSourceModel().equals(MostResultsPanel.this.currentSite) && !MostResultsPanel.this.ignoreUpdates) {
                    MostResultsPanel.this.sAnimPanel.modelUpdate(me);
                    MostResultsPanel.this.sTSPanel.modelUpdate(me);
                    MostResultsPanel.this.updatePanel();
                    if (MostResultsPanel.this.lastFrameRequested && me.getTimesteps() > 0) {
                        MostResultsPanel.this.setTimeStep(me.getTimesteps());
                    }
                }
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        Component sel;
        this.sAnimPanel.stateChanged(event);
        this.stopAnimation();
        if (this.currentSite != null && event.getSource() instanceof JTabbedPane && (sel = ((JTabbedPane)event.getSource()).getSelectedComponent()) instanceof Container && ((Container)sel).isAncestorOf(this)) {
            this.updatePanel();
            this.requestFocusInWindow();
        }
    }

    static {
        dfxxxx = NumberFormat.getNumberInstance();
        dfxxxx.setMinimumFractionDigits(5);
        dfx = NumberFormat.getNumberInstance();
        dfx.setMinimumFractionDigits(1);
        dfx.setMaximumFractionDigits(1);
        runIcon = new ImageIcon(MostResultsPanel.class.getResource("images/Play16.gif"));
        stopIcon = new ImageIcon(MostResultsPanel.class.getResource("images/Stop16.gif"));
    }

    protected class LeftStepAction
    extends AbstractAction {
        protected LeftStepAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MostResultsPanel.this.stickToLastFrame(false);
            MostResultsPanel.this.stopAnimation();
            MostResultsPanel.this.setTimeStep(MostResultsPanel.this.getTimeStep() - 1);
        }
    }

    protected class RightStepAction
    extends AbstractAction {
        protected RightStepAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MostResultsPanel.this.stickToLastFrame(false);
            MostResultsPanel.this.stopAnimation();
            MostResultsPanel.this.setTimeStep(MostResultsPanel.this.getTimeStep() + 1);
        }
    }
}

