/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.LocationFileChooser;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SimpleFileFilter;
import gov.noaa.tsunami.cmi.SwingWorker;
import gov.noaa.tsunami.websift.ee.MapCanvas;
import gov.noaa.tsunami.websift.propdb.Range2D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.spi.wizard.WizardPage;

public class NewModelRunWizardGridPanel
extends WizardPage
implements PropertyChangeListener {
    private final MapCanvas map;
    private Range2D range = new Range2D(0.0, 0.0, 0.0, 0.0);
    private int nx;
    private int ny;
    private int numPts = 0;
    private BathyGrid bathyGrid = null;
    private String defaultGridFileAppend = "";
    private Double resolutionDeg = new Double(0.03333333);
    private Double resolutionMin = new Double(2.0);
    private double resolutionSec = new Double(120.0);
    private double defaultResMin = 1.0;
    private static final DecimalFormat dfx = new DecimalFormat("0.0");
    private static final DecimalFormat dfxxx = new DecimalFormat("0.000");
    private static final DecimalFormat dfxxxx = new DecimalFormat("0.0000");
    private boolean rubberBanding;
    private int gridIdent = 1;
    private static String gridsPath;
    private StringBuffer fullGridFilename = new StringBuffer();
    private boolean download = true;
    private int fileVer = 0;
    private static List<Rectangle2D.Double> sourceGridExtents;
    private Map settings;
    private static TreeMap<Integer, ArrayList<Area>> lma;
    private JButton browseButton;
    private JCheckBox citiesCheckBox;
    private JLabel continueLabel;
    private JFormattedTextField eastFormattedTextField;
    protected JTextField gridFileNameTextField;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JLabel mapCoordLabel;
    private JPanel mapPanel;
    private JFormattedTextField northFormattedTextField;
    private JLabel numPtsLabel;
    private JLabel nxLabel;
    private JLabel nyLabel;
    private JFormattedTextField resolutionDegTextField;
    protected JFormattedTextField resolutionMinTextField;
    protected JFormattedTextField resolutionSecTextField;
    private JFormattedTextField southFormattedTextField;
    private JFormattedTextField westFormattedTextField;

    public NewModelRunWizardGridPanel() {
        this.initComponents();
        this.map = new MapCanvas(450, 350);
        this.map.setLogger(SiftShare.log);
        this.map.setFocusable(true);
        this.map.drawSitesOn();
        this.map.setMarkColor(new Color(246, 255, 133));
        try {
            this.map.setLandMasses(lma);
            File tf = new File(CMIUtil.etcDirName, "wdb_borders_i.b");
            this.map.setBorders(tf.toURI().toURL());
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.SEVERE, null, ex);
        }
        this.map.setMinZoomLevel(6);
        this.map.setMaxZoomLevel(31);
        this.map.zoomTo(200.0, 0.0);
        this.map.zoom(10);
        this.map.useCities(true);
        this.map.useCountries(true);
        this.mapPanel.add((Component)this.map, "Center");
        this.mapPanel.setFocusable(true);
        this.map.addPropertyChangeListener(this);
        this.northFormattedTextField.addPropertyChangeListener(this);
        this.southFormattedTextField.addPropertyChangeListener(this);
        this.eastFormattedTextField.addPropertyChangeListener(this);
        this.westFormattedTextField.addPropertyChangeListener(this);
        this.resolutionDegTextField.addPropertyChangeListener(this);
        this.resolutionMinTextField.addPropertyChangeListener(this);
        this.resolutionSecTextField.addPropertyChangeListener(this);
        this.gridFileNameTextField.addPropertyChangeListener(this);
        this.settings = this.getWizardDataMap();
        try {
            this.loadSourceGridExtents();
        }
        catch (Exception ex) {
            SiftShare.log.log(Level.SEVERE, null, ex);
        }
        this.getInputMap(2).put(KeyStroke.getKeyStroke(78, 64), "forcenext");
        this.getActionMap().put("forcenext", new ForceNextStepAction());
        this.map.getInputMap(2).put(KeyStroke.getKeyStroke(78, 64), "forcenext");
        this.map.getActionMap().put("forcenext", new ForceNextStepAction());
        this.setFocusable(true);
    }

    public void setGridIdent(int gi) {
        this.gridIdent = gi;
    }

    public static void setGridPath(String s) {
        gridsPath = s;
    }

    public static void setLandMasses(TreeMap<Integer, ArrayList<Area>> lm) {
        lma = lm;
    }

    public void setResolutionKey(String s) {
        this.resolutionSecTextField.setName(s);
    }

    public void setGridFilenameKey(String s) {
        this.getWizardDataMap().put(s, this.fullGridFilename);
    }

    public void setNorthExtentKey(String s) {
        this.northFormattedTextField.setName(s);
    }

    public void setSouthExtentKey(String s) {
        this.southFormattedTextField.setName(s);
    }

    public void setEastExtentKey(String s) {
        this.eastFormattedTextField.setName(s);
    }

    public void setWestExtentKey(String s) {
        this.westFormattedTextField.setName(s);
    }

    public void setDefaultGridFileAppend(String s) {
        this.defaultGridFileAppend = s;
    }

    public void setResolutionMin(double d) {
        this.defaultResMin = d;
        this.resolutionMin = d;
        this.resolutionDeg = d / 60.0;
        this.resolutionSec = d * 60.0;
    }

    @Override
    protected void renderingPage() {
        this.resolutionDegTextField.setValue(this.resolutionDeg);
        this.resolutionMinTextField.setValue(this.resolutionMin);
        this.resolutionSecTextField.setValue(this.resolutionSec);
        this.mapExtent(1, true);
        this.mapExtent(2, true);
        this.mapExtent(3, true);
        if (this.download) {
            this.setDefaultGridFilename();
        }
    }

    private void mapExtent(int ident, boolean zoom) {
        double minlon;
        double maxlon;
        double minlat;
        double maxlat;
        Object objN = this.getWizardData(BathyGrid.getGridLetter(ident) + " grid north extent");
        Object objS = this.getWizardData(BathyGrid.getGridLetter(ident) + " grid south extent");
        Object objE = this.getWizardData(BathyGrid.getGridLetter(ident) + " grid east extent");
        Object objW = this.getWizardData(BathyGrid.getGridLetter(ident) + " grid west extent");
        if (objN == null || objS == null || objE == null || objW == null) {
            return;
        }
        try {
            maxlat = ((Number)objN).doubleValue();
            minlat = ((Number)objS).doubleValue();
            maxlon = ((Number)objE).doubleValue();
            minlon = ((Number)objW).doubleValue();
        }
        catch (ClassCastException cce) {
            return;
        }
        Point2D.Double[] Pt = new Point2D.Double[]{new Point2D.Double(minlon, minlat), new Point2D.Double(maxlon, minlat), new Point2D.Double(maxlon, maxlat), new Point2D.Double(minlon, maxlat)};
        switch (ident) {
            case 1: {
                this.map.setGridA(Pt, "");
                break;
            }
            case 2: {
                this.map.setGridB(Pt, "");
                break;
            }
            case 3: {
                this.map.setGridC(Pt, "");
                break;
            }
        }
        this.map.setRubberbanding(false);
        if (zoom) {
            minlon -= 0.05 * Math.abs(maxlon - minlon);
            maxlon += 0.05 * Math.abs(maxlon - minlon);
            minlat -= 0.05 * Math.abs(maxlat - minlat);
            this.map.zoomTo(minlon += 0.05 * Math.abs(maxlat - minlat), maxlon, minlat, maxlat);
        }
    }

    private void initComponents() {
        this.mapPanel = new JPanel();
        this.mapCoordLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.westFormattedTextField = new JFormattedTextField();
        this.eastFormattedTextField = new JFormattedTextField();
        this.northFormattedTextField = new JFormattedTextField();
        this.southFormattedTextField = new JFormattedTextField();
        this.resolutionDegTextField = new JFormattedTextField();
        this.jLabel1 = new JLabel();
        this.gridFileNameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.resolutionMinTextField = new JFormattedTextField();
        this.resolutionSecTextField = new JFormattedTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.browseButton = new JButton();
        this.jLabel11 = new JLabel();
        this.nxLabel = new JLabel();
        this.jLabel13 = new JLabel();
        this.nyLabel = new JLabel();
        this.jLabel12 = new JLabel();
        this.numPtsLabel = new JLabel();
        this.continueLabel = new JLabel();
        this.jLabel14 = new JLabel();
        this.citiesCheckBox = new JCheckBox();
        this.setMinimumSize(new Dimension(1000, 475));
        this.mapPanel.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.mapPanel.setMinimumSize(new Dimension(0, 0));
        this.mapPanel.setLayout(new BorderLayout());
        this.mapCoordLabel.setFont(this.mapCoordLabel.getFont().deriveFont((float)this.mapCoordLabel.getFont().getSize() - 3.0f));
        this.westFormattedTextField.setColumns(8);
        this.westFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.0000"))));
        this.westFormattedTextField.setHorizontalAlignment(0);
        this.westFormattedTextField.setToolTipText("West extent (degrees longitude)");
        this.eastFormattedTextField.setColumns(8);
        this.eastFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.0000"))));
        this.eastFormattedTextField.setHorizontalAlignment(0);
        this.eastFormattedTextField.setToolTipText("East extent (degrees longitude)");
        this.northFormattedTextField.setColumns(8);
        this.northFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.0000"))));
        this.northFormattedTextField.setHorizontalAlignment(0);
        this.northFormattedTextField.setToolTipText("North extent (degrees latitude)");
        this.southFormattedTextField.setColumns(8);
        this.southFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.0000"))));
        this.southFormattedTextField.setHorizontalAlignment(0);
        this.southFormattedTextField.setToolTipText("South extent (degrees latitude)");
        this.resolutionDegTextField.setColumns(6);
        this.resolutionDegTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0.0000"))));
        this.resolutionDegTextField.setHorizontalAlignment(0);
        this.resolutionDegTextField.setFocusLostBehavior(0);
        this.jLabel1.setText("Cell Size:");
        this.gridFileNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewModelRunWizardGridPanel.this.gridFileNameTextFieldActionPerformed(evt);
            }
        });
        this.jLabel2.setText("File Name:");
        this.jLabel3.setText("(deg)");
        this.jLabel4.setText("(arcmin)");
        this.jLabel5.setText("(arcsec)");
        this.resolutionMinTextField.setColumns(6);
        this.resolutionMinTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0.000"))));
        this.resolutionMinTextField.setHorizontalAlignment(0);
        this.resolutionMinTextField.setFocusLostBehavior(0);
        this.resolutionSecTextField.setColumns(6);
        this.resolutionSecTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0.0"))));
        this.resolutionSecTextField.setHorizontalAlignment(0);
        this.resolutionSecTextField.setFocusLostBehavior(0);
        this.jLabel6.setText("Grid Extents:");
        this.jLabel7.setText("N");
        this.jLabel8.setText("S");
        this.jLabel9.setText("E");
        this.jLabel10.setText("W");
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewModelRunWizardGridPanel.this.browseButtonActionPerformed(evt);
            }
        });
        this.jLabel11.setText("Number points, nx:");
        this.nxLabel.setForeground(Color.gray);
        this.nxLabel.setHorizontalAlignment(0);
        this.nxLabel.setText("0");
        this.jLabel13.setText("ny:");
        this.nyLabel.setForeground(Color.gray);
        this.nyLabel.setHorizontalAlignment(0);
        this.nyLabel.setText("0");
        this.jLabel12.setText("total:");
        this.numPtsLabel.setForeground(Color.gray);
        this.numPtsLabel.setHorizontalAlignment(0);
        this.numPtsLabel.setText("0");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(this.jLabel2).addPreferredGap(0).add(this.gridFileNameTextField).addPreferredGap(0).add(this.browseButton).add(12, 12, 12)).add(jPanel1Layout.createSequentialGroup().add(this.jLabel6).addPreferredGap(1).add(this.westFormattedTextField, -2, -1, -2).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(this.southFormattedTextField, -2, -1, -2).add(this.northFormattedTextField, -2, -1, -2).add(this.jLabel10)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(this.eastFormattedTextField, -2, -1, -2).addPreferredGap(0).add(this.jLabel9)).add(2, jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(this.jLabel7).add(this.jLabel8)).add(102, 102, 102)))).add(jPanel1Layout.createSequentialGroup().add(this.jLabel11).add(18, 18, 18).add(this.nxLabel, -2, 54, -2).addPreferredGap(0).add(this.jLabel13).add(18, 18, 18).add(this.nyLabel, -2, 55, -2).addPreferredGap(1).add(this.jLabel12).addPreferredGap(0).add(this.numPtsLabel, -1, -1, Short.MAX_VALUE)).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(this.resolutionDegTextField, -2, 73, -2).addPreferredGap(0).add(this.jLabel3).add(18, 18, 18).add(this.resolutionMinTextField, -2, 77, -2).addPreferredGap(0).add(this.jLabel4).add(18, 18, 18).add(this.resolutionSecTextField, -2, 77, -2).addPreferredGap(0).add(this.jLabel5)).add(this.jLabel1)).add(62, 62, 62))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(37, 37, 37).add(this.jLabel6)).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.jLabel7).add(this.northFormattedTextField, -2, -1, -2)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.westFormattedTextField, -2, -1, -2).add(this.eastFormattedTextField, -2, -1, -2).add(this.jLabel9).add(this.jLabel10)).add(10, 10, 10).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel8).add(this.southFormattedTextField, -2, -1, -2)))).add(18, 18, 18).add(this.jLabel1).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.resolutionDegTextField, -2, -1, -2).add(this.resolutionMinTextField, -2, -1, -2).add(this.jLabel4).add(this.resolutionSecTextField, -2, -1, -2).add(this.jLabel5).add(this.jLabel3)).add(12, 12, 12).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel11).add(this.nxLabel).add(this.jLabel13).add(this.nyLabel).add(this.jLabel12).add(this.numPtsLabel)).addPreferredGap(0, -1, Short.MAX_VALUE).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel2).add(this.gridFileNameTextField, -2, -1, -2).add(this.browseButton)).add(15, 15, 15)));
        this.continueLabel.setFont(new Font("Dialog", 1, 14));
        this.continueLabel.setForeground(Color.blue);
        this.jLabel14.setFont(this.jLabel14.getFont().deriveFont(this.jLabel14.getFont().getStyle() & 0xFFFFFFFE, this.jLabel14.getFont().getSize() - 3));
        this.jLabel14.setText("<html>Hold <code>Shift</code> and drag to select a grid extent.<p>High-resolution data is available in areas outlined by black boxes.</html>");
        this.citiesCheckBox.setSelected(true);
        this.citiesCheckBox.setText("Show Cities");
        this.citiesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewModelRunWizardGridPanel.this.citiesCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(layout.createSequentialGroup().add(this.continueLabel, -2, 445, -2).add(51, 51, 51)).add(layout.createSequentialGroup().add(layout.createParallelGroup(2).add(this.citiesCheckBox).add(this.jPanel1, -2, -1, -2)).addPreferredGap(1))).add(layout.createParallelGroup(1).add(this.jLabel14, -2, -1, -2).add(this.mapCoordLabel, -1, -1, Short.MAX_VALUE).add(this.mapPanel, -1, 651, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.citiesCheckBox).addPreferredGap(0, 168, Short.MAX_VALUE).add(this.continueLabel)).add(this.mapPanel, -1, -1, Short.MAX_VALUE)).add(6, 6, 6).add(this.mapCoordLabel, -2, 14, -2).addPreferredGap(0).add(this.jLabel14, -2, -1, -2).addContainerGap()));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        LocationFileChooser fileChooser = new LocationFileChooser(gridsPath);
        SimpleFileFilter fileFilter = new SimpleFileFilter(new String[]{""}, "MOST grid file");
        fileChooser.setFileFilter(fileFilter);
        fileChooser.setLocation(100, 500);
        int result = fileChooser.showOpenDialog(this);
        if (result == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            gridsPath = selectedFile.getParent();
            try {
                this.bathyGrid = new BathyGrid(selectedFile, false);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Can't open " + selectedFile.getAbsolutePath() + ":\n" + e.getMessage(), "Error opening grid file", 0);
            }
            this.gridFileNameTextField.setText(selectedFile.getName());
            this.fullGridFilename.setLength(0);
            this.fullGridFilename.append(selectedFile.getPath());
            this.range.x = this.bathyGrid.getMinLon();
            this.range.y = this.bathyGrid.getMinLat();
            this.range.w = this.bathyGrid.getMaxLon() - this.range.x;
            this.range.h = this.bathyGrid.getMaxLat() - this.range.y;
            this.northFormattedTextField.setValue(this.bathyGrid.getMaxLat());
            this.southFormattedTextField.setValue(this.bathyGrid.getMinLat());
            this.eastFormattedTextField.setValue(this.bathyGrid.getMaxLon());
            this.westFormattedTextField.setValue(this.bathyGrid.getMinLon());
            this.resolutionDegTextField.setValue(this.bathyGrid.getMeanResolution());
            this.mapExtent(this.gridIdent, false);
            this.enableExtentsAndResolution(false);
            this.download = false;
            this.updateNumberPoints();
            this.continueLabel.setText("Existing MOST grid file loaded. Select Next.");
        }
    }

    private void gridFileNameTextFieldActionPerformed(ActionEvent evt) {
        this.fullGridFilename.setLength(0);
        this.fullGridFilename.append(this.gridFileNameTextField.getText());
        this.settings.put(this.gridFileNameTextField.getName(), this.fullGridFilename);
    }

    private void citiesCheckBoxActionPerformed(ActionEvent evt) {
        if (this.citiesCheckBox.isSelected()) {
            this.map.useCities(true);
        } else {
            this.map.useCities(false);
        }
    }

    public void setDefaultGridFilename() {
        this.gridFileNameTextField.setText(this.getWizardData("model run name") + this.defaultGridFileAppend);
        this.fullGridFilename.setLength(0);
        this.fullGridFilename.append(CMIUtil.gridsDirName + File.separator + this.gridFileNameTextField.getText());
        while (new File(this.fullGridFilename.toString()).exists()) {
            ++this.fileVer;
            this.defaultGridFileAppend = this.defaultGridFileAppend.replace(".most", String.format("%02d.most", this.fileVer));
            this.gridFileNameTextField.setText(this.getWizardData("model run name") + this.defaultGridFileAppend);
            this.fullGridFilename.setLength(0);
            this.fullGridFilename.append(CMIUtil.gridsDirName + File.separator + this.gridFileNameTextField.getText());
            SiftShare.log.fine("default grid file exists: " + this.fullGridFilename.toString());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String pname = evt.getPropertyName();
        if (pname.equals("pointerLocation")) {
            Point2D.Double pt = (Point2D.Double)evt.getNewValue();
            if (pt != null) {
                if (!this.map.isRubberbanding()) {
                    this.mapCoordLabel.setText(String.format("%.3f, %.3f", pt.x, pt.y));
                }
            } else {
                this.mapCoordLabel.setText(null);
            }
        } else if (pname.equals("rubberbandRegion")) {
            this.range = this.map.getRubberbandRegion();
            if (this.range != null) {
                this.continueLabel.setText("");
                this.enableExtentsAndResolution(true);
                this.rubberBanding = true;
                this.northFormattedTextField.setValue(this.range.y + this.range.h);
                this.southFormattedTextField.setValue(this.range.y);
                this.westFormattedTextField.setValue(this.range.x);
                this.eastFormattedTextField.setValue(this.range.x + this.range.w);
                if (!this.download) {
                    this.setResolutionMin(this.defaultResMin);
                }
                this.download = true;
                this.setDefaultGridFilename();
                this.updateResolutionTextFields();
                this.mapExtent(this.gridIdent, false);
                this.mapCoordLabel.setText(String.format("(%.3f, %.3f) - (%.3f, %.3f)", this.range.x, this.range.y, this.range.x + this.range.w, this.range.y + this.range.h));
                this.rubberBanding = false;
            }
        } else if (pname.equals("value")) {
            Object obj = evt.getSource();
            if (obj.equals(this.resolutionDegTextField)) {
                this.resolutionDeg = this.getDoubleValue(this.resolutionDegTextField);
                this.resolutionMin = this.resolutionDeg * 60.0;
                this.resolutionSec = this.resolutionDeg * 3600.0;
                this.updateResolutionTextFields();
            } else if (obj.equals(this.resolutionMinTextField)) {
                this.resolutionMin = this.getDoubleValue(this.resolutionMinTextField);
                this.resolutionDeg = this.resolutionMin / 60.0;
                this.resolutionSec = this.resolutionMin * 60.0;
                this.updateResolutionTextFields();
            } else if (obj.equals(this.resolutionSecTextField)) {
                this.resolutionSec = this.getDoubleValue(this.resolutionSecTextField);
                this.resolutionMin = this.resolutionSec / 60.0;
                this.resolutionDeg = this.resolutionSec / 3600.0;
                this.updateResolutionTextFields();
            } else if (obj.equals(this.northFormattedTextField)) {
                if (!this.rubberBanding) {
                    this.range.h = this.getDoubleValue(this.northFormattedTextField) - this.range.y;
                    this.map.setRubberbandRegion(this.range.x, this.range.x + this.range.w, this.range.y, this.range.y + this.range.h);
                    this.updateNumberPoints();
                }
            } else if (obj.equals(this.southFormattedTextField)) {
                if (!this.rubberBanding) {
                    this.range.y = this.getDoubleValue(this.southFormattedTextField);
                    this.range.h = this.getDoubleValue(this.northFormattedTextField) - this.range.y;
                    this.map.setRubberbandRegion(this.range.x, this.range.x + this.range.w, this.range.y, this.range.y + this.range.h);
                    this.updateNumberPoints();
                }
            } else if (obj.equals(this.eastFormattedTextField)) {
                if (!this.rubberBanding) {
                    this.range.w = this.getDoubleValue(this.eastFormattedTextField) - this.range.x;
                    this.map.setRubberbandRegion(this.range.x, this.range.x + this.range.w, this.range.y, this.range.y + this.range.h);
                    this.updateNumberPoints();
                }
            } else if (obj.equals(this.westFormattedTextField) && !this.rubberBanding) {
                this.range.x = this.getDoubleValue(this.westFormattedTextField);
                this.range.w = this.getDoubleValue(this.eastFormattedTextField) - this.range.x;
                this.map.setRubberbandRegion(this.range.x, this.range.x + this.range.w, this.range.y, this.range.y + this.range.h);
                this.updateNumberPoints();
            }
            if (obj instanceof JTextField) {
                JTextField jtf = (JTextField)obj;
                this.settings.put(jtf.getName(), jtf.getText());
            }
        }
    }

    public double getDoubleValue(JFormattedTextField tf) {
        double val = Double.MIN_VALUE;
        try {
            Object obj = tf.getValue();
            if (obj == null) {
                return 99999.9;
            }
            val = ((Number)obj).doubleValue();
        }
        catch (NumberFormatException nfe) {
            SiftShare.log.log(Level.FINE, "error parsing number", nfe);
        }
        return val;
    }

    private void enableExtentsAndResolution(boolean b) {
        this.resolutionDegTextField.setEnabled(b);
        this.resolutionMinTextField.setEnabled(b);
        this.resolutionSecTextField.setEnabled(b);
        this.northFormattedTextField.setEnabled(b);
        this.southFormattedTextField.setEnabled(b);
        this.eastFormattedTextField.setEnabled(b);
        this.westFormattedTextField.setEnabled(b);
        this.gridFileNameTextField.setEnabled(b);
    }

    private void updateResolutionTextFields() {
        this.resolutionDegTextField.setText(dfxxxx.format(this.resolutionDeg));
        this.resolutionMinTextField.setText(dfxxx.format(this.resolutionMin));
        this.resolutionSecTextField.setText(dfx.format(this.resolutionSec));
        this.settings.put(this.resolutionSecTextField.getName(), this.resolutionSecTextField.getText());
        SiftShare.log.log(Level.FINE, "resolution (sec): " + this.resolutionSecTextField.toString());
        this.updateNumberPoints();
    }

    private void updateNumberPoints() {
        if (!this.download) {
            this.nx = this.bathyGrid.getXSize();
            this.nxLabel.setText(Integer.toString(this.nx));
            this.ny = this.bathyGrid.getYSize();
            this.nyLabel.setText(Integer.toString(this.ny));
            this.numPts = this.nx * this.ny;
            this.numPtsLabel.setText(Integer.toString(this.numPts));
            this.numPtsLabel.setForeground(Color.gray);
        } else if (this.range != null) {
            this.nx = (int)(this.range.w / this.resolutionDeg);
            this.nxLabel.setText(Integer.toString(this.nx));
            this.ny = (int)(this.range.h / this.resolutionDeg);
            this.nyLabel.setText(Integer.toString(this.ny));
            this.numPts = this.nx * this.ny;
            this.numPtsLabel.setText(Integer.toString(this.numPts));
            this.numPtsLabel.setForeground(this.numPts > 360000 ? Color.red : Color.gray);
        }
        this.setProblem(this.validateContents(null, null));
    }

    private boolean outerGridContainsThisGrid() {
        return true;
    }

    @Override
    protected String validateContents(Component comp, Object o) {
        if (this.northFormattedTextField.getText().length() == 0 || this.southFormattedTextField.getText().length() == 0 || this.eastFormattedTextField.getText().length() == 0 || this.westFormattedTextField.getText().length() == 0) {
            return "Choose a grid extent to generate a new grid, or select \"Browse\" to open an existing MOST grid.";
        }
        if (this.getDoubleValue(this.northFormattedTextField) < this.getDoubleValue(this.southFormattedTextField)) {
            return "North extent must be greater than south extent";
        }
        if (this.getDoubleValue(this.eastFormattedTextField) < this.getDoubleValue(this.westFormattedTextField)) {
            return "East extent must be greater than west extent";
        }
        if (this.gridFileNameTextField.getText().indexOf(32) != -1) {
            return "Model name may not contain spaces";
        }
        if (!this.outerGridContainsThisGrid()) {
            return "Grid extents must be within previous grid extents";
        }
        if (this.download && this.numPtsLabel.getForeground().equals(Color.red)) {
            return "Extent too large, select smaller region (<600x600) or larger cell size";
        }
        return null;
    }

    private synchronized void loadSourceGridExtents() throws IOException {
        if (sourceGridExtents != null) {
            if (this.map != null) {
                this.map.setGridOverlays(sourceGridExtents);
                this.map.repaint();
            }
            return;
        }
        sourceGridExtents = new ArrayList<Rectangle2D.Double>(50);
        URL indexUrl = new URL(CMIUtil.commitServerAddress + "/bathymetry/search.csv");
        SourceGridExtentDownloader worker = new SourceGridExtentDownloader(indexUrl, sourceGridExtents, this.map);
        worker.start();
    }

    static {
        sourceGridExtents = null;
        lma = null;
    }

    private static class SourceGridExtentDownloader
    extends SwingWorker {
        private final URL indexUrl;
        private final List<Rectangle2D.Double> shapes;
        public Exception error = null;
        private final MapCanvas map;

        public SourceGridExtentDownloader(URL indexUrl, List<Rectangle2D.Double> shapes, MapCanvas map) {
            this.indexUrl = indexUrl;
            this.shapes = shapes;
            this.map = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object construct() {
            BufferedReader br = null;
            try {
                String inLine;
                HttpURLConnection con = (HttpURLConnection)this.indexUrl.openConnection();
                br = new BufferedReader(new InputStreamReader(con.getInputStream()));
                while ((inLine = br.readLine()) != null) {
                    String[] fields = inLine.split(" *, *");
                    if (fields.length < 8) continue;
                    try {
                        double res = Double.parseDouble(fields[2]);
                        if (!(res < 0.008333333333333333)) continue;
                        double x = Double.parseDouble(fields[4]);
                        double y = Double.parseDouble(fields[6]);
                        Rectangle2D.Double ext = new Rectangle2D.Double(x, y, Double.parseDouble(fields[5]) - x, Double.parseDouble(fields[7]) - y);
                        this.shapes.add(ext);
                    }
                    catch (NumberFormatException ex) {
                        throw new IOException(ex.getMessage());
                        return this.shapes;
                    }
                }
            }
            catch (IOException ex) {
                this.error = ex;
                SiftShare.log.warning(ex.toString());
                Object var3_6 = null;
                return var3_6;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        @Override
        public void finished() {
            if (this.shapes.isEmpty() || this.error != null) {
                return;
            }
            if (this.map != null) {
                this.map.setGridOverlays(this.shapes);
                this.map.repaint();
            }
        }
    }

    protected class ForceNextStepAction
    extends AbstractAction {
        protected ForceNextStepAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            NewModelRunWizardGridPanel.this.numPtsLabel.setForeground(Color.gray);
            NewModelRunWizardGridPanel.this.setProblem(NewModelRunWizardGridPanel.this.validateContents(null, null));
        }
    }
}

