/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

public class NiceScale {
    private double minPoint;
    private double maxPoint;
    private double maxTicks = 10.0;
    private double tickSpacing;
    private double range;
    private double niceMin;
    private double niceMax;

    public NiceScale(double min, double max) {
        this.minPoint = min;
        this.maxPoint = max;
        this.calculate();
    }

    private void calculate() {
        this.range = this.niceNum(this.maxPoint - this.minPoint, false);
        this.tickSpacing = this.niceNum(this.range / (this.maxTicks - 1.0), true);
        this.niceMin = Math.floor(this.minPoint / this.tickSpacing) * this.tickSpacing;
        this.niceMax = Math.ceil(this.maxPoint / this.tickSpacing) * this.tickSpacing;
    }

    private double niceNum(double range, boolean round) {
        double exponent = Math.floor(Math.log10(range));
        double fraction = range / Math.pow(10.0, exponent);
        double niceFraction = round ? (fraction < 1.5 ? 1.0 : (fraction < 3.0 ? 2.0 : (fraction < 7.0 ? 5.0 : 10.0))) : (fraction <= 1.0 ? 1.0 : (fraction <= 2.0 ? 2.0 : (fraction <= 5.0 ? 5.0 : 10.0)));
        return niceFraction * Math.pow(10.0, exponent);
    }

    public void setMinMaxPoints(double minPoint, double maxPoint) {
        this.minPoint = minPoint;
        this.maxPoint = maxPoint;
        this.calculate();
    }

    public void setMaxTicks(double maxTicks) {
        this.maxTicks = maxTicks;
        this.calculate();
    }

    public double getTickSpacing() {
        return this.tickSpacing;
    }

    public int getNumberOfTicks() {
        return Math.round((float)((this.niceMax - this.tickSpacing) / this.tickSpacing));
    }

    public double getNiceMin() {
        return this.niceMin;
    }

    public double getNiceMax() {
        return this.niceMax;
    }

    public String toString() {
        return String.format("Nice Scale, min: %2.3f, max: %2.3f, spacing: %2.3f, numticks: %d\n", this.niceMin, this.niceMax, this.tickSpacing, this.getNumberOfTicks());
    }

    public static void main(String[] args) {
        NiceScale ns = new NiceScale(0.0, 9.0);
        System.out.println(ns);
        ns = new NiceScale(-0.085, 0.173);
        System.out.println(ns);
    }
}

