/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;

public class OpenDAPDialog
extends JDialog
implements PropertyChangeListener {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private static final Map<String, String> presets = new LinkedHashMap<String, String>(4);
    private static final String DEFAULT_URL = "http://";
    private static String URLString = "http://";
    private static int returnStatus = 0;
    private JButton cancelButton;
    private static JFormattedTextField jFormattedTextField1;
    private JButton okButton;
    private JComboBox presetComboBox;

    public OpenDAPDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this.doInit();
    }

    public OpenDAPDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.doInit();
    }

    private void doInit() {
        this.initComponents();
        CMIUtil.installEscapeCloseOperation(this);
        URLString = DEFAULT_URL;
        jFormattedTextField1.setText(URLString);
        jFormattedTextField1.addPropertyChangeListener("value", this);
        this.presetComboBox.addItem(" ");
        for (String s : presets.keySet()) {
            this.presetComboBox.addItem(s);
        }
    }

    public int getReturnStatus() {
        return returnStatus;
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        JPanel jPanel1 = new JPanel();
        jFormattedTextField1 = new JFormattedTextField();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        this.presetComboBox = new JComboBox();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                OpenDAPDialog.this.closeDialog(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenDAPDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenDAPDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        jPanel1.setBorder(BorderFactory.createEtchedBorder());
        jLabel1.setFont(jLabel1.getFont().deriveFont((float)jLabel1.getFont().getSize() + 3.0f));
        jLabel1.setText("Enter Remote Unit Source Server URL:");
        jLabel2.setText("Remote server must be either an OpenDAP server or a ComMIT Server.");
        jLabel3.setText("Available presets:");
        this.presetComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenDAPDialog.this.presetComboBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(24, 24, 24).add(jLabel3).addPreferredGap(0).add(this.presetComboBox, 0, 429, Short.MAX_VALUE)).add(jLabel1, -1, 569, Short.MAX_VALUE).add(jLabel2).add(2, jFormattedTextField1, -1, 569, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jLabel1).addPreferredGap(0).add(jFormattedTextField1, -2, -1, -2).addPreferredGap(0).add(jLabel2).addPreferredGap(1).add(jPanel1Layout.createParallelGroup(3).add(jLabel3).add(this.presetComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(1, jPanel1, -1, -1, Short.MAX_VALUE).add(layout.createSequentialGroup().add(this.okButton, -2, 67, -2).addPreferredGap(0).add(this.cancelButton))).addContainerGap()));
        layout.linkSize(new Component[]{this.cancelButton, this.okButton}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(jPanel1, -2, -1, -2).add(18, 18, 18).add(layout.createParallelGroup(3).add(this.okButton).add(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void presetComboBoxActionPerformed(ActionEvent evt) {
        try {
            String s = presets.get((String)this.presetComboBox.getSelectedItem());
            if (s == null) {
                jFormattedTextField1.setValue(DEFAULT_URL);
            } else {
                jFormattedTextField1.setValue(s);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public static int showDialog(Dialog d, boolean b) {
        OpenDAPDialog dialog = new OpenDAPDialog(d, b);
        URLString = (String)jFormattedTextField1.getValue();
        dialog.setVisible(true);
        dialog.dispose();
        return returnStatus;
    }

    public static List<String> getEnteredURLs() {
        if (URLString != null && URLString.trim().length() > 0) {
            String[] urlarr = URLString.split(" *; *");
            return Arrays.asList(urlarr);
        }
        return Collections.emptyList();
    }

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new OpenDAPDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        URLString = jFormattedTextField1.getText();
    }

    static {
        presets.put("Default (NOAA PMEL)", "(default server)");
        presets.put("Australia Bureau of Meteorology", "http://opendap.bom.gov.au:8080/thredds/fileServer/atws_t1/a; http://opendap.bom.gov.au:8080/thredds/fileServer/atws_t1/b; http://opendap.bom.gov.au:8080/thredds/fileServer/atws_t1/c; http://opendap.bom.gov.au:8080/thredds/fileServer/atws_t1/d");
    }
}

