/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.DartInversionCellRenderer;
import gov.noaa.tsunami.cmi.ManualEventDialog;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import gov.noaa.tsunami.cmi.TsunamicastClient;
import gov.noaa.tsunami.cmi.TsunamicastWorker;
import gov.noaa.tsunami.websift.ee.EventEditor2;
import gov.noaa.tsunami.websift.events.CountryBoundaries;
import gov.noaa.tsunami.websift.events.QuakeNGDCParser;
import gov.noaa.tsunami.websift.events.SeismicEvent;
import gov.noaa.tsunami.websift.events.SimpleEventParser;
import gov.noaa.tsunami.websift.propdb.PropagationDatabase;
import gov.noaa.tsunami.websift.propdb.PropagationDatabaseException;
import gov.noaa.tsunami.websift.propdb.SourceCombo;
import gov.noaa.tsunami.websift.propdb.SourceScenario;
import gov.noaa.tsunami.websift.propdb.SourceScenarioListModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OpenEventDialog
extends JDialog {
    public static Vector<SeismicEvent> quakeEvents = new Vector();
    public static boolean doneParsing = false;
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    protected static int returnStatus = 0;
    private static File allEventsFile = null;
    private static File ngdcEventsFile = null;
    private static SimpleEventParser eventParser = new SimpleEventParser();
    private static QuakeNGDCParser ngdcParser = new QuakeNGDCParser();
    private SeismicEvent currentEvent = null;
    private SiteInfo siteInfo = null;
    private SourceScenario currentSourceScenario = null;
    private static boolean projectMode = false;
    private final String eventOrProjectStr;
    private EventEditor2 eventEditor = null;
    private JLabel authorityLabel;
    private JButton cancelButton;
    private JCheckBox createModelRunCheckBox;
    private JLabel createdLabel;
    private JLabel creatorLabel;
    protected JLabel dateLabel;
    protected JLabel depthLabel;
    private JButton downloadButton;
    protected JLabel epiLabel;
    private JPanel eventInfoPanel;
    private JCheckBox includeGroupSolnsChkBox;
    protected JList inversionList;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel legendAuthLabel;
    private JLabel legendPublishedLabel;
    protected JLabel magLabel;
    private JButton manualButton;
    protected JList nameList;
    protected JButton okButton;
    protected JLabel projectLabel;
    private JLabel scenarioLabel;
    private final JProgressBar workerProgressBar = new JProgressBar();

    public OpenEventDialog(Frame parent, SiteInfo si, boolean projectMode, EventEditor2 ee) {
        super(parent, true);
        this.initComponents();
        CMIUtil.installEscapeCloseOperation(this);
        this.setLocationRelativeTo(parent);
        this.siteInfo = si;
        OpenEventDialog.projectMode = projectMode;
        this.eventOrProjectStr = projectMode ? "project" : "event";
        this.eventEditor = ee;
        this.inversionList.setCellRenderer(new DartInversionCellRenderer());
        this.inversionList.setModel(new SourceScenarioListModel());
        boolean includeGroupSolns = SiftShare.getPreferences().getBoolean("GROUP_SOLUTIONS", false);
        this.includeGroupSolnsChkBox.setSelected(includeGroupSolns);
        allEventsFile = new File(CMIUtil.etcDirName, "allEvents.xml");
        if (!allEventsFile.exists() || (System.currentTimeMillis() - allEventsFile.lastModified()) / 3600000L > 336L) {
            int result = JOptionPane.showConfirmDialog(this, "Earthquake Events File more than 2 weeks old, Download?", "Download Earthquakes?", 0);
            if (result == 0) {
                this.getAllEvents();
            } else {
                this.eventListUpdate();
            }
        } else {
            this.eventListUpdate();
        }
        String s = this.eventOrProjectStr.substring(0, 1);
        s = this.eventOrProjectStr.replaceFirst(s, s.toUpperCase());
        this.setTitle(String.format("Open %s", s));
        this.projectLabel.setText(String.format("%ss:", s));
        this.scenarioLabel.setText(projectMode ? "Source scenarios:" : "Inversions:");
        this.eventInfoPanel.setVisible(!projectMode);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.nameList = new JList();
        this.projectLabel = new JLabel();
        this.scenarioLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.inversionList = new JList();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.authorityLabel = new JLabel();
        this.createdLabel = new JLabel();
        this.creatorLabel = new JLabel();
        this.eventInfoPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.dateLabel = new JLabel();
        this.magLabel = new JLabel();
        this.epiLabel = new JLabel();
        this.depthLabel = new JLabel();
        this.legendAuthLabel = new JLabel();
        this.legendPublishedLabel = new JLabel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.createModelRunCheckBox = new JCheckBox();
        this.includeGroupSolnsChkBox = new JCheckBox();
        this.downloadButton = new JButton();
        this.manualButton = new JButton();
        this.setTitle("Open Project");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                OpenEventDialog.this.formWindowOpened(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.nameList.setFont(new Font("Courier", 0, 12));
        this.nameList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.nameList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                OpenEventDialog.this.nameListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.nameList);
        this.projectLabel.setText("Events:");
        this.scenarioLabel.setText("Solutions:");
        this.inversionList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Retreiving events from server"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.inversionList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OpenEventDialog.this.inversionListMouseClicked(evt);
            }
        });
        this.inversionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                OpenEventDialog.this.inversionListValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.inversionList);
        this.jLabel1.setText("Created:");
        this.jLabel2.setText("Creator:");
        this.jLabel7.setText("Authority:");
        this.jLabel8.setText("--------");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.creatorLabel).addComponent(this.createdLabel).addComponent(this.authorityLabel)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.createdLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.creatorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.authorityLabel)).addContainerGap(12, Short.MAX_VALUE)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 242, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.eventInfoPanel.setMaximumSize(new Dimension(472, 128));
        this.jLabel3.setText("Date: ");
        this.jLabel4.setText("Mw: ");
        this.jLabel5.setText("Epicenter: ");
        this.jLabel6.setText("Depth: ");
        this.dateLabel.setText(" ");
        this.magLabel.setText(" ");
        this.epiLabel.setText(" ");
        this.depthLabel.setText(" ");
        GroupLayout eventInfoPanelLayout = new GroupLayout(this.eventInfoPanel);
        this.eventInfoPanel.setLayout(eventInfoPanelLayout);
        eventInfoPanelLayout.setHorizontalGroup(eventInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, eventInfoPanelLayout.createSequentialGroup().addContainerGap().addGroup(eventInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel5).addComponent(this.jLabel4).addComponent(this.jLabel6)).addGap(18, 18, 18).addGroup(eventInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dateLabel, -1, -1, Short.MAX_VALUE).addComponent(this.depthLabel, -1, -1, Short.MAX_VALUE).addComponent(this.epiLabel, -1, -1, Short.MAX_VALUE).addComponent(this.magLabel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        eventInfoPanelLayout.setVerticalGroup(eventInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(eventInfoPanelLayout.createSequentialGroup().addContainerGap().addGroup(eventInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.dateLabel, -2, 15, -2)).addGroup(eventInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(eventInfoPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4)).addGroup(eventInfoPanelLayout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.magLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(eventInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(eventInfoPanelLayout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addComponent(this.jLabel6)).addGroup(eventInfoPanelLayout.createSequentialGroup().addComponent(this.epiLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addComponent(this.depthLabel))).addContainerGap()));
        this.legendAuthLabel.setBackground(new Color(255, 255, 255));
        this.legendAuthLabel.setForeground(new Color(0, 153, 0));
        this.legendAuthLabel.setText("Authoritative");
        this.legendPublishedLabel.setBackground(new Color(255, 255, 255));
        this.legendPublishedLabel.setForeground(new Color(0, 51, 204));
        this.legendPublishedLabel.setText("Published");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.projectLabel).addGap(548, 548, 548)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addComponent(this.eventInfoPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.scenarioLabel).addGap(18, 18, 18).addComponent(this.legendAuthLabel).addGap(18, 18, 18).addComponent(this.legendPublishedLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLabel).addComponent(this.scenarioLabel).addComponent(this.legendAuthLabel).addComponent(this.legendPublishedLabel)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 242, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.eventInfoPanel, -2, -1, -2).addGap(0, 8, Short.MAX_VALUE))).addContainerGap()));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenEventDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenEventDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.createModelRunCheckBox.setText("Create New Model Run");
        this.includeGroupSolnsChkBox.setText("Include Group Solutions (Requires Login)");
        this.includeGroupSolnsChkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenEventDialog.this.includeGroupSolnsChkBoxActionPerformed(evt);
            }
        });
        this.downloadButton.setText("Download Events from Server");
        this.downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenEventDialog.this.downloadButtonActionPerformed(evt);
            }
        });
        this.manualButton.setText("Manually Enter Event");
        this.manualButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenEventDialog.this.manualButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.workerProgressBar, -2, 116, -2).addGap(18, 18, 18).addComponent(this.manualButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.downloadButton).addGap(18, 18, 18).addComponent(this.includeGroupSolnsChkBox).addGap(32, 32, 32).addComponent(this.createModelRunCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.okButton, -2, 81, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.createModelRunCheckBox).addComponent(this.includeGroupSolnsChkBox).addComponent(this.downloadButton).addComponent(this.manualButton)).addComponent(this.workerProgressBar, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void nameListValueChanged(ListSelectionEvent evt) {
        this.nameListSelected();
    }

    private void inversionListValueChanged(ListSelectionEvent evt) {
        this.inversionListSelected();
    }

    private void inversionListMouseClicked(MouseEvent evt) {
        Point p;
        int idx;
        if (evt.getClickCount() == 2 && this.okButton.isEnabled() && (idx = this.inversionList.locationToIndex(p = evt.getPoint())) >= 0 && this.inversionList.getCellBounds(idx, idx).contains(p)) {
            this.doClose(1);
        }
    }

    private void formWindowOpened(WindowEvent evt) {
        returnStatus = 0;
    }

    private void includeGroupSolnsChkBoxActionPerformed(ActionEvent evt) {
        Preferences prefs = SiftShare.getPreferences();
        prefs.putBoolean("GROUP_SOLUTIONS", this.includeGroupSolnsChkBox.isSelected());
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            SiftShare.log.log(Level.WARNING, null, ex);
        }
        this.getAllEvents();
    }

    private void downloadButtonActionPerformed(ActionEvent evt) {
        this.getAllEvents();
    }

    private void manualButtonActionPerformed(ActionEvent evt) {
        if (ManualEventDialog.showDialog(this, true) == 1) {
            this.currentEvent = ManualEventDialog.getSeismicEvent();
            this.currentSourceScenario = ManualEventDialog.getSourceScenario();
            this.doClose(1);
        }
    }

    private boolean showChangeSolutionWarning() {
        String noChangeMsg = "This model run has been run and has results.\nChanging the solution will invalidate and delete the results.\nTo save the run results, cancel and select the \"Create New Model Run\" option.\nDo you want to continue and delete the model run results?";
        int choice = JOptionPane.showConfirmDialog(this, noChangeMsg, "Solution Change Warning", 2, 2);
        return choice == 0;
    }

    private void doClose(int retStatus) {
        boolean solutionChanged = false;
        if (retStatus == 0) {
            returnStatus = 0;
            this.setVisible(false);
            return;
        }
        try {
            SourceCombo ssc = new SourceCombo(this.currentSourceScenario.getSourceNamesAndSlips(), PropagationDatabase.getInstance());
            SourceCombo sc = new SourceCombo(this.siteInfo.getSourceNamesAndSlips(), PropagationDatabase.getInstance());
            if (!sc.equals(ssc)) {
                solutionChanged = true;
            }
        }
        catch (PropagationDatabaseException ex) {
            SiftShare.log.log(Level.SEVERE, null, ex);
        }
        if (this.siteInfo.getTimestepsAvailable() > 0 && solutionChanged && !this.getCreateModelRun() && !this.showChangeSolutionWarning()) {
            return;
        }
        returnStatus = retStatus;
        this.setVisible(false);
    }

    public int getReturnStatus() {
        return returnStatus;
    }

    private void nameListSelected() {
        int s = this.nameList.getSelectedIndex();
        if (quakeEvents != null) {
            this.setSelectedSeismicEvent(s >= 0 ? quakeEvents.get(s) : null);
        }
    }

    private void inversionListSelected() {
        Object o = this.inversionList.getSelectedValue();
        if (o != null) {
            this.okButton.setEnabled(true);
            this.currentSourceScenario = (SourceScenario)o;
            this.setSSlabels(this.currentSourceScenario);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    private void getAllEvents() {
        EventLookupWorker eventWorker = new EventLookupWorker(projectMode, this.includeGroupSolnsChkBox.isSelected());
        this.workerProgressBar.setIndeterminate(true);
        this.nameList.setModel(new EventListModel(String.format("Contacting server for tsunami %ss...", this.eventOrProjectStr)));
        eventWorker.start();
    }

    public static void downloadTwebEvents() {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                String urlString = "https://nctr.pmel.noaa.gov/tweb/apx/event/?format=nctr_xml&limit=200";
                URL url = new URL(urlString);
                HttpURLConnection api = (HttpURLConnection)url.openConnection();
                api.addRequestProperty("Content-Type", "application/xml");
                api.addRequestProperty("User-Agent", "ComMIT/1.8.6");
                File f = File.createTempFile("downloadEvents", "xml");
                InputStream is = null;
                FileOutputStream fos = null;
                try {
                    is = api.getInputStream();
                    fos = new FileOutputStream(f);
                    ReadableByteChannel inch = Channels.newChannel(is);
                    fos.getChannel().transferFrom(inch, 0L, Long.MAX_VALUE);
                }
                catch (IOException x) {
                    SiftShare.log.log(Level.FINE, urlString, x);
                    throw x;
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                allEventsFile = new File(CMIUtil.etcDirName, "allEvents.xml");
                CMIUtil.copyFile(f, allEventsFile);
                return null;
            }

            @Override
            protected void done() {
                OpenEventDialog.loadQuakeEvents();
            }
        };
    }

    public static void loadQuakeEvents() {
        SiftShare.log.fine("Parsing quakes\n\n\n");
        long tic = System.currentTimeMillis();
        doneParsing = false;
        quakeEvents.clear();
        ngdcEventsFile = new File(CMIUtil.etcDirName, "ngdcEvents2022.txt");
        ngdcParser.parseEarthquakes(ngdcEventsFile, quakeEvents);
        Iterator<SeismicEvent> it = quakeEvents.iterator();
        while (it.hasNext()) {
            SeismicEvent se = it.next();
            if (!(se.getMagnitude() < 6.2)) continue;
            it.remove();
        }
        GregorianCalendar cal = new GregorianCalendar(1699, 6, 1);
        Iterator<SeismicEvent> it2 = quakeEvents.iterator();
        while (it2.hasNext()) {
            SeismicEvent se = it2.next();
            if (!se.getCalendar().before(cal)) continue;
            it2.remove();
        }
        PropagationDatabase propdb = PropagationDatabase.getInstance();
        int count = 0;
        for (SeismicEvent seismicEvent : quakeEvents) {
            String ssID = String.format("n%d", ++count);
            SourceCombo sourceCombo = propdb.getSeismicInversion(seismicEvent.getMagnitude(), seismicEvent.getLongitude(), seismicEvent.getLatitude());
            SourceScenario ss = new SourceScenario(ssID, seismicEvent, sourceCombo.getSourceNames(), SourceScenario.Type.SEISMIC);
            seismicEvent.addSourceScenario(ss);
        }
        for (SeismicEvent seismicEvent : quakeEvents) {
            String c = seismicEvent.getCountry();
            if (c.startsWith("USA")) {
                seismicEvent.setCountry(CountryBoundaries.getCountry(seismicEvent.getLongitude(), seismicEvent.getLatitude()));
                continue;
            }
            seismicEvent.setCountry(SeismicEvent.properNounCapitalize(c));
        }
        allEventsFile = new File(CMIUtil.etcDirName, "allEvents.xml");
        Vector<SeismicEvent> twebEvents = eventParser.getEvents(allEventsFile);
        for (SeismicEvent se : twebEvents) {
            se.setCountry(CountryBoundaries.getCountry(se.getLongitude(), se.getLatitude()));
        }
        Vector<SeismicEvent> vector = new Vector<SeismicEvent>();
        for (SeismicEvent se : quakeEvents) {
            for (SeismicEvent seTweb : twebEvents) {
                if (!seTweb.equals(se)) continue;
                vector.add(se);
            }
        }
        SiftShare.log.info("found: " + vector.size() + " duplicate events in ngdc events file, removing.\nNumber ngdc events: " + quakeEvents.size() + "\nNumber tweb events: " + twebEvents.size() + "\n");
        quakeEvents.removeAll(vector);
        quakeEvents.addAll(twebEvents);
        SeismicEvent.sortEventsByTime(quakeEvents);
        doneParsing = true;
        SiftShare.log.info("number quakeEvents: " + quakeEvents.size() + ", time to parse: " + (System.currentTimeMillis() - tic) / 1000L + " seconds.");
    }

    private void eventListUpdate() {
        if (quakeEvents != null && !quakeEvents.isEmpty()) {
            this.nameList.setModel(new EventListModel(quakeEvents));
            this.setSelectedScenario(this.currentSourceScenario);
            this.inversionList.requestFocusInWindow();
        } else {
            this.nameList.setModel(new EventListModel());
        }
    }

    private void updateAllEventsFile(File f) {
        if (f != null) {
            try {
                CMIUtil.copyFile(f, allEventsFile);
            }
            catch (IOException ex) {
                SiftShare.log.log(Level.INFO, null, ex);
            }
        }
    }

    public void setSelectedSeismicEvent(SeismicEvent se) {
        DecimalFormat dfx = new DecimalFormat("#.0");
        this.currentEvent = se;
        if (this.currentEvent == null) {
            return;
        }
        if (quakeEvents == null) {
            return;
        }
        if (!quakeEvents.contains(this.currentEvent)) {
            this.currentEvent = quakeEvents.get(0);
            ArrayList<SourceScenario> sclst = this.currentEvent.getScenarioList();
            this.currentSourceScenario = sclst.size() > 0 ? (SourceScenario)sclst.get(0) : null;
        }
        this.nameList.setSelectedValue(this.currentEvent, true);
        this.dateLabel.setText(this.currentEvent.getTime());
        this.magLabel.setText(dfx.format(this.currentEvent.getMagnitude()));
        this.depthLabel.setText(dfx.format(this.currentEvent.getDepth()));
        this.epiLabel.setText(this.currentEvent.getEpicenterString());
        this.eventEditor.setEpicenter(this.currentEvent.getLongitude(), this.currentEvent.getLatitude());
        this.eventEditor.zoomTo(this.currentEvent.getLongitude(), this.currentEvent.getLatitude());
        this.eventEditor.zoom(14);
        this.eventEditor.plotMark(true);
        ArrayList<SourceScenario> sortedScenarios = new ArrayList<SourceScenario>(this.currentEvent.getScenarioList());
        Collections.sort(sortedScenarios, new Comparator<SourceScenario>(){

            @Override
            public int compare(SourceScenario o1, SourceScenario o2) {
                int ordering = -1;
                if (o1.isAuthoritative()) {
                    return ordering;
                }
                if (o2.isAuthoritative()) {
                    return -ordering;
                }
                if (o1.isPublished()) {
                    return ordering;
                }
                if (o2.isPublished()) {
                    return -ordering;
                }
                int type = o1.getType().compareTo(o2.getType());
                int time = (int)(o2.getTimestamp() - o1.getTimestamp());
                return type != 0 ? type : time;
            }
        });
        this.inversionList.setModel(new SourceScenarioListModel(sortedScenarios));
        if (this.currentSourceScenario == null || !se.equals(this.currentSourceScenario.getSeismicEvent()) || !this.currentEvent.getScenarioList().contains(this.currentSourceScenario)) {
            this.inversionList.setSelectedIndex(0);
        } else {
            this.inversionList.setSelectedValue(this.currentSourceScenario, true);
            this.inversionList.requestFocusInWindow();
        }
        this.inversionList.requestFocusInWindow();
    }

    public SeismicEvent getSelectedSeismicEvent() {
        return this.currentEvent;
    }

    public SourceScenario getSelectedSourceScenario() {
        return this.currentSourceScenario;
    }

    private void clearSSlabels() {
        this.createdLabel.setText("");
        this.creatorLabel.setText("");
        this.authorityLabel.setText("");
    }

    private void setSSlabels(SourceScenario ss) {
        this.createdLabel.setText(ss.getTimestampString());
        this.creatorLabel.setText(ss.getUser());
        this.authorityLabel.setText(ss.getAuthority());
    }

    public void setSelectedScenario(SourceScenario sourceScenario) {
        if (sourceScenario == null) {
            this.clearSSlabels();
            return;
        }
        this.currentSourceScenario = sourceScenario;
        SeismicEvent e = this.currentSourceScenario.getSeismicEvent();
        if (e != null) {
            this.setSelectedSeismicEvent(e);
        }
        this.setSSlabels(this.currentSourceScenario);
    }

    public boolean getCreateModelRun() {
        return this.createModelRunCheckBox.isSelected();
    }

    public static void main(String[] args) {
        OpenEventDialog.loadQuakeEvents();
    }

    private class EventListModel
    extends AbstractListModel {
        private Vector<SeismicEvent> sev;

        public EventListModel() {
            this(new Vector<SeismicEvent>());
        }

        public EventListModel(Vector<SeismicEvent> v) {
            if (v != null) {
                this.sev = v;
            }
        }

        public EventListModel(String msg) {
            SeismicEvent se = new SeismicEvent();
            se.setName(msg);
            this.sev = new Vector();
            this.sev.add(se);
        }

        @Override
        public int getSize() {
            return this.sev.size();
        }

        @Override
        public Object getElementAt(int index) {
            SeismicEvent se = this.sev.get(index);
            return se;
        }

        public boolean contains(SeismicEvent se) {
            return this.sev.contains(se);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (SeismicEvent se : this.sev) {
                sb.append(se.toString());
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    private class EventLookupWorker
    extends TsunamicastWorker {
        final boolean projectMode;
        boolean getGroupSolutions;

        private EventLookupWorker(boolean projectMode, boolean getGroupSolutions) {
            this.projectMode = projectMode;
            this.getGroupSolutions = getGroupSolutions;
        }

        @Override
        public Object construct() {
            try {
                boolean usePublic = !OpenEventDialog.this.includeGroupSolnsChkBox.isSelected();
                String apiPath = usePublic ? "apx/" : "api/1/";
                String host = CMIUtil.tsunamiCastAddress;
                if (!host.endsWith("/")) {
                    host = host + "/";
                }
                this.client = TsunamicastClient.get(new URL(host), apiPath);
                return this.contactServer(this.client);
            }
            catch (TsunamicastClient.AuthorizationRequired ex) {
                this.authenticationFailure = true;
            }
            catch (TsunamicastClient.Redirected ex) {
                this.redirect = ex.getLocation();
            }
            catch (Exception ex) {
                SiftShare.log.log(Level.INFO, "tsunamicast contact error:", ex);
                this.error = ex;
            }
            return null;
        }

        @Override
        protected Object contactServer(TsunamicastClient client) throws IOException, TsunamicastClient.AuthorizationRequired, TsunamicastClient.Redirected {
            if (this.projectMode || this.getGroupSolutions) {
                client.requireLogin();
            }
            String apiUrl = client.getResourceIndexURI(this.projectMode ? "project" : "event");
            HashMap<String, String> params = new HashMap<String, String>(4);
            params.put("format", "nctr_xml");
            params.put("limit", "200");
            File f = File.createTempFile("downloadEvents", "xml");
            InputStream is = null;
            FileOutputStream fos = null;
            try {
                is = client.apiGetStream(apiUrl, params);
                fos = new FileOutputStream(f);
                ReadableByteChannel inch = Channels.newChannel(is);
                fos.getChannel().transferFrom(inch, 0L, Long.MAX_VALUE);
            }
            catch (IOException x) {
                SiftShare.log.log(Level.FINE, apiUrl, x);
                throw x;
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            return f;
        }

        @Override
        protected void handleAuthenticationCancel() {
            super.handleAuthenticationCancel();
        }

        @Override
        protected void handleError() {
            super.handleError();
            OpenEventDialog.loadQuakeEvents();
            OpenEventDialog.this.eventListUpdate();
        }

        @Override
        protected void handleSuccess() {
            super.handleSuccess();
            OpenEventDialog.this.updateAllEventsFile((File)this.get());
            OpenEventDialog.loadQuakeEvents();
            OpenEventDialog.this.eventListUpdate();
        }

        @Override
        public void finished() {
            OpenEventDialog.this.workerProgressBar.setIndeterminate(false);
            super.finished();
        }
    }
}

