/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.SiteInfo;
import gov.noaa.tsunami.cmi.macosx.JAnimatingProgressBar;
import java.awt.EventQueue;
import javax.swing.JTextArea;

public class OutputMessageHandler {
    private final JAnimatingProgressBar progressBar;
    private final JTextArea outputLogArea;

    public OutputMessageHandler(JTextArea outputLogArea, JAnimatingProgressBar progressBar) {
        this.outputLogArea = outputLogArea;
        this.progressBar = progressBar;
    }

    public void clear() {
        Runnable clearRun = new Runnable(){

            @Override
            public void run() {
                OutputMessageHandler.this.outputLogArea.setText(null);
            }
        };
        this.runInDispatchThread(clearRun);
    }

    public void indeterminateProgressBar(final String message) {
        if (message != null) {
            Runnable updateRun = new Runnable(){

                @Override
                public void run() {
                    OutputMessageHandler.this.progressBar.setIndeterminate(false);
                    OutputMessageHandler.this.progressBar.setString(message);
                }
            };
            this.runInDispatchThread(updateRun);
        }
    }

    public void updateProgressBar(final String message, final int currentProgress, final int maxProgress) {
        Runnable updateRun = new Runnable(){

            @Override
            public void run() {
                OutputMessageHandler.this.progressBar.setAnimating(true);
                OutputMessageHandler.this.progressBar.setIndeterminate(false);
                if (message != null) {
                    OutputMessageHandler.this.progressBar.setString(message);
                }
                if (currentProgress >= 0) {
                    OutputMessageHandler.this.progressBar.setValue(currentProgress);
                }
                if (maxProgress >= 0) {
                    OutputMessageHandler.this.progressBar.setMaximum(maxProgress);
                }
            }
        };
        this.runInDispatchThread(updateRun);
    }

    public void appendLogText(final String msg) {
        Runnable appendRun = new Runnable(){

            @Override
            public void run() {
                OutputMessageHandler.this.outputLogArea.append(msg);
                OutputMessageHandler.this.outputLogArea.setCaretPosition(OutputMessageHandler.this.outputLogArea.getDocument().getLength());
            }
        };
        this.runInDispatchThread(appendRun);
    }

    private void runInDispatchThread(Runnable run) {
        if (EventQueue.isDispatchThread()) {
            run.run();
        } else {
            EventQueue.invokeLater(run);
        }
    }

    public void setStoppedProgressBar(SiteInfo site) {
        if (site == null) {
            this.progressBar.setString("");
            this.progressBar.setEnabled(false);
            this.progressBar.setValue(0);
            this.progressBar.setMaximum(0);
        } else {
            int curts = site.getTimestepsAvailable();
            int maxts = site.getNumberOutputTimesteps();
            String msg = String.format("%s %s: step %d of %d", site.getName(), curts == maxts ? "finished" : "stopped", curts, maxts);
            this.progressBar.setMaximum(maxts);
            this.progressBar.setValue(curts);
            this.progressBar.setString(msg);
            this.progressBar.setEnabled(true);
            this.progressBar.setAnimating(false);
        }
    }
}

