/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.websift.propdb.PropagationDatabase;
import gov.noaa.tsunami.websift.propdb.SourceCombo;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jdesktop.layout.GroupLayout;

public class PasteInversionDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private static int returnStatus = 0;
    private static String invString;
    private static LinkedHashSet<SourceCombo> sourceSet;
    private static final PropagationDatabase propdb;
    private JButton cancelButton;
    private JButton jButton1;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private static JTextField jTextField1;
    private JButton okButton;

    public PasteInversionDialog(Frame parent, boolean modal) {
        super(parent, modal);
        sourceSet.clear();
        this.initComponents();
        jTextField1.setText(CMIUtil.currentSiteInfo.getSourceNamesAndSlips());
        CMIUtil.installEscapeCloseOperation(this);
    }

    public int getReturnStatus() {
        return returnStatus;
    }

    public static LinkedHashSet<SourceCombo> getSourceSet() {
        return sourceSet;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        jTextField1 = new JTextField();
        this.jComboBox1 = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jButton1 = new JButton();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PasteInversionDialog.this.formWindowClosing(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setFont(new Font("Dialog", 0, 14));
        this.jLabel1.setText("Paste Source Combination:");
        this.jLabel2.setFont(new Font("Dialog", 0, 12));
        this.jLabel2.setText("(e.g., 2.75 * iosza23 + 1.63 * ioszb23)");
        jTextField1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PasteInversionDialog.this.jTextField1PropertyChange(evt);
            }
        });
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"NCTR Test sources (mega-tsunamis)", "ACSZ A6-A15, B6-B15", "ACSZ A16-A25, B16-B25", "ACSZ A22-A31, B22-B31", "ACSZ A50-A59, B50-B59", "ACSZ A56-A65, B56-B65", "CSSZ A1-A10, B1-B10", "CSSZ A37-A46, B37-B46", "CSSZ A89-A98, B89-B98", "CSSZ A102-A111, B102-B111", "EPSZ A6-A15, B6-B15", "KISZ A1-A10, B1-B10", "KISZ A22-A31, B22-B31", "KISZ A32-A41, B32-B41", "KISZ A56-A65, B56-B65", "MOSZ A1-A10, B1-B10", "NGSZ A3-A12, B3-B12", "NTSZ A30-A39, B30-B39", "NVSZ A28-A37, B28-B37", "RNSZ A12-A21, B12-B21", "ATSZ A38-A47, B38-B47", "ATSZ A48-A57, B48-B57", "ATSZ A58-A67, B58-B67", "ATSZ A68-A77, B68-B77", "ATSZ A82-A91, B82-B91", "SSSZ A1-A10, B1-B10"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PasteInversionDialog.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("NCTR Test sources");
        this.jButton1.setText("Load from XML file");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PasteInversionDialog.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1).add(this.jLabel2, -1, 858, Short.MAX_VALUE).add(this.jLabel1, -1, 858, Short.MAX_VALUE).add(jTextField1, -1, 858, Short.MAX_VALUE).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(this.jComboBox1, -2, 271, -2).add(this.jLabel3).add(this.jButton1)).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(this.jLabel1).addPreferredGap(0).add(this.jLabel2).addPreferredGap(0).add(jTextField1, -2, -1, -2).add(18, 18, 18).add(this.jLabel3).add(3, 3, 3).add(this.jComboBox1, -2, -1, -2).add(18, 18, 18).add(this.jButton1).addContainerGap(21, Short.MAX_VALUE)));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PasteInversionDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PasteInversionDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(2, this.jPanel1, -1, -1, Short.MAX_VALUE).add(2, layout.createSequentialGroup().add(this.okButton).addPreferredGap(0).add(this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(1).add(layout.createParallelGroup(3).add(this.cancelButton).add(this.okButton)).addContainerGap()));
        this.pack();
    }

    private void jTextField1PropertyChange(PropertyChangeEvent evt) {
        invString = jTextField1.getText();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.doClose(0);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        String test = "";
        String zone = "";
        StringBuffer sb = new StringBuffer();
        int start = 0;
        int end = 0;
        test = (String)this.jComboBox1.getSelectedItem();
        if (test.startsWith("ACSZ A6")) {
            zone = "ac";
            start = 6;
            end = 15;
        } else if (test.startsWith("ACSZ A16")) {
            zone = "ac";
            start = 16;
            end = 25;
        } else if (test.startsWith("ACSZ A22")) {
            zone = "ac";
            start = 22;
            end = 31;
        } else if (test.startsWith("ACSZ A50")) {
            zone = "ac";
            start = 50;
            end = 59;
        } else if (test.startsWith("ACSZ A56")) {
            zone = "ac";
            start = 56;
            end = 65;
        } else if (test.startsWith("ACSZ 6")) {
            zone = "ac";
            start = 46;
            end = 55;
        } else if (test.startsWith("ACSZ 7")) {
            zone = "ac";
            start = 56;
            end = 65;
        } else if (test.startsWith("CSSZ A1-")) {
            zone = "cs";
            start = 1;
            end = 10;
        } else if (test.startsWith("CSSZ A37")) {
            zone = "cs";
            start = 37;
            end = 46;
        } else if (test.startsWith("CSSZ A89")) {
            zone = "cs";
            start = 89;
            end = 98;
        } else if (test.startsWith("CSSZ A102")) {
            zone = "cs";
            start = 102;
            end = 111;
        } else if (test.startsWith("CSSZ 5")) {
            zone = "cs";
            start = 41;
            end = 50;
        } else if (test.startsWith("CSSZ 6")) {
            zone = "cs";
            start = 51;
            end = 60;
        } else if (test.startsWith("CSSZ 7")) {
            zone = "cs";
            start = 61;
            end = 70;
        } else if (test.startsWith("CSSZ 8")) {
            zone = "cs";
            start = 71;
            end = 80;
        } else if (test.startsWith("CSSZ 9")) {
            zone = "cs";
            start = 81;
            end = 90;
        } else if (test.startsWith("CSSZ 10")) {
            zone = "cs";
            start = 91;
            end = 100;
        } else if (test.startsWith("CSSZ 11")) {
            zone = "cs";
            start = 101;
            end = 110;
        } else if (test.startsWith("CSSZ 12")) {
            zone = "cs";
            start = 106;
            end = 115;
        } else if (test.startsWith("NTSZ 1")) {
            zone = "nt";
            start = 1;
            end = 10;
        } else if (test.startsWith("NTSZ 2")) {
            zone = "nt";
            start = 11;
            end = 20;
        } else if (test.startsWith("NTSZ 3")) {
            zone = "nt";
            start = 21;
            end = 30;
        } else if (test.startsWith("NTSZ A30")) {
            zone = "nt";
            start = 30;
            end = 39;
        } else if (test.startsWith("NVSZ 1")) {
            zone = "nv";
            start = 1;
            end = 10;
        } else if (test.startsWith("NVSZ 2")) {
            zone = "nv";
            start = 11;
            end = 20;
        } else if (test.startsWith("NVSZ 3")) {
            zone = "nv";
            start = 21;
            end = 30;
        } else if (test.startsWith("NVSZ A28")) {
            zone = "nv";
            start = 28;
            end = 37;
        } else if (test.startsWith("MOSZ A1")) {
            zone = "mo";
            start = 1;
            end = 10;
        } else if (test.startsWith("MOSZ 2")) {
            zone = "mo";
            start = 8;
            end = 17;
        } else if (test.startsWith("NGSZ A3")) {
            zone = "ng";
            start = 3;
            end = 12;
        } else if (test.startsWith("NGSZ 2")) {
            zone = "ng";
            start = 6;
            end = 15;
        } else if (test.startsWith("EPSZ 1")) {
            zone = "ep";
            start = 1;
            end = 10;
        } else if (test.startsWith("EPSZ A6")) {
            zone = "ep";
            start = 6;
            end = 15;
        } else if (test.startsWith("RNSZ 1")) {
            zone = "rn";
            start = 1;
            end = 10;
        } else if (test.startsWith("RNSZ A12")) {
            zone = "rn";
            start = 12;
            end = 21;
        } else if (test.startsWith("KISZ A1")) {
            zone = "ki";
            start = 1;
            end = 10;
        } else if (test.startsWith("KISZ A22")) {
            zone = "ki";
            start = 22;
            end = 31;
        } else if (test.startsWith("KISZ 3")) {
            zone = "ki";
            start = 21;
            end = 30;
        } else if (test.startsWith("KISZ A32")) {
            zone = "ki";
            start = 32;
            end = 41;
        } else if (test.startsWith("KISZ 5")) {
            zone = "ki";
            start = 41;
            end = 50;
        } else if (test.startsWith("KISZ A56")) {
            zone = "ki";
            start = 56;
            end = 65;
        } else if (test.startsWith("KISZ 7")) {
            zone = "ki";
            start = 56;
            end = 65;
        } else if (test.startsWith("KISZ 8")) {
            zone = "ki";
            start = 66;
            end = 75;
        } else if (test.startsWith("ATSZ A38")) {
            zone = "at";
            start = 38;
            end = 47;
        } else if (test.startsWith("ATSZ A48")) {
            zone = "at";
            start = 48;
            end = 57;
        } else if (test.startsWith("ATSZ A58")) {
            zone = "at";
            start = 58;
            end = 67;
        } else if (test.startsWith("ATSZ A68")) {
            zone = "at";
            start = 68;
            end = 77;
        } else if (test.startsWith("ATSZ A82")) {
            zone = "at";
            start = 82;
            end = 91;
        } else if (test.startsWith("SSSZ A1")) {
            zone = "ss";
            start = 1;
            end = 75;
        }
        for (int i = start; i <= end; ++i) {
            sb.append("25.0*" + zone + i + "a+25.0*" + zone + i + "b+");
        }
        sb.deleteCharAt(sb.length() - 1);
        jTextField1.setText(sb.toString());
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        FileNameExtensionFilter xmlFilter = new FileNameExtensionFilter("xml files (*.xml)", "xml");
        fileChooser.addChoosableFileFilter(xmlFilter);
        fileChooser.setFileFilter(xmlFilter);
        fileChooser.setSelectedFile(new File("assessment.xml"));
        int retrival = fileChooser.showOpenDialog(this);
        if (retrival == 0) {
            this.parseSources(fileChooser.getSelectedFile());
        }
    }

    private void parseSources(File f) {
        Charset charset = Charset.forName("US-ASCII");
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(f.getPath(), new String[0]), charset);){
            String line = null;
            sourceSet.clear();
            while ((line = reader.readLine()) != null) {
                int idx = line.indexOf("<inversion>");
                if (idx == -1) continue;
                String inv = line.substring(idx + 11, line.indexOf("</inversion>"));
                SourceCombo sc = propdb.getSourceCombo(inv);
                if (sc != null && sc.getNumberOfSources() > 0) {
                    sourceSet.add(sc);
                    continue;
                }
                SiftShare.log.warning("bad inversion in Hazard sources xml file: " + inv);
            }
            invString = "loaded XML file, # sources: " + sourceSet.size();
            jTextField1.setText(invString);
            SiftShare.log.info("number sources parsed: " + sourceSet.size());
        }
        catch (IOException e) {
            SiftShare.log.log(Level.WARNING, "error parsing Hazard sources xml file", e);
        }
    }

    public static int showDialog(Frame f, boolean b) {
        PasteInversionDialog dialog = new PasteInversionDialog(f, b);
        invString = jTextField1.getText();
        dialog.setVisible(true);
        dialog.dispose();
        return returnStatus;
    }

    private void doClose(int retStatus) {
        SourceCombo sc;
        returnStatus = retStatus;
        if (returnStatus == 1 && !(invString = jTextField1.getText()).startsWith("loaded XML file") && invString.length() > 0 && (sc = propdb.getSourceCombo(invString)) != null && sc.getNumberOfSources() > 0) {
            sourceSet.add(sc);
        }
        this.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new PasteInversionDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    static {
        sourceSet = new LinkedHashSet();
        propdb = PropagationDatabase.getInstance();
    }
}

