/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.ComMITServerSelector;
import gov.noaa.tsunami.cmi.IndeterminateProgressMonitor;
import gov.noaa.tsunami.cmi.MostExecDownloader;
import gov.noaa.tsunami.cmi.MovedDirectoryDialog;
import gov.noaa.tsunami.cmi.OpenDAPDialog;
import gov.noaa.tsunami.cmi.ResultGraphicsPanel;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import gov.noaa.tsunami.cmi.SwingWorker;
import gov.noaa.tsunami.websift.ee.UniqueListModel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class PrefsDialog
extends JDialog
implements PropertyChangeListener {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private int returnStatus = 0;
    private final Preferences preferences;
    private final UniqueListModel<String> listModel;
    private final SiftShare siftShare;
    private DefaultFormatter nonOverstrikeFormatter;
    private DefaultFormatterFactory nonOverstrikeFormatterFactory;
    private JButton addDirButton;
    private JButton addOpenDAPButton;
    private JButton cancelButton;
    private JButton commitDirButton;
    private JFormattedTextField commitDirTextField;
    private JButton commitServerButton;
    private JFormattedTextField commitServerTextField;
    private JButton deleteButton;
    private JButton downButton;
    private JCheckBox exitCheckBox;
    private JCheckBox globalPropCheckBox;
    private JComboBox graphicsComboBox;
    private JLabel graphicsLabel;
    private JButton gridsDirButton;
    private JFormattedTextField gridsDirTextField;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JComboBox levelComboBox;
    private JButton mostDownloadButton;
    private JButton mostExecButton;
    private JFormattedTextField mostExecTextField;
    private JButton nctrDefaultsButton;
    private JFormattedTextField numArrowsFormattedTextField;
    private JButton okButton;
    private JList propDbList;
    private JCheckBox proxyCheckBox;
    private JPasswordField proxyPasswordField;
    private JFormattedTextField proxyPortTextField;
    private JFormattedTextField proxyServerTextField;
    private JFormattedTextField proxyUserTextField;
    private JButton scratchDirButton;
    private JFormattedTextField scratchDirTextField;
    private JFormattedTextField tsunamicastServerField;
    private JButton upButton;

    public PrefsDialog(SiftShare parent, boolean modal, Preferences p) {
        super((Frame)parent, modal);
        this.siftShare = parent;
        this.preferences = p;
        this.listModel = new UniqueListModel();
        this.nonOverstrikeFormatter = new DefaultFormatter();
        this.nonOverstrikeFormatter.setOverwriteMode(false);
        this.nonOverstrikeFormatterFactory = new DefaultFormatterFactory(this.nonOverstrikeFormatter);
        this.initComponents();
        CMIUtil.installEscapeCloseOperation(this);
        NumberFormatter portFormat = new NumberFormatter(new DecimalFormat("####"));
        this.proxyPortTextField.setFormatterFactory(new DefaultFormatterFactory(portFormat));
        this.propDbList.setModel(this.listModel);
        Vector<Level> levels = new Vector<Level>();
        levels.add(Level.ALL);
        levels.add(Level.FINEST);
        levels.add(Level.FINER);
        levels.add(Level.FINE);
        levels.add(Level.CONFIG);
        levels.add(Level.INFO);
        levels.add(Level.WARNING);
        levels.add(Level.SEVERE);
        levels.add(Level.OFF);
        this.levelComboBox.setModel(new DefaultComboBoxModel(levels));
        try {
            this.levelComboBox.setSelectedItem(Level.parse(CMIUtil.logLevel == null ? Level.INFO.toString() : CMIUtil.logLevel));
        }
        catch (IllegalArgumentException ex) {
            this.levelComboBox.setSelectedItem(Level.INFO);
        }
        this.loadPrefs();
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.commitDirButton = new JButton();
        this.commitDirTextField = new JFormattedTextField();
        this.gridsDirButton = new JButton();
        this.gridsDirTextField = new JFormattedTextField();
        this.scratchDirButton = new JButton();
        this.scratchDirTextField = new JFormattedTextField();
        this.mostExecButton = new JButton();
        this.mostExecTextField = new JFormattedTextField();
        this.mostDownloadButton = new JButton();
        this.commitServerButton = new JButton();
        this.commitServerTextField = new JFormattedTextField();
        this.jLabel1 = new JLabel();
        this.levelComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.exitCheckBox = new JCheckBox();
        this.tsunamicastServerField = new JFormattedTextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.numArrowsFormattedTextField = new JFormattedTextField();
        this.graphicsComboBox = new JComboBox();
        this.graphicsLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.propDbList = new JList();
        JLabel jLabel3 = new JLabel();
        this.addDirButton = new JButton();
        this.addOpenDAPButton = new JButton();
        this.deleteButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.nctrDefaultsButton = new JButton();
        this.globalPropCheckBox = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.proxyPasswordField = new JPasswordField();
        JLabel jLabel7 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.proxyCheckBox = new JCheckBox();
        JLabel jLabel8 = new JLabel();
        this.proxyUserTextField = new JFormattedTextField();
        this.proxyServerTextField = new JFormattedTextField();
        this.proxyPortTextField = new JFormattedTextField();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("ComMIT Preferences");
        this.commitDirButton.setText("ComMIT Directory");
        this.commitDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.commitDirButtonActionPerformed(evt);
            }
        });
        this.commitDirTextField.setEditable(false);
        this.commitDirTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PrefsDialog.this.commitDirTextFieldPropertyChange(evt);
            }
        });
        this.gridsDirButton.setText("Grids Directory");
        this.gridsDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.gridsDirButtonActionPerformed(evt);
            }
        });
        this.gridsDirTextField.setEditable(false);
        this.gridsDirTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PrefsDialog.this.gridsDirTextFieldPropertyChange(evt);
            }
        });
        this.scratchDirButton.setText("Scratch Directory");
        this.scratchDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.scratchDirButtonActionPerformed(evt);
            }
        });
        this.scratchDirTextField.setEditable(false);
        this.scratchDirTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PrefsDialog.this.scratchDirTextFieldPropertyChange(evt);
            }
        });
        this.mostExecButton.setText("Most Executable");
        this.mostExecButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.mostExecButtonActionPerformed(evt);
            }
        });
        this.mostExecTextField.setEditable(false);
        this.mostExecTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PrefsDialog.this.mostExecTextFieldPropertyChange(evt);
            }
        });
        this.mostDownloadButton.setText("Download now");
        this.mostDownloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.mostDownloadButtonActionPerformed(evt);
            }
        });
        this.commitServerButton.setText("ComMIT Server");
        this.commitServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.commitServerButtonActionPerformed(evt);
            }
        });
        this.commitServerTextField.setEditable(false);
        this.jLabel1.setText("Debug log level:");
        this.levelComboBox.setMaximumRowCount(9);
        this.levelComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.levelComboBoxActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Confirm on exit:");
        this.exitCheckBox.setSelected(true);
        this.exitCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.exitCheckBoxActionPerformed(evt);
            }
        });
        this.tsunamicastServerField.setFormatterFactory(this.nonOverstrikeFormatterFactory);
        this.tsunamicastServerField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.tsunamicastServerFieldActionPerformed(evt);
            }
        });
        this.jLabel4.setText("TWeb Server");
        this.jLabel5.setText("Max number of arrows: ");
        this.jLabel5.setToolTipText("Maximum number of arrows in each dimension for vector plots");
        this.numArrowsFormattedTextField.setColumns(5);
        this.numArrowsFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.numArrowsFormattedTextField.setHorizontalAlignment(0);
        this.numArrowsFormattedTextField.setText("120");
        this.numArrowsFormattedTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PrefsDialog.this.numArrowsFormattedTextFieldPropertyChange(evt);
            }
        });
        this.graphicsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Low", "Medium", "High", "Full"}));
        this.graphicsComboBox.setSelectedIndex(1);
        this.graphicsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.graphicsComboBoxActionPerformed(evt);
            }
        });
        this.graphicsLabel.setText("Graphics Resolution: ");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.commitServerButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.mostExecButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.scratchDirButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.gridsDirButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.commitDirButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addGap(8, 8, 8))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.commitDirTextField, -1, 682, Short.MAX_VALUE).addComponent(this.gridsDirTextField, -1, 682, Short.MAX_VALUE).addComponent(this.scratchDirTextField, -1, 682, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.mostExecTextField, -1, 533, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mostDownloadButton)).addComponent(this.commitServerTextField, -1, 682, Short.MAX_VALUE).addComponent(this.tsunamicastServerField, -1, 682, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exitCheckBox)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addGap(18, 18, 18).addComponent(this.numArrowsFormattedTextField, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.graphicsLabel).addGap(18, 18, 18).addComponent(this.graphicsComboBox, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.levelComboBox, -2, 140, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.commitDirButton).addComponent(this.commitDirTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.gridsDirButton).addComponent(this.gridsDirTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scratchDirButton).addComponent(this.scratchDirTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mostExecButton).addComponent(this.mostExecTextField, -2, -1, -2).addComponent(this.mostDownloadButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.commitServerButton).addComponent(this.commitServerTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tsunamicastServerField, -2, -1, -2).addComponent(this.jLabel4)).addGap(28, 28, 28).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.levelComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.exitCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.numArrowsFormattedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.graphicsComboBox, -2, -1, -2).addComponent(this.graphicsLabel)).addContainerGap(7, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("General", this.jPanel1);
        this.propDbList.setCellRenderer(new UnitSourceListCellRenderer());
        this.propDbList.setDragEnabled(true);
        this.jScrollPane1.setViewportView(this.propDbList);
        jLabel3.setText("Database Locations:");
        this.addDirButton.setText("Add Local Directory");
        this.addDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.addDirButtonActionPerformed(evt);
            }
        });
        this.addOpenDAPButton.setText("Add Remote Server");
        this.addOpenDAPButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.addOpenDAPButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.deleteButtonActionPerformed(evt);
            }
        });
        this.upButton.setIcon(new ImageIcon(this.getClass().getResource("/gov/noaa/tsunami/cmi/images/Up24.gif")));
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.upButtonActionPerformed(evt);
            }
        });
        this.downButton.setIcon(new ImageIcon(this.getClass().getResource("/gov/noaa/tsunami/cmi/images/Down24.gif")));
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.downButtonActionPerformed(evt);
            }
        });
        this.nctrDefaultsButton.setText("Reset to Defaults");
        this.nctrDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.nctrDefaultsButtonActionPerformed(evt);
            }
        });
        this.globalPropCheckBox.setSelected(true);
        this.globalPropCheckBox.setText("Use Global PropDB");
        this.globalPropCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.globalPropCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel3).addGroup(jPanel2Layout.createSequentialGroup().addGap(53, 53, 53).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.downButton, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addComponent(this.upButton, GroupLayout.Alignment.LEADING, -1, 42, Short.MAX_VALUE))).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.nctrDefaultsButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.deleteButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.addOpenDAPButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.addDirButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 686, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.globalPropCheckBox).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(jLabel3).addGap(18, 18, 18).addComponent(this.addDirButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.addOpenDAPButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.deleteButton).addGap(18, 18, 18).addComponent(this.upButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.downButton, -2, 24, -2).addGap(18, 18, 18).addComponent(this.nctrDefaultsButton))).addGap(18, 18, 18).addComponent(this.globalPropCheckBox).addContainerGap(94, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Propagation Database", this.jPanel2);
        this.proxyPasswordField.setEditable(false);
        this.proxyPasswordField.setText("abc123");
        this.proxyPasswordField.setToolTipText("Proxy Server password");
        this.proxyPasswordField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.proxyPasswordFieldActionPerformed(evt);
            }
        });
        jLabel7.setText("Use Proxy Server:");
        this.jLabel11.setText("Password:");
        this.jLabel9.setText("Proxy Port:");
        this.jLabel10.setText("User Name:");
        this.proxyCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.proxyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.proxyCheckBoxActionPerformed(evt);
            }
        });
        jLabel8.setText("Proxy Server:");
        this.proxyUserTextField.setEditable(false);
        this.proxyUserTextField.setText("yourProxyUserName");
        this.proxyUserTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PrefsDialog.this.proxyUserTextFieldPropertyChange(evt);
            }
        });
        this.proxyServerTextField.setEditable(false);
        this.proxyServerTextField.setText("your.proxy.server");
        this.proxyServerTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PrefsDialog.this.proxyServerTextFieldPropertyChange(evt);
            }
        });
        this.proxyPortTextField.setEditable(false);
        this.proxyPortTextField.setHorizontalAlignment(0);
        this.proxyPortTextField.setText("85");
        this.proxyPortTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PrefsDialog.this.proxyPortTextFieldPropertyChange(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel8).addComponent(jLabel7).addComponent(this.jLabel9).addComponent(this.jLabel10).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proxyCheckBox).addComponent(this.proxyServerTextField, -2, 298, -2).addComponent(this.proxyPortTextField, -2, 41, -2).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.proxyPasswordField, GroupLayout.Alignment.LEADING).addComponent(this.proxyUserTextField, GroupLayout.Alignment.LEADING, -1, 220, Short.MAX_VALUE))).addContainerGap(440, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel7).addComponent(this.proxyCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel8).addComponent(this.proxyServerTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.proxyPortTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10, -2, 16, -2).addComponent(this.proxyUserTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.proxyPasswordField, -2, -1, -2)).addContainerGap(244, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Network", this.jPanel3);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jTabbedPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap(18, Short.MAX_VALUE)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.returnStatus = 1;
        CMIUtil.tsunamiCastAddress = this.tsunamicastServerField.getText();
        this.updateDatabaseLocation();
        this.savePrefs();
        this.setVisible(false);
        this.siftShare.updateEventEditor(true);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.returnStatus = 0;
        this.setVisible(false);
    }

    private void addDirButtonActionPerformed(ActionEvent evt) {
        File toAdd = this.setDirectory(CMIUtil.baseDirName);
        SiftShare.log.fine("directory to add: " + toAdd);
        if (toAdd == null) {
            return;
        }
        this.listModel.add(0, toAdd.getPath());
        this.propDbList.setSelectedIndex(0);
        this.deleteButton.setEnabled(true);
        try {
            final String fileName = toAdd.getCanonicalPath();
            int result = JOptionPane.showConfirmDialog(this, "Check this directory for propagation files?\n  " + fileName + "\nThis may take time.", "Add Propagation Database Directory", 0, 3);
            if (result == 0) {
                final IndeterminateProgressMonitor pm = new IndeterminateProgressMonitor(this, "updating local propagation database directory (info_sz.dat) ...");
                pm.setLocation(this.getLocation().x + 30, this.getLocation().y + 50);
                pm.setAlwaysOnTop(true);
                pm.setVisible(true);
                SwingWorker propWorker = new SwingWorker(){

                    @Override
                    public Object construct() {
                        CMIUtil.updateInfoSZ(fileName, pm);
                        return null;
                    }

                    @Override
                    public void finished() {
                        pm.closeMe();
                    }
                };
                pm.setSwingWorker(propWorker);
                propWorker.start();
            }
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.WARNING, "can't getCanonicalPath", ex);
        }
    }

    private void addOpenDAPButtonActionPerformed(ActionEvent evt) {
        if (OpenDAPDialog.showDialog(this, true) == 1) {
            for (String s : OpenDAPDialog.getEnteredURLs()) {
                this.listModel.addElement(s);
            }
        }
        this.deleteButton.setEnabled(true);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int[] sel = this.propDbList.getSelectedIndices();
        while (sel.length > 0) {
            this.listModel.remove(sel[0]);
            sel = this.propDbList.getSelectedIndices();
        }
        if (this.listModel.getSize() == 0) {
            this.deleteButton.setEnabled(false);
        }
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        int index = this.propDbList.getSelectedIndex();
        if (index <= 0) {
            return;
        }
        String obj = this.listModel.remove(index);
        this.listModel.add(index - 1, obj);
        this.propDbList.setSelectedIndex(index - 1);
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        int index = this.propDbList.getSelectedIndex();
        if (index < 0 || index == this.listModel.getSize() - 1) {
            return;
        }
        String obj = this.listModel.remove(index);
        this.listModel.add(index + 1, obj);
        this.propDbList.setSelectedIndex(index + 1);
    }

    private void nctrDefaultsButtonActionPerformed(ActionEvent evt) {
        this.listModel.clear();
        this.listModel.addElement(CMIUtil.propDirName);
        this.listModel.addElement("(default server)");
        this.deleteButton.setEnabled(true);
    }

    private void proxyPasswordFieldActionPerformed(ActionEvent evt) {
        this.proxyFieldChange();
    }

    private void proxyCheckBoxActionPerformed(ActionEvent evt) {
        boolean isProxy = this.proxyCheckBox.isSelected();
        CMIUtil.setProxyEnabled(isProxy);
        this.proxyServerTextField.setEditable(isProxy);
        this.proxyPortTextField.setEditable(isProxy);
        this.proxyUserTextField.setEditable(isProxy);
        this.proxyPasswordField.setEditable(isProxy);
    }

    private void proxyUserTextFieldPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("value")) {
            this.proxyFieldChange();
        }
    }

    private void proxyServerTextFieldPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("value")) {
            this.proxyFieldChange();
        }
    }

    private void proxyPortTextFieldPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("value")) {
            this.proxyFieldChange();
        }
    }

    private void exitCheckBoxActionPerformed(ActionEvent evt) {
        CMIUtil.showExitDialog = this.exitCheckBox.isSelected();
        this.preferences.putBoolean("EXIT_DIALOG", CMIUtil.showExitDialog);
    }

    private void levelComboBoxActionPerformed(ActionEvent evt) {
        Level level = (Level)this.levelComboBox.getSelectedItem();
        CMIUtil.logLevel = level.getName();
    }

    private void commitDirTextFieldPropertyChange(PropertyChangeEvent evt) {
        String val = (String)this.commitDirTextField.getValue();
        if (val == null) {
            return;
        }
        CMIUtil.baseDirName = val;
    }

    private void gridsDirTextFieldPropertyChange(PropertyChangeEvent evt) {
        String val = (String)this.gridsDirTextField.getValue();
        if (val == null) {
            return;
        }
        CMIUtil.gridsDirName = val;
    }

    private void scratchDirTextFieldPropertyChange(PropertyChangeEvent evt) {
        String val = (String)this.scratchDirTextField.getValue();
        if (val == null) {
            return;
        }
        File f = new File(val);
        if (f.exists()) {
            CMIUtil.workingDirName = val;
        } else {
            JOptionPane.showMessageDialog(this, "Directory " + val + " does not exist.", "Error", 0);
            this.scratchDirTextField.setValue(CMIUtil.workingDirName);
        }
    }

    private void mostExecTextFieldPropertyChange(PropertyChangeEvent evt) {
        String val = (String)this.mostExecTextField.getValue();
        if (val == null) {
            return;
        }
        CMIUtil.MOST_EXEC = val;
    }

    private void commitDirButtonActionPerformed(ActionEvent evt) {
        this.setDirectoryName(this.commitDirTextField, CMIUtil.baseDirName);
    }

    private void gridsDirButtonActionPerformed(ActionEvent evt) {
        this.setDirectoryName(this.gridsDirTextField, CMIUtil.gridsDirName);
    }

    private void scratchDirButtonActionPerformed(ActionEvent evt) {
        this.setDirectoryName(this.scratchDirTextField, CMIUtil.workingDirName);
    }

    private void mostExecButtonActionPerformed(ActionEvent evt) {
        this.setExec(this.mostExecTextField, CMIUtil.MOST_EXEC);
    }

    private void mostDownloadButtonActionPerformed(ActionEvent evt) {
        MostExecDownloader med = new MostExecDownloader(this, this);
        final PrefsDialog prefsDlg = this;
        med.setCompletionCallback(new Runnable(){

            @Override
            public void run() {
                PrefsDialog.this.mostExecTextField.setValue(CMIUtil.MOST_EXEC);
                JOptionPane.showMessageDialog(prefsDlg, "The MOST model was successfully updated.", "Update completed", 1);
            }
        });
        med.downloadMOST();
    }

    private void commitServerButtonActionPerformed(ActionEvent evt) {
        ComMITServerSelector dlg = new ComMITServerSelector(this, CMIUtil.commitServerAddress, CMIUtil.workOffline);
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
        String s = dlg.getSelectedServerAddress();
        if (s != null) {
            this.setComMITServerAddress(s, dlg.getWorkOffline());
        }
    }

    private void tsunamicastServerFieldActionPerformed(ActionEvent evt) {
        CMIUtil.tsunamiCastAddress = this.tsunamicastServerField.getText();
    }

    private void numArrowsFormattedTextFieldPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("value")) {
            CMIUtil.maxNumArrows = ((Number)this.numArrowsFormattedTextField.getValue()).intValue();
            this.savePrefs();
        }
    }

    private void graphicsComboBoxActionPerformed(ActionEvent evt) {
        CMIUtil.graphicsres = this.graphicsComboBox.getSelectedIndex();
        ResultGraphicsPanel.setMaxGridDisplaySize(CMIUtil.graphicsres);
        SiftShare.log.info("Setting graphics resolution to: " + CMIUtil.graphicsres + " (max dim: " + ResultGraphicsPanel.MAX_GRID_DISPLAY_SIZE + ")");
        this.savePrefs();
    }

    private void globalPropCheckBoxActionPerformed(ActionEvent evt) {
        CMIUtil.propGlobal = this.globalPropCheckBox.isSelected();
        this.savePrefs();
    }

    public void setComMITServerAddress(String s, boolean workOffline) {
        CMIUtil.commitServerAddress = s;
        CMIUtil.workOffline = workOffline;
        if (this.commitServerTextField != null) {
            this.commitServerTextField.setText(s + (workOffline ? " (working offline)" : ""));
        }
        this.savePrefs();
    }

    private File setDirectory(String dirName) {
        File file = null;
        JFileChooser fileChooser = new JFileChooser(dirName);
        fileChooser.setFileSelectionMode(1);
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            file = fileChooser.getSelectedFile();
        }
        return file;
    }

    private String setDirectoryName(JFormattedTextField tf, String dirName) {
        String result = "error";
        JFileChooser fileChooser = new JFileChooser(dirName);
        fileChooser.setFileSelectionMode(1);
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                result = fileChooser.getSelectedFile().getCanonicalPath();
            }
            catch (IOException e) {
                SiftShare.log.log(Level.WARNING, "Can't get data directory path: ", e);
            }
            if (tf != null) {
                tf.setValue(result);
            }
        }
        return result;
    }

    private String setExec(JFormattedTextField tf, String currentExec) {
        String result = "error";
        File f = new File(currentExec);
        JFileChooser fileChooser = new JFileChooser(f.getParent());
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                result = fileChooser.getSelectedFile().getCanonicalPath();
            }
            catch (IOException e) {
                SiftShare.log.log(Level.WARNING, "Can't find executeable: ", e);
            }
            tf.setValue(result);
        }
        return result;
    }

    public void refresh() {
        this.setTextField(this.tsunamicastServerField, CMIUtil.tsunamiCastAddress);
    }

    private void loadPrefs() {
        File file;
        CMIUtil.firstTimeUser = this.preferences.getBoolean("FIRSTTIME", true);
        if (CMIUtil.firstTimeUser) {
            file = new File(System.getProperty("user.home"), "ComMIT");
            CMIUtil.baseDirName = file.getAbsolutePath();
            CMIUtil.workingDirName = CMIUtil.baseDirName + File.separator + "scratch";
            CMIUtil.gridsDirName = CMIUtil.baseDirName + File.separator + "grids";
            CMIUtil.publishDirName = CMIUtil.baseDirName + File.separator + "publish";
            CMIUtil.etcDirName = CMIUtil.baseDirName + File.separator + "etc";
            CMIUtil.propDirName = CMIUtil.baseDirName + File.separator + "prop";
            CMIUtil.MOST_EXEC = CMIUtil.baseDirName + File.separator + "bin/most3_facts_nc_null";
            CMIUtil.MOST_REV = 0;
            CMIUtil.MOSTProp_EXEC = CMIUtil.baseDirName + File.separator + "bin/most_db_null";
            CMIUtil.MOSTProp_REV = 0;
            CMIUtil.commitServerAddress = "https://sift.pmel.noaa.gov/ComMIT";
            CMIUtil.tsunamiCastAddress = "https://nctr.pmel.noaa.gov/tweb";
            CMIUtil.DATABASE_LOC = CMIUtil.commitServerAddress + "/compressed";
            CMIUtil.propGlobal = true;
            CMIUtil.useProxy = false;
            CMIUtil.proxyServer = "your.proxy.server";
            CMIUtil.proxyPort = 85;
            CMIUtil.proxyUserName = "yourProxyUserName";
            CMIUtil.proxyPass = "abc123";
            CMIUtil.maxNumArrows = 120;
            CMIUtil.graphicsres = 1;
            this.savePrefs();
            this.checkMakeAllDirs();
            this.checkMakeInfoSZ();
            this.unpackSampleGrids();
        } else {
            CMIUtil.baseDirName = this.preferences.get("BASEDIR", System.getProperty("user.dir") + File.separator + "ComMIT");
            file = new File(CMIUtil.baseDirName);
            if (!file.isDirectory()) {
                SiftShare.log.info("can't find ComMIT base directory: " + CMIUtil.baseDirName);
                MovedDirectoryDialog mdd = new MovedDirectoryDialog((Frame)this.siftShare, true, "install", CMIUtil.baseDirName);
                mdd.setAlwaysOnTop(true);
                int result = mdd.showDialog();
                if (result == 0) {
                    file.mkdir();
                } else if (result == 1) {
                    CMIUtil.baseDirName = mdd.getDirName();
                }
                CMIUtil.gridsDirName = CMIUtil.baseDirName + File.separator + "grids";
                CMIUtil.workingDirName = CMIUtil.baseDirName + File.separator + "scratch";
                CMIUtil.publishDirName = CMIUtil.baseDirName + File.separator + "publish";
                CMIUtil.etcDirName = CMIUtil.baseDirName + File.separator + "etc";
                CMIUtil.propDirName = CMIUtil.baseDirName + File.separator + "prop";
                this.savePrefs();
                this.checkMakeAllDirs();
                this.checkMakeInfoSZ();
                this.unpackSampleGrids();
            } else {
                CMIUtil.gridsDirName = this.preferences.get("DATADIR", CMIUtil.baseDirName + File.separator + "grids");
                CMIUtil.workingDirName = this.preferences.get("WORKINGDIR", CMIUtil.baseDirName + File.separator + "scratch");
                CMIUtil.publishDirName = this.preferences.get("PUBLISHDIR", CMIUtil.baseDirName + File.separator + "publish");
                CMIUtil.etcDirName = this.preferences.get("ETCDIR", CMIUtil.baseDirName + File.separator + "etc");
                CMIUtil.propDirName = this.preferences.get("PROPDIR", CMIUtil.baseDirName + File.separator + "prop");
                this.checkMakeAllDirs();
                this.unpackSampleGrids();
            }
        }
        CMIUtil.MOST_EXEC = this.preferences.get("MOST_EXEC", CMIUtil.baseDirName + File.separator + "bin" + File.separator + "most3_facts_nc_null");
        CMIUtil.MOST_REV = this.preferences.getInt("MOST_REV", 0);
        CMIUtil.MOSTProp_EXEC = this.preferences.get("MOSTProp_EXEC", CMIUtil.baseDirName + File.separator + "bin" + File.separator + "most_db_null");
        CMIUtil.MOSTProp_REV = this.preferences.getInt("MOSTProp_REV", 0);
        CMIUtil.commitServerAddress = this.preferences.get("COMMITSERVER", "https://sift.pmel.noaa.gov/ComMIT");
        SiftShare.log.info("\n\nComMITServer: " + CMIUtil.commitServerAddress + "\n\n");
        if (CMIUtil.commitServerAddress.startsWith("http://sift")) {
            SiftShare.log.warning("\n\n\nComMITServer preferences loaded with http protocol.  Switching to https...\n\n\n");
            CMIUtil.commitServerAddress = "https://sift.pmel.noaa.gov/ComMIT";
            this.preferences.put("COMMITSERVER", "https://sift.pmel.noaa.gov/ComMIT");
        }
        CMIUtil.propGlobal = this.preferences.getBoolean("PROPGLOBAL", true);
        if (this.preferences.get("COMMIT_VERSION", null) == null) {
            this.preferences.put("TSUNAMICASTSERVER", "https://nctr.pmel.noaa.gov/tweb");
        }
        CMIUtil.tsunamiCastAddress = this.preferences.get("TSUNAMICASTSERVER", "https://nctr.pmel.noaa.gov/tweb");
        CMIUtil.DATABASE_LOC = this.preferences.get("DATABASE_LOC", CMIUtil.propDirName + "," + "(default server)");
        if (!CMIUtil.DATABASE_LOC.contains(CMIUtil.propDirName)) {
            CMIUtil.DATABASE_LOC = CMIUtil.DATABASE_LOC + "," + CMIUtil.propDirName;
        }
        if (!CMIUtil.DATABASE_LOC.contains("(default server)")) {
            CMIUtil.DATABASE_LOC = CMIUtil.DATABASE_LOC.replaceAll("https://sift.pmel.noaa.gov/(ComMIT/)?compressed/?", "(default server)");
        }
        ArrayList<String> dbloc = new ArrayList<String>(Arrays.asList(CMIUtil.DATABASE_LOC.split(",")));
        Iterator<String> iter = dbloc.iterator();
        while (iter.hasNext()) {
            String loc = iter.next();
            if (loc.startsWith("http") || loc.equals("(default server)") || new File(loc).exists()) continue;
            iter.remove();
        }
        this.listModel.clear();
        StringBuilder sb = new StringBuilder();
        for (String s : dbloc) {
            this.listModel.addElement(s);
            sb.append(s).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        CMIUtil.DATABASE_LOC = sb.toString();
        this.preferences.put("DATABASE_LOC", CMIUtil.DATABASE_LOC);
        CMIUtil.showExitDialog = this.preferences.getBoolean("EXIT_DIALOG", true);
        CMIUtil.logLevel = this.preferences.get("LOG_LEVEL", "INFO");
        CMIUtil.proxyServer = this.preferences.get("PROXY_SERVER", "");
        CMIUtil.proxyPort = this.preferences.getInt("PROXY_PORT", 80);
        CMIUtil.proxyUserName = this.preferences.get("PROXY_USER", "");
        if (CMIUtil.proxyUserName == null) {
            CMIUtil.proxyUserName = "";
            this.preferences.put("PROXY_USER", "");
        }
        CMIUtil.proxyPass = this.preferences.get("PROXY_PASS", "");
        CMIUtil.setProxyEnabled(this.preferences.getBoolean("USE_PROXY", false));
        CMIUtil.maxNumArrows = this.preferences.getInt("MAX_ARROWS", 120);
        CMIUtil.graphicsres = this.preferences.getInt("GRAPHICS_RES", 1);
        ResultGraphicsPanel.setMaxGridDisplaySize(CMIUtil.graphicsres);
        this.setTextField(this.commitDirTextField, CMIUtil.baseDirName);
        this.setTextField(this.gridsDirTextField, CMIUtil.gridsDirName);
        this.setTextField(this.scratchDirTextField, CMIUtil.workingDirName);
        this.setTextField(this.proxyServerTextField, CMIUtil.proxyServer);
        this.setTextField(this.mostExecTextField, CMIUtil.MOST_EXEC);
        this.setTextField(this.commitServerTextField, CMIUtil.commitServerAddress);
        this.setTextField(this.proxyPortTextField, new Integer(CMIUtil.proxyPort));
        this.setTextField(this.proxyUserTextField, CMIUtil.proxyUserName);
        this.setTextField(this.proxyPasswordField, CMIUtil.proxyPass);
        this.setTextField(this.tsunamicastServerField, CMIUtil.tsunamiCastAddress);
        this.setTextField(this.numArrowsFormattedTextField, CMIUtil.maxNumArrows);
        this.graphicsComboBox.setSelectedIndex(CMIUtil.graphicsres);
        this.levelComboBox.setSelectedItem(Level.parse(CMIUtil.logLevel));
        if (this.proxyCheckBox != null) {
            this.proxyCheckBox.setSelected(CMIUtil.isProxyEnabled());
            this.proxyServerTextField.setEditable(CMIUtil.isProxyEnabled());
            this.proxyPortTextField.setEditable(CMIUtil.isProxyEnabled());
            this.proxyUserTextField.setEditable(CMIUtil.isProxyEnabled());
            this.proxyPasswordField.setEditable(CMIUtil.isProxyEnabled());
        }
        if (this.exitCheckBox != null) {
            this.exitCheckBox.setSelected(CMIUtil.showExitDialog);
        }
        if (this.globalPropCheckBox != null) {
            this.globalPropCheckBox.setSelected(CMIUtil.propGlobal);
        }
    }

    protected void savePrefs() {
        SiftShare.log.entering("prefsDialog", "savePrefs");
        this.preferences.put("BASEDIR", CMIUtil.baseDirName);
        this.preferences.put("DATADIR", CMIUtil.gridsDirName);
        this.preferences.put("WORKINGDIR", CMIUtil.workingDirName);
        this.preferences.put("PUBLISHDIR", CMIUtil.publishDirName);
        this.preferences.put("ETCDIR", CMIUtil.etcDirName);
        this.preferences.put("PROPDIR", CMIUtil.propDirName);
        this.preferences.put("MOST_EXEC", CMIUtil.MOST_EXEC);
        this.preferences.putInt("MOST_REV", CMIUtil.MOST_REV);
        this.preferences.put("MOSTProp_EXEC", CMIUtil.MOSTProp_EXEC);
        this.preferences.putInt("MOSTProp_REV", CMIUtil.MOSTProp_REV);
        this.preferences.put("COMMITSERVER", CMIUtil.commitServerAddress);
        this.preferences.put("TSUNAMICASTSERVER", CMIUtil.tsunamiCastAddress);
        this.preferences.put("DATABASE_LOC", CMIUtil.DATABASE_LOC);
        this.preferences.putBoolean("PROPGLOBAL", CMIUtil.propGlobal);
        this.preferences.putBoolean("FIRSTTIME", CMIUtil.firstTimeUser);
        this.preferences.put("LOG_LEVEL", CMIUtil.logLevel);
        this.preferences.putBoolean("EXIT_DIALOG", CMIUtil.showExitDialog);
        this.preferences.putBoolean("USE_PROXY", CMIUtil.useProxy);
        this.preferences.put("PROXY_SERVER", CMIUtil.proxyServer);
        this.preferences.putInt("PROXY_PORT", CMIUtil.proxyPort);
        this.preferences.put("PROXY_USER", CMIUtil.proxyUserName);
        this.preferences.put("PROXY_PASS", CMIUtil.proxyPass);
        this.preferences.putInt("MAX_ARROWS", CMIUtil.maxNumArrows);
        this.preferences.putInt("GRAPHICS_RES", CMIUtil.graphicsres);
        this.preferences.put("COMMIT_VERSION", "1.8.6");
        this.siftShare.setLogLevel(CMIUtil.logLevel);
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException ex) {
            SiftShare.log.log(Level.WARNING, null, ex);
        }
    }

    public void setTextField(JTextField tf, Object o) {
        if (tf != null) {
            if (tf instanceof JFormattedTextField) {
                ((JFormattedTextField)tf).setValue(o);
            } else {
                tf.setText((String)o);
            }
        }
    }

    public void checkMakeAllDirs() {
        this.checkMakeDir(new File(CMIUtil.baseDirName));
        this.checkMakeDir(new File(CMIUtil.baseDirName, "bin"));
        this.checkMakeDir(new File(CMIUtil.baseDirName, "etc"));
        this.checkMakeDir(new File(CMIUtil.workingDirName));
        this.checkMakeDir(new File(CMIUtil.gridsDirName));
        this.checkMakeDir(new File(CMIUtil.etcDirName));
        this.checkMakeDir(new File(CMIUtil.publishDirName));
        this.checkMakeDir(new File(CMIUtil.propDirName));
    }

    public void checkMakeDir(File dir) {
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    public void checkMakeInfoSZ() {
        File f = new File(CMIUtil.propDirName, "info_sz.dat");
        if (!f.exists()) {
            try {
                PrintWriter pw = new PrintWriter(f);
                pw.println("# Propagation database metadata file");
                pw.println("# OpenDAP URL prefix, NONE");
                pw.println("# Name, Filename/URL, Long(deg), Lat(deg), Slip(m), Strike(deg), Dip(deg), Depth(km), Length(km), Width(km), Rake(deg)");
                pw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void unpackSampleGrids() {
        File file = new File(CMIUtil.gridsDirName);
        if (!file.exists()) {
            file.mkdir();
        }
        try {
            CMIUtil.unpackFile(this, "grids/phuketOptGridA.gz", file, "phuketGridA");
            CMIUtil.unpackFile(this, "grids/phuketOptGridB.gz", file, "phuketGridB");
            CMIUtil.unpackFile(this, "grids/phuketOptGridC.gz", file, "phuketGridC");
            CMIUtil.unpackFile(this, "grids/hilo2GridA.gz", file, "hiloGridA");
            CMIUtil.unpackFile(this, "grids/hilo2GridB.gz", file, "hiloGridB");
            CMIUtil.unpackFile(this, "grids/hilo2GridC.gz", file, "hiloGridC");
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.WARNING, "Error unpacking sample bathymetry grids", ex);
        }
        try {
            CMIUtil.importModelRun(this.getClass().getResourceAsStream("images/crescent.zip"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateDatabaseLocation() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.listModel.size(); ++i) {
            String obj = this.listModel.get(i);
            if (obj instanceof String) {
                sb.append(obj.trim());
            } else {
                File file = (File)((Object)obj);
                sb.append(file.getAbsolutePath());
            }
            sb.append(',');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        CMIUtil.DATABASE_LOC = sb.toString();
    }

    private void proxyFieldChange() {
        if (this.isVisible()) {
            Object portobj = this.proxyPortTextField.getValue();
            char[] pw = this.proxyPasswordField.getPassword();
            CMIUtil.setProxy((String)this.proxyServerTextField.getValue(), portobj != null ? ((Number)portobj).intValue() : 0, (String)this.proxyUserTextField.getValue(), String.valueOf((Object)(pw != null ? pw : (char[])"")));
        }
    }

    public File getStartupModelDirectory() {
        String d = this.preferences.get("CURRENT_SITE_DIR", null);
        if (d != null && d.length() > 0) {
            return new File(d);
        }
        return null;
    }

    public List<Path> getOpenModelDirectories() {
        String[] dirs = this.preferences.get("OPEN_SITE_DIRS", "").split(File.pathSeparator);
        ArrayList<Path> files = new ArrayList<Path>(dirs.length);
        for (String d : dirs) {
            if (d.trim().length() <= 0) continue;
            files.add(Paths.get(d.trim(), new String[0]));
        }
        return files;
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() != this.siftShare) {
            return;
        }
        if ("openSites".equals(evt.getPropertyName()) && evt.getNewValue() instanceof Iterable) {
            StringBuilder sb = new StringBuilder();
            for (SiteInfo si : (Iterable)evt.getNewValue()) {
                sb.append(si.getSiteDirectory().getPath()).append(File.pathSeparatorChar);
            }
            this.preferences.put("OPEN_SITE_DIRS", sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "");
        } else if ("currentSite".equals(evt.getPropertyName())) {
            this.preferences.put("CURRENT_SITE_DIR", this.siftShare.getCurrentSite() != null ? this.siftShare.getCurrentSite().getDirName() : "");
        }
    }

    private class UnitSourceListCellRenderer
    extends DefaultListCellRenderer {
        private UnitSourceListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String s = value.toString();
            if (s.equalsIgnoreCase("(default server)")) {
                c.setForeground(SystemColor.textInactiveText);
                if (c instanceof JLabel && CMIUtil.commitServerAddress != null) {
                    JLabel clbl = (JLabel)c;
                    clbl.setText(CMIUtil.commitServerAddress + " " + clbl.getText());
                }
            }
            return c;
        }
    }
}

