/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.LocationFileChooser;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SimpleFileFilter;
import gov.noaa.tsunami.websift.ee.TopoCanvas;
import gov.noaa.tsunami.websift.propdb.Range2D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class PropBathyDownloadDialog
extends JDialog
implements PropertyChangeListener {
    private static final boolean DEBUG = true;
    private static Logger log = Logger.getLogger("gov.noaa.tsunami");
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private int returnStatus = 0;
    public static final int MAX_NUM_POINTS = 25000000;
    private final TopoCanvas map;
    private Range2D range = new Range2D(0.0, 0.0, 0.0, 0.0);
    private int nx;
    private int ny;
    private int numPts = 0;
    public int len;
    public int nread;
    private BathyGrid bathyGrid = null;
    private final String defaultGridFileAppend = "customPropGridFile";
    private File gridFile = new File("");
    private boolean download = true;
    private int fileVer = 0;
    private Double resolutionDeg = new Double(0.03333333);
    private Double resolutionMin = new Double(2.0);
    private Double resolutionSec = new Double(120.0);
    private double defaultResMin = 2.0;
    private static final DecimalFormat dfx = new DecimalFormat("0.0");
    private static final DecimalFormat dfxxx = new DecimalFormat("0.000");
    private static final DecimalFormat dfxxxx = new DecimalFormat("0.0000");
    private static List<Rectangle2D.Double> sourceGridExtents = null;
    private boolean rubberBanding;
    private static TreeMap<Integer, ArrayList<Area>> lma = null;
    private Thread dlThread = null;
    private JButton browseButton;
    private JButton cancelButton;
    private JFormattedTextField eastFormattedTextField;
    private Box.Filler filler1;
    private Box.Filler filler2;
    protected JTextField gridFileNameTextField;
    private JLabel infoLabel;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JLabel mapCoordLabel;
    private JPanel mapPanel;
    private JFormattedTextField northFormattedTextField;
    private JLabel numPtsLabel;
    private JLabel nxLabel;
    private JLabel nyLabel;
    private JButton okButton;
    private JProgressBar progressBar;
    private JFormattedTextField resolutionDegTextField;
    protected JFormattedTextField resolutionMinTextField;
    protected JFormattedTextField resolutionSecTextField;
    private JFormattedTextField southFormattedTextField;
    private JFormattedTextField westFormattedTextField;

    public PropBathyDownloadDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.map = new TopoCanvas();
        this.map.setMaxZoomLevel(48);
        this.map.setZoomScaleDelta(1.1);
        this.mapPanel.add((Component)this.map, "Center");
        this.map.setSize(this.mapPanel.getSize());
        try {
            File tf = new File(CMIUtil.etcDirName, "gshhs_c.nc");
            this.map.addLandMass(tf, 1);
            tf = new File(CMIUtil.etcDirName, "wdb_borders_i.b");
            this.map.addBorders(tf);
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.SEVERE, null, ex);
        }
        this.map.plotLandMass(true);
        this.map.plotBorders(true);
        this.map.plotGraticules(true);
        this.map.plotCountryNames(true);
        this.map.panTo(205.0, 0.0);
        this.map.zoomOut();
        this.mapPanel.requestFocus();
        this.map.addPropertyChangeListener(this);
        this.northFormattedTextField.addPropertyChangeListener(this);
        this.southFormattedTextField.addPropertyChangeListener(this);
        this.eastFormattedTextField.addPropertyChangeListener(this);
        this.westFormattedTextField.addPropertyChangeListener(this);
        this.resolutionDegTextField.addPropertyChangeListener(this);
        this.resolutionMinTextField.addPropertyChangeListener(this);
        this.resolutionSecTextField.addPropertyChangeListener(this);
        this.gridFileNameTextField.addPropertyChangeListener(this);
    }

    public void setLogger(Logger l) {
        log = l;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.westFormattedTextField = new JFormattedTextField();
        this.eastFormattedTextField = new JFormattedTextField();
        this.northFormattedTextField = new JFormattedTextField();
        this.southFormattedTextField = new JFormattedTextField();
        this.resolutionDegTextField = new JFormattedTextField();
        this.jLabel1 = new JLabel();
        this.gridFileNameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.resolutionMinTextField = new JFormattedTextField();
        this.resolutionSecTextField = new JFormattedTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.browseButton = new JButton();
        this.jLabel11 = new JLabel();
        this.nxLabel = new JLabel();
        this.jLabel13 = new JLabel();
        this.nyLabel = new JLabel();
        this.jLabel12 = new JLabel();
        this.numPtsLabel = new JLabel();
        this.mapPanel = new JPanel();
        this.infoLabel = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.mapCoordLabel = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 100), new Dimension(0, 100), new Dimension(Short.MAX_VALUE, 100));
        this.filler2 = new Box.Filler(new Dimension(10, 150), new Dimension(10, 150), new Dimension(10, 150));
        this.progressBar = new JProgressBar();
        this.setDefaultCloseOperation(2);
        this.westFormattedTextField.setColumns(8);
        this.westFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.0000"))));
        this.westFormattedTextField.setHorizontalAlignment(0);
        this.westFormattedTextField.setToolTipText("West extent (degrees longitude)");
        this.eastFormattedTextField.setColumns(8);
        this.eastFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.0000"))));
        this.eastFormattedTextField.setHorizontalAlignment(0);
        this.eastFormattedTextField.setToolTipText("East extent (degrees longitude)");
        this.northFormattedTextField.setColumns(8);
        this.northFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.0000"))));
        this.northFormattedTextField.setHorizontalAlignment(0);
        this.northFormattedTextField.setToolTipText("North extent (degrees latitude)");
        this.southFormattedTextField.setColumns(8);
        this.southFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.0000"))));
        this.southFormattedTextField.setHorizontalAlignment(0);
        this.southFormattedTextField.setToolTipText("South extent (degrees latitude)");
        this.resolutionDegTextField.setColumns(6);
        this.resolutionDegTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0.0000"))));
        this.resolutionDegTextField.setHorizontalAlignment(0);
        this.resolutionDegTextField.setFocusLostBehavior(0);
        this.jLabel1.setText("Cell Size:");
        this.jLabel2.setText("File Name:");
        this.jLabel3.setText("(deg)");
        this.jLabel4.setText("(arcmin)");
        this.jLabel5.setText("(arcsec)");
        this.resolutionMinTextField.setColumns(6);
        this.resolutionMinTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0.000"))));
        this.resolutionMinTextField.setHorizontalAlignment(0);
        this.resolutionMinTextField.setFocusLostBehavior(0);
        this.resolutionSecTextField.setColumns(6);
        this.resolutionSecTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0.0"))));
        this.resolutionSecTextField.setHorizontalAlignment(0);
        this.resolutionSecTextField.setFocusLostBehavior(0);
        this.jLabel6.setText("Grid Extents:");
        this.jLabel7.setText("N");
        this.jLabel8.setText("S");
        this.jLabel9.setText("E");
        this.jLabel10.setText("W");
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropBathyDownloadDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.jLabel11.setText("Number points, nx:");
        this.nxLabel.setForeground(Color.gray);
        this.nxLabel.setHorizontalAlignment(0);
        this.nxLabel.setText("0");
        this.jLabel13.setText("ny:");
        this.nyLabel.setForeground(Color.gray);
        this.nyLabel.setHorizontalAlignment(0);
        this.nyLabel.setText("0");
        this.jLabel12.setText("total:");
        this.numPtsLabel.setForeground(Color.gray);
        this.numPtsLabel.setHorizontalAlignment(0);
        this.numPtsLabel.setText("0");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gridFileNameTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addGap(12, 12, 12)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.westFormattedTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.southFormattedTextField, -2, -1, -2).addComponent(this.northFormattedTextField, -2, -1, -2).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.eastFormattedTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel8)).addGap(102, 102, 102)))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel11).addGap(18, 18, 18).addComponent(this.nxLabel, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel13).addGap(18, 18, 18).addComponent(this.nyLabel, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numPtsLabel, -1, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.resolutionDegTextField, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.resolutionMinTextField, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addGap(18, 18, 18).addComponent(this.resolutionSecTextField, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5)).addComponent(this.jLabel1)).addGap(62, 62, 62))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(37, 37, 37).addComponent(this.jLabel6)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.northFormattedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.westFormattedTextField, -2, -1, -2).addComponent(this.eastFormattedTextField, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.jLabel10)).addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.southFormattedTextField, -2, -1, -2)))).addGap(18, 18, 18).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resolutionDegTextField, -2, -1, -2).addComponent(this.resolutionMinTextField, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.resolutionSecTextField, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.jLabel3)).addGap(12, 12, 12).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.nxLabel).addComponent(this.jLabel13).addComponent(this.nyLabel).addComponent(this.jLabel12).addComponent(this.numPtsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.gridFileNameTextField, -2, -1, -2).addComponent(this.browseButton)).addGap(15, 15, 15)));
        this.mapPanel.setBackground(new Color(255, 204, 204));
        this.mapPanel.setMinimumSize(new Dimension(450, 225));
        this.mapPanel.setPreferredSize(new Dimension(700, 350));
        this.mapPanel.setLayout(new BorderLayout());
        this.infoLabel.setFont(this.infoLabel.getFont().deriveFont(this.infoLabel.getFont().getStyle() & 0xFFFFFFFE, this.infoLabel.getFont().getSize() - 1));
        this.infoLabel.setText("<html>Hold <code>Shift</code> and drag to select a grid extent (or Browse to a MOST bathymetry file).</html>");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropBathyDownloadDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropBathyDownloadDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.mapCoordLabel.setText("Lat/Lon");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.infoLabel, -2, -1, -2).addGroup(layout.createSequentialGroup().addGap(76, 76, 76).addComponent(this.filler1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.filler2, -2, -1, -2).addComponent(this.progressBar, -2, 345, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.mapCoordLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 485, Short.MAX_VALUE).addComponent(this.okButton).addGap(18, 18, 18).addComponent(this.cancelButton).addContainerGap()).addComponent(this.mapPanel, -2, 0, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filler1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.progressBar, -2, 34, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filler2, -1, -1, Short.MAX_VALUE)))).addComponent(this.mapPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.infoLabel, -2, -1, -2).addComponent(this.okButton).addComponent(this.cancelButton).addComponent(this.mapCoordLabel)).addContainerGap()));
        this.pack();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        LocationFileChooser fileChooser = new LocationFileChooser(CMIUtil.gridsDirName);
        SimpleFileFilter fileFilter = new SimpleFileFilter(new String[]{""}, "MOST grid file");
        fileChooser.setFileFilter(fileFilter);
        fileChooser.setLocation(100, 500);
        int result = fileChooser.showOpenDialog(this);
        if (result == 0) {
            this.gridFile = fileChooser.getSelectedFile();
            try {
                this.bathyGrid = new BathyGrid(this.gridFile, false);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Can't open " + this.gridFile.getPath() + ":\n" + e.getMessage(), "Error opening grid file", 0);
            }
            this.gridFileNameTextField.setText(this.gridFile.getName());
            double minLon = this.bathyGrid.getMinLon();
            double maxLon = this.bathyGrid.getMaxLon();
            double minLat = this.bathyGrid.getMinLat();
            double maxLat = this.bathyGrid.getMaxLat();
            this.range.x = minLon;
            this.range.w = maxLon - minLon;
            this.range.y = minLat;
            this.range.h = maxLat - minLat;
            this.northFormattedTextField.setValue(this.bathyGrid.getMaxLat());
            this.southFormattedTextField.setValue(this.bathyGrid.getMinLat());
            this.eastFormattedTextField.setValue(this.bathyGrid.getMaxLon());
            this.westFormattedTextField.setValue(this.bathyGrid.getMinLon());
            this.resolutionDegTextField.setValue(this.bathyGrid.getMeanResolution());
            this.map.setRubberbanding(false);
            Rectangle2D.Double r = new Rectangle2D.Double(this.range.x, this.range.y, this.range.w, this.range.h);
            this.map.setHome(r);
            this.map.goHome();
            this.map.setGrid0(r);
            this.enableExtentsAndResolution(false);
            this.download = false;
            this.updateNumberPoints();
            this.infoLabel.setText("Existing MOST grid file loaded. Select OK to continue.");
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.returnStatus = 1;
        if (!this.gridFile.exists()) {
            if (this.updateNumberPoints()) {
                this.downloadGrid();
            } else {
                log.warning("Propagation Grid request: too many points");
                this.infoLabel.setText("TOO MANY POINTS: DECREASE EXTENTS OR INCREASE RESOLUTION!!");
                this.infoLabel.setForeground(Color.red);
            }
        } else {
            this.setVisible(false);
        }
        log.info("Propagation grid file: " + this.gridFile.getPath());
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.returnStatus = 0;
        this.setVisible(false);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public void downloadGrid() {
        StringBuilder sb = new StringBuilder(CMIUtil.commitServerAddress + "/bathymetry/create.netcdf?");
        sb.append(String.format("xmin=%2.5f", this.getDoubleValue(this.westFormattedTextField)));
        sb.append(String.format("&xmax=%2.5f", this.getDoubleValue(this.eastFormattedTextField)));
        sb.append(String.format("&ymin=%2.5f", this.getDoubleValue(this.southFormattedTextField)));
        sb.append(String.format("&ymax=%2.5f", this.getDoubleValue(this.northFormattedTextField)));
        sb.append(String.format("&cellsize=%2.3fm", this.resolutionMin));
        this.progressBar.setString("Downloading grid...");
        this.progressBar.setStringPainted(true);
        this.dlThread = new Thread(new GridDownloader(this.progressBar, this.gridFile.getPath(), sb.toString()));
        this.dlThread.start();
    }

    public File getFile() {
        return this.gridFile;
    }

    private void enableExtentsAndResolution(boolean b) {
        this.resolutionDegTextField.setEnabled(b);
        this.resolutionMinTextField.setEnabled(b);
        this.resolutionSecTextField.setEnabled(b);
        this.northFormattedTextField.setEnabled(b);
        this.southFormattedTextField.setEnabled(b);
        this.eastFormattedTextField.setEnabled(b);
        this.westFormattedTextField.setEnabled(b);
        this.gridFileNameTextField.setEnabled(b);
    }

    private void updateResolutionTextFields() {
        this.resolutionDegTextField.setText(dfxxxx.format(this.resolutionDeg));
        this.resolutionMinTextField.setText(dfxxx.format(this.resolutionMin));
        this.resolutionSecTextField.setText(dfx.format(this.resolutionSec));
        SiftShare.log.log(Level.FINE, "resolution (sec): " + this.resolutionSecTextField.toString());
        if (this.updateNumberPoints()) {
            this.infoLabel.setForeground(Color.black);
            this.infoLabel.setText("Hold Shift and drag to select a grid extent (or Browse to a MOST bathymetry file).");
        }
    }

    private boolean updateNumberPoints() {
        boolean lessThanMax = false;
        if (!this.download) {
            this.nx = this.bathyGrid.getXSize();
            this.nxLabel.setText(Integer.toString(this.nx));
            this.ny = this.bathyGrid.getYSize();
            this.nyLabel.setText(Integer.toString(this.ny));
            this.numPts = this.nx * this.ny;
            this.numPtsLabel.setText(Integer.toString(this.numPts));
            this.numPtsLabel.setForeground(Color.gray);
            lessThanMax = false;
        } else if (this.range != null) {
            this.nx = (int)(this.range.w / this.resolutionDeg);
            this.nxLabel.setText(Integer.toString(this.nx));
            this.ny = (int)(this.range.h / this.resolutionDeg);
            this.nyLabel.setText(Integer.toString(this.ny));
            this.numPts = this.nx * this.ny;
            this.numPtsLabel.setText(Integer.toString(this.numPts));
            this.numPtsLabel.setForeground(this.numPts > 25000000 ? Color.red : Color.gray);
            lessThanMax = this.numPts < 25000000;
        }
        return lessThanMax;
    }

    public void setDefaultGridFilename() {
        this.fileVer = 1;
        this.gridFile = new File(CMIUtil.gridsDirName, String.format("%s%02d.nc", "customPropGridFile", this.fileVer));
        while (this.gridFile.exists()) {
            ++this.fileVer;
            this.gridFile = new File(CMIUtil.gridsDirName, String.format("%s%02d.nc", "customPropGridFile", this.fileVer));
            SiftShare.log.fine("default grid file exists: " + this.gridFile.getPath());
        }
        this.gridFileNameTextField.setText(this.gridFile.getName());
    }

    public void setResolutionMin(double d) {
        this.defaultResMin = d;
        this.resolutionMin = d;
        this.resolutionDeg = d / 60.0;
        this.resolutionSec = d * 60.0;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String pname = evt.getPropertyName();
        if (pname.equals("pointerLocation")) {
            Point2D.Double pt = (Point2D.Double)evt.getNewValue();
            if (pt != null) {
                if (!this.map.isRubberbanding()) {
                    this.mapCoordLabel.setText(String.format("%.3f, %.3f", pt.y, pt.x));
                }
            } else {
                this.mapCoordLabel.setText(null);
            }
        } else if (pname.equals("rubberbandRegion")) {
            this.range = this.map.getRubberbandRegion();
            if (this.range != null) {
                this.enableExtentsAndResolution(true);
                this.rubberBanding = true;
                this.northFormattedTextField.setValue(this.range.y + this.range.h);
                this.southFormattedTextField.setValue(this.range.y);
                this.westFormattedTextField.setValue(this.range.x);
                this.eastFormattedTextField.setValue(this.range.x + this.range.w);
                if (!this.download) {
                    this.setResolutionMin(this.defaultResMin);
                }
                this.download = true;
                this.setDefaultGridFilename();
                this.updateResolutionTextFields();
                Rectangle2D.Double r = new Rectangle2D.Double(this.range.x, this.range.y, this.range.w, this.range.h);
                this.map.setGrid0(r);
                this.mapCoordLabel.setText(String.format("(%.3f, %.3f) - (%.3f, %.3f)", this.range.x, this.range.y, this.range.x + this.range.w, this.range.y + this.range.h));
                this.rubberBanding = false;
            }
        } else if (pname.equals("goHome")) {
            this.map.zoomTo(this.map.getHome());
        } else if (pname.equals("value")) {
            Object obj = evt.getSource();
            if (obj.equals(this.resolutionDegTextField)) {
                this.resolutionDeg = this.getDoubleValue(this.resolutionDegTextField);
                this.resolutionMin = this.resolutionDeg * 60.0;
                this.resolutionSec = this.resolutionDeg * 3600.0;
                this.updateResolutionTextFields();
            } else if (obj.equals(this.resolutionMinTextField)) {
                this.resolutionMin = this.getDoubleValue(this.resolutionMinTextField);
                this.resolutionDeg = this.resolutionMin / 60.0;
                this.resolutionSec = this.resolutionMin * 60.0;
                this.updateResolutionTextFields();
            } else if (obj.equals(this.resolutionSecTextField)) {
                this.resolutionSec = this.getDoubleValue(this.resolutionSecTextField);
                this.resolutionMin = this.resolutionSec / 60.0;
                this.resolutionDeg = this.resolutionSec / 3600.0;
                this.updateResolutionTextFields();
            } else if (obj.equals(this.northFormattedTextField)) {
                if (!this.rubberBanding) {
                    this.range.h = this.getDoubleValue(this.northFormattedTextField) - this.range.y;
                    this.map.setRubberbandRegion(this.range.x, this.range.x + this.range.w, this.range.y, this.range.y + this.range.h);
                    this.updateNumberPoints();
                }
            } else if (obj.equals(this.southFormattedTextField)) {
                if (!this.rubberBanding) {
                    this.range.y = this.getDoubleValue(this.southFormattedTextField);
                    this.range.h = this.getDoubleValue(this.northFormattedTextField) - this.range.y;
                    this.map.setRubberbandRegion(this.range.x, this.range.x + this.range.w, this.range.y, this.range.y + this.range.h);
                    this.updateNumberPoints();
                }
            } else if (obj.equals(this.eastFormattedTextField)) {
                if (!this.rubberBanding) {
                    this.range.w = this.getDoubleValue(this.eastFormattedTextField) - this.range.x;
                    this.map.setRubberbandRegion(this.range.x, this.range.x + this.range.w, this.range.y, this.range.y + this.range.h);
                    this.updateNumberPoints();
                }
            } else if (obj.equals(this.westFormattedTextField) && !this.rubberBanding) {
                this.range.x = this.getDoubleValue(this.westFormattedTextField);
                this.range.w = this.getDoubleValue(this.eastFormattedTextField) - this.range.x;
                this.map.setRubberbandRegion(this.range.x, this.range.x + this.range.w, this.range.y, this.range.y + this.range.h);
                this.updateNumberPoints();
            }
        }
    }

    public double getDoubleValue(JFormattedTextField tf) {
        double val = Double.MIN_VALUE;
        try {
            Object obj = tf.getValue();
            if (obj == null) {
                return 99999.9;
            }
            val = ((Number)obj).doubleValue();
        }
        catch (NumberFormatException nfe) {
            SiftShare.log.log(Level.FINE, "error parsing number", nfe);
        }
        return val;
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(PropBathyDownloadDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(PropBathyDownloadDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(PropBathyDownloadDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(PropBathyDownloadDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        CMIUtil.etcDirName = "/Users/cmoore/ComMIT/etc";
        CMIUtil.gridsDirName = "/Users/cmoore/ComMIT/grids";
        CMIUtil.commitServerAddress = "http://localhost:8090/ComMIT";
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PropBathyDownloadDialog dialog = new PropBathyDownloadDialog(null, true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private class GridDownloader
    implements Runnable {
        JProgressBar pb = null;
        String pathString = "";
        String urls = "";

        public GridDownloader(JProgressBar progressBar, String pathString, String urlString) {
            this.pb = progressBar;
            this.pathString = pathString;
            this.urls = urlString;
        }

        @Override
        public void run() {
            log.info(String.format("downloading Prop grid, URL: %s\n to file: %s", this.urls, this.pathString));
            try {
                this.downloadFile(this.urls, this.pathString);
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, "Can't download prop grid!", ioe);
            }
        }

        public void downloadFile(String fileURL, String destinationPath) throws IOException {
            URL url = new URL(fileURL);
            boolean percent = false;
            int responseCode = 202;
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setConnectTimeout(0);
            con.setReadTimeout(0);
            responseCode = con.getResponseCode();
            if (responseCode == 200) {
                PropBathyDownloadDialog.this.len = con.getContentLength();
                if (PropBathyDownloadDialog.this.len == -1) {
                    PropBathyDownloadDialog.this.len = 10000;
                }
                log.info("downloading grid, size: " + PropBathyDownloadDialog.this.len / 1024 + "k");
                InputStream is = con.getInputStream();
                File downloadGridFile = new File(destinationPath);
                FileOutputStream out = new FileOutputStream(downloadGridFile);
                PropBathyDownloadDialog.this.nread = 0;
                int c = 0;
                byte[] buf = new byte[1024];
                while ((c = is.read(buf)) != -1) {
                    if (c > 0) {
                        PropBathyDownloadDialog.this.nread += c;
                        if (PropBathyDownloadDialog.this.nread <= PropBathyDownloadDialog.this.len) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    GridDownloader.this.pb.setMaximum(PropBathyDownloadDialog.this.len);
                                    GridDownloader.this.pb.setValue(PropBathyDownloadDialog.this.nread);
                                }
                            });
                        }
                    }
                    if (Thread.interrupted()) {
                        log.info("Prop downloaded interrupted downloading grid.");
                        is.close();
                        out.close();
                        downloadGridFile.delete();
                        return;
                    }
                    out.write(buf, 0, c);
                }
                is.close();
                out.close();
                this.pb.setString("Done downloading.");
                PropBathyDownloadDialog.this.setVisible(false);
            } else {
                log.log(Level.WARNING, "Error downloading grid: " + responseCode);
            }
        }
    }
}

