/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.ModelInfo;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.websift.propdb.UnitSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;

public class PropInfo
extends ModelInfo
implements Comparable<PropInfo> {
    public static final String globalFileName = "glb4m_e1ice_SSL21_c4_20140417_corr.nc";
    public static final String pacificFileName = "pacific_4m_nocaribbean2.corr";
    public static final String atlanticFileName = "atlantic_4m_20100601_ssl21_0360.corr";
    public static final String indianFileName = "indian_4m28.corr";
    public static final String caribFileName = "Caribbean_etopo1m_ssl20_corr30.most";
    public static final String medFileName = "Mediterranean_etopo2m_ssl19_corr30.most";
    private String mostDotIn = "";
    private boolean mostDotInValid = false;
    private long lastModified = -1L;
    private UnitSource unitSource = null;
    private String haFileName;
    private String uaFileName;
    private String vaFileName;
    private File bathyFile = null;
    private String gridName = "Pacific";
    private String gridAxesVer = "20060823";
    private String bathyFileName = CMIUtil.gridsDirName + File.separator + "pacific_4m_nocaribbean2.corr";
    private BathyGrid defGrid = null;
    private double minimumDepth = 20.0;
    private double timeStep = 10.0;
    private int totalNumberTimeStep = 8640;
    private int numberTimeStepsBetweenOutput = 6;
    private int numberTimeStepsStart = 0;
    private int numberStride = 1;
    private int globalGrid = 0;
    private String filePrefix = "auto";
    private String zoneName = "Aleutiam_Cascadia";
    private String zoneCode = "cu";
    private String col = "a";
    private int row = 1;
    private int sourceVersion = 1;
    private int numberFaultPlanes = 1;
    private int xInteg = 41;
    private int yInteg = 21;
    private double Vp = 8.11;
    private double Vs = 4.49;
    private int deformX = 10;
    private int deformY = 10;
    private double epLon = 179.842;
    private double epLat = 50.85;
    private double len = 100.0;
    private double wid = 50.0;
    private double dip = 15.0;
    private double rake = 90.0;
    private double strike = 271.0;
    private double slip = 1.0;
    private double depth = 5.0;
    private SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance(2);

    public PropInfo(String filename) {
        this.mostDotIn = filename;
        SiftShare.log.info("mdi: " + this.mostDotIn);
        this.haFileName = this.stripFileExtension(this.mostDotIn) + "ha.nc";
        this.uaFileName = this.stripFileExtension(this.mostDotIn) + "ua.nc";
        this.vaFileName = this.stripFileExtension(this.mostDotIn) + "va.nc";
        this.mostDotInValid = this.parseDotInFile();
    }

    private String gobbleComments(BufferedReader br) throws IOException {
        String line;
        while ((line = br.readLine()) != null && line.startsWith("#")) {
        }
        return line.trim().split("\\s+")[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseDotInFile() {
        BufferedReader br = null;
        File mostDotFile = new File(this.mostDotIn);
        if (mostDotFile.isFile()) {
            this.lastModified = mostDotFile.lastModified();
            try {
                br = new BufferedReader(new FileReader(this.mostDotIn));
                this.gridName = this.gobbleComments(br);
                this.gridAxesVer = this.gobbleComments(br);
                this.bathyFileName = this.gobbleComments(br);
                this.minimumDepth = Double.parseDouble(this.gobbleComments(br));
                this.timeStep = Double.parseDouble(this.gobbleComments(br));
                this.totalNumberTimeStep = Integer.parseInt(this.gobbleComments(br));
                this.numberTimeStepsBetweenOutput = Integer.parseInt(this.gobbleComments(br));
                this.numberTimeStepsStart = Integer.parseInt(this.gobbleComments(br));
                this.numberStride = Integer.parseInt(this.gobbleComments(br));
                this.globalGrid = Integer.parseInt(this.gobbleComments(br));
                this.filePrefix = this.gobbleComments(br);
                this.zoneName = this.gobbleComments(br);
                this.zoneCode = this.gobbleComments(br);
                this.col = this.gobbleComments(br);
                this.col = this.col.substring(0, 1);
                this.row = Integer.parseInt(this.gobbleComments(br));
                this.sourceVersion = Integer.parseInt(this.gobbleComments(br));
                this.numberFaultPlanes = Math.abs(Integer.parseInt(this.gobbleComments(br)));
                if (this.numberFaultPlanes == 0) {
                    this.defGrid = new BathyGrid(new File(br.readLine()));
                    double[] ll = this.defGrid.getLonLatAtMaxDepth();
                    this.epLon = ll[0];
                    this.epLat = ll[1];
                } else {
                    this.xInteg = Integer.parseInt(this.gobbleComments(br));
                    this.yInteg = Integer.parseInt(this.gobbleComments(br));
                    this.Vp = Double.parseDouble(this.gobbleComments(br));
                    this.Vs = Double.parseDouble(this.gobbleComments(br));
                    this.epLon = Double.parseDouble(this.gobbleComments(br));
                    this.epLat = Double.parseDouble(this.gobbleComments(br));
                    this.len = Double.parseDouble(this.gobbleComments(br));
                    this.wid = Double.parseDouble(this.gobbleComments(br));
                    this.dip = Double.parseDouble(this.gobbleComments(br));
                    this.rake = Double.parseDouble(this.gobbleComments(br));
                    this.strike = Double.parseDouble(this.gobbleComments(br));
                    this.slip = Double.parseDouble(this.gobbleComments(br));
                    this.depth = Double.parseDouble(this.gobbleComments(br));
                }
                boolean ll = true;
                return ll;
            }
            catch (NumberFormatException e) {
                SiftShare.log.log(Level.WARNING, "Error parsing most_db.in file: " + this.mostDotIn, e);
            }
            catch (NullPointerException e) {
                SiftShare.log.log(Level.WARNING, "Premature end of file reached in MOST parameter file (NPE): " + this.mostDotIn, e);
            }
            catch (IOException ioe) {
                SiftShare.log.log(Level.WARNING, "Error parsing most_db.in: " + this.mostDotIn, ioe);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return false;
    }

    public void writeDotIn() {
        try (PrintWriter pw = null;){
            File mostDotFile = new File(this.mostDotIn);
            pw = new PrintWriter(mostDotFile);
            pw.println("# Propagation MOST input file");
            pw.println("# created by ComMIT on " + this.sdf.format(new Date()));
            pw.println(this.gridName);
            pw.println(this.gridAxesVer);
            pw.println("# Bathymetry filename:");
            pw.println(this.bathyFileName);
            pw.println(this.minimumDepth + "\t# Input minimum depth for offshore (m)");
            pw.println(this.timeStep + "\t# Input time step (sec)");
            pw.println(this.totalNumberTimeStep + "\t# Input number of steps");
            pw.println(this.numberTimeStepsBetweenOutput + "\t# Input number of steps between output steps");
            pw.println(this.numberTimeStepsStart + "\t# ...Starting from");
            pw.println(this.numberStride + "\t# Save output every n-th grid point");
            pw.println(this.globalGrid + "\t# Input global BCs (1=global, 0=non-reentrant)");
            pw.println("#       Output File Prefix (<prefix>_ha.nc or auto)");
            pw.println(this.filePrefix);
            pw.println("#       Source Zone Name (no spaces)");
            pw.println(this.zoneName);
            pw.println("#       Source Zone Code (two characters)");
            pw.println(this.zoneCode);
            pw.println("#       Source Column (one character)");
            pw.println(this.col);
            pw.println(this.row + "\t# Source Row (integer/three character)");
            pw.println(this.sourceVersion + "\t# Source Version (integer/two characters)");
            pw.println(this.numberFaultPlanes + "\t# Number of fault planes ('-#'' looks for deformation files to use)");
            if (this.numberFaultPlanes == 1) {
                pw.println(this.xInteg + "\t# x-integration");
                pw.println(this.yInteg + "\t# y-integration");
                pw.println(this.Vp + "\t# Vp - P-wave velocity");
                pw.println(this.Vs + "\t# Vs - S-wave velocity");
                pw.println(this.epLon + "\t# Longitude (deg)");
                pw.println(this.epLat + "\t# Latitude (deg)");
                pw.println(this.len + "\t# Length (km)");
                pw.println(this.wid + "\t# Width (km)");
                pw.println(this.dip + "\t# Dip (deg)");
                pw.println(this.rake + "\t# Rake (deg)");
                pw.println(this.strike + "\t# Strike (deg)");
                pw.println(this.slip + "\t# Slip (m)");
                pw.println(this.depth + "\t# Depth (km)");
            } else {
                pw.println(this.defGrid.getGridFile().getPath());
            }
            pw.close();
        }
    }

    public boolean hasValidMostDotIn() {
        return this.mostDotInValid;
    }

    public String getMostDotIn() {
        return this.mostDotIn;
    }

    public double getMw() {
        if (this.numberFaultPlanes == 0) {
            return 0.0;
        }
        UnitSource us = this.getUnitSource();
        return us == null ? 0.0 : us.getMagnitude();
    }

    public boolean setDeformGrid(BathyGrid def) {
        if (def == null) {
            this.defGrid = null;
            this.numberFaultPlanes = 1;
            return false;
        }
        if (this.checkBathyAxes(def)) {
            this.defGrid = def;
            this.numberFaultPlanes = 0;
            this.len = 40.0;
            this.wid = 40.0;
            return true;
        }
        return false;
    }

    public String getDeformGridFilename() {
        return this.defGrid != null ? this.defGrid.getFileName() : "none (using Seismic Info)";
    }

    public boolean isCustomDeformation() {
        return this.defGrid != null;
    }

    public boolean checkBathyAxes(BathyGrid def) {
        try {
            BathyGrid bg = new BathyGrid(new File(this.bathyFileName), true);
            double[] blons = bg.getXArray();
            double[] blats = bg.getYArray();
            double[] dlons = def.getXArray();
            double[] dlats = def.getYArray();
            if (Math.abs(blons[0] - dlons[0]) < 0.001 && Math.abs(blons[blons.length - 1] - dlons[dlons.length - 1]) < 0.001 && Math.abs(blats[0] - dlats[0]) < 0.001 && Math.abs(blats[blats.length - 1] - dlats[dlats.length - 1]) < 0.001) {
                return true;
            }
        }
        catch (IOException ex) {
            SiftShare.log.info("deformation grid not on bathy grid axes");
            return false;
        }
        return false;
    }

    public boolean hasValidNetCDF() {
        Object us = null;
        return new File(this.haFileName).exists() && new File(this.uaFileName).exists() && new File(this.vaFileName).exists();
    }

    public String getHaFileName() {
        return this.haFileName;
    }

    public String stripFileExtension(String s) {
        String result = s;
        int i = result.lastIndexOf(46);
        if (i > 0) {
            return result.substring(0, i);
        }
        return "";
    }

    public void clearResults() {
        new File(this.haFileName).delete();
        new File(this.uaFileName).delete();
        new File(this.vaFileName).delete();
        File reFile = new File(this.stripFileExtension(this.mostDotIn) + "restart.nc");
        reFile.delete();
        if (reFile.exists()) {
            SiftShare.log.severe("\n\nCan't delete restart propagation file: " + reFile.getName() + "!!\n\n");
        }
        new File(this.stripFileExtension(this.mostDotIn) + ".out").delete();
        new File(this.stripFileExtension(this.mostDotIn) + "deform001.dat").delete();
    }

    public void clearDotIn() {
        new File(this.mostDotIn).delete();
    }

    public String getMostDotOut() {
        return this.stripFileExtension(this.mostDotIn) + ".out";
    }

    public UnitSource getUnitSource() {
        this.unitSource = new UnitSource(this.getName(), this.haFileName, this.epLon, this.epLat, this.slip, this.strike, this.dip, this.depth, this.len, this.wid, this.rake);
        return this.unitSource;
    }

    @Override
    public String getName() {
        return String.format("%s%d%s", this.zoneCode, this.row, this.col);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setBathyFileName(String bathyFileName) {
        this.bathyFileName = bathyFileName;
    }

    public String getBathyFileName() {
        return new File(this.bathyFileName).getName();
    }

    public String getBathyFilePath() {
        return this.bathyFileName;
    }

    public void setGridName(String gridName) {
        this.gridName = gridName;
    }

    public String getGridName() {
        return this.gridName;
    }

    public void setGridAxesVer(String gridAxesVer) {
        this.gridAxesVer = gridAxesVer;
    }

    public String getGridAxesVer() {
        return this.gridAxesVer;
    }

    public void setMinimumDepth(double minimumDepth) {
        this.minimumDepth = minimumDepth;
    }

    public double getMinimumDepth() {
        return this.minimumDepth;
    }

    public void setTimeStep(double timeStep) {
        this.timeStep = timeStep;
    }

    public double getTimeStep() {
        return this.timeStep;
    }

    public void setTotalNumberTimeStep(int totalNumberTimeStep) {
        this.totalNumberTimeStep = totalNumberTimeStep;
    }

    public int getTotalNumberTimeStep() {
        return this.totalNumberTimeStep;
    }

    public void setNumberTimeStepsBetweenOutput(int numberTimeStepsBetweenOutput) {
        this.numberTimeStepsBetweenOutput = numberTimeStepsBetweenOutput;
    }

    public int getNumberTimeStepsBetweenOutput() {
        return this.numberTimeStepsBetweenOutput;
    }

    public void setNumberTimeStepsStart(int numberTimeStepsStart) {
        this.numberTimeStepsStart = numberTimeStepsStart;
    }

    public int getNumberTimeStepsStart() {
        return this.numberTimeStepsStart;
    }

    public void setNumberGridStride(int numberStride) {
        this.numberStride = numberStride;
    }

    public int getNumberGridStride() {
        return this.numberStride;
    }

    public void setGlobalGrid(int globalGrid) {
        this.globalGrid = globalGrid;
    }

    public int getGlobalGrid() {
        return this.globalGrid;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setZoneName(String zoneName) {
        this.zoneName = zoneName;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public void setZoneCode(String zoneCode) {
        this.zoneCode = zoneCode;
    }

    public String getZoneCode() {
        return this.zoneCode;
    }

    public void setCol(String col) {
        this.col = col;
    }

    public String getCol() {
        return this.col;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getRow() {
        return this.row;
    }

    public void setSourceVersion(int sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    public int getSourceVersion() {
        return this.sourceVersion;
    }

    public void setNumberFaultPlanes(int numberFaultPlanes) {
        this.numberFaultPlanes = numberFaultPlanes;
    }

    public int getNumberFaultPlanes() {
        return this.numberFaultPlanes;
    }

    public void setXInteg(int xInteg) {
        this.xInteg = xInteg;
    }

    public int getXInteg() {
        return this.xInteg;
    }

    public void setYInteg(int yInteg) {
        this.yInteg = yInteg;
    }

    public int getYInteg() {
        return this.yInteg;
    }

    public void setVp(double Vp) {
        this.Vp = Vp;
    }

    public double getVp() {
        return this.Vp;
    }

    public void setVs(double Vs) {
        this.Vs = Vs;
    }

    public double getVs() {
        return this.Vs;
    }

    public void setEpLon(double epLon) {
        this.epLon = epLon;
    }

    public double getEpLon() {
        return this.epLon;
    }

    public void setEpLat(double epLat) {
        this.epLat = epLat;
    }

    public double getEpLat() {
        return this.epLat;
    }

    public void setLength(double length) {
        this.len = length;
    }

    public double getLength() {
        return this.len;
    }

    public void setWidth(double width) {
        this.wid = width;
    }

    public double getWidth() {
        return this.wid;
    }

    public void setDip(double dip) {
        this.dip = dip;
    }

    public double getDip() {
        return this.dip;
    }

    public void setRake(double rake) {
        this.rake = rake;
    }

    public double getRake() {
        return this.rake;
    }

    public void setStrike(double strike) {
        this.strike = strike;
    }

    public double getStrike() {
        return this.strike;
    }

    public void setSlip(double slip) {
        this.slip = slip;
    }

    public double getSlip() {
        return this.slip;
    }

    public void setDepth(double depth) {
        this.depth = depth;
    }

    public double getDepth() {
        return this.depth;
    }

    @Override
    public int compareTo(PropInfo o) {
        int zoneCmp = this.zoneCode.compareTo(o.getZoneCode());
        int colCmp = this.col.compareTo(o.getCol());
        int rowCmp = 0;
        if (this.row == o.getRow()) {
            rowCmp = 0;
        } else {
            int n = rowCmp = this.row > o.getRow() ? 1 : -1;
        }
        return zoneCmp != 0 ? zoneCmp : (rowCmp != 0 ? rowCmp : colCmp);
    }

    @Override
    public int getNumberOutputTimesteps() {
        return this.getNumberOutputTimesteps(this.getTotalNumberTimeStep());
    }

    public int getNumberOutputTimesteps(int totalNumTS) {
        int t = this.getNumberTimeStepsBetweenOutput();
        if (t <= 0) {
            return 0;
        }
        int icnt = 1;
        int nstart = this.getNumberTimeStepsStart();
        for (int nstep = 1; nstep <= totalNumTS; ++nstep) {
            if ((nstep - nstart) / t * t != nstep - nstart) continue;
            ++icnt;
        }
        return icnt;
    }

    public int getTimestepsAvailable() {
        int numTimeSteps = 0;
        try {
            NetcdfFile nc = NetcdfFile.open(this.haFileName);
            Dimension d = nc.findDimension("time");
            if (d != null) {
                numTimeSteps = d.getLength();
            }
            nc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return numTimeSteps;
    }

    public String toString() {
        return this.getName() + ", has output: " + this.hasValidNetCDF() + ", # steps: " + this.getTimestepsAvailable();
    }
}

