/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.pmel.util.Point2D;
import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.IndeterminateProgressMonitor;
import gov.noaa.tsunami.cmi.ModelEvent;
import gov.noaa.tsunami.cmi.ModelListener;
import gov.noaa.tsunami.cmi.MostExecDownloader;
import gov.noaa.tsunami.cmi.NiceScale;
import gov.noaa.tsunami.cmi.PrefsDialog;
import gov.noaa.tsunami.cmi.PropBathyDownloadDialog;
import gov.noaa.tsunami.cmi.PropInfo;
import gov.noaa.tsunami.cmi.PropRunner;
import gov.noaa.tsunami.cmi.SPropAnimPanel;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.macosx.JAnimatingProgressBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import java.util.zip.GZIPInputStream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ProgressMonitor;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PropRunPanel
extends JPanel
implements ActionListener,
ModelListener,
FocusListener {
    private static HashMap<String, URL> propGridURLs;
    private boolean lastFrameRequested = true;
    private int step = 0;
    private final Timer animationTimer;
    private static final ImageIcon runIcon;
    private static final ImageIcon stopIcon;
    private final SPropAnimPanel propAnimPanel;
    private LinkedHashMap<String, PropInfo> customSourceMap = new LinkedHashMap();
    private DecimalFormat dfx = new DecimalFormat("0.0");
    private DecimalFormat dfxx = new DecimalFormat("0.00");
    private DecimalFormat dfxxxxx = new DecimalFormat("0.00000");
    private static final NumberFormat intformat;
    private PropInfo propInfo;
    private boolean ignoreEvents = true;
    private PropRunner propRunner = null;
    private final List<ModelListener> modelListeners = new ArrayList<ModelListener>();
    private final MostExecDownloader MED;
    private IndeterminateProgressMonitor deformProgressMonitor = null;
    private JFrame parent = null;
    private BathyGrid defGrid = null;
    private PrefsDialog prefsDialog = null;
    private JSlider animSlider;
    private JToolBar animToolBar;
    private JComboBox bathyComboBox;
    private JTextField bathyTextField;
    private JSpinner colSpinner;
    private JButton customDefButton;
    private JTextField defTextField;
    private JButton deleteButton;
    private JFormattedTextField dipTextField;
    private JFormattedTextField epLatTextField;
    private JFormattedTextField epLonTextField;
    private JButton fastForwardButton;
    private JFormattedTextField faultDepthTextField;
    private JFormattedTextField faultLengthTextField;
    private JFormattedTextField faultWidthTextField;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JSplitPane jSplitPane1;
    private JFormattedTextField magTextField;
    private JPanel mapPanel;
    private JRadioButton maxRadioButton;
    private JFormattedTextField minDepthTextField;
    private JAnimatingProgressBar modelProgressBar;
    private JFormattedTextField numStepsTextField;
    private JFormattedTextField rakeTextField;
    private JButton rewindButton;
    private JSpinner rowSpinner;
    private JButton runStopButton;
    private JFormattedTextField skipGridTextField;
    private JFormattedTextField skipStepsTextField;
    private JFormattedTextField slipTextField;
    private JComboBox sourceComboBox;
    private JButton startStopButton;
    private JButton stepBackButton;
    private JButton stepForwardButton;
    private JFormattedTextField strikeTextField;
    private JFormattedTextField timeStepTextField;
    private JTextField zoneTextField;

    public PropRunPanel(JFrame frame) {
        this(frame, null);
    }

    public PropRunPanel(JFrame frame, PrefsDialog pd) {
        this.parent = frame;
        intformat.setGroupingUsed(false);
        this.initComponents();
        this.zoneTextField.setEditable(false);
        this.magTextField.setEditable(false);
        this.runStopButton.setIcon(runIcon);
        this.animationTimer = new Timer(1000, this);
        this.animationTimer.setActionCommand("animStep");
        this.propAnimPanel = new SPropAnimPanel();
        this.mapPanel.add((Component)this.propAnimPanel, "Center");
        this.propAnimPanel.addActionListener(this);
        this.addPropertyChangeListener(this.propAnimPanel);
        if (pd != null) {
            this.prefsDialog = pd;
        }
        this.MED = pd == null ? new MostExecDownloader(this) : new MostExecDownloader(this, pd);
        this.MED.initialCheckForMostUpdate(this.parent, 1);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("RIGHT"), "advance step");
        this.getActionMap().put("advance step", new RightStepAction());
        this.getInputMap(2).put(KeyStroke.getKeyStroke("LEFT"), "rewind step");
        this.getActionMap().put("rewind step", new LeftStepAction());
        this.setFocusable(true);
        this.modelListeners.add(this);
        this.ignoreEvents = false;
        this.addFocusListeners();
    }

    public void findPropRuns() {
        this.findCustomMostDotIn();
        this.propInfo = this.findLastModifiedPropInfo();
        SiftShare.log.info("Number of custom sources in prop folder: " + this.customSourceMap.size());
        this.updateTextFields();
        this.updateSourceComboBox();
        this.setSliderMaxAndSpacing();
    }

    public static void downloadGrids(SiftShare p, Runnable callBack) {
        propGridURLs = new HashMap();
        try {
            propGridURLs.put("glb4m_e1ice_SSL21_c4_20140417_corr.nc", new URL(CMIUtil.commitServerAddress + "/download/glb4m_e1ice_SSL21_c4_20140417_corr.nc.gz"));
            propGridURLs.put("pacific_4m_nocaribbean2.corr", new URL(CMIUtil.commitServerAddress + "/download/pacific_4m_nocaribbean2.corr.gz"));
            propGridURLs.put("indian_4m28.corr", new URL(CMIUtil.commitServerAddress + "/download/indian_4m28.corr.gz"));
            propGridURLs.put("atlantic_4m_20100601_ssl21_0360.corr", new URL(CMIUtil.commitServerAddress + "/download/atlantic_4m_20100601_ssl21_0360.corr.gz"));
            propGridURLs.put("Caribbean_etopo1m_ssl20_corr30.most", new URL(CMIUtil.commitServerAddress + "/download/Caribbean_etopo1m_ssl20_corr30.most.gz"));
            propGridURLs.put("Mediterranean_etopo2m_ssl19_corr30.most", new URL(CMIUtil.commitServerAddress + "/download/Mediterranean_etopo2m_ssl19_corr30.most.gz"));
        }
        catch (MalformedURLException ex) {
            SiftShare.log.log(Level.SEVERE, null, ex);
        }
        Thread downloadThread = new Thread(new downloadGridsWorker(propGridURLs, p, callBack));
        downloadThread.start();
    }

    public static boolean downloadGridsExist() {
        for (String s : propGridURLs.keySet()) {
            if (new File(CMIUtil.gridsDirName, s).exists()) continue;
            return false;
        }
        return true;
    }

    private void findCustomMostDotIn() {
        File dir = new File(CMIUtil.propDirName);
        File[] files = dir.listFiles();
        try {
            for (File f : files) {
                PropInfo pi;
                String fullFileName = f.getCanonicalPath();
                String fileName = f.getName();
                if (!fileName.endsWith(".in") || !fileName.startsWith("cu") || !(pi = new PropInfo(fullFileName)).hasValidMostDotIn()) continue;
                this.customSourceMap.put(pi.getName(), pi);
            }
            if (this.customSourceMap.size() == 0) {
                this.propInfo = new PropInfo(CMIUtil.propDirName + File.separator + "cu_001_a_.in");
                this.propInfo.writeDotIn();
                this.customSourceMap.put(this.propInfo.getName(), this.propInfo);
            } else {
                Iterator<String> it = this.customSourceMap.keySet().iterator();
                this.propInfo = this.customSourceMap.get(it.next());
            }
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.WARNING, "Error parsing most_db.in files", ex);
        }
    }

    public PropInfo findLastModifiedPropInfo() {
        Iterator<PropInfo> it = this.customSourceMap.values().iterator();
        PropInfo piLatest = it.next();
        while (it.hasNext()) {
            PropInfo pi = it.next();
            if (pi.getLastModified() <= piLatest.getLastModified()) continue;
            piLatest = pi;
        }
        return piLatest;
    }

    public void updateTextFields() {
        this.ignoreEvents = true;
        this.minDepthTextField.setValue(this.propInfo.getMinimumDepth());
        this.timeStepTextField.setValue(this.propInfo.getTimeStep());
        this.numStepsTextField.setValue(this.propInfo.getTotalNumberTimeStep());
        this.skipStepsTextField.setValue(this.propInfo.getNumberTimeStepsBetweenOutput());
        this.skipGridTextField.setValue(this.propInfo.getNumberGridStride());
        this.colSpinner.setValue(this.propInfo.getCol());
        this.rowSpinner.setValue(this.propInfo.getRow());
        this.zoneTextField.setText(this.propInfo.getZoneCode());
        this.epLatTextField.setValue(this.propInfo.getEpLat());
        this.epLonTextField.setValue(this.propInfo.getEpLon());
        this.faultDepthTextField.setValue(this.propInfo.getDepth());
        this.faultLengthTextField.setValue(this.propInfo.getLength());
        this.faultWidthTextField.setValue(this.propInfo.getWidth());
        this.slipTextField.setValue(this.propInfo.getSlip());
        this.dipTextField.setValue(this.propInfo.getDip());
        this.rakeTextField.setValue(this.propInfo.getRake());
        this.strikeTextField.setValue(this.propInfo.getStrike());
        this.magTextField.setValue(this.propInfo.getMw());
        this.defTextField.setText(this.propInfo.getDeformGridFilename());
        this.bathyTextField.setText(this.propInfo.getBathyFileName());
        this.ignoreEvents = false;
    }

    public void enableSeismicFields(boolean b) {
        this.epLatTextField.setEnabled(b);
        this.epLonTextField.setEnabled(b);
        this.faultDepthTextField.setEnabled(b);
        this.faultLengthTextField.setEnabled(b);
        this.faultWidthTextField.setEnabled(b);
        this.slipTextField.setEnabled(b);
        this.dipTextField.setEnabled(b);
        this.rakeTextField.setEnabled(b);
        this.strikeTextField.setEnabled(b);
    }

    public void enableTextFields(boolean b) {
        this.minDepthTextField.setEnabled(b);
        this.timeStepTextField.setEnabled(b);
        this.numStepsTextField.setEnabled(b);
        this.skipStepsTextField.setEnabled(b);
        this.skipGridTextField.setEnabled(b);
        this.colSpinner.setEnabled(b);
        this.rowSpinner.setEnabled(b);
        this.zoneTextField.setEnabled(b);
        this.epLatTextField.setEnabled(b);
        this.epLonTextField.setEnabled(b);
        this.faultDepthTextField.setEnabled(b);
        this.faultLengthTextField.setEnabled(b);
        this.faultWidthTextField.setEnabled(b);
        this.slipTextField.setEnabled(b);
        this.dipTextField.setEnabled(b);
        this.rakeTextField.setEnabled(b);
        this.strikeTextField.setEnabled(b);
        this.sourceComboBox.setEnabled(b);
        this.deleteButton.setEnabled(b);
        this.bathyComboBox.setEnabled(b);
        this.customDefButton.setEnabled(b);
    }

    public void updateSourceComboBox() {
        String[] sa = new String[this.customSourceMap.size()];
        ArrayList<PropInfo> piList = new ArrayList<PropInfo>(this.customSourceMap.values());
        Collections.sort(piList);
        for (int i = 0; i < piList.size(); ++i) {
            sa[i] = PropRunPanel.getKeyByValue(this.customSourceMap, piList.get(i));
        }
        this.sourceComboBox.setModel(new DefaultComboBoxModel<String>(sa));
        this.sourceComboBox.setSelectedItem(this.propInfo.getName());
    }

    public static <T, E> T getKeyByValue(Map<T, E> map, E value) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!Objects.equals(value, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public PropInfo createPropInfo() {
        PropInfo pi = new PropInfo(CMIUtil.propDirName + File.separator + String.format("%s_%03d_%s_.in", this.zoneTextField.getText(), this.rowSpinner.getValue(), this.colSpinner.getValue()));
        pi.setZoneCode(this.zoneTextField.getText());
        pi.setRow((Integer)this.rowSpinner.getValue());
        pi.setCol((String)this.colSpinner.getValue());
        this.bathyComboBox.setSelectedItem("Pacific");
        pi.setGridName((String)this.bathyComboBox.getSelectedItem());
        if (pi.getGridName().equals("Global")) {
            pi.setBathyFileName(CMIUtil.gridsDirName + File.separator + "glb4m_e1ice_SSL21_c4_20140417_corr.nc");
        } else if (pi.getGridName().equals("Pacific")) {
            pi.setBathyFileName(CMIUtil.gridsDirName + File.separator + "pacific_4m_nocaribbean2.corr");
        } else if (pi.getGridName().equals("Atlantic")) {
            pi.setBathyFileName(CMIUtil.gridsDirName + File.separator + "atlantic_4m_20100601_ssl21_0360.corr");
        } else if (pi.getGridName().equals("Indian")) {
            pi.setBathyFileName(CMIUtil.gridsDirName + File.separator + "indian_4m28.corr");
        } else if (pi.getGridName().equals("Caribbean")) {
            pi.setBathyFileName(CMIUtil.gridsDirName + File.separator + "Caribbean_etopo1m_ssl20_corr30.most");
        } else {
            pi.setBathyFileName(CMIUtil.gridsDirName + File.separator + "PUTNAMEHERE");
        }
        try {
            pi.setEpLat(Double.parseDouble(this.epLatTextField.getText()));
            pi.setEpLon(Double.parseDouble(this.epLonTextField.getText()));
            pi.setLength(Double.parseDouble(this.faultLengthTextField.getText()));
            pi.setWidth(Double.parseDouble(this.faultWidthTextField.getText()));
            pi.setDepth(Double.parseDouble(this.faultDepthTextField.getText()));
            pi.setDip(Double.parseDouble(this.dipTextField.getText()));
            pi.setSlip(Double.parseDouble(this.slipTextField.getText()));
            pi.setStrike(Double.parseDouble(this.strikeTextField.getText()));
            pi.setRake(Double.parseDouble(this.rakeTextField.getText()));
            pi.setMinimumDepth(Double.parseDouble(this.minDepthTextField.getText()));
            pi.setTimeStep(Double.parseDouble(this.timeStepTextField.getText()));
            pi.setTotalNumberTimeStep(Integer.parseInt(this.numStepsTextField.getText()));
            pi.setNumberTimeStepsBetweenOutput(Integer.parseInt(this.skipStepsTextField.getText()));
            pi.setNumberGridStride(Integer.parseInt(this.skipGridTextField.getText()));
        }
        catch (NumberFormatException nfe) {
            SiftShare.log.info("Error parsing text field for number: " + nfe);
            return null;
        }
        return pi;
    }

    public PropInfo getSelectedPropInfo() {
        int row = (Integer)this.rowSpinner.getValue();
        String zoneCode = this.zoneTextField.getText();
        String col = (String)this.colSpinner.getValue();
        String nam = String.format("%s%d%s", zoneCode, row, col);
        PropInfo pi = this.customSourceMap.get(nam);
        return pi;
    }

    private boolean askClearResults(PropInfo pi) {
        if (pi.hasValidNetCDF()) {
            int result = JOptionPane.showConfirmDialog(this, "There are currently results for this custom run.\nChanging parameters will delete the old results\nContinue?", "Clearing Results", 0, 3);
            if (result == 0) {
                this.clearResults();
                return true;
            }
            return false;
        }
        return true;
    }

    public void clearResults() {
        this.propInfo.clearResults();
        this.propAnimPanel.clearData();
        this.cancelModels();
        this.updateProgressBar(false);
    }

    public void loadResults() {
        this.propAnimPanel.readGrid();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel5 = new JPanel();
        this.jPanel4 = new JPanel();
        this.animToolBar = new JToolBar();
        this.rewindButton = new JButton();
        this.stepBackButton = new JButton();
        this.runStopButton = new JButton();
        this.stepForwardButton = new JButton();
        this.fastForwardButton = new JButton();
        this.animSlider = new JSlider();
        this.maxRadioButton = new JRadioButton();
        this.mapPanel = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.minDepthTextField = new JFormattedTextField(this.dfx);
        this.timeStepTextField = new JFormattedTextField(this.dfx);
        this.numStepsTextField = new JFormattedTextField(intformat);
        this.skipStepsTextField = new JFormattedTextField(intformat);
        this.skipGridTextField = new JFormattedTextField(intformat);
        this.jPanel1 = new JPanel();
        this.colSpinner = new JSpinner();
        this.rowSpinner = new JSpinner();
        this.zoneTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.sourceComboBox = new JComboBox();
        this.deleteButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.faultWidthTextField = new JFormattedTextField(this.dfx);
        this.faultLengthTextField = new JFormattedTextField(this.dfx);
        this.faultDepthTextField = new JFormattedTextField(this.dfxx);
        this.slipTextField = new JFormattedTextField(this.dfxx);
        this.dipTextField = new JFormattedTextField(this.dfx);
        this.rakeTextField = new JFormattedTextField(this.dfx);
        this.strikeTextField = new JFormattedTextField(this.dfx);
        this.epLatTextField = new JFormattedTextField(this.dfxxxxx);
        this.epLonTextField = new JFormattedTextField(this.dfxxxxx);
        this.magTextField = new JFormattedTextField(this.dfx);
        this.jLabel19 = new JLabel();
        this.startStopButton = new JButton();
        this.modelProgressBar = new JAnimatingProgressBar();
        this.jPanel7 = new JPanel();
        this.bathyComboBox = new JComboBox();
        this.customDefButton = new JButton();
        this.bathyTextField = new JTextField();
        this.defTextField = new JTextField();
        this.setPreferredSize(new Dimension(1118, 900));
        this.jSplitPane1.setBackground(new Color(102, 204, 255));
        this.jSplitPane1.setBorder(BorderFactory.createEtchedBorder());
        this.jSplitPane1.setDividerLocation(-1);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jPanel5.setBackground(new Color(255, 255, 255));
        this.jPanel5.setPreferredSize(new Dimension(200, 300));
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Animate"));
        this.animToolBar.setRollover(true);
        this.rewindButton.setIcon(new ImageIcon(this.getClass().getResource("/gov/noaa/tsunami/cmi/images/Rewind16.gif")));
        this.rewindButton.setToolTipText("First frame");
        this.rewindButton.setFocusable(false);
        this.rewindButton.setHorizontalTextPosition(0);
        this.rewindButton.setPreferredSize(new Dimension(28, 20));
        this.rewindButton.setVerticalTextPosition(3);
        this.rewindButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropRunPanel.this.rewindButtonActionPerformed(evt);
            }
        });
        this.animToolBar.add(this.rewindButton);
        this.stepBackButton.setIcon(new ImageIcon(this.getClass().getResource("/gov/noaa/tsunami/cmi/images/StepBack16.gif")));
        this.stepBackButton.setToolTipText("Previous frame");
        this.stepBackButton.setFocusable(false);
        this.stepBackButton.setHorizontalTextPosition(0);
        this.stepBackButton.setMinimumSize(new Dimension(28, 20));
        this.stepBackButton.setPreferredSize(new Dimension(28, 20));
        this.stepBackButton.setVerticalTextPosition(3);
        this.stepBackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropRunPanel.this.stepBackButtonActionPerformed(evt);
            }
        });
        this.animToolBar.add(this.stepBackButton);
        this.runStopButton.setToolTipText("Start/Stop animation");
        this.runStopButton.setFocusable(false);
        this.runStopButton.setHorizontalTextPosition(0);
        this.runStopButton.setMaximumSize(new Dimension(28, 20));
        this.runStopButton.setMinimumSize(new Dimension(28, 20));
        this.runStopButton.setPreferredSize(new Dimension(28, 20));
        this.runStopButton.setVerticalTextPosition(3);
        this.runStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropRunPanel.this.runStopButtonActionPerformed(evt);
            }
        });
        this.animToolBar.add(this.runStopButton);
        this.stepForwardButton.setIcon(new ImageIcon(this.getClass().getResource("/gov/noaa/tsunami/cmi/images/StepForward16.gif")));
        this.stepForwardButton.setToolTipText("Next frame");
        this.stepForwardButton.setFocusable(false);
        this.stepForwardButton.setHorizontalTextPosition(0);
        this.stepForwardButton.setMinimumSize(new Dimension(28, 20));
        this.stepForwardButton.setPreferredSize(new Dimension(28, 20));
        this.stepForwardButton.setVerticalTextPosition(3);
        this.stepForwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropRunPanel.this.stepForwardButtonActionPerformed(evt);
            }
        });
        this.animToolBar.add(this.stepForwardButton);
        this.fastForwardButton.setIcon(new ImageIcon(this.getClass().getResource("/gov/noaa/tsunami/cmi/images/FastForward16.gif")));
        this.fastForwardButton.setToolTipText("Last frame");
        this.fastForwardButton.setFocusable(false);
        this.fastForwardButton.setHorizontalTextPosition(0);
        this.fastForwardButton.setMinimumSize(new Dimension(28, 20));
        this.fastForwardButton.setPreferredSize(new Dimension(28, 20));
        this.fastForwardButton.setVerticalTextPosition(3);
        this.fastForwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropRunPanel.this.fastForwardButtonActionPerformed(evt);
            }
        });
        this.animToolBar.add(this.fastForwardButton);
        this.animSlider.setMajorTickSpacing(10);
        this.animSlider.setMinimum(1);
        this.animSlider.setPaintLabels(true);
        this.animSlider.setPaintTicks(true);
        this.animSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PropRunPanel.this.animSliderStateChanged(evt);
            }
        });
        this.maxRadioButton.setText("Max Amp");
        this.maxRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropRunPanel.this.maxRadioButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.animToolBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.maxRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.animSlider, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.animToolBar, -2, -1, -2).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxRadioButton).addComponent(this.animSlider, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel5.add((Component)this.jPanel4, "First");
        this.mapPanel.setLayout(new BorderLayout());
        this.jPanel5.add((Component)this.mapPanel, "Center");
        this.jSplitPane1.setRightComponent(this.jPanel5);
        this.jPanel5.getAccessibleContext().setAccessibleName("");
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Model Parameters"));
        this.jLabel14.setText("Minimum depth of offshore [m]");
        this.jLabel15.setText("Time step [sec]");
        this.jLabel16.setText("Number of steps");
        this.jLabel17.setText("Number of steps bet. output steps");
        this.jLabel18.setText("Skip every nth grid point");
        this.minDepthTextField.setText("20.0");
        this.minDepthTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropRunPanel.this.minDepthTextFieldPropertyChange(evt);
            }
        });
        this.timeStepTextField.setText("10.0");
        this.timeStepTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropRunPanel.this.timeStepTextFieldPropertyChange(evt);
            }
        });
        this.numStepsTextField.setText("8620");
        this.numStepsTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropRunPanel.this.numStepsTextFieldPropertyChange(evt);
            }
        });
        this.skipStepsTextField.setText("6");
        this.skipStepsTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropRunPanel.this.skipStepsTextFieldPropertyChange(evt);
            }
        });
        this.skipGridTextField.setText("4");
        this.skipGridTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropRunPanel.this.skipGridTextFieldPropertyChange(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.skipStepsTextField, -2, 65, -2).addGap(5, 5, 5)).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.skipGridTextField, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel17).addComponent(this.jLabel18))).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.minDepthTextField).addComponent(this.timeStepTextField).addComponent(this.numStepsTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel16).addComponent(this.jLabel14, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel15)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.minDepthTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(this.timeStepTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16).addComponent(this.numStepsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel17).addComponent(this.skipStepsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.skipGridTextField, -2, -1, -2).addComponent(this.jLabel18)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Source Identification"));
        this.colSpinner.setModel(new SpinnerListModel(new String[]{"x", "y", "z", "a", "b", "c", "d", "e", "f", "g"}));
        this.colSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PropRunPanel.this.colSpinnerStateChanged(evt);
            }
        });
        this.rowSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.rowSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PropRunPanel.this.rowSpinnerStateChanged(evt);
            }
        });
        this.zoneTextField.setColumns(2);
        this.zoneTextField.setText("cu");
        this.zoneTextField.setEnabled(false);
        this.jLabel3.setText("Zone:");
        this.jLabel4.setText("Col:");
        this.jLabel5.setText("Row:");
        this.sourceComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"ev001a", "ev002a", "ev001b"}));
        this.sourceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropRunPanel.this.sourceComboBoxActionPerformed(evt);
            }
        });
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropRunPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.sourceComboBox, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.zoneTextField, -2, -1, -2).addGap(12, 12, 12).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rowSpinner, -2, 60, -2).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colSpinner, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.zoneTextField, -2, -1, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.rowSpinner, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.colSpinner, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourceComboBox, -2, -1, -2).addComponent(this.deleteButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Seismic Info"));
        this.jLabel2.setText("Epicenter Latitude [deg]:");
        this.jLabel6.setText("Longitude [deg]:");
        this.jLabel7.setText("Length [km]:");
        this.jLabel8.setText("Width [km]:");
        this.jLabel9.setText("Depth [km]:");
        this.jLabel10.setText("Slip [m]:");
        this.jLabel11.setText("Dip [deg]:");
        this.jLabel12.setText("Rake [deg]:");
        this.jLabel13.setText("Strike [deg]:");
        this.faultWidthTextField.setText("50.0");
        this.faultWidthTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropRunPanel.this.faultWidthTextFieldPropertyChange(evt);
            }
        });
        this.faultLengthTextField.setText("100.0");
        this.faultLengthTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropRunPanel.this.faultLengthTextFieldPropertyChange(evt);
            }
        });
        this.faultDepthTextField.setText("5.00");
        this.faultDepthTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropRunPanel.this.faultDepthTextFieldPropertyChange(evt);
            }
        });
        this.slipTextField.setText("1.00");
        this.slipTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropRunPanel.this.slipTextFieldPropertyChange(evt);
            }
        });
        this.dipTextField.setText("15.0");
        this.dipTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropRunPanel.this.dipTextFieldPropertyChange(evt);
            }
        });
        this.rakeTextField.setText("90.0");
        this.rakeTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropRunPanel.this.rakeTextFieldPropertyChange(evt);
            }
        });
        this.strikeTextField.setText("271.0");
        this.strikeTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropRunPanel.this.strikeTextFieldPropertyChange(evt);
            }
        });
        this.epLatTextField.setColumns(8);
        this.epLatTextField.setText("21.0000");
        this.epLatTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropRunPanel.this.epLatTextFieldPropertyChange(evt);
            }
        });
        this.epLonTextField.setColumns(9);
        this.epLonTextField.setText("193.0000");
        this.epLonTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropRunPanel.this.epLonTextFieldPropertyChange(evt);
            }
        });
        this.magTextField.setText("8.5");
        this.jLabel19.setText("Mw:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dipTextField, -2, 58, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rakeTextField, -2, 60, -2).addGap(18, 18, 18).addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.strikeTextField, -2, 61, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.faultLengthTextField, -2, 67, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.faultDepthTextField, -2, 66, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel10).addGap(27, 27, 27))).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.faultWidthTextField).addComponent(this.slipTextField)).addGap(18, 18, 18).addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.magTextField, -2, 43, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.epLatTextField, -2, 84, -2).addGap(18, 18, 18).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.epLonTextField, -2, 96, -2))).addGap(0, 0, Short.MAX_VALUE)))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel6).addComponent(this.epLatTextField, -2, -1, -2).addComponent(this.epLonTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jLabel8).addComponent(this.faultWidthTextField, -2, -1, -2).addComponent(this.faultLengthTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jLabel10).addComponent(this.faultDepthTextField, -2, -1, -2).addComponent(this.slipTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.magTextField, -2, -1, -2).addComponent(this.jLabel19)).addGap(22, 22, 22))).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jLabel12).addComponent(this.jLabel13).addComponent(this.dipTextField, -2, -1, -2).addComponent(this.rakeTextField, -2, -1, -2).addComponent(this.strikeTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.startStopButton.setText("Start Propagation");
        this.startStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropRunPanel.this.startStopButtonActionPerformed(evt);
            }
        });
        this.modelProgressBar.setMaximumSize(new Dimension(Short.MAX_VALUE, 35));
        this.modelProgressBar.setMinimumSize(new Dimension(10, 35));
        this.modelProgressBar.setPreferredSize(new Dimension(146, 35));
        this.modelProgressBar.setStringPainted(true);
        this.jPanel7.setBorder(BorderFactory.createTitledBorder("Bathymetry"));
        this.bathyComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Global", "Pacific", "Atlantic", "Indian", "Caribbean", "Mediterranean", "Custom"}));
        this.bathyComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropRunPanel.this.bathyComboBoxActionPerformed(evt);
            }
        });
        this.customDefButton.setText("Deformation file:");
        this.customDefButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropRunPanel.this.customDefButtonActionPerformed(evt);
            }
        });
        this.bathyTextField.setEditable(false);
        this.bathyTextField.setText("<bathymetry filename>");
        this.defTextField.setEditable(false);
        this.defTextField.setText("none (using Seismic Info)");
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bathyComboBox, -2, -1, -2).addComponent(this.customDefButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defTextField).addComponent(this.bathyTextField)).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bathyComboBox, -2, -1, -2).addComponent(this.bathyTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.customDefButton).addComponent(this.defTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel7, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.startStopButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modelProgressBar, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.startStopButton, -1, -1, Short.MAX_VALUE).addComponent(this.modelProgressBar, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, -1, -2).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel6Layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel7, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jSplitPane1.setLeftComponent(this.jPanel6);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
    }

    private void rewindButtonActionPerformed(ActionEvent evt) {
        this.setTimeStep(0);
        this.lastFrameRequested = false;
    }

    private void stepBackButtonActionPerformed(ActionEvent evt) {
        this.setTimeStep(this.getTimeStep() - 1);
        this.lastFrameRequested = false;
    }

    private void runStopButtonActionPerformed(ActionEvent evt) {
        this.lastFrameRequested = false;
        if (this.animationTimer.isRunning()) {
            this.stopAnimation();
        } else {
            this.runStopButton.setIcon(stopIcon);
            this.animationTimer.setDelay(200);
            this.animationTimer.start();
        }
        this.requestFocusInWindow();
    }

    private void stepForwardButtonActionPerformed(ActionEvent evt) {
        this.setTimeStep(this.getTimeStep() + 1);
        this.lastFrameRequested = false;
    }

    private void fastForwardButtonActionPerformed(ActionEvent evt) {
        if (this.animationTimer.isRunning()) {
            this.stopAnimation();
        }
        this.setTimeStep(this.getTimeStepCount());
        this.lastFrameRequested = true;
    }

    private boolean doParameterChange(PropertyChangeEvent evt) {
        return !this.ignoreEvents && this.propInfo != null && "value".equals(evt.getPropertyName()) && evt.getNewValue() != null;
    }

    private void rowSpinnerStateChanged(ChangeEvent evt) {
        if (this.ignoreEvents) {
            return;
        }
        PropInfo pi = this.getSelectedPropInfo();
        if (pi == null) {
            pi = this.createPropInfo();
            pi.writeDotIn();
            this.customSourceMap.put(pi.getName(), pi);
        }
        this.propInfo = pi;
        this.updateSourceComboBox();
    }

    private void colSpinnerStateChanged(ChangeEvent evt) {
        if (this.ignoreEvents) {
            return;
        }
        PropInfo pi = this.getSelectedPropInfo();
        if (pi == null) {
            pi = this.createPropInfo();
            pi.writeDotIn();
            this.customSourceMap.put(pi.getName(), pi);
        }
        this.propInfo = pi;
        this.updateSourceComboBox();
    }

    private void bathyComboBoxActionPerformed(ActionEvent evt) {
        if (this.ignoreEvents) {
            return;
        }
        String bathyfn = (String)this.bathyComboBox.getSelectedItem();
        if (bathyfn.equals("Global")) {
            if (!this.propInfo.getBathyFileName().endsWith("glb4m_e1ice_SSL21_c4_20140417_corr.nc")) {
                if (this.askClearResults(this.propInfo)) {
                    this.propInfo.clearResults();
                    this.propInfo.setDeformGrid(null);
                    this.propInfo.setGridName("Global");
                    this.propInfo.setBathyFileName(CMIUtil.gridsDirName + File.separator + "glb4m_e1ice_SSL21_c4_20140417_corr.nc");
                    this.propInfo.setMinimumDepth(20.0);
                    this.propInfo.setTimeStep(8.0);
                    this.propInfo.setTotalNumberTimeStep(10800);
                    this.propInfo.setNumberTimeStepsBetweenOutput(7);
                    this.propInfo.setNumberGridStride(4);
                    this.propInfo.setGlobalGrid(1);
                    this.propInfo.setEpLat(50.47);
                    this.propInfo.setEpLon(185.4);
                    this.propInfo.writeDotIn();
                } else {
                    this.ignoreEvents = true;
                    this.bathyComboBox.setSelectedItem(this.propInfo.getGridName());
                    this.ignoreEvents = false;
                }
            }
        } else if (bathyfn.equals("Pacific")) {
            if (!this.propInfo.getBathyFileName().endsWith("pacific_4m_nocaribbean2.corr")) {
                if (this.askClearResults(this.propInfo)) {
                    this.propInfo.clearResults();
                    this.propInfo.setDeformGrid(null);
                    this.propInfo.setGridName("Pacific");
                    this.propInfo.setBathyFileName(CMIUtil.gridsDirName + File.separator + "pacific_4m_nocaribbean2.corr");
                    this.propInfo.setMinimumDepth(20.0);
                    this.propInfo.setTimeStep(10.0);
                    this.propInfo.setTotalNumberTimeStep(8640);
                    this.propInfo.setNumberTimeStepsBetweenOutput(6);
                    this.propInfo.setNumberGridStride(1);
                    this.propInfo.setGlobalGrid(0);
                    this.propInfo.setEpLat(50.47);
                    this.propInfo.setEpLon(185.4);
                    this.propInfo.writeDotIn();
                } else {
                    this.ignoreEvents = true;
                    this.bathyComboBox.setSelectedItem(this.propInfo.getGridName());
                    this.ignoreEvents = false;
                }
            }
        } else if (bathyfn.equals("Atlantic")) {
            if (!this.propInfo.getBathyFileName().endsWith("atlantic_4m_20100601_ssl21_0360.corr")) {
                if (this.askClearResults(this.propInfo)) {
                    this.propInfo.clearResults();
                    this.propInfo.setDeformGrid(null);
                    this.propInfo.setGridName("Atlantic");
                    this.propInfo.setBathyFileName(CMIUtil.gridsDirName + File.separator + "atlantic_4m_20100601_ssl21_0360.corr");
                    this.propInfo.setMinimumDepth(20.0);
                    this.propInfo.setTimeStep(10.0);
                    this.propInfo.setTotalNumberTimeStep(8640);
                    this.propInfo.setNumberGridStride(1);
                    this.propInfo.setNumberTimeStepsBetweenOutput(6);
                    this.propInfo.setGlobalGrid(0);
                    this.propInfo.setEpLat(20.742);
                    this.propInfo.setEpLon(289.11);
                    this.propInfo.writeDotIn();
                } else {
                    this.ignoreEvents = true;
                    this.bathyComboBox.setSelectedItem(this.propInfo.getGridName());
                    this.ignoreEvents = false;
                }
            }
        } else if (bathyfn.equals("Indian")) {
            if (!this.propInfo.getBathyFileName().endsWith("indian_4m28.corr")) {
                if (this.askClearResults(this.propInfo)) {
                    this.propInfo.clearResults();
                    this.propInfo.setDeformGrid(null);
                    this.propInfo.setGridName("Indian");
                    this.propInfo.setBathyFileName(CMIUtil.gridsDirName + File.separator + "indian_4m28.corr");
                    this.propInfo.setMinimumDepth(20.0);
                    this.propInfo.setTimeStep(12.0);
                    this.propInfo.setTotalNumberTimeStep(5400);
                    this.propInfo.setNumberGridStride(1);
                    this.propInfo.setNumberTimeStepsBetweenOutput(5);
                    this.propInfo.setGlobalGrid(0);
                    this.propInfo.setEpLat(1.47);
                    this.propInfo.setEpLon(95.3);
                    this.propInfo.writeDotIn();
                } else {
                    this.ignoreEvents = true;
                    this.bathyComboBox.setSelectedItem(this.propInfo.getGridName());
                    this.ignoreEvents = false;
                }
            }
        } else if (bathyfn.equals("Caribbean")) {
            if (!this.propInfo.getBathyFileName().endsWith("Caribbean_etopo1m_ssl20_corr30.most")) {
                if (this.askClearResults(this.propInfo)) {
                    this.propInfo.clearResults();
                    this.propInfo.setDeformGrid(null);
                    this.propInfo.setGridName("Caribbean");
                    this.propInfo.setGridAxesVer("20170719");
                    this.propInfo.setBathyFileName(CMIUtil.gridsDirName + File.separator + "Caribbean_etopo1m_ssl20_corr30.most");
                    this.propInfo.setMinimumDepth(10.0);
                    this.propInfo.setTimeStep(5.0);
                    this.propInfo.setTotalNumberTimeStep(5772);
                    this.propInfo.setNumberGridStride(1);
                    this.propInfo.setNumberTimeStepsBetweenOutput(12);
                    this.propInfo.setGlobalGrid(0);
                    this.propInfo.setEpLat(12.3);
                    this.propInfo.setEpLon(286.3);
                    this.propInfo.writeDotIn();
                } else {
                    this.ignoreEvents = true;
                    this.bathyComboBox.setSelectedItem(this.propInfo.getGridName());
                    this.ignoreEvents = false;
                }
            }
        } else if (bathyfn.equals("Mediterranean")) {
            if (!this.propInfo.getBathyFileName().endsWith("Mediterranean_etopo2m_ssl19_corr30.most")) {
                if (this.askClearResults(this.propInfo)) {
                    this.propInfo.clearResults();
                    this.propInfo.setDeformGrid(null);
                    this.propInfo.setGridName("Mediterranean");
                    this.propInfo.setGridAxesVer("20170807");
                    this.propInfo.setBathyFileName(CMIUtil.gridsDirName + File.separator + "Mediterranean_etopo2m_ssl19_corr30.most");
                    this.propInfo.setMinimumDepth(10.0);
                    this.propInfo.setTimeStep(10.0);
                    this.propInfo.setTotalNumberTimeStep(2886);
                    this.propInfo.setNumberGridStride(1);
                    this.propInfo.setNumberTimeStepsBetweenOutput(6);
                    this.propInfo.setGlobalGrid(0);
                    this.propInfo.setEpLat(36.925);
                    this.propInfo.setEpLon(27.414);
                    this.propInfo.setStrike(84.0);
                    this.propInfo.writeDotIn();
                } else {
                    this.ignoreEvents = true;
                    this.bathyComboBox.setSelectedItem(this.propInfo.getGridName());
                    this.ignoreEvents = false;
                }
            }
        } else if (bathyfn.equals("Custom") && !this.propInfo.getGridName().equals("Custom")) {
            if (this.askClearResults(this.propInfo)) {
                File file = null;
                PropBathyDownloadDialog pdd = new PropBathyDownloadDialog((Frame)this.parent, true);
                pdd.setAlwaysOnTop(true);
                pdd.setVisible(true);
                if (pdd.getReturnStatus() == 1) {
                    file = pdd.getFile();
                    pdd.dispose();
                    if (file == null) {
                        this.ignoreEvents = true;
                        this.bathyComboBox.setSelectedItem(this.propInfo.getGridName());
                        this.ignoreEvents = false;
                    } else {
                        try {
                            BathyGrid grid = new BathyGrid(file);
                            this.propInfo.clearResults();
                            this.propInfo.setDeformGrid(null);
                            this.propInfo.setGridName("Custom");
                            this.propInfo.setBathyFileName(grid.getFilePath());
                            this.propInfo.setMinimumDepth(10.0);
                            double timeStep = 0.92 * grid.getMaxTimeStep();
                            this.propInfo.setTimeStep(timeStep);
                            int totalNumberTimeSteps = 100 * (int)Math.round(43200.0 / timeStep / 100.0);
                            this.propInfo.setTotalNumberTimeStep(totalNumberTimeSteps);
                            this.propInfo.setNumberTimeStepsBetweenOutput((int)Math.ceil(60.0 / timeStep));
                            this.propInfo.setNumberGridStride(1);
                            this.propInfo.setGlobalGrid(0);
                            this.propInfo.setEpLat((grid.getMaxLat() + grid.getMinLat()) / 2.0);
                            this.propInfo.setEpLon((grid.getMaxLon() + grid.getMinLon()) / 2.0);
                            this.propInfo.writeDotIn();
                        }
                        catch (IOException ioe) {
                            JOptionPane.showMessageDialog(this.propAnimPanel, "File selected is not a MOST bathymetry file.\nPlease select a new file.", "Invalid MOST Bathymetry File", 2);
                            this.ignoreEvents = true;
                            this.bathyComboBox.setSelectedItem(this.propInfo.getGridName());
                            this.ignoreEvents = false;
                        }
                    }
                }
            } else {
                this.ignoreEvents = true;
                this.bathyComboBox.setSelectedItem(this.propInfo.getGridName());
                this.ignoreEvents = false;
            }
        }
        this.updateTextFields();
        this.propAnimPanel.setPropInfo(this.propInfo);
    }

    private void startStopButtonActionPerformed(ActionEvent evt) {
        this.startStopModelProcess();
    }

    private void sourceComboBoxActionPerformed(ActionEvent evt) {
        if (this.ignoreEvents) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.propInfo = this.customSourceMap.get((String)this.sourceComboBox.getSelectedItem());
        SiftShare.log.info("PropInfo selected: " + this.propInfo);
        this.propInfo.writeDotIn();
        if (this.propInfo.isCustomDeformation()) {
            this.enableSeismicFields(false);
        } else {
            this.enableSeismicFields(true);
        }
        this.updateTextFields();
        this.propAnimPanel.setPropInfo(this.propInfo);
        this.ignoreEvents = true;
        this.bathyComboBox.setSelectedItem(this.propInfo.getGridName());
        if (this.propRunner != null && this.propRunner.isRunning()) {
            this.propRunner.stop();
        }
        this.modelProgressBar.setAnimating(false);
        int curts = this.propInfo.getTimestepsAvailable();
        int maxts = this.propInfo.getNumberOutputTimesteps();
        this.modelProgressBar.setString(String.format("%s %s: step %d of %d", this.propInfo.getName(), curts == maxts ? "finished" : "stopped", curts, maxts));
        this.modelProgressBar.setMaximum(maxts);
        this.modelProgressBar.setValue(curts);
        this.setSliderMaxAndSpacing();
        this.setTimeStep(0);
        this.ignoreEvents = false;
        this.setMaxAmp(this.maxRadioButton.isSelected());
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int result = JOptionPane.showConfirmDialog(this, "This action will delete this custom run (including results).\n\nContinue?", "Deleting Custom Propagation Run", 0, 3);
        if (result == 0) {
            this.propInfo.clearResults();
            this.propInfo.clearDotIn();
            this.customSourceMap.remove(this.propInfo.getName());
            this.findCustomMostDotIn();
            this.propInfo = this.findLastModifiedPropInfo();
            this.updateTextFields();
            this.updateSourceComboBox();
            this.loadResults();
        }
    }

    private void faultWidthTextFieldPropertyChange(PropertyChangeEvent evt) {
        double test;
        if (this.doParameterChange(evt) && (test = ((Number)this.faultWidthTextField.getValue()).doubleValue()) != this.propInfo.getWidth()) {
            if (this.askClearResults(this.propInfo)) {
                this.propInfo.setWidth(test);
                this.propInfo.clearResults();
                this.propInfo.writeDotIn();
                this.updateProgressBar(false);
                this.propAnimPanel.setPropInfo(this.propInfo);
            }
            this.updateTextFields();
        }
    }

    private void faultLengthTextFieldPropertyChange(PropertyChangeEvent evt) {
        double test;
        if (this.doParameterChange(evt) && (test = ((Number)this.faultLengthTextField.getValue()).doubleValue()) != this.propInfo.getLength()) {
            if (this.askClearResults(this.propInfo)) {
                this.propInfo.setLength(test);
                this.propInfo.clearResults();
                this.propInfo.writeDotIn();
                this.updateProgressBar(false);
                this.propAnimPanel.setPropInfo(this.propInfo);
            }
            this.updateTextFields();
        }
    }

    private void faultDepthTextFieldPropertyChange(PropertyChangeEvent evt) {
        double test;
        if (this.doParameterChange(evt) && (test = ((Number)this.faultDepthTextField.getValue()).doubleValue()) != this.propInfo.getDepth()) {
            if (this.askClearResults(this.propInfo)) {
                this.propInfo.setDepth(test);
                this.propInfo.clearResults();
                this.propInfo.writeDotIn();
                this.updateProgressBar(false);
                this.propAnimPanel.setPropInfo(this.propInfo);
            } else {
                this.updateTextFields();
            }
        }
    }

    private void slipTextFieldPropertyChange(PropertyChangeEvent evt) {
        double test;
        if (this.doParameterChange(evt) && (test = ((Number)this.slipTextField.getValue()).doubleValue()) != this.propInfo.getSlip()) {
            if (this.askClearResults(this.propInfo)) {
                this.propInfo.setSlip(test);
                this.propInfo.clearResults();
                this.propInfo.writeDotIn();
                this.updateProgressBar(false);
                this.propAnimPanel.setPropInfo(this.propInfo);
            }
            this.updateTextFields();
        }
    }

    private void dipTextFieldPropertyChange(PropertyChangeEvent evt) {
        double test;
        if (this.doParameterChange(evt) && (test = ((Number)this.dipTextField.getValue()).doubleValue()) != this.propInfo.getDip()) {
            if (this.askClearResults(this.propInfo)) {
                this.propInfo.setDip(test);
                this.propInfo.clearResults();
                this.propInfo.writeDotIn();
                this.updateProgressBar(false);
                this.propAnimPanel.setPropInfo(this.propInfo);
            } else {
                this.updateTextFields();
            }
        }
    }

    private void rakeTextFieldPropertyChange(PropertyChangeEvent evt) {
        double test;
        if (this.doParameterChange(evt) && (test = ((Number)this.rakeTextField.getValue()).doubleValue()) != this.propInfo.getRake()) {
            if (this.askClearResults(this.propInfo)) {
                this.propInfo.setRake(test);
                this.propInfo.clearResults();
                this.propInfo.writeDotIn();
                this.updateProgressBar(false);
                this.propAnimPanel.setPropInfo(this.propInfo);
            } else {
                this.updateTextFields();
            }
        }
    }

    private void strikeTextFieldPropertyChange(PropertyChangeEvent evt) {
        double test;
        if (this.doParameterChange(evt) && (test = ((Number)this.strikeTextField.getValue()).doubleValue()) != this.propInfo.getStrike()) {
            if (this.askClearResults(this.propInfo)) {
                this.propInfo.setStrike(test);
                this.propInfo.clearResults();
                this.propInfo.writeDotIn();
                this.updateProgressBar(false);
                this.propAnimPanel.setPropInfo(this.propInfo);
            } else {
                this.updateTextFields();
            }
        }
    }

    private void epLatTextFieldPropertyChange(PropertyChangeEvent evt) {
        double test;
        if (this.doParameterChange(evt) && (test = ((Number)this.epLatTextField.getValue()).doubleValue()) != this.propInfo.getEpLat()) {
            if (this.askClearResults(this.propInfo)) {
                this.propInfo.setEpLat(test);
                this.propInfo.clearResults();
                this.propInfo.writeDotIn();
                this.updateProgressBar(false);
                this.propAnimPanel.setPropInfo(this.propInfo);
            } else {
                this.updateTextFields();
            }
            this.propAnimPanel.setEpicenter(this.propInfo.getEpLon(), this.propInfo.getEpLat());
        }
    }

    private void epLonTextFieldPropertyChange(PropertyChangeEvent evt) {
        double test;
        if (this.doParameterChange(evt) && (test = ((Number)this.epLonTextField.getValue()).doubleValue()) != this.propInfo.getEpLon()) {
            if (this.askClearResults(this.propInfo)) {
                this.propInfo.setEpLon(test);
                this.propInfo.clearResults();
                this.propInfo.writeDotIn();
                this.updateProgressBar(false);
                this.propAnimPanel.setPropInfo(this.propInfo);
            } else {
                this.updateTextFields();
            }
            this.propAnimPanel.setEpicenter(this.propInfo.getEpLon(), this.propInfo.getEpLat());
        }
    }

    private void minDepthTextFieldPropertyChange(PropertyChangeEvent evt) {
        double test;
        if (this.doParameterChange(evt) && (test = ((Number)this.minDepthTextField.getValue()).doubleValue()) != this.propInfo.getMinimumDepth()) {
            if (this.askClearResults(this.propInfo)) {
                this.propInfo.setMinimumDepth(test);
                this.propInfo.clearResults();
                this.propInfo.writeDotIn();
                this.updateProgressBar(false);
            } else {
                this.updateTextFields();
            }
        }
    }

    private void timeStepTextFieldPropertyChange(PropertyChangeEvent evt) {
        double test;
        if (this.doParameterChange(evt) && (test = ((Number)this.timeStepTextField.getValue()).doubleValue()) != this.propInfo.getTimeStep()) {
            if (this.askClearResults(this.propInfo)) {
                this.propInfo.setTimeStep(test);
                this.propInfo.clearResults();
                this.propInfo.writeDotIn();
                this.updateProgressBar(false);
            } else {
                this.updateTextFields();
            }
        }
    }

    private void numStepsTextFieldPropertyChange(PropertyChangeEvent evt) {
        int test;
        if (this.doParameterChange(evt) && (test = ((Number)this.numStepsTextField.getValue()).intValue()) != this.propInfo.getTotalNumberTimeStep()) {
            if (this.propInfo.getNumberOutputTimesteps(test) < this.propInfo.getTimestepsAvailable()) {
                if (this.askClearResults(this.propInfo)) {
                    this.propInfo.setTotalNumberTimeStep(test);
                    this.propInfo.clearResults();
                    this.propInfo.writeDotIn();
                    this.updateProgressBar(false);
                } else {
                    this.updateTextFields();
                }
            } else {
                this.propInfo.setTotalNumberTimeStep(test);
                this.propInfo.writeDotIn();
                this.updateProgressBar(false);
            }
        }
    }

    private void skipStepsTextFieldPropertyChange(PropertyChangeEvent evt) {
        int test;
        if (this.doParameterChange(evt) && (test = ((Number)this.skipStepsTextField.getValue()).intValue()) != this.propInfo.getNumberTimeStepsBetweenOutput()) {
            if (this.askClearResults(this.propInfo)) {
                this.propInfo.setNumberTimeStepsBetweenOutput(test);
                this.propInfo.clearResults();
                this.propInfo.writeDotIn();
                this.updateProgressBar(false);
            } else {
                this.updateTextFields();
            }
        }
    }

    private void skipGridTextFieldPropertyChange(PropertyChangeEvent evt) {
        int test;
        if (this.doParameterChange(evt) && (test = ((Number)this.skipGridTextField.getValue()).intValue()) != this.propInfo.getNumberGridStride()) {
            if (this.askClearResults(this.propInfo)) {
                this.propInfo.setNumberGridStride(test);
                this.propInfo.clearResults();
                this.propInfo.writeDotIn();
                this.updateProgressBar(false);
            } else {
                this.updateTextFields();
            }
        }
    }

    private void animSliderStateChanged(ChangeEvent evt) {
        if (this.ignoreEvents) {
            return;
        }
        if (!this.animSlider.getValueIsAdjusting()) {
            this.lastFrameRequested = false;
            this.setTimeStep(this.animSlider.getValue());
        }
    }

    private void maxRadioButtonActionPerformed(ActionEvent evt) {
        this.setMaxAmp(this.maxRadioButton.isSelected());
    }

    private void customDefButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser(CMIUtil.baseDirName);
        int ret = fc.showOpenDialog(this);
        if (ret == 0) {
            this.setCursor(new Cursor(3));
            try {
                this.defGrid = new BathyGrid(fc.getSelectedFile(), true);
                if (this.askClearResults(this.propInfo)) {
                    if (this.propInfo.setDeformGrid(this.defGrid)) {
                        double[] ll = this.defGrid.getLonLatAtMaxDepth();
                        this.propInfo.clearResults();
                        this.propInfo.setEpLon(ll[0]);
                        this.propInfo.setEpLat(ll[1]);
                        this.enableSeismicFields(false);
                        this.propInfo.writeDotIn();
                        this.propAnimPanel.setPropInfo(this.propInfo);
                    } else {
                        JOptionPane.showMessageDialog(this, "Deformation grid not on the same grid axes as bathymetry grid", "Error", 2);
                        this.enableSeismicFields(true);
                    }
                } else {
                    this.enableSeismicFields(true);
                }
            }
            catch (IOException ioe) {
                SiftShare.log.info("Can't read custom propagation deformation grid file: " + fc.getSelectedFile());
                JOptionPane.showMessageDialog(this, "Can't read custom deformation file: " + fc.getSelectedFile(), "Error reading deformation", 2);
            }
            this.updateTextFields();
            this.setCursor(new Cursor(0));
        }
    }

    private void setMaxAmp(boolean b) {
        this.setAnimButtonsEnabled(!b);
        this.animSlider.setEnabled(!b);
        this.propAnimPanel.setMaxAmp(b);
        this.loadResults();
    }

    private void setAnimButtonsEnabled(boolean b) {
        this.rewindButton.setEnabled(b);
        this.stepBackButton.setEnabled(b);
        this.stepForwardButton.setEnabled(b);
        this.fastForwardButton.setEnabled(b);
        this.runStopButton.setEnabled(b);
    }

    private void setSliderMaxAndSpacing() {
        int tnts = this.propInfo.getTimestepsAvailable();
        if (tnts < 1) {
            tnts = 1;
        }
        this.ignoreEvents = true;
        this.animSlider.setMaximum(tnts);
        NiceScale ns = new NiceScale(0.0, tnts);
        if (ns.getTickSpacing() >= 1.0) {
            this.animSlider.setMajorTickSpacing((int)Math.round(ns.getTickSpacing()));
            this.animSlider.setLabelTable(this.animSlider.createStandardLabels((int)Math.round(ns.getTickSpacing())));
        }
        this.ignoreEvents = false;
    }

    public void startStopModelProcess() {
        if (this.propRunner != null && this.propRunner.isRunning()) {
            if (this.parent != null) {
                this.deformProgressMonitor = new IndeterminateProgressMonitor(this.parent, "Stopping Model");
                this.deformProgressMonitor.setLocationRelativeTo(this);
                this.deformProgressMonitor.setVisible(true);
            }
            this.propRunner.stop();
        } else {
            while (!new File(CMIUtil.MOSTProp_EXEC).isFile()) {
                Object[] buttons = new String[]{"Download", "Specify location", "Cancel"};
                int result = JOptionPane.showOptionDialog(this, "The MOST Propagation model executable is not found.\n\nDownload a copy?", "MOST model not available", -1, 3, null, buttons, buttons[0]);
                if (result == 0) {
                    this.MED.setCompletionCallback(new Runnable(){

                        @Override
                        public void run() {
                            PropRunPanel.this.startStopModelProcess();
                        }
                    });
                    this.MED.downloadMOSTProp();
                    return;
                }
                if (result == 1) {
                    File f;
                    JFileChooser fc = new JFileChooser(CMIUtil.baseDirName + File.separator + "bin");
                    int ret = fc.showOpenDialog(this);
                    if (ret != 0 || !(f = fc.getSelectedFile()).exists()) continue;
                    CMIUtil.MOSTProp_EXEC = f.getPath();
                    if (this.prefsDialog == null) continue;
                    this.prefsDialog.savePrefs();
                    continue;
                }
                return;
            }
            this.propRunner = new PropRunner(this.propInfo, this.modelListeners);
            if (this.propInfo.hasValidNetCDF()) {
                Object[] opts = new String[]{"Continue Run", "Start Over", "Cancel"};
                int r = JOptionPane.showOptionDialog(this, "Do you want to continue the model at the time the last run stopped,\nor start over at the beginning?", "Use Model Restart?", -1, 3, null, opts, opts[0]);
                if (r == 2 || r == -1) {
                    this.propRunner = null;
                    return;
                }
                if (r == 1) {
                    this.propAnimPanel.closeFile();
                    this.propInfo.clearResults();
                }
            }
            this.propRunner.start();
            if (this.parent != null) {
                this.deformProgressMonitor = new IndeterminateProgressMonitor(this.parent, "Creating Deformation");
                this.deformProgressMonitor.setLocationRelativeTo(this);
                this.deformProgressMonitor.setVisible(true);
                this.deformProgressMonitor.setCancelCallback(new Runnable(){

                    @Override
                    public void run() {
                        PropRunPanel.this.cancelModels();
                    }
                });
            }
        }
    }

    public void cancelModels() {
        if (this.propRunner != null) {
            this.propRunner.stop();
        }
    }

    public void stickToLastFrame(boolean b) {
        this.lastFrameRequested = b;
    }

    public int getTimeStep() {
        return this.step;
    }

    public void setTimeStep(int tt2) {
        if (tt2 > this.getTimeStepCount()) {
            tt2 = this.getTimeStepCount();
        }
        if (tt2 < 1) {
            tt2 = 1;
        }
        if (tt2 != this.step) {
            int oldts = this.step;
            this.step = tt2;
            if (!this.animSlider.getValueIsAdjusting()) {
                this.ignoreEvents = true;
                this.animSlider.setValue(tt2);
                this.ignoreEvents = false;
            }
            this.firePropertyChange("timeStep", oldts, this.step);
        }
        this.requestFocusInWindow();
    }

    public void stopAnimation() {
        this.runStopButton.setIcon(runIcon);
        this.animationTimer.stop();
    }

    public int getTimeStepCount() {
        return this.propAnimPanel != null && this.propAnimPanel.getMostGrid() != null ? this.propAnimPanel.getMostGrid().getNumberOfTimeSteps() : 0;
    }

    public void updateProgressBar(boolean running) {
        int curts = this.propInfo.getTimestepsAvailable();
        int maxts = this.propInfo.getNumberOutputTimesteps();
        if (curts > 1 && this.deformProgressMonitor != null) {
            this.deformProgressMonitor.closeMe();
        }
        String state = "running";
        if (!running) {
            state = curts == maxts ? "finished" : "stopped";
        }
        this.modelProgressBar.setString(String.format("%s %s: step %d of %d", this.propInfo.getName(), state, curts, maxts));
        this.modelProgressBar.setValue(curts);
        this.modelProgressBar.setMaximum(maxts);
    }

    @Override
    public void modelStarted(final ModelEvent me) {
        CMIUtil.runOnDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (me.getSourceModel().equals(PropRunPanel.this.propInfo)) {
                    PropRunPanel.this.stopAnimation();
                    PropRunPanel.this.lastFrameRequested = true;
                    PropRunPanel.this.propAnimPanel.modelStarted(me);
                    PropRunPanel.this.startStopButton.setText("Stop Propagation");
                    PropRunPanel.this.enableTextFields(false);
                    PropRunPanel.this.updateProgressBar(true);
                }
            }
        });
    }

    @Override
    public void modelStopped(final ModelEvent me) {
        CMIUtil.runOnDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (me.getSourceModel().equals(PropRunPanel.this.propInfo)) {
                    PropRunPanel.this.propAnimPanel.modelStopped(me);
                    PropRunPanel.this.lastFrameRequested = false;
                    PropRunPanel.this.startStopButton.setText("Start Propagation");
                    PropRunPanel.this.modelProgressBar.setAnimating(false);
                    PropRunPanel.this.enableTextFields(true);
                    if (PropRunPanel.this.defGrid != null) {
                        PropRunPanel.this.enableSeismicFields(false);
                    }
                    if (PropRunPanel.this.deformProgressMonitor != null) {
                        PropRunPanel.this.deformProgressMonitor.closeMe();
                        PropRunPanel.this.deformProgressMonitor = null;
                    }
                    PropRunPanel.this.updateProgressBar(false);
                    if (me.getStatus() == 201) {
                        JOptionPane.showMessageDialog(PropRunPanel.this.propAnimPanel, me.getLogText(), "MOST Error", 0);
                    }
                }
            }
        });
    }

    @Override
    public void modelUpdate(final ModelEvent me) {
        CMIUtil.runOnDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (me.getStatus() == 101 && me.getTimesteps() > 0 && me.getSourceModel().equals(PropRunPanel.this.propInfo)) {
                    SiftShare.log.info("new model ts: " + me.getTimesteps() + " ts " + PropRunPanel.this.getTimeStep() + " ts count " + PropRunPanel.this.getTimeStepCount() + "  lfr " + PropRunPanel.this.lastFrameRequested);
                    PropRunPanel.this.propAnimPanel.modelUpdate(me);
                    PropRunPanel.this.setSliderMaxAndSpacing();
                    PropRunPanel.this.modelProgressBar.setAnimating(true);
                    PropRunPanel.this.updateProgressBar(true);
                    if (PropRunPanel.this.lastFrameRequested && me.getTimesteps() > 0) {
                        PropRunPanel.this.setTimeStep(me.getTimesteps());
                    }
                }
            }
        });
    }

    private void addFocusListeners() {
        this.sourceComboBox.addFocusListener(this);
        this.maxRadioButton.addFocusListener(this);
        this.deleteButton.addFocusListener(this);
        ((JSpinner.DefaultEditor)this.rowSpinner.getEditor()).getTextField().addFocusListener(this);
        ((JSpinner.DefaultEditor)this.colSpinner.getEditor()).getTextField().addFocusListener(this);
        this.bathyComboBox.addFocusListener(this);
        this.customDefButton.addFocusListener(this);
        this.epLatTextField.addFocusListener(this);
        this.epLonTextField.addFocusListener(this);
        this.faultLengthTextField.addFocusListener(this);
        this.faultWidthTextField.addFocusListener(this);
        this.faultDepthTextField.addFocusListener(this);
        this.slipTextField.addFocusListener(this);
        this.dipTextField.addFocusListener(this);
        this.rakeTextField.addFocusListener(this);
        this.strikeTextField.addFocusListener(this);
        this.minDepthTextField.addFocusListener(this);
        this.timeStepTextField.addFocusListener(this);
        this.numStepsTextField.addFocusListener(this);
        this.skipGridTextField.addFocusListener(this);
        this.skipStepsTextField.addFocusListener(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.stopAnimation();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("animStep")) {
            if (this.animationTimer.isRunning()) {
                int newts = this.getTimeStep() + 1;
                if (newts >= this.getTimeStepCount()) {
                    newts = 0;
                }
                this.setTimeStep(newts);
            }
        } else if (e.getActionCommand().equals("epicenter")) {
            Point2D.Double pt = this.propAnimPanel.getEpicenter();
            if (this.propInfo.getEpLon() != pt.x || this.propInfo.getEpLat() != pt.y) {
                if (this.askClearResults(this.propInfo)) {
                    this.propInfo.setEpLon(pt.x);
                    this.propInfo.setEpLat(pt.y);
                    this.propInfo.clearResults();
                    this.propInfo.writeDotIn();
                    this.propAnimPanel.setPropInfo(this.propInfo);
                } else {
                    this.propAnimPanel.setEpicenter(this.propInfo.getEpLon(), this.propInfo.getEpLat());
                }
            }
            this.updateTextFields();
        }
    }

    public static void main(String[] args) {
        Preferences preferences = Preferences.userNodeForPackage(SiftShare.class);
        CMIUtil.MOSTProp_EXEC = "/Volumes/big/cmoore/ComMIT/bin/most_db_mac_r3187";
        preferences.put("MOSTProp_EXEC", CMIUtil.MOSTProp_EXEC);
        CMIUtil.gridsDirName = preferences.get("DATADIR", CMIUtil.baseDirName + File.separator + "grids");
        CMIUtil.propDirName = preferences.get("PROPDIR", CMIUtil.baseDirName + File.separator + "prop");
        JFrame propRunFrame = new JFrame();
        PropRunPanel propRunPanel = new PropRunPanel(propRunFrame);
        propRunFrame.getContentPane().add(propRunPanel);
        propRunFrame.setSize(1118, 1010);
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        propRunFrame.addWindowListener(l);
        propRunFrame.setVisible(true);
    }

    static {
        intformat = NumberFormat.getIntegerInstance();
        runIcon = new ImageIcon(PropRunPanel.class.getResource("images/Play16.gif"));
        stopIcon = new ImageIcon(PropRunPanel.class.getResource("images/Stop16.gif"));
    }

    protected class LeftStepAction
    extends AbstractAction {
        protected LeftStepAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            PropRunPanel.this.stickToLastFrame(false);
            PropRunPanel.this.setTimeStep(PropRunPanel.this.getTimeStep() - 1);
        }
    }

    protected class RightStepAction
    extends AbstractAction {
        protected RightStepAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            PropRunPanel.this.stickToLastFrame(false);
            PropRunPanel.this.setTimeStep(PropRunPanel.this.getTimeStep() + 1);
        }
    }

    private static class downloadGridsWorker
    implements Runnable {
        HashMap<String, URL> gridURLS;
        SiftShare parent;
        Runnable callBack;

        public downloadGridsWorker(HashMap<String, URL> hm, SiftShare s, Runnable cb) {
            this.gridURLS = hm;
            this.parent = s;
            this.callBack = cb;
        }

        @Override
        public void run() {
            int gridNum = 0;
            boolean can = false;
            for (Map.Entry<String, URL> e : this.gridURLS.entrySet()) {
                ++gridNum;
                File file = new File(CMIUtil.gridsDirName, e.getKey());
                if (file.isFile() || can) continue;
                SiftShare.log.fine("Downloading Prop grid file: " + e.getKey());
                FileOutputStream out = null;
                GZIPInputStream is = null;
                try {
                    int c;
                    File tmpFile = File.createTempFile("propBath", null, new File(CMIUtil.gridsDirName));
                    tmpFile.deleteOnExit();
                    HttpURLConnection con = (HttpURLConnection)new URL(CMIUtil.commitServerAddress + "/download/" + e.getKey()).openConnection();
                    con.setConnectTimeout(10000);
                    con.setReadTimeout(10000);
                    con.connect();
                    int contentLength = con.getContentLength();
                    if (contentLength < 1) {
                        throw new IOException("Can't find contentLength downloading prop bathy");
                    }
                    con = (HttpURLConnection)e.getValue().openConnection();
                    con.setConnectTimeout(10000);
                    con.setReadTimeout(10000);
                    out = new FileOutputStream(tmpFile);
                    ProgressMonitor pm = new ProgressMonitor(this.parent, "Downloading Propagation Grids", "Grid: " + gridNum + " of " + this.gridURLS.size(), 0, contentLength);
                    SiftShare.log.fine("downloading grid: " + gridNum + " size: " + contentLength);
                    is = new GZIPInputStream(con.getInputStream());
                    int nread = 0;
                    byte[] buffer = new byte[1024];
                    while ((c = ((InputStream)is).read(buffer)) != -1) {
                        if (c > 0) {
                            pm.setProgress(nread += c);
                        }
                        if (pm.isCanceled()) {
                            ((InputStream)is).close();
                            out.close();
                            tmpFile.delete();
                            can = true;
                            break;
                        }
                        out.write(buffer, 0, c);
                    }
                    ((InputStream)is).close();
                    out.close();
                    if (can) continue;
                    file.delete();
                    tmpFile.renameTo(file);
                }
                catch (IOException ioe) {
                    SiftShare.log.log(Level.SEVERE, "Can't download prop bathy grids", ioe);
                }
            }
            if (this.callBack != null) {
                SwingUtilities.invokeLater(this.callBack);
            }
        }
    }
}

