/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.ModelEvent;
import gov.noaa.tsunami.cmi.ModelListener;
import gov.noaa.tsunami.cmi.PropInfo;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.StreamGobbler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropRunner
implements Runnable {
    private final PropInfo runningSite;
    private final Iterable<ModelListener> listeners;
    private Process mostProc;
    private Thread mythread;
    private boolean modelCancelled = false;
    public static final int POLLING_RATE = 500;
    public static final String TERM_FILENAME = "shootmenow";
    private StreamGobbler mostErrorGobbler;
    private StreamGobbler mostOutputGobbler;

    public PropRunner(PropInfo site, Iterable<ModelListener> listeners) {
        this.runningSite = site;
        this.listeners = listeners != null ? listeners : Collections.emptyList();
    }

    public Thread start() {
        this.mythread = new Thread((Runnable)this, this.getClass().getSimpleName() + ": " + this.runningSite.getName());
        this.mythread.start();
        return this.mythread;
    }

    protected void notifyModelUpdate(ModelEvent event) {
        for (ModelListener ml : this.listeners) {
            ml.modelUpdate(event);
        }
    }

    protected void notifyModelStart(ModelEvent event) {
        for (ModelListener ml : this.listeners) {
            ml.modelStarted(event);
        }
    }

    protected void notifyModelStop(ModelEvent event) {
        for (ModelListener ml : this.listeners) {
            ml.modelStopped(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ModelEvent startEv = new ModelEvent(this.runningSite, 100);
        startEv.setLogText(String.format("Starting prop model %s\n", this.runningSite.getName()));
        this.notifyModelStart(startEv);
        BufferedReader br = null;
        PrintWriter pw = null;
        try {
            String line;
            SiftShare.log.entering("PropRunner", "run");
            ModelEvent ev = new ModelEvent(this.runningSite, 100);
            ev.setMessage("Launching MOST Propagation\n");
            ev.setLogText("Launching MOST Propagation\n");
            this.notifyModelUpdate(ev);
            Runtime rt = Runtime.getRuntime();
            SiftShare.log.log(Level.INFO, "Starting MOST Prop for {0} using {1} in directory {2}", new Object[]{this.runningSite.getName(), CMIUtil.MOSTProp_EXEC, CMIUtil.propDirName});
            this.mostProc = rt.exec(CMIUtil.MOSTProp_EXEC, this.setupEnvironment(CMIUtil.MOSTProp_EXEC), new File(CMIUtil.propDirName));
            this.mostErrorGobbler = new StreamGobbler(this.mostProc.getErrorStream(), "MOSTERR");
            this.mostErrorGobbler.start();
            this.mostOutputGobbler = new StreamGobbler(this.mostProc.getInputStream(), "MOSTOUT", new FileOutputStream(new File(this.runningSite.getMostDotOut())));
            this.mostOutputGobbler.start();
            br = new BufferedReader(new FileReader(this.runningSite.getMostDotIn()));
            pw = new PrintWriter(this.mostProc.getOutputStream());
            while ((line = br.readLine()) != null) {
                pw.println(line);
                pw.flush();
            }
        }
        catch (IOException ex) {
            String msg = "Error starting MOST: " + ex.getMessage();
            ModelEvent errev = new ModelEvent(this.runningSite, 201, this.runningSite.getTimestepsAvailable());
            SiftShare.log.log(Level.SEVERE, msg, ex);
            errev.setLogText(msg);
            errev.setMessage(msg);
            this.notifyModelStop(errev);
            return;
        }
        finally {
            if (br != null && pw != null) {
                try {
                    br.close();
                    pw.close();
                }
                catch (IOException iOException) {}
            }
        }
        MostResultMonitor resultMonitor = new MostResultMonitor();
        Timer resultTimer = new Timer(resultMonitor.getClass().getSimpleName() + ": " + this.runningSite.getName(), true);
        resultTimer.schedule((TimerTask)resultMonitor, 0L, 500L);
        try {
            this.mostProc.waitFor();
        }
        catch (InterruptedException ex) {
            this.modelCancelled = true;
        }
        int exitval = this.mostProc.exitValue();
        SiftShare.log.info("Model stopped, exit value: " + exitval);
        this.mostProc = null;
        resultMonitor.run();
        resultTimer.cancel();
        this.mostErrorGobbler.requestStop();
        this.mostOutputGobbler.requestStop();
        ModelEvent stopev = new ModelEvent(this.runningSite, 200, this.runningSite.getTimestepsAvailable());
        String logtxt = resultMonitor.checkOutputLog();
        String exittxt = "";
        switch (exitval) {
            case 0: {
                exittxt = "\nModel completed normally.\n";
                stopev.status = 200;
            }
            case 1: {
                exittxt = "\nModel run cancelled normally.\n";
                stopev.status = 200;
                break;
            }
            case 2: {
                exittxt = "\nModel caught TERM signal.\n";
                stopev.status = 200;
                break;
            }
            case 3: {
                exittxt = "\nError parsing model input file.\n";
                stopev.status = 202;
                break;
            }
            case 4: {
                exittxt = "\nError reading bathymetry file.\n";
                stopev.status = 201;
                break;
            }
            case 5: {
                exittxt = "\nError creating deformation.\n";
                stopev.status = 201;
                break;
            }
            case 6: {
                exittxt = "\nError reading netcdf restart file.\n";
                stopev.status = 201;
                break;
            }
            case 7: {
                exittxt = "\nError initializing netcdf output files.\n";
                stopev.status = 201;
                break;
            }
            case 8: {
                exittxt = "\nError writing to netcdf output files.\n";
                stopev.status = 201;
                break;
            }
        }
        logtxt = (logtxt != null ? logtxt : exittxt) + String.format("Model %s ended.\n", this.runningSite.getName());
        stopev.setLogText(logtxt);
        if (resultMonitor.errorMessage != null) {
            stopev.status = 201;
            stopev.setMessage(resultMonitor.errorMessage);
        } else if (this.modelCancelled) {
            stopev.status = 202;
        }
        this.notifyModelStop(stopev);
        SiftShare.log.exiting("ModelRunner", "run");
    }

    public void stop() {
        this.modelCancelled = true;
        OutputStreamWriter fw = null;
        try {
            fw = new FileWriter(new File(CMIUtil.propDirName, TERM_FILENAME));
            fw.write("now");
        }
        catch (Exception e) {
            SiftShare.log.log(Level.WARNING, "error writing shootmenow file", e);
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
                System.gc();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isRunning() {
        return this.mythread != null && this.mythread.isAlive();
    }

    public PropInfo getModelInfo() {
        return this.runningSite;
    }

    private String[] setupEnvironment(String mostexec) {
        SiftShare.log.info("os.name: " + System.getProperty("os.name"));
        if (System.getProperty("os.name").startsWith("Mac OS")) {
            return new String[]{"DYLD_LIBRARY_PATH=" + new File(mostexec).getParent()};
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("linux")) {
            return new String[]{"LD_LIBRARY_PATH=/usr/local/netcdf/lib"};
        }
        return new String[0];
    }

    private class MostResultMonitor
    extends TimerTask {
        private int lastTsCount = 0;
        private FileReader logReader = null;
        private final Pattern errp = Pattern.compile("^.*(error\\W.*)$", 10);
        public String errorMessage = null;

        @Override
        public void run() {
            if (((PropRunner)PropRunner.this).mostErrorGobbler.outputOccurred) {
                ModelEvent evt = new ModelEvent(PropRunner.this.runningSite, 201, PropRunner.this.runningSite.getTimestepsAvailable());
                evt.setMessage(String.format("MOST error: %s\n", ((PropRunner)PropRunner.this).mostErrorGobbler.errorString));
                evt.setLogText(String.format("MOST error: %s\n", ((PropRunner)PropRunner.this).mostErrorGobbler.errorString));
                SiftShare.log.log(Level.SEVERE, "MOST error: " + ((PropRunner)PropRunner.this).mostErrorGobbler.errorString);
                PropRunner.this.notifyModelStop(evt);
            }
            String logtext = this.checkOutputLog();
            int tsCount = PropRunner.this.runningSite.getTimestepsAvailable();
            if (tsCount != this.lastTsCount || logtext != null) {
                ModelEvent evt = new ModelEvent(PropRunner.this.runningSite, 101, tsCount);
                evt.setMessage(String.format("%s running: output step %d of %d", evt.getSourceModel().getName(), evt.getTimesteps(), evt.getSourceModel().getNumberOutputTimesteps()));
                if (logtext != null) {
                    evt.setLogText(logtext);
                }
                PropRunner.this.notifyModelUpdate(evt);
                this.lastTsCount = tsCount;
            }
        }

        public String checkOutputLog() {
            String logText = null;
            try {
                if (this.logReader == null) {
                    File logf = new File(CMIUtil.propDirName, PropRunner.this.runningSite.getMostDotOut());
                    if (logf.exists()) {
                        this.logReader = new FileReader(logf);
                    } else {
                        return null;
                    }
                }
                if (!this.logReader.ready()) {
                    return null;
                }
                StringBuilder readBuf = new StringBuilder(1024);
                char[] inBuf = new char[1024];
                while (this.logReader.ready()) {
                    int chread = this.logReader.read(inBuf);
                    readBuf.append(inBuf, 0, chread);
                }
                if (readBuf.length() <= 0) {
                    return null;
                }
                logText = readBuf.toString();
                Matcher errm = this.errp.matcher(logText);
                if (errm.find()) {
                    this.errorMessage = errm.group(1);
                }
            }
            catch (IOException ioe) {
                SiftShare.log.log(Level.WARNING, "error", ioe);
            }
            return logText;
        }
    }
}

