/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.spi.wizard.DeferredWizardResult;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Summary;

class Result
extends DeferredWizardResult {
    DecimalFormat dfxxxx = new DecimalFormat("0.0000");

    public Result() {
        super(true);
    }

    @Override
    public void start(Map settings, ResultProgressHandle progress) {
        SiteInfo newSite;
        StringBuffer urlsb;
        String aGridFilename = ((StringBuffer)settings.get("A grid filename")).toString();
        String bGridFilename = ((StringBuffer)settings.get("B grid filename")).toString();
        String cGridFilename = ((StringBuffer)settings.get("C grid filename")).toString();
        String siteName = (String)settings.get("model run name");
        HashMap<String, String> gridNamesHash = new HashMap<String, String>();
        if (!new File(aGridFilename).exists()) {
            urlsb = new StringBuffer(CMIUtil.commitServerAddress + "/bathymetry/create.most?");
            urlsb.append("xmin=" + settings.get("A grid west extent"));
            urlsb.append("&xmax=" + settings.get("A grid east extent"));
            urlsb.append("&ymin=" + settings.get("A grid south extent"));
            urlsb.append("&ymax=" + settings.get("A grid north extent"));
            urlsb.append("&cellsize=" + settings.get("A grid resolution") + "s");
            gridNamesHash.put(aGridFilename, urlsb.toString());
        }
        if (!new File(bGridFilename).exists()) {
            urlsb = new StringBuffer(CMIUtil.commitServerAddress + "/bathymetry/create.most?");
            urlsb.append("xmin=" + settings.get("B grid west extent"));
            urlsb.append("&xmax=" + settings.get("B grid east extent"));
            urlsb.append("&ymin=" + settings.get("B grid south extent"));
            urlsb.append("&ymax=" + settings.get("B grid north extent"));
            urlsb.append("&cellsize=" + settings.get("B grid resolution") + "s");
            gridNamesHash.put(bGridFilename, urlsb.toString());
        }
        if (!new File(cGridFilename).exists()) {
            urlsb = new StringBuffer(CMIUtil.commitServerAddress + "/bathymetry/create.most?");
            urlsb.append("xmin=" + settings.get("C grid west extent"));
            urlsb.append("&xmax=" + settings.get("C grid east extent"));
            urlsb.append("&ymin=" + settings.get("C grid south extent"));
            urlsb.append("&ymax=" + settings.get("C grid north extent"));
            urlsb.append("&cellsize=" + settings.get("C grid resolution") + "s");
            gridNamesHash.put(cGridFilename, urlsb.toString());
        }
        try {
            int i = 1;
            for (String grid : gridNamesHash.keySet()) {
                this.downloadGrid(grid, (String)gridNamesHash.get(grid), progress, i, gridNamesHash.size());
                ++i;
            }
            progress.setBusy("Creating Model Directory");
            String[] gridNames = new String[]{aGridFilename, bGridFilename, cGridFilename};
            newSite = SiteInfo.createNewSite(siteName, new File(CMIUtil.workingDirName), gridNames);
        }
        catch (IOException ex) {
            progress.failed("Failed to create new Model: " + ex.getMessage(), true);
            return;
        }
        String[] items = new String[]{"Successfully created Model, named: " + settings.get("model run name"), "Close this wizard to continue..."};
        progress.finished(Summary.create(items, (Object)newSite));
    }

    public void downloadGrid(String filename, String urlString, ResultProgressHandle progress, int num, int total) throws IOException {
        SiftShare.log.info("downloading grid, URL: " + urlString);
        URL url = new URL(urlString);
        HttpURLConnection con = null;
        int responseCode = 202;
        int percent = 0;
        int begin = 100 * (num - 1) / total;
        int end = 100 * num / total;
        File downloadGridFile = new File(filename);
        progress.setBusy("Contacting ComMIT Server");
        con = (HttpURLConnection)url.openConnection();
        con.setConnectTimeout(0);
        con.setReadTimeout(0);
        responseCode = con.getResponseCode();
        while (responseCode == 202) {
            InputStream is = con.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String inputLine = br.readLine();
            SiftShare.log.info(inputLine);
            String[] inputArray = inputLine.split("\\s+");
            try {
                percent = Integer.parseInt(inputArray[0]);
                if (percent > 0 && begin + percent <= 100) {
                    progress.setProgress("Creating " + num + " of " + total + ": " + percent + " % done", begin + percent, 100);
                } else {
                    SiftShare.log.info("New Model Wizard getting bad progress values from ComMITServer");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            br.close();
            if (Thread.interrupted()) {
                SiftShare.log.info("New Model Wizard interrupted creating grid on server.");
                return;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            con = (HttpURLConnection)url.openConnection();
            responseCode = con.getResponseCode();
        }
        if (responseCode == 200) {
            int c;
            int len = con.getContentLength();
            if (len == -1) {
                len = 10000;
            }
            InputStream is = con.getInputStream();
            FileOutputStream out = new FileOutputStream(downloadGridFile);
            int nread = 0;
            byte[] buf = new byte[1024];
            while ((c = is.read(buf)) != -1) {
                if (c > 0 && (nread += c) <= len) {
                    progress.setProgress("Downloading " + num + " of " + total, nread, len);
                }
                if (Thread.interrupted()) {
                    SiftShare.log.info("New Model Wizard interrupted downloading grid.");
                    is.close();
                    out.close();
                    downloadGridFile.delete();
                    return;
                }
                out.write(buf, 0, c);
            }
            is.close();
            out.close();
        }
    }
}

