/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.LatitudeAxis;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerChild;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.LongitudeAxis;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.dm.SimpleLine;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.tsunami.cmi.AbstractGridTool;
import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.ColorBar;
import gov.noaa.tsunami.cmi.ColorMaps;
import gov.noaa.tsunami.cmi.EnumeratedColorMap;
import gov.noaa.tsunami.cmi.GridSelectorPanel;
import gov.noaa.tsunami.cmi.ModelEvent;
import gov.noaa.tsunami.cmi.ModelListener;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public abstract class ResultGraphicsPanel
extends JPanel
implements PropertyChangeListener,
ChangeListener,
ModelListener {
    private GridSelectorPanel gridSelector = null;
    private SiteInfo currentSite = null;
    private boolean updateRequired = false;
    private final JPane jPane;
    protected final Map<String, Layer> layers = new LinkedHashMap<String, Layer>();
    private final LinearTransform xt;
    private final LinearTransform yt;
    protected final SGLabel titleLabel;
    private final LatitudeAxis yAxis = new LatitudeAxis();
    private final LatitudeAxis yAxisRight = new LatitudeAxis();
    private final LongitudeAxis xAxis = new LongitudeAxis();
    private final LongitudeAxis xAxisTop = new LongitudeAxis();
    protected ColorBar colorBar = null;
    public static final double marginLeft = 0.5;
    public static final double marginRight = 0.3;
    public static final double marginTop = 0.7;
    public static final double marginBottom = 0.55;
    protected double xSize = 8.0;
    protected double xMin = 0.5;
    protected double xMax = 7.7;
    protected double ySize = 6.0;
    protected double yMin = 0.55;
    protected double yMax = 5.3;
    public static final Font AXIS_FONT = new Font("SansSerif", 0, 12);
    public static final double AXIS_LABEL_PHEIGHT = 0.16;
    protected static final double CONTOUR_LABEL_PHEIGHT = 0.15;
    public static final Font CONTOUR_LABEL_FONT = new Font("SansSerif", 0, 14);
    protected static int MAX_GRID_DISPLAY_SIZE = 20;
    protected int extremum = 1;
    protected static final EnumeratedColorMap cmap = ColorMaps.createRedBlueMap();
    protected static final GridAttribute ga = new GridAttribute(0, cmap);
    private SoTRange xZoomRange;
    private SoTRange yZoomRange;

    public ResultGraphicsPanel() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.jPane = new JPane(this.getClass().getName(), new Dimension(800, 600));
        this.jPane.setOpaque(true);
        this.jPane.setLayout(new StackedLayout());
        this.xZoomRange = new SoTRange.Double(10.0, 20.0, 1.0);
        this.yZoomRange = new SoTRange.Double(40.0, 80.0, 2.0);
        SoTPoint origin = new SoTPoint(this.xZoomRange.getStart(), this.yZoomRange.getStart());
        this.xt = new LinearTransform(new Range2D(this.xMin, this.xMax), this.xZoomRange);
        this.yt = new LinearTransform(new Range2D(this.yMin, this.yMax), this.yZoomRange);
        this.add((Component)this.jPane, "Center");
        this.jPane.addMouseListener(new MyMouseAdapter(this));
        this.jPane.addPropertyChangeListener(this);
        this.titleLabel = new SGLabel("title", "test", 0.22, new Point2D.Double(this.xSize / 2.0, this.ySize - 0.16), 1, 1);
        this.addLabel(this.titleLabel);
        CartesianGraph axgraph = this.getCartesianGraph("base");
        this.xAxis.setRangeU(this.xZoomRange);
        this.xAxis.setLocationU(origin);
        this.xAxis.setLabelHeightP(0.16);
        this.xAxis.setLabelFont(AXIS_FONT);
        this.xAxis.setSignificantDigits(3);
        this.xAxisTop.setRangeU(this.xZoomRange);
        this.xAxisTop.setTicPosition(1);
        this.xAxisTop.setLocationU(new SoTPoint(this.xZoomRange.getStart(), this.yZoomRange.getEnd()));
        this.xAxisTop.setLabelPosition(2);
        this.xAxis.register(this.xAxisTop);
        this.yAxis.setRangeU(this.yZoomRange);
        this.yAxis.setLocationU(origin);
        this.yAxis.setLabelHeightP(0.16);
        this.yAxis.setLabelFont(AXIS_FONT);
        this.yAxis.setSignificantDigits(3);
        this.yAxisRight.setRangeU(this.yZoomRange);
        this.yAxisRight.setLocationU(new SoTPoint(this.xZoomRange.getEnd(), this.yZoomRange.getStart()));
        this.yAxisRight.setTicPosition(1);
        this.yAxisRight.setLabelPosition(2);
        this.yAxis.register(this.yAxisRight);
        axgraph.addXAxis(this.xAxis);
        axgraph.addXAxis(this.xAxisTop);
        axgraph.addYAxis(this.yAxis);
        axgraph.addYAxis(this.yAxisRight);
    }

    public static void setMaxGridDisplaySize(int ds) {
        switch (ds) {
            case 0: {
                MAX_GRID_DISPLAY_SIZE = 200;
                break;
            }
            case 1: {
                MAX_GRID_DISPLAY_SIZE = 350;
                break;
            }
            case 2: {
                MAX_GRID_DISPLAY_SIZE = 500;
                break;
            }
            case 3: {
                MAX_GRID_DISPLAY_SIZE = 20000;
                break;
            }
            default: {
                MAX_GRID_DISPLAY_SIZE = 350;
            }
        }
    }

    public JPane getPane() {
        return this.jPane;
    }

    protected final void addLabel(SGLabel lbl) {
        this.getLayer("base").addChild(lbl);
    }

    public void setTitle(String s) {
        this.titleLabel.setText(s);
    }

    protected Layer getLayer(String layerName) {
        Layer lyr = this.layers.get(layerName);
        if (lyr != null) {
            return lyr;
        }
        lyr = new Layer(layerName, new Dimension2D(this.xSize, this.ySize));
        this.layers.put(layerName, lyr);
        this.jPane.add((Component)lyr, this.layers.size());
        this.updateRequired = true;
        CartesianGraph graph = new CartesianGraph(layerName + " graph");
        graph.setXTransform(this.xt);
        graph.setYTransform(this.yt);
        lyr.setGraph(graph);
        return lyr;
    }

    protected final CartesianGraph getCartesianGraph(String layerName) {
        Layer lyr = this.getLayer(layerName);
        return (CartesianGraph)lyr.getGraph();
    }

    public void clearData() {
        for (String lyrname : this.layers.keySet()) {
            this.getCartesianGraph(lyrname).setRenderer(null);
        }
        for (LayerChild o : this.getLayer("base").getChildren()) {
            if (!(o instanceof SGLabel)) continue;
            SGLabel lbl = (SGLabel)o;
            lbl.setText("");
        }
    }

    public Rectangle getImageAxesCornersPixels() {
        Rectangle clip = new Rectangle();
        CartesianGraph graph = this.getCartesianGraph("base");
        Layer layer = this.getLayer("base");
        Range2D xRange = this.xAxis.getRangeU();
        Range2D yRange = this.yAxis.getRangeU();
        clip.x = layer.getXPtoD(graph.getXUtoP(xRange.start));
        clip.y = layer.getYPtoD(graph.getYUtoP(yRange.end));
        clip.width = layer.getXPtoD(graph.getXUtoP(xRange.end)) - clip.x;
        clip.height = layer.getYPtoD(graph.getYUtoP(yRange.start)) - clip.y;
        SiftShare.log.fine("crop image coords: " + clip);
        return clip;
    }

    public Rectangle2D.Double getImageCornersLatLon() {
        int width = this.jPane.getWidth();
        int height = this.jPane.getHeight();
        if (this.colorBar != null) {
            width += this.colorBar.getWidth();
        }
        CartesianGraph graph = this.getCartesianGraph("base");
        Layer layer = this.getLayer("base");
        double minLon = graph.getXPtoU(layer.getXDtoP(width));
        double minLat = graph.getYPtoU(layer.getYDtoP(height));
        double maxLon = graph.getXPtoU(layer.getXDtoP(0));
        double maxLat = graph.getYPtoU(layer.getYDtoP(0));
        if (minLon > 180.0) {
            minLon -= 360.0;
        }
        if (maxLon > 180.0) {
            maxLon -= 360.0;
        }
        SiftShare.log.fine("minLon: " + minLon + " maxLon: " + maxLon + " minLat: " + minLat + " maxLat: " + maxLat);
        return new Rectangle2D.Double(minLon, maxLat, maxLon - minLon, maxLat - minLat);
    }

    public Rectangle2D.Double getColorbarImageCornersLatLon() {
        if (this.colorBar == null) {
            return null;
        }
        int width = this.colorBar.getWidth();
        int height = this.colorBar.getHeight();
        CartesianGraph graph = this.getCartesianGraph("base");
        Layer layer = this.getLayer("base");
        double minLon = graph.getXPtoU(layer.getXDtoP(width));
        double minLat = graph.getYPtoU(layer.getYDtoP(height));
        double maxLon = graph.getXPtoU(layer.getXDtoP(0));
        double maxLat = graph.getYPtoU(layer.getYDtoP(0));
        if (minLon > 180.0) {
            minLon -= 360.0;
        }
        if (maxLon > 180.0) {
            maxLon -= 360.0;
        }
        SiftShare.log.fine("Colorbar minLon: " + minLon + " maxLon: " + maxLon + " minLat: " + minLat + " maxLat: " + maxLat);
        return new Rectangle2D.Double(minLon, maxLat, maxLon - minLon, maxLat - minLat);
    }

    protected void setAxes(SGTGrid grid) {
        double yPlotSize;
        double xPlotSize;
        SoTPoint origin = new SoTPoint(grid.getXRange().getStart(), grid.getYRange().getStart());
        this.xZoomRange = grid.getXRange();
        this.yZoomRange = grid.getYRange();
        this.xAxis.setRangeU(grid.getXRange());
        this.xAxis.setLocationU(origin);
        this.xAxisTop.setLocationU(new SoTPoint(origin.getX(), grid.getYRange().getEnd()));
        this.yAxis.setRangeU(grid.getYRange());
        this.yAxis.setLocationU(origin);
        this.yAxisRight.setLocationU(new SoTPoint(grid.getXRange().getEnd(), origin.getY()));
        SoTRange xr = grid.getXRange();
        SoTRange yr = grid.getYRange();
        double lons = xr.getStart().getDouble();
        double lone = xr.getEnd().getDouble();
        double lats = yr.getStart().getDouble();
        double late = yr.getEnd().getDouble();
        double xext = Math.abs(lons - lone) * 111320.0 * Math.cos(Math.abs(late + lats) / 2.0 * Math.PI / 180.0);
        double yext = Math.abs(lats - late) * 111320.0;
        if (xext > yext) {
            xPlotSize = 8.0;
            yPlotSize = 8.0 * yext / xext;
        } else {
            yPlotSize = 8.0;
            xPlotSize = 8.0 * xext / yext;
        }
        this.xSize = xPlotSize + 0.5 + 0.3;
        this.ySize = yPlotSize + 0.7 + 0.55;
        this.xMin = 0.5;
        this.xMax = xPlotSize + 0.5;
        this.yMin = 0.55;
        this.yMax = yPlotSize + 0.55;
        for (String key : this.layers.keySet()) {
            this.layers.get(key).setSizeP(new Dimension2D(this.xSize, this.ySize));
        }
        this.xt.setRangeP(this.xMin, this.xMax);
        this.yt.setRangeP(this.yMin, this.yMax);
        this.xt.setRangeU(grid.getXRange());
        this.yt.setRangeU(grid.getYRange());
        this.titleLabel.setLocationP(new Point2D.Double(this.xSize / 2.0, this.ySize - 0.16));
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        if ("zoomRectangle".equals(name)) {
            SiftShare parentss;
            double temp;
            Range2D xr = new Range2D();
            Range2D yr = new Range2D();
            Rectangle zm = (Rectangle)event.getNewValue();
            CartesianGraph graph = this.getCartesianGraph("base");
            Layer layer = this.getLayer("base");
            if (zm.width <= 1 || zm.height <= 1) {
                return;
            }
            xr.start = graph.getXPtoU(layer.getXDtoP(zm.x));
            xr.end = graph.getXPtoU(layer.getXDtoP(zm.x + zm.width));
            if (xr.start > xr.end) {
                temp = xr.start;
                xr.start = xr.end;
                xr.end = temp;
            }
            yr.start = graph.getYPtoU(layer.getYDtoP(zm.y));
            yr.end = graph.getYPtoU(layer.getYDtoP(zm.y + zm.height));
            if (yr.start > yr.end) {
                temp = yr.start;
                yr.start = yr.end;
                yr.end = temp;
            }
            if ((parentss = (SiftShare)SwingUtilities.getAncestorOfClass(SiftShare.class, this)) != null) {
                AbstractGridTool gt = parentss.getCurrentGridTool();
                if (gt != null && gt.isVisible()) {
                    Point2D.Double[] r = new Point2D.Double[]{new Point2D.Double(xr.start, yr.start), new Point2D.Double(xr.end, yr.start), new Point2D.Double(xr.end, yr.end), new Point2D.Double(xr.start, yr.end)};
                    if (this.gridSelector != null) {
                        gt.setSelectedExtent(this.gridSelector.getSelectedGrid(), r);
                    }
                } else {
                    this.setZoom(xr, yr);
                }
            } else {
                this.setZoom(xr, yr);
            }
        } else if (event.getSource() == this.gridSelector && "selectedGrid".equals(name)) {
            this.updateResults();
            this.resetZoom();
        } else if ("currentSite".equals(name)) {
            SiteInfo si = (SiteInfo)event.getNewValue();
            SiteInfo oldsi = (SiteInfo)event.getOldValue();
            if (oldsi != null) {
                oldsi.removePropertyChangeListener(this);
            }
            this.setCurrentSite(si);
            this.updateResults();
            this.resetZoom();
            if (si != null) {
                si.addPropertyChangeListener(this);
            }
        } else if (name.equals("bathyGrid")) {
            this.updateResults();
            this.resetZoom();
        } else if (name.equals("extrememum")) {
            this.extremum = (Integer)event.getNewValue();
            this.updateResults();
        } else if ("sourceSwitched".equals(name)) {
            this.updateResults();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == null || !(event.getSource() instanceof JTabbedPane)) {
            return;
        }
        Component sel = ((JTabbedPane)event.getSource()).getSelectedComponent();
        if (!(sel instanceof Container) || !((Container)sel).isAncestorOf(this)) {
            return;
        }
        SiftShare.log.fine("stateChange me: " + this.getClass().toString() + " updateRequired: " + this.updateRequired);
        if (this.updateRequired) {
            this.updateResults(true);
        }
    }

    public void savePanelImage(File f, boolean transparent, boolean withColorbar, boolean withDecorations) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (withColorbar && this.colorBar == null) {
            SiftShare.log.severe("Attempting to save ResultGraphicsPanel image, requesting a null colorBar");
            return;
        }
        if (withColorbar) {
            width += this.colorBar.getWidth();
        }
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2 = image.createGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, width, height);
        this.jPane.draw(g2);
        if (!withDecorations) {
            Rectangle clip = this.getImageAxesCornersPixels();
            image = image.getSubimage(clip.x, clip.y, clip.width, clip.height);
        }
        if (withColorbar) {
            BufferedImage cbimage = new BufferedImage(this.colorBar.getWidth(), this.colorBar.getHeight(), 1);
            Graphics2D g2cb = cbimage.createGraphics();
            g2cb.setColor(Color.WHITE);
            g2cb.fillRect(0, 0, this.colorBar.getWidth(), this.colorBar.getHeight());
            this.colorBar.DrawColorBar(g2cb);
            g2.setClip(0, 0, width, height);
            g2.drawImage((Image)cbimage, this.getWidth(), 0, this);
        }
        if (transparent) {
            image = this.convertToSmoothTransparent(image);
        }
        g2.dispose();
        try {
            ImageIO.write((RenderedImage)image, "png", f);
        }
        catch (IOException ioe) {
            SiftShare.log.log(Level.WARNING, "error", ioe);
        }
    }

    public void saveColorbarImage(File f, boolean whiteToTransparent) {
        if (this.colorBar == null) {
            SiftShare.log.warning("Attempting to save colorBar image... colorBar==null");
            return;
        }
        BufferedImage image = (BufferedImage)this.colorBar.createImage(this.colorBar.getWidth(), this.colorBar.getHeight());
        Graphics2D g2 = image.createGraphics();
        this.colorBar.DrawColorBar(g2);
        try {
            ImageIO.write((RenderedImage)image, "png", f);
        }
        catch (IOException ioe) {
            SiftShare.log.log(Level.WARNING, "error", ioe);
        }
    }

    public void saveImageToFile() {
        String filename = this.currentSite.getName() + ".png";
        JFileChooser chooser = new JFileChooser(CMIUtil.workingDirName);
        chooser.setDialogTitle("Save image as (.png)");
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                int idx = name.lastIndexOf(46);
                return idx > 0 && name.substring(idx + 1, name.length()).equals("png");
            }

            @Override
            public String getDescription() {
                return "PNG Files";
            }
        });
        File f = new File(CMIUtil.workingDirName, filename);
        chooser.setSelectedFile(f);
        int result = chooser.showSaveDialog(this);
        if (result == 0) {
            if (chooser.getSelectedFile().exists()) {
                int overwrite = JOptionPane.showConfirmDialog(chooser, "File exists, overwrite?", "File exists", 1);
                if (overwrite == 0) {
                    this.savePanelImage(chooser.getSelectedFile(), false, true, true);
                }
            } else {
                this.savePanelImage(chooser.getSelectedFile(), false, true, true);
            }
        }
    }

    public static BufferedImage convertToTransparent(BufferedImage src, Color transparentColor) {
        int w = src.getWidth();
        int h = src.getHeight();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage dest = gc.createCompatibleImage(w, h, 2);
        int trgb = transparentColor != null ? transparentColor.getRGB() | 0xFF000000 : -65281;
        int[] buf = new int[w];
        for (int y = 0; y < h; ++y) {
            src.getRGB(0, y, w, 1, buf, 0, w);
            for (int x = 0; x < w; ++x) {
                if (buf[x] != trgb) continue;
                buf[x] = 0;
            }
            dest.setRGB(0, y, w, 1, buf, 0, w);
        }
        return dest;
    }

    public BufferedImage convertToSmoothTransparent(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage dest = gc.createCompatibleImage(w, h, 3);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int rgb = image.getRGB(x, y);
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                int max = Math.max(r, Math.max(g, b));
                int min = Math.min(r, Math.min(g, b));
                int a = 255 - (max + min) / 2;
                a = Math.min((int)((double)a * 4.0), 255);
                rgb = a << 24 | r << 16 | g << 8 | b;
                dest.setRGB(x, y, rgb);
            }
        }
        return dest;
    }

    public void setZoom(SoTRange xRange, SoTRange yRange) {
        this.xZoomRange = xRange;
        this.yZoomRange = yRange;
        this.jPane.setBatch(true);
        SoTPoint origin = new SoTPoint(xRange.getStart(), yRange.getStart());
        this.xt.setRangeU(xRange);
        this.xAxis.setRangeU(xRange);
        this.xAxis.setDeltaU(xRange.getDelta().getDouble());
        this.xAxis.setLocationU(origin);
        this.xAxisTop.setLocationU(new SoTPoint(origin.getX(), yRange.getEnd()));
        this.yt.setRangeU(yRange);
        this.yAxis.setRangeU(yRange);
        this.yAxis.setDeltaU(Double.NaN);
        this.yAxis.setLocationU(origin);
        this.yAxisRight.setLocationU(new SoTPoint(xRange.getEnd(), origin.getY()));
        for (String lyrName : this.layers.keySet()) {
            this.getCartesianGraph(lyrName).setClip(xRange, yRange);
        }
        this.jPane.setBatch(false);
    }

    public void setZoom() {
        this.setZoom(this.xZoomRange, this.yZoomRange);
    }

    public void setZoom(Range2D xr, Range2D yr) {
        this.setZoom(new SoTRange.Double(xr.start, xr.end, xr.delta), new SoTRange.Double(yr.start, yr.end, xr.delta));
    }

    public void resetZoom() {
        if (this.currentSite != null) {
            BathyGrid grid;
            int gridIdent = this.getGridSelectorControl() != null ? this.getGridSelectorControl().getSelectedGrid() : 1;
            try {
                grid = this.currentSite.getBathyGrid(gridIdent);
            }
            catch (IOException ex) {
                return;
            }
            this.xZoomRange = grid.getXRange();
            this.yZoomRange = grid.getYRange();
            this.setZoom();
        }
    }

    public ResultGraphicsPanel setGridSelectorControl(GridSelectorPanel gridsel) {
        this.gridSelector = gridsel;
        this.gridSelector.addPropertyChangeListener("selectedGrid", this);
        return this;
    }

    public GridSelectorPanel getGridSelectorControl() {
        return this.gridSelector;
    }

    public synchronized void updateResults(boolean alwaysUpdate) {
        if ((alwaysUpdate || this.isShowing()) && this.currentSite != null) {
            this.readGrid();
            this.updateRequired = false;
        } else {
            this.clearData();
            this.updateRequired = true;
        }
    }

    public void updateResults() {
        this.updateResults(false);
    }

    protected abstract void readGrid();

    protected void setCurrentSite(SiteInfo siteInfo) {
        this.currentSite = siteInfo;
        if (siteInfo != null) {
            this.getLayer("aBox");
            this.getLayer("bBox");
            this.getLayer("cBox");
        }
    }

    protected SiteInfo getCurrentSite() {
        return this.currentSite;
    }

    protected void plotBoxes() {
        CartesianGraph aBoxGraph = this.getCartesianGraph("aBox");
        CartesianGraph bBoxGraph = this.getCartesianGraph("bBox");
        CartesianGraph cBoxGraph = this.getCartesianGraph("cBox");
        try {
            BathyGrid bg = this.currentSite.getBathyGrid(2);
            SoTRange.Double xr = (SoTRange.Double)bg.getXRange();
            SoTRange.Double yr = (SoTRange.Double)bg.getYRange();
            double[] xlocs = new double[]{xr.start, xr.end, xr.end, xr.start, xr.start};
            double[] ylocs = new double[]{yr.start, yr.start, yr.end, yr.end, yr.start};
            LineAttribute la = new LineAttribute(6, Color.YELLOW);
            la.setDashArray(new float[]{12.0f});
            la.setWidth(2.5f);
            bBoxGraph.setData(new SimpleLine(xlocs, ylocs, ""), la);
            bg = this.currentSite.getBathyGrid(3);
            xr = (SoTRange.Double)bg.getXRange();
            yr = (SoTRange.Double)bg.getYRange();
            double[] xlocsc = new double[]{xr.start, xr.end, xr.end, xr.start, xr.start};
            double[] ylocsc = new double[]{yr.start, yr.start, yr.end, yr.end, yr.start};
            la = new LineAttribute(6, Color.RED);
            la.setDashArray(new float[]{12.0f});
            la.setWidth(2.5f);
            cBoxGraph.setData(new SimpleLine(xlocsc, ylocsc, ""), la);
            bg = this.currentSite.getBathyGrid(1);
            xr = (SoTRange.Double)bg.getXRange();
            yr = (SoTRange.Double)bg.getYRange();
            double[] xlocsa = new double[]{xr.start, xr.end, xr.end, xr.start, xr.start};
            double[] ylocsa = new double[]{yr.start, yr.start, yr.end, yr.end, yr.start};
            la = new LineAttribute(6, Color.GREEN);
            la.setDashArray(new float[]{12.0f});
            la.setWidth(3.0f);
            aBoxGraph.setData(new SimpleLine(xlocsa, ylocsa, ""), la);
            this.getPane().remove(this.getLayer("outline"));
            this.getPane().add(this.getLayer("outline"));
        }
        catch (IOException ioe) {
            SiftShare.log.log(Level.WARNING, "IO error reading bathymetry", ioe);
        }
    }

    public void showBoxes(boolean b) {
        if (b) {
            this.getPane().add(this.getLayer("aBox"));
            this.getPane().add(this.getLayer("bBox"));
            this.getPane().add(this.getLayer("cBox"));
            this.getPane().remove(this.getLayer("outline"));
            this.getPane().add(this.getLayer("outline"));
        } else {
            this.getPane().remove(this.getLayer("aBox"));
            this.getPane().remove(this.getLayer("bBox"));
            this.getPane().remove(this.getLayer("cBox"));
        }
    }

    public void setColorMap(EnumeratedColorMap cm) {
        ga.setColorMap(cm);
        this.colorBar.setColorMap(cm);
        this.colorBar.invalidate();
        this.colorBar.repaint();
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new ResetMeZoomAction("Reset Zoom"));
        menu.add(new SaveImageAction("Save as Image"));
        return menu;
    }

    @Override
    public void modelStarted(ModelEvent me) {
    }

    @Override
    public void modelStopped(ModelEvent me) {
    }

    @Override
    public void modelUpdate(ModelEvent me) {
    }

    private class SaveImageAction
    extends AbstractAction {
        public SaveImageAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ResultGraphicsPanel.this.saveImageToFile();
        }
    }

    private class ResetMeZoomAction
    extends AbstractAction {
        public ResetMeZoomAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ResultGraphicsPanel.this.resetZoom();
        }
    }

    protected class MyMouseAdapter
    extends MouseAdapter {
        private final Component outerParent;

        public MyMouseAdapter(Component p) {
            this.outerParent = p;
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                ResultGraphicsPanel.this.createPopupMenu().show(event.getComponent(), event.getX(), event.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                ResultGraphicsPanel.this.createPopupMenu().show(event.getComponent(), event.getX(), event.getY());
            }
        }
    }
}

