/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.DefaultContourLineAttribute;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.VectorAttribute;
import gov.noaa.pmel.sgt.dm.SGTVector;
import gov.noaa.pmel.sgt.dm.SimpleLine;
import gov.noaa.pmel.sgt.dm.SimplePoint;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.ColorBar;
import gov.noaa.tsunami.cmi.ColorMaps;
import gov.noaa.tsunami.cmi.EnumeratedColorMap;
import gov.noaa.tsunami.cmi.GeoGrid2D;
import gov.noaa.tsunami.cmi.MOSTGrid;
import gov.noaa.tsunami.cmi.ModelEvent;
import gov.noaa.tsunami.cmi.MostResultsPanel;
import gov.noaa.tsunami.cmi.ResultGraphicsPanel;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import gov.noaa.tsunami.websift.propdb.PropagationDatabase;
import gov.noaa.tsunami.websift.propdb.PropagationDatabaseException;
import gov.noaa.tsunami.websift.propdb.SourceCombo;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;

public final class SAnimPanel
extends ResultGraphicsPanel {
    private final SGLabel timeLabel;
    private final SGLabel snasLabel;
    private final SGLabel snasLabel2;
    private MOSTGrid mostGrid = null;
    private MOSTGrid uGrid = null;
    private MOSTGrid vGrid = null;
    private SGTVector vector = null;
    private boolean showVectors = false;
    private BathyGrid bathyGrid = null;
    private SimplePoint sp;
    private SimplePoint gp;
    private PointAttribute pa;
    private PointAttribute pag;
    private VectorAttribute va;
    private double gaugeLon = 0.0;
    private double gaugeLat = 0.0;
    private boolean plotContours = true;
    private MostResultsPanel mrp;
    private int timeStep;
    private static final GregorianCalendar calendar = new GregorianCalendar(0, 0, 0, 0, 0, 0);
    private static final SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
    private static final Color TS_MARK_COLOR = new Color(129, 252, 0);
    private static final int CMLINEAR = 0;
    private static final int CMLOG = 1;
    private int colorMapType = 0;

    public SAnimPanel() {
        this.getLayer("topo");
        this.getLayer("amp");
        this.getLayer("bathy");
        this.getLayer("zero");
        this.getLayer("vectors");
        this.getLayer("gauge");
        this.getLayer("tslayer");
        this.snasLabel = new SGLabel("snas label", "", 0.11, new Point2D.Double(this.xSize / 2.0, this.ySize - 0.36), 1, 1);
        this.snasLabel.setFont(AXIS_FONT);
        this.snasLabel2 = new SGLabel("snas label2", "", 0.11, new Point2D.Double(this.xSize / 2.0, this.ySize - 0.43), 1, 1);
        this.snasLabel2.setFont(AXIS_FONT);
        this.timeLabel = new SGLabel("time label", "", 0.15, new Point2D.Double(this.xSize / 2.0, this.ySize - 0.54), 1, 1);
        this.timeLabel.setFont(AXIS_FONT);
        this.addLabel(this.snasLabel);
        this.addLabel(this.snasLabel2);
        this.addLabel(this.timeLabel);
        this.sp = new SimplePoint(0.0, 0.0, "tspt");
        this.pa = new PointAttribute(44, TS_MARK_COLOR);
        this.pa.setMarkHeightP(0.3);
        this.gp = new SimplePoint(0.0, 0.0, "gaugePoint");
        this.pag = new PointAttribute(49, new Color(0, 0, 0));
        this.pag.setMarkHeightP(0.3);
        this.va = new VectorAttribute(0.0085, Color.black);
        this.va.setHeadScale(0.5);
        this.va.setVectorStyle(2);
        this.colorBar = new ColorBar(0);
        this.colorBar.setBackground(Color.WHITE);
        this.colorBar.setColorMap(cmap);
        this.colorBar.setStringYOffset(3);
        this.add((Component)this.colorBar, "East");
        this.getPane().addMouseListener(new TimeseriesMouseHandler(this));
        this.setFocusable(true);
    }

    public void showVectors() {
        this.showVectors = true;
    }

    public void hideVectors() {
        this.showVectors = false;
    }

    public void setVectorScale(double s) {
        this.va.setVectorScale(s);
    }

    @Override
    public void readGrid() {
        SiteInfo siteInfo = this.getCurrentSite();
        int gridNum = this.getGridSelectorControl().getSelectedGrid();
        SiftShare.log.entering("entering SAnimPanel", "entering readGrid");
        this.closeFile();
        if (siteInfo == null) {
            this.clearData();
            return;
        }
        BathyGrid bg = null;
        try {
            bg = siteInfo.getBathyGrid(gridNum);
            bg = bg.subsampleToMaxSize(ResultGraphicsPanel.MAX_GRID_DISPLAY_SIZE);
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.WARNING, "IO error reading bathymetry", ex);
            this.bathyGrid = null;
        }
        if (bg != null) {
            this.bathyGrid = bg;
            double[] dv = new double[]{0.001, 0.01, 5.0, 10.0, 15.0, 20.0, 25.0, 50.0, 75.0, 100.0, 200.0, 300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0, 1000.0, 1500.0, 2000.0, 2500.0, 3000.0};
            ContourLevels cl = ContourLevels.getDefault(dv);
            EnumeratedColorMap mp = ColorMaps.getTopographyPalm_Springs_5ColorMap();
            mp.setEnumeratedValues(dv);
            GridAttribute tga = new GridAttribute(cl);
            tga.setColorMap(mp);
            tga.setStyle(0);
            this.getCartesianGraph("topo").setData(this.bathyGrid, tga);
            this.plotContours(this.plotContours, false);
        }
        this.mostGrid = new MOSTGrid(siteInfo.getOutputFile(gridNum, "ha").getPath());
        if (this.showVectors) {
            this.uGrid = new MOSTGrid(siteInfo.getOutputFile(gridNum, "ua").getPath(), "ua");
            this.vGrid = new MOSTGrid(siteInfo.getOutputFile(gridNum, "va").getPath(), "va");
            this.vector = new SGTVector(this.uGrid, this.vGrid);
            this.uGrid.readData(this.timeStep);
            this.vGrid.readData(this.timeStep);
            this.uGrid.subsampleToMaxSize(CMIUtil.maxNumArrows);
            this.vGrid.subsampleToMaxSize(CMIUtil.maxNumArrows);
            this.getCartesianGraph("vectors").setData(this.vector, this.va);
        } else {
            this.getCartesianGraph("vectors").setRenderer(null);
            this.uGrid = null;
            this.vGrid = null;
            this.vector = null;
        }
        GeoGrid2D axGrd = this.mostGrid.readData(this.timeStep) ? this.mostGrid : this.bathyGrid;
        this.getCartesianGraph("amp").setData(this.mostGrid, ga);
        this.getCartesianGraph("amp").setClip(axGrd.getXRange(), axGrd.getYRange());
        this.getCartesianGraph("vector").setClip(axGrd.getXRange(), axGrd.getYRange());
        this.getCartesianGraph("topo").setClip(axGrd.getXRange(), axGrd.getYRange());
        this.setAxes(axGrd);
        if (this.mrp == null) {
            this.mrp = (MostResultsPanel)SwingUtilities.getAncestorOfClass(MostResultsPanel.class, this);
        }
        if (this.mrp != null) {
            Point2D.Double tspt = this.mrp.getTimeseriesLocation();
            this.sp.setX(tspt.x);
            this.sp.setY(tspt.y);
            this.getCartesianGraph("tslayer").setData(this.sp, this.pa);
            if (this.mrp.getGridShowing() == 3) {
                this.gp.setX(this.gaugeLon);
                this.gp.setY(this.gaugeLat);
            } else {
                this.gp.setX(0.0);
                this.gp.setY(0.0);
            }
            this.getCartesianGraph("gauge").setData(this.gp, this.pag);
        }
        this.plotBoxes();
        this.updatePlotLabels(siteInfo);
        this.colorBar.repaint();
    }

    private void updatePlotLabels(SiteInfo siteInfo) {
        String snas = siteInfo.getSourceNamesAndSlips();
        try {
            SourceCombo sc = new SourceCombo(snas, PropagationDatabase.getInstance());
            snas = sc.getSourceNames();
        }
        catch (PropagationDatabaseException ex) {
            SiftShare.log.warning("Custom source, not in PropDB: " + snas);
        }
        this.titleLabel.setText(siteInfo.getName() + ": Wave Amplitude [cm]");
        if (snas != null) {
            int idx;
            if ((snas = snas.replaceAll("\\s", "")).length() > 80 && (idx = snas.indexOf("+", snas.length() / 2) + 1) > 0) {
                this.snasLabel.setLocationP(new Point2D.Double(this.xSize / 2.0, this.ySize - 0.32));
                this.snasLabel.setText(snas.substring(0, idx));
                this.snasLabel2.setText(snas.substring(idx));
            } else {
                this.snasLabel.setLocationP(new Point2D.Double(this.xSize / 2.0, this.ySize - 0.36));
                this.snasLabel.setText(snas);
                this.snasLabel2.setText("");
            }
        } else {
            this.snasLabel.setText("");
            this.snasLabel2.setText("");
        }
        this.snasLabel.setLocationP(new Point2D.Double(this.xSize / 2.0, this.ySize - 0.36));
        this.snasLabel2.setLocationP(new Point2D.Double(this.xSize / 2.0, this.ySize - 0.43));
        this.timeLabel.setLocationP(new Point2D.Double(this.xSize / 2.0, this.ySize - 0.54));
        this.updateTimeLabel();
    }

    public MOSTGrid getMostGrid() {
        return this.mostGrid;
    }

    public void plotContours(boolean p, boolean drawImmediately) {
        this.plotContours = p;
        if (this.plotContours) {
            if (this.bathyGrid != null) {
                double val;
                Range2D cr = ColorMaps.normalizeBathymetryRange(this.bathyGrid.getZRange());
                ContourLevels cl = new ContourLevels();
                for (val = cr.start; val <= cr.end; val += cr.delta) {
                    if (val == 0.0) continue;
                    cl.addLevel(val);
                }
                ArrayList<Double> addLevels = ColorMaps.getAdditionalLevels(cr.delta);
                for (double l : addLevels) {
                    cl.addLevel(-1.0 * l);
                }
                GridAttribute bga = new GridAttribute(cl);
                DefaultContourLineAttribute cla = new DefaultContourLineAttribute();
                cla.setLabelHeightP(0.15);
                cla.setLabelFont(CONTOUR_LABEL_FONT);
                bga.getContourLevels().setDefaultContourLineAttribute(cla);
                bga.setColorMap(ColorMaps.createSeaMap(this.bathyGrid.getZRange()));
                bga.setStyle(2);
                this.getCartesianGraph("bathy").setData(this.bathyGrid, bga);
                double[] x = this.bathyGrid.getXArray();
                double[] y = this.bathyGrid.getYArray();
                int nx = x.length;
                int ny = y.length;
                double[] xEdge = new double[nx + 1];
                double[] yEdge = new double[ny + 1];
                for (int i = 1; i < nx; ++i) {
                    xEdge[i] = (x[i - 1] + x[i]) * 0.5;
                }
                for (int j = 1; j < ny; ++j) {
                    yEdge[j] = (y[j - 1] + y[j]) * 0.5;
                }
                xEdge[0] = x[0] + 0.5 * (x[0] - x[1]);
                xEdge[xEdge.length - 1] = x[nx - 1] - 0.5 * (x[nx - 2] - x[nx - 1]);
                yEdge[0] = y[0] + 0.5 * (y[0] - y[1]);
                yEdge[yEdge.length - 1] = y[ny - 1] - 0.5 * (y[ny - 2] - y[ny - 1]);
                double zc = 0.001;
                double[] z = this.bathyGrid.getZArray();
                int[][] c = new int[nx][ny];
                for (int i = 0; i < nx; ++i) {
                    for (int j = 0; j < ny; ++j) {
                        val = z[j + i * ny];
                        c[i][j] = Double.isNaN(val) ? -1 : (zc >= val ? 1 : -1);
                    }
                }
                int count = 0;
                double[] xc = new double[3 * (2 * nx * ny + nx + ny)];
                double[] yc = new double[3 * (2 * nx * ny + nx + ny)];
                for (int i = 0; i < nx; ++i) {
                    for (int j = 0; j < ny; ++j) {
                        if (i < nx - 1 && c[i][j] + c[i + 1][j] == 0) {
                            xc[count] = xEdge[i + 1];
                            yc[count] = yEdge[j];
                            xc[count + 1] = xEdge[i + 1];
                            yc[count + 1] = yEdge[j + 1];
                            xc[count + 2] = Double.NaN;
                            yc[count + 2] = Double.NaN;
                            count += 3;
                        }
                        if (j >= ny - 1 || c[i][j] + c[i][j + 1] != 0) continue;
                        xc[count] = xEdge[i + 1];
                        yc[count] = yEdge[j + 1];
                        xc[count + 1] = xEdge[i];
                        yc[count + 1] = yEdge[j + 1];
                        xc[count + 2] = Double.NaN;
                        yc[count + 2] = Double.NaN;
                        count += 3;
                    }
                }
                LineAttribute lAttr = new LineAttribute();
                lAttr.setColor(Color.DARK_GRAY);
                lAttr.setStyle(6);
                float[] dashes = new float[]{12.0f};
                lAttr.setDashArray(dashes);
                lAttr.setCapStyle(1);
                double[] xout = Arrays.copyOf(xc, count);
                double[] yout = Arrays.copyOf(yc, count);
                SimpleLine line = new SimpleLine(xout, yout, "Coastline");
                this.getCartesianGraph("zero").setData(line, lAttr);
            }
        } else {
            this.getCartesianGraph("bathy").setRenderer(null);
            this.getCartesianGraph("zero").setRenderer(null);
        }
        if (drawImmediately) {
            this.getPane().setModified(true, "contours changed");
        }
    }

    public boolean contoursPlotted() {
        return this.plotContours;
    }

    private String eventHours(int t) {
        String result = null;
        calendar.clear();
        calendar.set(13, (int)this.mostGrid.getTime(t));
        result = df.format(calendar.getTime());
        return result;
    }

    public void closeFile() {
        if (this.mostGrid != null) {
            this.mostGrid.close();
        }
        if (this.uGrid != null) {
            this.uGrid.close();
        }
        if (this.vGrid != null) {
            this.vGrid.close();
        }
    }

    public void showTopography(boolean b) {
        if (b) {
            this.getPane().add((Component)this.getLayer("topo"), 0);
            this.titleLabel.setColor(Color.BLACK);
            ga.setColorMap(cmap);
            this.colorBar.setColorMap(cmap);
            this.colorBar.invalidate();
        } else {
            this.getPane().remove(this.getLayer("topo"));
        }
    }

    public void setGaugeLocation(double lon, double lat) {
        this.gaugeLon = lon;
        this.gaugeLat = lat;
    }

    public void setColorMapDefault() {
        this.setColorMap(ColorMaps.createRedBlueMap());
        this.colorMapType = 0;
    }

    public void setColorMapLog() {
        EnumeratedColorMap c = ColorMaps.createRedBlueMap();
        c.setEnumeratedValues(new double[]{-1000.0, -900.0, -800.0, -700.0, -600.0, -500.0, -450.0, -400.0, -350.0, -300.0, -250.0, -200.0, -150.0, -100.0, -50.0, -20.0, -10.0, -5.0, -2.0, -1.0, -0.5, -0.2, -0.1, -0.05, -0.02, -0.01, 0.0, 0.01, 0.02, 0.05, 0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 150.0, 200.0, 250.0, 300.0, 250.0, 400.0, 450.0, 500.0, 600.0, 700.0, 800.0, 900.0, 1000.0});
        this.setColorMap(c);
        this.colorMapType = 1;
    }

    private void updateTimeLabel() {
        int tscount = this.mostGrid.getNumberOfTimeSteps();
        String ttl = tscount > 0 ? String.format("Time step: %d of %d   ---   hrs:min:sec after event: %s", this.timeStep + 1, tscount, this.eventHours(this.timeStep)) : "";
        this.timeLabel.setText(ttl);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propname = event.getPropertyName();
        if ("timeStep".equals(propname)) {
            this.timeStep = ((Number)event.getNewValue()).intValue();
            try {
                if (this.mostGrid != null) {
                    this.mostGrid.loadTimeStep(this.timeStep);
                }
                if (this.uGrid != null) {
                    this.uGrid.loadTimeStep(this.timeStep);
                }
                if (this.vGrid != null) {
                    this.vGrid.loadTimeStep(this.timeStep);
                }
            }
            catch (IOException ex) {
                SiftShare.log.log(Level.WARNING, null, ex);
            }
            this.updateTimeLabel();
        } else if ("timeseriesLocation".equals(propname) && this.sp != null) {
            if (event.getNewValue() == null) {
                this.sp.setX(Double.NaN);
                this.sp.setY(Double.NaN);
            } else {
                Point2D.Double pt = (Point2D.Double)event.getNewValue();
                this.sp.setX(pt.x);
                this.sp.setY(pt.y);
                SiftShare.log.log(Level.FINE, "Setting ts location: {0}", pt);
            }
        }
        super.propertyChange(event);
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = super.createPopupMenu();
        JRadioButtonMenuItem citem = new JRadioButtonMenuItem(new AbstractAction("Linear Scale Colormap"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SAnimPanel.this.setColorMapDefault();
            }
        });
        JRadioButtonMenuItem ritem = new JRadioButtonMenuItem(new AbstractAction("Log Scale Colormap"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SAnimPanel.this.setColorMapLog();
            }
        });
        JCheckBoxMenuItem depthitem = new JCheckBoxMenuItem(new AbstractAction("Show Depth Contours"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SAnimPanel.this.plotContours) {
                    SAnimPanel.this.plotContours(false, true);
                } else {
                    SAnimPanel.this.plotContours(true, true);
                }
            }
        });
        ButtonGroup bg = new ButtonGroup();
        citem.setSelected(this.colorMapType == 0);
        ritem.setSelected(this.colorMapType == 1);
        bg.add(citem);
        bg.add(ritem);
        menu.addSeparator();
        menu.add(citem);
        menu.add(ritem);
        menu.addSeparator();
        depthitem.setSelected(this.plotContours);
        menu.add(depthitem);
        return menu;
    }

    @Override
    public void modelStarted(ModelEvent me) {
        CMIUtil.runOnDispatchThread(new Runnable(){

            @Override
            public void run() {
                SAnimPanel.this.updateResults(true);
            }
        });
    }

    @Override
    public void modelUpdate(final ModelEvent me) {
        CMIUtil.runOnDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (me.getSourceModel().equals(SAnimPanel.this.getCurrentSite()) && me.getStatus() == 101 && me.getTimesteps() > 0) {
                    if (SAnimPanel.this.mostGrid == null) {
                        SAnimPanel.this.readGrid();
                    } else {
                        SAnimPanel.this.mostGrid.updateTimeAxis();
                        if (SAnimPanel.this.uGrid != null) {
                            SAnimPanel.this.uGrid.updateTimeAxis();
                        }
                        if (SAnimPanel.this.vGrid != null) {
                            SAnimPanel.this.vGrid.updateTimeAxis();
                        }
                        SAnimPanel.this.updateTimeLabel();
                    }
                }
            }
        });
    }

    @Override
    public void modelStopped(final ModelEvent me) {
        CMIUtil.runOnDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (me.getTimesteps() == 0) {
                    SiftShare.log.fine("rec modelStopped");
                    SAnimPanel.this.readGrid();
                } else {
                    SAnimPanel.this.mostGrid.updateTimeAxis();
                    if (SAnimPanel.this.uGrid != null) {
                        SAnimPanel.this.uGrid.updateTimeAxis();
                    }
                    if (SAnimPanel.this.vGrid != null) {
                        SAnimPanel.this.vGrid.updateTimeAxis();
                    }
                }
                SAnimPanel.this.updateTimeLabel();
            }
        });
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed(String command) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                String actionCommand = command;
                e = new ActionEvent(this, 1001, actionCommand);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    private class TimeseriesMouseHandler
    extends MouseAdapter {
        final SAnimPanel panel;

        public TimeseriesMouseHandler(SAnimPanel p) {
            this.panel = p;
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            SAnimPanel.this.requestFocusInWindow();
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getButton() == 1 && event.getClickCount() == 2) {
                Layer layer = SAnimPanel.this.getLayer("amp");
                CartesianGraph graph = SAnimPanel.this.getCartesianGraph("amp");
                double x = graph.getXPtoU(layer.getXDtoP(event.getX()));
                double y = graph.getYPtoU(layer.getYDtoP(event.getY()));
                if (SAnimPanel.this.mrp == null) {
                    SAnimPanel.this.mrp = (MostResultsPanel)SwingUtilities.getAncestorOfClass(MostResultsPanel.class, this.panel);
                }
                if (SAnimPanel.this.mrp != null) {
                    Point2D.Double pt = new Point2D.Double(x, y);
                    SAnimPanel.this.mrp.setTimeseriesLocation(pt);
                }
            }
            SAnimPanel.this.requestFocusInWindow();
        }
    }
}

