/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.DefaultContourLineAttribute;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.ColorMaps;
import gov.noaa.tsunami.cmi.EnumeratedColorMap;
import gov.noaa.tsunami.cmi.ResultGraphicsPanel;
import gov.noaa.tsunami.cmi.SiftShare;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.filechooser.FileFilter;

public final class SBathyGridsPanel
extends ResultGraphicsPanel {
    private final SGLabel infoLabel;
    private int plotStyle = 4;
    private BathyGrid currentGrid;

    public SBathyGridsPanel() {
        this.getLayer("bathymetry");
        this.getLayer("topography");
        this.infoLabel = new SGLabel("info label", "", 0.14, new Point2D.Double(this.xSize / 2.0, this.ySize - 0.35), 1, 1);
        this.addLabel(this.infoLabel);
    }

    @Override
    public void readGrid() {
        if (this.getCurrentSite() == null) {
            return;
        }
        Range2D zr = null;
        try {
            this.currentGrid = this.getCurrentSite().getBathyGrid(this.getGridSelectorControl().getSelectedGrid()).subsampleToMaxSize(ResultGraphicsPanel.MAX_GRID_DISPLAY_SIZE);
            zr = this.currentGrid.getZRange();
            SiftShare.log.info("Bathy range: " + zr);
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.SEVERE, "error loading grid bathymetry", ex);
            return;
        }
        String gridTitle = String.format("%s %s-Grid Bathymetry [m]", this.getCurrentSite().getName(), BathyGrid.getGridLetter(this.getGridSelectorControl().getSelectedGrid()));
        this.setTitle(gridTitle);
        try {
            this.infoLabel.setText(this.currentGrid.getGridFile().getCanonicalPath());
        }
        catch (IOException ex) {
            SiftShare.log.warning(ex.toString());
            this.infoLabel.setText(this.currentGrid.getGridFile().toString());
        }
        this.setAxes(this.currentGrid);
        this.infoLabel.setLocationP(new Point2D.Double(this.xSize / 2.0, this.ySize - 0.35));
        double[] dv = new double[]{0.001, 0.01, 5.0, 10.0, 15.0, 20.0, 25.0, 50.0, 75.0, 100.0, 200.0, 300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0, 1000.0, 1500.0, 2000.0, 2500.0, 3000.0, 3500.0, 4000.0};
        ContourLevels cl = ContourLevels.getDefault(dv);
        DefaultContourLineAttribute cla = cl.getDefaultContourLineAttribute();
        cla.setColor(new Color(1, 1, 1, 64));
        cla.setLabelColor(new Color(1, 1, 1, 64));
        cla.setWidth(0.1f);
        cla.setLabelHeightP(0.15);
        GridAttribute bga = new GridAttribute(cl);
        EnumeratedColorMap mp = ColorMaps.getTopographyPalm_Springs_5ColorMap();
        mp.setEnumeratedValues(dv);
        bga.setColorMap(mp);
        bga.setStyle(this.plotStyle);
        this.getCartesianGraph("topography").setData(this.currentGrid, bga);
        Range2D cr = ColorMaps.normalizeBathymetryRange(this.currentGrid.getZRange());
        ContourLevels bcl = ContourLevels.getDefault(cr);
        ArrayList<Double> addLevels = ColorMaps.getAdditionalLevels(cr.delta);
        for (double l : addLevels) {
            bcl.addLevel(-1.0 * l);
        }
        GridAttribute ga = new GridAttribute(bcl);
        DefaultContourLineAttribute dcla = new DefaultContourLineAttribute();
        dcla.setLabelHeightP(0.15);
        dcla.setLabelFont(CONTOUR_LABEL_FONT);
        ga.getContourLevels().setDefaultContourLineAttribute(dcla);
        ga.setColorMap(ColorMaps.createSeaMap(cr));
        ga.setStyle(this.plotStyle);
        if (this.plotStyle == 3) {
            // empty if block
        }
        this.getCartesianGraph("bathymetry").setData(this.currentGrid, ga);
        this.plotBoxes();
        this.resetZoom();
    }

    @Override
    public void saveImageToFile() {
        JFileChooser chooser = new JFileChooser(CMIUtil.workingDirName);
        chooser.setDialogTitle("Save image as (.png)");
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                int idx = name.lastIndexOf(46);
                return idx > 0 && name.substring(idx + 1, name.length()).equals("png");
            }

            @Override
            public String getDescription() {
                return "PNG Files";
            }
        });
        int result = chooser.showSaveDialog(this);
        if (result == 0) {
            this.savePanelImage(chooser.getSelectedFile(), false, false, true);
        }
    }

    public void saveAsNetCDF() {
        String filename = this.currentGrid.getFileName().replaceFirst("[.][^.]+$", "") + ".nc";
        JFileChooser chooser = new JFileChooser(this.getCurrentSite().getDirName());
        chooser.setSelectedFile(new File(this.getCurrentSite().getDirName(), filename));
        chooser.setDialogTitle("Save as NetCDF (.nc)");
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                int idx = name.lastIndexOf(46);
                return idx > 0 && name.substring(idx + 1, name.length()).equals("nc");
            }

            @Override
            public String getDescription() {
                return "NetCDF Files";
            }
        });
        int result = chooser.showSaveDialog(this);
        if (result == 0) {
            try {
                this.currentGrid.saveAsNetCDF(chooser.getSelectedFile(), false);
            }
            catch (IOException ex) {
                SiftShare.log.log(Level.SEVERE, "Error saving bathy file to netCDF", ex);
            }
        }
    }

    public void saveAsGeoTIFF() {
        String filename = this.currentGrid.getFileName().replaceFirst("[.][^.]+$", "") + ".tif";
        JFileChooser chooser = new JFileChooser(this.getCurrentSite().getDirName());
        chooser.setSelectedFile(new File(this.getCurrentSite().getDirName(), filename));
        chooser.setDialogTitle("Save as GeoTIFF (.tif)");
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                int idx = name.lastIndexOf(46);
                return idx > 0 && name.substring(idx + 1, name.length()).equals("nc");
            }

            @Override
            public String getDescription() {
                return "GeoTIFF Files";
            }
        });
        int result = chooser.showSaveDialog(this);
        if (result == 0) {
            try {
                this.currentGrid.saveAsGeoTIFF(chooser.getSelectedFile());
            }
            catch (IOException ex) {
                SiftShare.log.log(Level.SEVERE, "Error saving bathy file to GeoTIFF", ex);
            }
        }
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = super.createPopupMenu();
        JRadioButtonMenuItem snitem = new JRadioButtonMenuItem(new AbstractAction("Save As NetCDF"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SBathyGridsPanel.this.saveAsNetCDF();
            }
        });
        JRadioButtonMenuItem sgitem = new JRadioButtonMenuItem(new AbstractAction("Save As GeoTIFF"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SBathyGridsPanel.this.saveAsGeoTIFF();
            }
        });
        JRadioButtonMenuItem citem = new JRadioButtonMenuItem(new AbstractAction("Contour map"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SBathyGridsPanel.this.plotStyle = 4;
                SBathyGridsPanel.this.readGrid();
            }
        });
        JRadioButtonMenuItem ritem = new JRadioButtonMenuItem(new AbstractAction("Raster map"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SBathyGridsPanel.this.plotStyle = 3;
                SBathyGridsPanel.this.readGrid();
            }
        });
        ButtonGroup bg = new ButtonGroup();
        citem.setSelected(this.plotStyle == 4);
        ritem.setSelected(this.plotStyle == 3);
        bg.add(citem);
        bg.add(ritem);
        menu.add(snitem);
        menu.add(sgitem);
        menu.addSeparator();
        menu.add(citem);
        menu.add(ritem);
        return menu;
    }
}

