/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.DefaultContourLineAttribute;
import gov.noaa.pmel.sgt.GeometryAttribute;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.dm.GeometryCollection;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SimpleGeometry;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.ColorBar;
import gov.noaa.tsunami.cmi.ColorMaps;
import gov.noaa.tsunami.cmi.EnumeratedColorMap;
import gov.noaa.tsunami.cmi.MOSTMaxGrid;
import gov.noaa.tsunami.cmi.ModelEvent;
import gov.noaa.tsunami.cmi.ResultGraphicsPanel;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import gov.noaa.tsunami.cmi.SwingWorker;
import gov.noaa.tsunami.cmi.TaskCompletionCallback;
import gov.noaa.tsunami.websift.ee.GSHHSReader;
import gov.noaa.tsunami.websift.propdb.PropagationDatabase;
import gov.noaa.tsunami.websift.propdb.PropagationDatabaseException;
import gov.noaa.tsunami.websift.propdb.SourceCombo;
import gov.noaa.tsunami.websift.propdb.UnitSource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.beans.PropertyChangeEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;

public final class SICImagePanel
extends ResultGraphicsPanel
implements TaskCompletionCallback {
    private final SGLabel boxLabel;
    private final MOSTMaxGrid sg = new MOSTMaxGrid();
    private final MOSTMaxGrid ag = new MOSTMaxGrid();
    private final EnumeratedColorMap cmap = ColorMaps.createRachelMapLarge();
    private int lastUpdateStatus;
    private boolean fileDownloading = false;
    private String snas = "";
    private boolean mixedSource = false;
    private boolean cachedOnly = false;
    private BathyGrid bg = null;
    GeometryCollection gc = null;
    FileDownloadWorker dlworker = null;
    SiteInfo siteInfo = null;

    public SICImagePanel() {
        this.getLayer("amp");
        this.getLayer("topo");
        this.getLayer("arrtime");
        this.setTitle("");
        this.boxLabel = new SGLabel("", "", 0.1, new Point2D.Double(0.0, 0.0), 2, 0);
        this.boxLabel.setColor(Color.GREEN);
        this.addLabel(this.boxLabel);
        this.colorBar = new ColorBar(0);
        this.colorBar.setBackground(Color.WHITE);
        this.colorBar.setStringYOffset(3);
        this.colorBar.setColorMap(this.cmap);
        this.add((Component)this.colorBar, "East");
        this.loadLandMass();
    }

    private void loadLandMass() {
        ArrayList<Area> masses = null;
        try {
            File lmf = CMIUtil.unpackFile(this, "maplayers/gshhs_c.nc", new File(CMIUtil.etcDirName), "gshhs_c.nc");
            masses = GSHHSReader.getTileAreas(lmf);
        }
        catch (IOException ioe) {
            SiftShare.log.log(Level.WARNING, "Can't load gshhs landmass file", ioe);
        }
        this.gc = new GeometryCollection();
        GeometryFactory fact = new GeometryFactory();
        for (Area lm : masses) {
            Vector<Coordinate> coords = new Vector<Coordinate>();
            Vector polys = new Vector();
            PathIterator pi = lm.getPathIterator(null);
            double[] pts = new double[2];
            while (!pi.isDone()) {
                Coordinate coord;
                int type = pi.currentSegment(pts);
                if (type == 0) {
                    if (coords.size() > 2) {
                        this.gc.add(SICImagePanel.makePoly(fact, coords));
                    } else if (coords.size() == 0) {
                        coord = new Coordinate(pts[0], pts[1]);
                        coords.add(coord);
                    }
                } else if (type == 1) {
                    coord = new Coordinate(pts[0], pts[1]);
                    coords.add(coord);
                } else if (type == 4) {
                    // empty if block
                }
                pi.next();
            }
            if (coords.size() <= 2) continue;
            this.gc.add(SICImagePanel.makePoly(fact, coords));
        }
    }

    private static SimpleGeometry makePoly(GeometryFactory fact, Vector<Coordinate> coords) {
        if (coords.get((int)0).x != coords.get((int)(coords.size() - 1)).x || coords.get((int)0).y != coords.get((int)(coords.size() - 1)).y) {
            Coordinate coord = new Coordinate(coords.get((int)0).x, coords.get((int)0).y);
            coords.add(coord);
        }
        Coordinate[] coordArray = new Coordinate[coords.size()];
        coordArray = coords.toArray(coordArray);
        Geometry lString = fact.createLineString(coordArray);
        lString = lString.union(lString);
        LinearRing ring = fact.createLinearRing(lString.getCoordinates());
        Polygon poly = fact.createPolygon(ring, null);
        coords.removeAllElements();
        SimpleGeometry sg = new SimpleGeometry(poly, "one");
        return sg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMaxFileUpToDate(SiteInfo site) {
        this.siteInfo = site;
        NetcdfFile ncf = null;
        try {
            ncf = NetcdfFile.open(site.getFullLincoMaxFilename());
            List<Attribute> attlist = ncf.getGlobalAttributes();
            for (Attribute att : attlist) {
                if (!att.getShortName().equals("Source_Combination")) continue;
                SourceCombo msc = new SourceCombo(att.getStringValue(), PropagationDatabase.getInstance());
                SourceCombo sc = new SourceCombo(site.getSourceNamesAndSlips(), PropagationDatabase.getInstance());
                SiftShare.log.fine("site inv:" + sc + "\n      file inv:" + msc);
                if (!msc.equals(sc)) continue;
                boolean bl = true;
                return bl;
            }
            ncf.close();
        }
        catch (IOException ignore) {
            boolean bl = false;
            return bl;
        }
        catch (PropagationDatabaseException ex) {
            SiftShare.log.log(Level.SEVERE, "error getting SourceCombo for: " + site.getSourceNamesAndSlips(), ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (ncf != null) {
                try {
                    ncf.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public void setColorbarValues() {
        if (this.sg == null || this.sg.getZRange() == null) {
            return;
        }
        double maxwave = this.sg.getZRange().end;
        double maxLimit = 10.0;
        if (maxwave > 10.0) {
            maxLimit = 20.0;
        }
        if (maxwave > 20.0) {
            maxLimit = 50.0;
        }
        if (maxwave > 50.0) {
            maxLimit = 100.0;
        }
        if (maxwave > 100.0) {
            maxLimit = 200.0;
        }
        if (maxwave > 200.0) {
            maxLimit = 500.0;
        }
        if (maxwave > 500.0) {
            maxLimit = 1000.0;
        }
        double[] vals = new double[320];
        vals[0] = 0.0;
        for (int i = 1; i < vals.length; ++i) {
            vals[i] = vals[i - 1] + maxLimit / 320.0;
        }
        this.cmap.setEnumeratedValues(vals);
        this.colorBar.setColorMap(this.cmap);
    }

    public void downloadMaxAmpFile(SiteInfo site) {
        SiftShare.log.info("Requested max amp file download.");
        if (this.fileDownloading) {
            SiftShare.log.fine("Already downloading max amp file, not downloading.");
            return;
        }
        if (this.isMaxFileUpToDate(site)) {
            SiftShare.log.fine("Max amp file up to date... calling readGrid().");
            this.readGrid();
            this.setColorbarValues();
            return;
        }
        if (site.getSourceNamesAndSlips().equals("")) {
            SiftShare.log.fine("Not downloading max amp file: no sources selected");
            this.clearData();
            this.setTitle("No Source Selected");
            return;
        }
        this.clearData();
        File outFile = new File(site.getFullLincoMaxFilename());
        if (outFile.exists()) {
            try {
                SiftShare.log.fine("deleting file: " + outFile.getPath());
                Files.delete(outFile.toPath());
            }
            catch (IOException ex) {
                SiftShare.log.log(Level.SEVERE, "Error: can't remove linCo_<source>h_max.nc file.", ex);
            }
        }
        SourceCombo sc = null;
        try {
            sc = new SourceCombo(site.getSourceNamesAndSlips(), PropagationDatabase.getInstance());
        }
        catch (PropagationDatabaseException ex) {
            SiftShare.log.log(Level.SEVERE, "Error getting SourceCombo from PropagationDatabase", ex);
            return;
        }
        Vector<UnitSource> sources = sc.getSources();
        boolean hasLocal = false;
        boolean hasRemote = false;
        this.mixedSource = false;
        this.cachedOnly = false;
        for (UnitSource u : sources) {
            String fn = u.getOriginalFileName();
            if (fn == null) continue;
            if (fn.startsWith("http")) {
                hasRemote = true;
                continue;
            }
            hasLocal = true;
        }
        boolean bl = this.cachedOnly = !hasLocal && !hasRemote;
        if (hasLocal && hasRemote) {
            this.mixedSource = true;
            this.setTitle("Mixed Local/Remote source, can't calculate max amplitude.");
            return;
        }
        if (hasLocal && !hasRemote) {
            this.setTitle("Calculating Initial Condition maximums from Custom Prop file");
            this.getMaxFromCustomSource(sc, site);
            this.updateResults();
            this.setColorbarValues();
            return;
        }
        this.setTitle("Dowloading Initial Condition file from server...");
        this.snas = site.getSourceNamesAndSlips();
        SiftShare.log.fine("Downloading Propagation max amp file from server...");
        System.gc();
        this.dlworker = new FileDownloadWorker(outFile, site, this);
        this.fileDownloading = true;
        this.dlworker.start();
    }

    private void getMaxFromCustomSource(SourceCombo sc, SiteInfo site) {
        SiftShare.log.fine("Creating linCoh_max.nc from local files.");
        NetcdfFile ncin = null;
        NetcdfFileWriter ncout = null;
        String outfilename = site.getFullLincoMaxFilename();
        String infilename = "";
        boolean firstSource = true;
        ArrayFloat.D2 maxarr = null;
        Variable maxvar = null;
        Variable travar = null;
        try {
            ncout = NetcdfFileWriter.createNew(NetcdfFileWriter.Version.netcdf3, outfilename);
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.SEVERE, "Can't open output file: linCoh_max.nc", ex);
            return;
        }
        double[] lons = null;
        double[] lats = null;
        for (UnitSource us : sc.getSources()) {
            infilename = String.format("%s_%03d_%s_ha.nc", us.getZone(), us.getNameNumber(), us.getNameLetter());
            infilename = CMIUtil.propDirName + File.separator + infilename;
            if (!new File(infilename).exists()) {
                SiftShare.log.warning("Error creating linCoh_max.nc: custom prop file does not exist: " + infilename);
                return;
            }
            try {
                ncin = NetcdfFile.open(infilename);
                if (firstSource) {
                    firstSource = false;
                    lons = (double[])((ArrayDouble.D1)ncin.findVariable("grid_lon").read()).copyTo1DJavaArray();
                    lats = (double[])((ArrayDouble.D1)ncin.findVariable("grid_lat").read()).copyTo1DJavaArray();
                    Dimension londim = ncout.addDimension(null, "lon", lons.length);
                    Dimension latdim = ncout.addDimension(null, "lat", lats.length);
                    ArrayList<Dimension> dims = new ArrayList<Dimension>();
                    dims.add(londim);
                    Variable lonvar = ncout.addVariable(null, "lon", DataType.DOUBLE, dims);
                    dims.clear();
                    dims.add(latdim);
                    Variable latvar = ncout.addVariable(null, "lat", DataType.DOUBLE, dims);
                    dims.clear();
                    dims.add(latdim);
                    dims.add(londim);
                    maxvar = ncout.addVariable(null, "max_height", DataType.FLOAT, dims);
                    maxvar.addAttribute(new Attribute("missing_value", Float.valueOf(-1.0E34f)));
                    travar = ncout.addVariable(null, "travel_time", DataType.FLOAT, dims);
                    ncout.addGroupAttribute(null, new Attribute("Source_Combination", site.getSourceNamesAndSlips()));
                    ncout.create();
                    ncout.write(lonvar, Array.factory(lons));
                    ncout.write(latvar, Array.factory(lats));
                    maxarr = new ArrayFloat.D2(lats.length, lons.length);
                    MAMath.setDouble(maxarr, 0.0);
                }
                ArrayFloat.D2 maxarrin = (ArrayFloat.D2)ncin.findVariable("max_height").read();
                float alpha = (float)us.getAlpha();
                float holder = 0.0f;
                for (int j = 0; j < lats.length; ++j) {
                    for (int i = 0; i < lons.length; ++i) {
                        holder = maxarrin.get(j, i);
                        if (holder == -1.0E34f) {
                            maxarr.set(j, i, -1.0E34f);
                            continue;
                        }
                        maxarr.set(j, i, maxarr.get(j, i) + alpha * holder);
                    }
                }
                ncin.close();
            }
            catch (IOException | InvalidRangeException ex) {
                SiftShare.log.log(Level.SEVERE, null, ex);
            }
        }
        try {
            ncout.write(maxvar, maxarr);
            ncout.close();
        }
        catch (IOException | InvalidRangeException ex) {
            SiftShare.log.log(Level.SEVERE, "Can't create linCoh_max file", ex);
        }
        SiftShare.log.fine("Done creating linCoh_max file.  Exists: " + new File(outfilename).exists());
    }

    @Override
    public void onTaskComplete(String result) {
        this.fileDownloading = false;
        this.readGrid();
        this.setColorbarValues();
    }

    @Override
    public void onTaskError(Exception e) {
        this.fileDownloading = false;
        SiftShare.log.log(Level.WARNING, "Error downloading max amp file: " + this.siteInfo.getSourceNamesAndSlips(), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(File outFile, SiteInfo site) throws IOException {
        FileOutputStream fout = null;
        File tmpFile = null;
        URL url = null;
        try {
            int read;
            InputStream fis;
            url = new URL(CMIUtil.commitServerAddress + "/compressed/max?ts=" + site.getSourceNamesAndSlips());
            if ("https".equals(url.getProtocol())) {
                InputStream errstream;
                HttpURLConnection httpc = (HttpURLConnection)url.openConnection();
                httpc.setConnectTimeout(7000);
                if (httpc.getResponseCode() >= 400 && (errstream = httpc.getErrorStream()) != null) {
                    BufferedReader br = new BufferedReader(new InputStreamReader(httpc.getErrorStream()));
                    String errstr = br.readLine();
                    SiftShare.log.severe("\n\nError downloading linCoh_max.nc file, can't connect to server!\n\n");
                    throw new IOException(errstr);
                }
                fis = httpc.getInputStream();
            } else {
                fis = url.openStream();
            }
            SiftShare.log.log(Level.INFO, "Downloading max amp file {0} to local file {1}", new Object[]{url, outFile});
            tmpFile = File.createTempFile(outFile.getName(), "tmp", site.getSiteDirectory());
            fout = new FileOutputStream(tmpFile);
            byte[] buf = new byte[4096];
            while ((read = fis.read(buf)) != -1) {
                fout.write(buf, 0, read);
                if (!Thread.interrupted()) continue;
                SiftShare.log.severe("\n\nError downloading linCoh_max.nc file: interuppted while downloading!\n\n");
                throw new IOException("Download interrupted, cancelling");
            }
            fis.close();
            fout.close();
        }
        finally {
            if (fout != null) {
                fout.close();
            }
        }
        if (tmpFile != null && tmpFile.canRead()) {
            tmpFile.renameTo(outFile);
        }
    }

    @Override
    public void readGrid() {
        SiftShare.log.entering("SICImagePanel", "readGrid");
        SiteInfo site = this.getCurrentSite();
        if (site == null) {
            SiftShare.log.fine("Not reading max amp file, SiteInfo null");
            this.clearData();
            return;
        }
        final File maxFile = new File(this.getCurrentSite().getFullLincoMaxFilename());
        if (!this.isMaxFileUpToDate(this.getCurrentSite())) {
            SiftShare.log.fine("Max amp file not up to date: deleting.");
            maxFile.delete();
        }
        if (!maxFile.exists()) {
            if (this.fileDownloading) {
                if (!this.getCurrentSite().getSourceNamesAndSlips().equals(this.snas)) {
                    SiftShare.log.info("Canceling file download for inv: " + this.snas);
                    if (this.dlworker != null) {
                        this.dlworker.stop();
                    }
                }
            } else if (CMIUtil.workOffline || this.cachedOnly) {
                this.setTitle("Initial Condition image will be downloaded when internet is available.");
            } else if (this.mixedSource) {
                this.setTitle("Mixed Local/Remote source, can't calculate max amplitude.");
            } else {
                this.clearData();
                this.setTitle("Click \"Start model\" to see Initial Condition.");
            }
            return;
        }
        SwingWorker gridWorker = new SwingWorker(){
            boolean isDataAvailable = false;

            @Override
            public Object construct() {
                this.isDataAvailable = SICImagePanel.this.sg.readData(maxFile.getPath(), "max_height");
                if (this.isDataAvailable) {
                    SICImagePanel.this.sg.forceLons0360();
                    SiftShare.log.fine("Sub-sampling max amp file: " + maxFile.getName());
                    SICImagePanel.this.sg.subsampleToMaxSize(ResultGraphicsPanel.MAX_GRID_DISPLAY_SIZE);
                }
                return SICImagePanel.this.sg;
            }

            @Override
            public void finished() {
                if (this.isDataAvailable) {
                    GridAttribute ga = new GridAttribute(0, SICImagePanel.this.cmap);
                    SICImagePanel.this.setAxes(SICImagePanel.this.sg);
                    SICImagePanel.this.getCartesianGraph("amp").setData(SICImagePanel.this.sg, ga);
                    SICImagePanel.this.ag.readData(maxFile.getPath(), "travel_time");
                    SICImagePanel.this.ag.forceLons0360();
                    double[] dv = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0};
                    ContourLevels cl = ContourLevels.getDefault(dv);
                    DefaultContourLineAttribute dcla = cl.getDefaultContourLineAttribute();
                    dcla.setColor(new Color(1, 1, 1, 64));
                    dcla.setLabelColor(new Color(1, 1, 1, 64));
                    dcla.setLabelHeightP(0.15);
                    dcla.setLabelFont(ResultGraphicsPanel.CONTOUR_LABEL_FONT);
                    dcla.setWidth(0.1f);
                    GridAttribute bga = new GridAttribute(cl);
                    bga.setStyle(2);
                    SICImagePanel.this.getCartesianGraph("arrtime").setData(SICImagePanel.this.ag, bga);
                    SICImagePanel.this.addBathymetryLayer();
                    SICImagePanel.this.titleLabel.setText(SICImagePanel.this.getCurrentSite().getName() + " Initial Condition Maximum Amplitude [cm]");
                    SICImagePanel.this.resetZoom();
                    SICImagePanel.this.setColorbarValues();
                }
            }
        };
        this.setTitle("loading image...");
        gridWorker.start();
    }

    @Override
    public void resetZoom() {
        if (this.getCurrentSite() != null && this.getCartesianGraph("amp").getRenderer() != null) {
            SGTData d = this.getCartesianGraph("amp").getRenderer().getData();
            this.setZoom(d.getXRange(), d.getYRange());
        }
        this.colorBar.repaint();
    }

    private void addBathymetryLayer() {
        CartesianGraph bathyGraph = this.getCartesianGraph("topo");
        GeometryAttribute geomAttribute = new GeometryAttribute();
        LineAttribute la = geomAttribute.getOutlineAttribute();
        la.setColor(Color.black);
        la.setWidth(0.1f);
        geomAttribute.setDrawOutline(false);
        geomAttribute.setDefaultFillColor(new Color(128, 128, 128));
        bathyGraph.setData(this.gc, geomAttribute);
        this.plotBoxes();
    }

    @Override
    public void modelStarted(ModelEvent me) {
        CMIUtil.runOnDispatchThread(new Runnable(){

            @Override
            public void run() {
                SICImagePanel.this.lastUpdateStatus = Integer.MIN_VALUE;
            }
        });
    }

    @Override
    public void modelUpdate(final ModelEvent me) {
        CMIUtil.runOnDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (SICImagePanel.this.lastUpdateStatus == 100 && me.getStatus() == 101) {
                    SICImagePanel.this.updateResults();
                }
                SICImagePanel.this.lastUpdateStatus = me.getStatus();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propname = event.getPropertyName();
        if ("sourceSwitched".equals(propname)) {
            if (this.getCurrentSite() != null) {
                if (this.fileDownloading) {
                    this.fileDownloading = false;
                    this.dlworker.stop();
                }
                this.downloadMaxAmpFile(this.getCurrentSite());
            }
        } else if ("currentSite".equals(propname)) {
            SiteInfo si = (SiteInfo)event.getNewValue();
            SiteInfo oldsi = (SiteInfo)event.getOldValue();
            if (oldsi != null) {
                oldsi.removePropertyChangeListener(this);
            }
            if (this.fileDownloading) {
                this.fileDownloading = false;
                this.dlworker.stop();
            }
            this.setCurrentSite(si);
            this.updateResults();
            this.resetZoom();
            if (si != null) {
                si.addPropertyChangeListener(this);
            }
        } else if ("zoomRectangle".equals(propname)) {
            double temp;
            Range2D xr = new Range2D();
            Range2D yr = new Range2D();
            Rectangle zm = (Rectangle)event.getNewValue();
            CartesianGraph graph = this.getCartesianGraph("base");
            Layer layer = this.getLayer("base");
            if (zm.width <= 1 || zm.height <= 1) {
                return;
            }
            xr.start = graph.getXPtoU(layer.getXDtoP(zm.x));
            xr.end = graph.getXPtoU(layer.getXDtoP(zm.x + zm.width));
            if (xr.start > xr.end) {
                temp = xr.start;
                xr.start = xr.end;
                xr.end = temp;
            }
            yr.start = graph.getYPtoU(layer.getYDtoP(zm.y));
            yr.end = graph.getYPtoU(layer.getYDtoP(zm.y + zm.height));
            if (yr.start > yr.end) {
                temp = yr.start;
                yr.start = yr.end;
                yr.end = temp;
            }
            this.setZoom(xr, yr);
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        Component sel;
        if (this.getCurrentSite() != null && event.getSource() instanceof JTabbedPane && (sel = ((JTabbedPane)event.getSource()).getSelectedComponent()) instanceof Container && ((Container)sel).isAncestorOf(this)) {
            this.downloadMaxAmpFile(this.getCurrentSite());
        }
    }

    private class FileDownloadWorker
    implements Runnable {
        private final File outFile;
        private SiteInfo site;
        private TaskCompletionCallback callback;
        private Thread dfThread;

        public FileDownloadWorker(File outFile, SiteInfo site, TaskCompletionCallback callback) {
            this.outFile = outFile;
            this.site = site;
            this.callback = callback;
        }

        public Thread start() {
            this.dfThread = new Thread((Runnable)this, this.getClass().getSimpleName() + ": " + this.outFile.getName());
            this.dfThread.start();
            return this.dfThread;
        }

        public void stop() {
            this.dfThread.interrupt();
        }

        public boolean isRunning() {
            return this.dfThread != null && this.dfThread.isAlive();
        }

        @Override
        public void run() {
            try {
                SICImagePanel.this.downloadFile(this.outFile, this.site);
                this.callback.onTaskComplete(this.outFile.getName());
            }
            catch (IOException ex) {
                SiftShare.log.warning("Error downloading max amp file: " + this.site.getSourceNamesAndSlips());
                this.callback.onTaskError(ex);
            }
        }
    }
}

