/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.ContourLineAttribute;
import gov.noaa.pmel.sgt.DefaultContourLineAttribute;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.IndexedColorMap;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.VectorAttribute;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.sgt.dm.SGTVector;
import gov.noaa.pmel.sgt.dm.SimpleGrid;
import gov.noaa.pmel.sgt.dm.SimpleLine;
import gov.noaa.pmel.sgt.dm.SimplePoint;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.ColorBar;
import gov.noaa.tsunami.cmi.ColorMaps;
import gov.noaa.tsunami.cmi.CurrentsColormap;
import gov.noaa.tsunami.cmi.EnumeratedColorMap;
import gov.noaa.tsunami.cmi.MOSTMaxGrid;
import gov.noaa.tsunami.cmi.ModelEvent;
import gov.noaa.tsunami.cmi.MostExtremaPanel;
import gov.noaa.tsunami.cmi.ResultGraphicsPanel;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public final class SMaxImagePanel
extends ResultGraphicsPanel {
    private EnumeratedColorMap cmap;
    private EnumeratedColorMap cmapMax;
    private EnumeratedColorMap cmapMin;
    private EnumeratedColorMap cmapCurrents;
    private BathyGrid bathyGrid;
    private BathyGrid displayedBathyGrid;
    private final SGLabel infoLabel;
    private final SGLabel floodLabel;
    private String extremaName = "max_amp_";
    private String infoLabelPrefix = "Maximum amplitude in grid";
    private String titleName = ": Maximum Wave Amplitude in run [cm]";
    private MostExtremaPanel mep;
    private MOSTMaxGrid sg;
    private VectorAttribute va;
    private MOSTMaxGrid uGrid = null;
    private MOSTMaxGrid vGrid = null;
    private SGTVector vector = null;
    private boolean showVectors = false;
    private boolean currentsInKnots = true;
    public static final int MAX_AMP = 0;
    public static final int MIN_AMP = 2;
    public static final int MAX_SPEED = 3;
    public static final int FLOW_DEPTH = 1;

    public SMaxImagePanel() {
        this.getLayer("bathy");
        this.getLayer("wet");
        this.getLayer("maxamp");
        this.getLayer("contour");
        this.getLayer("vectors");
        this.getLayer("point");
        this.infoLabel = new SGLabel("info label", "", 0.14, new Point2D.Double(this.xSize / 2.0, this.ySize - 0.36), 1, 1);
        this.addLabel(this.infoLabel);
        this.floodLabel = new SGLabel("flood label", "", 0.14, new Point2D.Double(this.xSize / 2.0, this.ySize - 0.47), 1, 1);
        this.addLabel(this.floodLabel);
        this.va = new VectorAttribute(0.0085, Color.black);
        this.va.setHeadScale(0.5);
        this.va.setVectorStyle(2);
        this.colorBar = new ColorBar(0);
        this.colorBar.setStringYOffset(3);
        this.colorBar.setBackground(Color.WHITE);
        this.cmapMax = ColorMaps.getDefaultSIFTColorMap();
        this.cmapMin = ColorMaps.createMinAmpMap();
        int[] r = new int[]{};
        int[] g = new int[]{};
        int[] b = new int[]{};
        this.cmapCurrents = new CurrentsColormap(r, g, b);
        this.cmap = this.cmapMax;
        this.colorBar.setColorMap(this.cmap);
        this.add((Component)this.colorBar, "East");
        this.extremum = 0;
        this.getPane().addMouseMotionListener(new lonLatMouseAdapter());
    }

    public void setMEP(MostExtremaPanel m) {
        this.mep = m;
    }

    public void setExtrema(int i) {
        int currentGridId = this.getGridSelectorControl().getSelectedGrid();
        this.extremum = i;
        switch (i) {
            case 0: {
                this.extremaName = "max_amp_";
                this.infoLabelPrefix = "Maximum amplitude in grid";
                this.titleName = ": Maximum Wave Amplitude in run [cm]";
                this.cmap = this.cmapMax;
                this.colorBar.setUnits("[cm]");
                this.colorBar.setCurrents(false);
                this.readGrid();
                break;
            }
            case 2: {
                this.extremaName = "min_amp_";
                this.infoLabelPrefix = "Minimum amplitude in grid";
                this.titleName = ": Minimum Wave Amplitude in run [cm]";
                this.cmap = this.cmapMin;
                this.colorBar.setUnits("[cm]");
                this.colorBar.setCurrents(false);
                this.readGrid();
                break;
            }
            case 3: {
                this.extremaName = "max_speed_";
                this.infoLabelPrefix = "Maximum speed in grid";
                if (this.currentsInKnots) {
                    this.titleName = ": Maximum Current Speed in run [knots]";
                    this.cmap = this.cmapCurrents;
                    this.titleName = ": Maximum Current Speed in run [knots]";
                    this.colorBar.setUnits("[knots]");
                    this.colorBar.setCurrents(true);
                } else {
                    this.cmap = this.cmapMax;
                    this.titleName = ": Maximum Current Speed in run [cm/s]";
                    this.colorBar.setUnits("[cm/s]");
                    this.colorBar.setCurrents(false);
                }
                this.readGrid();
                break;
            }
            case 1: {
                this.extremaName = "max_amp_";
                this.infoLabelPrefix = "Maximum flow depth in grid";
                this.titleName = ": Maximum Flow Depth in run [cm]";
                this.cmap = this.cmapMax;
                this.colorBar.setUnits("[cm]");
                this.colorBar.setCurrents(false);
                this.readGrid();
            }
        }
    }

    public int getExtrema() {
        return this.extremum;
    }

    public void showVectors() {
        this.showVectors = true;
    }

    public void hideVectors() {
        this.showVectors = false;
    }

    public void setVectorScale(double s) {
        this.va.setVectorScale(s);
    }

    @Override
    public void readGrid() {
        SiteInfo site = this.getCurrentSite();
        int currentGridId = this.getGridSelectorControl().getSelectedGrid();
        String varName = this.extremaName + BathyGrid.getGridLetter(currentGridId).toLowerCase();
        if (site == null) {
            this.clearData();
            return;
        }
        try {
            this.bathyGrid = site.getBathyGrid(this.getGridSelectorControl().getSelectedGrid());
            if (!this.bathyGrid.equals(this.displayedBathyGrid)) {
                this.addTopographyLayers(this.bathyGrid);
                this.addWetCellMask(this.bathyGrid);
                this.addCoastlineLayer(this.bathyGrid);
                this.displayedBathyGrid = this.bathyGrid;
            }
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.WARNING, "Error loading bathymetry: {0}", ex.getMessage());
            this.bathyGrid = null;
        }
        this.sg = new MOSTMaxGrid();
        boolean dataAvailable = this.sg.readData(site.getSiftOutputFile().getPath(), varName);
        if (dataAvailable) {
            if (this.extremum == 1) {
                this.calcFlowDepth(currentGridId, site);
            }
            if (this.extremum == 3 && this.currentsInKnots) {
                this.sg.currentsToKnots();
            }
            CartesianGraph mg = this.getCartesianGraph("maxamp");
            mg.setData(this.sg, new GridAttribute(0, this.cmap));
            this.colorBar.setColorMap(this.cmap);
            mg.setClip(this.sg.getXRange(), this.sg.getYRange());
            this.setZoom();
            SimplePoint sp = null;
            switch (this.extremum) {
                case 0: {
                    this.infoLabel.setText(String.format("%s: %.1f cm at lon: %.4f lat: %.4f", this.infoLabelPrefix, this.sg.getZRange().end, this.sg.getXOfMaxWave(), this.sg.getYOfMaxWave()));
                    sp = new SimplePoint(this.sg.getXOfMaxWave(), this.sg.getYOfMaxWave(), "max amp point");
                    break;
                }
                case 2: {
                    this.infoLabel.setText(String.format("%s: %.1f cm at lon: %.4f lat: %.4f", this.infoLabelPrefix, this.sg.getZRange().start, this.sg.getXOfMinWave(), this.sg.getYOfMinWave()));
                    sp = new SimplePoint(this.sg.getXOfMinWave(), this.sg.getYOfMinWave(), "max amp point");
                    break;
                }
                case 3: {
                    if (this.currentsInKnots) {
                        this.infoLabel.setText(String.format("%s: %.1f knots at lon: %.4f lat: %.4f", this.infoLabelPrefix, this.sg.getZRange().end, this.sg.getXOfMaxWave(), this.sg.getYOfMaxWave()));
                    } else {
                        this.infoLabel.setText(String.format("%s: %.1f cm/s at lon: %.4f lat: %.4f", this.infoLabelPrefix, this.sg.getZRange().end, this.sg.getXOfMaxWave(), this.sg.getYOfMaxWave()));
                    }
                    sp = new SimplePoint(this.sg.getXOfMaxWave(), this.sg.getYOfMaxWave(), "max amp point");
                    break;
                }
                case 1: {
                    this.infoLabel.setText(String.format("%s: %.1f cm at lon: %.4f lat: %.4f", this.infoLabelPrefix, this.sg.getZRange().end, this.sg.getXOfMaxWave(), this.sg.getYOfMaxWave()));
                    sp = new SimplePoint(this.sg.getXOfMaxWave(), this.sg.getYOfMaxWave(), "max amp point");
                }
            }
            this.infoLabel.setLocationP(new Point2D.Double(this.xSize / 2.0, this.ySize - 0.36));
            PointAttribute pa = new PointAttribute(20, Color.CYAN);
            pa.setMarkHeightP(0.2);
            pa.setMarkOutline(true);
            this.getCartesianGraph("point").setData(sp, pa);
            this.floodLabel.setLocationP(new Point2D.Double(this.xSize / 2.0, this.ySize - 0.47));
            this.floodLabel.setText(String.format("Maximum flooded area: %.2f km^2", this.sg.getInunArea()));
            if (this.showVectors) {
                this.uGrid = new MOSTMaxGrid();
                this.vGrid = new MOSTMaxGrid();
                boolean speeduvAvailable = this.uGrid.readData(site.getSiftOutputFile().getPath(), "max_speed_u_c");
                speeduvAvailable = this.vGrid.readData(site.getSiftOutputFile().getPath(), "max_speed_v_c");
                if (speeduvAvailable) {
                    this.vector = new SGTVector(this.uGrid, this.vGrid);
                    this.uGrid.subsampleToMaxSize(CMIUtil.maxNumArrows);
                    this.vGrid.subsampleToMaxSize(CMIUtil.maxNumArrows);
                    this.getCartesianGraph("vectors").setData(this.vector, this.va);
                } else {
                    this.getCartesianGraph("vectors").setRenderer(null);
                    this.uGrid = null;
                    this.vGrid = null;
                    this.vector = null;
                }
            } else {
                this.getCartesianGraph("vectors").setRenderer(null);
                this.uGrid = null;
                this.vGrid = null;
                this.vector = null;
            }
        } else {
            this.getCartesianGraph("maxamp").setRenderer(null);
            this.getCartesianGraph("point").setRenderer(null);
            this.infoLabel.setText("");
            this.floodLabel.setText("");
        }
        this.setTitle(site.getName() + this.titleName);
        this.plotBoxes();
        this.colorBar.repaint();
    }

    public double getMax() {
        return this.sg == null ? 1.0 : this.sg.getZRange().end;
    }

    private void calcFlowDepth(int currentGridId, SiteInfo site) {
        double[] grid = this.sg.getZArray();
        double[] bath = this.displayedBathyGrid.getZArray();
        File defFile = new File(site.getDirName(), "deform" + BathyGrid.getGridLetter(currentGridId).toLowerCase() + ".dat");
        double[] defbath = new double[bath.length];
        if (defFile.exists()) {
            try {
                BathyGrid defBathyGrid = new BathyGrid(defFile, true);
                defbath = defBathyGrid.getZArray();
            }
            catch (IOException ex) {
                SiftShare.log.log(Level.WARNING, "Error reading deform.dat bathy file to calc flow depth, using bathy grid", ex);
                for (int i = 0; i < bath.length; ++i) {
                    defbath[i] = bath[i];
                }
            }
        } else {
            SiftShare.log.fine("No deform[a|b|c].dat file found");
            for (int i = 0; i < bath.length; ++i) {
                defbath[i] = bath[i];
            }
        }
        if (grid.length == defbath.length && defbath.length == bath.length) {
            int i;
            int j;
            int nLon = this.sg.getXSize();
            int nLat = this.sg.getYSize();
            if (this.sg.isImage()) {
                for (j = 0; j < nLon; ++j) {
                    for (i = 0; i < nLat; ++i) {
                        if (!Double.isNaN(grid[j * nLat + i])) {
                            grid[j * nLat + i] = grid[j * nLat + i] - 100.0 * defbath[j * nLat + (nLat - i - 1)];
                        }
                        if (!(bath[j * nLat + (nLat - i - 1)] < 0.0)) continue;
                        grid[j * nLat + i] = Double.NaN;
                    }
                }
            } else {
                for (j = 0; j < nLon; ++j) {
                    for (i = 0; i < nLat; ++i) {
                        if (!Double.isNaN(grid[j * nLat + i])) {
                            grid[j * nLat + i] = grid[j * nLat + i] - 100.0 * defbath[j * nLat + i];
                        }
                        if (!(bath[j * nLat + i] < 0.0)) continue;
                        grid[j * nLat + i] = Double.NaN;
                    }
                }
            }
            double start = Double.POSITIVE_INFINITY;
            double end = Double.NEGATIVE_INFINITY;
            int maxJ = -1;
            int maxI = -1;
            int minJ = -1;
            int minI = -1;
            for (int j2 = 0; j2 < nLon; ++j2) {
                for (int i2 = 0; i2 < nLat; ++i2) {
                    if (grid[j2 * nLat + i2] < start) {
                        start = grid[j2 * nLat + i2];
                        minI = i2;
                        minJ = j2;
                    }
                    if (!(grid[j2 * nLat + i2] > end)) continue;
                    end = grid[j2 * nLat + i2];
                    maxI = i2;
                    maxJ = j2;
                }
            }
            this.sg.setMinMaxIndices(minI, maxI, minJ, maxJ, start, end);
        } else {
            SiftShare.log.severe("Flow Depth: wave amp, deformed bath not the same size as bath.");
        }
    }

    private void addWetCellMask(BathyGrid bg) {
        double[] z = bg.getZArray();
        int nz = z.length;
        double[] mask = new double[nz];
        for (int k = 0; k < nz; ++k) {
            mask[k] = z[k] > 0.001 ? Double.NaN : 1.0;
        }
        double[] xloc = Arrays.copyOf(bg.getXArray(), bg.getXSize());
        double[] yloc = Arrays.copyOf(bg.getYArray(), bg.getYSize());
        SimpleGrid maskGrid = new SimpleGrid(mask, xloc, yloc, "Wet Cell Mask");
        maskGrid.setXMetaData(new SGTMetaData());
        maskGrid.setYMetaData(new SGTMetaData());
        Color[] cmcolors = new Color[]{new Color(204, 204, 204), new Color(204, 204, 204)};
        IndexedColorMap cmcmap = new IndexedColorMap(cmcolors);
        cmcmap.setTransform(new LinearTransform(-1.0, 1000000.0, 0.0, 1.0));
        GridAttribute wcga = new GridAttribute(0, cmcmap);
        this.getCartesianGraph("wet").setData(maskGrid, wcga);
    }

    private void addTopographyLayers(BathyGrid bg) {
        double[] dv = new double[]{-1000.0, 5.0, 10.0, 30.0, 50.0, 100.0, 200.0, 400.0, 800.0, 1200.0, 1600.0, 2000.0, 2500.0, 3000.0, 3500.0, 4000.0};
        ContourLevels cl = new ContourLevels();
        for (int i = 0; i < dv.length; ++i) {
            if (i == 0) {
                cl.addLevel(dv[i], new ContourLineAttribute(0, new Color(0, 0, 0, 0)));
                continue;
            }
            cl.addLevel(dv[i], new ContourLineAttribute(0, Color.black));
        }
        GridAttribute bga = new GridAttribute(cl);
        DefaultContourLineAttribute dcla = cl.getDefaultContourLineAttribute();
        dcla.setStyle(0);
        dcla.setColor(new Color(0, 0, 0, 64));
        dcla.setLabelColor(new Color(0, 0, 0, 64));
        dcla.setLabelHeightP(0.15);
        dcla.setLabelFont(CONTOUR_LABEL_FONT);
        dcla.setWidth(0.15f);
        EnumeratedColorMap mp = ColorMaps.getTopographyPalm_Springs_5ColorMap();
        mp.setEnumeratedValues(dv);
        bga.setColorMap(mp);
        int s = bg.getXSize() * bg.getYSize();
        if (s > MAX_GRID_DISPLAY_SIZE * MAX_GRID_DISPLAY_SIZE) {
            mp.setColor(0, mp.getColor(1));
            bga.setStyle(0);
        } else {
            bga.setStyle(4);
        }
        this.setAxes(bg);
        this.getCartesianGraph("bathy").setData(bg, bga);
    }

    private void addCoastlineLayer(BathyGrid bg) {
        double[] x = bg.getXArray();
        double[] y = bg.getYArray();
        int nx = x.length;
        int ny = y.length;
        double[] xEdge = new double[nx + 1];
        double[] yEdge = new double[ny + 1];
        for (int i = 1; i < nx; ++i) {
            xEdge[i] = (x[i - 1] + x[i]) * 0.5;
        }
        for (int j = 1; j < ny; ++j) {
            yEdge[j] = (y[j - 1] + y[j]) * 0.5;
        }
        xEdge[0] = x[0] + 0.5 * (x[0] - x[1]);
        xEdge[xEdge.length - 1] = x[nx - 1] - 0.5 * (x[nx - 2] - x[nx - 1]);
        yEdge[0] = y[0] + 0.5 * (y[0] - y[1]);
        yEdge[yEdge.length - 1] = y[ny - 1] - 0.5 * (y[ny - 2] - y[ny - 1]);
        double zc = 0.001;
        double[] z = bg.getZArray();
        int[][] c = new int[nx][ny];
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                double val = z[j + i * ny];
                c[i][j] = Double.isNaN(val) ? -1 : (zc >= val ? 1 : -1);
            }
        }
        int count = 0;
        double[] xc = new double[3 * (2 * nx * ny + nx + ny)];
        double[] yc = new double[3 * (2 * nx * ny + nx + ny)];
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                if (i < nx - 1 && c[i][j] + c[i + 1][j] == 0) {
                    xc[count] = xEdge[i + 1];
                    yc[count] = yEdge[j];
                    xc[count + 1] = xEdge[i + 1];
                    yc[count + 1] = yEdge[j + 1];
                    xc[count + 2] = Double.NaN;
                    yc[count + 2] = Double.NaN;
                    count += 3;
                }
                if (j >= ny - 1 || c[i][j] + c[i][j + 1] != 0) continue;
                xc[count] = xEdge[i + 1];
                yc[count] = yEdge[j + 1];
                xc[count + 1] = xEdge[i];
                yc[count + 1] = yEdge[j + 1];
                xc[count + 2] = Double.NaN;
                yc[count + 2] = Double.NaN;
                count += 3;
            }
        }
        LineAttribute lAttr = new LineAttribute();
        lAttr.setColor(Color.black);
        lAttr.setStyle(6);
        float[] dashes = new float[]{12.0f};
        lAttr.setDashArray(dashes);
        lAttr.setCapStyle(1);
        double[] xout = Arrays.copyOf(xc, count);
        double[] yout = Arrays.copyOf(yc, count);
        SimpleLine line = new SimpleLine(xout, yout, "Coastline");
        this.getCartesianGraph("contour").setData(line, lAttr);
    }

    public void showTopography(boolean b) {
        if (b) {
            this.addTopographyLayers(this.displayedBathyGrid);
            this.titleLabel.setColor(Color.BLACK);
        } else {
            this.getCartesianGraph("bathy").setRenderer(null);
            this.titleLabel.setColor(new Color(1, 1, 1));
        }
    }

    public void showCoastline(boolean b) {
        if (b) {
            this.addCoastlineLayer(this.displayedBathyGrid);
            this.titleLabel.setColor(Color.BLACK);
        } else {
            this.getCartesianGraph("contour").setRenderer(null);
            this.titleLabel.setColor(new Color(1, 1, 1));
        }
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = super.createPopupMenu();
        menu.add(new SaveGISAction("Save as ASCII Raster file", 1));
        menu.add(new SaveGISAction("Save as GeoTiff Raster file", 0));
        JRadioButtonMenuItem mi = new JRadioButtonMenuItem(new AbstractAction("Currents in knots"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SMaxImagePanel.this.ToggleCurrentsInKnots();
            }
        });
        mi.setSelected(this.currentsInKnots);
        menu.add(mi);
        return menu;
    }

    private void ToggleCurrentsInKnots() {
        this.currentsInKnots = !this.currentsInKnots;
        this.setExtrema(this.extremum);
        this.updateResults();
    }

    public void saveImageAsGIS(int type) {
        block14: {
            String fn = this.extremaName;
            if (this.extremum == 1) {
                fn = "flow_depth_";
            }
            String filename = CMIUtil.currentSiteInfo.getName() + fn + BathyGrid.getGridLetter(this.getGridSelectorControl().getSelectedGrid()).toLowerCase();
            JFileChooser chooser = new JFileChooser(CMIUtil.workingDirName);
            switch (type) {
                case 0: {
                    chooser.setDialogTitle("Save as GeoTIFF Raster (.tif)");
                    chooser.setFileFilter(new FileNameExtensionFilter("GIS GeoTiff files", ".tif"));
                    filename = filename + ".tif";
                    break;
                }
                case 1: {
                    chooser.setDialogTitle("Save as ASCII Raster (.asc)");
                    chooser.setFileFilter(new FileNameExtensionFilter("GIS ASCII raster files", ".asc"));
                    filename = filename + ".asc";
                }
            }
            File f = new File(CMIUtil.workingDirName, filename);
            chooser.setSelectedFile(f);
            int result = chooser.showSaveDialog(this);
            if (result == 0) {
                int overwrite;
                if (chooser.getSelectedFile().exists() && (overwrite = JOptionPane.showConfirmDialog(this, "File exists, overwrite?", "File exists", 1)) != 0) {
                    return;
                }
                if (type == 0) {
                    try {
                        if (this.extremum == 1) {
                            File nfn = new File(chooser.getSelectedFile().getPath().replaceFirst("[.][^.]+$", "") + ".nc");
                            this.sg.saveFlowDepthAsNetCDF(nfn);
                            this.sg.saveAsGeoTIFF(nfn, "flow_depth", chooser.getSelectedFile());
                            break block14;
                        }
                        File nfn = new File(chooser.getSelectedFile().getPath().replaceFirst("[.][^.]+$", "") + ".nc");
                        SiftShare.log.info("file chosen: " + chooser.getSelectedFile().getPath() + " file to save: " + nfn);
                        this.sg.copyNetCDFforGIS(nfn);
                        this.sg.saveAsGeoTIFF(nfn, this.sg.getVarName(), chooser.getSelectedFile());
                    }
                    catch (IOException ex) {
                        JOptionPane.showConfirmDialog(this, "Error creating file.\nNon-constant grid spacing not supported.", "Error creating GIS file", 2, 0);
                        SiftShare.log.log(Level.SEVERE, null, ex);
                    }
                } else {
                    try {
                        this.sg.saveAsASCIIRaster2(chooser.getSelectedFile());
                    }
                    catch (IOException ex) {
                        JOptionPane.showConfirmDialog(this, "Error creating file.\nGrid spacing in lat and lon differ.\nConsider saving as GeoTIFF.", "Error creating GIS file", 2, 0);
                        SiftShare.log.log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    @Override
    public void saveImageToFile() {
        String fn = this.extremaName;
        if (this.extremum == 1) {
            fn = "flow_depth_";
        }
        String filename = CMIUtil.currentSiteInfo.getName() + fn + BathyGrid.getGridLetter(this.getGridSelectorControl().getSelectedGrid()).toLowerCase() + ".png";
        JFileChooser chooser = new JFileChooser(CMIUtil.workingDirName);
        chooser.setDialogTitle("Save image as (.png)");
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                int idx = name.lastIndexOf(46);
                return idx > 0 && name.substring(idx + 1, name.length()).equals("png");
            }

            @Override
            public String getDescription() {
                return "PNG Files";
            }
        });
        File f = new File(CMIUtil.workingDirName, filename);
        chooser.setSelectedFile(f);
        int result = chooser.showSaveDialog(this);
        if (result == 0) {
            if (chooser.getSelectedFile().exists()) {
                int overwrite = JOptionPane.showConfirmDialog(chooser, "File exists, overwrite?", "File exists", 1);
                if (overwrite == 0) {
                    this.savePanelImage(chooser.getSelectedFile(), false, true, true);
                }
            } else {
                this.savePanelImage(chooser.getSelectedFile(), false, true, true);
            }
        }
    }

    @Override
    public void clearData() {
        this.displayedBathyGrid = null;
        super.clearData();
    }

    @Override
    public void modelStarted(final ModelEvent me) {
        CMIUtil.runOnDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (me.getSourceModel().equals(SMaxImagePanel.this.getCurrentSite())) {
                    SMaxImagePanel.this.clearData();
                }
            }
        });
    }

    @Override
    public void modelUpdate(final ModelEvent me) {
        CMIUtil.runOnDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (me.getSourceModel().equals(SMaxImagePanel.this.getCurrentSite()) && me.getStatus() == 101) {
                    SMaxImagePanel.this.updateResults();
                }
            }
        });
    }

    @Override
    public void modelStopped(final ModelEvent me) {
        CMIUtil.runOnDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (me.getTimesteps() == 0) {
                    SiftShare.log.fine("rec modelStopped");
                    SMaxImagePanel.this.clearData();
                }
            }
        });
    }

    private class lonLatMouseAdapter
    extends MouseAdapter {
        private lonLatMouseAdapter() {
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            Layer layer = SMaxImagePanel.this.getLayer("maxamp");
            CartesianGraph graph = SMaxImagePanel.this.getCartesianGraph("amp");
            double x = graph.getXPtoU(layer.getXDtoP(event.getX()));
            double y = graph.getYPtoU(layer.getYDtoP(event.getY()));
            double z = SMaxImagePanel.this.sg.getValueAt(x, y);
            double d = SMaxImagePanel.this.bathyGrid.getValueAt(x, y);
            SMaxImagePanel.this.mep.setLongitude(x);
            SMaxImagePanel.this.mep.setLatitude(y);
            SMaxImagePanel.this.mep.setExtrema(z);
            SMaxImagePanel.this.mep.setDepth(d);
        }
    }

    private class SaveGISAction
    extends AbstractAction {
        public static final int GeoTIFF = 0;
        public static final int ASCII = 1;
        private int type;

        public SaveGISAction(String text, int type) {
            super(text);
            this.type = -1;
            this.type = type;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SMaxImagePanel.this.saveImageAsGIS(this.type);
        }
    }
}

