/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.LatitudeAxis;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.LongitudeAxis;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.dm.SimpleLine;
import gov.noaa.pmel.sgt.dm.SimplePoint;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.ColorBar;
import gov.noaa.tsunami.cmi.ColorMaps;
import gov.noaa.tsunami.cmi.EnumeratedColorMap;
import gov.noaa.tsunami.cmi.GeoGrid2D;
import gov.noaa.tsunami.cmi.MOSTGrid;
import gov.noaa.tsunami.cmi.MOSTMaxGrid;
import gov.noaa.tsunami.cmi.ModelEvent;
import gov.noaa.tsunami.cmi.ModelListener;
import gov.noaa.tsunami.cmi.PropInfo;
import gov.noaa.tsunami.cmi.ResultGraphicsPanel;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.websift.propdb.Point3D;
import gov.noaa.tsunami.websift.propdb.UnitSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.filechooser.FileFilter;

public final class SPropAnimPanel
extends JPanel
implements PropertyChangeListener,
ModelListener {
    private final SGLabel timeLabel;
    private MOSTGrid mostGrid = null;
    private MOSTMaxGrid mostMaxGrid = null;
    private BathyGrid bathyGrid = null;
    private PropInfo propInfo = new PropInfo("test");
    private boolean maxAmpOnly = false;
    private boolean plotContours = false;
    private int timeStep;
    private static final GregorianCalendar calendar = new GregorianCalendar(0, 0, 0, 0, 0, 0);
    private static final SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
    private static final int CMLINEAR = 0;
    private static final int CMLOG = 1;
    private static final int CMMAX = 2;
    private int colorMapType = 0;
    private boolean updateRequired = false;
    private final JPane jPane;
    protected final Map<String, Layer> layers = new LinkedHashMap<String, Layer>();
    private final LinearTransform xt;
    private final LinearTransform yt;
    private SimplePoint sp;
    private PointAttribute pa;
    private SimpleLine sl;
    private LineAttribute la;
    protected final SGLabel titleLabel;
    private final LatitudeAxis yAxis = new LatitudeAxis();
    private final LatitudeAxis yAxisRight = new LatitudeAxis();
    private final LongitudeAxis xAxis = new LongitudeAxis();
    private final LongitudeAxis xAxisTop = new LongitudeAxis();
    protected ColorBar colorBar = null;
    public static final double marginLeft = 0.5;
    public static final double marginRight = 0.3;
    public static final double marginTop = 0.7;
    public static final double marginBottom = 0.55;
    protected double xSize = 8.0;
    protected double xMin = 0.5;
    protected double xMax = 7.7;
    protected double ySize = 6.0;
    protected double yMin = 0.55;
    protected double yMax = 5.3;
    public static final Font AXIS_FONT = new Font("SansSerif", 0, 12);
    public static final double AXIS_LABEL_PHEIGHT = 0.16;
    protected static final double CONTOUR_LABEL_PHEIGHT = 0.15;
    public static final Font CONTOUR_LABEL_FONT = new Font("SansSerif", 0, 14);
    protected static int MAX_GRID_DISPLAY_SIZE = 20;
    protected int extremum = 1;
    protected static final EnumeratedColorMap cmap = ColorMaps.createRedBlueMap();
    protected static final GridAttribute ga = new GridAttribute(0, cmap);
    protected static final EnumeratedColorMap cmapm = ColorMaps.createRachelMapLarge();
    protected static final GridAttribute gma = new GridAttribute(0, cmapm);
    private SoTRange xZoomRange;
    private SoTRange yZoomRange;

    public SPropAnimPanel() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.jPane = new JPane(this.getClass().getName(), new Dimension(800, 600));
        this.jPane.setOpaque(true);
        this.jPane.setLayout(new StackedLayout());
        this.xZoomRange = new SoTRange.Double(10.0, 20.0);
        this.yZoomRange = new SoTRange.Double(40.0, 80.0);
        SoTPoint origin = new SoTPoint(this.xZoomRange.getStart(), this.yZoomRange.getStart());
        this.xt = new LinearTransform(new Range2D(this.xMin, this.xMax), this.xZoomRange);
        this.yt = new LinearTransform(new Range2D(this.yMin, this.yMax), this.yZoomRange);
        this.add((Component)this.jPane, "Center");
        this.jPane.addMouseListener(new MyMouseAdapter(this));
        this.jPane.addPropertyChangeListener(this);
        this.titleLabel = new SGLabel("title", "test", 0.22, new Point2D.Double(this.xSize / 2.0, this.ySize - 0.16), 1, 1);
        this.addLabel(this.titleLabel);
        CartesianGraph axgraph = this.getCartesianGraph("base");
        this.xAxis.setRangeU(this.xZoomRange);
        this.xAxis.setNumberSmallTics(0);
        this.xAxis.setLocationU(origin);
        this.xAxis.setLabelHeightP(0.16);
        this.xAxis.setLabelFont(AXIS_FONT);
        this.xAxis.setSignificantDigits(3);
        this.xAxisTop.setRangeU(this.xZoomRange);
        this.xAxisTop.setNumberSmallTics(0);
        this.xAxisTop.setTicPosition(1);
        this.xAxisTop.setLocationU(new SoTPoint(this.xZoomRange.getStart(), this.yZoomRange.getEnd()));
        this.xAxisTop.setLabelPosition(2);
        this.xAxis.register(this.xAxisTop);
        this.yAxis.setRangeU(this.yZoomRange);
        this.yAxis.setNumberSmallTics(0);
        this.yAxis.setLocationU(origin);
        this.yAxis.setLabelHeightP(0.16);
        this.yAxis.setLabelFont(AXIS_FONT);
        this.yAxis.setSignificantDigits(3);
        this.yAxisRight.setRangeU(this.yZoomRange);
        this.yAxisRight.setNumberSmallTics(0);
        this.yAxisRight.setLocationU(new SoTPoint(this.xZoomRange.getEnd(), this.yZoomRange.getStart()));
        this.yAxisRight.setTicPosition(1);
        this.yAxisRight.setLabelPosition(2);
        this.yAxis.register(this.yAxisRight);
        axgraph.addXAxis(this.xAxis);
        axgraph.addXAxis(this.xAxisTop);
        axgraph.addYAxis(this.yAxis);
        axgraph.addYAxis(this.yAxisRight);
        this.getLayer("topo");
        this.getLayer("amp");
        this.getLayer("tslayer");
        this.getLayer("faultboxes");
        this.timeLabel = new SGLabel("time label", "", 0.15, new Point2D.Double(this.xSize / 2.0, this.ySize - 0.19), 1, 1);
        this.timeLabel.setFont(AXIS_FONT);
        this.addLabel(this.timeLabel);
        this.sp = new SimplePoint(0.0, 0.0, "tspt");
        this.pa = new PointAttribute(52, Color.YELLOW);
        this.pa.setMarkHeightP(0.3);
        this.pa.setMarkOutlineColor(Color.BLACK);
        this.pa.setMarkOutline(true);
        this.getCartesianGraph("tslayer").setData(this.sp, this.pa);
        this.sl = new SimpleLine(new double[]{10.0, 12.0}, new double[]{8.0, 9.0}, "box");
        this.la = new LineAttribute(0, Color.BLACK);
        this.getCartesianGraph("faultboxes").setData(this.sl, this.la);
        this.colorBar = new ColorBar(0);
        this.colorBar.setBackground(Color.WHITE);
        this.colorBar.setStringYOffset(3);
        this.setColorMapLog();
        this.add((Component)this.colorBar, "East");
    }

    public void setPropInfo(PropInfo pi) {
        SiftShare.log.fine("in setPropInfo: " + pi);
        this.propInfo = pi;
        if (this.bathyGrid == null || !this.bathyGrid.getFilePath().equals(this.propInfo.getBathyFilePath())) {
            if (this.bathyGrid != null) {
                SiftShare.log.info("bgfn: " + this.bathyGrid.getFilePath() + " pifn: " + this.propInfo.getBathyFilePath());
            }
            try {
                this.bathyGrid = new BathyGrid(new File(this.propInfo.getBathyFilePath()));
                this.bathyGrid.subsampleToMaxSize(ResultGraphicsPanel.MAX_GRID_DISPLAY_SIZE);
                double[] dv = new double[]{0.001, 0.01, 5.0, 10.0, 15.0, 20.0, 25.0, 50.0, 75.0, 100.0, 200.0, 300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0, 1000.0, 1500.0, 2000.0};
                EnumeratedColorMap mp = ColorMaps.getTopographyPalm_Springs_5ColorMap();
                mp.setEnumeratedValues(dv);
                ContourLevels cl = ContourLevels.getDefault(mp.getValues());
                GridAttribute tga = new GridAttribute(cl);
                tga.setColorMap(mp);
                tga.setStyle(0);
                this.getCartesianGraph("topo").setData(this.bathyGrid, tga);
                this.getCartesianGraph("topo").setClip(this.bathyGrid.getXRange(), this.bathyGrid.getYRange());
                this.setAxes(this.bathyGrid);
            }
            catch (IOException ex) {
                SiftShare.log.log(Level.SEVERE, "Error reading bathyGrid", ex);
            }
        }
        this.setEpicenter(this.propInfo.getEpLon(), this.propInfo.getEpLat());
        UnitSource us = this.propInfo.getUnitSource();
        Point3D[] pts = us.createBoxOutline();
        double[] xlocs = new double[pts.length + 1];
        double[] ylocs = new double[pts.length + 1];
        for (int i = 0; i < pts.length; ++i) {
            xlocs[i] = pts[i].x;
            ylocs[i] = pts[i].y;
        }
        xlocs[pts.length] = pts[0].x;
        ylocs[pts.length] = pts[0].y;
        this.sl.setXArray(xlocs);
        this.sl.setYArray(ylocs);
    }

    public JPane getPane() {
        return this.jPane;
    }

    protected final void addLabel(SGLabel lbl) {
        this.getLayer("base").addChild(lbl);
    }

    protected Layer getLayer(String layerName) {
        Layer lyr = this.layers.get(layerName);
        if (lyr != null) {
            return lyr;
        }
        lyr = new Layer(layerName, new Dimension2D(this.xSize, this.ySize));
        this.layers.put(layerName, lyr);
        this.jPane.add((Component)lyr, this.layers.size());
        this.updateRequired = true;
        CartesianGraph graph = new CartesianGraph(layerName + " graph");
        graph.setXTransform(this.xt);
        graph.setYTransform(this.yt);
        lyr.setGraph(graph);
        return lyr;
    }

    protected final CartesianGraph getCartesianGraph(String layerName) {
        Layer lyr = this.getLayer(layerName);
        return (CartesianGraph)lyr.getGraph();
    }

    public void clearData() {
        this.getCartesianGraph("amp").setRenderer(null);
        this.updateResults(false);
        this.closeFile();
        this.updatePlotLabels();
    }

    public void readGrid() {
        this.closeFile();
        GeoGrid2D axGrd = null;
        if (this.maxAmpOnly) {
            this.mostMaxGrid = new MOSTMaxGrid();
            axGrd = this.mostMaxGrid.readData(this.propInfo.getHaFileName(), "max_height") ? this.mostMaxGrid : this.bathyGrid;
            this.getCartesianGraph("amp").setData(this.mostMaxGrid, gma);
            this.setColorMapMax();
        } else {
            this.mostGrid = new MOSTGrid(this.propInfo.getHaFileName());
            axGrd = this.mostGrid.readData(this.timeStep) ? this.mostGrid : this.bathyGrid;
            this.getCartesianGraph("amp").setData(this.mostGrid, ga);
            this.setColorMapLog();
        }
        this.getCartesianGraph("amp").setClip(axGrd.getXRange(), axGrd.getYRange());
        this.getCartesianGraph("topo").setClip(axGrd.getXRange(), axGrd.getYRange());
        this.setAxes(axGrd);
        this.updatePlotLabels();
        this.colorBar.repaint();
    }

    void setMaxAmp(boolean b) {
        this.maxAmpOnly = b;
    }

    public synchronized void updateResults(boolean alwaysUpdate) {
        if (alwaysUpdate || this.isShowing()) {
            this.readGrid();
            this.updateRequired = false;
        } else {
            this.clearData();
            this.updateRequired = true;
        }
    }

    public void updateResults() {
        this.updateResults(false);
    }

    protected void setAxes(SGTGrid grid) {
        double yPlotSize;
        double xPlotSize;
        SoTPoint origin = new SoTPoint(grid.getXRange().getStart(), grid.getYRange().getStart());
        this.xZoomRange = grid.getXRange();
        this.yZoomRange = grid.getYRange();
        this.xAxis.setRangeU(grid.getXRange());
        this.xAxis.setLocationU(origin);
        this.xAxisTop.setLocationU(new SoTPoint(origin.getX(), grid.getYRange().getEnd()));
        this.yAxis.setRangeU(grid.getYRange());
        this.yAxis.setLocationU(origin);
        this.yAxisRight.setLocationU(new SoTPoint(grid.getXRange().getEnd(), origin.getY()));
        SoTRange xr = grid.getXRange();
        SoTRange yr = grid.getYRange();
        double lons = xr.getStart().getDouble();
        double lone = xr.getEnd().getDouble();
        double lats = yr.getStart().getDouble();
        double late = yr.getEnd().getDouble();
        double xext = Math.abs(lons - lone) * 111320.0 * Math.cos(Math.abs(late + lats) / 2.0 * Math.PI / 180.0);
        double yext = Math.abs(lats - late) * 111320.0;
        if (xext > yext) {
            xPlotSize = 8.0;
            yPlotSize = 8.0 * yext / xext;
        } else {
            yPlotSize = 8.0;
            xPlotSize = 8.0 * xext / yext;
        }
        this.xSize = xPlotSize + 0.5 + 0.3;
        this.ySize = yPlotSize + 0.7 + 0.55;
        this.xMin = 0.5;
        this.xMax = xPlotSize + 0.5;
        this.yMin = 0.55;
        this.yMax = yPlotSize + 0.55;
        for (String key : this.layers.keySet()) {
            this.layers.get(key).setSizeP(new Dimension2D(this.xSize, this.ySize));
        }
        this.xt.setRangeP(this.xMin, this.xMax);
        this.yt.setRangeP(this.yMin, this.yMax);
        this.xt.setRangeU(grid.getXRange());
        this.yt.setRangeU(grid.getYRange());
        this.titleLabel.setLocationP(new Point2D.Double(this.xSize / 2.0, this.ySize - 0.16));
    }

    private void updatePlotLabels() {
        if (this.maxAmpOnly) {
            this.titleLabel.setText(this.propInfo.getName() + ": Max Wave Amplitude [cm]");
        } else {
            this.titleLabel.setText(this.propInfo.getName() + ": Wave Amplitude [cm]");
        }
        this.timeLabel.setLocationP(new Point2D.Double(this.xSize / 2.0, this.ySize - 0.33));
        this.updateTimeLabel();
    }

    public void setEpicenter(double lon, double lat) {
        this.sp.setX(lon);
        this.sp.setY(lat);
    }

    public Point2D.Double getEpicenter() {
        return new Point2D.Double(this.sp.getX(), this.sp.getY());
    }

    public MOSTGrid getMostGrid() {
        return this.mostGrid;
    }

    public void setZoom(SoTRange xRange, SoTRange yRange) {
        this.xZoomRange = xRange;
        this.yZoomRange = yRange;
        this.jPane.setBatch(true);
        SoTPoint origin = new SoTPoint(xRange.getStart(), yRange.getStart());
        this.xt.setRangeU(xRange);
        this.xAxis.setRangeU(xRange);
        this.xAxis.setLocationU(origin);
        this.xAxisTop.setLocationU(new SoTPoint(origin.getX(), yRange.getEnd()));
        this.yt.setRangeU(yRange);
        this.yAxis.setRangeU(yRange);
        this.yAxis.setLocationU(origin);
        this.yAxisRight.setLocationU(new SoTPoint(xRange.getEnd(), origin.getY()));
        for (String lyrName : this.layers.keySet()) {
            this.getCartesianGraph(lyrName).setClip(xRange, yRange);
        }
        this.jPane.setBatch(false);
    }

    public void setZoom() {
        this.setZoom(this.xZoomRange, this.yZoomRange);
    }

    public void setZoom(Range2D xr, Range2D yr) {
        this.setZoom(new SoTRange.Double(xr.start, xr.end), new SoTRange.Double(yr.start, yr.end));
    }

    private String eventHours(int t) {
        String result = null;
        calendar.clear();
        calendar.set(13, (int)this.mostGrid.getTime(t));
        result = df.format(calendar.getTime());
        return result;
    }

    public void closeFile() {
        if (this.mostGrid != null) {
            this.mostGrid.close();
        }
    }

    public void showTopography(boolean b) {
        if (b) {
            this.getPane().add((Component)this.getLayer("topo"), 0);
            this.titleLabel.setColor(Color.BLACK);
            ga.setColorMap(cmap);
            this.colorBar.setColorMap(cmap);
            this.colorBar.invalidate();
        } else {
            this.getPane().remove(this.getLayer("topo"));
        }
    }

    public void saveImageToFile() {
        String filename = this.propInfo.getName() + ".png";
        JFileChooser chooser = new JFileChooser(CMIUtil.workingDirName);
        chooser.setDialogTitle("Save image as (.png)");
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                int idx = name.lastIndexOf(46);
                return idx > 0 && name.substring(idx + 1, name.length()).equals("png");
            }

            @Override
            public String getDescription() {
                return "PNG Files";
            }
        });
        File f = new File(CMIUtil.workingDirName, filename);
        chooser.setSelectedFile(f);
        int result = chooser.showSaveDialog(this);
        if (result == 0) {
            if (chooser.getSelectedFile().exists()) {
                int overwrite = JOptionPane.showConfirmDialog(chooser, "File exists, overwrite?", "File exists", 1);
                if (overwrite == 0) {
                    this.savePanelImage(chooser.getSelectedFile());
                }
            } else {
                this.savePanelImage(chooser.getSelectedFile());
            }
        }
    }

    public void savePanelImage(File f) {
        int width = this.getWidth();
        int height = this.getHeight();
        BufferedImage image = new BufferedImage(width += this.colorBar.getWidth(), height, 1);
        Graphics2D g2 = image.createGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, width, height);
        this.jPane.draw(g2);
        BufferedImage cbimage = new BufferedImage(this.colorBar.getWidth(), this.colorBar.getHeight(), 1);
        Graphics2D g2cb = cbimage.createGraphics();
        g2cb.setColor(Color.WHITE);
        g2cb.fillRect(0, 0, this.colorBar.getWidth(), this.colorBar.getHeight());
        this.colorBar.DrawColorBar(g2cb);
        g2.setClip(0, 0, width, height);
        g2.drawImage((Image)cbimage, this.getWidth(), 0, this);
        g2.dispose();
        try {
            ImageIO.write((RenderedImage)image, "png", f);
        }
        catch (IOException ioe) {
            SiftShare.log.log(Level.WARNING, "error", ioe);
        }
    }

    public void saveColorbarImage(File f, boolean whiteToTransparent) {
        if (this.colorBar == null) {
            SiftShare.log.warning("Attempting to save colorBar image... colorBar==null");
            return;
        }
        BufferedImage image = (BufferedImage)this.colorBar.createImage(this.colorBar.getWidth(), this.colorBar.getHeight());
        Graphics2D g2 = image.createGraphics();
        this.colorBar.DrawColorBar(g2);
        try {
            ImageIO.write((RenderedImage)image, "png", f);
        }
        catch (IOException ioe) {
            SiftShare.log.log(Level.WARNING, "error", ioe);
        }
    }

    public void setColorMapDefault() {
        EnumeratedColorMap ecm = ColorMaps.createRedBlueMap51();
        double[] vals = new double[]{-6.25, -6.0, -5.75, -5.5, -5.25, -5.0, -4.75, -4.5, -4.25, -4.0, -3.75, -3.5, -3.25, -3.0, -2.75, -2.5, -2.25, -2.0, -1.75, -1.5, -1.25, -1.0, -0.75, -0.5, -0.25, 0.0, 0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 1.75, 2.0, 2.25, 2.5, 2.75, 3.0, 3.25, 3.5, 3.75, 4.0, 4.25, 4.5, 4.75, 5.0, 5.25, 5.5, 5.75, 6.0, 6.25};
        ecm.setEnumeratedValues(vals);
        this.setColorMap(ecm);
        this.colorMapType = 0;
    }

    public void setColorMapLog() {
        EnumeratedColorMap c = ColorMaps.createRedBlueMap31();
        double[] vals = new double[]{-1000.0, -500.0, -200.0, -100.0, -50.0, -20.0, -10.0, -5.0, -2.0, -1.0, -0.5, -0.2, -0.1, -0.05, -0.02, -0.01, 0.0, 0.01, 0.02, 0.05, 0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0, 1000.0};
        c.setEnumeratedValues(new double[]{-500.0, -200.0, -100.0, -50.0, -20.0, -10.0, -5.0, -2.0, -1.0, -0.5, -0.2, -0.1, -0.05, -0.02, -0.01, 0.0, 0.01, 0.02, 0.05, 0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0});
        this.setColorMap(c);
        this.colorMapType = 1;
    }

    public void setColorMapMax() {
        double[] vals = new double[320];
        vals[0] = 0.0;
        double mm = this.propInfo.getUnitSource().getMagnitude();
        double maxLimit = 0.0;
        maxLimit = mm > 8.5 ? 500.0 : (mm > 7.7 ? 200.0 : (mm > 7.0 ? 25.0 : 10.0));
        for (int i = 1; i < vals.length; ++i) {
            vals[i] = vals[i - 1] + maxLimit / 320.0;
        }
        cmapm.setEnumeratedValues(vals);
        this.colorBar.setColorMap(cmapm);
        this.colorMapType = 2;
    }

    public void setColorMap(EnumeratedColorMap cm) {
        ga.setColorMap(cm);
        this.colorBar.setColorMap(cm);
        this.colorBar.invalidate();
        this.colorBar.repaint();
    }

    private void updateTimeLabel() {
        if (this.mostGrid == null) {
            return;
        }
        if (this.maxAmpOnly) {
            this.timeLabel.setText("");
        } else {
            int tscount = this.mostGrid.getNumberOfTimeSteps();
            String ttl = tscount > 0 ? String.format("Time step: %d of %d   ---   hrs:min:sec after event: %s", this.timeStep + 1, tscount, this.eventHours(this.timeStep)) : "";
            this.timeLabel.setText(ttl);
        }
    }

    public void resetZoom() {
        if (this.bathyGrid != null) {
            this.setZoom(this.bathyGrid.getXRange(), this.bathyGrid.getYRange());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propname = event.getPropertyName();
        if ("timeStep".equals(propname)) {
            this.timeStep = ((Number)event.getNewValue()).intValue();
            --this.timeStep;
            try {
                if (this.mostGrid != null && !this.maxAmpOnly) {
                    this.mostGrid.loadTimeStep(this.timeStep);
                }
            }
            catch (IOException ex) {
                SiftShare.log.log(Level.WARNING, null, ex);
            }
            this.updateTimeLabel();
        } else if ("zoomRectangle".equals(propname)) {
            double temp;
            Range2D xr = new Range2D();
            Range2D yr = new Range2D();
            Rectangle zm = (Rectangle)event.getNewValue();
            CartesianGraph graph = this.getCartesianGraph("base");
            Layer layer = this.getLayer("base");
            if (zm.width <= 1 || zm.height <= 1) {
                return;
            }
            xr.start = graph.getXPtoU(layer.getXDtoP(zm.x));
            xr.end = graph.getXPtoU(layer.getXDtoP(zm.x + zm.width));
            if (xr.start > xr.end) {
                temp = xr.start;
                xr.start = xr.end;
                xr.end = temp;
            }
            yr.start = graph.getYPtoU(layer.getYDtoP(zm.y));
            yr.end = graph.getYPtoU(layer.getYDtoP(zm.y + zm.height));
            if (yr.start > yr.end) {
                temp = yr.start;
                yr.start = yr.end;
                yr.end = temp;
            }
            this.setZoom(xr, yr);
        }
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new ResetMeZoomAction("Reset Zoom"));
        menu.add(new SaveImageAction("Save as Image"));
        JRadioButtonMenuItem citem = new JRadioButtonMenuItem(new AbstractAction("Linear Scale Colormap"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SPropAnimPanel.this.setColorMapDefault();
            }
        });
        JRadioButtonMenuItem ritem = new JRadioButtonMenuItem(new AbstractAction("Log Scale Colormap"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SPropAnimPanel.this.setColorMapLog();
            }
        });
        if (!this.maxAmpOnly) {
            ButtonGroup bg = new ButtonGroup();
            citem.setSelected(this.colorMapType == 0);
            ritem.setSelected(this.colorMapType == 1);
            bg.add(citem);
            bg.add(ritem);
            menu.addSeparator();
            menu.add(citem);
            menu.add(ritem);
        }
        menu.addSeparator();
        return menu;
    }

    @Override
    public void modelStarted(ModelEvent me) {
        CMIUtil.runOnDispatchThread(new Runnable(){

            @Override
            public void run() {
                SPropAnimPanel.this.updateResults(true);
            }
        });
    }

    @Override
    public void modelUpdate(final ModelEvent me) {
        CMIUtil.runOnDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (me.getStatus() == 101 && me.getTimesteps() > 0) {
                    if (SPropAnimPanel.this.mostGrid == null) {
                        SPropAnimPanel.this.readGrid();
                    } else if (SPropAnimPanel.this.maxAmpOnly) {
                        SPropAnimPanel.this.mostMaxGrid.readData(SPropAnimPanel.this.propInfo.getHaFileName(), "max_height");
                    } else {
                        SPropAnimPanel.this.mostGrid.updateTimeAxis();
                        SPropAnimPanel.this.updateTimeLabel();
                    }
                }
            }
        });
    }

    @Override
    public void modelStopped(final ModelEvent me) {
        CMIUtil.runOnDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (me.getTimesteps() == 0) {
                    SiftShare.log.fine("rec modelStopped");
                    SPropAnimPanel.this.readGrid();
                } else {
                    SPropAnimPanel.this.mostGrid.updateTimeAxis();
                }
                SPropAnimPanel.this.updateTimeLabel();
            }
        });
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed(String command) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                String actionCommand = command;
                e = new ActionEvent(this, 1001, actionCommand);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    protected class MyMouseAdapter
    extends MouseAdapter {
        private final Component outerParent;

        public MyMouseAdapter(Component p) {
            this.outerParent = p;
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getButton() == 1 && event.getClickCount() == 2) {
                Layer layer = SPropAnimPanel.this.getLayer("amp");
                CartesianGraph graph = SPropAnimPanel.this.getCartesianGraph("amp");
                SPropAnimPanel.this.sp.setX(graph.getXPtoU(layer.getXDtoP(event.getX())));
                SPropAnimPanel.this.sp.setY(graph.getYPtoU(layer.getYDtoP(event.getY())));
                SPropAnimPanel.this.fireActionPerformed("epicenter");
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                SPropAnimPanel.this.createPopupMenu().show(event.getComponent(), event.getX(), event.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                SPropAnimPanel.this.createPopupMenu().show(event.getComponent(), event.getX(), event.getY());
            }
        }
    }

    private class SaveImageAction
    extends AbstractAction {
        public SaveImageAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SPropAnimPanel.this.saveImageToFile();
        }
    }

    private class ResetMeZoomAction
    extends AbstractAction {
        public ResetMeZoomAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SPropAnimPanel.this.resetZoom();
        }
    }
}

