/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.BathyGrid;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class SSFilter {
    private static final int MAX_ITERATIONS = 10;

    public static int filterBathymetry(BathyGrid grid, double ssLimit, double dryLimit) {
        int i;
        int pointsModified = 0;
        if (ssLimit <= 1.0 || ssLimit >= 3.0) {
            throw new IllegalArgumentException("1 < ssLimit < 3");
        }
        if (dryLimit > 0.0) {
            dryLimit = -1.0 * dryLimit;
        }
        int num = Integer.MAX_VALUE;
        for (i = 0; i < 10 && num > 0; ++i) {
            num = SSFilter.openWaterFilter(grid, ssLimit, dryLimit);
            pointsModified += num;
        }
        num = Integer.MAX_VALUE;
        for (i = 0; i < 10 && num > 0; ++i) {
            num = SSFilter.coastlineFilter(grid, ssLimit, dryLimit);
            pointsModified += num;
        }
        return pointsModified;
    }

    private static int openWaterFilter(BathyGrid grid, double ssLimit, double dryLimit) {
        double fleft;
        double frght;
        int idx;
        int na = grid.getXSize();
        int ma = grid.getYSize();
        double[] deps = grid.getZArray();
        double[] s = new double[deps.length];
        boolean[] snan = new boolean[deps.length];
        int changeCount = 0;
        System.arraycopy(deps, 0, s, 0, deps.length);
        for (int i = ma - 1; i >= 0; --i) {
            int j;
            for (j = 0; j < na; ++j) {
                if (s[j * ma + i] >= dryLimit) {
                    snan[j * ma + i] = true;
                    continue;
                }
                s[j * ma + i] = Math.sqrt(-1.0 * s[j * ma + i]);
            }
            for (j = 1; j < na - 1; ++j) {
                idx = j * ma + i;
                if (snan[idx - ma] || snan[idx] || snan[idx + ma]) continue;
                frght = s[idx + ma] / s[idx];
                fleft = s[idx - ma] / s[idx];
                if (!(frght > ssLimit) && !(fleft > ssLimit)) continue;
                s[idx] = 0.5 * (s[idx - ma] + s[idx + ma]);
                deps[idx] = -1.0 * s[idx] * s[idx];
                ++changeCount;
            }
        }
        Arrays.fill(snan, false);
        System.arraycopy(deps, 0, s, 0, deps.length);
        for (int j = 0; j < na; ++j) {
            int i;
            for (i = ma - 1; i >= 0; --i) {
                if (s[j * ma + i] >= dryLimit) {
                    snan[j * ma + i] = true;
                    continue;
                }
                s[j * ma + i] = Math.sqrt(-1.0 * s[j * ma + i]);
            }
            for (i = ma - 2; i >= 1; --i) {
                idx = j * ma + i;
                if (snan[idx - 1] || snan[idx] || snan[idx + 1]) continue;
                frght = s[idx + 1] / s[idx];
                fleft = s[idx - 1] / s[idx];
                if (!(frght > ssLimit) && !(fleft > ssLimit)) continue;
                s[idx] = 0.5 * (s[idx - 1] + s[idx + 1]);
                deps[idx] = -1.0 * s[idx] * s[idx];
                ++changeCount;
            }
        }
        return changeCount;
    }

    private static int coastlineFilter(BathyGrid grid, double ssLimit, double dryLimit) {
        double a;
        int idx;
        int na = grid.getXSize();
        int ma = grid.getYSize();
        double[] deps = grid.getZArray();
        double[] s = new double[deps.length];
        boolean[] snan = new boolean[deps.length];
        int changeCount = 0;
        double r = ssLimit * ssLimit;
        System.arraycopy(deps, 0, s, 0, deps.length);
        for (int i = ma - 1; i >= 0; --i) {
            int j;
            for (j = 0; j < na; ++j) {
                if (!(s[j * ma + i] >= dryLimit)) continue;
                snan[j * ma + i] = true;
            }
            for (j = 1; j < na - 1; ++j) {
                idx = j * ma + i;
                if (snan[idx - ma] && !snan[idx] && !snan[idx + ma]) {
                    a = s[idx + ma];
                } else {
                    if (!snan[idx + ma] || snan[idx] || snan[idx - ma]) continue;
                    a = s[idx - ma];
                }
                if (!(a / s[idx] > r)) continue;
                deps[idx] = 1.001 * a / r;
                ++changeCount;
            }
        }
        Arrays.fill(snan, false);
        System.arraycopy(deps, 0, s, 0, deps.length);
        for (int j = 0; j < na; ++j) {
            int i;
            for (i = 0; i < ma; ++i) {
                if (!(s[j * ma + i] >= dryLimit)) continue;
                snan[j * ma + i] = true;
            }
            for (i = ma - 2; i >= 1; --i) {
                idx = j * ma + i;
                if (snan[idx - 1] && !snan[idx] && !snan[idx + 1]) {
                    a = s[idx + 1];
                } else {
                    if (!snan[idx + 1] || snan[idx] || snan[idx - 1]) continue;
                    a = s[idx - 1];
                }
                if (!(a / s[idx] > r)) continue;
                deps[idx] = 1.001 * a / r;
                ++changeCount;
            }
        }
        return changeCount;
    }

    private static void commandLineHelp() {
        System.err.println("Usage: ssfilter <limit> <drylimit> <inputfile> <outputfile>");
        System.err.println("\nThis tool filters bathymetry using the \"Support Scientist's Limit\".");
    }

    public static void main(String[] args) throws IOException {
        double lim = 0.0;
        double dry = 0.0;
        File inf = null;
        File outf = null;
        try {
            lim = Double.parseDouble(args[0]);
            dry = Double.parseDouble(args[1]);
            inf = new File(args[2]);
            outf = new File(args[3]);
        }
        catch (Exception e) {
            SSFilter.commandLineHelp();
            System.exit(2);
        }
        if (!inf.canRead()) {
            throw new IOException(inf.getName() + " cannot be read");
        }
        if (outf.exists()) {
            throw new IOException(outf.getName() + " already exists");
        }
        BathyGrid g = new BathyGrid(inf);
        int numpts = SSFilter.filterBathymetry(g, lim, dry);
        System.out.println("Total points modified: " + numpts);
        System.out.println("CFL limit (max time step): " + g.getMaxTimeStep());
    }
}

