/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.PlainAxis;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.SimpleLine;
import gov.noaa.pmel.sgt.dm.SimplePoint;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.GaugeLine;
import gov.noaa.tsunami.cmi.MOSTLine;
import gov.noaa.tsunami.cmi.ModelEvent;
import gov.noaa.tsunami.cmi.ModelListener;
import gov.noaa.tsunami.cmi.MostResultsPanel;
import gov.noaa.tsunami.cmi.ResultGraphicsPanel;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import gov.noaa.tsunami.cmi.TideGaugeClient;
import gov.noaa.tsunami.cmi.TideStationMetadata;
import gov.noaa.tsunami.websift.events.SeismicEvent;
import gov.noaa.tsunami.websift.propdb.SourceScenario;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.event.MouseInputAdapter;
import javax.swing.filechooser.FileFilter;

public class STSPanel
extends JPanel
implements PropertyChangeListener,
ModelListener {
    private int currentTimestep = 0;
    private int selectedGrid = -1;
    private final MOSTLine tsLine = new MOSTLine();
    private LinkedHashMap<String, GaugeLine> gaugeMap = new LinkedHashMap();
    private GaugeLine gaLine = new GaugeLine();
    private String sensor = "";
    private boolean despike = false;
    private final Map<String, Layer> layers = new LinkedHashMap<String, Layer>();
    private final JPane jPane;
    private final CartesianGraph graph;
    private final LinearTransform xt;
    private final LinearTransform yt;
    private final PlainAxis xAxis;
    private final PlainAxis xAxisTop;
    private final PlainAxis yAxis;
    private final PlainAxis yAxisRight;
    private final SimpleLine zeroLine;
    private final LineAttribute gratLA;
    private final LineAttribute gaugeLA;
    private final SimplePoint tsMarkerPoint;
    private final double xSize = 9.0;
    private final double ySize = 2.1;
    private final DecimalFormat dfxxxxx = new DecimalFormat("0.00000");
    private final DecimalFormat dfxx = new DecimalFormat("0.00");
    private final DecimalFormat dfx = new DecimalFormat("0.0");
    private int detideType = 1;
    protected MostResultsPanel mostResultsPanel;
    private double minTimeRange = 0.0;
    private SiteInfo si;
    private ArrayList<TideStationMetadata> tsm = new ArrayList();

    public STSPanel(MostResultsPanel mrp) {
        double xstart = 0.6;
        double xend = 8.9;
        double ystart = 0.5;
        double yend = 1.8;
        int pWidth = 600;
        int pHeight = 50;
        this.mostResultsPanel = mrp;
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.jPane = new JPane("bathy graph", new Dimension(600, 50));
        this.jPane.setOpaque(true);
        this.jPane.setLayout(new StackedLayout());
        SoTRange.Double xrange = (SoTRange.Double)this.tsLine.getXRange();
        SoTRange.Double yrange = (SoTRange.Double)this.tsLine.getYRange();
        this.xt = new LinearTransform(0.6, 8.9, xrange.start, xrange.end);
        this.yt = new LinearTransform(0.5, 1.8, yrange.start, yrange.end);
        this.getLayer("grat");
        this.getLayer("zero");
        this.getLayer("tspt");
        this.getLayer("ts");
        this.getLayer("tsgauge");
        this.xAxis = new PlainAxis();
        this.xAxis.setLabelHeightP(0.16);
        this.xAxis.setLabelFont(ResultGraphicsPanel.AXIS_FONT);
        this.xAxis.setLabelInterval(1);
        String xLabel = "Time since event [hr]";
        SGLabel xtitle = new SGLabel("xlbl", xLabel, new Point2D.Double(0.0, 0.0));
        xtitle.setFont(ResultGraphicsPanel.AXIS_FONT);
        xtitle.setHeightP(0.16);
        this.xAxis.setTitle(xtitle);
        this.xAxisTop = new PlainAxis();
        this.xAxisTop.setNumberSmallTics(0);
        this.xAxisTop.setTicPosition(1);
        this.xAxisTop.setLabelPosition(2);
        this.xAxis.register(this.xAxisTop);
        this.yAxis = new PlainAxis();
        this.yAxis.setLabelHeightP(0.16);
        this.yAxis.setLabelFont(ResultGraphicsPanel.AXIS_FONT);
        this.yAxis.setLabelInterval(1);
        this.yAxisRight = new PlainAxis();
        this.yAxisRight.setNumberSmallTics(0);
        this.yAxisRight.setTicPosition(1);
        this.yAxisRight.setLabelPosition(2);
        this.yAxis.register(this.yAxisRight);
        SGLabel ytitle = new SGLabel("ylbl", "amplitude [cm]", new Point2D.Double(0.0, 0.0));
        ytitle.setFont(ResultGraphicsPanel.AXIS_FONT);
        ytitle.setHeightP(0.16);
        this.yAxis.setTitle(ytitle);
        this.yAxis.setSignificantDigits(1);
        CartesianGraph gaugegraph = this.getCartesianGraph("tsgauge");
        this.gaugeLA = new LineAttribute(2, Color.black);
        this.gaugeLA.setWidth(2.5f);
        gaugegraph.setData(this.gaLine, this.gaugeLA);
        this.graph = this.getCartesianGraph("ts");
        this.graph.addXAxis(this.xAxis);
        this.graph.addXAxis(this.xAxisTop);
        this.graph.addYAxis(this.yAxis);
        this.graph.addYAxis(this.yAxisRight);
        LineAttribute la = new LineAttribute(2, Color.red);
        la.setWidth(3.5f);
        this.graph.setData(this.tsLine, la);
        double[] empty = new double[]{};
        this.zeroLine = new SimpleLine(empty, empty, "CWMzero");
        this.zeroLine.setDynamic(false);
        Collection lc = new Collection();
        lc.add(this.zeroLine);
        la = new LineAttribute(0, Color.black);
        this.getCartesianGraph("zero").setData(lc, la);
        this.tsMarkerPoint = new SimplePoint();
        CartesianGraph gr = this.getCartesianGraph("tspt");
        PointAttribute pta = new PointAttribute(50, Color.RED);
        pta.setMarkHeightP(0.25);
        gr.setData(this.tsMarkerPoint, pta);
        this.gratLA = new LineAttribute(1, Color.GRAY);
        this.gratLA.setWidth(0.1f);
        this.gratLA.setDashArray(new float[]{0.1f, 0.1f});
        this.updateAxes();
        this.add((Component)this.jPane, "Center");
        this.jPane.setMouseEventsEnabled(false);
        TSPanelMouseListener mouselisten = new TSPanelMouseListener(this.getLayer("ts"));
        this.jPane.addMouseListener(mouselisten);
        this.jPane.addMouseMotionListener(mouselisten);
        this.jPane.getInputMap(2).put(KeyStroke.getKeyStroke("shift RIGHT"), "shift model right");
        this.jPane.getActionMap().put("shift model right", new RightAction());
        this.jPane.getInputMap(2).put(KeyStroke.getKeyStroke("shift LEFT"), "shift model left");
        this.jPane.getActionMap().put("shift model left", new LeftAction());
        this.jPane.getInputMap(2).put(KeyStroke.getKeyStroke("shift SPACE"), "center model");
        this.jPane.getActionMap().put("center model", new CenterAction());
    }

    STSPanel() {
        this((MostResultsPanel)null);
    }

    protected final Layer getLayer(String layerName) {
        Layer lyr = this.layers.get(layerName);
        if (lyr != null) {
            return lyr;
        }
        lyr = new Layer(layerName, new Dimension2D(9.0, 2.1));
        this.layers.put(layerName, lyr);
        this.jPane.add(lyr);
        CartesianGraph gr = new CartesianGraph(layerName + " graph");
        gr.setXTransform(this.xt);
        gr.setYTransform(this.yt);
        lyr.setGraph(gr);
        return lyr;
    }

    protected final CartesianGraph getCartesianGraph(String layerName) {
        Layer lyr = this.getLayer(layerName);
        return (CartesianGraph)lyr.getGraph();
    }

    public void updateData() {
        if (this.mostResultsPanel.getGridShowing() == 3 && this.gaLine != null) {
            this.getCartesianGraph("tsgauge").setData(this.gaLine, this.gaugeLA);
        } else {
            this.getCartesianGraph("tsgauge").setData(new GaugeLine(), this.gaugeLA);
        }
        this.tsLine.updateData();
        this.updateAxes();
        this.setTimeStep(this.currentTimestep);
    }

    public void clearDisplay() {
        this.tsLine.setEmptyData();
        this.updateAxes();
        this.tsMarkerPoint.setX(Double.NaN);
        this.tsMarkerPoint.setY(Double.NaN);
    }

    private void updateAxes() {
        SimpleLine sl;
        double[] ylocs;
        int i;
        double span;
        SoTRange.Double xr = (SoTRange.Double)this.tsLine.getXRange();
        double st = Math.min(xr.start, xr.end);
        double end = Math.max(xr.start, xr.end);
        if (this.gaLine == null) {
            this.gaLine = new GaugeLine();
            this.gaLine.setEmptyData();
        }
        if (this.gaLine.hasData()) {
            st -= 1.0;
            end = Math.max(end, 12.0);
        }
        double roundTo = (span = Math.max(end - st, this.minTimeRange)) < 3.0 ? 0.083333333 : (span >= 3.0 && span < 5.0 ? 0.5 : 1.0);
        SoTRange.Double xrange = new SoTRange.Double(Math.floor(st / roundTo) * roundTo, Math.ceil((st + span) / roundTo) * roundTo, 2.0 * roundTo);
        SoTRange.Double yr = (SoTRange.Double)this.tsLine.getYRange();
        SoTRange.Double yrg = (SoTRange.Double)this.gaLine.getYRange();
        span = this.mostResultsPanel.getGridShowing() == 3 ? 2.0 * Math.max(Math.max(Math.abs(yr.end), Math.abs(yr.start)), Math.max(Math.abs(yrg.end), Math.abs(yrg.start))) : 2.0 * Math.max(Math.abs(yr.end), Math.abs(yr.start));
        SoTRange.Double yrange = new SoTRange.Double(-1.0, 1.0, 1.0);
        int numSmallTics = 3;
        if (span > 2.0) {
            yrange = new SoTRange.Double(-5.0, 5.0, 5.0);
            numSmallTics = 4;
        }
        if (span > 10.0) {
            yrange = new SoTRange.Double(-10.0, 10.0, 10.0);
            numSmallTics = 4;
        }
        if (span > 25.0) {
            yrange = new SoTRange.Double(-20.0, 20.0, 20.0);
            numSmallTics = 3;
        }
        if (span > 35.0) {
            yrange = new SoTRange.Double(-25.0, 25.0, 25.0);
            numSmallTics = 4;
        }
        if (span > 60.0) {
            yrange = new SoTRange.Double(-50.0, 50.0, 50.0);
            numSmallTics = 4;
        }
        if (span > 90.0) {
            yrange = new SoTRange.Double(-75.0, 75.0, 75.0);
            numSmallTics = 2;
        }
        if (span > 130.0) {
            yrange = new SoTRange.Double(-100.0, 100.0, 100.0);
            numSmallTics = 4;
        }
        if (span > 170.0) {
            yrange = new SoTRange.Double(-150.0, 150.0, 150.0);
            numSmallTics = 2;
        }
        if (span > 225.0) {
            yrange = new SoTRange.Double(-200.0, 200.0, 200.0);
            numSmallTics = 3;
        }
        if (span > 425.0) {
            yrange = new SoTRange.Double(-400.0, 400.0, 400.0);
            numSmallTics = 3;
        }
        if (span > 550.0) {
            yrange = new SoTRange.Double(-500.0, 500.0, 500.0);
            numSmallTics = 4;
        }
        if (span > 1100.0) {
            yrange = new SoTRange.Double(-1000.0, 1000.0, 1000.0);
            numSmallTics = 3;
        }
        if (span > 2100.0) {
            yrange = new SoTRange.Double(-2000.0, 2000.0, 2000.0);
            numSmallTics = 3;
        }
        this.yAxis.setNumberSmallTics(numSmallTics);
        SoTPoint origin = new SoTPoint(xrange.start, yrange.start);
        this.xAxis.setRangeU(xrange);
        this.xAxis.setLocationU(origin);
        this.xAxisTop.setLocationU(new SoTPoint(origin.getX(), yrange.getEnd()));
        this.yAxis.setRangeU(yrange);
        this.yAxis.setLocationU(origin);
        this.yAxisRight.setLocationU(new SoTPoint(xrange.getEnd(), origin.getY()));
        this.xt.setRangeU(xrange);
        this.yt.setRangeU(yrange);
        this.getCartesianGraph("tsgauge").setClip(xrange, yrange);
        this.zeroLine.setXArray(new double[]{xrange.start, xrange.end});
        this.zeroLine.setYArray(new double[]{0.0, 0.0});
        Collection lc = new Collection();
        double interval = yrange.end / (double)(numSmallTics + 1);
        double[] xlocs = new double[]{xrange.start, xrange.end};
        for (i = 0; i < numSmallTics; ++i) {
            ylocs = new double[2];
            ylocs[0] = ylocs[1] = interval * (double)(i + 1);
            sl = new SimpleLine(xlocs, ylocs, "y" + i);
            lc.add(sl);
            ylocs = new double[2];
            ylocs[0] = ylocs[1] = -interval * (double)(i + 1);
            sl = new SimpleLine(xlocs, ylocs, "-y" + i);
            lc.add(sl);
        }
        ylocs = new double[]{yrange.start, yrange.end};
        i = 0;
        while ((double)i < 2.0 * (xrange.end - xrange.start) / xrange.delta - 1.0) {
            xlocs = new double[2];
            xlocs[0] = xlocs[1] = xrange.start + xrange.delta * (double)(i + 1) / 2.0;
            sl = new SimpleLine(xlocs, ylocs, "x" + i);
            lc.add(sl);
            ++i;
        }
        this.getCartesianGraph("grat").setData(lc, this.gratLA);
    }

    private void setTimeStep(int ti) {
        this.currentTimestep = ti;
        this.tsMarkerPoint.setX(ti >= 0 && ti < this.tsLine.times.length ? this.tsLine.times[ti] : Double.NaN);
        this.tsMarkerPoint.setY(ti >= 0 && ti < this.tsLine.heights.length ? this.tsLine.heights[ti] : Double.NaN);
    }

    public void saveDetidedGaugeData() {
        File dataFile = this.gaLine.getFile();
        if (dataFile != null) {
            String fileName = dataFile.getPath();
            fileName = fileName.substring(0, fileName.lastIndexOf(46)) + "detide.txt";
            File f = new File(this.si.getSiteDirectory(), fileName);
            JFileChooser chooser = new JFileChooser(CMIUtil.currentSiteInfo.getSiteDirectory());
            chooser.setSelectedFile(f);
            int result = chooser.showSaveDialog(this);
            if (result == 0) {
                f = chooser.getSelectedFile();
                double[] times = this.gaLine.getXArray();
                double[] heights = this.gaLine.getYArray();
                try {
                    PrintWriter pw = new PrintWriter(f);
                    pw.println("# Detided tide gauge data from ComMIT");
                    pw.println("# Model: " + this.si.getName() + " Dir: " + this.si.getDirName());
                    pw.println("# Original data file: " + dataFile.getPath());
                    pw.println("# Metadata: " + this.si.getTideStationMetadata());
                    pw.println("# time-since-event(s) gauge-amp(cm)");
                    for (int i = 0; i < heights.length; ++i) {
                        if (Double.isNaN(heights[i])) continue;
                        pw.println(this.dfxx.format(times[i] * 3600.0) + " " + this.dfxx.format(heights[i]));
                    }
                    pw.close();
                }
                catch (FileNotFoundException ex) {
                    SiftShare.log.log(Level.WARNING, "error saving detided gauge data", ex);
                }
            }
        }
    }

    public void saveGaugeData() {
        File dataFile = this.gaugeMap.values().iterator().next().getFile();
        if (dataFile != null) {
            String fileName = dataFile.getName();
            File f = new File(CMIUtil.baseDirName, fileName);
            JFileChooser chooser = new JFileChooser(CMIUtil.currentSiteInfo.getSiteDirectory());
            chooser.setSelectedFile(f);
            int result = chooser.showSaveDialog(this);
            if (result == 0) {
                f = chooser.getSelectedFile();
                try {
                    CMIUtil.copyFile(dataFile, f);
                }
                catch (IOException ex) {
                    SiftShare.log.log(Level.WARNING, "error saving original gauge data", ex);
                }
            }
        }
    }

    public void saveTimeseries() {
        if (this.tsLine.getYArray().length > 0) {
            String fileName = this.si.getName() + "timeseries";
            int gridShowing = this.mostResultsPanel.getGridShowing();
            switch (gridShowing) {
                case 1: {
                    fileName = fileName + "A.txt";
                    break;
                }
                case 2: {
                    fileName = fileName + "B.txt";
                    break;
                }
                case 3: {
                    fileName = fileName + "C.txt";
                    break;
                }
                default: {
                    fileName = fileName + ".txt";
                }
            }
            File f = new File(this.si.getSiteDirectory(), fileName);
            JFileChooser chooser = new JFileChooser(CMIUtil.currentSiteInfo.getSiteDirectory());
            chooser.setSelectedFile(f);
            int result = chooser.showSaveDialog(this);
            if (result == 0) {
                f = chooser.getSelectedFile();
                this.saveTimeseriesToFile(f);
            }
        } else {
            JOptionPane.showMessageDialog(this, "No timesteps in Model Run\nLaunch model to create timeseries", "Error", 0);
        }
    }

    public void saveTimeseriesToFile(File f) {
        double[] times = this.tsLine.getXArray();
        double[] heights = this.tsLine.getYArray();
        if (heights.length > 0) {
            try {
                Point2D.Double pt = this.mostResultsPanel.getTimeseriesLocation();
                double depth = this.mostResultsPanel.getTimeseriesDepth();
                PrintWriter pw = new PrintWriter(f);
                pw.println("# MOST timeseries from point");
                pw.println("# x: " + this.dfxxxxx.format(pt.x) + " y: " + this.dfxxxxx.format(pt.y) + " depth: " + this.dfx.format(depth));
                pw.println("# time-since-event(s) wave-amp(cm)");
                for (int i = 0; i < heights.length; ++i) {
                    pw.println(this.dfxx.format(times[i] * 3600.0) + " " + this.dfxx.format(heights[i]));
                }
                pw.close();
            }
            catch (FileNotFoundException ex) {
                SiftShare.log.log(Level.WARNING, "error saving timeseries", ex);
            }
        }
    }

    public void saveImageToFile() {
        String fileName = this.si.getName() + "timeseries";
        int gridShowing = this.mostResultsPanel.getGridShowing();
        switch (gridShowing) {
            case 1: {
                fileName = fileName + "A.png";
                break;
            }
            case 2: {
                fileName = fileName + "B.png";
                break;
            }
            case 3: {
                fileName = fileName + "C.png";
                break;
            }
            default: {
                fileName = fileName + ".png";
            }
        }
        JFileChooser chooser = new JFileChooser(CMIUtil.workingDirName);
        chooser.setDialogTitle("Save image as (.png)");
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                int idx = name.lastIndexOf(46);
                return idx > 0 && name.substring(idx + 1, name.length()).equals("png");
            }

            @Override
            public String getDescription() {
                return "PNG Files";
            }
        });
        File f = new File(CMIUtil.workingDirName, fileName);
        chooser.setSelectedFile(f);
        int result = chooser.showSaveDialog(this);
        if (result == 0) {
            if (chooser.getSelectedFile().exists()) {
                int overwrite = JOptionPane.showConfirmDialog(chooser, "File exists, overwrite?", "File exists", 1);
                if (overwrite == 0) {
                    this.savePanelImage(chooser.getSelectedFile());
                }
            } else {
                this.savePanelImage(chooser.getSelectedFile());
            }
        }
    }

    public void savePanelImage(File f) {
        int width = this.getWidth();
        int height = this.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2 = image.createGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, width, height);
        this.jPane.draw(g2);
        g2.dispose();
        try {
            ImageIO.write((RenderedImage)image, "png", f);
        }
        catch (IOException ioe) {
            SiftShare.log.log(Level.WARNING, "error", ioe);
        }
    }

    private void setMinTimeRange(double t) {
        this.minTimeRange = t;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("timeStep".equals(evt.getPropertyName())) {
            this.setTimeStep((Integer)evt.getNewValue());
        } else if ("currentSite".equals(evt.getPropertyName())) {
            this.si = (SiteInfo)evt.getNewValue();
            if (this.si == null) {
                this.setMinTimeRange(0.0);
                this.clearDisplay();
            } else {
                this.tsLine.setDataFilename(this.si.getOutputFile(this.selectedGrid));
                this.tsLine.setTimeseriesLocation(this.si.getTimeseriesLocation(this.selectedGrid));
                this.setMinTimeRange(this.si.getModelTimeExtent());
                this.loadGaugeData(this.si);
            }
        } else if (!"selectedGrid".equals(evt.getPropertyName())) {
            if ("timeseriesLocation".equals(evt.getPropertyName())) {
                this.tsLine.setTimeseriesLocation((Point2D.Double)evt.getNewValue());
                this.updateData();
            } else if ("sourceSwitched".equals(evt.getPropertyName()) || "sourceScenario".equals(evt.getPropertyName())) {
                if (this.si == null) {
                    return;
                }
                this.tsLine.setDataFilename(this.si.getOutputFile(this.selectedGrid));
                this.tsLine.setTimeseriesLocation(this.si.getTimeseriesLocation(this.selectedGrid));
                this.setMinTimeRange(this.si.getModelTimeExtent());
                this.loadGaugeData(this.si);
                this.updateData();
            }
        }
    }

    public Double getModelAtStep(int i) {
        if (this.tsLine == null) {
            return Double.NaN;
        }
        return i >= 0 && i < this.tsLine.getYArray().length ? this.tsLine.getYArray()[i] : Double.NaN;
    }

    public void loadGaugeData(SiteInfo si) {
        this.gaugeMap.clear();
        if (si == null) {
            return;
        }
        if (this.gaLine == null) {
            this.gaLine = new GaugeLine();
        }
        this.gaLine.setEmptyData();
        SourceScenario ss = si.getSourceScenario();
        this.sensor = "none";
        if (ss != null) {
            SeismicEvent se = ss.getSeismicEvent();
            this.tsm = si.getTideStationMetadata();
            if (se != null) {
                SiftShare.log.info("Found SeismicEvent: " + se);
                for (TideStationMetadata t : this.tsm) {
                    this.gaugeMap.putAll(TideGaugeClient.readGaugeData(this, t, se.getDate()));
                }
            }
            if (this.gaugeMap.size() > 0) {
                SiftShare.log.info("Num sensors: " + this.gaugeMap.size());
                this.sensor = this.gaugeMap.keySet().iterator().next();
            } else {
                SiftShare.log.info("No tide gauge data for this event");
            }
        }
        this.detideGaugeData();
        this.updateData();
    }

    public void detideGaugeData() {
        TideGaugeClient.detideType = this.detideType;
        this.gaLine = TideGaugeClient.detideGaugeData(this.gaugeMap.get(this.sensor), this.despike);
    }

    public void setGaugeData(HashMap<String, GaugeLine> map) {
        this.gaugeMap.putAll(map);
        if (this.gaugeMap.size() > 0) {
            this.sensor = this.gaugeMap.keySet().iterator().next();
        }
        this.updateData();
    }

    @Override
    public void modelStarted(final ModelEvent me) {
        CMIUtil.runOnDispatchThread(new Runnable(){

            @Override
            public void run() {
                STSPanel.this.si = (SiteInfo)me.getSourceModel();
                STSPanel.this.tsLine.setDataFilename(STSPanel.this.si.getOutputFile(STSPanel.this.selectedGrid));
                STSPanel.this.tsLine.setTimeseriesLocation(STSPanel.this.si.getTimeseriesLocation(STSPanel.this.selectedGrid));
                STSPanel.this.setMinTimeRange(STSPanel.this.si.getModelTimeExtent());
                STSPanel.this.loadGaugeData(STSPanel.this.si);
                STSPanel.this.clearDisplay();
            }
        });
    }

    @Override
    public void modelStopped(final ModelEvent me) {
        CMIUtil.runOnDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (me.getTimesteps() == 0) {
                    STSPanel.this.clearDisplay();
                }
            }
        });
    }

    @Override
    public void modelUpdate(ModelEvent me) {
        CMIUtil.runOnDispatchThread(new Runnable(){

            @Override
            public void run() {
                STSPanel.this.updateData();
            }
        });
    }

    public void setSelectedGrid(int selectedGrid) {
        this.selectedGrid = selectedGrid;
        if (this.si != null) {
            this.tsLine.setDataFilename(this.si.getOutputFile(selectedGrid));
        }
    }

    private final class TSPanelMouseListener
    extends MouseInputAdapter {
        final JToolTip coordTip = new JToolTip();
        final Layer layer;
        FontMetrics metrics;

        public TSPanelMouseListener(Layer lyr) {
            this.layer = lyr;
            this.coordTip.setVisible(false);
            STSPanel.this.jPane.add(this.coordTip);
        }

        private void handlePopupMenu(MouseEvent e) {
            JMenuItem savets = new JMenuItem("Save model time series output");
            savets.setEnabled(STSPanel.this.tsLine.hasData());
            savets.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    STSPanel.this.saveTimeseries();
                }
            });
            JMenuItem savedtgauge = new JMenuItem("Save detided tide gauge output");
            savedtgauge.setEnabled(STSPanel.this.gaLine.hasData());
            savedtgauge.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    STSPanel.this.saveDetidedGaugeData();
                }
            });
            JMenuItem savegauge = new JMenuItem("Save original tide gauge output");
            savegauge.setEnabled(STSPanel.this.gaLine.hasData());
            savegauge.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    STSPanel.this.saveGaugeData();
                }
            });
            JMenuItem saveImage = new JMenuItem("Save time series panel as PNG image");
            saveImage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    STSPanel.this.saveImageToFile();
                }
            });
            JPopupMenu menu = new JPopupMenu();
            menu.add(savets);
            menu.add(savedtgauge);
            menu.add(savegauge);
            menu.add(saveImage);
            if (!STSPanel.this.gaugeMap.isEmpty()) {
                menu.addSeparator();
                ButtonGroup sensorGroup = new ButtonGroup();
                for (String s : STSPanel.this.gaugeMap.keySet()) {
                    JRadioButtonMenuItem mi = new JRadioButtonMenuItem(new AbstractAction(s){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            STSPanel.this.sensor = e.getActionCommand();
                            STSPanel.this.detideGaugeData();
                            STSPanel.this.updateData();
                        }
                    });
                    mi.setSelected(s.equals(STSPanel.this.sensor));
                    sensorGroup.add(mi);
                    menu.add(mi);
                }
                menu.addSeparator();
                JRadioButtonMenuItem miSpike = new JRadioButtonMenuItem(new AbstractAction("Despike data"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        STSPanel.this.despike = !STSPanel.this.despike;
                        STSPanel.this.detideGaugeData();
                        STSPanel.this.updateData();
                    }
                });
                miSpike.setSelected(STSPanel.this.despike);
                menu.add(miSpike);
                menu.addSeparator();
                ButtonGroup detideGroup = new ButtonGroup();
                JRadioButtonMenuItem miHarm = new JRadioButtonMenuItem(new AbstractAction("Detide Harmonic"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        STSPanel.this.detideType = 1;
                        STSPanel.this.detideGaugeData();
                        STSPanel.this.updateData();
                    }
                });
                miHarm.setSelected(STSPanel.this.detideType == 1);
                detideGroup.add(miHarm);
                menu.add(miHarm);
                JRadioButtonMenuItem miLP = new JRadioButtonMenuItem(new AbstractAction("Detide Low Pass Filter"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        STSPanel.this.detideType = 2;
                        STSPanel.this.detideGaugeData();
                        STSPanel.this.updateData();
                    }
                });
                miLP.setSelected(STSPanel.this.detideType == 2);
                detideGroup.add(miLP);
                menu.add(miLP);
                JRadioButtonMenuItem miNONE = new JRadioButtonMenuItem(new AbstractAction("Detide None"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        STSPanel.this.detideType = 0;
                        STSPanel.this.detideGaugeData();
                        STSPanel.this.updateData();
                    }
                });
                miNONE.setSelected(STSPanel.this.detideType == 0);
                detideGroup.add(miNONE);
                menu.add(miNONE);
            }
            menu.show(e.getComponent(), e.getX(), e.getY());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.handlePopupMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.handlePopupMenu(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            double x = STSPanel.this.graph.getXPtoU(this.layer.getXDtoP(e.getX()));
            int xi = STSPanel.this.tsLine.getIndexClosestInTime(x);
            if (xi > 0 && STSPanel.this.mostResultsPanel != null) {
                STSPanel.this.mostResultsPanel.stickToLastFrame(false);
                STSPanel.this.mostResultsPanel.setTimeStep(xi);
            }
        }
    }

    private class CenterAction
    extends AbstractAction {
        private CenterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            STSPanel.this.tsLine.shiftCenter();
        }
    }

    private class LeftAction
    extends AbstractAction {
        private LeftAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            STSPanel.this.tsLine.shiftLeft();
        }
    }

    private class RightAction
    extends AbstractAction {
        private RightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            STSPanel.this.tsLine.shiftRight();
        }
    }
}

