/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.IndeterminateProgressMonitor;
import gov.noaa.tsunami.cmi.MOSTGrid;
import gov.noaa.tsunami.cmi.MostExtremaPanel;
import gov.noaa.tsunami.cmi.MostResultsPanel;
import gov.noaa.tsunami.cmi.SAnimPanel;
import gov.noaa.tsunami.cmi.SBathyGridsPanel;
import gov.noaa.tsunami.cmi.SMaxImagePanel;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import gov.noaa.tsunami.websift.events.SeismicEvent;
import gov.noaa.tsunami.websift.propdb.Point3D;
import gov.noaa.tsunami.websift.propdb.SourceCombo;
import gov.noaa.tsunami.websift.propdb.UnitSource;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;

public class SaveGEDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private int returnStatus = 0;
    private File kmzFile = null;
    private Integer numberOutputSteps = 0;
    private Integer lastStep = 0;
    private Integer skip = 0;
    private DecimalFormat dfx = new DecimalFormat("0.0");
    private JRadioButton aGridRadioButton;
    private JCheckBox animCheckBox;
    private JRadioButton bGridRadioButton;
    private JRadioButton cGridRadioButton;
    private JButton cancelButton;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JSpinner lastSpinner;
    private JCheckBox maxAmpsCheckBox;
    private JTextField nameTextField;
    private JTextField numFramesTextField;
    private JButton okButton;
    private JSpinner skipSpinner;

    public SaveGEDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        CMIUtil.installEscapeCloseOperation(this);
    }

    private void initComponents() {
        this.jCheckBox1 = new JCheckBox();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.maxAmpsCheckBox = new JCheckBox();
        this.animCheckBox = new JCheckBox();
        this.aGridRadioButton = new JRadioButton();
        this.bGridRadioButton = new JRadioButton();
        this.cGridRadioButton = new JRadioButton();
        this.numFramesTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.skipSpinner = new JSpinner();
        this.jLabel4 = new JLabel();
        this.lastSpinner = new JSpinner();
        this.jCheckBox1.setText("jCheckBox1");
        this.setTitle("Save Model Run as Google Earth file");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveGEDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveGEDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setFont(new Font("Dialog", 0, 14));
        this.jLabel1.setText("Name:");
        this.nameTextField.setText("jTextField1");
        this.jLabel2.setFont(new Font("Dialog", 0, 14));
        this.jLabel2.setText("Include:");
        this.maxAmpsCheckBox.setFont(new Font("Dialog", 0, 12));
        this.maxAmpsCheckBox.setSelected(true);
        this.maxAmpsCheckBox.setText("Maximum Amplitudes");
        this.animCheckBox.setFont(new Font("Dialog", 0, 12));
        this.animCheckBox.setText("Animation:     Total # frames:");
        this.animCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveGEDialog.this.animCheckBoxActionPerformed(evt);
            }
        });
        this.aGridRadioButton.setFont(new Font("Dialog", 0, 12));
        this.aGridRadioButton.setText("A-Grid");
        this.aGridRadioButton.setEnabled(false);
        this.bGridRadioButton.setFont(new Font("Dialog", 0, 12));
        this.bGridRadioButton.setText("B-Grid");
        this.bGridRadioButton.setEnabled(false);
        this.cGridRadioButton.setFont(new Font("Dialog", 0, 12));
        this.cGridRadioButton.setText("C-Grid");
        this.cGridRadioButton.setEnabled(false);
        this.numFramesTextField.setBackground(new Color(204, 204, 204));
        this.numFramesTextField.setColumns(5);
        this.numFramesTextField.setEditable(false);
        this.numFramesTextField.setHorizontalAlignment(0);
        this.numFramesTextField.setText("100");
        this.jLabel3.setFont(new Font("Dialog", 0, 12));
        this.jLabel3.setText("Skip:");
        this.skipSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.skipSpinner.setEnabled(false);
        this.skipSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SaveGEDialog.this.skipSpinnerStateChanged(evt);
            }
        });
        this.jLabel4.setText("Last Step: ");
        this.lastSpinner.setModel(new SpinnerNumberModel(1200, 0, 1200, 20));
        this.lastSpinner.setEnabled(false);
        this.lastSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SaveGEDialog.this.lastSpinnerStateChanged(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(this.jLabel1).addPreferredGap(0).add(this.nameTextField)).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(this.maxAmpsCheckBox).add(this.jLabel2).add(jPanel1Layout.createSequentialGroup().add(21, 21, 21).add(jPanel1Layout.createParallelGroup(1).add(this.bGridRadioButton).add(this.aGridRadioButton).add(this.cGridRadioButton))).add(jPanel1Layout.createSequentialGroup().add(this.animCheckBox).addPreferredGap(0).add(this.numFramesTextField, -2, -1, -2).addPreferredGap(1).add(this.jLabel3).addPreferredGap(0).add(this.skipSpinner, -2, 54, -2).addPreferredGap(0).add(this.jLabel4).addPreferredGap(0).add(this.lastSpinner, -2, -1, -2))).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.jLabel1).add(this.nameTextField, -2, -1, -2)).add(18, 18, 18).add(this.jLabel2).addPreferredGap(1).add(this.maxAmpsCheckBox).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.animCheckBox).add(this.numFramesTextField, -2, -1, -2).add(this.jLabel3).add(this.skipSpinner, -2, -1, -2).add(this.jLabel4).add(this.lastSpinner, -2, -1, -2)).addPreferredGap(0).add(this.aGridRadioButton).addPreferredGap(1).add(this.bGridRadioButton).addPreferredGap(1).add(this.cGridRadioButton).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(this.okButton, -2, 78, -2).addPreferredGap(1).add(this.cancelButton)).add(2, this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -1, -1, Short.MAX_VALUE).add(9, 9, 9).add(layout.createParallelGroup(3).add(this.okButton).add(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        File f = new File(CMIUtil.workingDirName);
        JFileChooser chooser = new JFileChooser(f);
        chooser.setSelectedFile(new File(f, CMIUtil.currentSiteInfo.getName() + ".kmz"));
        int result = chooser.showSaveDialog(this);
        if (result == 0) {
            this.kmzFile = chooser.getSelectedFile();
            this.returnStatus = 1;
            this.setVisible(false);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void animCheckBoxActionPerformed(ActionEvent evt) {
        if (this.animCheckBox.isSelected()) {
            this.aGridRadioButton.setEnabled(true);
            this.aGridRadioButton.setSelected(true);
            this.bGridRadioButton.setEnabled(true);
            this.bGridRadioButton.setSelected(false);
            this.cGridRadioButton.setEnabled(true);
            this.cGridRadioButton.setSelected(false);
            this.skipSpinner.setEnabled(true);
            this.lastSpinner.setEnabled(true);
        } else {
            this.aGridRadioButton.setEnabled(false);
            this.bGridRadioButton.setEnabled(false);
            this.cGridRadioButton.setEnabled(false);
            this.skipSpinner.setEnabled(false);
            this.lastSpinner.setEnabled(false);
        }
    }

    private void skipSpinnerStateChanged(ChangeEvent evt) {
        this.skip = (Integer)this.skipSpinner.getValue();
        Integer numFrames = new Integer(this.lastStep / this.skip);
        this.numFramesTextField.setText(numFrames.toString());
    }

    private void lastSpinnerStateChanged(ChangeEvent evt) {
        this.lastStep = (Integer)this.lastSpinner.getValue();
        Integer numFrames = new Integer(this.lastStep / this.skip);
        this.numFramesTextField.setText(numFrames.toString());
    }

    @Override
    public void setName(String n) {
        this.nameTextField.setText(n);
    }

    @Override
    public String getName() {
        return this.nameTextField.getText();
    }

    public boolean maxAmpSelected() {
        return this.maxAmpsCheckBox.isSelected();
    }

    public boolean aGridSelected() {
        return this.aGridRadioButton.isSelected();
    }

    public boolean bGridSelected() {
        return this.bGridRadioButton.isSelected();
    }

    public boolean cGridSelected() {
        return this.cGridRadioButton.isSelected();
    }

    public boolean gridSelected(int gridID) {
        switch (gridID) {
            case 1: {
                return this.aGridSelected();
            }
            case 2: {
                return this.bGridSelected();
            }
            case 3: {
                return this.cGridSelected();
            }
        }
        return false;
    }

    public int getSkip() {
        return (Integer)this.skipSpinner.getValue();
    }

    public void setNumberOutputSteps(int steps) {
        this.numberOutputSteps = steps;
        this.lastStep = steps;
        Integer numFrames = new Integer(steps);
        this.lastSpinner.setModel(new SpinnerNumberModel(steps, 0, steps, 50));
        this.lastSpinner.setValue(steps);
        this.skip = 1;
        while (numFrames > 125) {
            Integer n = this.skip;
            Integer n2 = this.skip = Integer.valueOf(this.skip + 1);
            numFrames = steps / this.skip;
        }
        this.numFramesTextField.setText(numFrames.toString());
        this.skipSpinner.setValue(this.skip);
    }

    public boolean animationSelected() {
        return this.animCheckBox.isSelected();
    }

    private void doCancel() {
        this.returnStatus = 0;
        this.setVisible(false);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void writeFault(FileWriter fw, UnitSource us) {
        Point3D[] rect = us.getRect();
        for (int j = 0; j < rect.length; ++j) {
            if (!(rect[j].x > 180.0)) continue;
            rect[j].x -= 360.0;
        }
        if (rect.length != 4) {
            return;
        }
        try {
            fw.write("      <Placemark>\n");
            fw.write("        <name>Fault Plane: " + us.getName() + "</name>\n");
            fw.write("        <description>\n");
            fw.write("           <![CDATA[\n");
            fw.write("               <h1>" + us.getName() + " <b>Alpha: " + us.getAlpha() + "</b></h1>\n");
            fw.write("               <p>Lon: " + us.getLongitude() + "<br>\n");
            fw.write("               Lat: " + us.getLatitude() + "<br>\n");
            fw.write("               Strike: " + us.getStrike() + "<br>\n");
            fw.write("               Slip: " + us.getSlip() + "<br>\n");
            fw.write("               Dip: " + us.getDip() + "<br>\n");
            fw.write("               Depth: " + us.getDepth() + "<br>\n");
            fw.write("               Length: " + us.getLength() + "<br>\n");
            fw.write("               Width: " + us.getWidth() + "<br>\n");
            fw.write("               Rake: " + us.getRake() + "<br></p>\n");
            fw.write("           ]]>\n");
            fw.write("        </description>\n");
            fw.write("        <styleUrl>#fault</styleUrl>\n");
            fw.write("        <Polygon>\n");
            fw.write("          <tessellate>1</tessellate>\n");
            fw.write("          <altitudeMode>relativeToGround</altitudeMode>\n");
            fw.write("          <outerBoundaryIs>\n");
            fw.write("            <LinearRing>\n");
            fw.write("            <coordinates> " + rect[0].x + "," + rect[0].y + ",1000\n");
            fw.write("               " + rect[1].x + "," + rect[1].y + ",1000\n");
            fw.write("               " + rect[2].x + "," + rect[2].y + ",1000\n");
            fw.write("               " + rect[3].x + "," + rect[3].y + ",1000\n");
            fw.write("               " + rect[0].x + "," + rect[0].y + ",1000 </coordinates>\n");
            fw.write("            </LinearRing>\n");
            fw.write("          </outerBoundaryIs>\n");
            fw.write("        </Polygon>\n");
            fw.write("      </Placemark>\n");
        }
        catch (IOException ioe) {
            SiftShare.log.log(Level.WARNING, "error", ioe);
        }
    }

    public void WriteKMZfile(IndeterminateProgressMonitor pm, SourceCombo sc, MostExtremaPanel mep, SBathyGridsPanel bgp, MostResultsPanel mrp, JTabbedPane otp, SeismicEvent currentEvent) {
        double minLon = -180.0;
        double maxLon = 180.0;
        double minLat = -90.0;
        double maxLat = 90.0;
        int skip = this.getSkip();
        String gridLetter = "A";
        MOSTGrid mostGrid = mrp.getMostGrid();
        SAnimPanel sAnimPanel = mrp.getSAnimPanel();
        SMaxImagePanel mip = mep.getSMaxImagePanel();
        SiteInfo siteInfo = CMIUtil.currentSiteInfo;
        GregorianCalendar cal = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        boolean contoursPlotted = mrp.contoursPlotted();
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            int len;
            FileInputStream in;
            File imagesDir = new File(CMIUtil.currentSiteInfo.getSiteDirectory(), "images");
            CMIUtil.deleteDir(imagesDir);
            if (!imagesDir.exists()) {
                imagesDir.mkdir();
            }
            byte[] buf = new byte[1024];
            this.kmzFile.delete();
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(this.kmzFile));
            double aGridMinLon = siteInfo.getBathyGrid(1).getMinLon();
            double aGridMaxLon = siteInfo.getBathyGrid(1).getMaxLon();
            double aGridMinLat = siteInfo.getBathyGrid(1).getMinLat();
            double aGridMaxLat = siteInfo.getBathyGrid(1).getMaxLat();
            double bGridMinLon = siteInfo.getBathyGrid(2).getMinLon();
            double bGridMaxLon = siteInfo.getBathyGrid(2).getMaxLon();
            double bGridMinLat = siteInfo.getBathyGrid(2).getMinLat();
            double bGridMaxLat = siteInfo.getBathyGrid(2).getMaxLat();
            double cGridMinLon = siteInfo.getBathyGrid(3).getMinLon();
            double cGridMaxLon = siteInfo.getBathyGrid(3).getMaxLon();
            double cGridMinLat = siteInfo.getBathyGrid(3).getMinLat();
            double cGridMaxLat = siteInfo.getBathyGrid(3).getMaxLat();
            double lookAtLon = this.convertLongitude180toMinus180((aGridMaxLon + aGridMinLon) / 2.0);
            double lookAtLat = (aGridMaxLat + aGridMinLat) / 2.0;
            aGridMaxLon = this.convertLongitude180toMinus180(aGridMaxLon);
            aGridMinLon = this.convertLongitude180toMinus180(aGridMinLon);
            bGridMaxLon = this.convertLongitude180toMinus180(bGridMaxLon);
            bGridMinLon = this.convertLongitude180toMinus180(bGridMinLon);
            cGridMaxLon = this.convertLongitude180toMinus180(cGridMaxLon);
            cGridMinLon = this.convertLongitude180toMinus180(cGridMinLon);
            File docFile = new File(siteInfo.getSiteDirectory(), "doc.kml");
            docFile.delete();
            FileWriter fw = new FileWriter(docFile);
            fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            fw.write("<kml xmlns=\"http://www.opengis.net/kml/2.2\"\n");
            fw.write("     xmlns:gx=\"http://www.google.com/kml/ext/2.2\">\n");
            fw.write("  <Document>\n");
            fw.write("    <name>MOST Model Output: " + this.getName() + " Mw: " + this.dfx.format(sc.getMomentMagnitude()) + "</name>\n");
            fw.write("    <open>1</open>\n");
            fw.write("    <description>\n");
            fw.write("           <![CDATA[\n");
            fw.write("               <b>MOST Inundation simulation for " + this.getName() + "</b>\n");
            fw.write("               <p>Information about the Community Model Interface for Tsunamis:<br>\n");
            fw.write("             http://nctr.pmel.noaa.gov/ComMIT<br></p>\n");
            if (currentEvent != null) {
                fw.write("<p>Event: " + currentEvent.Print() + "</p>\n");
            }
            fw.write("<p>Source fault magnitude (Mw): " + this.dfx.format(sc.getMomentMagnitude()) + "</p>\n");
            fw.write("           ]]>\n");
            fw.write("MOST Inundation simulation for " + this.getName() + "\n");
            fw.write("    </description>\n");
            fw.write("     <LookAt>\n");
            fw.write("       <longitude>" + lookAtLon + "</longitude>\n");
            fw.write("       <latitude>" + lookAtLat + "</latitude>\n");
            fw.write("       <range>700000</range>\n");
            fw.write("     </LookAt>\n");
            fw.write("      <Style id=\"transGreen\">\n");
            fw.write("        <LineStyle>\n");
            fw.write("          <color>cf00ff00</color>\n");
            fw.write("          <width>4</width>\n");
            fw.write("        </LineStyle>\n");
            fw.write("      </Style>\n");
            fw.write("      <Style id=\"transYellow\">\n");
            fw.write("        <LineStyle>\n");
            fw.write("          <color>cf00ffff</color>\n");
            fw.write("          <width>4</width>\n");
            fw.write("        </LineStyle>\n");
            fw.write("      </Style>\n");
            fw.write("      <Style id=\"transRed\">\n");
            fw.write("        <LineStyle>\n");
            fw.write("          <color>cf0000ff</color>\n");
            fw.write("          <width>4</width>\n");
            fw.write("        </LineStyle>\n");
            fw.write("      </Style>\n");
            fw.write("      <Style id=\"fault\">\n");
            fw.write("        <LineStyle>\n");
            fw.write("          <color>cfffffcc</color>\n");
            fw.write("          <width>4</width>\n");
            fw.write("        </LineStyle>\n");
            fw.write("        <PolyStyle>\n");
            fw.write("          <color>ff00ff00</color>\n");
            fw.write("        </PolyStyle>\n");
            fw.write("      </Style>\n");
            fw.write("    <Folder>\n");
            fw.write("      <name>MOST Grid Extents</name>\n");
            fw.write("      <open>0</open>\n");
            fw.write("      <visibility>0</visibility>\n");
            fw.write("      <description>MOST nested grids</description>\n");
            fw.write("      <Placemark>\n");
            fw.write("        <name>" + siteInfo.getName() + " A-Grid Outline</name>\n");
            fw.write("        <visibility>0</visibility>\n");
            fw.write("        <description>" + siteInfo.getName() + " A-Grid Outline</description>\n");
            fw.write("        <styleUrl>#transGreen</styleUrl>\n");
            fw.write("        <LineString>\n");
            fw.write("          <tessellate>1</tessellate>\n");
            fw.write("          <altitudeMode>relative</altitudeMode>\n");
            fw.write("          <coordinates> " + aGridMinLon + "," + aGridMinLat + ",140.0\n");
            fw.write("               " + aGridMaxLon + "," + aGridMinLat + ",140.0\n");
            fw.write("               " + aGridMaxLon + "," + aGridMaxLat + ",140.0\n");
            fw.write("               " + aGridMinLon + "," + aGridMaxLat + ",140.0\n");
            fw.write("               " + aGridMinLon + "," + aGridMinLat + ",140.0 </coordinates>\n");
            fw.write("        </LineString>\n");
            fw.write("      </Placemark>\n");
            fw.write("      <Placemark>\n");
            fw.write("        <name>" + siteInfo.getName() + " B-Grid Outline</name>\n");
            fw.write("        <visibility>0</visibility>\n");
            fw.write("        <description>" + siteInfo.getName() + " B-Grid Outline</description>\n");
            fw.write("        <styleUrl>#transYellow</styleUrl>\n");
            fw.write("        <LineString>\n");
            fw.write("          <tessellate>0</tessellate>\n");
            fw.write("          <altitudeMode>relative</altitudeMode>\n");
            fw.write("          <coordinates> " + bGridMinLon + "," + bGridMinLat + ",140.0\n");
            fw.write("               " + bGridMaxLon + "," + bGridMinLat + ",140.0\n");
            fw.write("               " + bGridMaxLon + "," + bGridMaxLat + ",140.0\n");
            fw.write("               " + bGridMinLon + "," + bGridMaxLat + ",140.0\n");
            fw.write("               " + bGridMinLon + "," + bGridMinLat + ",140.0 </coordinates>\n");
            fw.write("        </LineString>\n");
            fw.write("      </Placemark>\n");
            fw.write("      <Placemark>\n");
            fw.write("        <name>" + siteInfo.getName() + " C-Grid Outline</name>\n");
            fw.write("        <visibility>0</visibility>\n");
            fw.write("        <description>" + siteInfo.getName() + " C-Grid Outline</description>\n");
            fw.write("        <styleUrl>#transRed</styleUrl>\n");
            fw.write("        <LineString>\n");
            fw.write("          <tessellate>0</tessellate>\n");
            fw.write("          <altitudeMode>relative</altitudeMode>\n");
            fw.write("          <coordinates> " + cGridMinLon + "," + cGridMinLat + ",140.0\n");
            fw.write("               " + cGridMaxLon + "," + cGridMinLat + ",140.0\n");
            fw.write("               " + cGridMaxLon + "," + cGridMaxLat + ",140.0\n");
            fw.write("               " + cGridMinLon + "," + cGridMaxLat + ",140.0\n");
            fw.write("               " + cGridMinLon + "," + cGridMinLat + ",140.0 </coordinates>\n");
            fw.write("        </LineString>\n");
            fw.write("      </Placemark>\n");
            fw.write("    </Folder>\n");
            Vector<UnitSource> sourceVector = sc.getSources();
            if (sc.getNumberOfSources() > 0) {
                fw.write("    <Folder>\n");
                fw.write("      <name>Fault Planes</name>\n");
                fw.write("      <open>0</open>\n");
                fw.write("      <visibility>0</visibility>\n");
                fw.write("      <description>Fault Planes used to force MOST model</description>\n");
                for (UnitSource aSource : sourceVector) {
                    this.writeFault(fw, aSource);
                }
                fw.write("    </Folder>\n");
            }
            fw.write("    <Folder>\n");
            fw.write("      <name>MOST Model Output</name>\n");
            fw.write("      <open>1</open>\n");
            fw.write("      <visibility>1</visibility>\n");
            fw.write("      <description>MOST Model Output</description>\n");
            if (this.maxAmpSelected()) {
                fw.write("    <Folder>\n");
                fw.write("      <name>Model Extrema</name>\n");
                fw.write("      <open>0</open>\n");
                fw.write("      <visibility>1</visibility>\n");
                fw.write("      <description>Model Extrema: all Grids</description>\n");
                lookAtLon = (cGridMaxLon + cGridMinLon) / 2.0;
                if (lookAtLon > 180.0) {
                    lookAtLon = (lookAtLon + 180.0) % 360.0 - 180.0;
                }
                lookAtLat = (cGridMaxLat + cGridMinLat) / 2.0;
                fw.write("       <LookAt>\n");
                fw.write("         <longitude>" + lookAtLon + "</longitude>\n");
                fw.write("         <latitude>" + lookAtLat + "</latitude>\n");
                fw.write("         <range>15000</range>\n");
                fw.write("       </LookAt>\n");
                for (int gridIdentifier = 1; gridIdentifier <= 3; ++gridIdentifier) {
                    gridLetter = BathyGrid.getGridLetter(gridIdentifier);
                    File maxImageFile = new File(imagesDir, "maxWave" + gridLetter + ".png");
                    otp.setSelectedIndex(4);
                    mip.getGridSelectorControl().setSelectedGrid(gridIdentifier);
                    mip.showTopography(false);
                    mip.showBoxes(false);
                    mip.resetZoom();
                    mip.savePanelImage(maxImageFile, true, false, false);
                    mip.showTopography(true);
                    mip.showBoxes(true);
                    File maxImageCBFile = new File(imagesDir, "maxWaveColorbar" + gridLetter + ".png");
                    mip.saveColorbarImage(maxImageCBFile, false);
                    switch (gridIdentifier) {
                        case 1: {
                            minLat = aGridMinLat;
                            maxLat = aGridMaxLat;
                            minLon = aGridMinLon;
                            maxLon = aGridMaxLon;
                            break;
                        }
                        case 2: {
                            minLat = bGridMinLat;
                            maxLat = bGridMaxLat;
                            minLon = bGridMinLon;
                            maxLon = bGridMaxLon;
                            break;
                        }
                        case 3: {
                            minLat = cGridMinLat;
                            maxLat = cGridMaxLat;
                            minLon = cGridMinLon;
                            maxLon = cGridMaxLon;
                        }
                    }
                    fw.write("      <Folder>\n");
                    fw.write("        <name>" + gridLetter + "-Grid Extrema</name>\n");
                    fw.write("        <open>0</open>\n");
                    if (gridIdentifier == 3 && !this.animCheckBox.isSelected() || gridIdentifier == 3 && this.gridSelected(3)) {
                        fw.write("        <visibility>1</visibility>\n");
                    } else {
                        fw.write("        <visibility>0</visibility>\n");
                    }
                    fw.write("        <description>MOST Model Output</description>\n");
                    fw.write("        <GroundOverlay>\n");
                    switch (mip.getExtrema()) {
                        case 0: {
                            fw.write("          <name>" + gridLetter + "-Grid Maximum Wave</name>\n");
                            break;
                        }
                        case 2: {
                            fw.write("          <name>" + gridLetter + "-Grid Minimum Wave</name>\n");
                            break;
                        }
                        case 3: {
                            fw.write("          <name>" + gridLetter + "-Grid Maximum Speed</name>\n");
                        }
                    }
                    if (gridIdentifier == 3) {
                        fw.write("        <visibility>1</visibility>\n");
                    } else {
                        fw.write("        <visibility>0</visibility>\n");
                    }
                    switch (mip.getExtrema()) {
                        case 0: {
                            fw.write("          <description>" + gridLetter + "-Grid Maximum Wave Amplitude [cm]</description>\n");
                            break;
                        }
                        case 2: {
                            fw.write("          <description>" + gridLetter + "-Grid Minimum Wave Amplitude [cm]</description>\n");
                            break;
                        }
                        case 3: {
                            fw.write("          <description>" + gridLetter + "-Grid Maximum Current Speed [cm/s]</description>\n");
                        }
                    }
                    fw.write("          <color>aaffffff</color>\n");
                    fw.write("          <Icon>\n");
                    fw.write("            <href>images/maxWave" + gridLetter + ".png</href>\n");
                    fw.write("          </Icon>\n");
                    fw.write("          <gx:altitudeMode>clampToSeaFloor</gx:altitudeMode>\n");
                    fw.write("          <LatLonBox>\n");
                    fw.write("            <north>" + maxLat + "</north>\n");
                    fw.write("            <south>" + minLat + "</south>\n");
                    fw.write("            <east>" + minLon + "</east>\n");
                    fw.write("            <west>" + maxLon + "</west>\n");
                    fw.write("            <rotation>0.0</rotation>\n");
                    fw.write("          </LatLonBox>\n");
                    fw.write("        </GroundOverlay>\n");
                    fw.write("        <GroundOverlay>\n");
                    switch (mip.getExtrema()) {
                        case 0: {
                            fw.write("          <name>Maximum Wave Colorbar</name>\n");
                            break;
                        }
                        case 2: {
                            fw.write("          <name>Minimum Wave Colorbar</name>\n");
                            break;
                        }
                        case 3: {
                            fw.write("          <name>Maximum Speed Colorbar</name>\n");
                        }
                    }
                    if (gridIdentifier == 3) {
                        fw.write("        <visibility>1</visibility>\n");
                    } else {
                        fw.write("        <visibility>0</visibility>\n");
                    }
                    Rectangle2D.Double rec = mip.getColorbarImageCornersLatLon();
                    minLon = rec.x + 2.0 * rec.width;
                    maxLon = rec.x + rec.width;
                    switch (mip.getExtrema()) {
                        case 0: {
                            fw.write("          <description>Colorbar: Max Wave Amplitude [cm]</description>\n");
                            break;
                        }
                        case 2: {
                            fw.write("          <description>Colorbar: Min Wave Amplitude [cm]</description>\n");
                            break;
                        }
                        case 3: {
                            fw.write("          <description>Colorbar: Max Current Speed [cm/s]</description>\n");
                        }
                    }
                    fw.write("          <color>ffffffff</color>\n");
                    fw.write("          <Icon>\n");
                    fw.write("            <href>images/maxWaveColorbar" + gridLetter + ".png</href>\n");
                    fw.write("          </Icon>\n");
                    fw.write("          <gx:altitudeMode>clampToSeaFloor</gx:altitudeMode>\n");
                    fw.write("          <LatLonBox>\n");
                    fw.write("            <north>" + maxLat + "</north>\n");
                    fw.write("            <south>" + minLat + "</south>\n");
                    fw.write("            <east>" + minLon + "</east>\n");
                    fw.write("            <west>" + maxLon + "</west>\n");
                    fw.write("            <rotation>0.0</rotation>\n");
                    fw.write("          </LatLonBox>\n");
                    fw.write("        </GroundOverlay>\n");
                    fw.write("      </Folder>\n");
                    in = new FileInputStream(maxImageFile);
                    out.putNextEntry(new ZipEntry("images/maxWave" + gridLetter + ".png"));
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.closeEntry();
                    in.close();
                    in = new FileInputStream(maxImageCBFile);
                    out.putNextEntry(new ZipEntry("images/maxWaveColorbar" + gridLetter + ".png"));
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.closeEntry();
                    in.close();
                }
                fw.write("      </Folder>\n");
            }
            if (this.animCheckBox.isSelected() && this.numberOutputSteps > 0) {
                otp.setSelectedIndex(3);
                sAnimPanel.saveColorbarImage(new File(imagesDir, "WaveLegend.png"), false);
                for (int gridIdentifier = 1; gridIdentifier <= 3; ++gridIdentifier) {
                    if (!this.gridSelected(gridIdentifier)) continue;
                    gridLetter = BathyGrid.getGridLetter(gridIdentifier);
                    String imageFileName = "";
                    mrp.setGridShowing(gridIdentifier);
                    String gridName = gridLetter + "-Grid";
                    SiftShare.log.info("Saving anim for " + gridName);
                    fw.write("    <Folder>\n");
                    fw.write("      <name>" + gridName + " Wave Amplitude animation</name>\n");
                    fw.write("      <open>0</open>\n");
                    fw.write("      <visibility>1</visibility>\n");
                    fw.write("      <description>" + gridName + " Wave Amplitude animation</description>\n");
                    fw.write("      <ScreenOverlay>\n");
                    fw.write("        <name>Wave Amplitude Legend</name>\n");
                    fw.write("        <Icon><href>images/WaveLegend.png</href></Icon>\n");
                    fw.write("        <overlayXY x=\"0.5\" y=\"0.5\" xunits=\"faction\" yunits=\"fraction\"/>\n");
                    fw.write("        <screenXY x=\"0.1\" y=\"0.5\" xunits=\"fraction\" yunits=\"fraction\"/>\n");
                    fw.write("        <rotationXY x=\"0\" y=\"0\" xunits=\"fraction\" yunits=\"fraction\"/>\n");
                    fw.write("        <size x=\"0\" y=\"0\" xunits=\"fraction\" yunits=\"fraction\"/>\n");
                    fw.write("      </ScreenOverlay>\n");
                    switch (gridIdentifier) {
                        case 1: {
                            minLat = aGridMinLat;
                            maxLat = aGridMaxLat;
                            minLon = aGridMinLon;
                            maxLon = aGridMaxLon;
                            break;
                        }
                        case 2: {
                            minLat = bGridMinLat;
                            maxLat = bGridMaxLat;
                            minLon = bGridMinLon;
                            maxLon = bGridMaxLon;
                            break;
                        }
                        case 3: {
                            minLat = cGridMinLat;
                            maxLat = cGridMaxLat;
                            minLon = cGridMinLon;
                            maxLon = cGridMaxLon;
                        }
                    }
                    sAnimPanel.showTopography(false);
                    sAnimPanel.showBoxes(false);
                    sAnimPanel.plotContours(false, true);
                    if (currentEvent != null) {
                        cal = (GregorianCalendar)GregorianCalendar.getInstance();
                        cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                        cal.setTime(currentEvent.getCalendar().getTime());
                        cal.add(13, (int)mostGrid.getTime(0));
                    } else {
                        cal = (GregorianCalendar)GregorianCalendar.getInstance();
                    }
                    for (int step = 0; step < this.lastStep; step += skip) {
                        imageFileName = String.format("grid%s%05d.png", gridLetter, step + 1);
                        try {
                            mrp.setTimeStep(step);
                            sAnimPanel.savePanelImage(new File(imagesDir, imageFileName), true, false, false);
                        }
                        catch (NegativeArraySizeException nase) {
                            SiftShare.log.log(Level.WARNING, "SGT failed to contour again :( ", nase);
                            continue;
                        }
                        fw.write("      <GroundOverlay>\n");
                        fw.write("        <name>" + gridName + " Wave Amplitude at timestep " + (step + 1) + "</name>\n");
                        fw.write("        <description>" + gridName + " Wave Amplitude [cm]</description>\n");
                        fw.write("        <TimeSpan>\n");
                        fw.write("          <begin>" + sdf.format(cal.getTime()) + "Z</begin>\n");
                        cal.setTimeInMillis(cal.getTimeInMillis() + (long)((double)skip * CMIUtil.currentSiteInfo.getOutputTimestep() * 1000.0));
                        fw.write("          <end>" + sdf.format(cal.getTime()) + "Z</end>\n");
                        fw.write("        </TimeSpan>\n");
                        fw.write("        <Icon>\n");
                        fw.write("          <href>images/" + imageFileName + "</href>\n");
                        fw.write("        </Icon>\n");
                        fw.write("        <gx:altitudeMode>clampToSeaFloor</gx:altitudeMode>\n");
                        fw.write("        <LatLonBox>\n");
                        fw.write("          <north>" + maxLat + "</north>\n");
                        fw.write("          <south>" + minLat + "</south>\n");
                        fw.write("          <east>" + minLon + "</east>\n");
                        fw.write("          <west>" + maxLon + "</west>\n");
                        fw.write("          <rotation>0.0</rotation>\n");
                        fw.write("        </LatLonBox>\n");
                        fw.write("      </GroundOverlay>\n");
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException ex) {
                            break;
                        }
                        File imageFile = new File(imagesDir, imageFileName);
                        in = new FileInputStream(imageFile);
                        out.putNextEntry(new ZipEntry("images/" + imageFileName));
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                        out.closeEntry();
                        in.close();
                    }
                    sAnimPanel.showTopography(true);
                    sAnimPanel.showBoxes(true);
                    fw.write("    </Folder>\n");
                    if (pm.isCanceled()) break;
                }
                File waveLegendFile = new File(imagesDir, "WaveLegend.png");
                in = new FileInputStream(waveLegendFile);
                out.putNextEntry(new ZipEntry("images/WaveLegend.png"));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            fw.write("    </Folder>\n");
            fw.write("  </Document>\n");
            fw.write("</kml>\n");
            fw.write("\n");
            fw.close();
            in = new FileInputStream(docFile);
            out.putNextEntry(new ZipEntry("doc.kml"));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            in.close();
            out.close();
            try {
                sAnimPanel.plotContours(contoursPlotted, false);
            }
            catch (NegativeArraySizeException negativeArraySizeException) {}
        }
        catch (IOException ioe) {
            SiftShare.log.log(Level.WARNING, "error", ioe);
        }
    }

    public double convertLongitude180toMinus180(double lon) {
        if (lon <= 180.0) {
            return lon;
        }
        return (lon + 180.0) % 360.0 - 180.0;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SaveGEDialog dialog = new SaveGEDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setNumberOutputSteps(600);
                dialog.setVisible(true);
            }
        });
    }
}

