/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.AboutDialog;
import gov.noaa.tsunami.cmi.AbstractGridTool;
import gov.noaa.tsunami.cmi.AlwaysAskYesNoDialog;
import gov.noaa.tsunami.cmi.BathyCropTool;
import gov.noaa.tsunami.cmi.BathyLonsTool;
import gov.noaa.tsunami.cmi.BathySmoothTool;
import gov.noaa.tsunami.cmi.BathySubsample;
import gov.noaa.tsunami.cmi.BathyVerticalAdjust;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.ClearModelRunDialog;
import gov.noaa.tsunami.cmi.ComMITServerSelector;
import gov.noaa.tsunami.cmi.CommandLineModelListener;
import gov.noaa.tsunami.cmi.CompositeMaxDialog;
import gov.noaa.tsunami.cmi.CopySiteDialog;
import gov.noaa.tsunami.cmi.DeleteSiteDialog;
import gov.noaa.tsunami.cmi.GridInfoFrame;
import gov.noaa.tsunami.cmi.GridSelectorPanel;
import gov.noaa.tsunami.cmi.IndeterminateProgressMonitor;
import gov.noaa.tsunami.cmi.LinCombModule;
import gov.noaa.tsunami.cmi.MOSTInputPanel;
import gov.noaa.tsunami.cmi.ModelEvent;
import gov.noaa.tsunami.cmi.ModelListener;
import gov.noaa.tsunami.cmi.ModelRenameDialog;
import gov.noaa.tsunami.cmi.ModelRunComboBoxRenderer;
import gov.noaa.tsunami.cmi.ModelRunFileView;
import gov.noaa.tsunami.cmi.ModelRunner;
import gov.noaa.tsunami.cmi.MostExecDownloader;
import gov.noaa.tsunami.cmi.MostExtremaPanel;
import gov.noaa.tsunami.cmi.MostResultsPanel;
import gov.noaa.tsunami.cmi.NewModelRunWizard;
import gov.noaa.tsunami.cmi.OpenEventDialog;
import gov.noaa.tsunami.cmi.OutputMessageHandler;
import gov.noaa.tsunami.cmi.PasteInversionDialog;
import gov.noaa.tsunami.cmi.PrefsDialog;
import gov.noaa.tsunami.cmi.PropRunPanel;
import gov.noaa.tsunami.cmi.SBathyGridsPanel;
import gov.noaa.tsunami.cmi.SICImagePanel;
import gov.noaa.tsunami.cmi.SaveGEDialog;
import gov.noaa.tsunami.cmi.SimpleFileFilter;
import gov.noaa.tsunami.cmi.SiteInfo;
import gov.noaa.tsunami.cmi.SortedComboBoxModel;
import gov.noaa.tsunami.cmi.SplashScreen;
import gov.noaa.tsunami.cmi.SwingWorker;
import gov.noaa.tsunami.cmi.TideGaugeClient;
import gov.noaa.tsunami.cmi.TwebUploadDialog;
import gov.noaa.tsunami.cmi.UploadDialog;
import gov.noaa.tsunami.cmi.macosx.JAnimatingProgressBar;
import gov.noaa.tsunami.cmi.macosx.OSXAdapter;
import gov.noaa.tsunami.utility.nc.NCUtil;
import gov.noaa.tsunami.websift.ee.EventEditor2;
import gov.noaa.tsunami.websift.events.BasinBoundaries;
import gov.noaa.tsunami.websift.events.CountryBoundaries;
import gov.noaa.tsunami.websift.events.SeismicEvent;
import gov.noaa.tsunami.websift.propdb.PropFileReaderBase;
import gov.noaa.tsunami.websift.propdb.PropGrid;
import gov.noaa.tsunami.websift.propdb.PropagationDatabase;
import gov.noaa.tsunami.websift.propdb.PropagationDatabaseException;
import gov.noaa.tsunami.websift.propdb.SourceCombo;
import gov.noaa.tsunami.websift.propdb.SourceScenario;
import gov.noaa.tsunami.websift.propdb.UnitSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dods.DODSNetcdfFile;

public final class SiftShare
extends JFrame
implements ActionListener,
PropertyChangeListener {
    public static final String VERSION = "1.8.6";
    public static final String RELDATE = "December 2025";
    public static final boolean DEBUG = false;
    public static final String WINDOW_TITLE_TEXT = "ComMIT: Community Model Interface for Tsunami 1.8.6";
    private static FileHandler fh;
    public static final Logger log;
    protected final Preferences preferences;
    private final PrefsDialog prefsDialog;
    private final MostResultsPanel mostResultsPanel;
    private final EventEditor2 eventEditor;
    private final MOSTInputPanel mostInputPanel = new MOSTInputPanel();
    private ModelRunner mostModelRunner = null;
    protected boolean creatinglinComb;
    private final SBathyGridsPanel sBathyPanel;
    private final SICImagePanel sicPanel;
    private final MostExtremaPanel mostExtremaPanel;
    private PropRunPanel propRunPanel;
    private JFrame propRunFrame = null;
    private GridInfoFrame gif = null;
    private final List<ModelListener> modelListeners = new ArrayList<ModelListener>();
    private final SiftShare mainApp;
    private final MostExecDownloader MED;
    private final OutputMessageHandler outputMessages;
    private final ArrayList<SiteInfo> openSites = new ArrayList();
    private final Icon modelStopIcon = new ImageIcon(this.getClass().getResource("images/Stop16.gif"));
    private final Icon modelStartIcon = new ImageIcon(this.getClass().getResource("images/Play16.gif"));
    private final SortedComboBoxModel<String> sourceComboBoxModel = new SortedComboBoxModel<String>(new String[]{"add a source"});
    private AbstractGridTool currentGridTool = null;
    private SaveGEDialog saveGEDialog = null;
    private CompositeMaxDialog compositeMaxDialog = null;
    private boolean listenForSourceChanges = true;
    private boolean resettingSourceComboBoxModel = false;
    private boolean runningAllSources = false;
    private JMenuItem aboutMenuItem;
    private JMenuItem addSourceMenuItem;
    private JMenuItem adjustMenuItem;
    private JPanel bathyGridPanel;
    private GridSelectorPanel bathyGridSelector;
    private ButtonGroup buttonGroup1;
    private JMenuItem cflMenuItem;
    private JMenuItem cleanMenuItem;
    private JMenuItem closeAllMenuItem;
    private JMenuItem closeRunMenuItem;
    private JMenuItem compositeMenuItem;
    private JMenuItem contentsMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem createMenuItem;
    private JMenuItem cropBathyMenuItem;
    private JMenuItem customPropMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenu editMenu;
    private JPanel eePanel;
    private JMenuItem emailLogMenuItem;
    private JMenuItem eventMenuItem;
    private JMenuItem eventRemoveMenuItem;
    private JMenuItem exitMenuItem;
    private JMenuItem exportMenuItem;
    private JMenuItem exportSourcesMenuItem;
    private JMenu fileMenu;
    private JPanel gridPanel;
    private JMenuItem hazardMenuItem;
    private JMenu helpMenu;
    private JPanel icPanel;
    private JMenuItem importMenuItem;
    private JMenuItem importSourcesMenuItem;
    private JMenuItem invertMenuItem;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JMenu jMenu1;
    private JToolBar jToolBar2;
    private JToolBar jToolBar3;
    private JMenuItem leftRightMenuItem;
    private JMenuItem longitudeMenuItem;
    private JPanel maxWaveOuterPanel;
    private JMenuBar menuBar;
    private JScrollPane modelLogPane;
    private JTextArea modelLogTextArea;
    private JButton modelNameButton;
    private JAnimatingProgressBar modelProgressBar;
    private JPanel modelSetupPanel;
    private JScrollPane mostInputScrollPane;
    private JPanel nameAndEventPanel;
    private JMenuItem openRunMenuItem;
    private JTabbedPane outputTabbedPane;
    private JMenuItem pastedMenuItem;
    private JMenuItem prefsMenuItem;
    private JLabel projectLabel;
    private JCheckBoxMenuItem propExtentsCheckBoxMenuItem;
    private JMenuItem propMenuItem;
    private JMenuItem publishMenuItem;
    private JMenuItem removeSourceMenuItem;
    private JMenuItem renameMenuItem;
    private JButton runCancelButton;
    private JMenuItem saveAnimMenuItem;
    private JMenuItem saveGEMenuItem;
    private JMenuItem saveTSMenuItem;
    private JComboBox siteComboBox;
    private JMenuItem smoothBathyMenuItem;
    private JComboBox<String> sourceComboBox;
    private JMenuItem sslBathyMenuItem;
    private JMenuItem subsampleBathyMenuItem;
    private JMenuItem upDownMenuItem;
    private JMenuItem viewLogMenuItem;
    private JMenu viewMenu;
    private JPanel wavePanel;

    public SiftShare(SplashScreen splashScreen) {
        this.mainApp = this;
        if (SiftShare.checkJavaVersion() < 1.8f) {
            JOptionPane.showMessageDialog(null, "ComMIT requires Java version 1.8 or greater to run.\n(http://www.java.com/download/)", "Newer Java Required", 2);
            System.exit(11);
        }
        splashScreen.setInfoString("Initializing...");
        this.initComponents();
        this.outputMessages = new OutputMessageHandler(this.modelLogTextArea, this.modelProgressBar);
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                log.info("Detected window closing event, calling closeApp().");
                if (SiftShare.this.closeApp()) {
                    System.exit(0);
                } else {
                    SiftShare.this.setDefaultCloseOperation(0);
                }
            }
        };
        this.addWindowListener(l);
        this.preferences = Preferences.userNodeForPackage(this.getClass());
        this.prefsDialog = new PrefsDialog(this, true, this.preferences);
        try {
            File f = CMIUtil.unpackFile(this, "maplayers/cmiConsoleLogging.conf", new File(CMIUtil.etcDirName), "cmiConsoleLogging.conf");
            LogManager.getLogManager().readConfiguration(new FileInputStream(new File(CMIUtil.etcDirName, "cmiConsoleLogging.conf")));
            fh = new FileHandler(CMIUtil.etcDirName + File.separator + "commit%g.log", 512000, 3, true);
            fh.setFormatter(new SimpleFormatter());
            fh.setLevel(Level.parse(CMIUtil.logLevel));
            log.addHandler(fh);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.setLevel(Level.ALL);
        log.info("\n\n\nStarting ComMIT ver: 1.8.6\n\n");
        log.info("\nComMIT app dir: " + CMIUtil.baseDirName + "\nComMIT etc dir: " + CMIUtil.etcDirName + "\nComMIT grids dir: " + CMIUtil.gridsDirName + "\nComMIT scratch dir: " + CMIUtil.workingDirName + "\nComMIT MOST exe: " + CMIUtil.MOST_EXEC + "\nProDB global: " + CMIUtil.propGlobal);
        PropagationDatabase propdb = PropagationDatabase.getInstance();
        propdb.setLogger(log);
        this.addPropertyChangeListener("currentSite", this.prefsDialog);
        this.addPropertyChangeListener("openSites", this.prefsDialog);
        TideGaugeClient.getGaugeLocations(this);
        try {
            File f = CMIUtil.unpackFile(this, "maplayers/countryReducedAKandHI.kml", new File(CMIUtil.etcDirName), "countryReducedAKandHI.kml");
            CountryBoundaries.loadCountries(f);
            f = CMIUtil.unpackFile(this, "maplayers/basin.kml", new File(CMIUtil.etcDirName), "basin.kml");
            BasinBoundaries.loadBasins(f);
            f = CMIUtil.unpackFile(this, "maplayers/ngdcEvents2022.txt", new File(CMIUtil.etcDirName), "ngdcEvents2022.txt");
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "Error unpacking country/basin/NGDC event files", ex);
        }
        EventEditor2.DEBUG = CMIUtil.DEBUG = false;
        this.eventEditor = new EventEditor2();
        try {
            File testFile = null;
            this.eventEditor.setBackgroundImage(this.getClass().getResource("images/world_all_4096x2048comp.jpg"), new Rectangle2D.Double(0.0, -90.0, 360.0, 180.0));
            testFile = CMIUtil.unpackFile(this, "images/wdb_borders_i.b.gz", new File(CMIUtil.etcDirName), "wdb_borders_i.b");
            this.eventEditor.setBorders(testFile.toURI().toURL());
            testFile = CMIUtil.unpackFile(this, "maplayers/gshhs_c.nc", new File(CMIUtil.etcDirName), "gshhs_c.nc");
            this.eventEditor.addLandMass(testFile, 1);
            testFile = CMIUtil.unpackFile(this, "maplayers/gshhs_f.nc", new File(CMIUtil.etcDirName), "gshhs_f.nc");
            this.eventEditor.addLandMass(testFile, 16);
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "Error", ex);
        }
        this.eventEditor.setEditMode(1);
        this.eventEditor.setLogger(log);
        this.eventEditor.setMaxZoomLevel(31);
        this.eventEditor.setMinZoomLevel(6);
        this.eventEditor.zoomTo(200.0, 0.0);
        this.eventEditor.zoom(10);
        this.eventEditor.setPropFolder(CMIUtil.propDirName);
        this.eventEditor.plotPlaces(true);
        this.eePanel.add((Component)this.eventEditor, "Center");
        this.MED = new MostExecDownloader(this, this.prefsDialog);
        this.addPropertyChangeListener("currentSite", this);
        this.addPropertyChangeListener("sourceSwitched", this);
        this.sicPanel = new SICImagePanel();
        this.icPanel.add((Component)this.sicPanel, "Center");
        this.addPropertyChangeListener("currentSite", this.sicPanel);
        this.addPropertyChangeListener("sourceSwitched", this.sicPanel);
        this.addModelListener(this.sicPanel);
        this.outputTabbedPane.addChangeListener(this.sicPanel);
        this.mostExtremaPanel = new MostExtremaPanel();
        this.maxWaveOuterPanel.add((Component)this.mostExtremaPanel, "Center");
        this.addPropertyChangeListener("currentSite", this.mostExtremaPanel.getSMaxImagePanel());
        this.addPropertyChangeListener("sourceSwitched", this.mostExtremaPanel.getSMaxImagePanel());
        this.addModelListener(this.mostExtremaPanel.getSMaxImagePanel());
        this.outputTabbedPane.addChangeListener(this.mostExtremaPanel.getSMaxImagePanel());
        this.sBathyPanel = new SBathyGridsPanel();
        this.sBathyPanel.setGridSelectorControl(this.bathyGridSelector);
        this.gridPanel.add((Component)this.sBathyPanel, "Center");
        this.addPropertyChangeListener("currentSite", this.sBathyPanel);
        this.outputTabbedPane.addChangeListener(this.sBathyPanel);
        this.mostResultsPanel = new MostResultsPanel();
        this.wavePanel.add((Component)this.mostResultsPanel, "Center");
        this.addPropertyChangeListener("currentSite", this.mostResultsPanel);
        this.addPropertyChangeListener("sourceSwitched", this.mostResultsPanel);
        this.addPropertyChangeListener("sourceScenario", this.mostResultsPanel);
        this.addModelListener(this.mostResultsPanel);
        this.outputTabbedPane.addChangeListener(this.mostResultsPanel);
        this.mostInputScrollPane.getViewport().add(this.mostInputPanel);
        this.addPropertyChangeListener("currentSite", this.mostInputPanel);
        this.addModelListener(new SiftShareModelListener());
        this.platformSpecificUI();
        this.pack();
        int windowX = this.preferences.getInt("WINDOW_X", 0);
        int windowY = this.preferences.getInt("WINDOW_Y", 0);
        int windowWidth = this.preferences.getInt("WINDOW_WIDTH", 1150);
        int windowHeight = this.preferences.getInt("WINDOW_HEIGHT", 900);
        log.info("Setting app bounds: " + windowX + " " + windowY + " " + windowWidth + " " + windowHeight);
        this.setBounds(new Rectangle(windowX, windowY, windowWidth, windowHeight));
        this.mostResultsPanel.setSplitPanePosition(this.preferences.getInt("SPLIT_POS", 600));
        splashScreen.setInfoString("Opening model run...");
        this.eventEditor.addActionListener(this);
    }

    private void openPreviousModels() {
        log.log(Level.FINE, "Opening previous Model Runs");
        List<Path> odirs = this.prefsDialog.getOpenModelDirectories();
        StringBuilder errors = new StringBuilder();
        SiteInfo lastSite = null;
        for (Path path : odirs) {
            try {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    this.openSite(new SiteInfo(path));
                    continue;
                }
                errors.append(path).append(" does not appear to be a model run directory.<br>");
            }
            catch (IOException ex) {
                errors.append(ex.getMessage()).append("<br>");
            }
        }
        File sf = this.prefsDialog.getStartupModelDirectory();
        if (sf != null) {
            for (SiteInfo si : this.getOpenSites()) {
                if (!sf.equals(si.getSiteDirectory())) continue;
                lastSite = si;
                break;
            }
            if (lastSite == null && ModelRunFileView.isModelRunDirectory(sf)) {
                try {
                    lastSite = new SiteInfo(sf);
                }
                catch (IOException iOException) {
                    errors.append(iOException.getMessage()).append("<br>");
                }
            }
        }
        if (lastSite == null) {
            this.setCurrentSite(null, true);
        } else {
            this.setCurrentSite(lastSite);
        }
        if (errors.length() > 0) {
            log.log(Level.SEVERE, errors.toString());
            errors.insert(0, "<html>Error loading models:<p>").append("</html>");
            JOptionPane.showMessageDialog(this, errors.toString(), "Error loading models", 0);
        }
    }

    private void showInitialHelp() {
        if (CMIUtil.firstTimeUser) {
            CMIUtil.firstTimeUser = false;
            this.prefsDialog.savePrefs();
            this.showHelp();
        }
    }

    private void checkForComMITUpdate() {
        if (CMIUtil.workOffline) {
            return;
        }
        String ver = "";
        try {
            URL u = new URL(CMIUtil.commitServerAddress + "/download/ComMIT.update.properties");
            Properties props = new Properties();
            URLConnection con = u.openConnection();
            con.setConnectTimeout(5000);
            props.load(con.getInputStream());
            ver = props.getProperty("ComMIT.revision");
        }
        catch (IOException | IllegalArgumentException ex) {
            log.log(Level.WARNING, "Couldn't check ComMITServer for update properties", ex);
            return;
        }
        if (ver == null || ver.equals("")) {
            return;
        }
        if (this.compareVersion(ver) <= 0) {
            return;
        }
        log.info("ComMITServer has newer version of ComMIT (" + ver + ").");
        Object[] opts = new Object[]{"Now", "Later"};
        int ret = JOptionPane.showOptionDialog(this, "New version of ComMIT is available (" + ver + "), download?\nClicking \"Now\" will open a browser to download page...", "Download Update?", 0, 3, null, opts, opts);
        if (ret == 0) {
            try {
                Desktop.getDesktop().browse(new URI("https://sift.pmel.noaa.gov/ComMIT"));
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private int compareVersion(String ver) {
        int cmp = 0;
        if (ver.compareTo(VERSION) == 0) {
            return 0;
        }
        String[] varrS = ver.split("\\.");
        String[] varr = VERSION.split("\\.");
        if (varrS.length != 3 || varr.length != 3) {
            log.info("ComMIT version not in standard format, server: " + ver + " this VERSION: " + VERSION);
            return 0;
        }
        int major = 0;
        int majorS = 0;
        int minor = 0;
        int minorS = 0;
        int subminor = 0;
        int subminorS = 0;
        String qualifier = "";
        String qualifierS = "";
        try {
            major = Integer.parseInt(varrS[0]);
            majorS = Integer.parseInt(varr[0]);
            minorS = Integer.parseInt(varrS[1]);
            minor = Integer.parseInt(varr[1]);
            String[] sma = varr[2].split("\\d+");
            if (sma.length > 1) {
                qualifier = sma[1];
            }
            subminor = Integer.parseInt(varr[2].replaceAll(qualifier, ""));
            sma = varrS[2].split("\\d+");
            if (sma.length > 1) {
                qualifierS = sma[1];
            }
            subminorS = Integer.parseInt(varrS[2].replaceAll(qualifierS, ""));
        }
        catch (NumberFormatException nfe) {
            log.info("Can't parse version, server: " + ver);
            return 0;
        }
        if (majorS > major) {
            cmp = 1;
        } else if (minorS > minor) {
            cmp = 1;
        } else if (subminorS > subminor) {
            cmp = 1;
        } else if (majorS == major && minorS == minor && subminorS == subminor && qualifier.length() > 0) {
            cmp = 1;
        }
        return cmp;
    }

    private static float checkJavaVersion() {
        float ver;
        try {
            ver = Float.parseFloat(System.getProperty("java.specification.version"));
        }
        catch (NumberFormatException e) {
            log.severe("Can't parse Java version!");
            return 0.0f;
        }
        return ver;
    }

    public void setLogLevel(String levelName) {
        if (fh != null) {
            fh.setLevel(Level.parse(levelName));
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.outputTabbedPane = new JTabbedPane();
        this.modelSetupPanel = new JPanel();
        JPanel modelSetupTopPanel = new JPanel();
        this.eePanel = new JPanel();
        this.mostInputScrollPane = new JScrollPane();
        JPanel modelSetupBottomPanel = new JPanel();
        this.modelLogPane = new JScrollPane();
        this.modelLogTextArea = new JTextArea();
        this.nameAndEventPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.projectLabel = new JLabel();
        this.modelNameButton = new JButton();
        this.icPanel = new JPanel();
        this.jToolBar3 = new JToolBar();
        this.bathyGridPanel = new JPanel();
        this.gridPanel = new JPanel();
        this.jToolBar2 = new JToolBar();
        this.bathyGridSelector = new GridSelectorPanel();
        this.wavePanel = new JPanel();
        this.maxWaveOuterPanel = new JPanel();
        JPanel toolbarPanel = new JPanel();
        this.runCancelButton = new JButton();
        this.siteComboBox = new JComboBox();
        this.modelProgressBar = new JAnimatingProgressBar();
        this.sourceComboBox = new JComboBox();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openRunMenuItem = new JMenuItem();
        this.closeRunMenuItem = new JMenuItem();
        this.closeAllMenuItem = new JMenuItem();
        this.createMenuItem = new JMenuItem();
        this.renameMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.importMenuItem = new JMenuItem();
        this.exportMenuItem = new JMenuItem();
        this.cleanMenuItem = new JMenuItem();
        JSeparator jSeparator1 = new JSeparator();
        this.saveAnimMenuItem = new JMenuItem();
        this.saveTSMenuItem = new JMenuItem();
        this.publishMenuItem = new JMenuItem();
        this.saveGEMenuItem = new JMenuItem();
        this.compositeMenuItem = new JMenuItem();
        JSeparator jSeparator2 = new JSeparator();
        this.addSourceMenuItem = new JMenuItem();
        this.pastedMenuItem = new JMenuItem();
        this.eventMenuItem = new JMenuItem();
        this.exportSourcesMenuItem = new JMenuItem();
        this.importSourcesMenuItem = new JMenuItem();
        this.eventRemoveMenuItem = new JMenuItem();
        this.removeSourceMenuItem = new JMenuItem();
        this.hazardMenuItem = new JMenuItem();
        this.customPropMenuItem = new JMenuItem();
        JSeparator jSeparator3 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.prefsMenuItem = new JMenuItem();
        this.propMenuItem = new JMenuItem();
        JPopupMenu.Separator jSeparator4 = new JPopupMenu.Separator();
        this.jMenu1 = new JMenu();
        this.sslBathyMenuItem = new JMenuItem();
        this.smoothBathyMenuItem = new JMenuItem();
        this.cropBathyMenuItem = new JMenuItem();
        this.subsampleBathyMenuItem = new JMenuItem();
        this.upDownMenuItem = new JMenuItem();
        this.leftRightMenuItem = new JMenuItem();
        this.longitudeMenuItem = new JMenuItem();
        this.invertMenuItem = new JMenuItem();
        this.adjustMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.cflMenuItem = new JMenuItem();
        this.propExtentsCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.viewLogMenuItem = new JMenuItem();
        this.emailLogMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("ComMIT: Community Model Interface for Tsunami");
        this.outputTabbedPane.setOpaque(true);
        this.modelSetupPanel.setBackground(new Color(255, 255, 255));
        this.modelSetupPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        modelSetupTopPanel.setOpaque(false);
        this.eePanel.setBackground(new Color(255, 255, 255));
        this.eePanel.setBorder(BorderFactory.createTitledBorder("Unit Sources"));
        this.eePanel.setLayout(new BorderLayout());
        this.mostInputScrollPane.setBorder(BorderFactory.createTitledBorder("Model Parameters"));
        this.mostInputScrollPane.setHorizontalScrollBarPolicy(31);
        GroupLayout modelSetupTopPanelLayout = new GroupLayout(modelSetupTopPanel);
        modelSetupTopPanel.setLayout(modelSetupTopPanelLayout);
        modelSetupTopPanelLayout.setHorizontalGroup(modelSetupTopPanelLayout.createParallelGroup(1).add(2, modelSetupTopPanelLayout.createSequentialGroup().add(this.eePanel, -1, 444, Short.MAX_VALUE).addPreferredGap(0).add(this.mostInputScrollPane, -2, 391, -2)));
        modelSetupTopPanelLayout.setVerticalGroup(modelSetupTopPanelLayout.createParallelGroup(1).add(this.mostInputScrollPane, -1, 323, Short.MAX_VALUE).add(this.eePanel, -1, -1, Short.MAX_VALUE));
        modelSetupBottomPanel.setBackground(Color.white);
        modelSetupBottomPanel.setOpaque(false);
        this.modelLogPane.setBorder(BorderFactory.createTitledBorder("Model output log"));
        this.modelLogTextArea.setEditable(false);
        this.modelLogTextArea.setColumns(20);
        this.modelLogTextArea.setRows(5);
        this.modelLogTextArea.setBorder(null);
        this.modelLogPane.setViewportView(this.modelLogTextArea);
        GroupLayout modelSetupBottomPanelLayout = new GroupLayout(modelSetupBottomPanel);
        modelSetupBottomPanel.setLayout(modelSetupBottomPanelLayout);
        modelSetupBottomPanelLayout.setHorizontalGroup(modelSetupBottomPanelLayout.createParallelGroup(1).add(this.modelLogPane));
        modelSetupBottomPanelLayout.setVerticalGroup(modelSetupBottomPanelLayout.createParallelGroup(1).add(modelSetupBottomPanelLayout.createSequentialGroup().add(this.modelLogPane, -1, 162, Short.MAX_VALUE).addContainerGap()));
        this.jLabel2.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel2.setText("Model Run:");
        this.jLabel4.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel4.setText("Event:");
        this.projectLabel.setText("none");
        this.modelNameButton.setText("name");
        this.modelNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.modelNameButtonActionPerformed(evt);
            }
        });
        GroupLayout nameAndEventPanelLayout = new GroupLayout(this.nameAndEventPanel);
        this.nameAndEventPanel.setLayout(nameAndEventPanelLayout);
        nameAndEventPanelLayout.setHorizontalGroup(nameAndEventPanelLayout.createParallelGroup(1).add(nameAndEventPanelLayout.createSequentialGroup().addContainerGap().add(nameAndEventPanelLayout.createParallelGroup(1).add(nameAndEventPanelLayout.createSequentialGroup().add(this.jLabel2).addPreferredGap(0).add(this.modelNameButton)).add(nameAndEventPanelLayout.createSequentialGroup().add(this.jLabel4).addPreferredGap(0).add(this.projectLabel))).addContainerGap(688, Short.MAX_VALUE)));
        nameAndEventPanelLayout.setVerticalGroup(nameAndEventPanelLayout.createParallelGroup(1).add(nameAndEventPanelLayout.createSequentialGroup().addContainerGap().add(nameAndEventPanelLayout.createParallelGroup(3).add(this.jLabel2).add(this.modelNameButton)).addPreferredGap(0).add(nameAndEventPanelLayout.createParallelGroup(3).add(this.jLabel4).add(this.projectLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout modelSetupPanelLayout = new GroupLayout(this.modelSetupPanel);
        this.modelSetupPanel.setLayout(modelSetupPanelLayout);
        modelSetupPanelLayout.setHorizontalGroup(modelSetupPanelLayout.createParallelGroup(1).add(this.nameAndEventPanel, -1, -1, Short.MAX_VALUE).add(2, modelSetupPanelLayout.createSequentialGroup().addContainerGap().add(modelSetupPanelLayout.createParallelGroup(1).add(modelSetupTopPanel, -1, -1, Short.MAX_VALUE).add(modelSetupBottomPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        modelSetupPanelLayout.setVerticalGroup(modelSetupPanelLayout.createParallelGroup(1).add(2, modelSetupPanelLayout.createSequentialGroup().add(this.nameAndEventPanel, -2, -1, -2).addPreferredGap(0).add(modelSetupTopPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add(modelSetupBottomPanel, -2, -1, -2).addContainerGap()));
        this.outputTabbedPane.addTab("Model Setup", null, this.modelSetupPanel, "Set up model parameters and initial conditions");
        this.icPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.icPanel.setLayout(new BorderLayout());
        this.jToolBar3.setFloatable(false);
        this.jToolBar3.setRollover(true);
        this.jToolBar3.setMaximumSize(new Dimension(2700, 34));
        this.jToolBar3.setMinimumSize(new Dimension(160, 34));
        this.jToolBar3.setPreferredSize(new Dimension(100, 34));
        this.icPanel.add((Component)this.jToolBar3, "First");
        this.outputTabbedPane.addTab("Propagation Max Amp", null, this.icPanel, "Maximum-amplitude plot of initial conditions drawn from the propagation database");
        this.bathyGridPanel.setBackground(Color.white);
        this.bathyGridPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.bathyGridPanel.setPreferredSize(new Dimension(0, 0));
        this.bathyGridPanel.setLayout(new BorderLayout());
        this.gridPanel.setLayout(new BorderLayout());
        this.jToolBar2.setFloatable(false);
        this.jToolBar2.setRollover(true);
        this.jToolBar2.setMaximumSize(new Dimension(2700, 34));
        this.jToolBar2.setMinimumSize(new Dimension(150, 34));
        this.jToolBar2.setPreferredSize(new Dimension(188, 34));
        this.jToolBar2.add(this.bathyGridSelector);
        this.gridPanel.add((Component)this.jToolBar2, "First");
        this.bathyGridPanel.add((Component)this.gridPanel, "Center");
        this.outputTabbedPane.addTab("Grid Bathymetry", this.bathyGridPanel);
        this.wavePanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.wavePanel.setLayout(new BorderLayout());
        this.outputTabbedPane.addTab("Results Animation", this.wavePanel);
        this.maxWaveOuterPanel.setBackground(Color.white);
        this.maxWaveOuterPanel.setPreferredSize(new Dimension(0, 0));
        this.maxWaveOuterPanel.setLayout(new BorderLayout());
        this.outputTabbedPane.addTab("Results Extrema", this.maxWaveOuterPanel);
        this.getContentPane().add((Component)this.outputTabbedPane, "Center");
        this.runCancelButton.setFont(this.runCancelButton.getFont().deriveFont(this.runCancelButton.getFont().getStyle() | 1));
        this.runCancelButton.setIcon(this.modelStartIcon);
        this.runCancelButton.setText("Start model");
        this.runCancelButton.setMinimumSize(new Dimension(145, 29));
        this.runCancelButton.setPreferredSize(new Dimension(145, 29));
        this.runCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.runCancelButtonActionPerformed(evt);
            }
        });
        this.siteComboBox.setMaximumRowCount(28);
        this.siteComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Open model site..."}));
        this.siteComboBox.setMaximumSize(new Dimension(300, Short.MAX_VALUE));
        this.siteComboBox.setRenderer(new ModelRunComboBoxRenderer());
        this.siteComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.siteComboBoxActionPerformed(evt);
            }
        });
        this.modelProgressBar.setMaximumSize(new Dimension(Short.MAX_VALUE, 35));
        this.modelProgressBar.setMinimumSize(new Dimension(10, 35));
        this.modelProgressBar.setPreferredSize(new Dimension(146, 35));
        this.modelProgressBar.setStringPainted(true);
        this.sourceComboBox.setMaximumRowCount(28);
        this.sourceComboBox.setModel(this.sourceComboBoxModel);
        this.sourceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.sourceComboBoxActionPerformed(evt);
            }
        });
        GroupLayout toolbarPanelLayout = new GroupLayout(toolbarPanel);
        toolbarPanel.setLayout(toolbarPanelLayout);
        toolbarPanelLayout.setHorizontalGroup(toolbarPanelLayout.createParallelGroup(1).add(toolbarPanelLayout.createSequentialGroup().addContainerGap().add(this.runCancelButton, -2, 149, -2).addPreferredGap(0).add(this.modelProgressBar, -1, 356, Short.MAX_VALUE).addPreferredGap(0).add(this.siteComboBox, -2, 289, -2).addPreferredGap(0).add(this.sourceComboBox, -2, -1, -2).addContainerGap()));
        toolbarPanelLayout.setVerticalGroup(toolbarPanelLayout.createParallelGroup(1).add(toolbarPanelLayout.createSequentialGroup().addContainerGap().add(toolbarPanelLayout.createParallelGroup(4).add(this.siteComboBox, -2, -1, -2).add(this.runCancelButton, -2, 29, -2).add(this.modelProgressBar, -2, 19, -2).add(this.sourceComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add((Component)toolbarPanel, "North");
        this.fileMenu.setText("Model");
        this.openRunMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.openRunMenuItem.setText("Open Model Site");
        this.openRunMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.openModelRunActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openRunMenuItem);
        this.closeRunMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.closeRunMenuItem.setText("Close Model Site");
        this.closeRunMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.closeRunMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.closeRunMenuItem);
        this.closeAllMenuItem.setText("Close All Model Sites");
        this.closeAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.closeAllMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.closeAllMenuItem);
        this.createMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.createMenuItem.setText("New Model Site");
        this.createMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.createMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.createMenuItem);
        this.renameMenuItem.setText("Rename Model Site");
        this.renameMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.renameMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.renameMenuItem);
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.copyMenuItem.setText("Copy Model Site...");
        this.copyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.copyMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.copyMenuItem);
        this.deleteMenuItem.setText("Delete Model Site");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.deleteMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.deleteMenuItem);
        this.importMenuItem.setText("Import Model Site");
        this.importMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.importMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.importMenuItem);
        this.exportMenuItem.setText("Export Model Site");
        this.exportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.exportMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exportMenuItem);
        this.cleanMenuItem.setText("Clear Model Results...");
        this.cleanMenuItem.setToolTipText("Remove Model Run files (Inititial Condition, Images, or Model output)");
        this.cleanMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.cleanMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.cleanMenuItem);
        this.fileMenu.add(jSeparator1);
        this.saveAnimMenuItem.setText("Save Animation Frames");
        this.saveAnimMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.saveAnimMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAnimMenuItem);
        this.saveTSMenuItem.setText("Save Time Series as ASCII");
        this.saveTSMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.saveTSMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveTSMenuItem);
        this.publishMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 64));
        this.publishMenuItem.setText("Publish Model Run (Tweb)");
        this.publishMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.publishMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.publishMenuItem);
        this.saveGEMenuItem.setText("Save as Google Earth File");
        this.saveGEMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.saveGEMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveGEMenuItem);
        this.compositeMenuItem.setText("Create Composite Wave File");
        this.compositeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.compositeMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.compositeMenuItem);
        this.fileMenu.add(jSeparator2);
        this.addSourceMenuItem.setText("Add Source");
        this.addSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.addSourceMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.addSourceMenuItem);
        this.pastedMenuItem.setText("Set Source Solution/Combination");
        this.pastedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.pastedMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.pastedMenuItem);
        this.eventMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 64));
        this.eventMenuItem.setText("Add Event to Source");
        this.eventMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.eventMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.eventMenuItem);
        this.exportSourcesMenuItem.setText("Export Sources");
        this.exportSourcesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.exportSourcesMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exportSourcesMenuItem);
        this.importSourcesMenuItem.setText("Import Sources");
        this.importSourcesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.importSourcesMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.importSourcesMenuItem);
        this.eventRemoveMenuItem.setText("Remove Event from Source");
        this.eventRemoveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.eventRemoveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.eventRemoveMenuItem);
        this.removeSourceMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.removeSourceMenuItem.setText("Remove Source");
        this.removeSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.removeSourceMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.removeSourceMenuItem);
        this.hazardMenuItem.setText("Run All Sources");
        this.hazardMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.hazardMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.hazardMenuItem);
        this.customPropMenuItem.setText("Create New Source (Custom Propagation Run)");
        this.customPropMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.customPropMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.customPropMenuItem);
        this.fileMenu.add(jSeparator3);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.prefsMenuItem.setText("Preferences");
        this.prefsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.prefsMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.prefsMenuItem);
        this.propMenuItem.setText("Update Local Propagation DB");
        this.propMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.propMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.propMenuItem);
        this.editMenu.add(jSeparator4);
        this.jMenu1.setText("Bathymetry");
        this.sslBathyMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.sslBathyMenuItem.setText("Filter Bathymetry (SSL)");
        this.sslBathyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.sslBathyMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.sslBathyMenuItem);
        this.smoothBathyMenuItem.setText("Smooth Bathymetry");
        this.smoothBathyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.smoothBathyMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.smoothBathyMenuItem);
        this.cropBathyMenuItem.setText("Crop Bathymetry");
        this.cropBathyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.cropBathyMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.cropBathyMenuItem);
        this.subsampleBathyMenuItem.setText("Subsample Bathymetry");
        this.subsampleBathyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.subsampleBathyMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.subsampleBathyMenuItem);
        this.upDownMenuItem.setText("Flip Bathymetry Up/Down");
        this.upDownMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.upDownMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.upDownMenuItem);
        this.leftRightMenuItem.setText("Flip Bathymetry Left/Right");
        this.leftRightMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.leftRightMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.leftRightMenuItem);
        this.longitudeMenuItem.setText("Shift Longitude");
        this.longitudeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.longitudeMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.longitudeMenuItem);
        this.invertMenuItem.setText("Invert Bathymetry ( mult. by -1.0 )");
        this.invertMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.invertMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.invertMenuItem);
        this.adjustMenuItem.setText("Adjust Vertical Datum");
        this.adjustMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.adjustMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.adjustMenuItem);
        this.editMenu.add(this.jMenu1);
        this.menuBar.add(this.editMenu);
        this.viewMenu.setText("View");
        this.cflMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.cflMenuItem.setText("Grid information (CFL)");
        this.cflMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.cflMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.cflMenuItem);
        this.propExtentsCheckBoxMenuItem.setText("Show Propagation Grid Extents");
        this.propExtentsCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.propExtentsCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.propExtentsCheckBoxMenuItem);
        this.menuBar.add(this.viewMenu);
        this.helpMenu.setText("Help");
        this.contentsMenuItem.setText("Help");
        this.contentsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.contentsMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.contentsMenuItem);
        this.viewLogMenuItem.setText("View log file");
        this.viewLogMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.viewLogMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.viewLogMenuItem);
        this.emailLogMenuItem.setText("Email log file to ComMIT Team");
        this.emailLogMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.emailLogMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.emailLogMenuItem);
        this.aboutMenuItem.setText("About ComMIT");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiftShare.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void propExtentsCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        if (this.propExtentsCheckBoxMenuItem.isSelected()) {
            final IndeterminateProgressMonitor pm = new IndeterminateProgressMonitor(this, "checking propagation grid extents...");
            pm.setAlwaysOnTop(true);
            pm.setVisible(true);
            SwingWorker propExtentWorker = new SwingWorker(){

                @Override
                public Object construct() {
                    SiftShare.this.showPropExtents();
                    return null;
                }

                @Override
                public void finished() {
                    pm.closeMe();
                }
            };
            pm.setSwingWorker(propExtentWorker);
            propExtentWorker.start();
        } else {
            this.hidePropExtents();
        }
    }

    private void propMenuItemActionPerformed(ActionEvent evt) {
        final List<String> dbLocNames = Arrays.asList(CMIUtil.DATABASE_LOC.split(","));
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = dbLocNames.iterator();
        while (it.hasNext()) {
            if (!it.next().startsWith("http")) continue;
            it.remove();
        }
        for (String s : dbLocNames) {
            sb.append(s).append("\n");
        }
        int result = JOptionPane.showConfirmDialog(this, "Check all local propagation database folders:\n" + sb.toString() + "for new/changed propagation files?", "Updating Local Propagation DB", 0);
        if (result == 0) {
            final IndeterminateProgressMonitor pm = new IndeterminateProgressMonitor(this, "updating local Propagation DB (info_sz.dat) files ...");
            pm.setLocation(this.getLocation().x + 30, this.getLocation().y + 50);
            pm.setAlwaysOnTop(true);
            pm.setVisible(true);
            SwingWorker propWorker = new SwingWorker(){

                @Override
                public Object construct() {
                    for (String s : dbLocNames) {
                        if (s.equals("(default server)")) continue;
                        CMIUtil.updateInfoSZ(s, SiftShare.this.mainApp);
                    }
                    return null;
                }

                @Override
                public void finished() {
                    SiftShare.this.updateDatabaseLocs();
                    pm.closeMe();
                }
            };
            pm.setSwingWorker(propWorker);
            propWorker.start();
        }
    }

    private void saveGEMenuItemActionPerformed(ActionEvent evt) {
        this.outputTabbedPane.setSelectedIndex(3);
        if (this.saveGEDialog == null) {
            this.saveGEDialog = new SaveGEDialog((Frame)this, true);
            this.saveGEDialog.setLocationRelativeTo(this);
        }
        this.saveGEDialog.setNumberOutputSteps(this.mostResultsPanel.getTimeStepCount());
        this.saveGEDialog.setName(this.getCurrentSite().getName());
        this.saveGEDialog.setVisible(true);
        if (this.saveGEDialog.getReturnStatus() == 1) {
            this.repaint();
            this.mostResultsPanel.stopAnimation();
            this.mostResultsPanel.setIgnoreUpdates(true);
            final IndeterminateProgressMonitor pm = new IndeterminateProgressMonitor(this, "saving as Google Earth file...");
            pm.setLocation(this.getLocation().x + 30, this.getLocation().y + 50);
            pm.setAlwaysOnTop(true);
            pm.setVisible(true);
            SwingWorker animWorker = new SwingWorker(){

                @Override
                public Object construct() {
                    SourceScenario ss = CMIUtil.currentSiteInfo.getSourceScenario();
                    SeismicEvent se = null;
                    if (ss != null) {
                        se = ss.getSeismicEvent();
                    }
                    SiftShare.this.saveGEDialog.WriteKMZfile(pm, SiftShare.this.eventEditor.getActiveSourceCombo(), SiftShare.this.mostExtremaPanel, SiftShare.this.sBathyPanel, SiftShare.this.mostResultsPanel, SiftShare.this.outputTabbedPane, se);
                    return null;
                }

                @Override
                public void finished() {
                    SiftShare.this.mostResultsPanel.getSAnimPanel().showTopography(true);
                    SiftShare.this.mostResultsPanel.setIgnoreUpdates(false);
                    pm.closeMe();
                }
            };
            pm.setSwingWorker(animWorker);
            animWorker.start();
        }
    }

    private void pastedMenuItemActionPerformed(ActionEvent evt) {
        SiteInfo si;
        if (PasteInversionDialog.showDialog(this, true) == 1 && (si = this.getCurrentSite()) != null) {
            LinkedHashSet<SourceCombo> sourceSet = PasteInversionDialog.getSourceSet();
            if (sourceSet.size() == 1) {
                this.eventEditor.setActive((SourceCombo)sourceSet.iterator().next());
                this.eventEditor.jumpTo("to Selected");
            } else {
                String sname = si.getActiveSourceName();
                for (SourceCombo sc : sourceSet) {
                    si.addSource(sc.getSourceNames());
                }
                si.setSource(sname);
                this.firePropertyChange("currentSite", null, si);
            }
        }
    }

    private void saveTSMenuItemActionPerformed(ActionEvent evt) {
        this.mostResultsPanel.saveTimeseries();
    }

    private void saveAnimMenuItemActionPerformed(ActionEvent evt) {
        this.outputTabbedPane.setSelectedIndex(3);
        final IndeterminateProgressMonitor pm = new IndeterminateProgressMonitor(this, "saving animation...");
        pm.setLocation(this.getLocation().x + 30, this.getLocation().y + 50);
        pm.setAlwaysOnTop(true);
        pm.setVisible(true);
        SwingWorker animWorker = new SwingWorker(){

            @Override
            public Object construct() {
                SiftShare.this.mostResultsPanel.saveAllImages();
                return null;
            }

            @Override
            public void finished() {
                pm.closeMe();
            }
        };
        pm.setSwingWorker(animWorker);
        animWorker.start();
    }

    private void copyMenuItemActionPerformed(ActionEvent evt) {
        if (this.openSites.isEmpty()) {
            JOptionPane.showMessageDialog(this, "There are no Model Runs to copy.\nPlease create new Model Run.", "No runs to copy", 1);
            return;
        }
        CopySiteDialog copyDlg = new CopySiteDialog((Frame)this, this.openSites);
        copyDlg.setSelectedSite(this.getCurrentSite());
        copyDlg.setVisible(true);
        if (copyDlg.getReturnStatus() == 1 || copyDlg.getNewSite() != null) {
            if (this.mostModelRunner != null && this.mostModelRunner.isRunning()) {
                this.mostModelRunner.stop();
            }
            this.setCurrentSite(this.openSite(copyDlg.getNewSite()));
        }
    }

    private void cflMenuItemActionPerformed(ActionEvent evt) {
        if (this.openSites.isEmpty()) {
            JOptionPane.showMessageDialog(this, "There are no grids to view.\nPlease create new Model Run.", "No grids to view", 1);
            return;
        }
        this.gif = new GridInfoFrame(this.getCurrentSite());
        this.gif.setLocationRelativeTo(this);
        this.gif.setVisible(true);
    }

    private void eventMenuItemActionPerformed(ActionEvent evt) {
        this.doEventDialog(false);
    }

    private void updateModelOutputLog(SiteInfo si) {
        this.modelLogTextArea.setText("");
        if (si != null) {
            try {
                String inputLine;
                FileReader mfr = new FileReader(new File(si.getSiteDirectory(), String.format("output_%s_%s.lis", si.getName(), si.getActiveSourceName())));
                BufferedReader br = new BufferedReader(mfr);
                while ((inputLine = br.readLine()) != null) {
                    this.modelLogTextArea.append(inputLine + "\n");
                }
                mfr.close();
                br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.modelLogTextArea.setCaretPosition(this.modelLogTextArea.getDocument().getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEESiteSources(SiteInfo site, boolean replace) {
        block6: {
            log.fine("adding sources from site: " + site.getName());
            if (replace) {
                this.eventEditor.removeCroppedSources();
            }
            File infoFile = new File(site.getSiteDirectory(), "info_sz.dat");
            try {
                if (!infoFile.canRead()) break block6;
                try (FileInputStream is = new FileInputStream(infoFile);){
                    this.eventEditor.useCroppedSources(is);
                }
            }
            catch (IOException e) {
                log.warning(e.getMessage());
            }
        }
    }

    private void updateEventEditorSite(SiteInfo site) {
        if (site != null) {
            this.eventEditor.drawSitesOn();
            try {
                this.eventEditor.setGridA(site.getBathyGrid(1).getGridBox(), site.getName());
                this.eventEditor.setGridB(site.getBathyGrid(2).getGridBox(), site.getName());
                this.eventEditor.setGridC(site.getBathyGrid(3).getGridBox(), site.getName());
                this.eventEditor.drawSitesOn();
            }
            catch (IOException e) {
                log.warning(e.getMessage());
            }
            this.eventEditor.setDefaultRegion(site.getAGridRegion());
            this.eventEditor.plotMark(false);
            this.addEESiteSources(site, true);
            SourceCombo sc = this.eventEditor.getSourceComboFromString(site.getSourceNamesAndSlips());
            if (sc.getNumberOfSources() > 0) {
                this.eventEditor.setActive(sc);
            } else if (site.getLocation() != null) {
                this.eventEditor.setActive(new SourceCombo());
                this.eventEditor.setMagnitude(8.2);
            }
            if (site.getSourceScenario() != null && !site.getSourceScenario().getSeismicEvent().isProject()) {
                double lon = site.getSourceScenario().getSeismicEvent().getLongitude();
                double lat = site.getSourceScenario().getSeismicEvent().getLatitude();
                this.eventEditor.setEpicenter(lon, lat);
                this.eventEditor.plotMark(true);
            }
        } else {
            this.eventEditor.drawSitesOff();
            this.eventEditor.removeCroppedSources();
            this.eventEditor.setActive(new SourceCombo());
            this.eventEditor.setMagnitude(7.5);
            this.eventEditor.zoomTo(190.0, 10.0);
            this.eventEditor.zoom(10);
        }
        this.projectLabel.setText(site != null && site.getSourceScenario() != null ? site.getSourceScenario().getSeismicEvent().toString() : "");
    }

    private void updateToolbarSite(SiteInfo site) {
        if (this.openSites.isEmpty()) {
            this.siteComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Open model site.."}));
        } else {
            DefaultComboBoxModel<SiteInfo> cbm = new DefaultComboBoxModel<SiteInfo>();
            for (SiteInfo s : this.openSites) {
                cbm.addElement(s);
            }
            this.siteComboBox.setModel(cbm);
        }
        if (site != null && !site.equals(this.siteComboBox.getSelectedItem())) {
            this.siteComboBox.setSelectedItem(site);
        }
        this.outputMessages.setStoppedProgressBar(site);
    }

    public void showPrefsDialog() {
        this.prefsDialog.refresh();
        this.prefsDialog.setLocationRelativeTo(this);
        this.prefsDialog.setVisible(true);
    }

    private void prefsMenuItemActionPerformed(ActionEvent evt) {
        this.showPrefsDialog();
    }

    private void deleteMenuItemActionPerformed(ActionEvent evt) {
        if (this.openSites.isEmpty()) {
            JOptionPane.showMessageDialog(this, "There are no runs to delete.\nPlease create new Model Run.", "No runs to delete", 1);
            return;
        }
        DeleteSiteDialog deleteSiteDialog = new DeleteSiteDialog((Frame)this, this.getOpenSites());
        deleteSiteDialog.setSelectedSite(this.getCurrentSite());
        deleteSiteDialog.setVisible(true);
        if (deleteSiteDialog.getReturnStatus() == 1 && this.getCurrentSite() != null && this.getCurrentSite().equals(deleteSiteDialog.getDeletedSite())) {
            this.setCurrentSite(null);
        }
    }

    private void createMenuItemActionPerformed(ActionEvent evt) {
        NewModelRunWizard modelRunWizard = new NewModelRunWizard(this.eventEditor.getMap().getLandMasses());
        Rectangle rec = this.getBounds();
        SiteInfo siteInfo = modelRunWizard.showWizard(new Rectangle(rec.x, rec.y, 1250, 550));
        if (siteInfo != null) {
            this.openSite(siteInfo);
            this.setCurrentSite(siteInfo);
        }
    }

    public void showAboutDialog() {
        AboutDialog aboutDialog = new AboutDialog((Frame)this, false);
        aboutDialog.setLocationRelativeTo(this);
        aboutDialog.setVisible(true);
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        this.showAboutDialog();
    }

    private void contentsMenuItemActionPerformed(ActionEvent evt) {
        this.showHelp();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        if (this.closeApp()) {
            System.exit(0);
        }
    }

    private void cleanMenuItemActionPerformed(ActionEvent evt) {
        if (this.openSites.isEmpty()) {
            JOptionPane.showMessageDialog(this, "There are no open model sites to clear.", "No sites to clear", 1);
            return;
        }
        this.mostResultsPanel.closeFiles();
        this.runningAllSources = false;
        ClearModelRunDialog clearModelRunDialog = new ClearModelRunDialog((Frame)this, this.openSites, this.mostModelRunner);
        clearModelRunDialog.setSelectedSite(this.getCurrentSite());
        clearModelRunDialog.setLocationRelativeTo(this);
        clearModelRunDialog.setVisible(true);
        if (clearModelRunDialog.getReturnStatus() == 1) {
            for (ModelListener ml : this.modelListeners) {
                ml.modelStopped(new ModelEvent(this.getCurrentSite(), 200, 0));
            }
            this.addEESiteSources(this.getCurrentSite(), true);
        }
    }

    public static Preferences getPreferences() {
        return Preferences.userNodeForPackage(SiftShare.class);
    }

    private void publishMenuItemActionPerformed(ActionEvent evt) {
        if (this.getCurrentSite() == null) {
            JOptionPane.showMessageDialog(this, "There are no runs to publish.\nPlease create a new Model Run.", "No runs to publish", 2);
            return;
        }
        if (this.getCurrentSite().getSourceScenario() == null) {
            JOptionPane.showMessageDialog(this, "You must open a project or event before publishing.\nPlease select Model->Open Event or Open Project, and then restart the Model Run.", "No event selected", 2);
            return;
        }
        if (this.getCurrentSite().getTimestepsAvailable() <= 0) {
            JOptionPane.showMessageDialog(this, "This run has no model output available.\nPlease run the model before publishing.", "No model output", 2);
            return;
        }
        if (this.getCurrentSite().getTimestepsAvailable() < this.getCurrentSite().getNumberOutputTimesteps()) {
            String message = "This model has not completed running.\nModel will be stopped: press Start to continue after uploading.\nAre you sure you want to publish incomplete model?\n";
            String title = "Incomplete Model";
            int doUpload = JOptionPane.showConfirmDialog(this, message, title, 0, 2);
            if (doUpload == 1) {
                return;
            }
            if (this.mostModelRunner != null && this.mostModelRunner.isRunning()) {
                this.mostModelRunner.stop();
            }
        }
        boolean isTweb = CMIUtil.tsunamiCastAddress.toLowerCase().indexOf("tweb") >= 0 || CMIUtil.tsunamiCastAddress.indexOf("8888") > 0 || CMIUtil.tsunamiCastAddress.toLowerCase().indexOf("tweet") >= 0;
        JDialog uploadDialog = isTweb ? new TwebUploadDialog((Frame)this, this.getCurrentSite()) : new UploadDialog((Frame)this, this.getCurrentSite());
        uploadDialog.setLocationRelativeTo(this);
        uploadDialog.setVisible(true);
    }

    private void runCancelButtonActionPerformed(ActionEvent evt) {
        this.startStopModelProcess();
    }

    public void startStopModelProcess() {
        if (this.mostModelRunner != null && this.mostModelRunner.isRunning()) {
            this.mostModelRunner.stop();
            if (this.runningAllSources) {
                this.runningAllSources = false;
            }
        } else {
            if (this.getCurrentSite() == null) {
                JOptionPane.showMessageDialog(this, "No model run is open. Please open or create a model run before launching.", "No model run open", 0);
                return;
            }
            if (this.eventEditor.getActiveSourceCombo().getNumberOfSources() < 1) {
                if (this.runningAllSources) {
                    log.info("Running all sources, and no unit source selected for this source, skipping: " + this.getCurrentSite().getActiveSourceName());
                    int numSources = this.sourceComboBox.getItemCount();
                    if (this.sourceComboBox.getSelectedIndex() + 1 == numSources) {
                        this.runningAllSources = false;
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SiftShare.this.sourceComboBox.setSelectedIndex(SiftShare.this.sourceComboBox.getSelectedIndex() + 1);
                            }
                        });
                    }
                    return;
                }
                this.outputTabbedPane.setSelectedComponent(this.modelSetupPanel);
                JOptionPane.showMessageDialog(this, "You must select at least one source", "Error", 0);
                return;
            }
            while (!new File(CMIUtil.MOST_EXEC).isFile()) {
                Object[] buttons = new String[]{"Download", "Specify location", "Cancel"};
                int result = JOptionPane.showOptionDialog(this, "The MOST model executable is not found.\n\nYou can download it, or manually specify the executable location.", "MOST model not available", -1, 3, null, buttons, buttons[0]);
                if (result == 0) {
                    this.MED.setCompletionCallback(new Runnable(){

                        @Override
                        public void run() {
                            SiftShare.this.startStopModelProcess();
                        }
                    });
                    this.MED.downloadMOST();
                    return;
                }
                if (result == 1) {
                    this.prefsDialog.setLocationRelativeTo(this);
                    this.prefsDialog.setVisible(true);
                    continue;
                }
                return;
            }
            log.log(Level.INFO, "\n\nStarting Model Run: " + this.getCurrentSite() + " with soln: " + this.getCurrentSite().getSourceNamesAndSlips() + "\n\n");
            this.mostModelRunner = new ModelRunner(this.getCurrentSite(), this.modelListeners);
            LinCombModule linco = new LinCombModule(this.getCurrentSite(), this.eventEditor.getActiveSourceCombo(), this.modelListeners);
            boolean cleanExistingResults = true;
            if (!linco.isLinCoUpToDate(this.eventEditor.getActiveSourceCombo().getSourceNames())) {
                this.mostModelRunner.setLinearCombinator(linco);
            } else {
                linco = null;
                if (this.runningAllSources) {
                    cleanExistingResults = false;
                } else if (this.getCurrentSite().getRestartFile() != null) {
                    Object[] opts = new String[]{"Continue Run", "Start Over", "Cancel"};
                    int r = JOptionPane.showOptionDialog(this.mainApp, "Do you want to continue the model at the time the last run stopped,\nor start over at the beginning?", "Use Model Restart?", -1, 3, null, opts, opts[0]);
                    if (r == 2 || r == -1) {
                        this.mostModelRunner = null;
                        return;
                    }
                    boolean bl = cleanExistingResults = r == 1;
                    if (cleanExistingResults) {
                        this.getCurrentSite().getRestartFile().delete();
                        this.getCurrentSite().getSiftOutputFile().delete();
                    }
                }
            }
            CMIUtil.cleanMostOutput(this.getCurrentSite(), cleanExistingResults, false, cleanExistingResults, false);
            this.mostModelRunner.start();
        }
    }

    public ModelRunner getModelRunner() {
        return this.mostModelRunner;
    }

    private void siteComboBoxActionPerformed(ActionEvent evt) {
        Object selectedObj = this.siteComboBox.getSelectedItem();
        if (!(selectedObj instanceof SiteInfo)) {
            this.openModelRunActionPerformed(evt);
            return;
        }
        SiteInfo si = (SiteInfo)selectedObj;
        if (this.mostModelRunner != null && this.mostModelRunner.isRunning() && si != this.getCurrentSite()) {
            int result = JOptionPane.showConfirmDialog(this, String.format("MOST is currently running the %s model.\nDo you wish to cancel the run and switch to\nthe %s Model Run?", this.getCurrentSite().getName(), si.getName()), "Model Running", 0, 3);
            if (result == 0) {
                this.runningAllSources = false;
                this.mostModelRunner.stop();
            } else {
                this.siteComboBox.setSelectedItem(this.getCurrentSite());
                return;
            }
        }
        this.ignoreEventEditorSourceChanges();
        this.setCurrentSite(si);
    }

    private void openModelRunActionPerformed(ActionEvent evt) {
        JFileChooser modelChooser = new JFileChooser(CMIUtil.workingDirName);
        boolean reopen = true;
        modelChooser.setFileView(new ModelRunFileView());
        modelChooser.setFileSelectionMode(2);
        modelChooser.setFileFilter(ModelRunFileView.getModelRunFileFilter());
        modelChooser.setMultiSelectionEnabled(true);
        modelChooser.setDialogTitle("Open Model Site");
        while (reopen) {
            SiteInfo firstSite = null;
            if (modelChooser.showOpenDialog(this) == 0) {
                for (File f : modelChooser.getSelectedFiles()) {
                    if (ModelRunFileView.isModelRunDirectory(f)) {
                        try {
                            SiteInfo newSite = this.openSite(new SiteInfo(f));
                            if (firstSite == null) {
                                firstSite = newSite;
                            }
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(this, "Error loading model:\n" + ex.getMessage(), "Error loading models", 0);
                        }
                        reopen = false;
                        continue;
                    }
                    if (firstSite != null) continue;
                    modelChooser.setCurrentDirectory(f);
                    reopen = true;
                }
                if (firstSite == null) continue;
                if (this.mostModelRunner != null && this.mostModelRunner.isRunning() && firstSite != this.getCurrentSite()) {
                    int result = JOptionPane.showConfirmDialog(this, String.format("MOST is currently running the %s model.\nDo you wish to cancel the run and switch to\nthe %s Model Site?", this.getCurrentSite().getName(), firstSite.getName()), "Model Running", 0, 3);
                    if (result == 0) {
                        this.mostModelRunner.stop();
                    } else {
                        return;
                    }
                }
                this.setCurrentSite(firstSite);
                continue;
            }
            reopen = false;
        }
    }

    private void closeRunMenuItemActionPerformed(ActionEvent evt) {
        if (this.getCurrentSite() == null) {
            return;
        }
        this.closeSite(this.getCurrentSite(), true);
    }

    private void smoothBathyMenuItemActionPerformed(ActionEvent evt) {
        if (this.getCurrentSite() == null) {
            return;
        }
        BathySmoothTool bt = new BathySmoothTool((Frame)this, this.getCurrentSite());
        this.addPropertyChangeListener("currentSite", bt);
        this.currentGridTool = bt;
        switch (this.outputTabbedPane.getSelectedIndex()) {
            case 0: 
            case 1: {
                this.outputTabbedPane.setSelectedIndex(2);
                break;
            }
        }
        this.currentGridTool.setVisible(true);
    }

    private void importMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(new File(CMIUtil.workingDirName));
        chooser.setFileFilter(new SimpleFileFilter("zip", "Zipped Model Run File"));
        chooser.setDialogTitle("Import Model Site");
        if (chooser.showOpenDialog(this) == 0) {
            File f = chooser.getSelectedFile();
            log.log(Level.INFO, "Importing Model Run from {0}", f);
            if (f != null && f.exists()) {
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    File sitedir = CMIUtil.importModelRun(new FileInputStream(f));
                    if (sitedir != null) {
                        SiteInfo site = new SiteInfo(sitedir);
                        log.log(Level.INFO, "imported new Model Run: {0}", site.getName());
                        this.openSite(site);
                        this.setCurrentSite(site);
                    }
                    this.setCursor(Cursor.getDefaultCursor());
                }
                catch (IOException ioe) {
                    this.setCursor(Cursor.getDefaultCursor());
                    log.log(Level.WARNING, "Error importing Model Site from zip file", ioe);
                    JOptionPane.showMessageDialog(this, "Error importing Model Run: \n" + ioe.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportMenuItemActionPerformed(ActionEvent evt) {
        SiteInfo site = this.getCurrentSite();
        if (site == null) {
            return;
        }
        JFileChooser chooser = new JFileChooser(new File(CMIUtil.workingDirName));
        chooser.setFileFilter(new SimpleFileFilter("zip", "Zipped Model Run File"));
        chooser.setSelectedFile(new File(CMIUtil.workingDirName, site.getName() + ".zip"));
        chooser.setDialogTitle("Export Model Site");
        log.log(Level.INFO, "Exporting Model Run: {0} to zip file", site.getName());
        if (chooser.showSaveDialog(this) == 0) {
            File f = chooser.getSelectedFile();
            try {
                ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(f));
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    SiftShare.addZipEntry(new File(site.getSiteDirectory(), "most3_facts_nc.in"), site.getName() + "/" + "most3_facts_nc.in", zos);
                    SiftShare.addZipEntry(new File(site.getSiteDirectory(), site.getGridName(1)), site.getName() + "/" + site.getGridName(1), zos);
                    SiftShare.addZipEntry(new File(site.getSiteDirectory(), site.getGridName(2)), site.getName() + "/" + site.getGridName(2), zos);
                    SiftShare.addZipEntry(new File(site.getSiteDirectory(), site.getGridName(3)), site.getName() + "/" + site.getGridName(3), zos);
                    File mif = new File(site.getSiteDirectory(), "model_info.xml");
                    if (mif.exists()) {
                        SiftShare.addZipEntry(mif, site.getName() + "/model_info.xml", zos);
                    } else {
                        log.log(Level.WARNING, "No model_info.xml file, not including in export!");
                    }
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                    zos.close();
                }
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Error exporting Model Run: \n" + ioe.getMessage());
                log.log(Level.WARNING, "", ioe);
            }
        }
    }

    private void upDownMenuItemActionPerformed(ActionEvent evt) {
        SiteInfo site = this.getCurrentSite();
        if (site == null) {
            return;
        }
        this.outputTabbedPane.setSelectedIndex(2);
        int gridShowing = this.bathyGridSelector.getSelectedGrid();
        Object[] opt = new String[]{"A-Grid: " + site.getGridName(1), "B-Grid: " + site.getGridName(2), "C-Grid: " + site.getGridName(3)};
        String s = (String)JOptionPane.showInputDialog(this, "Flip selected grid up/down:\n", "Edit Bathymetry Grid", -1, null, opt, opt[gridShowing - 1]);
        if (s != null && s.length() > 0) {
            log.info("Flipping grid up/down: " + s);
            try {
                if (s.startsWith("A-Grid")) {
                    site.setBathyGrid(1, site.getBathyGrid(1).flipUpDown());
                } else if (s.startsWith("B-Grid")) {
                    site.setBathyGrid(2, site.getBathyGrid(2).flipUpDown());
                } else {
                    site.setBathyGrid(3, site.getBathyGrid(3).flipUpDown());
                }
                site.clearLoadedBathymetryGrids();
            }
            catch (IOException ioe) {
                log.log(Level.WARNING, "Error writing grid file", ioe);
            }
            CMIUtil.cleanMostOutput(site, true, false, true);
            for (ModelListener ml : this.modelListeners) {
                ml.modelStopped(new ModelEvent(this.getCurrentSite(), 200, 0));
            }
            this.addEESiteSources(this.getCurrentSite(), true);
        }
    }

    private void leftRightMenuItemActionPerformed(ActionEvent evt) {
        SiteInfo site = this.getCurrentSite();
        if (site == null) {
            return;
        }
        this.outputTabbedPane.setSelectedIndex(2);
        int gridShowing = this.bathyGridSelector.getSelectedGrid();
        Object[] opt = new String[]{"A-Grid: " + site.getGridName(1), "B-Grid: " + site.getGridName(2), "C-Grid: " + site.getGridName(3)};
        String s = (String)JOptionPane.showInputDialog(this, "Flip selected grid left/right:\n", "Edit Bathymetry Grid", -1, null, opt, opt[gridShowing - 1]);
        if (s != null && s.length() > 0) {
            log.info("Flipping grid left/right: " + s);
            try {
                if (s.startsWith("A-Grid")) {
                    site.setBathyGrid(1, site.getBathyGrid(1).flipLeftRight());
                } else if (s.startsWith("B-Grid")) {
                    site.setBathyGrid(2, site.getBathyGrid(2).flipLeftRight());
                } else {
                    site.setBathyGrid(3, site.getBathyGrid(3).flipLeftRight());
                }
                site.clearLoadedBathymetryGrids();
            }
            catch (IOException ioe) {
                log.log(Level.WARNING, "Error writing grid file", ioe);
            }
            CMIUtil.cleanMostOutput(site, true, false, true);
            for (ModelListener ml : this.modelListeners) {
                ml.modelStopped(new ModelEvent(this.getCurrentSite(), 200, 0));
            }
            this.addEESiteSources(this.getCurrentSite(), true);
        }
    }

    private void invertMenuItemActionPerformed(ActionEvent evt) {
        SiteInfo site = this.getCurrentSite();
        if (site == null) {
            return;
        }
        this.outputTabbedPane.setSelectedIndex(2);
        int gridShowing = this.bathyGridSelector.getSelectedGrid();
        Object[] opt = new String[]{"A-Grid: " + site.getGridName(1), "B-Grid: " + site.getGridName(2), "C-Grid: " + site.getGridName(3)};
        String s = (String)JOptionPane.showInputDialog(this, "Invert selected grid (multiply by -1.0):\n", "Edit Bathymetry Grid", -1, null, opt, opt[gridShowing - 1]);
        if (s != null && s.length() > 0) {
            log.info("Inverting grid (bath x -1.0): " + s);
            try {
                if (s.startsWith("A-Grid")) {
                    site.setBathyGrid(1, site.getBathyGrid(1).invert());
                } else if (s.startsWith("B-Grid")) {
                    site.setBathyGrid(2, site.getBathyGrid(2).invert());
                } else {
                    site.setBathyGrid(3, site.getBathyGrid(3).invert());
                }
                site.clearLoadedBathymetryGrids();
            }
            catch (IOException ioe) {
                log.log(Level.WARNING, "Error writing grid file", ioe);
            }
            CMIUtil.cleanMostOutput(site, true, false, true);
            for (ModelListener ml : this.modelListeners) {
                ml.modelStopped(new ModelEvent(this.getCurrentSite(), 200, 0));
            }
            this.addEESiteSources(this.getCurrentSite(), true);
        }
    }

    private void eventRemoveMenuItemActionPerformed(ActionEvent evt) {
        SiteInfo si = this.getCurrentSite();
        if (si != null) {
            SourceScenario ss = si.getSourceScenario();
            si.setSourceScenario(null);
            si.setSourceNamesAndSlips(this.eventEditor.getActiveSourceCombo().getSourceNames());
            this.eventEditor.plotMark(false);
            this.firePropertyChange("sourceScenario", ss, null);
        }
    }

    private void cropBathyMenuItemActionPerformed(ActionEvent evt) {
        if (this.getCurrentSite() == null) {
            return;
        }
        BathyCropTool bct = new BathyCropTool((Frame)this, this.getCurrentSite());
        this.addPropertyChangeListener("currentSite", bct);
        this.currentGridTool = bct;
        switch (this.outputTabbedPane.getSelectedIndex()) {
            case 0: 
            case 1: {
                this.outputTabbedPane.setSelectedIndex(2);
                break;
            }
        }
        this.currentGridTool.setVisible(true);
    }

    private void modelNameButtonActionPerformed(ActionEvent evt) {
        if (!this.modelNameButton.getText().equals("name")) {
            try {
                Desktop.getDesktop().open(new File(this.modelNameButton.getText()));
            }
            catch (IOException ex) {
                log.warning("Can't find model run folder: " + this.modelNameButton.getText());
            }
        }
    }

    private void compositeMenuItemActionPerformed(ActionEvent evt) {
        if (this.compositeMaxDialog == null) {
            this.compositeMaxDialog = new CompositeMaxDialog((Frame)this, true);
            this.compositeMaxDialog.setLocationRelativeTo(this);
        }
        this.compositeMaxDialog.addModelRuns(this.openSites);
        this.compositeMaxDialog.setVisible(true);
    }

    private void adjustMenuItemActionPerformed(ActionEvent evt) {
        if (this.getCurrentSite() == null) {
            return;
        }
        BathyVerticalAdjust bva = new BathyVerticalAdjust((Frame)this, this.getCurrentSite());
        this.addPropertyChangeListener("currentSite", bva);
        this.addPropertyChangeListener("selectedGrid", bva);
        switch (this.outputTabbedPane.getSelectedIndex()) {
            case 0: 
            case 1: {
                this.outputTabbedPane.setSelectedIndex(2);
                break;
            }
        }
        bva.setVisible(true);
    }

    private void subsampleBathyMenuItemActionPerformed(ActionEvent evt) {
        if (this.getCurrentSite() == null) {
            return;
        }
        BathySubsample bss = new BathySubsample((Frame)this, this.getCurrentSite());
        this.addPropertyChangeListener("currentSite", bss);
        this.addPropertyChangeListener("selectedGrid", bss);
        switch (this.outputTabbedPane.getSelectedIndex()) {
            case 0: 
            case 1: {
                this.outputTabbedPane.setSelectedIndex(2);
                break;
            }
        }
        bss.setVisible(true);
    }

    private void customPropMenuItemActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        PropRunPanel.downloadGrids(this, new Runnable(){

            @Override
            public void run() {
                SiftShare.this.openCustomPropWindow();
            }
        });
    }

    public void openCustomPropWindow() {
        if (PropRunPanel.downloadGridsExist()) {
            this.propRunFrame = new JFrame();
            this.propRunPanel = new PropRunPanel(this.propRunFrame, this.prefsDialog);
            this.propRunFrame.setTitle("Custom Propagation");
            this.propRunFrame.getContentPane().add(this.propRunPanel);
            this.propRunFrame.setSize(1150, 930);
            this.propRunFrame.setDefaultCloseOperation(2);
            WindowAdapter l = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    SiftShare.this.propRunPanel.cancelModels();
                    SiftShare.this.checkForLocalPropRunUpdates(SiftShare.this.propRunFrame);
                    SiftShare.this.updateEventEditor(true);
                    SiftShare.this.propRunFrame.dispose();
                }
            };
            this.propRunFrame.addWindowListener(l);
            this.propRunPanel.findPropRuns();
            this.propRunFrame.setLocationRelativeTo(this);
            this.propRunFrame.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, "Unable to download Propagation bathymetry\nPlease check your network connection and try again.", "Error", 0);
            log.log(Level.SEVERE, "Downloaded prop bathy grids don't exist!");
        }
        this.setCursor(new Cursor(0));
    }

    private void emailLogMenuItemActionPerformed(ActionEvent evt) {
        String msg = "To the ComMIT Team:\n\nI'm attaching the log file 'commit0.log' to this email because I'm having problems.  Please help!\n\nFrom, a ComMIT User";
        String url = "mailTo:Christopher.Moore@noaa.gov?subject=";
        try {
            JOptionPane.showMessageDialog(this, "Please email Christopher.Moore@noaa.gov the file \"commit0.log\"");
            Desktop.getDesktop().open(new File(CMIUtil.etcDirName));
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "Can't send log email.", ex);
        }
    }

    private void sslBathyMenuItemActionPerformed(ActionEvent evt) {
        SiteInfo site = this.getCurrentSite();
        if (site == null) {
            return;
        }
        this.outputTabbedPane.setSelectedIndex(2);
        int gridShowing = this.bathyGridSelector.getSelectedGrid();
        Object[] opt = new String[]{"A-Grid: " + site.getGridName(1), "B-Grid: " + site.getGridName(2), "C-Grid: " + site.getGridName(3)};
        String s = (String)JOptionPane.showInputDialog(this, "Filter selected grid with SSL filter:\n", "Edit Bathymetry Grid", -1, null, opt, opt[gridShowing - 1]);
        if (s != null && s.length() > 0) {
            log.info("Applying SSFilt to selected grid: " + s);
            try {
                if (s.startsWith("A-Grid")) {
                    site.setBathyGrid(1, site.getBathyGrid(1).ssfilt());
                } else if (s.startsWith("B-Grid")) {
                    site.setBathyGrid(2, site.getBathyGrid(2).ssfilt());
                } else {
                    site.setBathyGrid(3, site.getBathyGrid(3).ssfilt());
                }
                site.clearLoadedBathymetryGrids();
            }
            catch (IOException ioe) {
                log.log(Level.WARNING, "Error writing grid file", ioe);
            }
            CMIUtil.cleanMostOutput(site, true, false, true);
            for (ModelListener ml : this.modelListeners) {
                ml.modelStopped(new ModelEvent(this.getCurrentSite(), 200, 0));
            }
            this.addEESiteSources(this.getCurrentSite(), true);
        }
    }

    private void closeAllMenuItemActionPerformed(ActionEvent evt) {
        log.info("Closing all open Model Sites.");
        if (this.mostModelRunner != null && this.mostModelRunner.isRunning()) {
            JOptionPane.showMessageDialog(this, "MOST is currently running.\nStopping model and closing all Model Sites", "Model running", 2);
            this.mostModelRunner.stop();
        }
        this.openSites.clear();
        this.firePropertyChange("openSites", null, this.openSites);
        this.setCurrentSite(null);
    }

    private void viewLogMenuItemActionPerformed(ActionEvent evt) {
        try {
            Desktop.getDesktop().open(new File(CMIUtil.etcDirName, "commit0.log"));
        }
        catch (IOException ioe) {
            log.log(Level.WARNING, "Error opening log file", ioe);
        }
    }

    private void hazardMenuItemActionPerformed(ActionEvent evt) {
        int response = JOptionPane.showConfirmDialog(this, "Do you wish to run all sources\n(This may take quite some time)", "Run all Sources", 0);
        if (response == 0) {
            log.info("\n\nRunning All Sources!\n\n");
            if (this.mostModelRunner != null && this.mostModelRunner.isRunning()) {
                this.mostModelRunner.stop();
            }
            this.runningAllSources = true;
            this.sourceComboBox.setSelectedIndex(0);
        }
    }

    private void addSourceMenuItemActionPerformed(ActionEvent evt) {
        if (this.askToStopModelRun()) {
            String sname = CMIUtil.currentSiteInfo.addSource("");
            this.ignoreEventEditorSourceChanges();
            this.eventEditor.clearActiveSources();
            this.listenForEventEditorSourceChanges();
            this.sourceComboBox.addItem(sname);
            this.sourceComboBox.setSelectedItem(sname);
        }
    }

    private void removeSourceMenuItemActionPerformed(ActionEvent evt) {
        if (this.askToStopModelRun()) {
            CMIUtil.cleanMostOutput(CMIUtil.currentSiteInfo, true, false, true);
            String sname = this.sourceComboBox.getSelectedItem().toString();
            CMIUtil.currentSiteInfo.removeSource(sname);
            this.sourceComboBox.removeItem(sname);
            String namenew = (String)this.sourceComboBox.getSelectedItem();
            this.firePropertyChange("sourceSwitched", sname, namenew);
        }
    }

    private void sourceComboBoxActionPerformed(ActionEvent evt) {
        String snameOld;
        if (this.sourceComboBox.getSelectedIndex() == -1) {
            return;
        }
        if (this.resettingSourceComboBoxModel) {
            return;
        }
        String sname = (String)this.sourceComboBox.getSelectedItem();
        if (sname.equals(snameOld = CMIUtil.currentSiteInfo.getActiveSourceName())) {
            this.eventEditor.jumpTo("to Selected");
            if (!this.runningAllSources) {
                return;
            }
        }
        if (this.askToStopModelRun()) {
            log.log(Level.FINE, "SiftShare is setting source to: {0}", sname);
            CMIUtil.currentSiteInfo.setSource(sname);
            this.firePropertyChange("sourceSwitched", null, sname);
        } else {
            this.sourceComboBox.setSelectedItem(CMIUtil.currentSiteInfo.getActiveSourceName());
        }
    }

    private void renameMenuItemActionPerformed(ActionEvent evt) {
        ModelRenameDialog diag = new ModelRenameDialog((Frame)this, true, this.getCurrentSite().getName());
        if (diag.getReturnStatue() == 1) {
            try {
                this.getCurrentSite().renameSite(diag.getName());
                this.modelNameButton.setText(this.getCurrentSite().getDirName());
                this.firePropertyChange("openSites", null, this.openSites);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Couldn't rename Model, please try again", "Error renameing Model", 2);
                log.log(Level.SEVERE, "Cant rename model site!", ex);
            }
        }
    }

    private void longitudeMenuItemActionPerformed(ActionEvent evt) {
        if (this.getCurrentSite() == null) {
            return;
        }
        BathyLonsTool bva = new BathyLonsTool((Frame)this, this.getCurrentSite());
        this.addPropertyChangeListener("currentSite", bva);
        this.addPropertyChangeListener("selectedGrid", bva);
        switch (this.outputTabbedPane.getSelectedIndex()) {
            case 0: 
            case 1: {
                this.outputTabbedPane.setSelectedIndex(2);
                break;
            }
        }
        bva.setVisible(true);
    }

    private void importSourcesMenuItemActionPerformed(ActionEvent evt) {
        SiteInfo site = this.getCurrentSite();
        if (site == null) {
            return;
        }
        JFileChooser chooser = new JFileChooser(new File(CMIUtil.workingDirName));
        chooser.setFileFilter(new SimpleFileFilter(".xml", "XML file of ComMIT sources"));
        chooser.setSelectedFile(new File(CMIUtil.workingDirName, site.getName() + "sources.xml"));
        chooser.setDialogTitle("Import Site Sources");
        if (chooser.showOpenDialog(this) == 0) {
            File f = chooser.getSelectedFile();
            log.log(Level.INFO, "Importing sources from xml file: {0}", f.getPath());
            if (f != null && f.exists()) {
                try {
                    String activeSource = site.getActiveSourceName();
                    site.importSourcesXMLFile(f);
                    site.setSource(activeSource);
                    this.firePropertyChange("currentSite", null, site);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Couldn't import Sources from xml file", e);
                    JOptionPane.showMessageDialog(this, "Error importing Sources from xml: \n" + e.getMessage());
                }
            }
        }
    }

    private void exportSourcesMenuItemActionPerformed(ActionEvent evt) {
        SiteInfo site = this.getCurrentSite();
        if (site == null) {
            return;
        }
        JFileChooser chooser = new JFileChooser(new File(CMIUtil.workingDirName));
        chooser.setFileFilter(new SimpleFileFilter(".xml", "XML file of ComMIT sources"));
        chooser.setSelectedFile(new File(CMIUtil.workingDirName, site.getName() + "_Sources.xml"));
        chooser.setDialogTitle("Export Site Sources");
        log.log(Level.INFO, "Exporting sources from Model Run {0} to xml file", site.getName());
        if (chooser.showSaveDialog(this) == 0) {
            site.exportSourcesXMLFile(chooser.getSelectedFile());
        }
    }

    private boolean askToStopModelRun() {
        boolean ret = true;
        if (this.mostModelRunner != null && this.mostModelRunner.isRunning()) {
            int result = JOptionPane.showConfirmDialog(this, String.format("MOST is currently running the model with source %s.\nDo you wish to stop the run and switch to another source?", this.getCurrentSite().getActiveSourceName()), "Model Running", 0, 3);
            if (result == 0) {
                if (this.mostModelRunner != null) {
                    this.runningAllSources = false;
                    this.mostModelRunner.stop();
                }
            } else {
                ret = false;
            }
        }
        return ret;
    }

    private static void addZipEntry(File f, String name, ZipOutputStream zos) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        FileInputStream fis = new FileInputStream(f);
        zos.putNextEntry(new ZipEntry(name));
        while ((len = fis.read(buf)) > 0) {
            zos.write(buf, 0, len);
        }
        zos.closeEntry();
        fis.close();
    }

    public ArrayList<SiteInfo> getOpenSites() {
        return this.openSites;
    }

    public SiteInfo getCurrentSite() {
        return CMIUtil.currentSiteInfo;
    }

    public void setCurrentSite(SiteInfo si) {
        this.setCurrentSite(si, false);
    }

    private void setCurrentSite(SiteInfo si, boolean forceNotify) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.ignoreEventEditorSourceChanges();
        if (si == null) {
            if (this.openSites.contains(this.getCurrentSite())) {
                si = this.getCurrentSite();
            } else if (!this.openSites.isEmpty()) {
                si = this.openSites.get(0);
            }
        }
        if (!forceNotify && (si == this.getCurrentSite() || si != null && si.equals(this.getCurrentSite()))) {
            this.eventEditor.jumpToCurrentSite();
            this.listenForEventEditorSourceChanges();
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        log.log(Level.INFO, "\n\nSetting current site to {0}\n\n", si);
        si = this.openSite(si);
        if (CMIUtil.currentSiteInfo != null) {
            CMIUtil.currentSiteInfo.clearLoadedBathymetryGrids();
        }
        SiteInfo oldSite = CMIUtil.currentSiteInfo;
        CMIUtil.currentSiteInfo = si;
        this.firePropertyChange("currentSite", oldSite, CMIUtil.currentSiteInfo);
        this.listenForEventEditorSourceChanges();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private SiteInfo openSite(SiteInfo site) {
        SiteInfo osite = null;
        if (site != null) {
            for (SiteInfo s : this.openSites) {
                if (!s.equals(site)) continue;
                osite = s;
                break;
            }
            if (osite == null) {
                this.openSites.add(site);
                osite = site;
                Collections.sort(this.openSites);
                this.firePropertyChange("openSites", null, this.openSites);
            }
        }
        return osite;
    }

    public boolean closeSite(SiteInfo site, boolean confirmIfRunning) {
        if (this.mostModelRunner != null && this.mostModelRunner.isRunning() && site.equals(this.mostModelRunner.getModelSite())) {
            if (confirmIfRunning && JOptionPane.showConfirmDialog(this, "MOST is currently running.\nYou must stop the model run before closing.", "Model running", 2, 2) == 2) {
                return false;
            }
            this.mostModelRunner.stop();
        }
        this.openSites.remove(site);
        this.firePropertyChange("openSites", null, this.openSites);
        if (site.equals(this.getCurrentSite())) {
            this.setCurrentSite(null);
        }
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String pn = evt.getPropertyName();
        log.log(Level.INFO, "SiftShare recd propertyChange evt: " + pn + " from: " + evt.getSource());
        if (evt.getSource() == this.getCurrentSite() && this.mostModelRunner != null && this.mostModelRunner.isRunning()) {
            JOptionPane.showMessageDialog(this, "Changing the MOST parameters requires re-running the Model.\nPlease re-run the model by clicking \"Start\"\n", "Model running ... parameters changed", 2);
            this.runningAllSources = false;
            this.mostModelRunner.stop();
            return;
        }
        if (evt.getSource() == this && "currentSite".equals(pn)) {
            SiteInfo oldsi = (SiteInfo)evt.getOldValue();
            SiteInfo si = (SiteInfo)evt.getNewValue();
            if (oldsi != null) {
                oldsi.removePropertyChangeListener(this);
            }
            boolean siteOpen = si != null;
            this.setTitle((siteOpen ? si.getName() + ": " : "") + WINDOW_TITLE_TEXT);
            this.modelNameButton.setText(siteOpen ? si.getDirName() : "none");
            this.resettingSourceComboBoxModel = true;
            this.sourceComboBox.removeAllItems();
            if (siteOpen) {
                Set<String> snames = si.getSourceNames();
                for (String n : snames) {
                    this.sourceComboBox.addItem(n);
                }
                this.sourceComboBox.setSelectedItem(si.getActiveSourceName());
            } else {
                this.sourceComboBox.addItem("add a source");
            }
            this.resettingSourceComboBoxModel = false;
            this.saveAnimMenuItem.setEnabled(siteOpen);
            this.saveGEMenuItem.setEnabled(siteOpen);
            this.saveTSMenuItem.setEnabled(siteOpen);
            this.cleanMenuItem.setEnabled(siteOpen);
            this.closeRunMenuItem.setEnabled(siteOpen);
            this.copyMenuItem.setEnabled(siteOpen);
            this.publishMenuItem.setEnabled(siteOpen);
            this.saveAnimMenuItem.setEnabled(siteOpen);
            this.cflMenuItem.setEnabled(siteOpen);
            this.smoothBathyMenuItem.setEnabled(siteOpen);
            this.exportMenuItem.setEnabled(siteOpen);
            this.eventMenuItem.setEnabled(siteOpen);
            this.runCancelButton.setEnabled(siteOpen);
            if (this.gif != null) {
                this.gif.closeFrame();
            }
            this.updateEventEditorSite(si);
            this.eventEditor.jumpToCurrentSite();
            this.updateModelOutputLog(si);
            this.updateToolbarSite(si);
            this.modelSetupPanel.repaint();
            if (si != null) {
                si.addPropertyChangeListener(this);
            }
        } else if ("numberOutputTimesteps".equals(pn) || "openSites".equals(pn)) {
            this.updateToolbarSite(this.getCurrentSite());
        } else if ("sourceSwitched".equals(pn)) {
            SiteInfo si = CMIUtil.currentSiteInfo;
            log.info("sourceSwitched: " + si.getActiveSourceName() + " inv: " + si.getSourceNamesAndSlips());
            this.listenForSourceChanges = false;
            this.eventEditor.setActive(si.getSourceNamesAndSlips());
            this.eventEditor.jumpToFromCB("to Selected");
            this.updateModelOutputLog(si);
            this.updateModelSourceScenario();
            this.outputMessages.setStoppedProgressBar(si);
            this.listenForSourceChanges = true;
            if (this.runningAllSources) {
                this.startStopModelProcess();
            }
        } else if ("sourceScenario".equals(pn)) {
            this.updateModelSourceScenario();
        }
    }

    public void updateModelSourceScenario() {
        SourceScenario ss = this.getCurrentSite().getSourceScenario();
        if (ss != null) {
            log.info(ss.toString());
            double lon = ss.getSeismicEvent().getLongitude();
            double lat = ss.getSeismicEvent().getLatitude();
            this.eventEditor.setEpicenter(lon, lat);
            this.eventEditor.plotMark(true);
            this.projectLabel.setText(ss.getSeismicEvent().toString());
        } else {
            log.info("No SourceScenario for this source");
            this.eventEditor.plotMark(false);
            this.projectLabel.setText("none");
        }
    }

    public void listenForEventEditorSourceChanges() {
        log.info("Listening for EventEditor source changes");
        this.listenForSourceChanges = true;
    }

    public void ignoreEventEditorSourceChanges() {
        log.info("Ignoring EventEditor source changes");
        this.listenForSourceChanges = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        log.log(Level.INFO, "in SiftShare.actionPerformed, actionCommand: {0}", actionCommand);
        if (actionCommand.equals("sources changed") && this.listenForSourceChanges) {
            if (this.getCurrentSite() == null) {
                return;
            }
            if (this.getCurrentSite().getOutputFile(3).exists()) {
                int result;
                String msg = "This Model Run has Model Results!\nChanging the Unit Sources will delete Model Results\nContinue changing the Unit Source combination?";
                Boolean running = false;
                this.listenForSourceChanges = false;
                if (this.mostModelRunner != null && this.mostModelRunner.isRunning()) {
                    running = true;
                    msg = "This Model Run is currently running!\nChanging the Unit Sources will stop the model\nContinue changing the Unit Source combination?";
                }
                if ((result = JOptionPane.showConfirmDialog(this, msg, "Warning", 0, 2)) == 0) {
                    this.getCurrentSite().setSourceNamesAndSlips(this.eventEditor.getActiveSourceCombo().getSourceNames());
                    if (running.booleanValue()) {
                        this.mostModelRunner.stop();
                    }
                    CMIUtil.cleanMostOutput(this.getCurrentSite(), true, false, true, false);
                    for (ModelListener ml : this.modelListeners) {
                        ml.modelStopped(new ModelEvent(this.getCurrentSite(), 200, 0));
                    }
                } else {
                    this.eventEditor.setActive(this.getCurrentSite().getSourceNamesAndSlips());
                }
                this.sicPanel.readGrid();
                this.listenForSourceChanges = true;
            } else {
                this.listenForSourceChanges = false;
                this.getCurrentSite().setSourceNamesAndSlips(this.eventEditor.getActiveSourceCombo().getSourceNames());
                this.listenForSourceChanges = true;
            }
        }
    }

    public void updateEventEditor(boolean showProgressMonitor) {
        PropagationUpdateWorker eventEditorWorker = new PropagationUpdateWorker();
        if (showProgressMonitor) {
            IndeterminateProgressMonitor pm = new IndeterminateProgressMonitor(this, "Updating propagation database...        ");
            eventEditorWorker.setProgressMonitor(pm);
            pm.setAlwaysOnTop(true);
            pm.setVisible(true);
            pm.setSwingWorker(eventEditorWorker);
        }
        eventEditorWorker.start();
    }

    private List<String> updateDatabaseLocs() {
        List<String> dbLocs;
        log.info("\n\nStarting update Database\n\n");
        if (CMIUtil.DATABASE_LOC.length() != 0) {
            dbLocs = Arrays.asList(CMIUtil.DATABASE_LOC.split(","));
            for (String db : dbLocs) {
                if (!db.startsWith("http") && db.equalsIgnoreCase("(default server)")) continue;
            }
        } else {
            dbLocs = Collections.emptyList();
        }
        return dbLocs;
    }

    private Stack<Color> getColorStack() {
        Stack<Color> colorStack = new Stack<Color>();
        colorStack.push(new Color(204, 153, 51));
        colorStack.push(new Color(255, 153, 51));
        colorStack.push(new Color(204, 255, 102));
        colorStack.push(new Color(0, 0, 0));
        colorStack.push(new Color(204, 255, 255));
        colorStack.push(new Color(153, 0, 153));
        colorStack.push(new Color(255, 41, 102));
        colorStack.push(new Color(0, 153, 51));
        colorStack.push(new Color(204, 51, 255));
        colorStack.push(new Color(255, 255, 102));
        return colorStack;
    }

    private void showPropExtents() {
        log.info("Checking UnitSources for grid extent in EE");
        String zone = "";
        Color currentColor = new Color(255, 255, 255);
        Stack<Color> colorStack = this.getColorStack();
        ArrayList<UnitSource> sources = new ArrayList<UnitSource>();
        sources.addAll(this.eventEditor.getSources());
        Collections.sort(sources);
        this.eventEditor.clearPropGrids();
        this.eventEditor.drawGrids(true);
        this.eventEditor.jumpTo("World");
        for (UnitSource aSource : sources) {
            if (aSource.isCropped()) continue;
            if (!aSource.getZone().equals(zone)) {
                zone = aSource.getZone();
                String URLName = aSource.getFileName().replaceAll("http:", "https:");
                try {
                    PropGrid pg;
                    if (URLName.startsWith("http") && URLName.contains("/compressed/")) {
                        log.info(URLName);
                        Properties pgprop = new Properties();
                        pgprop.load(new URL(URLName + "?global=" + (CMIUtil.propGlobal ? "true" : "false") + "&extents=true").openStream());
                        double minLon = Double.parseDouble(pgprop.getProperty("xmin"));
                        double minLat = Double.parseDouble(pgprop.getProperty("ymin"));
                        double maxLon = Double.parseDouble(pgprop.getProperty("xmax"));
                        double maxLat = Double.parseDouble(pgprop.getProperty("ymax"));
                        int numLon = Integer.parseInt(pgprop.getProperty("xsize"));
                        int numLat = Integer.parseInt(pgprop.getProperty("ysize"));
                        pg = new PropGrid(minLon, maxLon, minLat, maxLat, numLon, numLat);
                    } else {
                        NetcdfFile nc = URLName.startsWith("https:") || URLName.startsWith("dods:") ? new DODSNetcdfFile(URLName) : NetcdfFile.open(URLName);
                        PropFileReaderBase pfr = new PropFileReaderBase(nc);
                        pg = new PropGrid(pfr.getLongitudeCoordinates(), pfr.getLatitudeCoordinates());
                    }
                    pg.setRGB(-9999);
                    log.log(Level.FINE, "checking Propagation Grid extents for zone: {0}: {1}", new Object[]{zone, pg});
                    int testColor = this.eventEditor.addPropGrid(pg);
                    if (testColor == -9999) {
                        log.fine("added new PropGrid (extents are unique)");
                        currentColor = colorStack.empty() ? new Color(255, 255, 255) : colorStack.pop();
                        pg.setRGB(currentColor.getRGB());
                    } else {
                        currentColor = new Color(testColor);
                    }
                    aSource.setRGB(currentColor.getRGB());
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Error opening Propagation file:" + URLName + " to check grid size", ex);
                }
                if (Thread.interrupted()) {
                    return;
                }
                this.eventEditor.repaint();
                continue;
            }
            aSource.setRGB(currentColor.getRGB());
        }
    }

    private void hidePropExtents() {
        ArrayList<UnitSource> sources = this.eventEditor.getSources();
        for (UnitSource aSource : sources) {
            aSource.setRGB(-1973791);
        }
        this.eventEditor.drawGrids(false);
    }

    private void showHelp() {
        String ver = VERSION.trim();
        if (ver.contains("a")) {
            ver = ver.substring(0, ver.indexOf("a"));
        }
        if (ver.contains("b")) {
            ver = ver.substring(0, ver.indexOf("b"));
        }
        File f = new File(CMIUtil.etcDirName, "ComMITManual" + ver + ".pdf");
        try {
            CMIUtil.unpackFile(this, "html/ComMITManual" + ver + ".pdf", new File(CMIUtil.etcDirName), f.getName());
            Desktop.getDesktop().open(f);
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "Can't open the help file: " + f.getPath(), ex);
            JOptionPane.showMessageDialog(this, "Can't open PDF file, please install Adobe Acrobat", "Error opening Help document", 0);
        }
    }

    public boolean closeApp() {
        boolean modelRunning;
        boolean bl = modelRunning = this.mostModelRunner != null && this.mostModelRunner.isRunning();
        if (CMIUtil.showExitDialog || modelRunning) {
            String msg = modelRunning ? String.format("A model is still running. ", new Object[0]) : "";
            AlwaysAskYesNoDialog aad = new AlwaysAskYesNoDialog(this, true, msg + "Do you really want to exit?", "Exit confirmation", "EXIT_DIALOG");
            int result = aad.showDialog();
            CMIUtil.showExitDialog = aad.alwaysAsk();
            this.preferences.putBoolean("EXIT_DIALOG", aad.alwaysAsk());
            if (result != 1) {
                return false;
            }
        }
        if (modelRunning && this.mostModelRunner != null) {
            this.mostModelRunner.stop();
        }
        this.preferences.putInt("WINDOW_X", this.getX());
        this.preferences.putInt("WINDOW_Y", this.getY());
        this.preferences.putInt("WINDOW_WIDTH", this.getWidth());
        this.preferences.putInt("WINDOW_HEIGHT", this.getHeight());
        this.preferences.putInt("SPLIT_POS", this.mostResultsPanel.getSplitPanePosition());
        this.prefsDialog.savePrefs();
        log.info("\nClosing ComMIT application.\n");
        return true;
    }

    public boolean addModelListener(ModelListener me) {
        return this.modelListeners.add(me);
    }

    public boolean removeModelListener(ModelListener me) {
        return this.modelListeners.remove(me);
    }

    public AbstractGridTool getCurrentGridTool() {
        return this.currentGridTool;
    }

    private void platformSpecificUI() {
        if (System.getProperty("os.name").toLowerCase().startsWith("mac os x") && "true".equals(System.getProperty("apple.laf.useScreenMenuBar"))) {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("closeApp", null));
                OSXAdapter.setAboutHandler(this, this.getClass().getDeclaredMethod("showAboutDialog", null));
                OSXAdapter.setPreferencesHandler(this, this.getClass().getDeclaredMethod("showPrefsDialog", null));
                this.helpMenu.remove(this.aboutMenuItem);
                this.editMenu.remove(this.prefsMenuItem);
                this.fileMenu.remove(this.exitMenuItem);
                int mcc = this.fileMenu.getMenuComponentCount() - 1;
                if (mcc > 0 && this.fileMenu.getMenuComponent(mcc) instanceof JSeparator) {
                    this.fileMenu.remove(mcc);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error configuring Mac OS X user interface: {0}", e.getMessage());
            }
        }
        try {
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/ComMITIcon.gif")));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void doEventDialog(boolean projectMode) {
        if (this.getCurrentSite() == null) {
            return;
        }
        OpenEventDialog dlg = new OpenEventDialog((Frame)this, this.getCurrentSite(), projectMode, this.eventEditor);
        dlg.setSelectedScenario(this.getCurrentSite().getSourceScenario());
        dlg.setVisible(true);
        if (dlg.getReturnStatus() != 1) {
            return;
        }
        SourceScenario ss = dlg.getSelectedSourceScenario();
        if (ss != null) {
            if (dlg.getCreateModelRun()) {
                try {
                    SiteInfo si2;
                    log.info("Creating new Model Run from 'Add Event' dialog");
                    String basename = this.getCurrentSite().getName();
                    int idx = basename.lastIndexOf(95);
                    if (idx > 1) {
                        basename = basename.substring(0, idx);
                    }
                    basename = basename + "_" + SourceCombo.getSimpleName(ss.getSourceNamesAndSlips());
                    Object newSiteName = basename;
                    HashSet<String> siteNames = new HashSet<String>();
                    for (SiteInfo si2 : this.openSites) {
                        siteNames.add(si2.getName().toLowerCase());
                    }
                    int count = 0;
                    while (siteNames.contains(((String)newSiteName).toLowerCase())) {
                        newSiteName = String.format("%s_ver%d", basename, ++count);
                    }
                    si2 = SiteInfo.copySite(this.getCurrentSite(), new File(CMIUtil.workingDirName), (String)newSiteName);
                    if (this.mostModelRunner != null && this.mostModelRunner.isRunning()) {
                        this.mostModelRunner.stop();
                    }
                    this.setCurrentSite(this.openSite(si2));
                }
                catch (IOException ex) {
                    log.log(Level.SEVERE, null, ex);
                    JOptionPane.showMessageDialog(this, "Could not create new model run:\n\n" + ex.getMessage(), "Error", 0);
                    return;
                }
            }
            this.ignoreEventEditorSourceChanges();
            try {
                SourceCombo projectSC = new SourceCombo(ss.getSourceNamesAndSlips(), PropagationDatabase.getInstance());
                SourceCombo currentSC = new SourceCombo(this.getCurrentSite().getSourceNamesAndSlips(), PropagationDatabase.getInstance());
                if (!currentSC.equals(projectSC)) {
                    if (this.mostModelRunner != null && this.mostModelRunner.isRunning()) {
                        this.mostModelRunner.stop();
                    }
                    CMIUtil.cleanMostOutput(this.getCurrentSite(), true, false, true);
                    for (ModelListener ml : this.modelListeners) {
                        ml.modelStopped(new ModelEvent(this.getCurrentSite(), 200, 0));
                    }
                }
            }
            catch (PropagationDatabaseException pde) {
                log.warning("Can't get SourceCombo from propdb...");
            }
            this.ignoreEventEditorSourceChanges();
            this.getCurrentSite().setSourceNamesAndSlips(ss.getSourceNamesAndSlips());
            this.getCurrentSite().setSourceScenario(ss);
            this.firePropertyChange("sourceScenario", null, ss);
            this.eventEditor.setActive(ss.getSourceNamesAndSlips());
            double lon = ss.getSeismicEvent().getLongitude();
            double lat = ss.getSeismicEvent().getLatitude();
            this.eventEditor.setEpicenter(lon, lat);
            this.eventEditor.plotMark(true);
            this.projectLabel.setText(ss.getSeismicEvent().toString());
            this.eventEditor.jumpToFromCB("to Selected");
            this.sicPanel.readGrid();
            this.listenForEventEditorSourceChanges();
        }
    }

    private void addPropfolderUnitSources() {
        File dir = new File(CMIUtil.propDirName);
        File[] files = dir.listFiles();
        int numAdded = 0;
        ArrayList<String> filesNotAdded = new ArrayList<String>();
        Color customColor = new Color(255, 255, 0);
        PropagationDatabase propdb = PropagationDatabase.getInstance();
        for (File f : files) {
            String fileName = f.getPath();
            if (!fileName.endsWith("ha.nc") || !new File(fileName.replaceAll("ha.nc", "ua.nc")).exists() || !new File(fileName.replaceAll("ha.nc", "va.nc")).exists()) continue;
            UnitSource us = null;
            try {
                NetcdfFile ncf = NetcdfFile.open(fileName);
                Attribute att = null;
                att = ncf.findGlobalAttribute("IC_Deformation_file");
                if (att != null) {
                    us = new UnitSource(fileName);
                    att = ncf.findGlobalAttribute("Source_Zone_Code");
                    if (att != null) {
                        us.setZoneCode(att.getStringValue());
                    }
                    if ((att = ncf.findGlobalAttribute("Source_Zone_Name")) != null) {
                        us.setZone(att.getStringValue());
                    }
                    att = ncf.findGlobalAttribute("Source_Row");
                    int row = -999;
                    row = att.isString() ? Integer.parseInt(att.getStringValue()) : att.getNumericValue().intValue();
                    us.setNameNumber(row);
                    String col = ncf.findGlobalAttribute("Source_Column").getStringValue();
                    us.setNameLetter(col);
                    us.setName(String.format("%s%d%s", us.getZoneCode(), us.getNameNumber(), us.getNameLetter()));
                    us.parseName();
                } else {
                    us = new UnitSource(new File(fileName));
                }
                ncf.close();
                us.setRGB(customColor.getRGB());
                log.info("Custom Prop output found, adding: " + us.toString());
                ++numAdded;
                propdb.addUnitSource(us);
            }
            catch (IOException ioe) {
                log.log(Level.WARNING, "Error creating Unitsource.", ioe);
                filesNotAdded.add(fileName);
            }
        }
        log.info("Files added to PropDB: " + numAdded);
        if (filesNotAdded.size() > 0) {
            StringBuffer sb = new StringBuffer();
            String comma = "";
            for (String s : filesNotAdded) {
                sb.append(comma);
                sb.append(s);
                comma = ", ";
            }
            log.warning("Files NOT added to PropDB: " + sb.toString());
        }
        this.eventEditor.setSources(propdb.getUnitSources());
    }

    public void checkForLocalPropRunUpdates(JFrame frame) {
        int ret;
        log.info("Checking for local Propagation updates");
        boolean foundone = false;
        ArrayList<SiteInfo> outOfDateSites = new ArrayList<SiteInfo>();
        for (SiteInfo si : this.getOpenSites()) {
            File[] fa = si.getSiteDirectory().listFiles();
            for (int i = 0; i < fa.length; ++i) {
                String fname = fa[i].getName();
                if (!fname.startsWith("cu") || !fname.endsWith("ha.nc") || this.isCurrent(fa[i])) continue;
                foundone = true;
                outOfDateSites.add(si);
                log.fine("Found outOfDate prop cache for site: " + si);
            }
        }
        if (foundone && (ret = JOptionPane.showConfirmDialog(frame, "Some Model Runs have cached local Custom Propagation Runs\nthat are out-of-date.  Clear these and use the new ones?", "Use new Custom Propagation Runs?", 0, 3)) == 0) {
            if (this.mostModelRunner != null && this.mostModelRunner.isRunning()) {
                this.mostModelRunner.stop();
            }
            for (SiteInfo si : outOfDateSites) {
                CMIUtil.cleanMostOutput(si, true, true, true);
            }
            for (ModelListener ml : this.modelListeners) {
                ml.modelStopped(new ModelEvent(this.getCurrentSite(), 200, 0));
            }
            this.addEESiteSources(this.getCurrentSite(), true);
        }
    }

    public boolean isCurrent(File croppedPropFile) {
        boolean retval = true;
        try {
            NetcdfFile ncCrop = NetcdfFile.open(croppedPropFile.getPath());
            NetcdfFile ncProp = NetcdfFile.open(ncCrop.findGlobalAttribute("croppedfrom").getStringValue());
            if (ncProp.findGlobalAttribute("Source_Length") == null) {
                log.info("Found a custom deformation propagation run, updating inundation models that depend on it.");
                return false;
            }
            if (!ncProp.findGlobalAttribute("Source_Length").equals(ncCrop.findGlobalAttribute("Source_Length"))) {
                retval = false;
            }
            if (!ncProp.findGlobalAttribute("Source_Width").equals(ncCrop.findGlobalAttribute("Source_Width"))) {
                retval = false;
            }
            if (!ncProp.findGlobalAttribute("Source_Longitude").equals(ncCrop.findGlobalAttribute("Source_Longitude"))) {
                retval = false;
            }
            if (!ncProp.findGlobalAttribute("Source_Latitude").equals(ncCrop.findGlobalAttribute("Source_Latitude"))) {
                retval = false;
            }
            if (!ncProp.findGlobalAttribute("Dip").equals(ncCrop.findGlobalAttribute("Dip"))) {
                retval = false;
            }
            if (!ncProp.findGlobalAttribute("Rake").equals(ncCrop.findGlobalAttribute("Rake"))) {
                retval = false;
            }
            if (!ncProp.findGlobalAttribute("Strike").equals(ncCrop.findGlobalAttribute("Strike"))) {
                retval = false;
            }
            if (!ncProp.findGlobalAttribute("Slip").equals(ncCrop.findGlobalAttribute("Slip"))) {
                retval = false;
            }
            if (!ncProp.findGlobalAttribute("Depth").equals(ncCrop.findGlobalAttribute("Depth"))) {
                retval = false;
            }
            if (NCUtil.findNcDimension(ncProp, "time").getLength() != NCUtil.findNcDimension(ncCrop, "time").getLength()) {
                retval = false;
            }
        }
        catch (IOException | NullPointerException ex) {
            retval = false;
            log.log(Level.WARNING, "Error checking seismic params for cropped file", ex);
        }
        return retval;
    }

    public static void createLinComb(String siteDir, String sourceNamesAndSlips) throws IOException {
        SiteInfo si = new SiteInfo(new File(siteDir));
        SourceCombo sc = null;
        try {
            sc = new SourceCombo(sourceNamesAndSlips, PropagationDatabase.getInstance());
            LinCombModule lcm = new LinCombModule(si, sc, null);
            if (lcm.isLinCoUpToDate(sc.getSourceNames())) {
                log.log(Level.INFO, "linCoh.nc file already exists for SourceCombo {0}.", sc.getSourceNames());
            } else {
                lcm.createLinComb();
                log.info("\n\nSuccessfully created linComb files!!\n\n");
            }
        }
        catch (PropagationDatabaseException ex) {
            throw new IOException(ex);
        }
        catch (LinCombModule.LinCombException ex) {
            throw new IOException(ex);
        }
    }

    public static void runModelRun(SiteInfo si, String sourceNamesAndSlips) throws IOException {
        log.info("Running MOST for site: " + si + " with invsion: " + sourceNamesAndSlips + " source: " + si.getActiveSourceName());
        CMIUtil.cleanMostOutput(si, true, false, true, true);
        ArrayList<ModelListener> ml = new ArrayList<ModelListener>();
        ml.add(new CommandLineModelListener());
        si.loadSettings(true);
        ModelRunner mmr = new ModelRunner(si, ml);
        try {
            SourceCombo sc = new SourceCombo(sourceNamesAndSlips, PropagationDatabase.getInstance());
            LinCombModule lcm = new LinCombModule(si, sc, null);
            mmr.setLinearCombinator(lcm);
        }
        catch (PropagationDatabaseException pde) {
            log.severe("Error accessing PropDB class for SourceCombo");
            throw new IOException(pde);
        }
        Thread t = mmr.start();
        while (mmr.isRunning()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
                break;
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        String snas = "";
        String siteDir = "";
        String dblocs = "https://sift.pmel.noaa.gov/ComMIT/compressed";
        boolean execute = false;
        boolean verbose = false;
        int sourceNum = 1;
        PrintStream filterOut = new PrintStream(System.err){

            @Override
            public void println(String l) {
                if (!l.startsWith("SLF4J")) {
                    super.println(l);
                }
            }
        };
        System.setErr(filterOut);
        Preferences prefs = Preferences.userRoot().node("/gov/noaa/tsunami/cmi");
        CMIUtil.baseDirName = prefs.get("BASEDIR", System.getProperty("user.dir") + File.separator + "ComMIT");
        CMIUtil.workingDirName = prefs.get("WORKINGDIR", CMIUtil.baseDirName + File.separator + "scratch");
        CMIUtil.MOST_EXEC = prefs.get("MOST_EXEC", CMIUtil.baseDirName + File.separator + "bin" + File.separator + "most3_facts_nc_null");
        CMIUtil.MOST_REV = prefs.getInt("MOST_REV", 0);
        double maxLat = -9999.0;
        double minLat = -9999.0;
        double maxLon = -9999.0;
        double minLon = -9999.0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-d") || args[i].equals("-debug")) {
                CMIUtil.DEBUG = true;
                log.setLevel(Level.FINER);
                ConsoleHandler ch = new ConsoleHandler();
                ch.setLevel(Level.FINER);
                log.addHandler(ch);
            }
            if (args[i].equals("-l") && args.length > i + 1) {
                snas = args[i + 1];
            }
            if (args[i].equals("-m") && args.length > i + 1) {
                siteDir = args[i + 1];
            }
            if (args[i].equals("-p") && args.length > i + 1) {
                dblocs = args[i + 1];
            }
            if (args[i].equals("-e")) {
                execute = true;
            }
            if (args[i].equals("-n")) {
                try {
                    sourceNum = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException ch) {
                    // empty catch block
                }
            }
            if (args[i].equals("-v")) {
                verbose = true;
            }
            if (!args[i].equals("-x") || args.length <= i + 4) continue;
            try {
                minLon = Double.parseDouble(args[i + 1]);
                maxLon = Double.parseDouble(args[i + 2]);
                minLat = Double.parseDouble(args[i + 3]);
                maxLat = Double.parseDouble(args[i + 4]);
                System.out.println("minLon: " + minLon);
                continue;
            }
            catch (NumberFormatException ch) {
                // empty catch block
            }
        }
        if (!snas.equals("")) {
            ArrayList<String> dblist = new ArrayList<String>();
            dblist.add(dblocs);
            try {
                PropagationDatabase.getInstance().setDatabaseLocations(dblist, CMIUtil.propGlobal);
                SiteInfo si = new SiteInfo(new File(CMIUtil.workingDirName, siteDir));
                log.info("Opening site: " + si.getDirName());
                CMIUtil.currentSiteInfo = si;
                CMIUtil.currentSiteInfo.setSource(String.format("source%03d", sourceNum));
                CMIUtil.currentSiteInfo.setSourceNamesAndSlips(snas);
                if (execute) {
                    SiftShare.runModelRun(si, snas);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    SiftShare.createLinComb(si.getDirName(), snas);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                System.exit(4);
            }
            System.exit(0);
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e2) {
            log.log(Level.WARNING, "Error setting system look and feel ", e2);
        }
        SplashScreen ss = new SplashScreen("images/splash_lapalma.png", VERSION);
        new Thread(ss).start();
        Locale.setDefault(Locale.US);
        SiftShare siftShare = null;
        try {
            siftShare = new SiftShare(ss);
            log.info("setting visible");
            siftShare.setVisible(true);
            siftShare.showInitialHelp();
            siftShare.updateEventEditor(true);
            ss.close();
            ss = null;
            siftShare.checkForComMITUpdate();
        }
        catch (OutOfMemoryError oe) {
            log.log(Level.SEVERE, "OutOfMemoryError in top-level SiftShare", oe);
            String msg = "ComMIT has run out of memory (heap space).\n\nIf ComMIT was run from the command line, make sure the command was:\njava -Xmx1500m -jar ComMIT.jar";
            ss.setInfoString("ComMIT has run out of memory (heap space).\n\nIf ComMIT was run from the command line, make sure the command was:\njava -Xmx1500m -jar ComMIT.jar");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (ss != null) {
                ss.close();
                ss = null;
            }
            System.err.println("ComMIT has run out of memory (heap space).\n\nIf ComMIT was run from the command line, make sure the command was:\njava -Xmx1500m -jar ComMIT.jar");
            JOptionPane.showMessageDialog(null, "ComMIT has run out of memory (heap space).\n\nIf ComMIT was run from the command line, make sure the command was:\njava -Xmx1500m -jar ComMIT.jar", "Out of memory", 0);
            System.exit(-1);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Exception caught in top-level SiftShare", e);
            System.exit(-1);
        }
    }

    static {
        log = Logger.getLogger("gov.noaa.tsunami");
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT] %2$s %n            [%4$-7s] %5$s%6$s %n");
    }

    private class PropagationUpdateWorker
    extends SwingWorker {
        private IndeterminateProgressMonitor pm = null;
        private ListIterator<String> dbiter;
        private Thread dbthread = null;
        private Exception dbthreadError = null;

        PropagationUpdateWorker() {
        }

        public void setProgressMonitor(IndeterminateProgressMonitor pm) {
            this.pm = pm;
        }

        private void doReadDb(String dbaddr) {
            this.dbthreadError = null;
            try {
                log.info("loading infosz from server, global: " + CMIUtil.propGlobal);
                SiftShare.this.eventEditor.addDatabaseLocation(dbaddr, CMIUtil.propGlobal);
            }
            catch (IOException ex) {
                this.dbthreadError = ex;
            }
        }

        private void loadUnitSources() {
            this.dbiter = SiftShare.this.updateDatabaseLocs().listIterator();
            while (this.dbiter.hasNext()) {
                String newServer;
                String dbaddr;
                String dbloc = this.dbiter.next();
                boolean isComMITServer = dbloc.equals("(default server)");
                String string = isComMITServer ? CMIUtil.commitServerAddress + (CMIUtil.commitServerAddress.contains("/compressed") ? "" : "/compressed/") : (dbaddr = dbloc);
                if (CMIUtil.workOffline && (dbaddr.startsWith("https:") || isComMITServer)) continue;
                if (this.pm != null) {
                    this.pm.setNoteLabel(dbaddr + (dbaddr.endsWith("/") ? "" : "/") + "info_sz.dat");
                }
                this.dbthread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        PropagationUpdateWorker.this.doReadDb(dbaddr);
                    }
                }, dbloc);
                this.dbthread.start();
                try {
                    this.dbthread.join();
                }
                catch (InterruptedException ex) {
                    this.dbthreadError = ex;
                    this.dbthread.interrupt();
                    this.dbthread = null;
                }
                Thread.interrupted();
                if (this.dbthreadError == null || !isComMITServer) continue;
                if (this.pm != null) {
                    this.pm.setVisible(false);
                }
                ComMITServerSelector serverDlg = new ComMITServerSelector(SiftShare.this.mainApp, CMIUtil.commitServerAddress, CMIUtil.workOffline);
                serverDlg.setErrorMode(true);
                serverDlg.setLocationRelativeTo(SiftShare.this.mainApp);
                serverDlg.setVisible(true);
                if (this.pm != null) {
                    this.pm.setVisible(true);
                }
                if ((newServer = serverDlg.getSelectedServerAddress()) == null) continue;
                SiftShare.this.prefsDialog.setComMITServerAddress(newServer, serverDlg.getWorkOffline());
                this.dbiter.previous();
            }
        }

        @Override
        public Object construct() {
            String prev_sc = SiftShare.this.eventEditor.getActiveSourceCombo().getSourceNames();
            SiftShare.this.ignoreEventEditorSourceChanges();
            SiftShare.this.eventEditor.clearUnitSources();
            new File(CMIUtil.propDirName + File.separator + "info_sz.dat").delete();
            SiftShare.this.addPropfolderUnitSources();
            this.loadUnitSources();
            if (SiftShare.this.getCurrentSite() != null) {
                SiftShare.this.updateEventEditorSite(SiftShare.this.getCurrentSite());
                SourceCombo sc = SiftShare.this.eventEditor.getSourceComboFromString(prev_sc);
                if (!sc.getSourceNames().equals(prev_sc)) {
                    log.warning("database changed, initial condition must be re-calculated for this site.");
                    SiftShare.this.sicPanel.clearData();
                    JOptionPane.showMessageDialog(this.pm.getParent(), "One or more of the unit sources selected is no longer available from the source databases", "Unit source database changed", 2);
                }
            }
            if (SiftShare.this.propExtentsCheckBoxMenuItem.isSelected() && SiftShare.this.isVisible()) {
                SiftShare.this.showPropExtents();
            }
            if (this.pm != null) {
                this.pm.setNoteLabel("Parsing Earthquake Events");
            }
            OpenEventDialog.loadQuakeEvents();
            if (this.pm != null) {
                this.pm.setNoteLabel("Checking for MOST model update");
            }
            SiftShare.this.MED.setCompletionCallback(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(SiftShare.this.mainApp, "The MOST model was successfully updated.", "Update completed", 1);
                }
            });
            SiftShare.this.MED.initialCheckForMostUpdate(SiftShare.this.mainApp, 0);
            return null;
        }

        @Override
        public void finished() {
            SiftShare.this.openPreviousModels();
            SiftShare.this.listenForEventEditorSourceChanges();
            if (this.pm != null) {
                this.pm.closeMe();
            }
            SiftShare.this.modelSetupPanel.repaint();
        }
    }

    private class SiftShareModelListener
    implements ModelListener {
        private int lastStatus = 100;

        private SiftShareModelListener() {
        }

        @Override
        public void modelStarted(final ModelEvent me) {
            CMIUtil.runOnDispatchThread(new Runnable(){

                @Override
                public void run() {
                    log.log(Level.FINE, "SiftShareModelListener.modelStarted: {0}", me);
                    if (!me.getSourceModel().equals(SiftShare.this.getCurrentSite())) {
                        return;
                    }
                    SiftShare.this.modelLogTextArea.setText("");
                    SiftShare.this.outputMessages.updateProgressBar(null, 0, 0);
                    SiftShareModelListener.this.modelLogUpdate(me);
                    SiftShare.this.runCancelButton.setText("Stop model");
                    SiftShare.this.runCancelButton.setIcon(SiftShare.this.modelStopIcon);
                }
            });
        }

        @Override
        public void modelStopped(final ModelEvent me) {
            CMIUtil.runOnDispatchThread(new Runnable(){

                @Override
                public void run() {
                    log.log(Level.FINE, "SiftShareModelListener.modelStopped: {0}", me);
                    SiftShare.this.runCancelButton.setText("Start model");
                    SiftShare.this.runCancelButton.setIcon(SiftShare.this.modelStartIcon);
                    SiftShare.this.siteComboBox.repaint();
                    if (me.getSourceModel().equals(SiftShare.this.getCurrentSite())) {
                        SiftShare.this.outputMessages.setStoppedProgressBar(SiftShare.this.getCurrentSite());
                        SiftShareModelListener.this.modelLogUpdate(me);
                    }
                    if (me.getStatus() == 201) {
                        SiftShare.this.runningAllSources = false;
                        if (SiftShareModelListener.this.lastStatus == 100 && me.getSourceModel().equals(SiftShare.this.getCurrentSite())) {
                            JOptionPane.showMessageDialog(SiftShare.this.mainApp, "An error occurred while setting up the model:\n\n" + me.getMessage(), "Error", 0);
                        } else {
                            JOptionPane.showMessageDialog(SiftShare.this.mainApp, "The MOST model returned an error:\n\n" + me.getMessage(), "MOST Error", 0);
                        }
                    }
                    SiftShare.this.mostModelRunner = null;
                    if (SiftShare.this.runningAllSources) {
                        int numSources = SiftShare.this.sourceComboBox.getItemCount();
                        if (SiftShare.this.sourceComboBox.getSelectedIndex() + 1 == numSources) {
                            SiftShare.this.runningAllSources = false;
                        } else {
                            SiftShare.this.sourceComboBox.setSelectedIndex(SiftShare.this.sourceComboBox.getSelectedIndex() + 1);
                        }
                    }
                }
            });
        }

        @Override
        public void modelUpdate(final ModelEvent me) {
            CMIUtil.runOnDispatchThread(new Runnable(){

                @Override
                public void run() {
                    log.log(Level.FINE, "SiftShareModelListener.modelUpdate: {0}", me);
                    if (!me.getSourceModel().equals(SiftShare.this.getCurrentSite())) {
                        return;
                    }
                    SiftShareModelListener.this.modelLogUpdate(me);
                    if (me.getStatus() == 100) {
                        SiftShare.this.outputMessages.indeterminateProgressBar(me.getMessage());
                        SiftShare.this.addEESiteSources((SiteInfo)me.getSourceModel(), false);
                    } else {
                        SiftShare.this.outputMessages.updateProgressBar(me.getMessage(), me.getTimesteps(), me.getSourceModel().getNumberOutputTimesteps());
                    }
                    SiftShareModelListener.this.lastStatus = me.getStatus();
                }
            });
        }

        private void modelLogUpdate(ModelEvent me) {
            if (me.getLogText() != null) {
                SiftShare.this.modelLogTextArea.append(me.getLogText());
                SiftShare.this.modelLogTextArea.setCaretPosition(SiftShare.this.modelLogTextArea.getDocument().getLength());
            }
        }
    }
}

