/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class SimpleFileFilter
extends FileFilter {
    private String[] extensions;
    private String description;

    public SimpleFileFilter(String ext, String descr) {
        this(new String[]{ext}, descr);
    }

    public SimpleFileFilter(String ext) {
        this(new String[]{ext}, null);
    }

    public SimpleFileFilter(String[] exts, String descr) {
        this.extensions = new String[exts.length];
        for (int i = exts.length - 1; i >= 0; --i) {
            this.extensions[i] = exts[i].toLowerCase();
        }
        this.description = descr == null ? exts[0] + " files" : descr;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String name = f.getName().toLowerCase();
        for (int i = this.extensions.length - 1; i >= 0; --i) {
            if (!name.endsWith(this.extensions[i])) continue;
            return true;
        }
        return false;
    }

    public boolean hasExtension(String ext) {
        for (int i = 0; i < this.extensions.length; ++i) {
            if (!this.extensions[i].equals(ext)) continue;
            return true;
        }
        return false;
    }

    public String getExtension() {
        return this.getExtension(0);
    }

    public String getExtension(int index) {
        int idx = index;
        if (idx < 0 || idx >= this.extensions.length) {
            idx = 0;
        }
        return this.extensions[idx];
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String descr) {
        this.description = descr;
    }
}

