/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.pmel.util.Point2D;
import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.ModelInfo;
import gov.noaa.tsunami.cmi.OpenEventDialog;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.TSindex;
import gov.noaa.tsunami.cmi.TideGaugeClient;
import gov.noaa.tsunami.cmi.TideStationMetadata;
import gov.noaa.tsunami.websift.events.SeismicEvent;
import gov.noaa.tsunami.websift.propdb.Point3D;
import gov.noaa.tsunami.websift.propdb.SourceScenario;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;

public class SiteInfo
extends ModelInfo
implements Comparable<SiteInfo> {
    private static final Logger log = Logger.getLogger("gov.noaa.tsunami");
    public static final double DEFAULT_MINIMUM_AMPLITUDE = 0.005;
    public static final double DEFAULT_MINIMUM_DEPTH = 5.0;
    public static final double DEFAULT_DRY_LAND_DEPTH = 0.1;
    public static final double DEFAULT_FRICTION = 9.0E-4;
    public static final boolean DEFAULT_ALLOW_RUNUP = true;
    public static final double DEFAULT_MAX_ETA = 300.0;
    public static final int DEFAULT_TIMESTEPS_START = 0;
    public static final int DEFAULT_STRIDE = 1;
    public static final double DEFAULT_RUN_TIME = 28800.0;
    public static final double DEFAULT_OUTPUT_FREQUENCY = 30.0;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private String siteName;
    private final Map<Integer, String> bathyGridNames = new HashMap<Integer, String>(8);
    private final Map<Integer, BathyGrid> bathyGrids = new HashMap<Integer, BathyGrid>(8);
    private final Map<Integer, Point2D.Double> tsLocs = new HashMap<Integer, Point2D.Double>(8);
    private File siteDir;
    private Point3D location;
    private String sourceNamesAndSlips = null;
    private double maxAllowedTimestep = -1.0;
    private TideStationMetadata tsm = null;
    private LinkedHashMap<String, String> sources = new LinkedHashMap();
    private String activeSourceName = "";
    private double minimumAmplitude = 0.005;
    private double minimumDepth = 5.0;
    private double dryLandDepth = 0.1;
    private double friction = 9.0E-4;
    private boolean allowRunup = true;
    private double maxEta = 300.0;
    private double timeStep = -1.0;
    private int totalNumberTimeStep = -1;
    private int numberTimeStepsAGrid = -1;
    private int numberTimeStepsBGrid = -1;
    private int numberTimeStepsStart = 0;
    private int numberTimeStepsBetweenOutput = -1;
    private int numberStride = 1;
    private List<TSindex> tsIndices = null;
    public static final String MOST_PARAMETER_FILENAME = "most3_facts_nc.in";
    private SourceScenario sourceScenario = null;
    private HashMap<String, SourceScenario> sourceMap = new HashMap();
    private boolean writeParam = false;

    public SiteInfo(String sn, File dir) throws IOException {
        this.siteName = sn;
        this.siteDir = new File(dir, "");
        this.loadSettings(false);
    }

    public SiteInfo(File runDir) throws IOException {
        this(runDir.getName().replaceFirst("_run2d$", ""), runDir);
    }

    public SiteInfo(Path runDir) throws IOException {
        this(runDir.getFileName().toString().replaceFirst("_run2d$", ""), runDir.toFile());
    }

    public static SiteInfo createNewSite(String siteName, File parentDirectory, String[] gridNames) throws IOException {
        File pd;
        if (gridNames.length != 3) {
            throw new IllegalArgumentException("gridNames must contain exactly 3 grid names (for now)");
        }
        if (siteName.indexOf(32) >= 0) {
            throw new IOException("Model run names must not have spaces in them.");
        }
        File file = pd = parentDirectory != null ? parentDirectory : new File(CMIUtil.workingDirName);
        if (!pd.exists() && !pd.mkdir()) {
            throw new IOException("The parent directory could not be created:\n" + pd.getPath());
        }
        File runDirectory = new File(pd, siteName);
        if (runDirectory.exists()) {
            if (!runDirectory.isDirectory() || !runDirectory.canWrite() || runDirectory.list().length > 0) {
                throw new IOException("The new run directory " + runDirectory.getName() + " already exists.");
            }
        } else if (!runDirectory.mkdir()) {
            throw new IOException("The run directory " + runDirectory.getName() + " could not be created.");
        }
        for (int i = 0; i < gridNames.length; ++i) {
            File gridFile = new File(gridNames[i]);
            File copyGridFile = new File(runDirectory, gridFile.getName());
            CMIUtil.copyFile(gridFile, copyGridFile);
            gridNames[i] = copyGridFile.getPath();
        }
        SiteInfo newSite = new SiteInfo(siteName, runDirectory);
        newSite.setGridName(1, gridNames[0]);
        newSite.setGridName(2, gridNames[1]);
        newSite.setGridName(3, gridNames[2]);
        newSite.setDefaultParameters();
        return newSite;
    }

    public static SiteInfo copySite(SiteInfo origSite, File parentDir, String newSiteName) throws IOException {
        int[] grids = new int[]{1, 2, 3};
        File tmpdir = new File(parentDir, newSiteName);
        String[] gridNames = new String[]{origSite.getBathyGrid(1).getGridFile().getPath(), origSite.getBathyGrid(2).getGridFile().getPath(), origSite.getBathyGrid(3).getGridFile().getPath()};
        SiteInfo newSite = SiteInfo.createNewSite(newSiteName, parentDir, gridNames);
        newSite.setMinimumAmplitude(origSite.getMinimumAmplitude());
        newSite.setMinimumDepth(origSite.getMinimumDepth());
        newSite.setDryLandDepth(origSite.getDryLandDepth());
        newSite.setFriction(origSite.getFriction());
        newSite.setAllowRunup(origSite.isAllowRunup());
        newSite.setMaxEta(origSite.getMaxEta());
        newSite.setTimeStep(origSite.getTimeStep());
        newSite.setTotalNumberTimeStep(origSite.getTotalNumberTimeStep());
        newSite.setNumberTimeStepsAGrid(origSite.getNumberTimeStepsAGrid());
        newSite.setNumberTimeStepsBGrid(origSite.getNumberTimeStepsBGrid());
        newSite.setNumberTimeStepsStart(origSite.getNumberTimeStepsStart());
        newSite.setNumberTimeStepsBetweenOutput(origSite.getNumberTimeStepsBetweenOutput());
        newSite.setNumberStride(origSite.getNumberStride());
        for (int g : grids) {
            Point2D.Double pt = origSite.getTimeseriesLocation(g);
            newSite.setTimeseriesLocation(g, pt.x, pt.y);
        }
        return newSite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void renameSite(String newSiteName) throws IOException {
        if (newSiteName == null || newSiteName.indexOf(" ") != -1) {
            throw new IOException("Can't create a Model Site of null or spaces in filename (MOST still cant handle this): " + newSiteName);
        }
        File f = new File(CMIUtil.workingDirName, newSiteName);
        if (f.exists()) {
            throw new IOException("Can't use site name, folder exists with that name: " + newSiteName);
        }
        if (!f.mkdir()) throw new IOException("Can't make folder with site name: " + newSiteName);
        String oldName = this.siteName;
        if (!this.siteDir.renameTo(f)) throw new IOException("Can't move folder");
        this.siteDir = f;
        this.siteName = newSiteName;
        for (String sname : this.getSourceNames()) {
            for (File fi : this.siteDir.listFiles(new CMIUtil.MostFileFilter(sname))) {
                File frn = new File(fi.getPath().replaceAll(oldName, this.siteName));
                fi.renameTo(frn);
            }
            File ofile = new File(this.siteDir, "output_" + oldName + "_" + sname + ".lis");
            ofile.renameTo(new File(ofile.getPath().replaceAll(oldName, this.siteName)));
        }
    }

    public ArrayList<TideStationMetadata> getTideStationMetadata() {
        BathyGrid g = null;
        try {
            g = this.getBathyGrid(3);
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.SEVERE, "Error loading tide gauge metadata: SiteInfo has no C-grid", ex);
            return new ArrayList<TideStationMetadata>();
        }
        return TideGaugeClient.getStationMetadata(g);
    }

    public void setSourceScenario(SourceScenario ss) {
        SourceScenario prev = this.sourceScenario;
        this.sourceScenario = ss;
        String string = this.sourceNamesAndSlips = ss == null ? null : ss.getSourceNamesAndSlips();
        if (ss == null) {
            this.sourceMap.remove(this.activeSourceName);
        } else {
            this.sourceMap.put(this.activeSourceName, ss);
        }
        SiftShare.log.info("firing prop change: sourceScenario");
        this.firePropertyChange("sourceScenario", prev, this.sourceScenario);
        this.writeModelInfoFile();
    }

    public SourceScenario getSourceScenario() {
        return this.sourceScenario;
    }

    public Point3D getLocation() {
        return this.location;
    }

    public Rectangle2D.Double getAGridRegion() {
        Point2D.Double[] aGridBox;
        try {
            aGridBox = this.getBathyGrid(1).getGridBox();
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "can't get region", ex);
            return null;
        }
        this.location = new Point3D((aGridBox[0].x + aGridBox[2].x) / 2.0, (aGridBox[0].y + aGridBox[2].y) / 2.0, 0.0);
        double width = aGridBox[1].x - aGridBox[0].x;
        double height = aGridBox[3].y - aGridBox[0].y;
        double pc = 0.1;
        return new Rectangle2D.Double(aGridBox[0].x - 0.1 * width, aGridBox[0].y - 0.1 * height, width * 1.2, height * 1.2);
    }

    public void setSourceNamesAndSlips(String sc) {
        if (!(sc = SourceScenario.parseSNAS(sc)).equals(this.sourceNamesAndSlips)) {
            SiftShare.log.fine("setting snas to: " + sc);
            this.sourceNamesAndSlips = sc;
            this.sources.put(this.activeSourceName, this.sourceNamesAndSlips);
            this.writeModelInfoFile();
        }
    }

    public String getSourceNamesAndSlips() {
        return this.sourceNamesAndSlips != null ? this.sourceNamesAndSlips : "";
    }

    @Override
    public String getName() {
        return this.siteName;
    }

    public void setGridName(int gridIdent, String name) {
        File f;
        boolean doRewrite = false;
        if (this.bathyGridNames.containsKey(gridIdent) && !name.equals(this.bathyGridNames.get(gridIdent))) {
            this.bathyGrids.remove(gridIdent);
            doRewrite = true;
        }
        if (!(f = new File(name)).isAbsolute()) {
            f = new File(this.getSiteDirectory(), name);
        }
        try {
            this.bathyGridNames.put(gridIdent, CMIUtil.getRelativePath(this.getSiteDirectory(), f));
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, f.getPath(), ex);
        }
        if (doRewrite && this.bathyGridNames.size() >= 3) {
            this.writeInputFile();
            this.deleteRestart();
            this.firePropertyChange("mostParamChanged", 0, 1);
        }
    }

    public String getGridName(int gridIdent) {
        return this.bathyGridNames.get(gridIdent);
    }

    public void setBathyGrid(int gridIdentifier, BathyGrid grd) {
        if (grd != null) {
            BathyGrid oldValue = this.bathyGrids.get(gridIdentifier);
            this.bathyGrids.put(gridIdentifier, grd);
            try {
                this.bathyGridNames.put(gridIdentifier, CMIUtil.getRelativePath(this.siteDir, grd.getGridFile()));
            }
            catch (IOException ex) {
                SiftShare.log.log(Level.SEVERE, grd.getGridFile().getPath(), ex);
            }
            this.firePropertyChange("bathyGrid", oldValue, grd);
        } else {
            this.bathyGrids.remove(gridIdentifier);
        }
        this.maxAllowedTimestep = -1.0;
        this.writeInputFile();
        this.deleteRestart();
    }

    public BathyGrid getBathyGrid(int gridIdentifier) throws IOException {
        BathyGrid g = this.bathyGrids.get(gridIdentifier);
        if (g == null) {
            String gName = this.getGridName(gridIdentifier);
            if (gName == null) {
                throw new IOException("can't find gridName");
            }
            File f = new File(this.siteDir, gName);
            if (f != null) {
                g = new BathyGrid(f, false);
                this.bathyGrids.put(gridIdentifier, g);
            }
        }
        return g;
    }

    public void clearLoadedBathymetryGrids() {
        this.bathyGrids.clear();
    }

    public String getDirName() {
        return this.siteDir.getPath();
    }

    public File getSiteDirectory() {
        return this.siteDir;
    }

    public String addSource(String inv) {
        int i = 1;
        String name = String.format("source%03d", i);
        while (this.sources.keySet().contains(name)) {
            name = String.format("source%03d", ++i);
        }
        if (inv.equals("")) {
            this.sources.put(name, " ");
        } else {
            this.sources.put(name, inv);
        }
        this.sourceNamesAndSlips = inv;
        this.sourceScenario = null;
        this.writeModelInfoFile();
        return name;
    }

    public void removeSource(String sname) {
        SiftShare.log.info("Removing source: " + sname);
        this.sources.remove(sname);
        this.sourceMap.remove(sname);
        this.writeModelInfoFile();
    }

    public String setSource(String sname) {
        String snas = this.sources.get(sname);
        this.sourceNamesAndSlips = snas == null || snas.equals(" ") ? "" : snas;
        this.activeSourceName = sname;
        this.sourceScenario = this.sourceMap.get(sname);
        this.writeModelInfoFile();
        return this.sourceNamesAndSlips;
    }

    public Set<String> getSourceNames() {
        return this.sources.keySet();
    }

    public String getActiveSourceName() {
        return this.activeSourceName;
    }

    public SourceScenario getSourceScenario(String sname) {
        return this.sourceMap.get(sname);
    }

    public String getSourceAndSlip(String sname) {
        String snas = this.sources.get(sname);
        if (snas == null || snas.equals(" ")) {
            return "";
        }
        return snas;
    }

    public String getFullLincoFilename() {
        return this.getSiteDirectory() + File.separator + "linCo_" + this.getActiveSourceName() + "h.nc";
    }

    public String getFullLincoMaxFilename() {
        return this.getSiteDirectory() + File.separator + "linCo_" + this.getActiveSourceName() + "h_max.nc";
    }

    public final boolean loadSettings(boolean cleanFile) throws IOException {
        boolean parseError = true;
        File fn = new File(this.getSiteDirectory(), "model_info.xml");
        if (fn.exists()) {
            this.readModelInfoFile();
        } else {
            fn = new File(this.getSiteDirectory(), "README.txt");
            if (fn.exists()) {
                this.loadReadmeFile(fn);
                this.writeModelInfoFile();
            } else {
                this.activeSourceName = this.addSource("");
            }
        }
        if (this.sourceNamesAndSlips == null || this.sourceNamesAndSlips.equals("")) {
            this.parseInversion();
        }
        fn = new File(this.getSiteDirectory(), MOST_PARAMETER_FILENAME);
        if (!this.getSiteDirectory().isDirectory() || !this.getSiteDirectory().canRead()) {
            throw new IOException("Site directory " + this.getSiteDirectory().getPath() + " does not exist or cannot be read");
        }
        if (fn.exists()) {
            this.loadMostParameterFile(fn);
        }
        if (cleanFile) {
            this.writeInputFile();
            this.writeModelInfoFile();
        }
        return parseError;
    }

    private void parseInversion() {
        File linFile = new File(this.getFullLincoFilename());
        File outFile = this.getSiftOutputFile();
        if (linFile.exists() && outFile.exists()) {
            try {
                NetcdfFile nc = NetcdfFile.open(linFile.getPath());
                Attribute att = nc.findGlobalAttribute("inversion");
                if (att != null) {
                    NetcdfFile nco = NetcdfFile.open(outFile.getPath());
                    Attribute atto = nco.findGlobalAttribute("inversion");
                    if (atto != null && att.getStringValue().equals(atto.getStringValue())) {
                        SiftShare.log.info("linCoh.nc inv: " + att.getStringValue() + "\nsift.nc inv: " + atto.getStringValue());
                        this.setSourceNamesAndSlips(att.getStringValue());
                    } else {
                        SiftShare.log.info("linCoh.nc inv: " + att.getStringValue() + "\nsift.nc inv: not found");
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void loadReadmeFile(File fn) throws IOException {
        File f2;
        String inputLine;
        Pattern tsPattern = Pattern.compile("(.+)Grid Timeseries (Longitude|Latitude)");
        FileReader fr = new FileReader(fn);
        BufferedReader br = new BufferedReader(fr);
        String sdinv = "";
        String sdusr = "";
        String sdtit = "";
        String sid = "-1";
        boolean isProject = false;
        SiftShare.log.fine("Reading README.txt file for site: " + this.getName());
        while ((inputLine = br.readLine()) != null) {
            if ((inputLine = inputLine.trim()).charAt(0) == '#' || inputLine.indexOf(61) < 0) continue;
            String[] tokens = inputLine.split(" *= *", 2);
            Matcher tsMatches = tsPattern.matcher(tokens[0]);
            if (tsMatches.matches()) {
                double v;
                int gr = BathyGrid.parseGridIdentifier(tsMatches.group(1));
                Point2D.Double pt = this.tsLocs.get(gr);
                try {
                    v = Double.parseDouble(tokens[1]);
                }
                catch (NumberFormatException ex) {
                    pt = null;
                    this.tsLocs.put(gr, pt);
                    continue;
                }
                if (pt == null) {
                    pt = new Point2D.Double();
                }
                if (tsMatches.group(2).equalsIgnoreCase("Longitude")) {
                    pt.x = v;
                } else {
                    pt.y = v;
                }
                this.tsLocs.put(gr, pt);
                continue;
            }
            if (tokens[0].equalsIgnoreCase("Initial Condition")) {
                this.sourceNamesAndSlips = tokens[1];
                SiftShare.log.fine("snas:" + this.sourceNamesAndSlips + ":");
                continue;
            }
            if (tokens[0].equalsIgnoreCase("Maximum Timestep")) {
                try {
                    this.maxAllowedTimestep = Double.parseDouble(tokens[1]);
                }
                catch (NumberFormatException nfe) {
                    this.maxAllowedTimestep = -1.0;
                }
                continue;
            }
            if (tokens[0].equalsIgnoreCase("Scenario ID")) {
                sid = tokens[1].trim();
                continue;
            }
            if (tokens[0].equalsIgnoreCase("Scenario Type")) {
                isProject = tokens[1].equalsIgnoreCase("project");
                continue;
            }
            if (!tokens[0].equalsIgnoreCase("Source")) continue;
        }
        br.close();
        fr.close();
        this.activeSourceName = this.addSource(this.getSourceNamesAndSlips());
        this.sourceScenario = this.findSourceScenario(sid);
        if (this.sourceScenario != null) {
            this.sourceMap.put(this.activeSourceName, this.sourceScenario);
        }
        for (File f : this.getSiteDirectory().listFiles(new CMIUtil.MostFileFilter(""))) {
            String fname = f.getName().replaceAll(this.siteName, this.siteName + "_source001");
            f2 = new File(this.siteDir, fname);
            f.renameTo(f2);
        }
        for (File f : this.siteDir.listFiles((d, s) -> s.startsWith("linCo"))) {
            String fname = f.getName().replaceAll("linCo", "linCo_source001");
            f2 = new File(this.siteDir, fname);
            f.renameTo(f2);
        }
    }

    private SourceScenario findSourceScenario(String sid) {
        SiftShare.log.info("event id: |" + sid + "|");
        SourceScenario ret = null;
        try {
            if (!sid.equals("-1")) {
                for (int count = 0; count < 10 && !OpenEventDialog.doneParsing; ++count) {
                    Thread.sleep(1000L);
                }
                block3: for (SeismicEvent se : OpenEventDialog.quakeEvents) {
                    for (SourceScenario ss : se.getScenarioList()) {
                        if (!ss.getID().equals(sid)) continue;
                        SiftShare.log.info("Found match: " + ss.getID());
                        ret = ss;
                        continue block3;
                    }
                }
            }
        }
        catch (InterruptedException | NullPointerException npe) {
            log.log(Level.WARNING, "Error getting event SourceScenario", npe);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMostParameterFile(File fn) throws IOException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(fn));
            this.minimumAmplitude = Double.parseDouble(br.readLine().split("\\s+")[0]);
            this.minimumDepth = Double.parseDouble(br.readLine().split("\\s+")[0]);
            this.dryLandDepth = Double.parseDouble(br.readLine().split("\\s+")[0]);
            this.friction = Double.parseDouble(br.readLine().split("\\s+")[0]);
            this.allowRunup = br.readLine().split("\\s+")[0].equals("1");
            this.maxEta = Double.parseDouble(br.readLine().split("\\s+")[0]);
            this.timeStep = Double.parseDouble(br.readLine().split("\\s+")[0]);
            this.totalNumberTimeStep = Integer.parseInt(br.readLine().split("\\s+")[0]);
            this.numberTimeStepsAGrid = Integer.parseInt(br.readLine().split("\\s+")[0]);
            this.numberTimeStepsBGrid = Integer.parseInt(br.readLine().split("\\s+")[0]);
            this.numberTimeStepsBetweenOutput = Integer.parseInt(br.readLine().split("\\s+")[0]);
            this.numberTimeStepsStart = Integer.parseInt(br.readLine().split("\\s+")[0]);
            this.numberStride = Integer.parseInt(br.readLine().split("\\s+")[0]);
            this.setGridName(1, this.findGrid(br.readLine()).trim());
            this.setGridName(2, this.findGrid(br.readLine()).trim());
            this.setGridName(3, this.findGrid(br.readLine()).trim());
        }
        catch (NumberFormatException e) {
            throw new IOException("Error parsing number in MOST parameter file: " + e.getMessage());
        }
        catch (NullPointerException e) {
            throw new IOException("Premature end of file reached in MOST parameter file (NPE)");
        }
        this.tsIndices = null;
        String s = "";
        try {
            br.readLine();
            br.readLine();
            br.readLine();
            int tsCount = Integer.parseInt(br.readLine().split("\\s+")[0]);
            SiftShare.log.log(Level.INFO, "Found index timeseries points in most.in file: " + tsCount);
            if (tsCount > 0) {
                this.tsIndices = new ArrayList<TSindex>(tsCount);
                for (int i = 0; i < tsCount && (s = br.readLine()) != null; ++i) {
                    String[] sarr = s.split("\\s+");
                    String comment = "";
                    if (sarr.length < 3) continue;
                    int commentidx = s.indexOf(sarr[2]);
                    if (commentidx > 0 && commentidx < s.length()) {
                        comment = s.substring(commentidx + sarr[2].length());
                    }
                    TSindex tsi = new TSindex(sarr[0], sarr[1], sarr[2], comment.trim());
                    SiftShare.log.log(Level.INFO, "ts point: " + tsi);
                    this.tsIndices.add(tsi);
                    this.tsLocs.put(tsi.getGridID(), new Point2D.Double(0.0, 0.0));
                    BathyGrid bg = this.getBathyGrid(tsi.getGridID());
                    double[] yarr = bg.getYArray();
                    this.setTimeseriesLocation(tsi.getGridID(), bg.getXArray()[tsi.getXIndex() - 1], yarr[yarr.length - tsi.getYIndex()]);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            SiftShare.log.log(Level.WARNING, "couldn't parse timeseries index from line: " + s);
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        if (this.writeParam) {
            this.writeInputFile();
        }
    }

    private String findGrid(String g) throws IOException {
        File gridFile = new File(this.getSiteDirectory(), g.trim());
        if (!gridFile.exists()) {
            SiftShare.log.fine("found bathy grids listed as <site>_run2d, changing most3_facts_nc.in file");
            String[] junk = g.split("/");
            if (junk.length == 1) {
                g = "./" + junk[0];
            } else if (junk.length == 2) {
                g = "./" + junk[1];
            }
            gridFile = new File(this.getSiteDirectory(), g);
            if (!gridFile.exists()) {
                throw new IOException(String.format("Grid file %s missing for model run %s.", gridFile.getPath(), this.getName()));
            }
            this.writeParam = true;
        }
        return g;
    }

    private void deleteRestart() {
        File rf = this.getRestartFile();
        if (rf != null) {
            rf.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInputFile() {
        if (!this.getSiteDirectory().isDirectory()) {
            return;
        }
        OutputStreamWriter fw = null;
        try {
            int numberTimeseriesLocations;
            fw = new FileWriter(new File(this.getSiteDirectory(), MOST_PARAMETER_FILENAME), false);
            fw.write(this.getMinimumAmplitude() + "\tMinimum amp. of input offshore wave (m)\n");
            fw.write(this.getMinimumDepth() + "\tMinimum depth of offshore (m)\n");
            fw.write(this.getDryLandDepth() + "\tDry land depth of inundation (m)\n");
            fw.write(String.format("%.5f\tFriction coefficient (n**2)\n", this.getFriction()));
            fw.write((this.isAllowRunup() ? "1" : "0") + "\tLet A-Grid and B-Grid run up\n");
            fw.write(this.getMaxEta() + "\tMax eta before blow-up (m)\n");
            fw.write(this.getTimeStep() + "\tTime step (sec)\n");
            fw.write(this.getTotalNumberTimeStep() + "\tTotal number of time steps in run\n");
            fw.write(this.getNumberTimeStepsAGrid() + "\tTime steps between A-Grid computations\n");
            fw.write(this.getNumberTimeStepsBGrid() + "\tTime steps between B-Grid computations\n");
            fw.write(this.getNumberTimeStepsBetweenOutput() + "\tTime steps between output steps\n");
            fw.write(this.getNumberTimeStepsStart() + "\tTime steps before saving first output step\n");
            fw.write(this.getNumberStride() + "\tSave output every n-th grid point\n");
            fw.write(this.getGridName(1) + "\n");
            fw.write(this.getGridName(2) + "\n");
            fw.write(this.getGridName(3) + "\n");
            fw.write("./\n");
            fw.write("./\n");
            fw.write("1 1 1 1\n");
            int n = numberTimeseriesLocations = this.tsIndices != null ? this.tsIndices.size() : 0;
            if (numberTimeseriesLocations > 0) {
                fw.write(numberTimeseriesLocations + "               Timeseries locations:\n");
                for (TSindex ts : this.tsIndices) {
                    fw.write(ts.toString());
                }
            }
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.WARNING, "error", ex);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void readModelInfoFile() {
        this.tsLocs.put(1, null);
        this.tsLocs.put(2, null);
        this.tsLocs.put(3, null);
        this.sources.clear();
        this.maxAllowedTimestep = -1.0;
        String sid = "-1";
        try {
            SAXParserFactory fac = SAXParserFactory.newInstance();
            SAXParser parser = fac.newSAXParser();
            DefaultHandler handler = new DefaultHandler(){
                String character_buf;
                Double lat = null;
                Double lon = null;
                int grid = -1;
                String sname = "";

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
                    this.character_buf = "";
                    if (qName.equals("agridts")) {
                        this.lon = null;
                        this.lat = null;
                        this.grid = 1;
                    }
                    if (qName.equals("bgridts")) {
                        this.lon = null;
                        this.lat = null;
                        this.grid = 2;
                    }
                    if (qName.equals("cgridts")) {
                        this.lon = null;
                        this.lat = null;
                        this.grid = 3;
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (qName.equals("longitude") && this.character_buf.length() > 0) {
                        this.lon = new Double(this.character_buf);
                    }
                    if (qName.equals("latitude") && this.character_buf.length() > 0) {
                        this.lat = new Double(this.character_buf);
                        SiteInfo.this.tsLocs.put(this.grid, new Point2D.Double(this.lon, this.lat));
                    }
                    if (qName.equals("maxts") && this.character_buf.length() > 0) {
                        SiteInfo.this.maxAllowedTimestep = new Double(this.character_buf);
                    }
                    if (qName.equals("name") && this.character_buf.length() > 0) {
                        this.sname = this.character_buf;
                        if (this.sname.chars().filter(Character::isDigit).count() < 3L) {
                            this.sname = "source0" + this.sname.substring(6, 8);
                        }
                    }
                    if (qName.equals("inv")) {
                        if (this.character_buf.length() > 0) {
                            SiteInfo.this.sources.put(this.sname, this.character_buf);
                        } else {
                            SiteInfo.this.sources.put(this.sname, " ");
                        }
                    }
                    if (qName.equals("eventID") && this.character_buf.length() > 0) {
                        SourceScenario ss = SiteInfo.this.findSourceScenario(this.character_buf);
                        if (ss == null) {
                            SiftShare.log.warning("Can't find event ID: " + this.character_buf + " for this source: " + this.sname);
                        }
                        SiteInfo.this.sourceMap.put(this.sname, ss);
                    }
                    if (qName.equals("active") && this.character_buf.length() > 0) {
                        SiteInfo.this.activeSourceName = this.character_buf;
                        if (SiteInfo.this.activeSourceName.chars().filter(Character::isDigit).count() < 3L) {
                            SiteInfo.this.activeSourceName = "source0" + SiteInfo.this.activeSourceName.substring(6, 8);
                        }
                    }
                    this.character_buf = "";
                }

                @Override
                public void characters(char[] chars, int start, int length) throws SAXException {
                    this.character_buf = this.character_buf + String.copyValueOf(chars, start, length);
                }
            };
            parser.parse(new File(this.getSiteDirectory(), "model_info.xml"), handler);
            this.setSource(this.activeSourceName);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            SiftShare.log.log(Level.SEVERE, "Error parsing model_info.xml", e);
        }
    }

    private void writeModelInfoFile() {
        SiftShare.log.info("Writing model_info.xml file for site: " + this.getName());
        if (this.sources.isEmpty()) {
            this.setSource("");
        }
        try (FileWriter fw = new FileWriter(new File(this.getSiteDirectory(), "model_info.xml"));){
            fw.write("<?xml version=\"1.0\"?>\n");
            fw.write("<model>\n");
            fw.write("  <sources>\n");
            if (this.activeSourceName.equals("")) {
                fw.write("    <active>source001</active>\n");
            } else {
                fw.write("    <active>" + this.activeSourceName + "</active>\n");
            }
            TreeMap<String, String> sorted = new TreeMap<String, String>(this.sources);
            for (Map.Entry<String, String> pair : sorted.entrySet()) {
                if (pair.getKey().equals("")) continue;
                fw.write("    <source>\n");
                fw.write("      <name>" + pair.getKey() + "</name>\n");
                fw.write("      <inv>" + pair.getValue() + "</inv>\n");
                SourceScenario ss = this.sourceMap.get(pair.getKey());
                if (ss != null) {
                    fw.write("      <eventID>" + ss.getID() + "</eventID>\n");
                }
                fw.write("    </source>\n");
            }
            fw.write("  </sources>\n");
            fw.write("  <agridts>\n");
            Point2D.Double pt = this.tsLocs.get(1);
            String lon = "";
            String lat = "";
            if (pt != null) {
                lon = String.format("%2.8f", pt.x);
                lat = String.format("%2.8f", pt.y);
            }
            fw.write("    <longitude>" + lon + "</longitude>\n");
            fw.write("    <latitude>" + lat + "</latitude>\n");
            fw.write("  </agridts>\n");
            fw.write("  <bgridts>\n");
            pt = this.tsLocs.get(2);
            lon = "";
            lat = "";
            if (pt != null) {
                lon = String.format("%2.8f", pt.x);
                lat = String.format("%2.8f", pt.y);
            }
            fw.write("    <longitude>" + lon + "</longitude>\n");
            fw.write("    <latitude>" + lat + "</latitude>\n");
            fw.write("  </bgridts>\n");
            fw.write("  <cgridts>\n");
            pt = this.tsLocs.get(3);
            lon = "";
            lat = "";
            if (pt != null) {
                lon = String.format("%2.8f", pt.x);
                lat = String.format("%2.8f", pt.y);
            }
            fw.write("    <longitude>" + lon + "</longitude>\n");
            fw.write("    <latitude>" + lat + "</latitude>\n");
            fw.write("  </cgridts>\n");
            lon = "";
            if (this.maxAllowedTimestep > 0.0) {
                lon = String.format("%2.3f", this.maxAllowedTimestep);
            }
            fw.write("  <maxts>" + lon + "</maxts>\n");
            fw.write("</model>\n");
        }
        catch (IOException ioe) {
            SiftShare.log.log(Level.SEVERE, "Can't write model_info.xml file", ioe);
        }
    }

    public void exportSourcesXMLFile(File f) {
        SiftShare.log.info("Writing export xml file of Sources for site: " + this.getName());
        if (this.sources.isEmpty()) {
            this.setSource("");
        }
        try (FileWriter fw = new FileWriter(f);){
            fw.write("<?xml version=\"1.0\"?>\n");
            fw.write("  <sources>\n");
            TreeMap<String, String> sorted = new TreeMap<String, String>(this.sources);
            for (Map.Entry<String, String> pair : sorted.entrySet()) {
                if (pair.getKey().equals("")) continue;
                fw.write("    <source>\n");
                fw.write("      <name>" + pair.getKey() + "</name>\n");
                fw.write("      <inv>" + pair.getValue() + "</inv>\n");
                SourceScenario ss = this.sourceMap.get(pair.getKey());
                if (ss != null) {
                    fw.write("      <eventID>" + ss.getID() + "</eventID>\n");
                }
                fw.write("    </source>\n");
            }
            fw.write("  </sources>\n");
        }
        catch (IOException ioe) {
            SiftShare.log.log(Level.SEVERE, "Can't write Sources xml export file", ioe);
        }
    }

    public void importSourcesXMLFile(File f) throws Exception {
        SiftShare.log.info("Importing XML file of Sources to add to this Site: " + this.getName());
        try {
            SAXParserFactory fac = SAXParserFactory.newInstance();
            SAXParser parser = fac.newSAXParser();
            DefaultHandler handler = new DefaultHandler(){
                String character_buf;
                String sname = "";

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
                    this.character_buf = "";
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (qName.equals("name") && this.character_buf.length() > 0) {
                        this.sname = this.character_buf;
                    }
                    if (qName.equals("inv") && this.character_buf.length() > 0) {
                        this.sname = SiteInfo.this.addSource(this.character_buf);
                    }
                    if (qName.equals("eventID") && this.character_buf.length() > 0) {
                        SourceScenario ss = SiteInfo.this.findSourceScenario(this.character_buf);
                        if (ss == null) {
                            SiftShare.log.warning("Can't find event ID: " + this.character_buf + " for this source: " + this.sname);
                        }
                        SiteInfo.this.sourceMap.put(this.sname, ss);
                    }
                }

                @Override
                public void characters(char[] chars, int start, int length) throws SAXException {
                    this.character_buf = this.character_buf + String.copyValueOf(chars, start, length);
                }
            };
            parser.parse(f, handler);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            SiftShare.log.log(Level.WARNING, "Error parsing source import xml file", e);
            throw e;
        }
    }

    public double getMaxTimeStep() {
        return this.getMaxTimeStep(null);
    }

    public double getMaxTimeStep(StringBuffer sb) {
        double maxDT = Double.MAX_VALUE;
        if (sb == null) {
            if (this.maxAllowedTimestep > 0.0) {
                return this.maxAllowedTimestep;
            }
            sb = new StringBuffer("");
        }
        ArrayList<Integer> ga = new ArrayList<Integer>(this.bathyGridNames.keySet());
        Collections.sort(ga);
        for (int gridIdent : ga) {
            sb.append(String.format(" %s-Grid\n", BathyGrid.getGridLetter(gridIdent)));
            try {
                double deltaT = this.getBathyGrid(gridIdent).getMaxTimeStep(sb);
                maxDT = deltaT < maxDT ? deltaT : maxDT;
            }
            catch (IOException e) {
                sb.append(String.format("IO error loading %s\n", this.bathyGridNames.get(gridIdent)));
            }
        }
        this.maxAllowedTimestep = (double)((int)(maxDT * 100.0)) / 100.0;
        this.writeModelInfoFile();
        return this.maxAllowedTimestep;
    }

    public double getModelTimeExtent() {
        return (double)(this.getNumberOutputTimesteps() * this.getNumberTimeStepsBetweenOutput()) * this.getTimeStep() / 3600.0;
    }

    public boolean isOutputAvailable() {
        return this.getOutputFile(3).exists();
    }

    public File getSiftOutputFile() {
        return new File(this.siteDir, this.siteName + "_" + this.activeSourceName + "_sift.nc");
    }

    public File getOutputFile(int gridIdentifier) {
        return this.getOutputFile(gridIdentifier, "ha");
    }

    public File getOutputFile(int gridIdentifier, String modelvar) {
        String g = BathyGrid.getGridLetter(gridIdentifier).toUpperCase();
        if (g.equals("C")) {
            g = "";
        }
        return new File(this.siteDir, this.siteName + "_" + this.activeSourceName + "_runup" + g + "_" + modelvar + ".nc");
    }

    public File getRestartFile() {
        File rf = new File(this.siteDir, this.siteName + "_" + this.activeSourceName + "_restart.nc");
        return rf.isFile() && rf.canRead() ? rf : null;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof SiteInfo)) {
            return false;
        }
        return this.getSiteDirectory().equals(((SiteInfo)that).getSiteDirectory());
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.siteDir != null ? this.siteDir.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.getName();
    }

    public double getMinimumAmplitude() {
        return this.minimumAmplitude;
    }

    public void setMinimumAmplitude(double minimumAmplitude) {
        if (minimumAmplitude != this.minimumAmplitude) {
            this.minimumAmplitude = minimumAmplitude;
            this.writeInputFile();
            this.deleteRestart();
            this.firePropertyChange("mostParamChanged", 0, 1);
        }
    }

    public double getMinimumDepth() {
        return this.minimumDepth;
    }

    public void setMinimumDepth(double minimumDepth) {
        if (minimumDepth != this.minimumDepth) {
            this.minimumDepth = minimumDepth;
            this.writeInputFile();
            this.deleteRestart();
            this.firePropertyChange("mostParamChanged", 0, 1);
        }
    }

    public double getDryLandDepth() {
        return this.dryLandDepth;
    }

    public void setDryLandDepth(double dryLandDepth) {
        if (dryLandDepth != this.dryLandDepth) {
            this.dryLandDepth = dryLandDepth;
            this.writeInputFile();
            this.deleteRestart();
            this.firePropertyChange("mostParamChanged", 0, 1);
        }
    }

    public double getFriction() {
        return this.friction;
    }

    public void setFriction(double friction) {
        if (friction != this.friction) {
            this.friction = friction;
            this.writeInputFile();
            this.deleteRestart();
            this.firePropertyChange("mostParamChanged", 0, 1);
        }
    }

    public boolean isAllowRunup() {
        return this.allowRunup;
    }

    public void setAllowRunup(boolean allowRunup) {
        if (allowRunup != this.allowRunup) {
            this.allowRunup = allowRunup;
            this.writeInputFile();
            this.deleteRestart();
        }
    }

    public double getMaxEta() {
        return this.maxEta;
    }

    public void setMaxEta(double maxEta) {
        if (maxEta != this.maxEta) {
            this.maxEta = maxEta;
            this.writeInputFile();
            this.firePropertyChange("mostParamChanged", 0, 1);
        }
    }

    public double getTimeStep() {
        return this.timeStep;
    }

    public void setTimeStep(double timeStep) {
        if (timeStep != this.timeStep) {
            this.timeStep = timeStep;
            this.writeInputFile();
            this.deleteRestart();
            this.firePropertyChange("mostParamChanged", 0, 1);
        }
    }

    public int getTotalNumberTimeStep() {
        return this.totalNumberTimeStep;
    }

    public void setTotalNumberTimeStep(int totalNumberTimeStep) {
        if (totalNumberTimeStep != this.totalNumberTimeStep) {
            int v = this.getNumberOutputTimesteps();
            this.totalNumberTimeStep = totalNumberTimeStep;
            this.writeInputFile();
            this.firePropertyChange("numberOutputTimesteps", v, this.getNumberOutputTimesteps());
        }
    }

    public int getNumberTimeStepsAGrid() {
        return this.numberTimeStepsAGrid;
    }

    public void setNumberTimeStepsAGrid(int numberTimeStepsAGrid) {
        if (numberTimeStepsAGrid != this.numberTimeStepsAGrid) {
            this.numberTimeStepsAGrid = numberTimeStepsAGrid;
            this.writeInputFile();
            this.deleteRestart();
            this.firePropertyChange("mostParamChanged", 0, 1);
        }
    }

    public int getNumberTimeStepsBGrid() {
        return this.numberTimeStepsBGrid;
    }

    public void setNumberTimeStepsBGrid(int numberTimeStepsBGrid) {
        if (numberTimeStepsBGrid != this.numberTimeStepsBGrid) {
            this.numberTimeStepsBGrid = numberTimeStepsBGrid;
            this.writeInputFile();
            this.deleteRestart();
            this.firePropertyChange("mostParamChanged", 0, 1);
        }
    }

    public int getNumberTimeStepsStart() {
        return this.numberTimeStepsStart;
    }

    public void setNumberTimeStepsStart(int numberTimeStepsStart) {
        if (numberTimeStepsStart != this.numberTimeStepsStart) {
            this.numberTimeStepsStart = numberTimeStepsStart;
            this.writeInputFile();
            this.deleteRestart();
            this.firePropertyChange("mostParamChanged", 0, 1);
        }
    }

    @Override
    public int getNumberOutputTimesteps() {
        int t = this.getNumberTimeStepsBetweenOutput();
        if (t <= 0) {
            return 0;
        }
        int icnt = 0;
        int nstart = this.getNumberTimeStepsStart();
        for (int nstep = 1; nstep <= this.getTotalNumberTimeStep(); ++nstep) {
            if ((nstep - nstart) / t * t != nstep - nstart) continue;
            ++icnt;
        }
        return icnt;
    }

    public double getOutputTimestep() {
        return this.timeStep * (double)this.numberTimeStepsBetweenOutput;
    }

    public int getNumberTimeStepsBetweenOutput() {
        return this.numberTimeStepsBetweenOutput;
    }

    public void setNumberTimeStepsBetweenOutput(int numberTimeStepsBetweenOutput) {
        if (numberTimeStepsBetweenOutput != this.numberTimeStepsBetweenOutput) {
            int v = this.getNumberOutputTimesteps();
            this.numberTimeStepsBetweenOutput = numberTimeStepsBetweenOutput;
            this.writeInputFile();
            this.deleteRestart();
            this.firePropertyChange("numberOutputTimesteps", v, this.getNumberOutputTimesteps());
        }
    }

    public int getNumberStride() {
        return this.numberStride;
    }

    public void setNumberStride(int numberStride) {
        if (numberStride != this.numberStride) {
            this.numberStride = numberStride;
            this.writeInputFile();
            this.deleteRestart();
            this.firePropertyChange("mostParamChanged", 0, 1);
        }
    }

    public boolean setTimeseriesLocation(int gridIdentifier, double x, double y) {
        boolean inside = true;
        Point2D.Double ptorig = this.tsLocs.get(gridIdentifier);
        Point2D.Double pt = new Point2D.Double(x, y);
        if (ptorig == null) {
            ptorig = pt;
            return true;
        }
        if (!pt.equals(ptorig)) {
            try {
                BathyGrid bg = this.getBathyGrid(gridIdentifier);
                if (bg.contains(pt.x, pt.y)) {
                    this.tsLocs.put(gridIdentifier, new Point2D.Double(x, y));
                    this.writeModelInfoFile();
                    inside = true;
                } else {
                    inside = false;
                }
            }
            catch (IOException ignore) {
                return false;
            }
        }
        return inside;
    }

    public Point2D.Double getTimeseriesLocation(int gridIdentifier) {
        Point2D.Double p = this.tsLocs.get(gridIdentifier);
        if (p == null) {
            SiftShare.log.fine("null ts location, setting to center of grid");
            try {
                Point2D.Double[] gridBox = this.getBathyGrid(gridIdentifier).getGridBox();
                this.tsLocs.put(gridIdentifier, new Point2D.Double((gridBox[0].x + gridBox[1].x) / 2.0, (gridBox[1].y + gridBox[2].y) / 2.0));
                p = this.tsLocs.get(gridIdentifier);
            }
            catch (IOException ex) {
                return new Point2D.Double(0.0, 0.0);
            }
        }
        return p;
    }

    public int getTimestepsAvailable() {
        String ncpath = this.getOutputFile(3).getPath();
        int numTimeSteps = 0;
        try {
            NetcdfFile nc = NetcdfFile.open(ncpath);
            Dimension d = nc.findDimension("TIME");
            if (d != null) {
                numTimeSteps = d.getLength();
            }
            nc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return numTimeSteps;
    }

    public void setDefaultParameters() {
        double ats;
        double bts;
        int v = this.getNumberOutputTimesteps();
        this.minimumAmplitude = 0.005;
        this.minimumDepth = 5.0;
        this.dryLandDepth = 0.1;
        this.friction = 9.0E-4;
        this.allowRunup = true;
        this.maxEta = 300.0;
        this.numberTimeStepsStart = 0;
        this.numberStride = 1;
        this.maxAllowedTimestep = -1.0;
        this.timeStep = Math.floor(0.96 * this.getMaxTimeStep() * 100.0) / 100.0;
        try {
            bts = this.getBathyGrid(2).getMaxTimeStep();
            ats = this.getBathyGrid(1).getMaxTimeStep();
        }
        catch (IOException ex) {
            Logger.getLogger(SiteInfo.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        this.numberTimeStepsBGrid = Math.max((int)Math.floor(0.96 * bts / this.timeStep), 1);
        this.numberTimeStepsAGrid = Math.max(this.numberTimeStepsBGrid * (int)Math.floor(0.96 * ats / this.timeStep / (double)this.numberTimeStepsBGrid), 1);
        this.totalNumberTimeStep = 100 * (int)Math.round(28800.0 / this.timeStep / 100.0);
        int m = Math.max(this.numberTimeStepsAGrid, this.numberTimeStepsBGrid);
        this.numberTimeStepsBetweenOutput = m * (int)Math.round(30.0 / this.timeStep / (double)m);
        this.firePropertyChange("numberOutputTimesteps", v, this.getNumberOutputTimesteps());
        this.writeInputFile();
        this.deleteRestart();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public int compareTo(SiteInfo o) {
        return this.siteName.compareTo(o.siteName);
    }

    public static void main(String[] args) {
        try {
            SiteInfo siteInfo = new SiteInfo(new File("/Users/cmoore/ComMIT/scratch/hanalei_haz"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

