/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JWindow;
import javax.swing.Timer;

public class SplashScreen
extends JWindow
implements Runnable {
    private String imageFileName;
    private String cmiVersion;
    private Image image;
    private int x;
    private int y;
    private int width;
    private static int minMillis = 200;
    private static int counter;
    private Timer timer;
    private int height;
    private String infoString = "";
    private boolean paintCalled = false;
    private Shape rrect;

    public SplashScreen(String fileName, String version) {
        super(new Frame());
        this.imageFileName = fileName;
        this.cmiVersion = version;
    }

    @Override
    public void run() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.image = toolkit.getImage(this.getClass().getResource(this.imageFileName));
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        if (this.image == null) {
            return;
        }
        this.width = this.image.getWidth(this);
        this.height = this.image.getHeight(this);
        Dimension screenSize = toolkit.getScreenSize();
        this.x = (screenSize.width - this.width) / 2;
        this.y = (screenSize.height - this.height) / 2;
        int numMonitors = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length;
        if (numMonitors > 1) {
            this.x -= screenSize.width / 4;
        }
        this.setAlwaysOnTop(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SplashScreen.this.setVisible(false);
                SplashScreen.this.dispose();
            }
        });
        this.rrect = new RoundRectangle2D.Double(0.0, 0.0, this.width, this.height, 40.0, 40.0);
        this.setBounds(this.x, this.y, this.width, this.height);
        this.setVisible(true);
        try {
            for (counter = 0; counter <= minMillis; counter += minMillis / 20) {
                Thread.sleep(minMillis / 20);
            }
        }
        catch (InterruptedException ex) {
            return;
        }
    }

    public void close() {
        while (counter < minMillis) {
            try {
                Thread.sleep(minMillis - counter);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    public void setInfoString(String s) {
        this.infoString = s;
        this.repaint();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage(this.image, 0, 0, this);
        g2.setColor(new Color(75, 75, 75));
        g2.setFont(new Font("Lucida Sans", 0, 75));
        g2.drawString(this.cmiVersion, 200, 300);
        g2.setStroke(new BasicStroke(2.0f));
        g2.setColor(Color.WHITE);
        g2.setFont(new Font("Dialog", 1, 14));
        g2.drawString(this.infoString, 70, 448);
    }

    public static void main(String[] args) {
        SplashScreen ss = new SplashScreen("images/splash_lapalma.png", "1.8.6");
        new Thread(ss).start();
    }
}

