/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.SiftShare;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.swing.event.EventListenerList;

public class StreamGobbler
extends Thread {
    InputStream is;
    String type;
    OutputStream os;
    boolean outputOccurred = false;
    EventListenerList listenerList = new EventListenerList();
    String listenString;
    String errorString = "";
    boolean stopRequested = false;

    public StreamGobbler(InputStream is, String type) {
        this(is, type, null);
    }

    public StreamGobbler(InputStream is, String type, OutputStream redirect) {
        this.is = is;
        this.type = type;
        this.os = redirect;
    }

    @Override
    public void run() {
        try {
            PrintWriter pw = null;
            if (this.os != null) {
                pw = new PrintWriter(this.os);
            }
            InputStreamReader isr = new InputStreamReader(this.is);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null && !this.stopRequested) {
                if (pw != null) {
                    pw.println(line);
                    pw.flush();
                }
                this.errorString = line;
                SiftShare.log.finest(this.type + ">" + line);
                this.outputOccurred = true;
            }
            br.close();
            isr.close();
            if (pw != null) {
                pw.flush();
            }
        }
        catch (IOException ioe) {
            SiftShare.log.fine(this.type + "> error in StreamGobbler (runtime process probably terminated)");
        }
    }

    public void requestStop() {
        this.stopRequested = true;
    }

    public void addActionListener(ActionListener l, String s) {
        this.listenerList.add(ActionListener.class, l);
        this.listenString = s;
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed(String s) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                String actionCommand = s;
                e = new ActionEvent(this, 1001, actionCommand);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }
}

