/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import Jama.Matrix;
import Jama.QRDecomposition;
import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.GaugeLine;
import gov.noaa.tsunami.cmi.IndeterminateProgressMonitor;
import gov.noaa.tsunami.cmi.LPfilter;
import gov.noaa.tsunami.cmi.STSPanel;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import gov.noaa.tsunami.cmi.SwingWorker;
import gov.noaa.tsunami.cmi.TideConstituents;
import gov.noaa.tsunami.cmi.TideGaugeDataParser;
import gov.noaa.tsunami.cmi.TideGaugeLocsParserIOC;
import gov.noaa.tsunami.cmi.TideGaugeLocsParserNOS;
import gov.noaa.tsunami.cmi.TideStationMetadata;
import gov.noaa.tsunami.websift.events.SeismicEvent;
import gov.noaa.tsunami.websift.propdb.SourceScenario;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;

public class TideGaugeClient {
    private static Map<String, TideStationMetadata> gaugeLocs = new LinkedHashMap<String, TideStationMetadata>(30);
    private static boolean gaugeLocsParsed = false;
    private static SiftShare parent = null;
    public static final int DETIDE_NONE = 0;
    public static final int DETIDE_HARMONIC = 1;
    public static final int DETIDE_LPFILTER = 2;
    public static int detideType = 1;

    public static void getGaugeLocations(SiftShare ss) {
        parent = ss;
        File gaugeLocsFile = new File(CMIUtil.etcDirName, "allGaugeLocsIOC.xml");
        File gaugeLocsFileNOS = new File(CMIUtil.etcDirName, "allGaugeLocsNOS.xml");
        long now = new Date().getTime();
        if (!gaugeLocsFile.exists() || !gaugeLocsFileNOS.exists() || now - gaugeLocsFile.lastModified() > 1209600000L) {
            SiftShare.log.info("Downloading new tide gauge location files: etc/allGauges[IOC|NOS].xml");
            GaugeLookupWorker gaugeWorker = new GaugeLookupWorker();
            gaugeWorker.start();
        } else {
            SiftShare.log.info("Tide gauge location file: etc/AllGauges[IOC|NOS].xml is recent.");
            TideGaugeClient.parseGaugesLocs();
        }
    }

    private static void parseGaugesLocs() {
        TideGaugeLocsParserNOS tgpNOS = new TideGaugeLocsParserNOS();
        tgpNOS.parseGaugeLocs(gaugeLocs);
        TideGaugeLocsParserIOC tgp = new TideGaugeLocsParserIOC();
        tgp.parseGaugeLocs(gaugeLocs);
        gaugeLocsParsed = true;
    }

    public static boolean getGaugeLocsParsed() {
        return gaugeLocsParsed;
    }

    public static ArrayList<TideStationMetadata> getStationMetadata(BathyGrid bathyGrid) {
        ArrayList<TideStationMetadata> tsm = new ArrayList<TideStationMetadata>();
        boolean foundone = false;
        for (Map.Entry<String, TideStationMetadata> entry : gaugeLocs.entrySet()) {
            double[] lonLat = entry.getValue().getLonLat();
            if (!bathyGrid.contains(lonLat[0], lonLat[1])) continue;
            tsm.add(entry.getValue());
        }
        return tsm;
    }

    private static void getGaugeData(STSPanel tsp, TideStationMetadata tsm, long eventTime) {
        StringBuffer sb = new StringBuffer("");
        switch (tsm.getProvider()) {
            case 1: {
                sb.append("https://opendap.co-ops.nos.noaa.gov/ioos-dif-sos/SOS?service=SOS&request=GetObservation&version=1.0.0");
                sb.append("&observedproperty=water_surface_height_above_reference_datum&offering=urn:ioos:station:NOAA.NOS.CO-OPS:" + tsm.getGaugeID());
                sb.append("&responseFormat=text%2Fcsv&eventTime=");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                sb.append(sdf.format(new Date(eventTime - 57600000L)));
                sb.append("/" + sdf.format(new Date(eventTime + 129600000L)));
                sb.append("&result=VerticalDatum%3D%3Durn:ioos:def:datum:noaa::MHW&dataType=PreliminaryOneMinute");
                SiftShare.log.info("downloading gauge data from url: " + sb.toString());
                sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                GaugeDownloadWorker gdw = new GaugeDownloadWorker(tsp, tsm, sb.toString(), "gaugeNOS" + sdf.format(new Date(eventTime)) + ".csv");
                gdw.start();
                break;
            }
            case 2: {
                sb.append("http://ioc-sealevelmonitoring.org/service.php?query=data&code=" + tsm.getGaugeID());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm", Locale.US);
                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                sb.append("&timestart=" + sdf.format(new Date(eventTime - 57600000L)));
                sb.append("&timestop=" + sdf.format(new Date(eventTime + 129600000L)));
                sb.append("&format=xml");
                SiftShare.log.info("downloading gauge data from url: " + sb.toString());
                sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                GaugeDownloadWorker gdw = new GaugeDownloadWorker(tsp, tsm, sb.toString(), "gaugeIOC" + sdf.format(new Date(eventTime)) + ".xml");
                gdw.start();
            }
        }
    }

    public static void despikeGaugeData(GaugeLine gaLine) {
        double[] times = gaLine.getXArray();
        double[] heights = gaLine.getYArray();
        double mean = TideGaugeClient.getMean(heights);
        double stdev = TideGaugeClient.getStandardDeviation(heights, mean);
        int count = 0;
        for (int i = 0; i < heights.length; ++i) {
            if (!(Math.abs(heights[i] - mean) > 8.0 * stdev)) continue;
            ++count;
            heights[i] = Double.NaN;
        }
        SiftShare.log.info("Mean: " + mean + ", stdev: " + stdev + " number spikes: " + count);
    }

    public static double getStandardDeviation(double[] thisArray, double mean) {
        double sum = 0.0;
        double deviation = 0.0;
        int counter = 0;
        for (int i = 0; i < thisArray.length; ++i) {
            if (Double.isNaN(thisArray[i])) continue;
            sum += (thisArray[i] - mean) * (thisArray[i] - mean);
            ++counter;
        }
        deviation = Math.sqrt(sum / (double)counter);
        return deviation;
    }

    public static double getMean(double[] thisArray) {
        double mean = 0.0;
        double sum = 0.0;
        int counter = 0;
        for (int i = 0; i < thisArray.length; ++i) {
            if (Double.isNaN(thisArray[i])) continue;
            sum += thisArray[i];
            ++counter;
        }
        mean = sum / (double)counter;
        return mean;
    }

    public static HashMap<String, GaugeLine> readGaugeData(STSPanel tsp, TideStationMetadata tsm, long eventTime) {
        GaugeLine testLine = new GaugeLine();
        HashMap<String, GaugeLine> map = new HashMap<String, GaugeLine>();
        switch (tsm.getProvider()) {
            case 1: {
                map = TideGaugeClient.readNOSGaugeData(tsm);
                if (map.size() == 0) {
                    TideGaugeClient.getGaugeData(tsp, tsm, eventTime);
                    break;
                }
                Iterator<GaugeLine> it = map.values().iterator();
                testLine = it.next();
                if (!(testLine.getEndTime() < 35.9)) break;
                TideGaugeClient.getGaugeData(tsp, tsm, eventTime);
                break;
            }
            case 2: {
                map = TideGaugeClient.readIOCGaugeData(tsm);
                if (map.size() == 0) {
                    TideGaugeClient.getGaugeData(tsp, tsm, eventTime);
                    break;
                }
                Iterator<GaugeLine> it = map.values().iterator();
                testLine = it.next();
                if (!(testLine.getEndTime() < 35.9)) break;
                TideGaugeClient.getGaugeData(tsp, tsm, eventTime);
            }
        }
        return map;
    }

    private static HashMap<String, GaugeLine> readIOCGaugeData(TideStationMetadata tsm) {
        TideGaugeDataParser tgp = new TideGaugeDataParser();
        Object times = null;
        Object heights = null;
        File f = null;
        HashMap<String, GaugeLine> gaLines = new HashMap<String, GaugeLine>();
        try {
            SiteInfo site = CMIUtil.currentSiteInfo;
            SourceScenario ss = site.getSourceScenario();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            SeismicEvent se = null;
            long eventTime = 0L;
            if (ss != null && (se = ss.getSeismicEvent()) != null) {
                eventTime = se.getDate();
                SiftShare.log.info("Event info: " + se);
            }
            f = new File(site.getSiteDirectory(), "gaugeIOC" + sdf.format(new Date(eventTime)) + ".xml");
            tgp.parseGaugeData(tsm, f, eventTime);
            gaLines = tgp.getGaugeLines();
        }
        catch (IOException ex) {
            SiftShare.log.warning("IO error reading timeseries: " + ex.getMessage());
        }
        return gaLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, GaugeLine> readNOSGaugeData(TideStationMetadata tsm) {
        double[] times = null;
        double[] heights = null;
        File f = null;
        InputStreamReader fr = null;
        BufferedReader br = null;
        GaugeLine gaLine = null;
        try {
            SiteInfo site = CMIUtil.currentSiteInfo;
            SourceScenario ss = site.getSourceScenario();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            SeismicEvent se = null;
            long eventTime = 0L;
            if (ss != null && (se = ss.getSeismicEvent()) != null) {
                eventTime = se.getDate();
                SiftShare.log.info("Event info: " + se);
            }
            f = new File(site.getSiteDirectory(), "gaugeNOS" + sdf.format(new Date(eventTime)) + ".csv");
            fr = new FileReader(f);
            br = new BufferedReader(fr);
            String inputLine = null;
            inputLine = br.readLine();
            if (inputLine == null) {
                throw new IOException("no content found in gauge file");
            }
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            sdf.setLenient(false);
            LinkedHashMap<Double, Double> gaugeMap = new LinkedHashMap<Double, Double>();
            double hholder = 0.0;
            double tholder = 0.0;
            while ((inputLine = br.readLine()) != null) {
                String[] linearr = inputLine.split(",");
                if (linearr.length <= 4) continue;
                try {
                    tholder = sdf.parse(linearr[4].replaceAll("T", " ").replaceAll("Z", "")).getTime();
                    hholder = Double.parseDouble(linearr[5]);
                    gaugeMap.put(tholder, hholder);
                }
                catch (ParseException pe) {
                    SiftShare.log.log(Level.WARNING, "Parse error parsing time string in gauge file: ", pe);
                }
                catch (NumberFormatException nfe) {
                    SiftShare.log.log(Level.WARNING, "Error parsing tide gauge height: ", nfe);
                }
            }
            if (gaugeMap.size() > 5) {
                times = new double[gaugeMap.size()];
                heights = new double[gaugeMap.size()];
                int i = 0;
                for (Double key : gaugeMap.keySet()) {
                    heights[i] = (Double)gaugeMap.get(key) * 100.0;
                    times[i] = (key - (double)eventTime) / 3600000.0;
                    ++i;
                }
            } else {
                SiftShare.log.warning("No data found in gauge file");
            }
        }
        catch (IOException ex) {
            SiftShare.log.warning("IO error reading timeseries: " + ex.getMessage());
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {}
        }
        HashMap<String, GaugeLine> map = new HashMap<String, GaugeLine>();
        if (times != null && heights != null) {
            gaLine = new GaugeLine();
            gaLine.setData(times, heights);
            gaLine.setFile(f);
            map.put("NOS_" + tsm.getGaugeID() + "_nos", gaLine);
        }
        return map;
    }

    private static void insertNans(GaugeLine gaLine) {
        int i;
        double[] times = gaLine.getXArray();
        double[] heights = gaLine.getYArray();
        if (times.length == 0) {
            return;
        }
        double dt = 100.0;
        for (int i2 = 1; i2 < times.length; ++i2) {
            dt = dt < times[i2] - times[i2 - 1] ? dt : times[i2] - times[i2 - 1];
        }
        ArrayList<Double> timesList = new ArrayList<Double>();
        ArrayList<Double> heightsList = new ArrayList<Double>();
        double current = times[0];
        int count = 0;
        timesList.add(current);
        heightsList.add(heights[0]);
        for (i = 1; i < times.length; ++i) {
            while (times[i] - current > 1.1 * dt) {
                ++count;
                timesList.add(current += dt);
                heightsList.add(Double.NaN);
            }
            current = times[i];
            timesList.add(current);
            heightsList.add(heights[i]);
        }
        times = new double[timesList.size()];
        heights = new double[heightsList.size()];
        for (i = 0; i < timesList.size(); ++i) {
            times[i] = (Double)timesList.get(i);
            heights[i] = (Double)heightsList.get(i);
        }
        SiftShare.log.fine("found " + count + " gaps in tide gauge data, sample interval: " + dt * 60.0 + " minutes");
        gaLine.setData(times, heights);
    }

    public static GaugeLine detideGaugeData(GaugeLine inLine, boolean despike) throws RuntimeException {
        if (inLine == null) {
            return null;
        }
        GaugeLine gaLine = new GaugeLine(inLine);
        switch (detideType) {
            case 1: {
                TideGaugeClient.harmonicDetideGaugeData(gaLine);
                break;
            }
            case 2: {
                TideGaugeClient.lowPassFilterGaugeData(gaLine);
                break;
            }
            case 0: {
                TideGaugeClient.deMeanGaugeData(gaLine);
            }
        }
        if (despike) {
            TideGaugeClient.despikeGaugeData(gaLine);
        }
        TideGaugeClient.insertNans(gaLine);
        return gaLine;
    }

    private static void harmonicDetideGaugeData(GaugeLine gaLine) throws RuntimeException {
        double[] times = gaLine.getXArray();
        double[] heights = gaLine.getYArray();
        int nConst = TideConstituents.values().length;
        Matrix tc = new Matrix(times.length, 2 * nConst + 1);
        Matrix B = new Matrix(heights, 1).transpose();
        for (int i = 0; i < times.length; ++i) {
            tc.set(i, 0, 1.0);
            for (int j = 0; j < nConst; ++j) {
                tc.set(i, j + 1, Math.cos(Math.PI * 2 * times[i] * TideConstituents.values()[j].freq));
                tc.set(i, nConst + j + 1, Math.sin(Math.PI * 2 * times[i] * TideConstituents.values()[j].freq));
            }
        }
        QRDecomposition qrd = new QRDecomposition(tc);
        if (qrd.isFullRank()) {
            int i;
            Matrix X2 = qrd.solve(B);
            double[] x = X2.getColumnPackedCopy();
            double[] pred = tc.times(X2).getRowPackedCopy();
            double[] amp = new double[nConst];
            double[] pha = new double[nConst];
            StringBuffer sb = new StringBuffer();
            sb.append("Const     Freq       A      B      Amplitude      Phase\n");
            for (i = 0; i < nConst; ++i) {
                amp[i] = Math.sqrt(Math.pow(x[i + 1], 2.0) + Math.pow(x[i + nConst + 1], 2.0));
                pha[i] = 180.0 * Math.acos(x[i + 1] / amp[i]) / Math.PI;
                sb.append(TideConstituents.values()[i].name + " " + TideConstituents.values()[i].freq + " " + x[i + 1] + " " + x[i + nConst + 1] + " " + amp[i] + " " + pha[i] + "\n");
            }
            SiftShare.log.fine("\n\nDetide results:\n\n" + sb.toString());
            for (i = 0; i < pred.length; ++i) {
                heights[i] = heights[i] - pred[i];
            }
            gaLine.setData(times, heights);
        } else {
            SiftShare.log.fine("Detding failed: insufficient rank (not enough tide gauge data)");
        }
    }

    private static void lowPassFilterGaugeData(GaugeLine gaLine) throws RuntimeException {
        double[] times = gaLine.getXArray();
        double[] heights = gaLine.getYArray();
        double[] pred = LPfilter.filter(heights, times, 2.0, true);
        for (int i = 0; i < heights.length; ++i) {
            heights[i] = heights[i] - pred[i];
        }
        gaLine.setData(times, heights);
        SiftShare.log.fine("Low PassFiltered gauge data, max: " + gaLine.getMax() + ", min: " + gaLine.getMin());
    }

    private static void deMeanGaugeData(GaugeLine gaLine) {
        double mean = TideGaugeClient.getMean(gaLine.heights);
        double[] h = gaLine.getYArray();
        for (int i = 0; i < h.length; ++i) {
            h[i] = h[i] - mean;
        }
    }

    public static class GaugeDownloadWorker
    extends SwingWorker {
        IndeterminateProgressMonitor pm = null;
        InputStream is = null;
        FileOutputStream fos = null;
        String urlstring;
        String ofilename;
        URL url = null;
        STSPanel tsp = null;
        TideStationMetadata tsm = null;
        HashMap<String, GaugeLine> testLine = new HashMap();

        GaugeDownloadWorker(STSPanel tsp, TideStationMetadata tsm, String urlstring, String ofilename) {
            this.tsp = tsp;
            this.tsm = tsm;
            this.urlstring = urlstring;
            this.ofilename = ofilename;
            if (parent != null) {
                this.pm = new IndeterminateProgressMonitor(parent, "Downloading tide gauge data");
            }
        }

        @Override
        public Object construct() {
            try {
                if (CMIUtil.currentSiteInfo == null) {
                    return null;
                }
                File f = File.createTempFile("downloadGaugeData", "xml");
                File outf = new File(CMIUtil.currentSiteInfo.getSiteDirectory(), this.ofilename);
                this.url = new URL(this.urlstring);
                HttpURLConnection api = (HttpURLConnection)this.url.openConnection();
                this.is = api.getInputStream();
                this.fos = new FileOutputStream(f);
                ReadableByteChannel inch = Channels.newChannel(this.is);
                this.fos.getChannel().transferFrom(inch, 0L, Long.MAX_VALUE);
                this.is.close();
                this.fos.close();
                CMIUtil.copyFile(f, outf);
            }
            catch (IOException ioe) {
                SiftShare.log.log(Level.WARNING, "Error loading tide gauge locations", ioe);
            }
            return null;
        }

        @Override
        public void finished() {
            if (this.pm != null) {
                this.pm.closeMe();
            }
            switch (this.tsm.getProvider()) {
                case 1: {
                    this.testLine = TideGaugeClient.readNOSGaugeData(this.tsm);
                    break;
                }
                case 2: {
                    this.testLine = TideGaugeClient.readIOCGaugeData(this.tsm);
                }
            }
            this.tsp.setGaugeData(this.testLine);
        }
    }

    private static class GaugeLookupWorker
    extends SwingWorker {
        private GaugeLookupWorker() {
        }

        @Override
        public Object construct() {
            InputStream is = null;
            FileOutputStream fos = null;
            File f = null;
            URL url = null;
            HttpURLConnection api = null;
            ReadableByteChannel inch = null;
            try {
                f = File.createTempFile("downloadGauges", "xml");
                url = new URL("http://www.ioc-sealevelmonitoring.org/service.php?query=stationlist&format=xml");
                api = (HttpURLConnection)url.openConnection();
                is = api.getInputStream();
                fos = new FileOutputStream(f);
                inch = Channels.newChannel(is);
                fos.getChannel().transferFrom(inch, 0L, Long.MAX_VALUE);
                is.close();
                fos.close();
                if (f.length() == 0L) {
                    throw new IOException("IOC gauge locs file has zero length!");
                }
                CMIUtil.copyFile(f, new File(CMIUtil.etcDirName, "allGaugeLocsIOC.xml"));
            }
            catch (IOException ioe) {
                SiftShare.log.log(Level.WARNING, "Error loading IOC tide gauge locations", ioe);
            }
            try {
                f = File.createTempFile("downloadGauges", "xml");
                url = new URL("https://opendap.co-ops.nos.noaa.gov/stations/stationsXML.jsp");
                api = (HttpURLConnection)url.openConnection();
                is = api.getInputStream();
                fos = new FileOutputStream(f);
                inch = Channels.newChannel(is);
                fos.getChannel().transferFrom(inch, 0L, Long.MAX_VALUE);
                is.close();
                fos.close();
                if (f.length() == 0L) {
                    throw new IOException("NOS gauge locs file has zero length!");
                }
                CMIUtil.copyFile(f, new File(CMIUtil.etcDirName, "allGaugeLocsNOS.xml"));
            }
            catch (IOException ioe) {
                SiftShare.log.log(Level.WARNING, "Error loading NOS tide gauge locations", ioe);
            }
            return null;
        }

        @Override
        public void finished() {
            TideGaugeClient.parseGaugesLocs();
        }
    }
}

