/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.GaugeLine;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.TideStationMetadata;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TideGaugeDataParser
implements ContentHandler,
ErrorHandler {
    private Map<String, LinkedHashMap<Long, Double>> gaugeMap = new LinkedHashMap<String, LinkedHashMap<Long, Double>>();
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String character_buf;
    private Long time = null;
    private Double height = null;
    private Long eventTime = null;
    private File dataFile = null;
    private TideStationMetadata tsm = null;

    public TideGaugeDataParser() {
        this.sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    protected void parseGaugeData(TideStationMetadata tsm, File f, long etime) throws IOException {
        this.eventTime = etime;
        this.dataFile = f;
        this.tsm = tsm;
        Object gaLine = null;
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setContentHandler(this);
            xmlReader.setErrorHandler(this);
            xmlReader.parse(f.getPath());
        }
        catch (SAXException se) {
            SiftShare.log.log(Level.WARNING, "Error parsing IOC tide gauge data xml file.", se);
        }
    }

    public HashMap<String, GaugeLine> getGaugeLines() {
        HashMap<String, GaugeLine> map = new HashMap<String, GaugeLine>();
        for (Map.Entry<String, LinkedHashMap<Long, Double>> e : this.gaugeMap.entrySet()) {
            map.put("IOC_" + this.tsm.getGaugeID() + "_" + e.getKey(), this.getGaugeLine((Map<Long, Double>)e.getValue()));
        }
        return map;
    }

    private GaugeLine getGaugeLine(Map<Long, Double> gaugeMap) {
        double[] times = new double[gaugeMap.size()];
        double[] heights = new double[gaugeMap.size()];
        int i = 0;
        for (Long key : gaugeMap.keySet()) {
            heights[i] = gaugeMap.get(key) * 100.0;
            times[i] = (double)(key - this.eventTime) / 3600000.0;
            ++i;
        }
        GaugeLine gaLine = new GaugeLine();
        gaLine.setData(times, heights);
        gaLine.setFile(this.dataFile);
        return gaLine;
    }

    @Override
    public void setDocumentLocator(Locator lctr) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String string, String string1) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void startElement(String nameSpaceURI, String localName, String qname, Attributes attrs) throws SAXException {
        this.character_buf = "";
        if (localName.equals("sample")) {
            this.time = null;
            this.height = null;
        }
    }

    @Override
    public void endElement(String nameSpaceURI, String localName, String qname) throws SAXException {
        try {
            if (localName.equals("stime") && this.character_buf.length() > 0) {
                this.time = this.sdf.parse(this.character_buf).getTime();
            }
            if (localName.equals("slevel") && this.character_buf.length() > 0) {
                this.height = new Double(this.character_buf);
            }
        }
        catch (ParseException pe) {
            SiftShare.log.log(Level.WARNING, "Error parsing stime for tide gauge: " + this.character_buf, pe);
        }
        catch (NumberFormatException nfe) {
            SiftShare.log.log(Level.WARNING, "Error parsing slevel for tide gauge: " + this.character_buf, nfe);
        }
        if (localName.equals("sensor")) {
            LinkedHashMap<Long, Double> amap = this.gaugeMap.get(this.character_buf);
            if (amap == null) {
                amap = new LinkedHashMap();
                this.gaugeMap.put(this.character_buf, amap);
            }
            amap.put(this.time, this.height);
        }
        if (localName.equals("data")) {
            LinkedList<Map.Entry<String, LinkedHashMap<Long, Double>>> list = new LinkedList<Map.Entry<String, LinkedHashMap<Long, Double>>>(this.gaugeMap.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<String, LinkedHashMap<Long, Double>>>(){

                @Override
                public int compare(Map.Entry<String, LinkedHashMap<Long, Double>> o1, Map.Entry<String, LinkedHashMap<Long, Double>> o2) {
                    return new Integer(o1.getValue().size()).compareTo(new Integer(o2.getValue().size()));
                }
            });
            this.gaugeMap.clear();
            for (Map.Entry entry : list) {
                this.gaugeMap.put((String)entry.getKey(), (LinkedHashMap<Long, Double>)entry.getValue());
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Number of tide gauge samples:\n");
            for (Map.Entry<String, LinkedHashMap<Long, Double>> e : this.gaugeMap.entrySet()) {
                sb.append("Sensor " + e.getKey() + ", num samples: " + e.getValue().size() + "\n");
            }
            SiftShare.log.info(sb.toString());
        }
        this.character_buf = "";
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        this.character_buf = this.character_buf + String.copyValueOf(chars, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] chars, int i, int i1) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string1) throws SAXException {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        SiftShare.log.log(Level.WARNING, "Error parsing IOC tide gauge data xml file: skipped entity: ", string);
    }

    @Override
    public void warning(SAXParseException saxpe) throws SAXException {
        SiftShare.log.log(Level.WARNING, "Error parsing IOC tide gauge data xml file", saxpe);
    }

    @Override
    public void error(SAXParseException saxpe) throws SAXException {
        SiftShare.log.log(Level.WARNING, "Error parsing IOC tide gauge data xml file", saxpe);
    }

    @Override
    public void fatalError(SAXParseException saxpe) throws SAXException {
        SiftShare.log.log(Level.WARNING, "Error parsing IOC tide gauge data xml file", saxpe);
    }
}

