/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.TideStationMetadata;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TideGaugeLocsParserNOS
implements ContentHandler,
ErrorHandler {
    private Map<String, TideStationMetadata> gaugeLocs;
    private String character_buf;
    private String code = "";
    private String name = "";
    private double lat = 0.0;
    private double lon = 0.0;
    private boolean hasWaterLevel = false;

    protected void parseGaugeLocs(Map<String, TideStationMetadata> locs) {
        this.gaugeLocs = locs;
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setContentHandler(this);
            xmlReader.setErrorHandler(this);
            xmlReader.parse(CMIUtil.etcDirName + File.separator + "allGaugeLocsNOS.xml");
        }
        catch (SAXException se) {
            SiftShare.log.log(Level.WARNING, "Error parsing tide gauge locs xml file.", se);
        }
        catch (IOException ioe) {
            SiftShare.log.log(Level.WARNING, "Error opening tide gauge locs xml file.", ioe);
        }
    }

    @Override
    public void setDocumentLocator(Locator lctr) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String string, String string1) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void startElement(String nameSpaceURI, String localName, String qname, Attributes attrs) throws SAXException {
        this.character_buf = "";
        if (localName.equals("station")) {
            this.code = attrs.getValue("ID");
            this.name = attrs.getValue("name");
            this.hasWaterLevel = false;
        }
        if (localName.equals("parameter") && !this.hasWaterLevel) {
            this.hasWaterLevel = attrs.getValue("name").equals("Water Level");
        }
    }

    @Override
    public void endElement(String nameSpaceURI, String localName, String qname) throws SAXException {
        try {
            if (localName.equals("lat") && this.character_buf.length() > 0) {
                this.lat = Double.parseDouble(this.character_buf);
            }
            if (localName.equals("long") && this.character_buf.length() > 0) {
                this.lon = Double.parseDouble(this.character_buf);
                if (this.lon < 0.0) {
                    this.lon += 360.0;
                }
            }
        }
        catch (NumberFormatException nfe) {
            SiftShare.log.log(Level.WARNING, "Error parsing latitude for gauge code: " + this.code, nfe);
        }
        if (localName.equals("station") && this.hasWaterLevel) {
            this.gaugeLocs.put(this.code, new TideStationMetadata(this.code, this.name, 1, this.lon, this.lat));
        }
        if (localName.equals("stations")) {
            SiftShare.log.info("Number of NOS tide gauge stations: " + this.gaugeLocs.size());
        }
        this.character_buf = "";
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        this.character_buf = this.character_buf + String.copyValueOf(chars, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] chars, int i, int i1) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string1) throws SAXException {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void warning(SAXParseException saxpe) throws SAXException {
    }

    @Override
    public void error(SAXParseException saxpe) throws SAXException {
    }

    @Override
    public void fatalError(SAXParseException saxpe) throws SAXException {
    }
}

