/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.PlainAxis;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.SimpleLine;
import gov.noaa.pmel.sgt.dm.SimplePoint;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.tsunami.cmi.GaugeLine;
import gov.noaa.tsunami.cmi.MOSTLine;
import gov.noaa.tsunami.cmi.ResultGraphicsPanel;
import gov.noaa.tsunami.cmi.SiteInfo;
import gov.noaa.tsunami.cmi.TideGaugeClient;
import gov.noaa.tsunami.cmi.TideStationMetadata;
import gov.noaa.tsunami.websift.events.SeismicEvent;
import gov.noaa.tsunami.websift.propdb.SourceScenario;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class TideGaugeTester
extends JFrame {
    private final MOSTLine tsLine = new MOSTLine();
    private HashMap<String, GaugeLine> gaugeMap = new HashMap();
    private GaugeLine gaLine = new GaugeLine();
    private String sensor = "";
    private boolean despike = false;
    private Map<String, Layer> layers = new LinkedHashMap<String, Layer>();
    private JPane jPane;
    private CartesianGraph graph;
    private LinearTransform xt;
    private LinearTransform yt;
    private PlainAxis xAxis;
    private PlainAxis xAxisTop;
    private PlainAxis yAxis;
    private PlainAxis yAxisRight;
    private SimpleLine zeroLine;
    private LineAttribute gratLA;
    private LineAttribute gaugeLA;
    private SimplePoint tsMarkerPoint;
    private final double xSize = 9.0;
    private final double ySize = 2.1;
    private final DecimalFormat dfxxxxx = new DecimalFormat("0.00000");
    private final DecimalFormat dfxx = new DecimalFormat("0.00");
    private final DecimalFormat dfx = new DecimalFormat("0.0");
    private int detideType = 1;
    private double minTimeRange = 0.0;
    private SiteInfo si;
    private ArrayList<TideStationMetadata> tsm = new ArrayList();
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;

    public TideGaugeTester() {
        this.initComponents();
        this.jPane = new JPane("bathy graph", new Dimension(600, 50));
        this.setUpPane();
        this.jPanel1.add((Component)this.jPane, "Center");
        this.getLayer("tsgauge");
        this.setSize(1500, 600);
        this.addGaugeData();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setDefaultCloseOperation(3);
        this.jPanel1.setLayout(new BorderLayout());
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jPanel1.add((Component)this.jScrollPane1, "Last");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    public void addGaugeData() {
        try {
            SiteInfo si = new SiteInfo("crescent", new File("/Volumes/big/Users/cmoore/ComMIT/scratch/crescent"));
            SeismicEvent se = new SeismicEvent(9.0, 142.373, 38.297);
            se.setTime(2011, 3, 11, 5, 46, 24);
            SourceScenario sourceScenario = new SourceScenario("t649", se, "6.310*ki25a+1.910*ki25b+27.390*ki26a+0.480*ki26b+17.500*ki26y+20.990*ki26z+17.010*ki27a+12.430*ki27z+4.140*ki28z+9.540*ki29a", SourceScenario.Type.DART);
        }
        catch (IOException ex) {
            Logger.getLogger(TideGaugeTester.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void loadGaugeData(SiteInfo si) {
        this.gaugeMap.clear();
        if (si == null) {
            return;
        }
        if (this.gaLine == null) {
            this.gaLine = new GaugeLine();
        }
        this.gaLine.setEmptyData();
        SourceScenario ss = si.getSourceScenario();
        this.sensor = "none";
        if (ss != null) {
            SeismicEvent se = ss.getSeismicEvent();
            this.tsm = si.getTideStationMetadata();
            if (se != null) {
                for (TideStationMetadata tideStationMetadata : this.tsm) {
                }
            }
            if (this.gaugeMap.size() > 0) {
                this.sensor = this.gaugeMap.keySet().iterator().next();
            }
        }
        this.updateData();
    }

    public void updateData() {
        TideGaugeClient.detideType = this.detideType;
        this.gaLine = TideGaugeClient.detideGaugeData(this.gaugeMap.get(this.sensor), this.despike);
        if (this.gaLine != null) {
            this.getCartesianGraph("tsgauge").setData(this.gaLine, this.gaugeLA);
        } else {
            this.getCartesianGraph("tsgauge").setData(new GaugeLine(), this.gaugeLA);
        }
        this.updateAxes();
    }

    public void setUpPane() {
        double xstart = 0.6;
        double xend = 8.9;
        double ystart = 0.5;
        double yend = 1.8;
        int pWidth = 600;
        int pHeight = 50;
        this.jPane.setOpaque(true);
        this.jPane.setLayout(new StackedLayout());
        this.jPane.setOpaque(true);
        this.jPane.setLayout(new StackedLayout());
        SoTRange.Double xrange = (SoTRange.Double)this.tsLine.getXRange();
        SoTRange.Double yrange = (SoTRange.Double)this.tsLine.getYRange();
        this.xt = new LinearTransform(0.6, 8.9, xrange.start, xrange.end);
        this.yt = new LinearTransform(0.5, 1.8, yrange.start, yrange.end);
        this.getLayer("grat");
        this.getLayer("zero");
        this.getLayer("tspt");
        this.getLayer("ts");
        this.getLayer("tsgauge");
        this.xAxis = new PlainAxis();
        this.xAxis.setLabelHeightP(0.16);
        this.xAxis.setLabelFont(ResultGraphicsPanel.AXIS_FONT);
        this.xAxis.setLabelInterval(1);
        String xLabel = "Time since event [hr]";
        SGLabel xtitle = new SGLabel("xlbl", xLabel, new Point2D.Double(0.0, 0.0));
        xtitle.setFont(ResultGraphicsPanel.AXIS_FONT);
        xtitle.setHeightP(0.16);
        this.xAxis.setTitle(xtitle);
        this.xAxisTop = new PlainAxis();
        this.xAxisTop.setNumberSmallTics(0);
        this.xAxisTop.setTicPosition(1);
        this.xAxisTop.setLabelPosition(2);
        this.xAxis.register(this.xAxisTop);
        this.yAxis = new PlainAxis();
        this.yAxis.setLabelHeightP(0.16);
        this.yAxis.setLabelFont(ResultGraphicsPanel.AXIS_FONT);
        this.yAxis.setLabelInterval(1);
        this.yAxisRight = new PlainAxis();
        this.yAxisRight.setNumberSmallTics(0);
        this.yAxisRight.setTicPosition(1);
        this.yAxisRight.setLabelPosition(2);
        this.yAxis.register(this.yAxisRight);
        SGLabel ytitle = new SGLabel("ylbl", "amplitude [cm]", new Point2D.Double(0.0, 0.0));
        ytitle.setFont(ResultGraphicsPanel.AXIS_FONT);
        ytitle.setHeightP(0.16);
        this.yAxis.setTitle(ytitle);
        this.yAxis.setSignificantDigits(1);
        CartesianGraph gaugegraph = this.getCartesianGraph("tsgauge");
        this.gaugeLA = new LineAttribute(2, Color.black);
        this.gaugeLA.setWidth(2.5f);
        gaugegraph.setData(this.gaLine, this.gaugeLA);
        this.graph = this.getCartesianGraph("ts");
        this.graph.addXAxis(this.xAxis);
        this.graph.addXAxis(this.xAxisTop);
        this.graph.addYAxis(this.yAxis);
        this.graph.addYAxis(this.yAxisRight);
        LineAttribute la = new LineAttribute(2, Color.red);
        la.setWidth(2.5f);
        this.graph.setData(this.tsLine, la);
        double[] empty = new double[]{};
        this.zeroLine = new SimpleLine(empty, empty, "CWMzero");
        this.zeroLine.setDynamic(false);
        Collection lc = new Collection();
        lc.add(this.zeroLine);
        la = new LineAttribute(0, Color.black);
        this.getCartesianGraph("zero").setData(lc, la);
        this.tsMarkerPoint = new SimplePoint();
        CartesianGraph gr = this.getCartesianGraph("tspt");
        PointAttribute pta = new PointAttribute(50, Color.RED);
        pta.setMarkHeightP(0.25);
        gr.setData(this.tsMarkerPoint, pta);
        this.gratLA = new LineAttribute(1, Color.GRAY);
        this.gratLA.setWidth(0.1f);
        this.gratLA.setDashArray(new float[]{0.1f, 0.1f});
        this.updateAxes();
    }

    private void updateAxes() {
        SimpleLine sl;
        double[] ylocs;
        int i;
        double span;
        SoTRange.Double xr = (SoTRange.Double)this.tsLine.getXRange();
        double st = Math.min(xr.start, xr.end);
        double end = Math.max(xr.start, xr.end);
        if (this.gaLine == null) {
            this.gaLine = new GaugeLine();
            this.gaLine.setEmptyData();
        }
        if (this.gaLine.hasData()) {
            st -= 1.0;
            end = Math.max(end, 12.0);
        }
        double roundTo = (span = Math.max(end - st, this.minTimeRange)) < 3.0 ? 0.083333333 : (span >= 3.0 && span < 5.0 ? 0.5 : 1.0);
        SoTRange.Double xrange = new SoTRange.Double(Math.floor(st / roundTo) * roundTo, Math.ceil((st + span) / roundTo) * roundTo, 2.0 * roundTo);
        SoTRange.Double yr = (SoTRange.Double)this.tsLine.getYRange();
        SoTRange.Double yrg = (SoTRange.Double)this.gaLine.getYRange();
        span = 2.0 * Math.max(Math.max(Math.abs(yr.end), Math.abs(yr.start)), Math.max(Math.abs(yrg.end), Math.abs(yrg.start)));
        SoTRange.Double yrange = new SoTRange.Double(-1.0, 1.0, 1.0);
        int numSmallTics = 3;
        if (span > 2.0) {
            yrange = new SoTRange.Double(-5.0, 5.0, 5.0);
            numSmallTics = 4;
        }
        if (span > 10.0) {
            yrange = new SoTRange.Double(-10.0, 10.0, 10.0);
            numSmallTics = 4;
        }
        if (span > 25.0) {
            yrange = new SoTRange.Double(-20.0, 20.0, 20.0);
            numSmallTics = 3;
        }
        if (span > 35.0) {
            yrange = new SoTRange.Double(-25.0, 25.0, 25.0);
            numSmallTics = 4;
        }
        if (span > 60.0) {
            yrange = new SoTRange.Double(-50.0, 50.0, 50.0);
            numSmallTics = 4;
        }
        if (span > 90.0) {
            yrange = new SoTRange.Double(-75.0, 75.0, 75.0);
            numSmallTics = 2;
        }
        if (span > 130.0) {
            yrange = new SoTRange.Double(-100.0, 100.0, 100.0);
            numSmallTics = 4;
        }
        if (span > 170.0) {
            yrange = new SoTRange.Double(-150.0, 150.0, 150.0);
            numSmallTics = 2;
        }
        if (span > 225.0) {
            yrange = new SoTRange.Double(-200.0, 200.0, 200.0);
            numSmallTics = 3;
        }
        if (span > 425.0) {
            yrange = new SoTRange.Double(-400.0, 400.0, 400.0);
            numSmallTics = 3;
        }
        if (span > 550.0) {
            yrange = new SoTRange.Double(-500.0, 500.0, 500.0);
            numSmallTics = 4;
        }
        if (span > 1100.0) {
            yrange = new SoTRange.Double(-1000.0, 1000.0, 1000.0);
            numSmallTics = 3;
        }
        if (span > 2100.0) {
            yrange = new SoTRange.Double(-2000.0, 2000.0, 2000.0);
            numSmallTics = 3;
        }
        this.yAxis.setNumberSmallTics(numSmallTics);
        SoTPoint origin = new SoTPoint(xrange.start, yrange.start);
        this.xAxis.setRangeU(xrange);
        this.xAxis.setLocationU(origin);
        this.xAxisTop.setLocationU(new SoTPoint(origin.getX(), yrange.getEnd()));
        this.yAxis.setRangeU(yrange);
        this.yAxis.setLocationU(origin);
        this.yAxisRight.setLocationU(new SoTPoint(xrange.getEnd(), origin.getY()));
        this.xt.setRangeU(xrange);
        this.yt.setRangeU(yrange);
        this.getCartesianGraph("tsgauge").setClip(xrange, yrange);
        this.zeroLine.setXArray(new double[]{xrange.start, xrange.end});
        this.zeroLine.setYArray(new double[]{0.0, 0.0});
        Collection lc = new Collection();
        double interval = yrange.end / (double)(numSmallTics + 1);
        double[] xlocs = new double[]{xrange.start, xrange.end};
        for (i = 0; i < numSmallTics; ++i) {
            ylocs = new double[2];
            ylocs[0] = ylocs[1] = interval * (double)(i + 1);
            sl = new SimpleLine(xlocs, ylocs, "y" + i);
            lc.add(sl);
            ylocs = new double[2];
            ylocs[0] = ylocs[1] = -interval * (double)(i + 1);
            sl = new SimpleLine(xlocs, ylocs, "-y" + i);
            lc.add(sl);
        }
        ylocs = new double[]{yrange.start, yrange.end};
        i = 0;
        while ((double)i < 2.0 * (xrange.end - xrange.start) / xrange.delta - 1.0) {
            xlocs = new double[2];
            xlocs[0] = xlocs[1] = xrange.start + xrange.delta * (double)(i + 1) / 2.0;
            sl = new SimpleLine(xlocs, ylocs, "x" + i);
            lc.add(sl);
            ++i;
        }
        this.getCartesianGraph("grat").setData(lc, this.gratLA);
    }

    protected final Layer getLayer(String layerName) {
        Layer lyr = this.layers.get(layerName);
        if (lyr != null) {
            return lyr;
        }
        lyr = new Layer(layerName, new Dimension2D(9.0, 2.1));
        this.layers.put(layerName, lyr);
        this.jPane.add(lyr);
        CartesianGraph gr = new CartesianGraph(layerName + " graph");
        gr.setXTransform(this.xt);
        gr.setYTransform(this.yt);
        lyr.setGraph(gr);
        return lyr;
    }

    protected final CartesianGraph getCartesianGraph(String layerName) {
        Layer lyr = this.getLayer(layerName);
        return (CartesianGraph)lyr.getGraph();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(TideGaugeTester.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(TideGaugeTester.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(TideGaugeTester.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(TideGaugeTester.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new TideGaugeTester().setVisible(true);
            }
        });
    }
}

