/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

public class TideStationMetadata
implements Comparable<TideStationMetadata> {
    public static final int NOS = 1;
    public static final int IOC = 2;
    private int provider = 0;
    private double[] lonLat = new double[2];
    private String gaugeID = "";
    private String name = "";

    public TideStationMetadata(String gaugeID, String name, int provider, double lon, double lat) {
        this.provider = provider;
        this.gaugeID = gaugeID;
        this.name = name;
        this.lonLat[0] = lon;
        this.lonLat[1] = lat;
    }

    public String getGaugeID() {
        return this.gaugeID;
    }

    public String getName() {
        return this.name;
    }

    public int getProvider() {
        return this.provider;
    }

    public double[] getLonLat() {
        return this.lonLat;
    }

    public String toString() {
        return "ID: " + this.gaugeID + " Name: " + this.name + " Provider: " + (this.provider == 1 ? "NOS" : "IOC") + " lon: " + this.lonLat[0] + " lat: " + this.lonLat[1];
    }

    @Override
    public int compareTo(TideStationMetadata that) {
        if (this.provider < that.getProvider()) {
            return -1;
        }
        if (this.provider > that.getProvider()) {
            return 1;
        }
        return this.gaugeID.compareTo(that.getGaugeID());
    }
}

