/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.Base64Coder;
import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import gov.noaa.tsunami.cmi.TwebClient;
import gov.noaa.tsunami.cmi.UploadDialog;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TsunamicastClient {
    protected final URL apiURL;
    private static final Logger log = Logger.getLogger(UploadDialog.class.getName());
    private static final Map<URL, TsunamicastClient> clients = new HashMap<URL, TsunamicastClient>(4);
    private String authorization = null;
    private String username = null;

    public static TsunamicastClient get(URL url) throws MalformedURLException {
        return TsunamicastClient.get(url, "api/1/");
    }

    public static TsunamicastClient get(URL url, String apiPath) throws MalformedURLException {
        URL u = !url.getPath().endsWith("/") ? new URL(url.toString() + "/") : url;
        TsunamicastClient c = clients.get(new URL(u, apiPath));
        if (c == null) {
            boolean isTweb = u.toString().toLowerCase().indexOf("twe") >= 0 || u.toString().indexOf("8888") > 0;
            c = isTweb ? new TwebClient(u, apiPath) : new TsunamicastClient(u, apiPath);
            clients.put(c.apiURL, c);
        }
        return c;
    }

    public static boolean put(String serviceUrl, String apiPath, TsunamicastClient c) {
        try {
            URL u = new URL(serviceUrl);
            TsunamicastClient newClient = TsunamicastClient.get(u, apiPath);
            newClient.authorization = c.authorization;
            newClient.username = c.username;
            return true;
        }
        catch (MalformedURLException mfe) {
            SiftShare.log.warning(mfe.toString());
            return false;
        }
    }

    protected TsunamicastClient(URL url) throws MalformedURLException {
        this.apiURL = new URL(url, "api/1/");
    }

    protected TsunamicastClient(URL url, String apiPath) throws MalformedURLException {
        this.apiURL = new URL(url, apiPath);
    }

    public void setLogin(String username, char[] password) {
        this.username = username;
        this.authorization = username != null && password != null ? "Basic " + Base64Coder.encode(username + ":" + String.copyValueOf(password)) : null;
    }

    public void requireLogin() throws AuthorizationRequired {
        if (this.username == null || this.authorization == null) {
            throw new AuthorizationRequired();
        }
    }

    public String getLogin() {
        return this.username;
    }

    protected HttpURLConnection setupConnection(URL url, String contentType) throws IOException {
        return this.setupConnection(url, contentType, contentType);
    }

    private HttpURLConnection setupConnection(URL url, String contentType, String acceptType) throws IOException {
        HttpURLConnection api;
        try {
            api = (HttpURLConnection)url.openConnection();
        }
        catch (ClassCastException ex) {
            throw new IOException("Server URL must begin with http: or https:");
        }
        api.addRequestProperty("Content-Type", contentType);
        api.addRequestProperty("Accept", acceptType);
        api.addRequestProperty("User-Agent", "ComMIT/1.8.6");
        if (this.authorization != null) {
            api.addRequestProperty("Authorization", this.authorization);
        }
        return api;
    }

    public String getResourceIndexURI(String resourceName) {
        return String.format("%s%s/", this.apiURL.getPath(), resourceName).replace("//", "/");
    }

    public String getResourceURI(String resourceName, int id) {
        return String.format("%s%s/%d/", this.apiURL.getPath(), resourceName, id).replace("//", "/");
    }

    public InputStream apiGetStream(String urlFragment, Map<String, String> params) throws IOException, AuthorizationRequired, Redirected {
        URL url = new URL(this.apiURL, urlFragment);
        if (params != null) {
            StringBuilder sb = new StringBuilder(url.toString());
            String sep = "";
            if (sb.indexOf("?") < 0) {
                sb.append('?');
            }
            for (Map.Entry<String, String> p : params.entrySet()) {
                sb.append(sep).append(URLEncoder.encode(p.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(p.getValue(), "UTF-8"));
                sep = "&";
            }
            url = new URL(sb.toString());
        }
        SiftShare.log.info(url.toString());
        HttpURLConnection api = this.setupConnection(url, "application/xml");
        this.checkApiResponse(api);
        return api.getInputStream();
    }

    private Document apiGetXML(String urlFragment, Map<String, String> params) throws IOException, AuthorizationRequired, Redirected {
        InputStream stream = this.apiGetStream(urlFragment, params);
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
        }
        catch (ParserConfigurationException ex) {
            log.log(Level.SEVERE, ex.toString(), ex);
            throw new IOException(ex);
        }
        catch (SAXException ex) {
            String s = "Error parsing API response: ";
            log.log(Level.SEVERE, s, ex);
            throw new IOException(s + ex.getMessage());
        }
    }

    protected String readResponse(InputStream responseStream) throws IOException {
        int chars;
        if (responseStream == null) {
            return null;
        }
        BufferedReader inrdr = new BufferedReader(new InputStreamReader(responseStream, "UTF-8"));
        StringBuilder response = new StringBuilder();
        char[] buf = new char[65536];
        while ((chars = inrdr.read(buf)) >= 0) {
            response.append(buf, 0, chars);
        }
        return response.toString();
    }

    protected void checkApiResponse(HttpURLConnection connection) throws AuthorizationRequired, Redirected, IOException {
        int responseCode = connection.getResponseCode();
        if (responseCode == 401 || responseCode == 403) {
            log.log(Level.WARNING, "Authorization requested by remote server");
            throw new AuthorizationRequired();
        }
        if (responseCode == 301) {
            // empty if block
        }
        if (responseCode == 302) {
            Map<String, List<String>> headers = connection.getHeaderFields();
            List<String> location = headers.get("Location");
            throw new Redirected(location.get(0));
        }
        if (responseCode == 304) {
            log.fine("Event List not modified");
        }
        if (responseCode >= 400) {
            InputStream is = connection.getErrorStream();
            if (is == null) {
                is = connection.getInputStream();
            }
            String response = this.readResponse(is);
            log.log(Level.WARNING, "Error response code received: {0}: {1}", new Object[]{responseCode, response});
            throw new IOException(String.format("%s (code %d)", response, responseCode));
        }
        log.log(Level.FINEST, "Successful response code received: {0}", responseCode);
    }

    protected String apiPost(String urlFragment, Map<String, String> params) throws IOException, AuthorizationRequired, Redirected {
        URL url = new URL(this.apiURL, urlFragment);
        try {
            Document outDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element rootElt = outDoc.createElement("object");
            outDoc.appendChild(rootElt);
            for (Map.Entry<String, String> p : params.entrySet()) {
                Element subElt = outDoc.createElement(p.getKey());
                subElt.appendChild(outDoc.createTextNode(p.getValue()));
                rootElt.appendChild(subElt);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(outDoc);
            log.log(Level.INFO, "Sending POST request to {0}", url);
            HttpURLConnection api = this.setupConnection(url, "application/xml");
            api.setDoOutput(true);
            transformer.transform(source, new StreamResult(api.getOutputStream()));
            this.checkApiResponse(api);
            if (api.getResponseCode() == 201) {
                String s = api.getHeaderField("Location");
                if (s == null) {
                    throw new IOException("Expected Location: header from Tsunamicast API not found");
                }
                return new URL(s.trim()).getPath();
            }
            return this.readResponse(api.getInputStream());
        }
        catch (TransformerException ex) {
            throw new IOException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new IOException(ex);
        }
    }

    protected String apiDataPost(String urlFragment, File inFile, String contentType) throws IOException, AuthorizationRequired, Redirected {
        return this.apiDataPost(urlFragment, inFile, contentType, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String apiDataPost(String urlFragment, File inFile, String contentType, String acceptType) throws IOException, AuthorizationRequired, Redirected {
        FileChannel inCh = null;
        Channel outCh = null;
        try {
            inCh = new FileInputStream(inFile).getChannel();
            URL url = new URL(this.apiURL, urlFragment);
            HttpURLConnection api = this.setupConnection(url, contentType, acceptType);
            api.setDoOutput(true);
            outCh = Channels.newChannel(api.getOutputStream());
            inCh.transferTo(0L, inCh.size(), (WritableByteChannel)outCh);
            this.checkApiResponse(api);
            String string = this.readResponse(api.getInputStream());
            return string;
        }
        finally {
            if (inCh != null) {
                inCh.close();
            }
            if (outCh != null) {
                outCh.close();
            }
        }
    }

    public Map<Integer, TsunamicastModelResponse> lookupModel(SiteInfo model) throws IOException, AuthorizationRequired, Redirected {
        HashMap<Integer, TsunamicastModelResponse> responses = new HashMap<Integer, TsunamicastModelResponse>(4);
        String parenturi = null;
        for (int gidx = 3; gidx >= 1; --gidx) {
            BathyGrid grd = model.getBathyGrid(gidx);
            Map<String, String> m = this.gridSearchRequest(grd);
            if (parenturi != null) {
                m.put("parent", parenturi);
            }
            Document rdoc = this.apiGetXML("forecastmodel/", this.gridSearchRequest(grd));
            TsunamicastModelResponse response = new TsunamicastModelResponse(rdoc, m);
            responses.put(gidx, response);
            parenturi = response.parent;
        }
        return responses;
    }

    public void createModels(SiteInfo model, Map<Integer, TsunamicastModelResponse> modeldata, Map<Integer, String> modelNames) throws IOException, AuthorizationRequired, Redirected {
        String parent = null;
        for (int gidx = 1; gidx <= 3; ++gidx) {
            TsunamicastModelResponse mr = modeldata.get(gidx);
            if (mr.resourceuri == null) {
                HashMap<String, String> uploadParams = new HashMap<String, String>();
                uploadParams.putAll(mr.request);
                uploadParams.put("creator", "N");
                uploadParams.put("name", modelNames.get(gidx).trim());
                if (parent != null) {
                    uploadParams.put("parent", parent);
                }
                mr.resourceuri = this.apiPost("forecastmodel/", uploadParams);
            }
            parent = mr.resourceuri;
        }
    }

    public Map<Integer, String> createModelRuns(SiteInfo model, Map<Integer, TsunamicastModelResponse> modeldata) throws IOException, AuthorizationRequired, Redirected {
        String mrUri = null;
        TsunamicastModelResponse mr = null;
        HashMap<String, String> uploadParams = new HashMap<String, String>(4);
        HashMap<Integer, String> runUris = new HashMap<Integer, String>(4);
        String ssID = model.getSourceScenario().getID();
        if (!ssID.startsWith("t")) {
            throw new IOException("Attempting to upload modelrun with non-tweb SourceScenario ID");
        }
        int id = Integer.parseInt(ssID.replaceFirst("t", ""));
        uploadParams.put("inversion", this.getResourceURI("inversion", id));
        this.requireLogin();
        for (int gidx = 1; gidx <= 3; ++gidx) {
            mr = modeldata.get(gidx);
            assert (mr.resourceuri != null);
            uploadParams.put("model", mr.resourceuri);
            mrUri = this.apiPost("modelrun/", uploadParams);
            log.log(Level.INFO, "model run created: {0}", mrUri);
            runUris.put(gidx, mrUri);
        }
        assert ("MOST2".equals(mr.request.get("mostversion")));
        File outf = model.getSiftOutputFile();
        String fileuri = String.format("%s/siftfile/%s", mrUri, outf.getName()).replace("//", "/");
        log.log(Level.FINE, "POST {0} to {1}", new Object[]{outf.getPath(), fileuri});
        this.apiDataPost(fileuri, outf, "application/netcdf");
        return runUris;
    }

    protected Map<String, String> gridSearchRequest(BathyGrid grd) {
        HashMap<String, String> lookupMap = new HashMap<String, String>(8);
        Point2D.Double[] grdbox = grd.getGridBox();
        lookupMap.put("extent", String.format("POLYGON ((%1$f %2$f, %1$f %4$f, %3$f %4$f, %3$f %2$f, %1$f %2$f))", grdbox[0].x, grdbox[0].y, grdbox[2].x, grdbox[2].y));
        lookupMap.put("mostversion", "MOST2");
        lookupMap.put("xresolution", String.valueOf((grd.getMaxLon() - grd.getMinLon()) / (double)grd.getXSize()));
        lookupMap.put("yresolution", String.valueOf((grd.getMaxLat() - grd.getMinLat()) / (double)grd.getYSize()));
        return lookupMap;
    }

    public class TsunamicastModelResponse {
        String parent = null;
        String name = null;
        String resourceuri = null;
        String comment = null;
        String gridfile = null;
        int id = -1;
        Map<String, String> request;

        public TsunamicastModelResponse(String name, Integer id, String resourceUri, String gridFile, String parent, Map<String, String> request) {
            this.name = name;
            this.resourceuri = resourceUri;
            this.gridfile = gridFile;
            this.parent = parent;
            this.request = request;
            if (id != null) {
                this.id = id;
            }
        }

        public TsunamicastModelResponse(Document apiResponse, Map<String, String> request) {
            NodeList nodelist = apiResponse.getElementsByTagName("object");
            Node node = nodelist.item(0);
            this.parent = this.getElement("parent", node);
            this.resourceuri = this.getElement("resource_uri", node);
            try {
                this.id = Integer.valueOf(this.getElement("id", node));
            }
            catch (NumberFormatException ex) {
                this.id = -1;
            }
            this.name = this.getElement("name", node);
            this.gridfile = this.getElement("gridfile", node);
            this.request = request;
        }

        private String getElement(String tag, Node node) {
            try {
                return node.getOwnerDocument().getElementsByTagName(tag).item(0).getTextContent();
            }
            catch (NullPointerException ex) {
                return null;
            }
        }
    }

    public class Redirected
    extends Exception {
        private final String location;

        public Redirected(String newLocation) {
            this.location = newLocation;
        }

        public String getLocation() {
            return this.location;
        }
    }

    public class AuthorizationRequired
    extends Exception {
    }
}

