/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.TsunamicastClient;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;

public class TsunamicastLoginDialog
extends JDialog {
    private final TsunamicastClient client;
    private boolean response = false;
    private JButton cancelButton;
    private JLabel errorLabel;
    private JLabel headerLabel;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JButton okButton;
    private JPasswordField passwordField;
    private JTextField usernameField;

    public TsunamicastLoginDialog(Window parent, TsunamicastClient client) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.client = client;
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.usernameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TsunamicastLoginDialog.this.okButton.setEnabled(TsunamicastLoginDialog.this.usernameField.getText().length() > 0);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TsunamicastLoginDialog.this.okButton.setEnabled(TsunamicastLoginDialog.this.usernameField.getText().length() > 0);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        CMIUtil.installEscapeCloseOperation(this);
    }

    public boolean requestLogin() {
        this.response = false;
        this.setVisible(true);
        this.dispose();
        return this.response;
    }

    private void close(boolean okSelected) {
        this.response = okSelected;
        this.setVisible(false);
    }

    private void initComponents() {
        this.headerLabel = new JLabel();
        this.jLabel2 = new JLabel();
        this.usernameField = new JTextField();
        this.jLabel3 = new JLabel();
        this.passwordField = new JPasswordField();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.errorLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Tweb Login");
        this.setLocationByPlatform(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                TsunamicastLoginDialog.this.formWindowOpened(evt);
            }
        });
        this.headerLabel.setText("Please enter your login and password credentials.");
        this.jLabel2.setLabelFor(this.usernameField);
        this.jLabel2.setText("User login:");
        this.usernameField.setToolTipText("Enter your Tweb username.");
        this.usernameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TsunamicastLoginDialog.this.usernameFieldActionPerformed(evt);
            }
        });
        this.jLabel3.setLabelFor(this.passwordField);
        this.jLabel3.setText("Password:");
        this.passwordField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TsunamicastLoginDialog.this.passwordFieldActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TsunamicastLoginDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TsunamicastLoginDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.errorLabel.setForeground(Color.red);
        this.errorLabel.setText("That username or password is not valid.");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(this.errorLabel).add(this.headerLabel)).add(0, 57, Short.MAX_VALUE)).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(this.jLabel2).add(this.jLabel3)).addPreferredGap(0).add(layout.createParallelGroup(1).add(this.passwordField).add(this.usernameField)))).addContainerGap()).add(2, layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add(this.okButton).addPreferredGap(0).add(this.cancelButton).add(9, 9, 9)))));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.headerLabel, -1, -1, Short.MAX_VALUE).add(18, 18, 18).add(layout.createParallelGroup(3).add(this.jLabel2).add(this.usernameField, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel3).add(this.passwordField, -2, -1, -2)).add(9, 9, 9).add(this.errorLabel).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.okButton).add(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void usernameFieldActionPerformed(ActionEvent evt) {
        this.passwordField.requestFocusInWindow();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.close(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.client.setLogin(this.usernameField.getText(), this.passwordField.getPassword());
        this.close(true);
    }

    private void passwordFieldActionPerformed(ActionEvent evt) {
        if (this.usernameField.getText().length() > 0 && this.passwordField.getPassword().length > 0) {
            this.okButtonActionPerformed(evt);
        }
    }

    private void formWindowOpened(WindowEvent evt) {
        String username = this.client != null ? this.client.getLogin() : null;
        this.errorLabel.setVisible(username != null);
        this.usernameField.setText(username);
        this.okButton.setEnabled(this.usernameField.getText() != null && this.usernameField.getText().length() > 0);
        this.usernameField.requestFocusInWindow();
    }
}

