/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SwingWorker;
import gov.noaa.tsunami.cmi.TsunamicastClient;
import gov.noaa.tsunami.cmi.TsunamicastLoginDialog;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;

public abstract class TsunamicastWorker
extends SwingWorker {
    protected Exception error = null;
    protected boolean authenticationFailure = false;
    protected String redirect = null;
    protected TsunamicastClient client;
    private Window parentWindow = null;

    protected abstract Object contactServer(TsunamicastClient var1) throws IOException, TsunamicastClient.AuthorizationRequired, TsunamicastClient.Redirected;

    public void setParentWindow(Window w) {
        this.parentWindow = w;
    }

    protected void handleSuccess() {
    }

    protected void handleError() {
        String errorMsg;
        String displayMsg = errorMsg = this.error.getMessage();
        if (errorMsg != null && errorMsg.indexOf("html") >= 0) {
            displayMsg = "";
            int lastIdx = errorMsg.lastIndexOf("(");
            if (lastIdx > 0) {
                displayMsg = displayMsg + errorMsg.substring(lastIdx);
            }
            displayMsg = displayMsg + "\nPlease see the log for details.";
        }
        JOptionPane.showMessageDialog(null, "An error occurred connecting to the event server:\n" + displayMsg, "Connection Error", 0);
    }

    protected void handleAuthenticationCancel() {
    }

    protected void requestAuthentication() {
        TsunamicastLoginDialog dlg = new TsunamicastLoginDialog(this.parentWindow, this.client);
        this.authenticationFailure = false;
        this.error = null;
        if (dlg.requestLogin()) {
            this.retry();
        } else {
            this.handleAuthenticationCancel();
        }
    }

    public void handleRedirect() {
        String newLocation = this.redirect;
        String oldLocation = this.client.apiURL.toString();
        int pathIdx = newLocation.indexOf("/ap");
        newLocation = newLocation.substring(0, pathIdx);
        String apiPath = oldLocation.substring(pathIdx);
        CMIUtil.tsunamiCastAddress = newLocation;
        try {
            Preferences prefs = SiftShare.getPreferences();
            prefs.put("TSUNAMICASTSERVER", newLocation);
            prefs.flush();
        }
        catch (Exception ex) {
            SiftShare.log.warning(ex.toString());
        }
        TsunamicastClient.put(newLocation, apiPath, this.client);
        this.redirect = null;
        this.retry();
    }

    @Override
    public void finished() {
        if (this.authenticationFailure) {
            this.requestAuthentication();
        } else if (this.redirect != null) {
            this.handleRedirect();
        } else if (this.error != null) {
            this.handleError();
        } else {
            this.handleSuccess();
        }
    }

    @Override
    public Object construct() {
        try {
            this.client = TsunamicastClient.get(new URL(CMIUtil.tsunamiCastAddress));
            return this.contactServer(this.client);
        }
        catch (TsunamicastClient.AuthorizationRequired ex) {
            this.authenticationFailure = true;
        }
        catch (TsunamicastClient.Redirected ex) {
            this.redirect = ex.getLocation();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            SiftShare.log.log(Level.INFO, "tsunamicast contact error:" + ex, ex);
            this.error = ex;
        }
        return null;
    }
}

