/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.MOSTLine;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import gov.noaa.tsunami.cmi.TsunamicastClient;
import gov.noaa.tsunami.cmi.UploadDialog;
import gov.noaa.tsunami.websift.events.SeismicEvent;
import gov.noaa.tsunami.websift.propdb.SourceScenario;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;

public class TwebClient
extends TsunamicastClient {
    private static final Logger log = Logger.getLogger(UploadDialog.class.getName());

    TwebClient(URL url) throws MalformedURLException {
        super(url);
    }

    TwebClient(URL url, String apiPath) throws MalformedURLException {
        super(url, apiPath);
    }

    protected String apiPostQ(String urlFragment, Map<String, String> params) throws IOException, TsunamicastClient.AuthorizationRequired {
        URL url = new URL(this.apiURL, urlFragment);
        FileChannel inCh = null;
        WritableByteChannel outCh = null;
        try {
            StringBuilder uber = new StringBuilder(url.toString()).append("?");
            String sep = "";
            for (Map.Entry<String, String> p : params.entrySet()) {
                uber.append(sep).append(URLEncoder.encode(p.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(p.getValue(), "UTF-8"));
                sep = "&";
            }
            url = new URL(uber.toString());
            log.log(Level.INFO, "Sending POST request to {0}", url);
            HttpURLConnection api = this.setupConnection(url, "application/xml");
            api.setDoOutput(true);
            inCh = new FileInputStream(new File(CMIUtil.etcDirName, "cmiConsoleLogging.conf")).getChannel();
            outCh = Channels.newChannel(api.getOutputStream());
            inCh.transferTo(0L, inCh.size(), outCh);
            this.checkApiResponse(api);
            if (api.getResponseCode() == 201) {
                String s = api.getHeaderField("Location");
                if (s == null) {
                    throw new IOException("Expected Location: header from Tsunamicast API not found");
                }
                return s.trim();
            }
            return this.readResponse(api.getInputStream());
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    String createGrid(Map<String, String> params) throws IOException, TsunamicastClient.AuthorizationRequired {
        return this.apiPostQ("forecastmodel", params);
    }

    Map<Integer, TsunamicastClient.TsunamicastModelResponse> createModel(SiteInfo model, String modelDescription) throws IOException, TsunamicastClient.AuthorizationRequired {
        this.requireLogin();
        String modelName = CMIUtil.capitalize(model.getName());
        SiftShare.log.info("Model doesn't exist in Tweb for this event, creating Tweb model: " + modelName);
        HashMap<Integer, TsunamicastClient.TsunamicastModelResponse> responses = new HashMap<Integer, TsunamicastClient.TsunamicastModelResponse>();
        String parenturi = null;
        for (int gidx = 1; gidx <= 3; ++gidx) {
            BathyGrid grd = model.getBathyGrid(gidx);
            Map<String, String> m = this.gridSearchRequest(grd);
            m.put("name", CMIUtil.capitalize(model.getName()));
            if (parenturi != null) {
                m.put("parent", parenturi);
            } else {
                m.put("description", modelDescription);
            }
            parenturi = this.createGrid(m);
            String[] parts = parenturi.split("/");
            String code = parts[0];
            TsunamicastClient.TsunamicastModelResponse response = new TsunamicastClient.TsunamicastModelResponse(modelName, Integer.parseInt(parts[parts.length - 1]), parenturi, code, parenturi, m);
            responses.put(gidx, response);
        }
        return responses;
    }

    Object uploadSiftFile(SiteInfo model, Map<Integer, TsunamicastClient.TsunamicastModelResponse> modeldata, String description) throws IOException, TsunamicastClient.AuthorizationRequired, TsunamicastClient.Redirected {
        this.requireLogin();
        SourceScenario ss = model.getSourceScenario();
        SeismicEvent evt = ss.getSeismicEvent();
        String ids = ss.getID();
        if (!ids.startsWith("t")) {
            throw new IOException("Can't upload to Tweb: this event is not in the Tweb system: " + evt.toString());
        }
        String solutionId = ids.replaceFirst("t", "");
        String eventName = evt.getName();
        String modelId = modeldata.get((Object)Integer.valueOf((int)1)).gridfile;
        String mrUri = "upload/" + eventName + "/" + solutionId + "/" + modelId;
        SiftShare.log.info("Uploading SIFT file with url: " + mrUri);
        File outf = new File(model.getSiftOutputFile().getAbsolutePath().replaceAll(".nc", "TS.nc"));
        if (!outf.exists()) {
            TwebClient.addTimeSeriesToOutput(model);
        }
        File newsiftfile = new File(outf.getAbsolutePath().replaceAll(model.getActiveSourceName() + "_", ""));
        Files.copy(outf.toPath(), newsiftfile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        StringBuilder uriBldr = new StringBuilder(mrUri).append("?model=").append(URLEncoder.encode(model.getName(), "UTF-8")).append("&most=").append(URLEncoder.encode("most3_facts_nc_mac_pgi_64_v2376", "UTF-8"));
        if (description != null) {
            uriBldr.append("&description=").append(URLEncoder.encode(description, "UTF-8"));
        }
        String uploadUri = uriBldr.toString();
        log.log(Level.FINE, "POST {0} to {1}", new Object[]{outf.getPath(), uploadUri});
        this.apiDataPost(uploadUri, outf, "application/netcdf", "text/plain");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTimeSeriesToOutput(SiteInfo siteInfo) {
        NetcdfFile nfha = null;
        NetcdfFile nfsift = null;
        NetcdfFileWriteable nfnew = null;
        boolean tsexists = false;
        File siftfile = siteInfo.getSiftOutputFile();
        if (!siftfile.exists()) {
            SiftShare.log.info("Not adding time series to sift.nc file: does not exist.");
            return;
        }
        File newsiftfile = new File(siteInfo.getSiftOutputFile().getAbsolutePath().replaceAll(".nc", "TS.nc"));
        try {
            SiftShare.log.info("Adding time series to sift.nc file: " + siftfile.getCanonicalPath() + " " + newsiftfile.getCanonicalPath());
            nfha = NetcdfFile.open(siteInfo.getOutputFile(3).getCanonicalPath());
            nfsift = NetcdfFile.open(siftfile.getCanonicalPath());
            nfnew = NetcdfFileWriteable.createNew(newsiftfile.getCanonicalPath());
            Variable ts = nfsift.findVariable("ts");
            if (ts == null) {
                Dimension timedim = null;
                List<Dimension> dimlist = nfsift.getDimensions();
                List<Variable> varlist = nfsift.getVariables();
                List<Attribute> attlist = nfsift.getGlobalAttributes();
                for (Dimension d : dimlist) {
                    Dimension d2 = nfnew.addDimension(d.getName(), d.getLength(), d.isShared(), d.isUnlimited(), d.isVariableLength());
                    if (!d2.getName().equals("TIME")) continue;
                    timedim = d2;
                }
                for (Variable v : varlist) {
                    nfnew.addVariable(v.getName(), v.getDataType(), v.getDimensions());
                    List<Attribute> vattlist = v.getAttributes();
                    for (Attribute va : vattlist) {
                        if (va.getDataType().equals((Object)DataType.STRING)) {
                            nfnew.addVariableAttribute(v.getName(), va.getName(), va.getStringValue());
                            continue;
                        }
                        nfnew.addVariableAttribute(v.getName(), va.getName(), va.getNumericValue());
                    }
                }
                for (Attribute a : attlist) {
                    nfnew.addAttribute(null, a);
                }
                Dimension numtsdim = nfnew.addDimension("NUMTS", 1);
                nfnew.addVariable("tslon", DataType.DOUBLE, new Dimension[]{numtsdim});
                nfnew.addVariable("tsi", DataType.INT, new Dimension[]{numtsdim});
                nfnew.addVariableAttribute("tsi", "long_name", "1-based index into longitude");
                nfnew.addVariable("tslat", DataType.DOUBLE, new Dimension[]{numtsdim});
                nfnew.addVariable("tsj", DataType.INT, new Dimension[]{numtsdim});
                nfnew.addVariableAttribute("tsj", "long_name", "1-based index into latitude");
                nfnew.addVariable("tsgrid", DataType.INT, new Dimension[]{numtsdim});
                nfnew.addVariableAttribute("tsgrid", "long_name", "Grid Number");
                nfnew.addVariableAttribute("tsgrid", "units", "(123=ABC)");
                nfnew.addVariable("ts", DataType.FLOAT, new Dimension[]{timedim, numtsdim});
                nfnew.addVariableAttribute("ts", "long_name", "Wave Amplitude");
                nfnew.addVariableAttribute("ts", "units", "CENTIMETERS");
                nfnew.create();
                MOSTLine.LonLatIdx lliC = MOSTLine.findTimeseriesIndices(nfha, siteInfo.getTimeseriesLocation(3));
                SiftShare.log.info("lat/lon index: " + lliC.toString());
                Variable ha = nfha.findVariable("HA");
                int[] ha_shape = ha.getShape();
                ha_shape[2] = 1;
                ha_shape[1] = 1;
                float[] htmp = (float[])ha.read(lliC.idx, ha_shape).copyTo1DJavaArray();
                ArrayFloat.D2 vfd2 = new ArrayFloat.D2(timedim.getLength(), 1);
                for (int i = 0; i < timedim.getLength(); ++i) {
                    if (i >= htmp.length) continue;
                    vfd2.set(i, 0, htmp[i]);
                }
                for (Variable v : varlist) {
                    nfnew.write(v.getName(), v.read());
                }
                nfnew.write("tslon", Array.factory(new double[]{lliC.lon}));
                nfnew.write("tsi", Array.factory(new int[]{lliC.idx[2]}));
                nfnew.write("tslat", Array.factory(new double[]{lliC.lat}));
                nfnew.write("tsj", Array.factory(new int[]{lliC.idx[1]}));
                nfnew.write("tsgrid", Array.factory(new int[]{3}));
                nfnew.write("ts", vfd2);
                nfnew.flush();
            } else {
                Files.copy(siftfile.toPath(), newsiftfile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception ex) {
            SiftShare.log.log(Level.SEVERE, "Error adding time series to <model>_sift.nc file", ex);
        }
        finally {
            if (nfsift != null && nfha != null) {
                try {
                    nfsift.close();
                    nfha.close();
                    nfnew.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getModelLocation(String urlFragment, Map<String, String> params) throws IOException, TsunamicastClient.AuthorizationRequired, TsunamicastClient.Redirected {
        URL url = new URL(this.apiURL, urlFragment);
        if (params != null) {
            StringBuilder sb = new StringBuilder(url.toString());
            String sep = "";
            if (sb.indexOf("?") < 0) {
                sb.append('?');
            }
            for (Map.Entry<String, String> p : params.entrySet()) {
                sb.append(sep).append(URLEncoder.encode(p.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(p.getValue(), "UTF-8"));
                sep = "&";
            }
            url = new URL(sb.toString());
        }
        SiftShare.log.info(url.toString());
        HttpURLConnection api = this.setupConnection(url, "text/html");
        try {
            this.checkApiResponse(api);
        }
        catch (IOException ex) {
            SiftShare.log.info("Exception contacting " + url.toString() + " : " + ex.getMessage());
            return null;
        }
        return api.getHeaderField("Location");
    }

    @Override
    public Map<Integer, TsunamicastClient.TsunamicastModelResponse> lookupModel(SiteInfo model) throws IOException, TsunamicastClient.AuthorizationRequired, TsunamicastClient.Redirected {
        HashMap<Integer, TsunamicastClient.TsunamicastModelResponse> responses = new HashMap<Integer, TsunamicastClient.TsunamicastModelResponse>(4);
        String parenturi = null;
        for (int gidx = 1; gidx <= 3; ++gidx) {
            BathyGrid grd = model.getBathyGrid(gidx);
            Map<String, String> m = this.gridSearchRequest(grd);
            if (parenturi != null) {
                m.put("parent", parenturi);
            }
            String location = this.getModelLocation("forecastmodel/", m);
            String name = null;
            Integer id = null;
            String resourceUri = null;
            String gridFile = null;
            String parent = null;
            if (location != null) {
                String[] locParts = location.split(":");
                name = locParts[0];
                resourceUri = locParts[1];
                String[] parts = resourceUri.split("/");
                int plen = parts.length;
                if (plen == 0) {
                    throw new IOException("Bad location response from tweb");
                }
                gridFile = parts[0];
                if (plen > 1) {
                    id = new Integer(parts[plen - 1]);
                }
                if (plen > 2) {
                    parent = location.substring(0, location.lastIndexOf("/") - 1);
                }
            } else {
                responses.clear();
                break;
            }
            parenturi = resourceUri;
            TsunamicastClient.TsunamicastModelResponse response = new TsunamicastClient.TsunamicastModelResponse(name, id, resourceUri, gridFile, parent, m);
            responses.put(gidx, response);
        }
        return responses;
    }
}

