/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import gov.noaa.tsunami.cmi.SwingWorker;
import gov.noaa.tsunami.cmi.TsunamicastClient;
import gov.noaa.tsunami.cmi.TsunamicastWorker;
import gov.noaa.tsunami.cmi.TwebClient;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class TwebUploadDialog
extends JDialog {
    private static final Logger log = Logger.getLogger(TwebUploadDialog.class.getName());
    private final SiteInfo model;
    private Map<Integer, TsunamicastClient.TsunamicastModelResponse> modeldata = null;
    private SwingWorker activeWorker = null;
    private JTextField cModelNameField;
    private JButton cancelButton;
    private JTextArea descriptionField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JProgressBar progressBar;
    private JButton uploadButton;
    private JLabel uploadModelText;

    public TwebUploadDialog(Frame parent, SiteInfo modelRun) {
        super(parent, true);
        final TwebUploadDialog thisWindow = this;
        this.model = modelRun;
        this.initComponents();
        CMIUtil.installEscapeCloseOperation(this);
        String server = CMIUtil.tsunamiCastAddress;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ModelLookupWorker mlw = new ModelLookupWorker();
                mlw.setParentWindow(thisWindow);
                TwebUploadDialog.this.setProgressBar("Looking up models...");
                mlw.start();
                TwebUploadDialog.this.activeWorker = mlw;
            }
        });
    }

    private void initComponents() {
        this.cancelButton = new JButton();
        this.uploadButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.cModelNameField = new JTextField();
        this.uploadModelText = new JLabel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.descriptionField = new JTextArea();
        this.progressBar = new JProgressBar();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TwebUploadDialog.this.formWindowClosing(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TwebUploadDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.uploadButton.setText("Upload");
        this.uploadButton.setEnabled(false);
        this.uploadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TwebUploadDialog.this.uploadButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Upload model run"));
        this.jPanel1.setName("");
        this.jLabel2.setText("DESCRIPTION:");
        this.jLabel3.setText("NAME:");
        this.uploadModelText.setText("<html>Enter name for the model to create on the TWeb server.<div style=\"font-size: 90%\">This should be the name of the city or other location modeled.</div></html>");
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("(optional)");
        this.jLabel1.setVerticalAlignment(1);
        this.descriptionField.setColumns(20);
        this.descriptionField.setRows(4);
        this.jScrollPane1.setViewportView(this.descriptionField);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(2).add(1, this.uploadModelText).add(1, jPanel1Layout.createSequentialGroup().add(this.jLabel3).addPreferredGap(0).add(this.cModelNameField)).add(1, jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(this.jLabel2).add(jPanel1Layout.createSequentialGroup().add(16, 16, 16).add(this.jLabel1))).add(18, 18, 18).add(this.jScrollPane1, -1, 432, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(this.uploadModelText, -2, 50, -2).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.cModelNameField, -2, -1, -2).add(this.jLabel3)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(6, 6, 6).add(this.jLabel2).addPreferredGap(0).add(this.jLabel1)).add(this.jScrollPane1, -2, 74, -2)).add(16, 16, 16)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.jPanel1, -2, -1, -2).add(0, 0, Short.MAX_VALUE)).add(layout.createSequentialGroup().add(this.progressBar, -2, 222, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.uploadButton).addPreferredGap(1).add(this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add(layout.createParallelGroup(1).add(layout.createParallelGroup(3).add(this.cancelButton).add(this.uploadButton)).add(this.progressBar, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void uploadButtonActionPerformed(ActionEvent evt) {
        this.submitDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void closeDialog() {
        if (this.activeWorker != null) {
            this.activeWorker.cancel();
        }
        this.setVisible(false);
        this.dispose();
    }

    private void submitDialog() {
        if (this.cModelNameField.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, "A model name is required.", "Error", 0);
            return;
        }
        TwebUploadWorker muw = new TwebUploadWorker();
        this.setProgressBar("Uploading models...");
        this.uploadButton.setEnabled(false);
        muw.start();
        this.activeWorker = muw;
    }

    protected void setProgressBar(String text) {
        this.progressBar.setString(text);
        this.progressBar.setStringPainted(text != null);
        this.progressBar.setIndeterminate(text != null);
    }

    private class ModelUploadWorker
    extends TsunamicastWorker {
        private ModelUploadWorker() {
        }

        @Override
        protected Object contactServer(TsunamicastClient tclient) throws IOException, TsunamicastClient.AuthorizationRequired, TsunamicastClient.Redirected {
            HashMap<Integer, String> modelNames = new HashMap<Integer, String>(3);
            modelNames.put(2, TwebUploadDialog.this.descriptionField.getText());
            modelNames.put(3, TwebUploadDialog.this.cModelNameField.getText());
            tclient.createModels(TwebUploadDialog.this.model, TwebUploadDialog.this.modeldata, modelNames);
            return tclient.createModelRuns(TwebUploadDialog.this.model, TwebUploadDialog.this.modeldata);
        }

        @Override
        public void finished() {
            TwebUploadDialog.this.setProgressBar(null);
            if (TwebUploadDialog.this.activeWorker == this) {
                TwebUploadDialog.this.activeWorker = null;
            }
            super.finished();
        }

        @Override
        protected void handleError() {
            TwebUploadDialog.this.closeDialog();
            super.handleError();
        }

        @Override
        protected void handleAuthenticationCancel() {
            TwebUploadDialog.this.closeDialog();
            super.handleAuthenticationCancel();
        }

        @Override
        protected void handleSuccess() {
            TwebUploadDialog.this.closeDialog();
            Object[] options = new Object[]{"Open TWeb", "OK"};
            int n = JOptionPane.showOptionDialog(TwebUploadDialog.this.rootPane, "Model data uploaded successfully.\n\n" + CMIUtil.tsunamiCastAddress, "Data Uploaded", 0, 1, null, options, options[0]);
            if (n == 0) {
                try {
                    Desktop.getDesktop().browse(URI.create(CMIUtil.tsunamiCastAddress));
                }
                catch (IOException ex) {
                    SiftShare.log.log(Level.WARNING, "Couldn't open a browser to tsunamicast", ex);
                }
            }
        }
    }

    private class TwebUploadWorker
    extends ModelUploadWorker {
        private TwebUploadWorker() {
        }

        @Override
        protected Object contactServer(TsunamicastClient tclient) throws IOException, TsunamicastClient.AuthorizationRequired, TsunamicastClient.Redirected {
            TwebClient twclient = (TwebClient)tclient;
            String description = TwebUploadDialog.this.descriptionField.getText();
            if (TwebUploadDialog.this.modeldata.isEmpty()) {
                TwebUploadDialog.this.modeldata = twclient.createModel(TwebUploadDialog.this.model, description);
            }
            return twclient.uploadSiftFile(TwebUploadDialog.this.model, TwebUploadDialog.this.modeldata, description);
        }
    }

    private class ModelLookupWorker
    extends TsunamicastWorker {
        private ModelLookupWorker() {
        }

        @Override
        protected Object contactServer(TsunamicastClient tclient) throws IOException, TsunamicastClient.AuthorizationRequired, TsunamicastClient.Redirected {
            TwebUploadDialog.this.modeldata = tclient.lookupModel(TwebUploadDialog.this.model);
            return TwebUploadDialog.this.modeldata;
        }

        @Override
        public void finished() {
            TwebUploadDialog.this.setProgressBar(null);
            if (TwebUploadDialog.this.activeWorker == this) {
                TwebUploadDialog.this.activeWorker = null;
            }
            super.finished();
        }

        @Override
        protected void handleError() {
            TwebUploadDialog.this.closeDialog();
            super.handleError();
        }

        @Override
        protected void handleAuthenticationCancel() {
            TwebUploadDialog.this.closeDialog();
            super.handleAuthenticationCancel();
        }

        @Override
        protected void handleSuccess() {
            String name = CMIUtil.capitalize(TwebUploadDialog.this.model.getName().replace('_', ' '));
            boolean cExists = this.updateFields((TsunamicastClient.TsunamicastModelResponse)TwebUploadDialog.this.modeldata.get(3), name, TwebUploadDialog.this.cModelNameField);
            if (cExists) {
                TwebUploadDialog.this.uploadModelText.setText("<html>The model run results will be uploaded to the following model on Tweb.<div style=\"font-size: 90%\">Existing model results will be replaced.</div></html>");
            }
            TwebUploadDialog.this.uploadButton.setEnabled(true);
        }

        private boolean updateFields(TsunamicastClient.TsunamicastModelResponse mr, String defaultName, JTextField textfld) {
            if (mr != null && mr.resourceuri != null) {
                textfld.setText(mr.name);
                textfld.setEnabled(false);
            } else {
                textfld.setText(defaultName);
                textfld.setEnabled(true);
            }
            return mr != null && mr.resourceuri != null;
        }
    }
}

