/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import gov.noaa.tsunami.cmi.SwingWorker;
import gov.noaa.tsunami.cmi.TsunamicastClient;
import gov.noaa.tsunami.cmi.TsunamicastWorker;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;

public class UploadDialog
extends JDialog {
    private static final Logger log = Logger.getLogger(UploadDialog.class.getName());
    private final SiteInfo model;
    private Map<Integer, TsunamicastClient.TsunamicastModelResponse> modeldata = null;
    private SwingWorker activeWorker = null;
    private JTextField aModelNameField;
    private JTextField bModelNameField;
    private JTextField cModelNameField;
    private JButton cancelButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JProgressBar progressBar;
    private JButton uploadButton;
    private JLabel uploadModelText;

    public UploadDialog(Frame parent, SiteInfo modelRun) {
        super(parent, true);
        final UploadDialog thisWindow = this;
        this.model = modelRun;
        this.initComponents();
        CMIUtil.installEscapeCloseOperation(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ModelLookupWorker mlw = new ModelLookupWorker();
                mlw.setParentWindow(thisWindow);
                UploadDialog.this.setProgressBar("Looking up models...");
                mlw.start();
                UploadDialog.this.activeWorker = mlw;
            }
        });
        this.cModelNameField.getDocument().addDocumentListener(new DocumentListener(){

            private void update(String s) {
                UploadDialog.this.bModelNameField.setText(String.format("%s (B)", s.trim()));
                UploadDialog.this.aModelNameField.setText(String.format("%s (A)", s.trim()));
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update(UploadDialog.this.cModelNameField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update(UploadDialog.this.cModelNameField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    private void initComponents() {
        this.cancelButton = new JButton();
        this.uploadButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.aModelNameField = new JTextField();
        this.bModelNameField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.cModelNameField = new JTextField();
        this.uploadModelText = new JLabel();
        this.progressBar = new JProgressBar();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                UploadDialog.this.formWindowClosing(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.uploadButton.setText("Upload");
        this.uploadButton.setEnabled(false);
        this.uploadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadDialog.this.uploadButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Upload to models"));
        this.jPanel1.setName("");
        this.jLabel1.setText("A:");
        this.jLabel2.setText("B:");
        this.jLabel3.setText("C:");
        this.uploadModelText.setText("<html>Enter names for the models to create on the Tsunamicast server.<div style=\"font-size: 90%\">This should be the name of the city or other location modeled.</div></html>");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(2).add(1, this.uploadModelText, -1, 514, Short.MAX_VALUE).add(1, jPanel1Layout.createParallelGroup(2, false).add(1, jPanel1Layout.createSequentialGroup().add(this.jLabel1).addPreferredGap(0).add(this.aModelNameField)).add(1, jPanel1Layout.createSequentialGroup().add(this.jLabel2).addPreferredGap(0).add(this.bModelNameField)).add(1, jPanel1Layout.createSequentialGroup().add(this.jLabel3).addPreferredGap(0).add(this.cModelNameField, -1, 491, Short.MAX_VALUE)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(this.uploadModelText, -2, 50, -2).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.cModelNameField, -2, -1, -2).add(this.jLabel3)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel2).add(this.bModelNameField, -2, -1, -2)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel1).add(this.aModelNameField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jPanel1, -1, -1, Short.MAX_VALUE).add(layout.createSequentialGroup().add(this.progressBar, -2, 222, -2).addPreferredGap(0, 170, Short.MAX_VALUE).add(this.uploadButton).addPreferredGap(1).add(this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add(layout.createParallelGroup(1).add(layout.createParallelGroup(3).add(this.cancelButton).add(this.uploadButton)).add(this.progressBar, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void uploadButtonActionPerformed(ActionEvent evt) {
        this.submitDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void closeDialog() {
        if (this.activeWorker != null) {
            this.activeWorker.cancel();
        }
        this.setVisible(false);
        this.dispose();
    }

    private void submitDialog() {
        if (this.aModelNameField.getText().length() == 0 || this.bModelNameField.getText().length() == 0 || this.cModelNameField.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, "A model name is required.", "Error", 0);
            return;
        }
        ModelUploadWorker muw = new ModelUploadWorker();
        this.setProgressBar("Uploading models...");
        this.uploadButton.setEnabled(false);
        muw.start();
        this.activeWorker = muw;
    }

    protected void setProgressBar(String text) {
        this.progressBar.setString(text);
        this.progressBar.setStringPainted(text != null);
        this.progressBar.setIndeterminate(text != null);
    }

    private class ModelUploadWorker
    extends TsunamicastWorker {
        private ModelUploadWorker() {
        }

        @Override
        protected Object contactServer(TsunamicastClient tclient) throws IOException, TsunamicastClient.AuthorizationRequired, TsunamicastClient.Redirected {
            HashMap<Integer, String> modelNames = new HashMap<Integer, String>(3);
            modelNames.put(1, UploadDialog.this.aModelNameField.getText());
            modelNames.put(2, UploadDialog.this.bModelNameField.getText());
            modelNames.put(3, UploadDialog.this.cModelNameField.getText());
            tclient.createModels(UploadDialog.this.model, UploadDialog.this.modeldata, modelNames);
            return tclient.createModelRuns(UploadDialog.this.model, UploadDialog.this.modeldata);
        }

        @Override
        public void finished() {
            UploadDialog.this.setProgressBar(null);
            if (UploadDialog.this.activeWorker == this) {
                UploadDialog.this.activeWorker = null;
            }
            super.finished();
        }

        @Override
        protected void handleError() {
            UploadDialog.this.closeDialog();
            super.handleError();
        }

        @Override
        protected void handleAuthenticationCancel() {
            UploadDialog.this.closeDialog();
            super.handleAuthenticationCancel();
        }

        @Override
        protected void handleSuccess() {
            UploadDialog.this.closeDialog();
            Object[] options = new Object[]{"Open TsunamiCast", "OK"};
            int n = JOptionPane.showOptionDialog(UploadDialog.this.rootPane, "Model data uploaded successfully.\n\n" + CMIUtil.tsunamiCastAddress, "Data Uploaded", 0, 1, null, options, options[0]);
            if (n == 0) {
                try {
                    Desktop.getDesktop().browse(URI.create(CMIUtil.tsunamiCastAddress));
                }
                catch (IOException ex) {
                    SiftShare.log.log(Level.WARNING, "Couldn't open a browser to tsunamicast", ex);
                }
            }
        }
    }

    private class ModelLookupWorker
    extends TsunamicastWorker {
        private ModelLookupWorker() {
        }

        @Override
        protected Object contactServer(TsunamicastClient tclient) throws IOException, TsunamicastClient.AuthorizationRequired, TsunamicastClient.Redirected {
            UploadDialog.this.modeldata = tclient.lookupModel(UploadDialog.this.model);
            return UploadDialog.this.modeldata;
        }

        @Override
        public void finished() {
            UploadDialog.this.setProgressBar(null);
            if (UploadDialog.this.activeWorker == this) {
                UploadDialog.this.activeWorker = null;
            }
            super.finished();
        }

        @Override
        protected void handleError() {
            UploadDialog.this.closeDialog();
            super.handleError();
        }

        @Override
        protected void handleAuthenticationCancel() {
            UploadDialog.this.closeDialog();
            super.handleAuthenticationCancel();
        }

        @Override
        protected void handleSuccess() {
            String name = CMIUtil.capitalize(UploadDialog.this.model.getName().replace('_', ' '));
            boolean cExists = this.updateFields((TsunamicastClient.TsunamicastModelResponse)UploadDialog.this.modeldata.get(3), name, UploadDialog.this.cModelNameField);
            boolean bExists = this.updateFields((TsunamicastClient.TsunamicastModelResponse)UploadDialog.this.modeldata.get(2), String.format("%s (B)", name), UploadDialog.this.bModelNameField);
            boolean aExists = this.updateFields((TsunamicastClient.TsunamicastModelResponse)UploadDialog.this.modeldata.get(1), String.format("%s (A)", name), UploadDialog.this.aModelNameField);
            if (cExists && bExists && aExists) {
                UploadDialog.this.uploadModelText.setText("<html>The model run results will be uploaded to the following model sites on Tsunamicast.<div style=\"font-size: 90%\">Existing model results will be replaced.</div></html>");
            }
            UploadDialog.this.uploadButton.setEnabled(true);
        }

        private boolean updateFields(TsunamicastClient.TsunamicastModelResponse mr, String defaultName, JTextField textfld) {
            if (mr.resourceuri != null) {
                textfld.setText(mr.name);
                textfld.setEnabled(false);
            } else {
                textfld.setText(defaultName);
                textfld.setEnabled(true);
            }
            return mr.resourceuri != null;
        }
    }
}

