/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;

public class tt {
    private static String history = "";
    private static SimpleDateFormat histDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z: ");

    public static boolean calcTT(String filename) {
        boolean success = false;
        try {
            NetcdfFile ncfile = NetcdfFile.open(filename);
            Variable lonVar = tt.findVar(ncfile, "lon");
            if (lonVar == null) {
                throw new IOException("Can't find longitude variable");
            }
            double[] lons = (double[])((ArrayDouble.D1)lonVar.read()).copyTo1DJavaArray();
            Variable latVar = tt.findVar(ncfile, "lat");
            if (latVar == null) {
                throw new IOException("Can't find latitude variable");
            }
            double[] lats = (double[])((ArrayDouble.D1)latVar.read()).copyTo1DJavaArray();
            Variable var = tt.findVar(ncfile, "time");
            if (var == null) {
                throw new IOException("Can't find time variable");
            }
            double[] times = (double[])((ArrayDouble.D1)var.read()).copyTo1DJavaArray();
            var = tt.findVar(ncfile, "ha");
            ArrayFloat.D3 vfd3 = (ArrayFloat.D3)var.read();
            int[] shape = vfd3.getShape();
            int jsize = shape[1];
            int isize = shape[2];
            shape[1] = 1;
            shape[2] = 1;
            int[] origin = new int[vfd3.getRank()];
            ArrayFloat.D2 marrayTT = new ArrayFloat.D2(jsize, isize);
            for (int j = 0; j < jsize; ++j) {
                block3: for (int i = 0; i < isize; ++i) {
                    marrayTT.set(j, i, -1.0E34f);
                    origin[1] = j;
                    origin[2] = i;
                    ArrayFloat.D1 tsarr = (ArrayFloat.D1)vfd3.section(origin, shape);
                    double tsmax = 0.05 * MAMath.getMaximum(tsarr);
                    if (tsmax < 0.001) continue;
                    for (int tind = 0; tind < times.length; ++tind) {
                        if (!((double)tsarr.get(tind) > tsmax)) continue;
                        marrayTT.set(j, i, (float)times[tind] / 3600.0f);
                        continue block3;
                    }
                }
            }
            File ofile = new File(filename.replaceAll("ha.nc", "tt.nc"));
            System.out.println("Found MOST model output file: " + filename);
            System.out.println("Creating travel time file: " + ofile.getCanonicalPath());
            ofile.delete();
            success = tt.createOutputFile(ofile, lons, lats, marrayTT);
            ncfile.close();
        }
        catch (IOException | InvalidRangeException ioe) {
            System.err.println("Can't read file: " + filename);
            ioe.printStackTrace();
        }
        return success;
    }

    private static boolean createOutputFile(File ofile, double[] lons, double[] lats, ArrayFloat.D2 ttArray) {
        boolean result = false;
        try {
            NetcdfFileWriter ncout = NetcdfFileWriter.createNew(NetcdfFileWriter.Version.netcdf3, ofile.getPath());
            Dimension londim = ncout.addDimension(null, "lon", lons.length);
            Dimension latdim = ncout.addDimension(null, "lat", lats.length);
            Variable lonvar = ncout.addVariable(null, "lon", DataType.DOUBLE, Arrays.asList(londim));
            ncout.addVariableAttribute(lonvar, new Attribute("long_name", "longitude"));
            ncout.addVariableAttribute(lonvar, new Attribute("units", "degrees_east"));
            Variable latvar = ncout.addVariable(null, "lat", DataType.DOUBLE, Arrays.asList(latdim));
            ncout.addVariableAttribute(latvar, new Attribute("long_name", "latitude"));
            ncout.addVariableAttribute(latvar, new Attribute("units", "degrees_north"));
            ArrayList<Dimension> dimList = new ArrayList<Dimension>();
            Variable crVar = ncout.addVariable(null, "crs", DataType.INT, dimList);
            crVar.addAttribute(new Attribute("grid_mapping_name", "latitude_longitude"));
            crVar.addAttribute(new Attribute("longitude_of_prime_meridian", 0.0));
            crVar.addAttribute(new Attribute("semi_major_axis", 6378137.0));
            crVar.addAttribute(new Attribute("inverse_flattening", 298.257223563));
            crVar.addAttribute(new Attribute("crs_wkt", "GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]"));
            crVar.addAttribute(new Attribute("spatial_ref", "GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]"));
            ArrayList<Dimension> dims2 = new ArrayList<Dimension>();
            dims2.add(latdim);
            dims2.add(londim);
            Variable ttimeVar = ncout.addVariable(null, "travel_time", DataType.FLOAT, dims2);
            ncout.addVariableAttribute(ttimeVar, new Attribute("long_name", "Travel Time"));
            ncout.addVariableAttribute(ttimeVar, new Attribute("units", "hours"));
            ncout.addVariableAttribute(ttimeVar, new Attribute("grid_mapping", "crs"));
            ncout.addVariableAttribute(ttimeVar, new Attribute("_FillValue", Float.valueOf(-1.0E34f)));
            ncout.addVariableAttribute(ttimeVar, new Attribute("missing_value", Float.valueOf(-1.0E34f)));
            ncout.addGroupAttribute(null, new Attribute("history", history));
            ncout.create();
            ncout.write(lonvar, Array.factory(lons));
            ncout.write(latvar, Array.factory(lats));
            ncout.write(ttimeVar, ttArray);
            ncout.close();
            result = true;
        }
        catch (IOException | InvalidRangeException ioe) {
            System.err.println("Can't create output file: " + ofile.getPath());
            ioe.printStackTrace();
        }
        return result;
    }

    private static Variable findVar(NetcdfFile ncfile, String varName) {
        Variable rv = ncfile.findVariable(varName);
        if (rv != null) {
            return rv;
        }
        for (Variable v : ncfile.getVariables()) {
            if (!v.getShortName().equalsIgnoreCase(varName)) continue;
            return v;
        }
        return rv;
    }

    public static void usage() {
        System.err.println("traveltime: takes MOST ha file and produces arrival time file.");
        System.err.println("Usage:");
        System.err.println("java -jar traveltime.jar <MOST_file_ha.nc>");
        System.err.println("produces file <MOST_file_tt.nc> with same lat/lon");
        System.err.println("plus variable travel_time in units of [hours], appropriate for contouring");
        System.err.println("Note: based on simple/crude threshold algorithm.");
    }

    private static void createAndShowGUI() {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            tt.calcTT(fc.getSelectedFile().getPath());
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIManager.put("swing.boldMetal", Boolean.FALSE);
                tt.createAndShowGUI();
            }
        });
    }
}

