/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmt;

import gov.noaa.tsunami.cmt.seismic.Tensor;
import gov.noaa.tsunami.cmt.view.BeachBallView;
import gov.noaa.tsunami.cmt.view.Canvas;
import gov.noaa.tsunami.cmt.view.Options;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class SimpleExample {
    public static void main(String[] args) {
        Options options = Options.defaults();
        Tensor tensor = Tensor.fromStrikeDipRake(300.0, 10.0, 90.0, 7.5);
        options = options.withFillColor(Color.BLACK).withLineColor(Color.BLACK).withLabelAxes(false).withLabelPlanes(false).withPlotPlanes(false).withPlotAxes(false).withSize(40);
        SimpleExample.runWithOptions(tensor, options);
    }

    private static void runWithOptions(Tensor t, Options o) {
        BeachBallView bbv = new BeachBallView(o);
        BufferedImage bi = new BufferedImage(50, 50, 2);
        Graphics2D g2 = bi.createGraphics();
        Canvas canvas = new Canvas(g2);
        bbv.render(canvas, t);
        JFrame frame1 = new JFrame();
        frame1.add(new JLabel(new ImageIcon(bi)));
        frame1.setDefaultCloseOperation(3);
        frame1.pack();
        frame1.setVisible(true);
    }
}

